/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.util.DBUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

class SituacaoRequisicao {
    private static final int LANCADO = 0;
    private static final int CONFERIDO = 1;
    private static final int IMPRESSO = 2;
    private static final int MAPA = 3;
    private static final int SITUACAO = 4;
    Object[][] datas = new Object[0][];
    boolean destinoNaoImprimir;
    boolean saldoDevedor;
    boolean deveGuia;

    public SituacaoRequisicao(String codigoFilial, String codigoRequisicao) {
        this.carregarRequisicao(codigoFilial, codigoRequisicao);
    }

    public boolean existe() {
        return this.datas.length > 0;
    }

    public boolean todosConferidos() {
        for (Object[] data : this.datas) {
            if (data[1] != null || data[4].toString().equalsIgnoreCase("A")) continue;
            return false;
        }
        return true;
    }

    public boolean todosLancados() {
        for (Object[] data : this.datas) {
            if (data[0] != null || data[4].toString().equalsIgnoreCase("A") && data[4].toString().equalsIgnoreCase("O")) continue;
            return false;
        }
        return true;
    }

    public boolean contemLancado() {
        for (Object[] data : this.datas) {
            if (data[0] == null || data[4].toString().equalsIgnoreCase("O")) continue;
            return true;
        }
        return false;
    }

    public boolean todosLaudosImpressos() {
        for (Object[] data : this.datas) {
            if (data[2] != null || data[4].toString().equalsIgnoreCase("A")) continue;
            return false;
        }
        return true;
    }

    public boolean contemLaudoImpresso() {
        for (Object[] data : this.datas) {
            if (data[2] == null) continue;
            return true;
        }
        return false;
    }

    public boolean todosMapasImpressos() {
        for (Object[] data : this.datas) {
            if (data[3] != null) continue;
            return false;
        }
        return true;
    }

    public boolean contemMapaImpresso() {
        for (Object[] data : this.datas) {
            if (data[3] == null) continue;
            return true;
        }
        return false;
    }

    public boolean destinoNaoImprimir() {
        return this.destinoNaoImprimir;
    }

    public boolean saldoDevedor() {
        return this.saldoDevedor;
    }

    public boolean isDeveGuia() {
        return this.deveGuia;
    }

    private void carregarRequisicao(String codigoFilial, String codigoRequisicao) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                ArrayList<Object[]> array = new ArrayList<Object[]>();
                StringBuilder bui = new StringBuilder("select ");
                bui.append(" (a.req_total - a.req_totpago > 0 ) as devedor, ");
                bui.append(" a.req_deveguia = true as deveguia, ");
                bui.append(" b.des_naoimprimir, ");
                bui.append(" c.exr_datadigita, c.exr_dataassina, c.exr_dataimpresso, c.exr_datamapa, c.exr_situacao ");
                bui.append(" from requisicao a ");
                bui.append(" left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
                bui.append(" left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
                bui.append(" where ");
                bui.append(" a.fil_codigo = ").append(codigoFilial);
                bui.append(" and a.req_codigo = ").append(codigoRequisicao);
                bui.append(" and a.req_excluida = false and c.exr_excluido = false ");
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                if (res.next()) {
                    this.destinoNaoImprimir = res.getBoolean("des_naoimprimir");
                    this.saldoDevedor = res.getBoolean("devedor");
                    this.deveGuia = res.getBoolean("deveguia");
                    do {
                        array.add(new Object[]{res.getObject("exr_datadigita"), res.getObject("exr_dataassina"), res.getObject("exr_dataimpresso"), res.getObject("exr_datamapa"), DBUtil.campoNull(res.getString("exr_situacao")) ? "" : res.getObject("exr_situacao")});
                    } while (res.next());
                }
                this.datas = (Object[][])array.toArray((T[])new Object[array.size()][]);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SituacaoRequisicao: 176");
            }
        }
    }
}

