/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import br.com.thread.openpdf.text.DocumentException;
import br.com.thread.openpdf.text.pdf.PdfReader;
import br.com.thread.pdfbox.io.MemoryUsageSetting;
import br.com.thread.pdfbox.multipdf.PDFMergerUtility;
import br.com.thread.pdfbox.pdmodel.PDDocument;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.ConfiguradorResultadoTexto;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.CodigoBarrasDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.DadosDigitacao;
import jalis.laboratorio.digitacao.componente.ExpressaoDigitacao;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.texto.CampoDetalhe;
import jalis.laboratorio.exportacao.texto.CampoValor;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.impressao.componente.CodigoQRCodeImpressao;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.impressao.componente.FormaImpressao;
import jalis.laboratorio.impressao.componente.GraficoImpressao;
import jalis.laboratorio.impressao.componente.ImagemImpressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.resultados.CertificadoHabilitadoAssinar;
import jalis.laboratorio.resultados.assinaturadigital.AssinaturaDigitalPDF;
import jalis.laboratorio.resultados.assinaturadigital.DadosAssinaturaDigitalDTO;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLUtil;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultadosUtil {
    private static final int LARGURA_PADRAO_ASSINATURA_DIGITAL = 190;
    private static final int ALTURA_PADRAO_ASSINATURA_DIGITAL = 70;
    private static String CODIFICACAO = "ISO-8859-1";

    public static String geraResultadoTextoParaWeb(Statement st, String filial, String codigoConvenio, String codigoDestino, int idade, String tipoIdade, String exame, int codigoMaterial, String codigoMetodo, String resultado) throws Exception {
        String layout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino);
        return ResultadosUtil.geraResultadoTextoParaWeb(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, resultado, st);
    }

    public static String geraResultadoTextoParaWeb(Statement st, String filial, String codigoConvenio, String codigoDestino, int idade, String tipoIdade, String exame, int codigoMaterial, String codigoMetodo, String resultado, int layoutPadrao) {
        String layout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st, layoutPadrao);
        return ResultadosUtil.geraResultadoTextoParaWeb(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, resultado, st);
    }

    public static String geraResultadoTextoParaWeb(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, String codigoMetodo, String resultado, Statement st) {
        String linhas = ExameUtil.pegaRelacionamentoExportaTextoIdade(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, st);
        return ResultadosUtil.geraResultadoTextoParaWeb(resultado, linhas);
    }

    public static String geraResultadoTextoParaWeb(String resultado, String formatoTexto) {
        StringBuilder retorno = new StringBuilder("");
        if (!Funcoes.textoVazio(resultado) && !Funcoes.textoVazio(formatoTexto)) {
            Map<String, Object> h = Resultado.getCamposResultadoParaTexto(resultado);
            List<CampoValor> lista = ConfiguradorResultadoTexto.getListaRelacionamentoCampos(formatoTexto);
            if (h != null && lista != null) {
                for (CampoValor c : lista) {
                    if (h.get(c.getCampo().toLowerCase()) == null) continue;
                    String valorExame = h.get(c.getCampo().toLowerCase()).toString();
                    CampoValor exameExportado = c;
                    for (CampoDetalhe d : exameExportado.getDetalhes()) {
                        if (!d.getValor().equalsIgnoreCase(valorExame)) continue;
                        valorExame = d.getTroca();
                        break;
                    }
                    if (retorno.length() > 0) {
                        retorno.append("<br>");
                    }
                    retorno.append(StringUtil.tratarEntidadesHTML(exameExportado.getValor(), true));
                    retorno.append(" ");
                    retorno.append(StringUtil.tratarEntidadesHTML(valorExame, true));
                }
            }
        }
        return retorno.toString().endsWith("<br>") ? retorno.toString().substring(0, retorno.toString().length() - 4) : retorno.toString();
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        Map<String, Object> retorno = null;
        StringBuilder bui = new StringBuilder();
        bui.append("select ert_resultado from examerequisicaoresultado ");
        bui.append("where ");
        bui.append("fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bui.append(" and mco_codigo = ").append(material);
        ResultSet rs = st.executeQuery(bui.toString());
        String resultado = "";
        if (rs.next()) {
            resultado = rs.getString("ert_resultado");
        }
        rs.close();
        if (!Funcoes.textoVazio(resultado)) {
            if (resultado.contains("<laudo>")) {
                resultado = StringUtil.getValor(resultado, "exame");
            }
            retorno = ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, exame, material, resultado, false, -1, true, null);
        }
        return retorno;
    }

    public static boolean possuiResultadoPdfDb(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append(" select ert_resultadopdf from examerequisicaoresultado where ");
        bui.append(" fil_codigo = ").append(!Funcoes.textoVazio(filial) ? filial : Variaveis.filialPadrao);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bui.append(" and mco_codigo = ").append(material);
        bui.append(" and (ert_resultadopdf is not null or ert_resultadopdf <> '') ");
        ResultSet rs = st.executeQuery(bui.toString());
        return rs.next();
    }

    public static String geraResultadoPDfDB(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        String resultadoPDF = "";
        StringBuilder bui = new StringBuilder();
        bui.append(" select ert_resultadopdf from examerequisicaoresultado where ");
        bui.append(" fil_codigo = ").append(!Funcoes.textoVazio(filial) ? filial : Variaveis.filialPadrao);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bui.append(" and mco_codigo = ").append(material);
        ResultSet rs = st.executeQuery(bui.toString());
        if (rs.next()) {
            resultadoPDF = rs.getString("ert_resultadopdf");
        }
        rs.close();
        return resultadoPDF;
    }

    public static String geraResultadoPDF(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        String resultadoPDF = "";
        StringBuilder bui = new StringBuilder();
        bui.append(" select ert_resultadopdf from examerequisicaoresultado err ");
        bui.append(" join examerequisicao er on er.fil_codigo = err.fil_codigo and er.req_codigo = err.req_codigo and er.exa_codigo = err.exa_codigo and er.mco_codigo = err.mco_codigo ");
        bui.append(" where err.fil_codigo = ").append(!Funcoes.textoVazio(filial) ? filial : Variaveis.filialPadrao);
        bui.append(" and err.req_codigo = ").append(requisicao);
        bui.append(" and err.exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bui.append(" and err.mco_codigo = ").append(material);
        bui.append(" and er.exr_situacao in ('").append("C").append("', '").append("I").append("', '").append("E").append("' )");
        ResultSet rs = st.executeQuery(bui.toString());
        if (rs.next()) {
            resultadoPDF = rs.getString("ert_resultadopdf");
        }
        rs.close();
        return resultadoPDF;
    }

    public static byte[] concatenarPdfs(byte[] pdfEmBytes, byte[] pdfEmBytes1, String titulo) throws IOException, DocumentException {
        if (Funcoes.objectIsNull(pdfEmBytes) || Funcoes.objectIsNull(pdfEmBytes1)) {
            if (!Funcoes.objectIsNull(pdfEmBytes)) {
                return pdfEmBytes;
            }
            return pdfEmBytes1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PDFMergerUtility mergePDF = new PDFMergerUtility();
        mergePDF.addSource((InputStream)new ByteArrayInputStream(pdfEmBytes));
        mergePDF.addSource((InputStream)new ByteArrayInputStream(pdfEmBytes1));
        mergePDF.setDestinationStream((OutputStream)baos);
        mergePDF.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
        return baos.toByteArray();
    }

    private static HashMap<String, String> construirInformacoesAdicionais(String titulo, PdfReader reader1) {
        HashMap informacoesAdicionais = (HashMap)reader1.getInfo();
        if (!Funcoes.textoVazio(titulo)) {
            informacoesAdicionais.put("Title", titulo);
        }
        informacoesAdicionais.put("Creator", "JALIS");
        informacoesAdicionais.put("Author", "JALIS");
        return informacoesAdicionais;
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, String filial, String requisicao, String exame, String material, String xmlResultado, boolean adicionarImagemComoValorData, boolean pesquisarLayoutRodapeWeb) throws SQLException {
        return ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, exame, material, xmlResultado, adicionarImagemComoValorData, -1, pesquisarLayoutRodapeWeb, null);
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, String filial, String requisicao, String exame, String material, String xmlResultado, boolean adicionarImagemComoValorData, boolean pesquisarLayoutRodapeWeb, Map<String, Object> dadosCabecalho) throws SQLException {
        return ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, exame, material, xmlResultado, adicionarImagemComoValorData, -1, pesquisarLayoutRodapeWeb, dadosCabecalho);
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, String filial, String requisicao, String exame, String material, String xmlResultado, boolean adicionarImagemComoValorData) throws SQLException {
        return ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, exame, material, xmlResultado, adicionarImagemComoValorData, -1, true, null);
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, String filial, String requisicao, String exame, String material, String xmlResultado, boolean adicionarImagemComoValorData, int contadorPaginaExameImagem, boolean pesquisarLayoutRodapeWeb) throws SQLException {
        return ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, exame, material, xmlResultado, adicionarImagemComoValorData, contadorPaginaExameImagem, pesquisarLayoutRodapeWeb, null);
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, String filial, String requisicao, String exame, String material, String xmlResultado, boolean adicionarImagemComoValorData, int contadorPaginaExameImagem, boolean pesquisarLayoutRodapeWeb, Map<String, Object> dadosCabecalho) throws SQLException {
        return ResultadosUtil.geraResultadoParaWeb(st, Conexao.getStatement(), Conexao.getStatement(), filial, requisicao, exame, material, xmlResultado, adicionarImagemComoValorData, contadorPaginaExameImagem, pesquisarLayoutRodapeWeb, true, true, dadosCabecalho);
    }

    public static Map<String, Object> geraResultadoParaWeb(Statement st, Statement st2, Statement stTemp, String filial, String requisicao, String exame, String material, String xmlResultado, boolean adicionarImagemComoValorData, int contadorPaginaExameImagem, boolean pesquisarLayoutRodapeWeb, boolean fecharStatement, boolean adicionarTagPHP, Map<String, Object> dadosCabecalho) throws SQLException {
        HashMap<String, Object> retorno = new HashMap();
        ArrayList<Component> componentesRodape = new ArrayList<Component>();
        int alturaRodapeExame = 0;
        StringBuilder buf = new StringBuilder();
        buf.append("select con_codigo, des_codigo from requisicao ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(requisicao);
        ResultSet rs = st.executeQuery(buf.toString());
        if (!rs.next()) {
            return null;
        }
        String convenio = rs.getString("con_codigo");
        String destino = rs.getString("des_codigo");
        String layout = ExameUtil.getCodigoLayout(filial, convenio, destino, st);
        if (!Funcoes.isNumeric(layout)) {
            return null;
        }
        String xmlRodapeExame = "";
        String codigoRequisicaoFormatado = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, stTemp);
        if (pesquisarLayoutRodapeWeb) {
            buf.setLength(0);
            buf.append("select lay_laudoweb from layout ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and lay_codigo = ").append(layout);
            rs = st.executeQuery(buf.toString());
            if (rs.next() && !Funcoes.textoVazio(rs.getString("lay_laudoweb"))) {
                String tmp = "";
                tmp = rs.getString("lay_laudoweb");
                if (StringUtil.getBoolean(tmp = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(tmp, "exame"), "pagina"), "propriedades"), "exibirRodapeExame")) {
                    alturaRodapeExame = StringUtil.getInt(tmp, "alturaRodapeExame");
                    xmlRodapeExame = StringUtil.getValor(StringUtil.getValor(rs.getString("lay_laudoweb"), "itens"), "rodapeExame");
                    if (!Funcoes.textoVazio(xmlRodapeExame)) {
                        TabelaSimbolos tabela = new TabelaSimbolos();
                        tabela.setDados(ExameUtil.getDadosExameRequisicao(st2, stTemp, requisicao, exame, material, filial, fecharStatement, dadosCabecalho, true));
                        ResultadosUtil.carregarItensParaArrayList(xmlRodapeExame, componentesRodape, tabela);
                        for (Component c : componentesRodape) {
                            if (c instanceof ExpressaoDigitacao) {
                                ((ExpressaoDigitacao)c).setTabelaSimbolos(tabela);
                                ((ExpressaoDigitacao)c).executar();
                                continue;
                            }
                            if (c instanceof DadosDigitacao) {
                                DadosDigitacao dados = (DadosDigitacao)c;
                                dados.setValor(tabela.getValor(dados.getCampoBanco()));
                                continue;
                            }
                            if (c instanceof CodigoBarrasDigitacao) {
                                CodigoBarrasDigitacao barra = (CodigoBarrasDigitacao)c;
                                barra.setValor(tabela.getValor(barra.getCampoBanco()));
                                continue;
                            }
                            if (!(c instanceof ImagemDigitacao)) continue;
                            ((ImagemDigitacao)c).setTabelaSimbolos(tabela);
                            ((ImagemDigitacao)c).executar();
                        }
                    }
                }
            }
        }
        retorno = Resultado.getResultadoHTML(xmlResultado, componentesRodape, requisicao, exame, material, codigoRequisicaoFormatado, adicionarImagemComoValorData, alturaRodapeExame, contadorPaginaExameImagem, adicionarTagPHP);
        if (fecharStatement) {
            Conexao.fecharStatement(st2, stTemp);
        }
        return retorno;
    }

    private static void carregarItensParaArrayList(String xml, List<Component> arrayList, TabelaSimbolos tabela) {
        try {
            arrayList.clear();
            for (String item : StringUtil.getListValores(xml, "componente")) {
                Componente comp = (Componente)Class.forName(StringUtil.getValor(item, "tipo")).newInstance();
                comp.setAtributos(StringUtil.getValor(item, "atributos"));
                Component dig = comp.getComponenteDigitacao(false);
                if (dig instanceof ExpressaoDigitacao) {
                    ((ExpressaoDigitacao)dig).setTabelaSimbolos(tabela);
                }
                arrayList.add(dig);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ResultadosUtil: 259");
        }
    }

    public static void gravarHashResultado(Statement st, String filial, String requisicao, String exame, String material, String nomePaciente, String xmlResultado) throws SQLException, NoSuchAlgorithmException, SalvaDadosException {
        if (xmlResultado == null || st == null) {
            return;
        }
        Resultado res = new Resultado(xmlResultado);
        List<Component> comps = res.getComponentes();
        StringBuilder bui = new StringBuilder();
        bui.append(Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()));
        bui.append(";");
        bui.append(Funcoes.preencheZero(requisicao, ParametrosGerais.getDigitosTuboRequisicao()));
        bui.append(";");
        bui.append(exame.toLowerCase());
        bui.append(";");
        bui.append(Funcoes.preencheZero(material, 3));
        bui.append(";");
        bui.append(nomePaciente.toLowerCase());
        bui.append(";");
        bui.append(Funcoes.formataData("dd/MM/yy HH:mm:ss", new Date()));
        bui.append(";");
        for (Component c : comps) {
            if (!(c instanceof ComponenteImpressao) || c instanceof ImagemImpressao || c instanceof FormaImpressao || c instanceof CodigoQRCodeImpressao || c instanceof GraficoImpressao) continue;
            String valor = "";
            if (c instanceof TextoEstatico) {
                valor = ((TextoEstatico)c).getText();
            } else if (c instanceof ComponenteResultado) {
                valor = ((ComponenteResultado)((Object)c)).getStringValor();
            }
            bui.append(c.getName()).append(":").append(valor).append(";");
        }
        String hash = StringUtil.calcularCodigoHash(bui.toString());
        SalvaDados salvar = new SalvaDados("examerequisicaohash");
        salvar.setOperacao(0);
        String codigoGerado = DBUtil.getSequencia(st, "examerequisicaohash", String.valueOf(Integer.parseInt(filial)));
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("exh_codigo", 2, false, true, codigoGerado);
        salvar.adicionaCampo("req_codigo", 2, false, true, requisicao);
        salvar.adicionaCampo("exa_codigo", 0, false, true, exame);
        salvar.adicionaCampo("mco_codigo", 2, false, true, material);
        salvar.adicionaCampo("exh_datahora", 0, false, true, Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date()));
        salvar.adicionaCampo("usr_codigo", 0, false, true, Variaveis.login);
        salvar.adicionaCampo("exh_resultado", 0, false, true, StringUtil.textoDB(xmlResultado));
        salvar.adicionaCampo("exh_textohash", 0, false, true, StringUtil.textoDB(bui.toString()));
        salvar.adicionaCampo("exh_hash", 0, false, true, hash);
        Conexao.executePerformance(filial, st, salvar.getComando(), false);
    }

    public static void gravarHashResultadoPerformance(Statement st, String filial, String requisicao, String exame, String material, String nomePaciente, String xmlResultado, List<Component> comps) throws NoSuchAlgorithmException, SQLException, SalvaDadosException {
        if (xmlResultado == null || st == null) {
            return;
        }
        StringBuilder bui = new StringBuilder();
        bui.append(Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()));
        bui.append(";");
        bui.append(Funcoes.preencheZero(requisicao, ParametrosGerais.getDigitosTuboRequisicao()));
        bui.append(";");
        bui.append(exame.toLowerCase());
        bui.append(";");
        bui.append(Funcoes.preencheZero(material, 3));
        bui.append(";");
        bui.append(nomePaciente.toLowerCase());
        bui.append(";");
        bui.append(Funcoes.formataData("dd/MM/yy HH:mm:ss", new Date()));
        bui.append(";");
        for (Component c : comps) {
            if (!(c instanceof ComponenteImpressao) || c instanceof ImagemImpressao || c instanceof FormaImpressao || c instanceof CodigoQRCodeImpressao || c instanceof GraficoImpressao) continue;
            String valor = "";
            if (c instanceof TextoEstatico) {
                valor = ((TextoEstatico)c).getText();
            } else if (c instanceof ComponenteResultado) {
                valor = ((ComponenteResultado)((Object)c)).getStringValor();
            }
            bui.append(c.getName()).append(":").append(valor).append(";");
        }
        String hash = StringUtil.calcularCodigoHash(bui.toString());
        SalvaDados salvar = new SalvaDados("examerequisicaohash");
        salvar.setOperacao(0);
        String codigoGerado = DBUtil.getSequencia(st, "examerequisicaohash", String.valueOf(Integer.parseInt(filial)));
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("exh_codigo", 2, false, true, codigoGerado);
        salvar.adicionaCampo("req_codigo", 2, false, true, requisicao);
        salvar.adicionaCampo("exa_codigo", 0, false, true, exame);
        salvar.adicionaCampo("mco_codigo", 2, false, true, material);
        salvar.adicionaCampo("exh_datahora", 0, false, true, Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date()));
        salvar.adicionaCampo("usr_codigo", 0, false, true, Variaveis.login);
        salvar.adicionaCampo("exh_resultado", 0, false, true, StringUtil.textoDB(xmlResultado));
        salvar.adicionaCampo("exh_textohash", 0, false, true, StringUtil.textoDB(bui.toString()));
        salvar.adicionaCampo("exh_hash", 0, false, true, hash);
        Conexao.executePerformance(filial, st, salvar.getComando(), false);
    }

    public static String assinarXML(Statement st, String filial, String xml, String requisicao, String exame, String material, String nomePaciente, String sexo, String dataNascimento, Date dataAssinatura) throws Exception, CertificadoException {
        xml = XMLUtil.processaCDataXml(xml, new String[]{"condicao", "validacao", "mensagemErro"});
        CertificadoHabilitadoAssinar certificado = null;
        String xmlAssinado = null;
        try {
            certificado = ResultadosUtil.tipoCertificacao(filial);
            if (certificado == null) {
                return xml;
            }
            certificado.setGerarArquivoXmlFisico(false);
            if (xml.indexOf("UTF-8") > 0) {
                xml = xml.replace("UTF-8", CODIFICACAO);
            }
            String xmlCabecalho = "<?xml version=\"1.0\" encoding=\"" + CODIFICACAO + "\" standalone=\"no\"?>";
            xml = xml.replace(xmlCabecalho, "");
            StringBuilder bui = new StringBuilder();
            bui.append(xmlCabecalho);
            bui.append("<laudo>");
            bui.append("<identificacao>");
            bui.append("<filial>").append(filial).append("</filial>");
            bui.append("<codigoRequisicao>").append(requisicao).append("</codigoRequisicao>");
            bui.append("<codigoExame>").append(exame).append("</codigoExame>");
            bui.append("<codigoMaterial>").append(material).append("</codigoMaterial>");
            bui.append("<nomepac>").append(StringUtil.preencheCData(StringUtil.limpaString(nomePaciente, new String[]{"<", ">", "'"}))).append("</nomepac>");
            bui.append("<sexo>").append(sexo).append("</sexo>");
            bui.append("<datanasc>").append(dataNascimento).append("</datanasc>");
            bui.append("<datahora>").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataAssinatura)).append("</datahora>");
            bui.append("</identificacao>");
            bui.append(xml);
            bui.append("</laudo>");
            certificado.setXmlOriginal(bui.toString());
            certificado = ResultadosUtil.assinarXmlLaudo(certificado);
            xmlAssinado = certificado.getXmlAssinado();
        }
        catch (Exception e) {
            Conexao.anulaSQL();
            throw new CertificadoException(e.getMessage());
        }
        return xmlAssinado;
    }

    public static CertificadoHabilitadoAssinar assinarXmlLaudo(CertificadoHabilitadoAssinar certificadoHabilitadoAssinar) throws Exception {
        if (certificadoHabilitadoAssinar.isAssinaturaEnvelopada()) {
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(certificadoHabilitadoAssinar.getCertificado()), certificadoHabilitadoAssinar.getSenha());
            String alias = ks.aliases().nextElement();
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(certificadoHabilitadoAssinar.getSenha()));
            X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            ArrayList<Object> x509Content = new ArrayList<Object>();
            x509Content.add(cert.getSubjectX500Principal().getName());
            x509Content.add(cert);
            X509Data xd = kif.newX509Data(x509Content);
            KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            ByteArrayInputStream is = new ByteArrayInputStream(certificadoHabilitadoAssinar.getXmlOriginal().getBytes(Charset.forName(CODIFICACAO)));
            Document doc = dbf.newDocumentBuilder().parse(is);
            DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)doc.getDocumentElement());
            Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            signature.sign(dsc);
            if (certificadoHabilitadoAssinar.isGerarArquivoXmlFisico()) {
                FileOutputStream os = new FileOutputStream(certificadoHabilitadoAssinar.getXmlSaidaArquivo());
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                trans.transform(new DOMSource(doc), new StreamResult(os));
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter saida = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(saida));
            certificadoHabilitadoAssinar.setXmlAssinado(saida.toString());
            ((InputStream)is).close();
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new Exception("N\u00e3o foi possivel encontrar a tag [Signature] no xml assinado.");
            }
        } else {
            String[] valoresMensagemErro;
            String[] valoresCondicao;
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(certificadoHabilitadoAssinar.getCertificado()), certificadoHabilitadoAssinar.getSenha());
            String alias = ks.aliases().nextElement();
            PrivateKey pk = (PrivateKey)ks.getKey(alias, certificadoHabilitadoAssinar.getSenha());
            Certificate[] chain = ks.getCertificateChain(alias);
            StringBuilder xml = new StringBuilder(certificadoHabilitadoAssinar.getXmlOriginal());
            for (String condicao : valoresCondicao = StringUtil.getValores(xml.toString(), "condicao")) {
                StringUtil.setValor(xml, "condicao", StringUtil.trataEntidadesXML(StringUtil.preencheCData(condicao)));
            }
            for (String msgErro : valoresMensagemErro = StringUtil.getValores(xml.toString(), "mensagemErro")) {
                StringUtil.setValor(xml, "mensagemErro", StringUtil.trataEntidadesXML(StringUtil.preencheCData(msgErro)));
            }
            certificadoHabilitadoAssinar.setXmlOriginal(xml.toString());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            ByteArrayInputStream is = new ByteArrayInputStream(certificadoHabilitadoAssinar.getXmlOriginal().getBytes(Charset.forName("UTF-8")));
            Document doc = dbf.newDocumentBuilder().parse(is);
            DOMSignContext dsc = new DOMSignContext(ks.getKey(alias, certificadoHabilitadoAssinar.getSenha()), (Node)doc.getDocumentElement());
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            KeyValue kv = kif.newKeyValue(chain[0].getPublicKey());
            KeyInfo ki = kif.newKeyInfo(Collections.singletonList(kv));
            Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            signature.sign(dsc);
            if (certificadoHabilitadoAssinar.isGerarArquivoXmlFisico()) {
                FileOutputStream os = new FileOutputStream(certificadoHabilitadoAssinar.getXmlSaidaArquivo());
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                trans.transform(new DOMSource(doc), new StreamResult(os));
            }
            DOMSource domSource = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter saida = new StringWriter();
            StreamResult sr = new StreamResult(saida);
            transformer.transform(domSource, sr);
            certificadoHabilitadoAssinar.setXmlAssinado(saida.toString());
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new Exception("N\u00e3o foi possivel encontrar a tag [Signature] no xml assinado.");
            }
        }
        return certificadoHabilitadoAssinar;
    }

    public static void atualizaAssinaturaExameRequisicao(String filial, String requisicao, String exame, String material, Statement st, Date dataHora) throws Exception {
        ResultadosUtil.atualizaAssinaturaExameRequisicaoPerformance(filial, requisicao, exame, material, st, dataHora);
    }

    public static void atualizaAssinaturaExameRequisicaoPerformance(String filial, String requisicao, String exame, String material, Statement st, Date dataHora) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("update examerequisicao set exr_datacertificado = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataHora)).append("' ");
        sql.append(" where fil_codigo = ").append(filial);
        sql.append(" and req_codigo = ").append(requisicao);
        sql.append(" and exa_codigo = '").append(exame).append("'");
        sql.append(" and mco_codigo = ").append(material).append(";");
        Conexao.executePerformance(filial, st, sql.toString(), false);
    }

    public static Date validarCertificado(byte[] certificado, String senhaCertificado) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        ByteArrayInputStream certificadoByte = new ByteArrayInputStream(certificado);
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(certificadoByte, senhaCertificado.toCharArray());
        String alias = ks.aliases().nextElement();
        if (Funcoes.textoVazio(alias)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O Alias do certificado digital \u00e9 inv\u00e1lido. Entre em contato com o Suporte.", 1);
            return null;
        }
        PrivateKey pk = (PrivateKey)ks.getKey(alias, senhaCertificado.toCharArray());
        Certificate[] chain = ks.getCertificateChain(alias);
        if (chain != null && chain.length > 0) {
            Date dataValidade = ((X509Certificate)chain[0]).getNotAfter();
            return dataValidade;
        }
        return null;
    }

    public static byte[] assinarPdfComCertificadoDigital(DadosAssinaturaDigitalDTO dadosAssinatura) throws Exception {
        try {
            if (dadosAssinatura.getPdfOriginal() == null) {
                throw new Exception("O PDF original n\u00e3o foi informado.");
            }
            if (dadosAssinatura.getCertificado() == null) {
                throw new Exception("O certificado digital n\u00e3o foi informado.");
            }
            if (Funcoes.textoVazio(dadosAssinatura.getSenhaCertificado())) {
                throw new Exception("A senha do certificado digital n\u00e3o foi informada.");
            }
            AssinaturaDigitalPDF assinaturaDigital = new AssinaturaDigitalPDF(dadosAssinatura);
            byte[] assinado = assinaturaDigital.assinarPDF();
            return assinado;
        }
        catch (IOException ioe) {
            throw new Exception("N\u00e3o foi poss\u00edvel assinar o PDF.\nVerifique se a senha est\u00e1 correta e se o certificado \u00e9 v\u00e1lido.\n" + ioe.getMessage());
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o \u00e9 poss\u00edvel assinar o PDF.\n" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CertificadoHabilitadoAssinar tipoCertificacao(String filial) throws Exception {
        Statement stFilial = Conexao.getStatement();
        Statement stUser = Conexao.getStatement();
        ResultSet rsFilial = null;
        Object retorno = null;
        ResultSet rsUser = null;
        CertificadoHabilitadoAssinar certificadoHabilitadoAssinar = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select * from filiais_postocoleta where fil_codigo = ").append(filial);
            rsFilial = stFilial.executeQuery(sql.toString());
            if (rsFilial.next()) {
                String tipo = rsFilial.getString("fil_tipocertificacao");
                Base64 base64e = new Base64();
                if (!Funcoes.textoVazio(tipo) && (tipo.equalsIgnoreCase("F") || tipo.equalsIgnoreCase("U"))) {
                    if (tipo.equalsIgnoreCase("F")) {
                        if (rsFilial.getString("fil_certificadort") != null) {
                            certificadoHabilitadoAssinar = new CertificadoHabilitadoAssinar();
                            certificadoHabilitadoAssinar.setTipo(tipo);
                            certificadoHabilitadoAssinar.setSenha(rsFilial.getString("fil_senhart"));
                            certificadoHabilitadoAssinar.setCertificado(Base64.decodeBase64((String)rsFilial.getString("fil_certificadort")));
                            return certificadoHabilitadoAssinar;
                        }
                        if (rsFilial.getString("fil_certificadortsub") != null) {
                            certificadoHabilitadoAssinar = new CertificadoHabilitadoAssinar();
                            certificadoHabilitadoAssinar.setTipo(tipo);
                            certificadoHabilitadoAssinar.setSenha(rsFilial.getString("fil_senhartsub"));
                            certificadoHabilitadoAssinar.setCertificado(Base64.decodeBase64((String)rsFilial.getString("fil_certificadortsub")));
                            return certificadoHabilitadoAssinar;
                        }
                        CertificadoHabilitadoAssinar certificadoHabilitadoAssinar2 = null;
                        return certificadoHabilitadoAssinar2;
                    }
                    if (!tipo.equalsIgnoreCase("U")) return certificadoHabilitadoAssinar;
                    sql = new StringBuilder();
                    sql.append("select * from usuario where upper(usr_codigo) = '").append(Variaveis.login.toUpperCase()).append("' ");
                    rsUser = stUser.executeQuery(sql.toString());
                    if (!rsUser.next()) {
                        CertificadoHabilitadoAssinar certificadoHabilitadoAssinar3 = null;
                        return certificadoHabilitadoAssinar3;
                    }
                    if (rsUser.getString("usr_certificado") != null && !Funcoes.textoVazio(rsUser.getString("usr_senhacertificado"))) {
                        certificadoHabilitadoAssinar = new CertificadoHabilitadoAssinar();
                        certificadoHabilitadoAssinar.setTipo(tipo);
                        certificadoHabilitadoAssinar.setSenha(rsUser.getString("usr_senhacertificado"));
                        certificadoHabilitadoAssinar.setCertificado(Base64.decodeBase64((String)rsUser.getString("usr_certificado")));
                        return certificadoHabilitadoAssinar;
                    }
                    if (rsFilial.getString("fil_certificadort") != null) {
                        certificadoHabilitadoAssinar = new CertificadoHabilitadoAssinar();
                        certificadoHabilitadoAssinar.setTipo(tipo);
                        certificadoHabilitadoAssinar.setSenha(rsFilial.getString("fil_senhart"));
                        certificadoHabilitadoAssinar.setCertificado(Base64.decodeBase64((String)rsFilial.getString("fil_certificadort")));
                        return certificadoHabilitadoAssinar;
                    }
                    if (rsFilial.getString("fil_certificadortsub") != null) {
                        certificadoHabilitadoAssinar = new CertificadoHabilitadoAssinar();
                        certificadoHabilitadoAssinar.setTipo(tipo);
                        certificadoHabilitadoAssinar.setSenha(rsFilial.getString("fil_senhartsub"));
                        certificadoHabilitadoAssinar.setCertificado(Base64.decodeBase64((String)rsFilial.getString("fil_certificadortsub")));
                        return certificadoHabilitadoAssinar;
                    }
                    CertificadoHabilitadoAssinar certificadoHabilitadoAssinar4 = null;
                    return certificadoHabilitadoAssinar4;
                }
                CertificadoHabilitadoAssinar certificadoHabilitadoAssinar5 = null;
                return certificadoHabilitadoAssinar5;
            }
            CertificadoHabilitadoAssinar certificadoHabilitadoAssinar6 = null;
            return certificadoHabilitadoAssinar6;
        }
        finally {
            try {
                stFilial.close();
                stUser.close();
            }
            catch (SQLException sQLException) {}
            if (rsUser != null) {
                try {
                    rsUser.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rsFilial != null) {
                try {
                    rsFilial.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static String getChaveAcessoRequisicao(Statement st, String codigoFilial, String codigoRequisicao, String senhaWebRequisicao) throws SQLException {
        String baseWeb = Variaveis.codigoBaseWeb;
        boolean agrupada = ExportaWeb.isBaseWebAgrupada(st, codigoFilial);
        if (agrupada) {
            try {
                Map<String, Object> o = ExportaWeb.getBaseWebAgrupada(st, codigoFilial);
                baseWeb = o.get("baseWeb") != null ? o.get("baseWeb").toString() : "";
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        String chaveAcesso = "";
        JSONObject jsonObject = new JSONObject();
        try {
            String tmp = Funcoes.preencheZero(codigoFilial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codigoRequisicao, ParametrosGerais.getDigitosTuboRequisicao());
            jsonObject.put("c", (Object)(agrupada ? tmp : codigoRequisicao));
            jsonObject.put("b", (Object)baseWeb);
            jsonObject.put("p", (Object)senhaWebRequisicao);
            chaveAcesso = new IntegracaoAplicativoService().encript(jsonObject.toString());
            chaveAcesso = Base64.encodeBase64String((byte[])chaveAcesso.getBytes());
        }
        catch (JSONException e) {
            throw new SQLException(e.getCause());
        }
        return chaveAcesso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enviarNotificacoes(HashMap<String, String> hashMapFilialRequisicao, Boolean conferirAutomatico, String usuarioConferencia) throws Exception {
        if (Boolean.TRUE.equals(!hashMapFilialRequisicao.isEmpty() && conferirAutomatico != false) && !Funcoes.textoVazio(usuarioConferencia)) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            String filial = "";
            String requisicao = "";
            try {
                for (Map.Entry<String, String> filReq : hashMapFilialRequisicao.entrySet()) {
                    String[] filialRequisicao = filReq.getKey().split("-");
                    if (filialRequisicao.length > 1) {
                        filial = filialRequisicao[0];
                    }
                    requisicao = filReq.getValue();
                    if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao)) continue;
                    if (!SMSUtil.isBloquearSMSExamePronto(filial, requisicao, st)) {
                        SMSUtil.criaLogSmsComDadosRequisicao(filial, requisicao, ExportaSMS.TipoSMS.RESULTADO, st, st2);
                    }
                    if (!EmailUtil.isBloquearEmailExamePronto(filial, requisicao, st)) {
                        EmailUtil.criaLogEmail(filial, requisicao, null, EmailUtil.TipoEmail.RESULTADO, true, st);
                    }
                    if (!PushUtil.isBloquearPushExamePronto(filial, requisicao, st)) {
                        PushUtil.criaLogPushComDadosRequisicao(filial, requisicao, TipoPush.RESULTADO, st, st2);
                    }
                    if (WhatsAppUtil.isBloquearWhatsappExamePronto(filial, requisicao, st)) continue;
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(filial, requisicao, TipoWhatsapp.RESULTADO, st, st2);
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean notificacaoJaEnviada(Integer filial, Integer requisicao, Statement st, String colunaAgrupar, String colunaRegistro) throws SQLException {
        String sql = "select (case when " + colunaAgrupar + " is null then false else fil_agruparmultiguiasms end) as " + colunaAgrupar + " from filiais_postocoleta where fil_codigo = ?";
        PreparedStatement psMultiguia = Conexao.getPreparedStatement(sql);
        psMultiguia.setInt(1, filial);
        try (ResultSet rsFilialMultiguia = null;){
            rsFilialMultiguia = psMultiguia.executeQuery();
            boolean bFilialMultiguia = false;
            if (rsFilialMultiguia.next()) {
                bFilialMultiguia = rsFilialMultiguia.getBoolean(colunaAgrupar);
            }
            if (bFilialMultiguia) {
                int n;
                StringBuilder listaRequisicoes = new StringBuilder();
                Integer[] integerArray = RecepcaoUtil.verificaMultiGuias(st, String.valueOf(filial), String.valueOf(requisicao), true);
                int n2 = integerArray.length;
                for (n = 0; n < n2; n += 1) {
                    int requisicaoAtual = integerArray[n];
                    if (!listaRequisicoes.toString().isEmpty()) {
                        listaRequisicoes.append(", ");
                    }
                    listaRequisicoes.append(requisicaoAtual);
                }
                StringBuilder buf = new StringBuilder("select ");
                buf.append(colunaRegistro);
                buf.append(" from requisicao where fil_codigo = ").append(filial);
                buf.append(" and req_codigo in ( ").append((CharSequence)listaRequisicoes).append(" ) and not req_excluida");
                buf.append(" and " + colunaRegistro + " is not null");
                ResultSet reqNotificaoEnviada = st.executeQuery(buf.toString());
                if (reqNotificaoEnviada.next()) {
                    n = !Funcoes.textoVazio(reqNotificaoEnviada.getString(colunaRegistro)) ? 1 : 0;
                    return n != 0;
                }
            }
        }
        return false;
    }

    public static boolean verificaIntegridadePDFImportado(byte[] pdf) {
        try {
            if (pdf == null || pdf.length == 0) {
                return false;
            }
            PDDocument.load((byte[])pdf);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getChaveAcessoRequisicao(Statement st, String codigoFilial, String codigoRequisicao, String senhaWebRequisicao, String baseWeb, int digitosTuboFilial, int digitosTuboRequisicao) throws SQLException {
        boolean agrupada = ExportaWeb.isBaseWebAgrupada(st, codigoFilial);
        if (agrupada) {
            try {
                Map<String, Object> o = ExportaWeb.getBaseWebAgrupada(st, codigoFilial);
                baseWeb = o.get("baseWeb") != null ? o.get("baseWeb").toString() : "";
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        String chaveAcesso = "";
        JSONObject jsonObject = new JSONObject();
        try {
            String tmp = Funcoes.preencheZero(codigoFilial, digitosTuboFilial) + Funcoes.preencheZero(codigoRequisicao, digitosTuboRequisicao);
            jsonObject.put("c", (Object)(agrupada ? tmp : codigoRequisicao));
            jsonObject.put("b", (Object)baseWeb);
            jsonObject.put("p", (Object)senhaWebRequisicao);
            chaveAcesso = new IntegracaoAplicativoService().encript(jsonObject.toString());
            chaveAcesso = Base64.encodeBase64String((byte[])chaveAcesso.getBytes());
        }
        catch (JSONException e) {
            throw new SQLException(e.getCause());
        }
        return chaveAcesso;
    }
}

