/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.resultados.ThreadImpAutoListener;
import jalis.laboratorio.resultados.ThreadImpressaoAutomatica;
import jalis.laboratorio.util.impressao.ImprimirMapa;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MapaImpressaoAutomatica
extends FrmPadrao
implements ActionListener,
ThreadImpAutoListener {
    private static final String ULTIMO_FILTRO = "MapaImpressaoAutomatica.ultimoFiltro";
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JLabel labelData = new JLabel();
    private JLabel labelRequisicao = new JLabel();
    private JLabel labelPaciente = new JLabel();
    private JLabel labelTempo = new JLabel("00:00:00", 4);
    private JLabel labelMensagem = new JLabel("", 0);
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JProgressBar progress = ComponenteFactory.novoJProgressBar("Imprimindo : ");
    private JCheckBox checkAutomatico = new JCheckBox("Autom\u00e1tico", true);
    private JCheckBox checkTriado = new JCheckBox("<html>Imprimir apenas exames<br>j\u00e1 triados</html>", false);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private JButton buttonParar = ComponenteFactory.novoJButton("Parar", 'P', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonOpcoes = ComponenteFactory.novoJButton(this, null, null, false);
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemPrioridade;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemMaterial;
    private int tempo;
    private ThreadImpressaoAutomatica thread;
    private SimpleDateFormat brDate = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat usDate = new SimpleDateFormat("MM/dd/yyyy");
    private final long ACESSO_FILTRAR_FILIAL = 300100101L;
    private boolean filtrarFilial = !ParametrosGerais.getTipoIntegracao().equals("N") || Acesso.getAcesso(300100101L);
    private Timer cronometro = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MapaImpressaoAutomatica.this.labelTempo.setText(StringUtil.formataSegundos(++MapaImpressaoAutomatica.this.tempo));
        }
    }){

        @Override
        public void start() {
            MapaImpressaoAutomatica.this.tempo = 0;
            super.start();
        }

        @Override
        public void stop() {
            MapaImpressaoAutomatica.this.labelTempo.setText(StringUtil.formataSegundos(0L));
            super.stop();
        }
    };
    private boolean ocultarConvenio;

    public static long getModuloAcesso() {
        return 300100100L;
    }

    public MapaImpressaoAutomatica() {
        this.iniciar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonDataIni) {
                Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
            } else if (o == this.buttonDataFin) {
                Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
            } else if (o == this.buttonImprimir) {
                this.gravarParametros(true);
                this.thread = new ThreadImpressaoAutomatica(this.getSelect(), this.checkAutomatico.isSelected());
                this.thread.addThreadImpAutoListener(this);
                this.thread.iniciar();
            } else if (o == this.buttonParar) {
                if (this.thread != null) {
                    this.thread.parar();
                    this.thread = null;
                }
            } else if (o == this.buttonFechar) {
                this.setVisible(false);
                this.gravarParametros(true);
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace(), "MapaImpressaoAutomatica: 119");
            }
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "MapaImpressaoAutomatica: 121");
        }
    }

    @Override
    public void iniciouExecucao() {
        this.cronometro.start();
        this.habilitarDesabilitar(false);
        ControlaTempoInativo.parar();
    }

    @Override
    public void executouConsulta(Registro[] registros) {
        this.progress.setMaximum(registros.length);
        this.progress.setValue(0);
        this.labelData.setText("");
        this.labelRequisicao.setText("");
        this.labelPaciente.setText("");
    }

    @Override
    public void processouRegistro(Registro reg, int posicao) throws Exception {
        boolean naoPermiteVisualizar = Acesso.getAcesso(Long.parseLong("0300100102"));
        this.progress.setValue(posicao + 1);
        this.labelData.setText(this.brDate.format(reg.getDate("req_data")));
        this.labelRequisicao.setText(reg.getString("req_codigo"));
        if (Acesso.getAcesso(Long.valueOf("0300100102"))) {
            this.labelPaciente.setText("Visualiza\u00e7\u00e3o n\u00e3o permitida");
        } else {
            this.labelPaciente.setText(reg.getString("pac_nome"));
        }
        String[] setores = this.itemSetor.getSelecionados();
        String[] materiais = this.itemMaterial.getSelecionados();
        if (ImprimirMapa.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, setores, false, this.checkTriado.isSelected(), true, materiais, naoPermiteVisualizar, this.ocultarConvenio, -1)) {
            String tempo = ParametrosLocais.getParametro("tempoImpressaoMapa");
            if (this.thread != null) {
                this.thread.esperar(tempo != null && tempo.matches("\\d+") ? Integer.parseInt(tempo) : 0);
            }
        }
    }

    @Override
    public void processouTodos() {
        this.progress.setValue(0);
    }

    @Override
    public void terminouExecucao() {
        this.habilitarDesabilitar(true);
        this.labelData.setText("");
        this.labelRequisicao.setText("");
        this.labelPaciente.setText("");
        this.progress.setValue(0);
        this.progress.setString("");
        this.cronometro.stop();
        if (!this.checkAutomatico.isSelected()) {
            this.labelMensagem.setText("Impress\u00e3o conclu\u00edda.");
        }
        ControlaTempoInativo.iniciar();
    }

    private int[] getInteiros(String[] valores) {
        if (valores != null && valores.length > 0) {
            int[] tmp = new int[valores.length];
            for (int i = 0; i < valores.length; ++i) {
                tmp[i] = Integer.parseInt(valores[i]);
            }
            return tmp;
        }
        return null;
    }

    private String getSelect() throws ParseException {
        StringBuilder bui = new StringBuilder("select distinct req.fil_codigo, req.req_codigo, req.req_data, pac.pac_nome \n");
        bui.append("from requisicao req \n");
        bui.append("left join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo \n");
        bui.append("left join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo \n");
        if (this.itemSetor != null && !this.itemSetor.vazio()) {
            bui.append("left join examesetor ese on exr.fil_codigo = ese.fil_codigo and exr.exa_codigo = ese.exa_codigo \n");
        }
        if (this.itemPrioridade != null && !this.itemPrioridade.vazio()) {
            bui.append("left join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo \n");
        }
        bui.append("where ");
        if (this.itemFilial != null && !this.itemFilial.vazio()) {
            bui.append("req.fil_codigo in ").append(this.getExpressaoWhere(this.itemFilial)).append(" \n");
        } else {
            bui.append("req.fil_codigo = ").append(Variaveis.filialPadrao);
        }
        bui.append(" and req.req_excluida = false and exr.exr_excluido = false ");
        bui.append(" and exr.exr_datamapa is null and (exr.exr_situacao <> '");
        bui.append("T");
        bui.append("' or exr.exr_situacao is null)\n");
        if (this.checkTriado.isSelected()) {
            bui.append(" and exr.exr_dataetqtriagem is not null ");
        }
        String campo = "exr.exr_datamaterial";
        if (Variaveis.filialPadrao.equals("A")) {
            campo = "req.req_data";
        }
        if (Funcoes.verificaData(this.textDataIni.getText())) {
            bui.append("and cast(").append(campo).append(" as date) >= '");
            bui.append(this.usDate.format(this.brDate.parse(this.textDataIni.getText())));
            bui.append("' \n");
        }
        if (Funcoes.verificaData(this.textDataFin.getText())) {
            bui.append("and cast(").append(campo).append(" as date) <= '");
            bui.append(this.usDate.format(this.brDate.parse(this.textDataFin.getText())));
            bui.append("' \n");
        }
        if (this.itemColeta != null && !this.itemColeta.vazio()) {
            bui.append("and req.col_codigo in ").append(this.getExpressaoWhere(this.itemColeta)).append(" \n");
        }
        if (this.itemSetor != null && !this.itemSetor.vazio()) {
            bui.append("and ese.set_codigo in ").append(this.getExpressaoWhere(this.itemSetor)).append(" \n");
        }
        if (this.itemConvenio != null && !this.itemConvenio.vazio()) {
            bui.append("and req.con_codigo in ").append(this.getExpressaoWhere(this.itemConvenio)).append(" \n");
        }
        if (this.itemMaterial != null && !this.itemMaterial.vazio()) {
            bui.append("and exr.mco_codigo in ").append(this.getExpressaoWhere(this.itemMaterial)).append(" \n");
        }
        if (this.itemDestino != null && !this.itemDestino.vazio()) {
            bui.append("and req.des_codigo in ").append(this.getExpressaoWhere(this.itemDestino)).append(" \n");
        }
        if (this.itemSituacao != null && !this.itemSituacao.vazio()) {
            bui.append("and req.sit_codigo in ").append(this.getExpressaoWhere(this.itemSituacao)).append(" \n");
        }
        if (this.itemPrioridade != null && !this.itemPrioridade.vazio()) {
            bui.append("and con.pri_codigo in ").append(this.getExpressaoWhere(this.itemPrioridade)).append(" \n");
        }
        if (this.itemMedico != null && this.itemMedico.isSelected()) {
            bui.append(this.getExpressaoWhere(this.itemMedico)).append(" \n");
        }
        bui.append("order by req.req_data, req.req_codigo");
        return bui.toString();
    }

    private String getExpressaoWhere(CheckItemFiltro item) {
        StringBuilder bui = new StringBuilder();
        if (item == this.itemMedico) {
            String[] conselho = item.getSelecionadosAvancado(0);
            String[] crm = item.getSelecionadosAvancado(1);
            String[] uf = item.getSelecionadosAvancado(2);
            if (crm != null && uf != null && crm.length > 0 && crm.length == uf.length) {
                bui.append(" and ");
                if (crm.length > 1) {
                    bui.append('(');
                }
                bui.append("(req.med_conselho = '").append(conselho[0]);
                bui.append("' and req.med_crm = '").append(crm[0]);
                bui.append("' and req.med_uf = '").append(uf[0]).append("')");
                for (int i = 1; i < crm.length; ++i) {
                    bui.append(" or (req.med_conselho = '").append(conselho[i]);
                    bui.append("' and req.med_crm = '").append(crm[i]);
                    bui.append("' and req.med_uf = '").append(uf[i]).append("')");
                }
                if (crm.length > 1) {
                    bui.append(')');
                }
                bui.append(" \n");
            }
        } else {
            String asps = item == this.itemColeta || item == this.itemDestino ? "'" : "";
            String[] sel = item.getSelecionados(0);
            if (sel != null && sel.length > 0) {
                bui.append('(').append(asps).append(sel[0]).append(asps);
                for (int i = 1; i < sel.length; ++i) {
                    bui.append(", ").append(asps).append(sel[i]).append(asps);
                }
                bui.append(')');
            }
        }
        return bui.toString();
    }

    private void habilitarDesabilitar(boolean valor) {
        this.buttonImprimir.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.buttonParar.setEnabled(!valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.itemColeta.setEnabled(valor);
        this.itemFilial.setEnabled(valor);
        this.itemSetor.setEnabled(valor);
        if (!this.ocultarConvenio) {
            this.itemConvenio.setEnabled(valor);
        }
        this.itemMaterial.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemSituacao.setEnabled(valor);
        this.itemPrioridade.setEnabled(valor);
        this.itemMedico.setEnabled(valor);
        this.checkAutomatico.setEnabled(valor);
        this.checkTriado.setEnabled(valor);
    }

    private void gravarParametros(boolean executarCommitParametros) {
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, this.getAtributos());
        ParametrosUsuarios.salvarParametros(executarCommitParametros);
    }

    private void carregarParametros() {
        this.setAtributos(ParametrosUsuarios.getValor(ULTIMO_FILTRO));
    }

    private String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("automatico", String.valueOf(this.checkAutomatico.isSelected())));
        bui.append(StringUtil.getTag("triados", String.valueOf(this.checkTriado.isSelected())));
        bui.append(this.getAtributosFiltro(this.itemFilial, "filial"));
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemSetor, "setor"));
        if (!this.ocultarConvenio) {
            bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        }
        bui.append(this.getAtributosFiltro(this.itemMaterial, "material"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemSituacao, "situacao"));
        bui.append(this.getAtributosFiltro(this.itemPrioridade, "prioridade"));
        bui.append(this.getAtributosFiltro(this.itemMedico, "medico"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        return StringUtil.getTag("filtro", bui.toString());
    }

    private void setAtributos(String atr) {
        String str = StringUtil.getValor(atr, "filtro");
        if (StringUtil.getValor(str, "automatico").length() == 0) {
            this.checkAutomatico.setSelected(true);
        } else {
            this.checkAutomatico.setSelected(StringUtil.getBoolean(str, "automatico"));
        }
        if (StringUtil.getValor(str, "triados").length() == 0) {
            this.checkTriado.setSelected(true);
        } else {
            this.checkTriado.setSelected(StringUtil.getBoolean(str, "triados"));
        }
        this.setAtributosFiltro(this.itemFilial, StringUtil.getValor(str, "filial"));
        this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
        this.setAtributosFiltro(this.itemSetor, StringUtil.getValor(str, "setor"));
        if (!this.ocultarConvenio) {
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
        }
        this.setAtributosFiltro(this.itemMaterial, StringUtil.getValor(str, "material"));
        this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
        this.setAtributosFiltro(this.itemSituacao, StringUtil.getValor(str, "situacao"));
        this.setAtributosFiltro(this.itemPrioridade, StringUtil.getValor(str, "prioridade"));
        this.setAtributosFiltro(this.itemMedico, StringUtil.getValor(str, "medico"));
        this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
        this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        if (item == this.itemMedico) {
            bui.append(StringUtil.getTag("crm", item.getSelecionadosAvancado(1)));
            bui.append(StringUtil.getTag("uf", item.getSelecionadosAvancado(2)));
        }
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
            if (item == this.itemMedico) {
                item.setSelecionados(StringUtil.getValores(atributos, "crm"), 1);
                item.setSelecionados(StringUtil.getValores(atributos, "uf"), 2);
            }
        }
    }

    private void iniciar() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Impress\u00e3o autom\u00e1tica", "Impress\u00e3o autom\u00e1tica de mapas", "triagem/mapa_automatica.jpg");
        this.ocultarConvenio = Acesso.getAcesso(Long.valueOf("0300100103"));
        this.checkAutomatico.setMargin(new Insets(0, 0, 0, 0));
        this.textDataIni.setPreferredSize(new Dimension(10, 20));
        this.textDataFin.setPreferredSize(new Dimension(10, 20));
        Dimension dimensionItem = new Dimension(186, 20);
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setMinimumSize(dimensionItem);
        this.itemFilial.setPreferredSize(dimensionItem);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setMinimumSize(dimensionItem);
        this.itemColeta.setPreferredSize(dimensionItem);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setMinimumSize(dimensionItem);
        this.itemDestino.setPreferredSize(dimensionItem);
        if (!this.ocultarConvenio) {
            this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            this.itemConvenio.setColunaHint(1);
            this.itemConvenio.setMinimumSize(dimensionItem);
            this.itemConvenio.setPreferredSize(dimensionItem);
        }
        this.itemMaterial = new CheckItemFiltro("Material", "Filtrar", "Filtrando materiais", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemMaterial.setDados("materialcoleta", new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemMaterial.setColunaHint(1);
        this.itemMaterial.setMinimumSize(dimensionItem);
        this.itemMaterial.setPreferredSize(dimensionItem);
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setMinimumSize(dimensionItem);
        this.itemSetor.setPreferredSize(dimensionItem);
        this.itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, false);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(3);
        this.itemMedico.setMinimumSize(dimensionItem);
        this.itemMedico.setPreferredSize(dimensionItem);
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemSituacao.setMinimumSize(dimensionItem);
        this.itemSituacao.setPreferredSize(dimensionItem);
        this.itemPrioridade = new CheckItemFiltro("Prioridade", "Filtrar", "Filtrando prioridades", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPrioridade.setDados("prioridade", new String[]{"pri_codigo", "pri_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemPrioridade.setColunaHint(1);
        this.itemPrioridade.setMinimumSize(dimensionItem);
        this.itemPrioridade.setPreferredSize(dimensionItem);
        JPanel panelTemp = new JPanel(new GridBagLayout());
        panelTemp.setBorder(BorderFactory.createTitledBorder("Impress\u00e3o"));
        this.add((Component)panelTemp, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(0, 5, 5, 5);
        cons.gridx = 0;
        cons.gridy = 0;
        panelTemp.add((Component)new JLabel("Data:"), cons);
        cons.gridy = 1;
        panelTemp.add((Component)new JLabel("Requisi\u00e7\u00e3o:"), cons);
        cons.gridy = 2;
        panelTemp.add((Component)new JLabel("Paciente:"), cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.weightx = 0.5;
        panelTemp.add((Component)this.labelData, cons);
        cons.gridy = 1;
        panelTemp.add((Component)this.labelRequisicao, cons);
        cons.gridy = 2;
        panelTemp.add((Component)this.labelPaciente, cons);
        cons.weighty = 0.5;
        cons.gridwidth = 2;
        cons.gridx = 0;
        cons.gridy = 3;
        panelTemp.add((Component)this.labelMensagem, cons);
        cons.insets = new Insets(0, 0, 5, 5);
        cons.gridx = 1;
        cons.gridy = 4;
        cons.weighty = 0.0;
        panelTemp.add((Component)this.labelTempo, cons);
        cons.insets = new Insets(0, 0, 0, 0);
        cons.gridx = 0;
        cons.gridy = 5;
        panelTemp.add((Component)this.progress, cons);
        Dimension dimensaoData = new Dimension(90, 20);
        Dimension dimensaoBotaoData = new Dimension(20, 20);
        panelTemp = new JPanel(new GridBagLayout());
        panelTemp.setBorder(BorderFactory.createTitledBorder("Filtro"));
        this.add((Component)panelTemp, "West");
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 3;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 0, 0, 0);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        if (this.filtrarFilial) {
            panelTemp.add((Component)this.itemFilial, cons);
            ++cons.gridy;
        }
        panelTemp.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemSetor, cons);
        if (!this.ocultarConvenio) {
            ++cons.gridy;
            panelTemp.add((Component)this.itemConvenio, cons);
        }
        ++cons.gridy;
        panelTemp.add((Component)this.itemDestino, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemSituacao, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemPrioridade, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemMedico, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemMaterial, cons);
        ++cons.gridy;
        cons.insets = new Insets(1, 1, 0, 0);
        cons.gridwidth = 1;
        panelTemp.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        this.textDataIni.setPreferredSize(dimensaoData);
        this.textDataIni.setMinimumSize(dimensaoData);
        panelTemp.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setFocusable(false);
        this.buttonDataIni.setPreferredSize(dimensaoBotaoData);
        this.buttonDataIni.setMinimumSize(dimensaoBotaoData);
        panelTemp.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelTemp.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        this.textDataFin.setPreferredSize(dimensaoData);
        this.textDataFin.setMinimumSize(dimensaoData);
        panelTemp.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataFin.setFocusable(false);
        this.buttonDataFin.setPreferredSize(dimensaoBotaoData);
        this.buttonDataFin.setMinimumSize(dimensaoBotaoData);
        panelTemp.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 3;
        panelTemp.add((Component)this.checkAutomatico, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.checkTriado, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        panelTemp.add((Component)new JLabel(), cons);
        ++cons.gridy;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.anchor = 13;
        panelTemp.add((Component)this.buttonImprimir, cons);
        panelTemp = new JPanel(new FlowLayout(2, 3, 3));
        panelTemp.add(this.buttonParar);
        panelTemp.add(this.buttonFechar);
        this.add((Component)panelTemp, "South");
        this.carregarParametros();
    }
}

