/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.resultados.ThreadImpAutoListener;
import jalis.laboratorio.resultados.ThreadImpressaoAutomatica;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class LaudoImpressaoAutomatica
extends FrmPadrao
implements ActionListener,
ThreadImpAutoListener,
DisposeListener {
    private static final String ULTIMO_FILTRO = "LaudoImpressaoAutomatica.ultimoFiltro";
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JLabel labelData = new JLabel();
    private JLabel labelRequisicao = new JLabel();
    private JLabel labelPaciente = new JLabel();
    private JLabel labelTempo = new JLabel("00:00:00", 4);
    private JLabel labelMensagem = new JLabel("", 0);
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JProgressBar progress = ComponenteFactory.novoJProgressBar("Imprimindo : ");
    private JCheckBox checkAutomatico = new JCheckBox("Autom\u00e1tico", true);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private JButton buttonParar = ComponenteFactory.novoJButton("Parar", 'P', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemPrioridade;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemExame;
    private CheckItemFiltro itemGrupoExame;
    private int tempo;
    private ThreadImpressaoAutomatica thread;
    private SimpleDateFormat brDate = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat usDate = new SimpleDateFormat("MM/dd/yyyy");
    private JTextArea areaHistorico = new JTextArea();
    private JScrollPane scrollHistorico = new JScrollPane(this.areaHistorico);
    private boolean acessoImprimirDevedor = Acesso.getAcesso(400500104L);
    private boolean acessoFiltrarFilial = Acesso.getAcesso(400500108L);
    private String impressoraSelecionada;
    private boolean filtrarFilial = !ParametrosGerais.getTipoIntegracao().equals("N") || this.acessoFiltrarFilial;
    private Timer cronometro = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            LaudoImpressaoAutomatica.this.labelTempo.setText(StringUtil.formataSegundos(++LaudoImpressaoAutomatica.this.tempo));
        }
    }){

        @Override
        public void start() {
            LaudoImpressaoAutomatica.this.tempo = 0;
            super.start();
        }

        @Override
        public void stop() {
            LaudoImpressaoAutomatica.this.labelTempo.setText(StringUtil.formataSegundos(0L));
            super.stop();
        }
    };
    private boolean ocultarConvenio;

    public LaudoImpressaoAutomatica() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return 400500101L;
    }

    @Override
    public void dispose() {
        if (this.thread != null) {
            this.thread.parar();
            this.thread = null;
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            splash.mostrar("A impress\u00e3o autom\u00e1tica de laudo foi interrompida");
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            splash.apagar();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonDataIni) {
                Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
            } else if (o == this.buttonDataFin) {
                Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
            } else if (o == this.buttonImprimir) {
                this.areaHistorico.setText("");
                this.gravarParametros(false);
                this.thread = new ThreadImpressaoAutomatica(this.getSelect(), this.checkAutomatico.isSelected());
                this.thread.addThreadImpAutoListener(this);
                this.thread.iniciar();
            } else if (o == this.buttonParar) {
                if (this.thread != null) {
                    this.thread.parar();
                    this.thread = null;
                }
            } else if (o == this.buttonFechar) {
                this.setVisible(false);
                this.gravarParametros(true);
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace(), "LaudoImpressaoAutomatica: 123");
            }
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "LaudoImpressaoAutomatica: 125");
        }
    }

    @Override
    public void executouConsulta(Registro[] registros) {
        this.progress.setMaximum(registros.length);
        this.progress.setValue(0);
        this.labelData.setText("");
        this.labelRequisicao.setText("");
        this.labelPaciente.setText("");
        this.agruparRequisicoesPaciente(registros);
    }

    @Override
    public void iniciouExecucao() {
        this.cronometro.start();
        this.habilitarDesabilitar(false);
        ControlaTempoInativo.parar();
    }

    @Override
    public void processouRegistro(Registro reg, int posicao) throws Exception {
        this.progress.setValue(posicao + 1);
        this.areaHistorico.append("REQ. C\u00d3D: \"" + Funcoes.preencheVazio(reg.getString("req_codigo"), 10, 1) + "\"");
        if (this.validaRequisicao(reg)) {
            this.areaHistorico.append(" - valida\u00e7\u00e3o OK");
            this.labelData.setText(this.brDate.format(reg.getDate("req_data")));
            this.labelRequisicao.setText(reg.getString("req_codigo"));
            if (Acesso.getAcesso(Long.valueOf("0400500113"))) {
                this.labelPaciente.setText("Visualiza\u00e7\u00e3o n\u00e3o permitida");
            } else {
                this.labelPaciente.setText(reg.getString("pac_nome"));
            }
            boolean naoMostrarNomePaciente = Acesso.getAcesso(Long.parseLong("0400500113"));
            RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(this.impressoraSelecionada, this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), false, ParametrosGerais.getConferencia(), this.itemSetor.getSelecionados(0), this.itemExame.getSelecionados(0), null, false, "", false, false, this.itemGrupoExame.getSelecionados(0), false, "", naoMostrarNomePaciente);
            if (Funcoes.textoVazio(this.impressoraSelecionada) || this.impressoraSelecionada.equalsIgnoreCase("Selecionar Impressora")) {
                this.impressoraSelecionada = retorno.getImpressoraSelecionada();
            }
            if (retorno.isImprimiuResultado()) {
                this.areaHistorico.append(" - enviado para impress\u00e3o.");
                Conexao.arquivaSQL();
                if (ParametrosLocais.isTrue("executarGCImpressaoAutomatica")) {
                    System.gc();
                }
                String tempo = ParametrosLocais.getParametro("tempoImpressaoLaudo");
                if (this.thread != null) {
                    this.thread.esperar(tempo != null && tempo.matches("\\d+") ? Integer.parseInt(tempo) : 100);
                }
            } else {
                this.areaHistorico.append(" - N\u00e3o foi poss\u00edvel enviar para impress\u00e3o.");
            }
        } else {
            this.areaHistorico.append(" - N\u00e3o foi poss\u00edvel concluir a valida\u00e7\u00e3o.");
        }
        this.areaHistorico.append("\n");
    }

    @Override
    public void processouTodos() {
        this.progress.setValue(0);
    }

    @Override
    public void terminouExecucao() {
        this.habilitarDesabilitar(true);
        this.labelData.setText("");
        this.labelRequisicao.setText("");
        this.labelPaciente.setText("");
        this.progress.setValue(0);
        this.progress.setString("");
        this.cronometro.stop();
        if (!this.checkAutomatico.isSelected()) {
            this.labelMensagem.setText("Impress\u00e3o conclu\u00edda.");
        }
        ControlaTempoInativo.iniciar();
    }

    private String getSelect() throws Exception {
        StringBuilder bui = new StringBuilder(ImpressaoResultados.SELECT_REQUISICAO);
        bui.append("where \n");
        if (!this.itemFilial.vazio()) {
            bui.append("a.fil_codigo in ").append(this.getExpressaoWhere(this.itemFilial)).append(" \n");
        } else {
            bui.append("a.fil_codigo = ").append(Variaveis.filialPadrao).append(" \n");
        }
        bui.append(" and a.req_excluida = false ");
        if (Funcoes.verificaData(this.textDataIni.getText())) {
            bui.append("and a.req_data >= '");
            bui.append(this.usDate.format(this.brDate.parse(this.textDataIni.getText())));
            bui.append("' \n");
        }
        if (Funcoes.verificaData(this.textDataFin.getText())) {
            bui.append("and a.req_data <= '");
            bui.append(this.usDate.format(this.brDate.parse(this.textDataFin.getText())));
            bui.append("' \n");
        }
        if (!this.acessoImprimirDevedor) {
            bui.append("and (a.req_total - a.req_totpago) <= 0 and a.req_deveguia = false \n");
        }
        if (!this.itemColeta.vazio()) {
            bui.append("and a.col_codigo in ").append(this.getExpressaoWhere(this.itemColeta)).append(" \n");
        }
        if (!this.ocultarConvenio && !this.itemConvenio.vazio()) {
            bui.append("and a.con_codigo in ").append(this.getExpressaoWhere(this.itemConvenio)).append(" \n");
        }
        if (!this.itemDestino.vazio()) {
            bui.append("and a.des_codigo in ").append(this.getExpressaoWhere(this.itemDestino)).append(" \n");
        }
        if (!this.itemSituacao.vazio()) {
            bui.append("and a.sit_codigo in ").append(this.getExpressaoWhere(this.itemSituacao)).append(" \n");
        }
        if (!this.itemPrioridade.vazio()) {
            bui.append("and b.pri_codigo in ").append(this.getExpressaoWhere(this.itemPrioridade)).append(" \n");
        }
        if (this.itemMedico.isSelected()) {
            bui.append(this.getExpressaoWhere(this.itemMedico)).append(" \n");
        }
        bui.append(" and c.des_naoimprimir = false ");
        bui.append("order by a.con_codigo, a.req_data");
        return bui.toString();
    }

    private String getExpressaoWhere(CheckItemFiltro item) {
        StringBuilder bui = new StringBuilder();
        if (item == this.itemMedico) {
            String[] conselho = item.getSelecionadosAvancado(0);
            String[] crm = item.getSelecionadosAvancado(1);
            String[] uf = item.getSelecionadosAvancado(2);
            if (conselho != null && crm != null && uf != null && crm.length > 0 && crm.length == uf.length) {
                bui.append(" and ");
                if (crm.length > 1) {
                    bui.append('(');
                }
                bui.append("(a.med_conselho = '").append(conselho[0]);
                bui.append("' and a.med_crm = '").append(crm[0]);
                bui.append("' and a.med_uf = '").append(uf[0]).append("')");
                for (int i = 1; i < crm.length; ++i) {
                    bui.append(" or (a.med_conselho = '").append(conselho[i]);
                    bui.append("' and a.med_crm = '").append(crm[i]);
                    bui.append("' and a.med_uf = '").append(uf[i]).append("')");
                }
                if (crm.length > 1) {
                    bui.append(')');
                }
                bui.append(" \n");
            }
        } else {
            String asps = item == this.itemColeta || item == this.itemDestino ? "'" : "";
            String[] sel = item.getSelecionados(0);
            if (sel != null && sel.length > 0) {
                bui.append('(').append(asps).append(sel[0]).append(asps);
                for (int i = 1; i < sel.length; ++i) {
                    bui.append(", ").append(asps).append(sel[i]).append(asps);
                }
                bui.append(')');
            }
        }
        return bui.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validaRequisicao(Registro reg) {
        boolean retorno = true;
        Statement st = Conexao.getStatement();
        if (st != null) {
            block20: {
                try {
                    StringBuilder buf = new StringBuilder("select exa_codigo from examerequisicao where ");
                    if (ParametrosGerais.getConferencia()) {
                        buf.append("exr_dataassina is null and ");
                    } else {
                        buf.append("exr_datadigita is null and ");
                    }
                    buf.append(" exr_situacao <> '");
                    buf.append("A");
                    buf.append("' and fil_codigo = ");
                    buf.append(reg.getString("fil_codigo"));
                    buf.append(" and req_codigo = ");
                    buf.append(reg.getString("req_codigo"));
                    buf.append(" and exr_excluido = false ");
                    ResultSet tmp = Conexao.executeQuery(st, buf.toString());
                    if (tmp.next() && !reg.getBoolean("pri_separar") && !reg.getBoolean("req_imprimirseparado")) {
                        retorno = false;
                    }
                    if (ParametrosGerais.isAgruparImpressaoParcialPorData() && retorno) {
                        buf.delete(0, buf.length());
                        buf.append("select count(exa_codigo) as qtde, cast(exr_dataentregaprev as date) as data from examerequisicao ");
                        buf.append("where fil_codigo = ").append(reg.getString("fil_codigo"));
                        buf.append(" and req_codigo = ").append(reg.getString("req_codigo"));
                        buf.append(" and exr_dataimpresso is null ");
                        buf.append(" and exr_situacao != '").append("A").append("' ");
                        buf.append(" and exr_excluido = false ");
                        buf.append(" group by cast(exr_dataentregaprev as date) order by 2");
                        tmp = Conexao.executeQuery(st, buf);
                        HashMap<Date, Integer> contagem = new HashMap<Date, Integer>();
                        while (tmp.next()) {
                            contagem.put(tmp.getDate("data"), tmp.getInt("qtde"));
                        }
                        buf.delete(0, buf.length());
                        buf.append("select count(exa_codigo) as qtde, cast(exr_dataentregaprev as date) as data from examerequisicao ");
                        buf.append("where fil_codigo = ").append(reg.getString("fil_codigo"));
                        buf.append(" and req_codigo = ").append(reg.getString("req_codigo"));
                        buf.append(" and exr_dataimpresso is null and ");
                        if (ParametrosGerais.getConferencia()) {
                            buf.append("exr_dataassina is not null ");
                        } else {
                            buf.append("exr_datadigita is not null ");
                        }
                        buf.append(" and exr_situacao != '").append("A").append("' ");
                        buf.append(" and exr_excluido = false ");
                        buf.append(" group by cast(exr_dataentregaprev as date) order by 2");
                        tmp = Conexao.executeQuery(st, buf);
                        retorno = tmp.next();
                        if (!retorno) break block20;
                        retorno = false;
                        do {
                            int qtde;
                            if ((qtde = ((Integer)contagem.get(tmp.getDate("data"))).intValue()) != tmp.getInt("qtde")) continue;
                            retorno = true;
                            break block20;
                        } while (tmp.next());
                        break block20;
                    }
                    if (ParametrosGerais.isAgruparSetorImpressaoAutomatica() && retorno) {
                        buf.delete(0, buf.length());
                        buf.append("select count(a.exa_codigo) as qtde, b.set_codigo from examerequisicao a ");
                        buf.append("left join examesetor b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and b.ese_default = true ");
                        buf.append("where a.fil_codigo = ").append(reg.getString("fil_codigo"));
                        buf.append(" and a.req_codigo = ").append(reg.getString("req_codigo"));
                        buf.append(" and a.exr_dataimpresso is null ");
                        buf.append(" and a.exr_situacao != '").append("A").append("' ");
                        if (ParametrosGerais.getConferencia()) {
                            buf.append(" and a.exr_excluido = false ");
                        }
                        buf.append(" group by b.set_codigo order by 2");
                        tmp = Conexao.executeQuery(st, buf);
                        HashMap<Integer, Integer> contagem = new HashMap<Integer, Integer>();
                        while (tmp.next()) {
                            contagem.put(tmp.getInt("set_codigo"), tmp.getInt("qtde"));
                        }
                        buf.delete(0, buf.length());
                        buf.append("select count(a.exa_codigo) as qtde, b.set_codigo from examerequisicao a ");
                        buf.append("left join examesetor b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and b.ese_default = true ");
                        buf.append("where a.fil_codigo = ").append(reg.getString("fil_codigo"));
                        buf.append(" and a.req_codigo = ").append(reg.getString("req_codigo"));
                        buf.append(" and a.exr_dataimpresso is null and ");
                        if (ParametrosGerais.getConferencia()) {
                            buf.append("a.exr_dataassina is not null ");
                        } else {
                            buf.append("a.exr_datadigita is not null ");
                        }
                        buf.append(" and a.exr_situacao != '").append("A").append("' ");
                        buf.append(" and a.exr_excluido = false ");
                        buf.append(" group by b.set_codigo order by 2");
                        tmp = Conexao.executeQuery(st, buf);
                        retorno = tmp.next();
                        if (!retorno) break block20;
                        retorno = false;
                        do {
                            int qtde;
                            if ((qtde = ((Integer)contagem.get(tmp.getInt("set_codigo"))).intValue()) != tmp.getInt("qtde")) continue;
                            retorno = true;
                            break block20;
                        } while (tmp.next());
                        break block20;
                    }
                    if (!retorno) break block20;
                    buf.delete(0, buf.length());
                    buf.append("select exa_codigo from examerequisicao where ");
                    if (ParametrosGerais.getConferencia()) {
                        buf.append("exr_dataassina is not null and ");
                    }
                    buf.append("exr_dataimpresso is null and fil_codigo = ");
                    buf.append(reg.getString("fil_codigo"));
                    buf.append(" and req_codigo = ");
                    buf.append(reg.getString("req_codigo"));
                    buf.append(" and exr_excluido = false ");
                    tmp = Conexao.executeQuery(st, buf.toString());
                    if (tmp.next()) break block20;
                    retorno = false;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "FrmImpressaoAutomatica: 640");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    private void agruparRequisicoesPaciente(Registro[] regs) {
        block0: for (int i = 0; i < regs.length - 2; ++i) {
            int pac = regs[i].getInt("pac_codigo");
            for (int j = i + 1; j < regs.length; ++j) {
                if (pac != regs[j].getInt("pac_codigo")) continue;
                if (j <= i + 1) continue block0;
                Registro tmp = regs[j];
                System.arraycopy(regs, i + 1, regs, i + 2, j - i - 1);
                regs[i + 1] = tmp;
                continue block0;
            }
        }
    }

    private void habilitarDesabilitar(boolean valor) {
        this.buttonImprimir.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.buttonParar.setEnabled(!valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.itemColeta.setEnabled(valor);
        this.itemFilial.setEnabled(valor);
        this.itemSetor.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.itemGrupoExame.setEnabled(valor);
        if (!this.ocultarConvenio) {
            this.itemConvenio.setEnabled(valor);
        }
        this.itemDestino.setEnabled(valor);
        this.itemSituacao.setEnabled(valor);
        this.itemPrioridade.setEnabled(valor);
        this.itemMedico.setEnabled(valor);
        this.checkAutomatico.setEnabled(valor);
    }

    private void gravarParametros(boolean executarCommitParametros) {
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, this.getAtributos());
        ParametrosUsuarios.salvarParametros(executarCommitParametros);
    }

    private void carregarParametros() {
        this.setAtributos(ParametrosUsuarios.getValor(ULTIMO_FILTRO));
    }

    private String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("automatico", String.valueOf(this.checkAutomatico.isSelected())));
        bui.append(this.getAtributosFiltro(this.itemFilial, "filial"));
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemSetor, "setor"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        if (!this.ocultarConvenio) {
            bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        }
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemSituacao, "situacao"));
        bui.append(this.getAtributosFiltro(this.itemPrioridade, "prioridade"));
        bui.append(this.getAtributosFiltro(this.itemMedico, "medico"));
        bui.append(this.getAtributosFiltro(this.itemGrupoExame, "grupoexame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        return StringUtil.getTag("filtro", bui.toString());
    }

    private void setAtributos(String atr) {
        String str = StringUtil.getValor(atr, "filtro");
        if (StringUtil.getValor(str, "automatico").length() == 0) {
            this.checkAutomatico.setSelected(true);
        } else {
            this.checkAutomatico.setSelected(StringUtil.getBoolean(str, "automatico"));
        }
        this.setAtributosFiltro(this.itemFilial, StringUtil.getValor(str, "filial"));
        this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
        this.setAtributosFiltro(this.itemSetor, StringUtil.getValor(str, "setor"));
        this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
        if (!this.ocultarConvenio) {
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
        }
        this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
        this.setAtributosFiltro(this.itemSituacao, StringUtil.getValor(str, "situacao"));
        this.setAtributosFiltro(this.itemPrioridade, StringUtil.getValor(str, "prioridade"));
        this.setAtributosFiltro(this.itemMedico, StringUtil.getValor(str, "medico"));
        this.setAtributosFiltro(this.itemGrupoExame, StringUtil.getValor(str, "grupoexame"));
        this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
        this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        if (item == this.itemMedico) {
            bui.append(StringUtil.getTag("crm", item.getSelecionados(1)));
            bui.append(StringUtil.getTag("uf", item.getSelecionados(2)));
        }
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
            if (item == this.itemMedico) {
                item.setSelecionados(StringUtil.getValores(atributos, "crm"), 1);
                item.setSelecionados(StringUtil.getValores(atributos, "uf"), 2);
            }
        }
    }

    private void iniciar() {
        this.ocultarConvenio = Acesso.getAcesso(Long.valueOf("0400500120"));
        Laboratorio.getInstancia().addDisposeListener(this);
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Impress\u00e3o autom\u00e1tica", "Impress\u00e3o autom\u00e1tica de laudos", "recepcao/impressao_automatica.jpg");
        this.checkAutomatico.setMargin(new Insets(0, 0, 0, 0));
        this.textDataIni.setPreferredSize(new Dimension(10, 20));
        this.textDataFin.setPreferredSize(new Dimension(10, 20));
        Dimension dimensaoItem = new Dimension(186, 20);
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setMinimumSize(dimensaoItem);
        this.itemFilial.setPreferredSize(dimensaoItem);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setMinimumSize(dimensaoItem);
        this.itemColeta.setPreferredSize(dimensaoItem);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setMinimumSize(dimensaoItem);
        this.itemDestino.setPreferredSize(dimensaoItem);
        if (!this.ocultarConvenio) {
            this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            this.itemConvenio.setColunaHint(1);
            this.itemConvenio.setMinimumSize(dimensaoItem);
            this.itemConvenio.setPreferredSize(dimensaoItem);
        }
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setMinimumSize(dimensaoItem);
        this.itemSetor.setPreferredSize(dimensaoItem);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{80, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setMinimumSize(dimensaoItem);
        this.itemExame.setPreferredSize(dimensaoItem);
        this.itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, true);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(3);
        this.itemMedico.setMinimumSize(dimensaoItem);
        this.itemMedico.setPreferredSize(dimensaoItem);
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemSituacao.setMinimumSize(dimensaoItem);
        this.itemSituacao.setPreferredSize(dimensaoItem);
        this.itemPrioridade = new CheckItemFiltro("Prioridade", "Filtrar", "Filtrando prioridades", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPrioridade.setDados("prioridade", new String[]{"pri_codigo", "pri_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemPrioridade.setColunaHint(1);
        this.itemPrioridade.setMinimumSize(dimensaoItem);
        this.itemPrioridade.setPreferredSize(dimensaoItem);
        this.itemGrupoExame = new CheckItemFiltro("Grupo", "Filtrar", "Filtrando grupos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemGrupoExame.setDados("grupo", new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemGrupoExame.setColunaHint(1);
        this.itemGrupoExame.setMinimumSize(dimensaoItem);
        this.itemGrupoExame.setPreferredSize(dimensaoItem);
        JPanel panelDireita = new JPanel(new BorderLayout());
        this.add((Component)panelDireita, "Center");
        JPanel panelTemp = new JPanel(new GridBagLayout());
        panelTemp.setBorder(BorderFactory.createTitledBorder("Impress\u00e3o"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(0, 5, 5, 5);
        cons.gridx = 0;
        cons.gridy = 0;
        panelTemp.add((Component)new JLabel("Data:"), cons);
        cons.gridy = 1;
        panelTemp.add((Component)new JLabel("Requisi\u00e7\u00e3o:"), cons);
        cons.gridy = 2;
        panelTemp.add((Component)new JLabel("Paciente:"), cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.weightx = 0.5;
        panelTemp.add((Component)this.labelData, cons);
        cons.gridy = 1;
        panelTemp.add((Component)this.labelRequisicao, cons);
        cons.gridy = 2;
        panelTemp.add((Component)this.labelPaciente, cons);
        cons.weighty = 0.5;
        cons.gridwidth = 2;
        cons.gridx = 0;
        cons.gridy = 3;
        panelTemp.add((Component)this.labelMensagem, cons);
        cons.insets = new Insets(0, 0, 5, 5);
        cons.gridx = 1;
        cons.gridy = 4;
        cons.weighty = 0.0;
        panelTemp.add((Component)this.labelTempo, cons);
        cons.insets = new Insets(0, 0, 0, 0);
        cons.gridx = 0;
        cons.gridy = 5;
        panelTemp.add((Component)this.progress, cons);
        panelDireita.add((Component)panelTemp, "Center");
        panelTemp = new JPanel(new GridBagLayout());
        panelTemp.setBorder(BorderFactory.createTitledBorder("Hist\u00f3rico"));
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        this.areaHistorico.setEditable(false);
        panelTemp.add((Component)this.scrollHistorico, cons);
        Dimension dimensaoData = new Dimension(90, 20);
        Dimension dimensaoBotaoData = new Dimension(20, 20);
        panelTemp = new JPanel(new GridBagLayout());
        panelTemp.setBorder(BorderFactory.createTitledBorder("Filtro"));
        this.add((Component)panelTemp, "West");
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 3;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 0, 0, 0);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        if (this.filtrarFilial) {
            panelTemp.add((Component)this.itemFilial, cons);
            ++cons.gridy;
        }
        panelTemp.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemSetor, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemExame, cons);
        if (!this.ocultarConvenio) {
            ++cons.gridy;
            panelTemp.add((Component)this.itemConvenio, cons);
        }
        ++cons.gridy;
        panelTemp.add((Component)this.itemDestino, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemSituacao, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemPrioridade, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemMedico, cons);
        ++cons.gridy;
        panelTemp.add((Component)this.itemGrupoExame, cons);
        ++cons.gridy;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 1, 0, 0);
        panelTemp.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        this.textDataIni.setPreferredSize(dimensaoData);
        this.textDataIni.setMinimumSize(dimensaoData);
        panelTemp.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setFocusable(false);
        this.buttonDataIni.setPreferredSize(dimensaoBotaoData);
        this.buttonDataIni.setMinimumSize(dimensaoBotaoData);
        panelTemp.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelTemp.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        this.textDataFin.setPreferredSize(dimensaoData);
        this.textDataFin.setMinimumSize(dimensaoData);
        panelTemp.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataFin.setFocusable(false);
        this.buttonDataFin.setPreferredSize(dimensaoBotaoData);
        this.buttonDataFin.setMinimumSize(dimensaoBotaoData);
        panelTemp.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 3;
        panelTemp.add((Component)this.checkAutomatico, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        panelTemp.add((Component)new JLabel(), cons);
        ++cons.gridy;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.anchor = 13;
        panelTemp.add((Component)this.buttonImprimir, cons);
        panelTemp = new JPanel(new FlowLayout(2, 3, 3));
        panelTemp.add(this.buttonParar);
        panelTemp.add(this.buttonFechar);
        this.add((Component)panelTemp, "South");
        this.carregarParametros();
    }

    @Override
    @Deprecated
    public void addWindowListener(WindowListener l) {
    }

    @Override
    @Deprecated
    public void removeWindowListener(WindowListener l) {
    }
}

