/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.ids.DadosErrosIntegracaoIds;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tempuri.IDSIntLabProxy;
import org.tempuri.IDSIntLab___ImportarResultadosExames;
import org.tempuri.IDSIntLab___ImportarResultadosExamesResponse;
import org.tempuri.TResExa;
import org.tempuri.TResult;

public class IntegracaoIDSSaude {
    static final String CABECALHO = "cabecalho";
    static final String CODIGO_LAYOUT = "codigoLayout";
    static final String HISTORICOS = "historicos";
    static final String MEDICAMENTOS = "medicamentos";
    static final String CID10 = "cid10";
    static final String SEM_LAYOUT = "semLayout";
    static final String METODOLOGIA_EXAME = "metodologiaExame";
    public static final String MENSAGEM_RELACIONAMENTO = "O relacionamento com IDS Sa\u00fade n\u00e3o foi configurado.";
    private static DadosErrosIntegracaoIds dadosErrosIntegracaoIds = new DadosErrosIntegracaoIds();

    public StringBuilder enviaResultadoIdsSaude(int filial, int codigoIds, Registro dadosReq) {
        Statement st = ConexaoTemporaria.getStatement();
        StringBuilder erro = new StringBuilder();
        String mensagemErro = "";
        ArrayList<Registro> exames = new ArrayList<Registro>();
        if (!dadosReq.nulo("exame")) {
            exames.add((Registro)dadosReq.getValor("exame"));
        } else {
            exames.add(dadosReq);
        }
        if (exames == null || exames.size() == 0) {
            return erro;
        }
        String nomeProfissional = null;
        String cboProfissional = null;
        String confIntegracao = ParametrosGerais.getConfiguracaoIntegracaoIDS();
        String chaveAcesso = IntegracaoIDSSaude.getChaveAcessoIds(dadosReq.getString("fil_codigo"));
        String descricaoMetodoIds = null;
        if (!Funcoes.textoVazio(confIntegracao)) {
            confIntegracao = StringUtil.getValor(confIntegracao, "configuracaoIDS");
            nomeProfissional = StringUtil.getValor(confIntegracao, "nomeProf");
            cboProfissional = StringUtil.getValor(confIntegracao, "codCboProf");
        } else {
            mensagemErro = "As configura\u00e7\u00f5es padr\u00e3o da integra\u00e7\u00e3o com IDS Sa\u00fade n\u00e3o foram realizadas.";
            erro.append(mensagemErro);
            IntegracaoIDSSaude.dadosErrosIntegracaoIds.errosProcesso.add(IntegracaoIDSSaude.montaExcecao(null, "Erro", mensagemErro, null, null, null, null));
        }
        if (Funcoes.textoVazio(nomeProfissional)) {
            mensagemErro = "O nome do profissional executante n\u00e3o foi definido nas configura\u00e7\u00f5es padr\u00e3o da integra\u00e7\u00e3o com IDS Sa\u00fade.";
            erro.append("\n").append(mensagemErro);
            IntegracaoIDSSaude.dadosErrosIntegracaoIds.errosProcesso.add(IntegracaoIDSSaude.montaExcecao(null, "Erro", mensagemErro, null, null, null, null));
        }
        if (Funcoes.textoVazio(cboProfissional)) {
            mensagemErro = "A especialidade do profissional executante n\u00e3o foi definido nas configura\u00e7\u00f5es padr\u00e3o da integra\u00e7\u00e3o com IDS Sa\u00fade.";
            erro.append("\n").append(mensagemErro);
            IntegracaoIDSSaude.dadosErrosIntegracaoIds.errosProcesso.add(IntegracaoIDSSaude.montaExcecao(null, "Erro", mensagemErro, null, null, null, null));
        }
        String linkComunicacao = StringUtil.getValor(confIntegracao, "link");
        IDSIntLabProxy proxy = new IDSIntLabProxy();
        if (!Funcoes.textoVazio(linkComunicacao)) {
            proxy.setEndpoint(linkComunicacao);
        }
        TResExa[] listaResultadosExames = new TResExa[exames.size()];
        ArrayList<Registro> examesEnviados = new ArrayList<Registro>();
        int pos = 0;
        for (Registro exame : exames) {
            StringBuilder errosExames = new StringBuilder();
            String xmlAssociacao = ExameUtil.pegaRelacionamentoExportaTextoIdade(dadosReq.getString("fil_codigo"), dadosReq.getInt("req_idade"), dadosReq.getString("req_anomes"), dadosReq.getString(CODIGO_LAYOUT), exame.getString("exa_codigo"), Integer.parseInt(exame.getString("mco_codigo")), exame.getString("met_codigo"), st);
            if (Funcoes.textoVazio(xmlAssociacao)) {
                errosExames.append(MENSAGEM_RELACIONAMENTO + System.lineSeparator());
            } else if (Funcoes.textoVazio(xmlAssociacao = StringUtil.getValor(xmlAssociacao, "integracaoIDS"))) {
                errosExames.append(MENSAGEM_RELACIONAMENTO + System.lineSeparator());
            }
            Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado("" + exame.getValor("exr_resultado"), false);
            String[] camposAssociacao = StringUtil.getValores(xmlAssociacao, "campo");
            int qtdeCamposAssociacao = 0;
            int count = 0;
            ArrayList<String> campos = new ArrayList<String>();
            for (String aux : camposAssociacao) {
                ++count;
                if (Funcoes.textoVazio(StringUtil.getValor(aux, "campo_jalis"))) continue;
                campos.add(aux);
                ++qtdeCamposAssociacao;
            }
            if (qtdeCamposAssociacao == 0) {
                errosExames.append("O relacionamento de campos de resultado da integra\u00e7\u00e3o com IDS Sa\u00fade n\u00e3o foi configurado.\n");
            }
            TResult[] resultados = new TResult[qtdeCamposAssociacao];
            for (int i = 0; i < campos.size(); ++i) {
                TResult resultadoCampo;
                String auxAssociacao = (String)campos.get(i);
                String campoJalis = StringUtil.getValor(auxAssociacao, "campo_jalis");
                if (Funcoes.textoVazio(campoJalis)) {
                    errosExames.append("N\u00e3o h\u00e1 campo do jalis configurado para: ").append(auxAssociacao);
                    continue;
                }
                String valorResultado = "";
                if (mapaResultado.get(campoJalis.toLowerCase()) != null) {
                    valorResultado = !Funcoes.textoVazio(mapaResultado.get(campoJalis.toLowerCase()).toString()) && !mapaResultado.get(campoJalis.toLowerCase()).toString().equalsIgnoreCase("null") ? mapaResultado.get(campoJalis.toLowerCase()).toString() : "0";
                }
                int codigoCampoIDS = Integer.parseInt(StringUtil.getValor(auxAssociacao, "codigo_campo"));
                if (StringUtil.isEmpty(campoJalis)) continue;
                resultados[i] = resultadoCampo = new TResult(codigoCampoIDS, valorResultado, "");
            }
            if (!Funcoes.textoVazio(xmlAssociacao)) {
                int codigoExameIDS = Integer.parseInt(StringUtil.getValor(xmlAssociacao, "codigo_exame"));
                String siglaMaterialIds = StringUtil.getValor(xmlAssociacao, "sigla_material");
                String descricaoMaterialIds = StringUtil.getValor(xmlAssociacao, "descricao_material");
                if (Funcoes.textoVazio(descricaoMaterialIds)) {
                    descricaoMaterialIds = "";
                }
                int codigoMetodoIds = Integer.parseInt(StringUtil.getValor(xmlAssociacao, "codigo_metodologia"));
                descricaoMetodoIds = StringUtil.getValor(xmlAssociacao, "descricao_metodologia");
                if (!Funcoes.textoVazio(descricaoMetodoIds)) {
                    try {
                        descricaoMetodoIds = IntegracaoIDSSaude.buscaMetodo(descricaoMetodoIds, exame, dadosReq);
                    }
                    catch (SQLException e) {
                        errosExames.append("N\u00e3o h\u00e1 m\u00e9todo configurado para o exame: ").append(exame.getString("exa_codigo"));
                    }
                }
                listaResultadosExames[pos++] = new TResExa(codigoExameIDS, "", nomeProfissional, cboProfissional, siglaMaterialIds, descricaoMaterialIds, codigoMetodoIds, descricaoMetodoIds, resultados);
                examesEnviados.add(exame.clone());
            }
            if (errosExames == null || Funcoes.textoVazio(errosExames.toString())) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("Filial: ").append(dadosReq.getString("fil_codigo")).append(", ");
            buf.append("  - Requisic\u00e3o: ").append(dadosReq.getString("req_codigo")).append(", ");
            buf.append("\nConv\u00eanio: ").append(dadosReq.getString("con_codigo")).append(", ");
            buf.append("\nExame: ").append(exame.getString("exa_codigo")).append(", ");
            buf.append("\nmaterial: ").append(exame.getString("mco_codigo")).append(", ");
            buf.append("\nidade: ").append(dadosReq.getInt("req_idade")).append(" ").append(dadosReq.getString("req_anomes")).append(", ");
            buf.append("\nlayout: ").append(dadosReq.getString(CODIGO_LAYOUT)).append(", ");
            buf.append("\nmetodologia:").append(descricaoMetodoIds).append(".");
            buf.append("\nErros:\n");
            buf.append(errosExames.toString());
            IntegracaoIDSSaude.atualizarLog(st, codigoIds, buf.toString(), true, "R");
            erro.append(buf.toString());
            IntegracaoIDSSaude.dadosErrosIntegracaoIds.errosProcesso.add(IntegracaoIDSSaude.montaExcecao(null, "Erro", buf.toString(), null, null, null, null));
            buf.setLength(0);
            errosExames.setLength(0);
        }
        if (!examesEnviados.isEmpty()) {
            IDSIntLab___ImportarResultadosExames enviarResultado = new IDSIntLab___ImportarResultadosExames(chaveAcesso, StringUtil.preencheString(dadosReq.getString("req_codigoapoiado"), 13, '0', 1), listaResultadosExames);
            IDSIntLab___ImportarResultadosExamesResponse resposta = new IDSIntLab___ImportarResultadosExamesResponse();
            try {
                resposta = proxy.importarResultadosExames(enviarResultado);
            }
            catch (Exception e) {
                examesEnviados.forEach(exa -> {
                    StringBuilder bui = new StringBuilder();
                    bui.append(e.getMessage());
                    erro.append(e.getMessage());
                    IntegracaoIDSSaude.atualizarLog(st, codigoIds, erro.toString(), true, "R");
                });
            }
            if (null != resposta && null != resposta.getResult()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Filial: ").append(dadosReq.getString("fil_codigo"));
                buf.append("  - Requisi\u00e7\u00e3o: ").append(dadosReq.getString("req_codigo")).append(", ");
                buf.append("\nConv\u00eanio: ").append(dadosReq.getString("con_codigo")).append(", ");
                buf.append("\nidade: ").append(dadosReq.getInt("req_idade")).append(" ").append(dadosReq.getString("req_anomes")).append(", ");
                buf.append("\nlayout: ").append(dadosReq.getString(CODIGO_LAYOUT)).append(",");
                for (Registro exa2 : examesEnviados) {
                    buf.append("\nExame: ").append(exa2.getString("exa_codigo")).append(", ");
                    buf.append("\nmaterial: ").append(exa2.getString("mco_codigo")).append(", ");
                    buf.append("\nmetodologia: ").append(descricaoMetodoIds).append(".\n");
                    buf.append(resposta.getResult());
                    IntegracaoIDSSaude.atualizarLog(st, codigoIds, buf.toString(), true, "E");
                }
            }
        }
        return erro;
    }

    private static boolean mensagemCorreta(String mensagem) {
        return mensagem.toUpperCase().indexOf("Resultado Importado".toUpperCase()) > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buscaMetodo(String descricaoMetodoIds, Registro exame, Registro dadosReq) throws SQLException {
        String[] componente;
        String xmlLaudo = "";
        String metodo = "";
        Statement st = ConexaoTemporaria.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select elm_formato from examelayoutmetodo where fil_codigo = ").append(dadosReq.getString("fil_codigo"));
        buf.append(" and exa_codigo = '").append(exame.getString("exa_codigo")).append("'");
        buf.append(" and lay_codigo = ").append(dadosReq.getString(CODIGO_LAYOUT));
        buf.append(" and met_codigo = ").append(exame.getString("met_codigo"));
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                xmlLaudo = rs.getString("elm_formato");
            }
        }
        for (String campoSelecionado : componente = StringUtil.getValores(xmlLaudo, "componente")) {
            if (!StringUtil.getValor(campoSelecionado, "nome").equalsIgnoreCase(descricaoMetodoIds)) continue;
            metodo = StringUtil.getValor(campoSelecionado, "texto");
            break;
        }
        return metodo;
    }

    public static Registro getCodigoIDS(String fil_codigo, String req_codigo) throws Exception {
        if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo)) {
            throw new Exception("Requisi\u00e7\u00e3o n\u00e3o localizada. Filial: " + (fil_codigo == null ? "null" : fil_codigo) + ", Requisi\u00e7\u00e3o: " + (req_codigo == null ? "null" : req_codigo) + ".");
        }
        StringBuilder query = new StringBuilder();
        query.append("select req_codigoapoiado, req_xmlagendamentoids");
        query.append("  FROM requisicao a ");
        query.append(" WHERE a.fil_codigo = ? ");
        query.append("   AND a.req_codigo = ? ");
        PreparedStatement ps = ConexaoTemporaria.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(fil_codigo));
        ps.setInt(2, Integer.parseInt(req_codigo));
        ResultSet rs = ConexaoTemporaria.executeQuery(ps);
        Registro reg = null;
        if (rs.next()) {
            reg = new Registro(rs);
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(ps);
        return reg;
    }

    public static boolean temCodigoIDS(String fil_codigo, String req_codigo) throws Exception {
        boolean retorno = false;
        if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo)) {
            return retorno;
        }
        StringBuilder query = new StringBuilder();
        query.append("select req_xmlagendamentoids");
        query.append("  FROM requisicao a ");
        query.append(" WHERE a.fil_codigo = ? ");
        query.append("   AND a.req_codigo = ? ");
        PreparedStatement ps = ConexaoTemporaria.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(fil_codigo));
        ps.setInt(2, Integer.parseInt(req_codigo));
        ResultSet rs = ConexaoTemporaria.executeQuery(ps);
        if (rs.next()) {
            retorno = !Funcoes.textoVazio(rs.getString(1));
        }
        rs.close();
        ConexaoTemporaria.fecharStatement(ps);
        return retorno;
    }

    private static void gravaLog_(Statement st, Registro dadosReq, Registro exame, StringBuilder erro, boolean isCorrigido) {
        StringBuilder buf = new StringBuilder();
        boolean falha = null == erro || erro.toString().toUpperCase().indexOf("Resultado Importado".toUpperCase()) < 0;
        buf.append("insert into logids (ids_datahora, ids_mensagem, ids_exportado, usr_codigo, fil_codigo, exa_codigo, mco_codigo, req_codigo, ids_falha) values (");
        buf.append("current_timestamp");
        buf.append(", ").append(StringUtil.textoDBEscape(erro.toString()));
        buf.append(", ").append(false);
        buf.append(", ").append("'").append(Variaveis.login).append("'");
        buf.append(", ").append(dadosReq.getString("fil_codigo"));
        buf.append(", ").append("'").append(exame.getString("exa_codigo")).append("'");
        buf.append(", ").append(exame.getString("mco_codigo"));
        buf.append(", ").append(dadosReq.getString("req_codigo"));
        buf.append(", ").append(falha);
        buf.append(")");
        try {
            ConexaoTemporaria.execute(st, buf.toString());
            ConexaoTemporaria.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ConexaoTemporaria.anulaSQL();
                erro.append("N\u00e3o foi poss\u00edvel inserir o log.\n").append(e.getMessage()).append("\n").append(e.getStackTrace());
            }
            catch (SQLException e1) {
                erro.append("N\u00e3o foi poss\u00edvel anular a inser\u00e7\u00e3o do log.\n").append(e.getMessage()).append("\n").append(e.getStackTrace());
            }
        }
    }

    private static ArrayList<Registro> getDadosExamesConferidos(Statement st, String codigoFilial, String codigoRequisicao) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append(" select exa_codigo ");
        bui.append("       ,mco_codigo ");
        bui.append("       ,met_codigo ");
        bui.append("       ,pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
        bui.append("   from examerequisicao ");
        bui.append("  where fil_codigo = ").append(codigoFilial);
        bui.append("    and req_codigo = ").append(codigoRequisicao);
        bui.append("    and not exr_excluido ");
        bui.append("    and exr_situacao IN ('").append("C").append("', '").append("I").append("', '").append("E").append("') ");
        ArrayList<Registro> exames = new ArrayList<Registro>();
        ResultSet rs = ConexaoTemporaria.executeQuery(st, bui.toString());
        while (rs.next()) {
            exames.add(Registro.novoRegistro(new Object[]{"exa_codigo", rs.getString("exa_codigo"), "mco_codigo", rs.getString("mco_codigo"), "met_codigo", rs.getString("met_codigo"), "exr_resultado", rs.getString("exr_resultado")}));
        }
        rs.close();
        return exames;
    }

    public static String getChaveAcessoIds(String codigoFilial) {
        String confIntegracao = ParametrosGerais.getConfiguracaoIntegracaoIDS();
        if (!Funcoes.textoVazio(confIntegracao)) {
            String xmlChaves;
            String[] chaves;
            String chaveAcesso = StringUtil.getValor(ParametrosGerais.getConfiguracaoIntegracaoIDS(), "chaveAcesso");
            if (confIntegracao.indexOf("chavesAcesso") > -1 && (chaves = StringUtil.getValores(xmlChaves = StringUtil.getValor(confIntegracao, "chavesAcesso"), "dadoFilial")) != null && chaves.length > 0) {
                for (String chave : chaves) {
                    if (Funcoes.textoVazio(chave)) continue;
                    String filial = StringUtil.getValor(chave, "codigoFilial");
                    String ch = StringUtil.getValor(chave, "chaveAcesso");
                    if (!filial.equals(codigoFilial)) continue;
                    chaveAcesso = ch;
                    break;
                }
            }
            return chaveAcesso;
        }
        return null;
    }

    public static String getLinkComunicacaoIDS() {
        String linkComunicacao;
        String confIntegracao = ParametrosGerais.getConfiguracaoIntegracaoIDS();
        if (!Funcoes.textoVazio(confIntegracao) && !Funcoes.textoVazio(linkComunicacao = StringUtil.getValor(confIntegracao, "link"))) {
            return linkComunicacao;
        }
        return null;
    }

    private static IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls, String codigoFilialLog, Long codigoLog) {
        String tmp;
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception != null && exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null) {
            buf.append("\n").append(exception.toString());
            if (exception instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        StringBuilder xmlAux = new StringBuilder();
        if (xmls != null) {
            for (String aux : xmls) {
                if (!Funcoes.textoVazio(xmlAux.toString())) {
                    xmlAux.append("\n\n");
                }
                xmlAux.append(aux);
            }
        }
        if ((tmp = codigoFilialLog) == null || Funcoes.isNumeric(tmp)) {
            tmp = "1";
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, Integer.valueOf(tmp), codigoLog, null, buf.toString(), xmlAux.toString(), null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    public DadosErrosIntegracaoIds getDadosErrosIntegracaoIds() {
        return dadosErrosIntegracaoIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Registro carregarDados(String codigoFilial, String codigoRequisicao, String exame, String material) {
        Registro dadosReq = null;
        PreparedStatement pst = null;
        try {
            StringBuilder bui = new StringBuilder("select ");
            bui.append("a.req_data,a.fil_codigo, a.req_codigo, a.req_guia, a.req_dum, a.req_idade, a.req_anomes, a.req_deveguia, a.des_codigo, a.req_obs, a.req_dclinicos, a.req_sanitariasproduto, ");
            bui.append("b.pac_codigo, b.pac_nome, b.pac_datanasc, b.pac_sexo, a.req_integracaohospital, ");
            bui.append("c.med_crm, c.med_nome, c.med_conselho, c.med_uf, c.med_cbo,");
            bui.append("d.con_codigo, d.con_fantasia, d.con_nr1via, ");
            bui.append("e.des_naoimprimir, e.des_impressora, e.des_descricao, ");
            bui.append("f.pri_impressora, a.req_perguntas, d.con_perguntarpercbalcao, ");
            bui.append("a.req_descricaoproduto, a.req_areaproduto, a.req_datarecebimentoproduto, ");
            bui.append("b.pac_sif, a.req_lacreproduto, a.req_localcoletaproduto, a.req_numeroloteproduto, a.req_datafabricacao ");
            bui.append(", (a.req_total - a.req_totpago) as ").append("saldo_devedor").append(", a.req_codigoapoiado, ");
            bui.append(" a.req_xmlagendamentoids as xmlagendamentoids, ");
            bui.append(" g.col_marcarexterno as marcarExterno ");
            bui.append(", a.req_codigoipm as codigoIpm");
            bui.append(ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SALUX ? ", a.req_idsolicitacaosalux " : "");
            bui.append(" from requisicao a left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            bui.append(" left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ");
            bui.append(" left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            bui.append(" left join coletas g on a.fil_codigo = g.fil_codigo and a.col_codigo = g.col_codigo ");
            bui.append(" left join destino e on a.fil_codigo = e.fil_codigo and a.des_codigo = e.des_codigo ");
            bui.append(" left join prioridade f on d.fil_codigo = f.fil_codigo and d.pri_codigo = f.pri_codigo ");
            bui.append(" where a.req_codigo = ").append(codigoRequisicao);
            bui.append(" and a.fil_codigo = ").append(codigoFilial);
            bui.append(" and a.req_excluida = false ");
            pst = ConexaoTemporaria.getPreparedStatement(bui.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(pst);
            if (rs.next()) {
                dadosReq = new Registro(rs);
                dadosReq.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(codigoFilial, rs.getString("con_codigo"), rs.getString("des_codigo")));
                dadosReq.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(codigoFilial, dadosReq.getString(CODIGO_LAYOUT)));
                dadosReq.setValor(HISTORICOS, ExameUtil.getHistoricos(null, codigoFilial));
                dadosReq.setValor(MEDICAMENTOS, IntegracaoIDSSaude.getMedicamentosRequisicao(codigoFilial, codigoRequisicao));
                dadosReq.setValor(CID10, IntegracaoIDSSaude.getCID10Requisicao(codigoFilial, codigoRequisicao));
                dadosReq.setValor("codigoDestino", rs.getString("des_codigo"));
                dadosReq.setValor("saldo_devedor", rs.getFloat("saldo_devedor") > 0.0f);
                dadosReq.setValor("codigoIpm", rs.getString("codigoIpm"));
                dadosReq.setValor("exame", IntegracaoIDSSaude.carregarExames(codigoFilial, codigoRequisicao, exame, material, rs.getString("con_codigo"), rs.getString("des_codigo"), rs.getInt("req_idade"), rs.getString("req_anomes")));
            }
            rs.close();
            if (pst == null) return dadosReq;
        }
        catch (Exception e) {
            e.printStackTrace();
            return dadosReq;
        }
        finally {
            if (pst != null) {
                ConexaoTemporaria.fecharStatement(pst);
            }
        }
        ConexaoTemporaria.fecharStatement(pst);
        return dadosReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ModeloResultSet getMedicamentosRequisicao(String filial, String requisicao) {
        ModeloResultSet modelo = new ModeloResultSet("Medicamento", "mto_descricao", "Dosagem", "rem_dosagem", "Data", "rem_datadose", "Hora", "rem_horadose");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select a.rem_dosagem, a.rem_datadose, a.rem_horadose, b.mto_descricao, b.mto_indicacao, b.mto_interacao ");
                bui.append("from requisicaomedicamento a ");
                bui.append("left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo ");
                bui.append("where a.fil_codigo = ").append(filial);
                bui.append(" and a.req_codigo = ").append(requisicao);
                rs = ConexaoTemporaria.executeQuery(st, bui);
                modelo.carregarDeResultSet(rs);
                SimpleDateFormat data = new SimpleDateFormat("dd/MM/yyyy");
                SimpleDateFormat hora = new SimpleDateFormat("HH:mm");
                Iterator<Registro> iterator = modelo.getRegistros().iterator();
                while (iterator.hasNext()) {
                    Registro reg;
                    Date d = (reg = iterator.next()).getDate("rem_datadose");
                    reg.setValor("rem_datadose", d != null ? data.format(d) : "");
                    d = reg.getDate("rem_horadose");
                    reg.setValor("rem_horadose", d != null ? hora.format(d) : "");
                }
                rs.close();
            }
            catch (Exception exception) {
                ConexaoTemporaria.fecharResultSet(rs);
                ConexaoTemporaria.fecharStatement(st);
                catch (Throwable throwable) {
                    ConexaoTemporaria.fecharResultSet(rs);
                    ConexaoTemporaria.fecharStatement(st);
                    throw throwable;
                }
            }
            ConexaoTemporaria.fecharResultSet(rs);
            ConexaoTemporaria.fecharStatement(st);
        }
        return modelo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModeloResultSet getCID10Requisicao(String filial, String requisicao) {
        ModeloResultSet modelo;
        block6: {
            modelo = new ModeloResultSet("C\u00f3digo", "c10_codigo", "Descri\u00e7\u00e3o", "c10_descricao");
            Statement st = ConexaoTemporaria.getStatement();
            ResultSet rs = null;
            if (st != null) {
                try {
                    StringBuilder bui = new StringBuilder("select a.c10_codigo, b.c10_descricao ");
                    bui.append("from requisicaocid10 a ");
                    bui.append("left join cid10 b on a.c10_codigo = b.c10_codigo ");
                    bui.append("where a.fil_codigo = ").append(filial);
                    bui.append(" and a.req_codigo = ").append(requisicao);
                    rs = ConexaoTemporaria.executeQuery(st, bui);
                    modelo.carregarDeResultSet(rs);
                    ConexaoTemporaria.fecharResultSet(rs);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel localizar os dados do cid10 da requisi\u00e7\u00e3o " + requisicao, e.getStackTrace());
                    break block6;
                }
                finally {
                    ConexaoTemporaria.fecharResultSet(rs);
                    ConexaoTemporaria.fecharStatement(st);
                }
                ConexaoTemporaria.fecharStatement(st);
            }
        }
        return modelo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Registro carregarExames(String codigoFilial, String codigoRequisicao, String exame, String material, String convenio, String destino, int idade, String anoMes) {
        Registro retorno;
        block10: {
            retorno = null;
            PreparedStatement pst = null;
            Statement stTemp = ConexaoTemporaria.getStatement();
            ResultSet rs = null;
            try {
                StringBuilder bui = new StringBuilder("select ");
                bui.append("  a.exr_situacao, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_resposta, a.exr_datadigita, a.exr_dataassina, a.exr_dataimpresso, a.exr_dataentreguerst, ");
                bui.append("  a.exr_datamaterial, a.exr_vlrexame, a.exr_vlrmaterial, a.exr_descricaomaterial, a.exr_naofaturar, ");
                bui.append("  a.usr_coddigitador, a.usr_codassina, a.usr_codimpressao, a.usr_codentrega, coalesce(a.exr_obs, '') as exr_obs, a.exr_ordem, coalesce(a.exr_motivocoletaincorreta, '') as exr_motivocoletaincorreta, a.exr_coletaincorreta,");
                bui.append("  usr_codtrocalayout, exr_datatrocalayout, ");
                bui.append("  (a.exr_datafatura is not null or a.exr_datafaturarepasse is not null) as faturado, ");
                bui.append("  (select count(exa_codigo) from examerequisicaohistoricolaudo where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo) as laudoretificado, ");
                bui.append(" a.exr_datafatura, a.usr_codfatura, a.exr_datafaturarepasse, a.usr_codfaturarepasse, ");
                bui.append("  b.exa_codigo, b.exa_descricao, b.exa_salvaparcial, ");
                bui.append("  c.mco_codigo, c.mco_descricao, c.mco_abreviatura, c.mco_solicitarmat, ");
                bui.append("  d.prz_codigo, d.emc_solicitarjejum, d.emc_obrigavolume, d.emc_obrigatempodiurese, ");
                bui.append("  d.emc_pagina, d.emc_ordem, b.exa_soa, b.exa_coa, b.exa_inmetro, s.set_descricao, ");
                bui.append("  a.exr_datarepeticao, a.usr_codrepeticao, a.exr_motivorecoleta ");
                bui.append(" ,coalesce(a.met_codigo, d.met_codigo) as met_codigo ");
                bui.append(" ,a.usr_codtransportechegada, a.exr_datatransportechegada, a.req_codigo, a.fil_codigo, mr.mrc_descricao, a.exr_resultadoempdf, a.exr_notificacao, b.exa_corponotificacao, b.exa_cabecalhonotificacao ");
                bui.append(" , b.exa_importarpdf, (select distinct lae.lae_protocolo from labexterno lae join loteexternoexamerequisicao lte on lae.fil_codigo = lte.fil_codigo and lae.lae_codigo=lte.lae_codigo where lte.fil_codigo = a.fil_codigo and lte.req_codigo = a.req_codigo and lte.exa_codigo = a.exa_codigo  and  lte.mco_codigo = a.mco_codigo) as lae_protocolo ");
                bui.append(ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SALUX ? " , a.exr_sequencialsalux " : "");
                bui.append("from examerequisicao a ");
                bui.append("left join exames b on  a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                bui.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo \n");
                bui.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                bui.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true \n");
                bui.append("left join setores s on e.fil_codigo = s.fil_codigo and e.set_codigo = s.set_codigo ");
                bui.append("left join motivorecoleta mr on a.fil_codigo = mr.fil_codigo and a.mrc_codigo = mr.mrc_codigo ");
                bui.append("where ");
                bui.append("  a.fil_codigo = ").append(codigoFilial);
                bui.append(" and a.req_codigo = ").append(codigoRequisicao);
                bui.append(" and a.exr_excluido = false ");
                if (!Funcoes.textoVazio(exame)) {
                    bui.append(" and a.exa_codigo = ").append(StringUtil.textoDBEscape(exame));
                }
                if (Funcoes.isNumeric(material)) {
                    bui.append(" and a.mco_codigo = ").append(material);
                }
                if ((rs = ConexaoTemporaria.executeQuery(pst = ConexaoTemporaria.getPreparedStatement(bui.toString()))).next()) {
                    Registro reg = new Registro(rs);
                    Registro tmp = IntegracaoIDSSaude.selecionarExameDoPaciente(codigoFilial, codigoRequisicao, convenio, destino, exame, material, rs.getInt("met_codigo"), idade, anoMes);
                    if (tmp != null) {
                        reg.carregar(tmp);
                    } else {
                        reg.setValor("exr_situacao", SEM_LAYOUT);
                    }
                    reg.setValor(METODOLOGIA_EXAME, rs.getInt("met_codigo"));
                    retorno = reg;
                }
                ConexaoTemporaria.fecharStatement(stTemp);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block10;
            }
            finally {
                ConexaoTemporaria.fecharStatement(stTemp);
                ConexaoTemporaria.fecharStatement(pst);
            }
            ConexaoTemporaria.fecharStatement(pst);
        }
        return retorno;
    }

    private static Registro selecionarExameDoPaciente(String filial, String requisicao, String convenio, String destino, String exame, String material, Integer codigoMetodologia, int idade, String anoMes) {
        Registro reg = new Registro();
        String lay_codigo = ExameUtil.getCodigoLayout(filial, convenio, destino);
        String elm_formato = ExameUtil.pegaLayoutIdade(filial, idade, anoMes, lay_codigo, exame, Integer.parseInt(material), codigoMetodologia, "elm_formato", reg);
        return reg;
    }

    public static void inserirLogComValidacao(Statement st, int filial, int requisicao, int idade, String tipoIdade, String exame, int material, String codLayout, String codMetodologia) throws SQLException {
        String modelo = ExameUtil.pegaRelacionamentoExportaTextoIdade(String.valueOf(filial), idade, tipoIdade, codLayout, exame, material, codMetodologia, st);
        String situacao = !Funcoes.textoVazio(modelo) && modelo.contains("integracaoIDS") ? "" : "N";
        String mensagem = situacao.equals("N") ? MENSAGEM_RELACIONAMENTO : "";
        IntegracaoIDSSaude.inserirLog(st, filial, requisicao, exame, material, mensagem, situacao);
    }

    public static void inserirLog(Statement st, int filial, int requisicao, String exame, int material, String mensagem, String situacao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into logids (ids_datahora, ids_mensagem, ids_exportado, usr_codigo, fil_codigo, exa_codigo, mco_codigo, req_codigo, ids_situacao) values (");
        buf.append("current_timestamp");
        buf.append(", ").append(StringUtil.textoDBEscape(mensagem));
        buf.append(", ").append(false);
        buf.append(", ").append("'").append(Variaveis.login).append("'");
        buf.append(", ").append(filial);
        buf.append(", ").append(StringUtil.textoDBEscape(exame));
        buf.append(", ").append(material);
        buf.append(", ").append(requisicao);
        buf.append(", ").append(StringUtil.textoDBEscape(situacao));
        buf.append(")");
        st.execute(buf.toString());
    }

    private static boolean comFalha(String mensagem) {
        return null == mensagem || mensagem.toString().toUpperCase().indexOf("Resultado Importado".toUpperCase()) < 0;
    }

    public static void atualizarLog(Statement st, int codigoLog, String mensagem, boolean exportado, String situacao) {
        StringBuilder buf = new StringBuilder();
        buf.append("update logids set ");
        buf.append("ids_mensagem = ").append(StringUtil.textoDBEscape(mensagem));
        buf.append(", ids_exportado = ").append(exportado);
        buf.append(", ids_situacao = ").append(StringUtil.textoDBEscape(situacao));
        buf.append(", ids_datahoraexportado = ").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd kk:mm:ss", new Date())));
        buf.append(" where ids_codigo = ").append(codigoLog);
        try {
            st.execute(buf.toString());
        }
        catch (Exception e) {
            IntegracaoIDSSaude.dadosErrosIntegracaoIds.errosProcesso.add(IntegracaoIDSSaude.montaExcecao(null, "Erro", "N\u00e3o foi poss\u00edvel atualizar o log de envio do RNDS", null, null, null, null));
        }
    }

    public static void adicionarLog(Statement st, int filial, int requisicao, String exame, int material) throws SQLException {
        IntegracaoIDSSaude.inserirLog(st, filial, requisicao, exame, material, "", "");
    }
}

