/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import br.com.thread.openpdf.text.Document;
import br.com.thread.openpdf.text.DocumentException;
import br.com.thread.openpdf.text.Rectangle;
import br.com.thread.openpdf.text.pdf.DefaultFontMapper;
import br.com.thread.openpdf.text.pdf.FontMapper;
import br.com.thread.openpdf.text.pdf.PdfContentByte;
import br.com.thread.openpdf.text.pdf.PdfGraphics2D;
import br.com.thread.openpdf.text.pdf.PdfImportedPage;
import br.com.thread.openpdf.text.pdf.PdfReader;
import br.com.thread.openpdf.text.pdf.PdfSmartCopy;
import br.com.thread.openpdf.text.pdf.PdfTemplate;
import br.com.thread.openpdf.text.pdf.PdfWriter;
import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.printing.Orientation;
import br.com.thread.pdfbox.printing.PDFPageable;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.configurador.pagina.DimensoesAssinaturaDigitalDTO;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.resultados.ExamesImpressos;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.resultados.assinaturadigital.DadosAssinaturaDigitalDTO;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.ImprimirCapaLaudo;
import jalis.laboratorio.util.impressao.ImprimirEtiquetaLaudo;
import jalis.model.vo.resultado.RequisicaoPaginasImpressasVO;
import jalis.relatorio.gerador.DialogoImpressao;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.service.resultados.RequisicaoPaginasImpressasService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.OtimizadorImagensPDF;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONException;
import org.json.JSONObject;

public class ImpressaoResultados {
    private static String impressoraSelecionada;
    static final String DATA = "data";
    static final String SITUACAO = "situacao";
    static final String LAUDO_IMPRESSO = "laudo_impresso";
    static final String MAPA_IMPRESSO = "mapa_impresso";
    static final String SALDO_DEVEDOR = "saldo_devedor";
    static final String LANCADO = "lancado";
    static final String CONFERIDO = "conferido";
    static final String IMPRESSO = "impresso";
    static final String ENTREGUE = "entregue";
    static final String SEM_RESULTADO = "sem_resultado";
    static final String MULTIGUIA = "multiguia";
    static final String SELECT_REQUISICAO;
    static final String SELECT_EXAME;
    static final DefaultFontMapper mapper;
    static String razaoAssinatura;

    static String getSelectRequisicaoExame(String filial, String filtro, Integer codigoRequisicao, boolean filtrarSetor) {
        return ImpressaoResultados.getSelectRequisicaoExame(filial, filtro, codigoRequisicao, filtrarSetor, false);
    }

    static String getSelectRequisicaoExame(String filial, String filtro, Integer codigoRequisicao, boolean filtrarSetor, boolean ordenarPorNomePaciente) {
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, (a.req_total - a.req_totpago > 0 or a.req_deveguia = true) as ").append(SALDO_DEVEDOR).append(", \n");
        bui.append("  b.con_codigo, a.req_imprimirseparado, \n");
        bui.append("  c.des_codigo, c.des_naoimprimir, c.des_impressora, \n");
        bui.append("  g.pac_codigo, g.pac_nome, \n");
        bui.append("  h.pri_separar, h.pri_impressora, \n");
        bui.append("  (i.exr_datamapa is not null) as ").append(MAPA_IMPRESSO);
        bui.append("  ,i.exr_situacao = '").append("E").append("' as ").append(ENTREGUE);
        bui.append("  ,i.exr_situacao = '").append("I").append("' as ").append(IMPRESSO);
        bui.append("  ,i.exr_situacao = '").append("C").append("' as ").append(CONFERIDO);
        bui.append("  ,i.exr_situacao = '").append("L").append("' as ").append(LANCADO);
        bui.append("  ,trim(coalesce(i.exr_situacao, '')) = '' as ").append(SEM_RESULTADO);
        bui.append(" \nfrom requisicao a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo \n");
        bui.append("left join destino c on a.fil_codigo = c.fil_codigo and upper(a.des_codigo) = upper(c.des_codigo) \n");
        bui.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf \n");
        bui.append("left join situacao e on a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo \n");
        bui.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) \n");
        bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo \n");
        bui.append("left join prioridade h on a.fil_codigo = h.fil_codigo and b.pri_codigo = h.pri_codigo \n");
        bui.append("left join examerequisicao i on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo \n");
        if (filtrarSetor) {
            bui.append("left join examesetor set on i.fil_codigo = set.fil_codigo and i.exa_codigo = set.exa_codigo and set.ese_default = true ");
        }
        bui.append("where ");
        if (filial.matches("\\-?\\d+")) {
            bui.append("a.fil_codigo = ");
        }
        bui.append(filial);
        if (filtro != null) {
            if (filtro.trim().length() == 0) {
                bui.append(" \n");
            } else {
                bui.append(" and ").append(filtro).append(" \n");
            }
            if (codigoRequisicao != null) {
                bui.append(" and a.req_codigo = ").append(codigoRequisicao);
            }
        } else {
            bui.append(" and a.req_codigo = ").append(codigoRequisicao);
        }
        bui.append(" and a.req_excluida = false and i.exr_excluido = false and i.exr_situacao <> '").append("A").append("' ");
        bui.append("group by \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_total, a.req_totpago, a.req_deveguia, b.con_codigo, \n");
        bui.append("  c.des_codigo, c.des_naoimprimir, c.des_impressora, g.pac_codigo, g.pac_nome, h.pri_separar, a.req_imprimirseparado, \n");
        bui.append("  h.pri_impressora, impresso, ").append(MAPA_IMPRESSO).append(", ").append(LANCADO).append(" \n");
        bui.append(" ,i.exr_situacao ");
        bui.append("order by \n");
        if (ordenarPorNomePaciente) {
            bui.append(" upper(g.pac_nome) ");
        } else {
            bui.append(" a.req_codigo, a.req_data");
        }
        return bui.toString();
    }

    static String getSelectRequisicaoExameMapa(String filial, String filtro, String reqMult, boolean filtrarSetor, String codigoRequisicao, boolean ordenarPorNomePaciente) {
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, (a.req_total - a.req_totpago > 0 or a.req_deveguia = true) as ").append(SALDO_DEVEDOR).append(", \n");
        bui.append("  b.con_codigo, a.req_imprimirseparado, \n");
        bui.append("  c.des_codigo, c.des_naoimprimir, c.des_impressora, \n");
        bui.append("  g.pac_codigo, g.pac_nome, \n");
        bui.append("  h.pri_separar, h.pri_impressora, \n");
        bui.append("  (i.exr_datamapa is not null) as ").append(MAPA_IMPRESSO);
        bui.append("  ,i.exr_situacao = '").append("E").append("' as ").append(ENTREGUE);
        bui.append("  ,i.exr_situacao = '").append("I").append("' as ").append(IMPRESSO);
        bui.append("  ,i.exr_situacao = '").append("C").append("' as ").append(CONFERIDO);
        bui.append("  ,i.exr_situacao = '").append("L").append("' as ").append(LANCADO);
        bui.append("  ,trim(coalesce(i.exr_situacao, '')) = '' as ").append(SEM_RESULTADO);
        if (reqMult == null) {
            bui.append(", \n  (count(j.req_kodigo) > 0) as ").append(MULTIGUIA);
        }
        bui.append(" \nfrom requisicao a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo \n");
        bui.append("left join destino c on a.fil_codigo = c.fil_codigo and a.des_codigo = c.des_codigo \n");
        bui.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and a.med_crm = d.med_crm and a.med_uf = d.med_uf \n");
        bui.append("left join situacao e on a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo \n");
        bui.append("left join coletas f on a.fil_codigo = f.fil_codigo and a.col_codigo = f.col_codigo \n");
        bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo \n");
        bui.append("left join prioridade h on a.fil_codigo = h.fil_codigo and b.pri_codigo = h.pri_codigo \n");
        bui.append("left join examerequisicao i on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo \n");
        bui.append("left join examematcoleta u on i.fil_codigo = u.fil_codigo and i.exa_codigo = u.exa_codigo and i.mco_codigo = u.mco_codigo \n");
        bui.append("left join requisicaorequisicao j on a.fil_codigo = j.fil_codigo and a.req_codigo = j.req_codigo \n");
        if (filtrarSetor) {
            bui.append("left join examesetor set on i.fil_codigo = set.fil_codigo and i.exa_codigo = set.exa_codigo and set.ese_printmapa = true ");
        }
        if (reqMult != null && reqMult.matches("\\-?\\d+")) {
            bui.append("left join requisicaorequisicao l on a.fil_codigo = l.fil_codigo and a.req_codigo = l.req_kodigo \n");
            bui.append("where l.fil_codigo = ").append(filial);
            bui.append(" and l.req_codigo = ").append(reqMult);
            bui.append(" and a.req_excluida = false and i.exr_excluido = false ");
        } else {
            if (filtro != null) {
                bui.append("where ");
                if (filial.matches("\\-?\\d+")) {
                    bui.append("a.fil_codigo = ");
                }
                bui.append(filial);
                if (filtro.trim().length() == 0) {
                    bui.append(" \n");
                } else {
                    bui.append(" and ").append(filtro).append(" \n");
                }
            }
            if (codigoRequisicao != null) {
                bui.append(" and a.req_codigo = ").append(codigoRequisicao);
            }
            bui.append(" and a.req_excluida = false and i.exr_excluido = false and i.exr_situacao <> '").append("A").append("' ");
            bui.append(" and (i.exr_situacao = ' ' or i.exr_situacao is null or i.exr_situacao = '') ");
            bui.append(" and (u.emc_imprimirmapa = true or u.emc_imprimirmapa is null) ");
            bui.append("group by \n");
            bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_total, a.req_totpago, a.req_deveguia, b.con_codigo, \n");
            bui.append("  c.des_codigo, c.des_naoimprimir, c.des_impressora, g.pac_codigo, g.pac_nome, h.pri_separar, a.req_imprimirseparado, \n");
            bui.append("  h.pri_impressora, impresso, ").append(MAPA_IMPRESSO).append(", ").append(LANCADO).append(" \n");
            bui.append(" ,i.exr_situacao ");
            bui.append("order by \n");
            if (ordenarPorNomePaciente) {
                bui.append(" upper(g.pac_nome) ");
            } else {
                bui.append("  a.req_codigo, a.req_data");
            }
        }
        return bui.toString();
    }

    static String getSelectImpressaoProtocolo(String filial, String filtro, boolean ordenarPorNomePaciente) {
        StringBuilder bui = new StringBuilder();
        bui.append(" select distinct a.fil_codigo ");
        bui.append("       ,a.req_codigo ");
        bui.append("       ,a.req_data ");
        bui.append("       ,g.pac_nome ");
        bui.append("   from requisicao a ");
        bui.append("   left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        bui.append("   left join destino c on a.fil_codigo = c.fil_codigo and upper(a.des_codigo) = upper(c.des_codigo) ");
        bui.append("   left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        bui.append("   left join situacao e on a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo ");
        bui.append("   left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        bui.append("   left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
        bui.append("   left join prioridade h on a.fil_codigo = h.fil_codigo and b.pri_codigo = h.pri_codigo ");
        bui.append("   left join examerequisicao i on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo ");
        bui.append("   left join examesetor set on i.fil_codigo = set.fil_codigo and i.exa_codigo = set.exa_codigo and set.ese_default = true ");
        bui.append("  where ").append(filial);
        if (filtro != null && filtro.trim().length() > 0) {
            bui.append(" and ").append(filtro).append(" ");
        }
        bui.append("    and a.req_excluida = false ");
        bui.append("    and i.exr_excluido = false ");
        bui.append("    and i.exr_situacao <> '").append("A").append("' ");
        bui.append("  order by ");
        if (ordenarPorNomePaciente) {
            bui.append(" g.pac_nome ");
        } else {
            bui.append(" a.req_codigo ");
        }
        return bui.toString();
    }

    public static RetornoImpressaoResultados imprimirExamesPdf(String filial, String codigoRequisicao, String arquivoPdf, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(null, null, filial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, null, null, true, arquivoPdf, false, false, null, ignorarSituacoesParaPdf, mensagemSemResultado, bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExamesPdf(String filial, String codigoRequisicao, String[] exames, String[] materiais, String arquivoPdf, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(null, null, filial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, exames, materiais, true, arquivoPdf, false, false, null, ignorarSituacoesParaPdf, mensagemSemResultado, bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExamesPdf(String filial, String codigoRequisicao, String[] exames, String[] materiais, String arquivoPdf, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean bloqueiaNome, boolean usarLaudoWeb) throws SQLException {
        return ImpressaoResultados.imprimirExames(null, null, filial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, exames, materiais, true, arquivoPdf, false, usarLaudoWeb, null, ignorarSituacoesParaPdf, mensagemSemResultado, bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExamesPdfWeb(String filial, String codigoRequisicao, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(null, null, filial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, null, null, true, "", true, true, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, false, ParametrosGerais.getConferencia(), null, null, null, false, "", false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, ParametrosGerais.getConferencia(), null, null, null, false, "", false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, boolean bloqueiaNome, boolean marcarDataImpressao) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, ParametrosGerais.getConferencia(), null, null, null, false, "", false, false, null, false, "", false, bloqueiaNome, marcarDataImpressao);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, String arquivoPdf, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, ParametrosGerais.getConferencia(), null, null, null, true, arquivoPdf, false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, String[] setores, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, ParametrosGerais.getConferencia(), setores, null, null, false, "", false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, String[] setores, String[] exames, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, ParametrosGerais.getConferencia(), setores, exames, null, false, "", false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, String[] setores, String[] exames, String[] materiais, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, ParametrosGerais.getConferencia(), setores, exames, materiais, false, "", false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, false, "", false, false, null, false, "", bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean bloqueiaNome) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, pdf, arquivoPdf, gerarPdfWeb, usarLaudoWeb, grupoExames, ignorarSituacoesParaPdf, mensagemSemResultado, true, bloqueiaNome);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean usarThread, boolean bloqueiaNomePaciente) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, pdf, arquivoPdf, gerarPdfWeb, usarLaudoWeb, grupoExames, ignorarSituacoesParaPdf, mensagemSemResultado, usarThread, bloqueiaNomePaciente, true);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean usarThread, boolean bloqueiaNomePaciente, boolean marcarDataImpressao) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement stTmp = Conexao.getStatement();
        Statement stConferidos = Conexao.getStatement();
        Statement stCertificado = Conexao.getStatement();
        Statement stCertificacaoUsuario = Conexao.getStatement();
        Statement stCertificacaoSetor = Conexao.getStatement();
        RetornoImpressaoResultados retorno = null;
        try {
            retorno = ImpressaoResultados.imprimirExames(impressoraSelecionada, c, st, stTmp, stConferidos, stCertificado, stCertificacaoUsuario, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, pdf, arquivoPdf, gerarPdfWeb, usarLaudoWeb, grupoExames, ignorarSituacoesParaPdf, mensagemSemResultado, usarThread, bloqueiaNomePaciente, marcarDataImpressao, ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getSequenciaImpressora(), ParametrosGerais.getLayCodigo(), false, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), stCertificacaoSetor);
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(stTmp, st, stConferidos, stCertificado, stCertificacaoUsuario);
                throw throwable;
            }
        }
        Conexao.fecharStatement(stTmp, st, stConferidos, stCertificado, stCertificacaoUsuario);
        return retorno;
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, Statement st, Statement stTmp, Statement stConferidos, Statement stCertificado, Statement stCertificacaoUsuario, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean usarThread, boolean bloqueiaNomePaciente, boolean marcarDataImpressao, boolean ordenarPorSetor, int tipoSequenciaImpressora, int layoutPadrao, boolean enviarErroConsole, int digitosFilial, int digitosRequisicao, Statement stCertificacaoSetor) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, st, stTmp, stConferidos, stCertificado, stCertificacaoUsuario, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, pdf, arquivoPdf, gerarPdfWeb, usarLaudoWeb, grupoExames, ignorarSituacoesParaPdf, mensagemSemResultado, usarThread, bloqueiaNomePaciente, marcarDataImpressao, ordenarPorSetor, tipoSequenciaImpressora, layoutPadrao, enviarErroConsole, false, ParametrosGerais.getConferencia(), false, ParametrosGerais.getPrecoMetodologia(), digitosFilial, digitosRequisicao, stCertificacaoSetor);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, Statement st, Statement stTmp, Statement stConferidos, Statement stCertificado, Statement stCertificacaoUsuario, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean usarThread, boolean bloqueiaNomePaciente, boolean marcarDataImpressao, boolean ordenarPorSetor, int tipoSequenciaImpressora, int layoutPadrao, boolean enviarErroConsole, boolean utilizarAssinaturaWebUsuario, int digitosFilial, int digitosRequisicao, Statement stCertificacaoSetor) throws SQLException {
        return ImpressaoResultados.imprimirExames(impressoraSelecionada, c, st, stTmp, stConferidos, stCertificado, stCertificacaoUsuario, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, pdf, arquivoPdf, gerarPdfWeb, usarLaudoWeb, grupoExames, ignorarSituacoesParaPdf, mensagemSemResultado, usarThread, bloqueiaNomePaciente, marcarDataImpressao, ordenarPorSetor, tipoSequenciaImpressora, layoutPadrao, enviarErroConsole, utilizarAssinaturaWebUsuario, ParametrosGerais.getConferencia(), false, ParametrosGerais.getPrecoMetodologia(), digitosFilial, digitosRequisicao, stCertificacaoSetor);
    }

    public static RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, Statement st, Statement stTmp, Statement stConferidos, Statement stCertificado, Statement stCertificacaoUsuario, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean usarThread, boolean bloqueiaNomePaciente, boolean marcarDataImpressao, boolean ordenarPorSetor, int tipoSequenciaImpressora, int layoutPadrao, boolean enviarErroConsole, boolean utilizarAssinaturaWebUsuario, boolean considerarConferencia, boolean imprimirParaStandalone, boolean utilizarPrecoPorMetodologia, int digitosFilial, int digitosRequisicao, Statement stCertificacaoSetor) throws SQLException {
        ImpressaoResultados resultado = new ImpressaoResultados();
        return resultado.imprimirExames(impressoraSelecionada, c, st, stTmp, stConferidos, stCertificado, stCertificacaoUsuario, filial, codigoRequisicao, reimprimir, exigeConferencia, setores, exames, materiais, pdf, arquivoPdf, gerarPdfWeb, usarLaudoWeb, grupoExames, ignorarSituacoesParaPdf, mensagemSemResultado, usarThread, bloqueiaNomePaciente, marcarDataImpressao, ordenarPorSetor, tipoSequenciaImpressora, layoutPadrao, enviarErroConsole, utilizarAssinaturaWebUsuario, considerarConferencia, imprimirParaStandalone, utilizarPrecoPorMetodologia, digitosFilial, digitosRequisicao, "", false, stCertificacaoSetor);
    }

    public RetornoImpressaoResultados imprimirExames(String impressoraSelecionada, Container c, Statement st, Statement stTmp, Statement stConferidos, Statement stCertificado, Statement stCertificacaoUsuario, String filial, String codigoRequisicao, boolean reimprimir, boolean exigeConferencia, String[] setores, String[] exames, String[] materiais, boolean pdf, String arquivoPdf, boolean gerarPdfWeb, boolean usarLaudoWeb, String[] grupoExames, boolean ignorarSituacoesParaPdf, String mensagemSemResultado, boolean usarThread, boolean bloqueiaNomePaciente, boolean marcarDataImpressao, boolean ordenarPorSetor, int tipoSequenciaImpressora, int layoutPadrao, boolean enviarErroConsole, boolean utilizarAssinaturaWebUsuario, boolean considerarConferencia, boolean imprimirParaStandalone, boolean utilizarPrecoPorMetodologia, int digitosFilial, int digitosRequisicao, String formatoResultado, boolean isColetaWeb, Statement stCertificacaoSetor) throws SQLException {
        RetornoImpressaoResultados retorno = new RetornoImpressaoResultados(false);
        StringBuilder bui = new StringBuilder("");
        boolean isImpressaoRealizada = true;
        String[] examesParaImprimir = exames;
        String[] materiaisParaImprimir = materiais;
        if (st != null && stTmp != null && ImpressaoResultados.validaCodigoRequisicao(codigoRequisicao)) {
            try {
                if (grupoExames != null && grupoExames.length > 0) {
                    bui.setLength(0);
                    bui.append("select exa_codigo, mco_codigo ");
                    bui.append("from examematgrupo ");
                    bui.append("where fil_codigo = ");
                    bui.append(filial);
                    if (exames != null && exames.length > 0 && (materiais == null || materiais.length == 0)) {
                        bui.append(" and ");
                        bui.append(ImpressaoResultados.getExpressao("exa_codigo", exames, true));
                    } else if (exames != null && exames.length > 0 || materiais != null && materiais.length > 0) {
                        bui.append(" and ");
                        bui.append(ImpressaoResultados.getExpressaoExameMaterial("exa_codigo", "mco_codigo", exames, materiais));
                    }
                    if (grupoExames != null && grupoExames.length > 0) {
                        bui.append(" and ");
                        bui.append(ImpressaoResultados.getExpressao("grp_codigo", grupoExames, true));
                    }
                    ArrayList<String> exms = new ArrayList<String>();
                    ArrayList<String> mats = new ArrayList<String>();
                    ResultSet rsTmp = st.executeQuery(bui.toString());
                    if (rsTmp.next()) {
                        do {
                            exms.add(rsTmp.getString("exa_codigo"));
                            mats.add(rsTmp.getString("mco_codigo"));
                        } while (rsTmp.next());
                    }
                    examesParaImprimir = exms.toArray(new String[exms.size()]);
                    materiaisParaImprimir = mats.toArray(new String[mats.size()]);
                }
                bui.setLength(0);
                bui.append("select ");
                if (Funcoes.textoVazio(formatoResultado)) {
                    bui.append(" pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, ");
                } else {
                    bui.append("'" + formatoResultado + "' as exr_resultado, ");
                }
                bui.append("b.exa_codigo, b.mco_codigo, (b.exr_dataimpresso is not null) as segundavia, ");
                bui.append("pegaHashResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as hash, b.exa_codigo, b.mco_codigo, ");
                bui.append("c.emc_pagina, ");
                bui.append("d.set_codigo, ");
                if (utilizarAssinaturaWebUsuario) {
                    bui.append("e.usr_assinaturaweb as assinaturaUsuario, f.usr_assinaturaweb as assinaturaUsuarioDigitacao, g.usr_assinaturaweb as assinaturaUsuarioConferencia, ");
                } else {
                    bui.append("e.usr_assinatura as assinaturaUsuario, f.usr_assinatura as assinaturaUsuarioDigitacao, g.usr_assinatura as assinaturaUsuarioConferencia, ");
                }
                bui.append("h.con_nr1via, h.con_nr2via, ");
                bui.append("a.req_perguntas, ");
                bui.append("a.req_senhaweb, ");
                bui.append("i.met_referencia, j.exa_soa, j.exa_coa, j.exa_inmetro, s.set_descricao, ");
                bui.append("a.des_codigo, ");
                bui.append("a.con_codigo, ");
                bui.append("b.exr_datadigita, ");
                bui.append("b.exr_dataassina, ");
                bui.append("g.usr_codigo as codigoUsuarioAssinatura,");
                bui.append(" coalesce(req_anomes, 'A') as req_anomes , a.req_idade, b.met_codigo ");
                bui.append(" ,coalesce(b.exr_resultadoempdf, false) as ispdf, ");
                bui.append(" err.ert_resultadopdf ");
                bui.append("from requisicao a ");
                bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
                bui.append("left join examematcoleta c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo ");
                bui.append("left join examesetor d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and d.ese_default = true ");
                bui.append("left join usuario e on upper(e.usr_codigo) = upper(b.usr_codigo) ");
                bui.append("left join usuario f on upper(f.usr_codigo) = upper(b.usr_coddigitador) ");
                bui.append("left join usuario g on upper(g.usr_codigo) = upper(b.usr_codassina) ");
                bui.append("left join convenios h on a.fil_codigo = h.fil_codigo and a.con_codigo = h.con_codigo ");
                bui.append("left join metodologia i on b.fil_codigo = i.fil_codigo and b.met_codigo = i.met_codigo ");
                bui.append("left join exames j on b.fil_codigo = j.fil_codigo and b.exa_codigo = j.exa_codigo ");
                bui.append("left join setores s on d.fil_codigo = s.fil_codigo and d.set_codigo = s.set_codigo ");
                bui.append("left join examerequisicaoresultado err on b.fil_codigo = err.fil_codigo and b.req_codigo = err.req_codigo and b.exa_codigo = err.exa_codigo and b.mco_codigo = err.mco_codigo ");
                if (Variaveis.tipoFilialPadrao.equals("A")) {
                    bui.append("left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo ");
                    bui.append("left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
                }
                bui.append("where ");
                if (!ignorarSituacoesParaPdf) {
                    bui.append("b.exr_datadigita is not null and ");
                }
                bui.append(" a.fil_codigo = ");
                bui.append(filial);
                bui.append(" and a.req_codigo = ");
                bui.append(codigoRequisicao);
                bui.append(" and a.req_excluida = false and b.exr_excluido = false ");
                if (!gerarPdfWeb) {
                    if (reimprimir) {
                        bui.append(" and h.con_nr2via > 0 ");
                    } else {
                        bui.append(" and h.con_nr1via > 0 ");
                    }
                }
                if (exigeConferencia && !ignorarSituacoesParaPdf) {
                    bui.append(" and b.exr_dataassina is not null");
                } else if (!exigeConferencia && !ignorarSituacoesParaPdf) {
                    bui.append(" and b.exr_situacao != '").append("A").append("' ");
                }
                if (!ignorarSituacoesParaPdf) {
                    bui.append(" and b.exr_situacao != '").append("O").append("' ");
                }
                if (gerarPdfWeb) {
                    bui.append(" and b.exr_situacao != '").append("L").append("' ");
                }
                if (!reimprimir) {
                    bui.append(" and b.exr_dataimpresso is null");
                }
                if (setores != null && setores.length > 0) {
                    bui.append(" and ");
                    bui.append(ImpressaoResultados.getExpressao("d.set_codigo", setores, false));
                }
                if (examesParaImprimir != null && examesParaImprimir.length > 0 && (materiaisParaImprimir == null || materiaisParaImprimir.length == 0)) {
                    bui.append(" and ");
                    bui.append(ImpressaoResultados.getExpressao("b.exa_codigo", examesParaImprimir, true));
                } else if (examesParaImprimir != null && examesParaImprimir.length > 0 || materiaisParaImprimir != null && materiaisParaImprimir.length > 0) {
                    bui.append(" and ");
                    bui.append(ImpressaoResultados.getExpressaoExameMaterial("b.exa_codigo", "b.mco_codigo", examesParaImprimir, materiaisParaImprimir));
                }
                bui.append(" order by ispdf asc, ");
                if (Variaveis.tipoFilialPadrao.equals("A")) {
                    bui.append("j.exa_inmetro desc, ");
                }
                if (ordenarPorSetor) {
                    bui.append("d.set_codigo, ");
                }
                bui.append("c.emc_pagina, c.emc_ordem, b.exa_codigo, b.mco_codigo ");
                ResultSet res = st.executeQuery(bui.toString());
                res.last();
                int tamanho = res.getRow();
                exames = new String[tamanho];
                materiais = new String[tamanho];
                res.beforeFirst();
                int o = 0;
                while (res.next()) {
                    exames[o] = res.getString("exa_codigo");
                    materiais[o] = res.getString("mco_codigo");
                    ++o;
                }
                res.beforeFirst();
                if (res.next()) {
                    if (!pdf && ParametrosLocais.isTrue("imprimirCapaLaudo")) {
                        if (Funcoes.textoVazio(impressoraSelecionada) || impressoraSelecionada.equals("Selecionar Impressora")) {
                            DialogoImpressao digImp = DialogoImpressao.novaInstancia(c, "Impress\u00e3o da capa de laudo", false);
                            digImp.setVisible(true);
                            impressoraSelecionada = digImp.ok() ? digImp.getImpressoraSelecionada() : "";
                            retorno.setImpressoraSelecionada(impressoraSelecionada);
                            digImp.dispose();
                            if (!Funcoes.textoVazio(impressoraSelecionada)) {
                                ImprimirCapaLaudo.imprimir(filial, codigoRequisicao, impressoraSelecionada);
                            }
                        } else {
                            ImprimirCapaLaudo.imprimir(filial, codigoRequisicao, impressoraSelecionada);
                        }
                    }
                    if (!pdf && ParametrosLocais.isTrue("imprimirEtiquetaLaudoAutomaticamente")) {
                        Statement stImpressaoLaudo = Conexao.getStatement();
                        Statement stImpressaoLaudo2 = Conexao.getStatement();
                        String impressora = ParametrosLocais.getParametro("impressoraEtqLaudo");
                        ImprimirEtiquetaLaudo etiquetaLaudo = new ImprimirEtiquetaLaudo();
                        etiquetaLaudo.imprimir(filial, codigoRequisicao, false, stImpressaoLaudo, stImpressaoLaudo2, impressora, ParametrosGerais.getLayCodigo(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        Conexao.fecharStatement(stImpressaoLaudo, stImpressaoLaudo2);
                    }
                    Date data = jalis.laboratorio.util.impressao.Impressao.pegaUltimaDataExameRequisicao(stTmp, filial, codigoRequisicao, "exr_dataassina");
                    Map<String, Object> perguntasRequisicao = null;
                    if (!DBUtil.campoNull(res.getString("req_perguntas")) && !Funcoes.textoVazio(res.getString("req_perguntas"))) {
                        perguntasRequisicao = Resultado.getCamposResultado(res.getString("req_perguntas"));
                    }
                    Map<String, Object> dadosExameRequisicao = null;
                    dadosExameRequisicao = !imprimirParaStandalone ? ExameUtil.getDadosExameRequisicao(stTmp, stConferidos, codigoRequisicao, null, null, filial, false, bloqueiaNomePaciente, true) : ExameUtil.getDadosExameRequisicao(stTmp, stConferidos, codigoRequisicao, null, null, filial, false, null, false, considerarConferencia, utilizarPrecoPorMetodologia);
                    if (perguntasRequisicao != null) {
                        dadosExameRequisicao.putAll(perguntasRequisicao);
                    }
                    String senhaWebRequisicao = res.getString("req_senhaweb");
                    ImpressaoResultados.preencheValorCampoLaudo(stTmp, dadosExameRequisicao, filial, codigoRequisicao, senhaWebRequisicao, digitosFilial, digitosRequisicao);
                    ResultSet rsCertificado = ImpressaoResultados.getCamposAssinaturaDigitalFilial(filial, stCertificado);
                    boolean temCertificadoRT = false;
                    boolean temCertificadoRTSub = false;
                    if (rsCertificado.next()) {
                        temCertificadoRT = rsCertificado.getString("certificadoRT") != null && !Funcoes.textoVazio(rsCertificado.getString("certificadoRT"));
                        temCertificadoRTSub = rsCertificado.getString("certificadoRTSub") != null && !Funcoes.textoVazio(rsCertificado.getString("certificadoRTSub"));
                    }
                    String codUser = res.getString("codigoUsuarioAssinatura");
                    ResultSet certificadoUser = ImpressaoResultados.getCamposAssinaturaDigitalUsuario(codUser, stCertificacaoUsuario);
                    if (!temCertificadoRT && certificadoUser.next()) {
                        temCertificadoRT = certificadoUser.getString("usr_certificado") != null && !Funcoes.textoVazio(certificadoUser.getString("usr_certificado"));
                    }
                    Documento doc = ImpressaoResultados.getDocumento(stTmp, stConferidos, res, filial, codigoRequisicao, ignorarSituacoesParaPdf, mensagemSemResultado, pdf && (!Funcoes.textoVazio(arquivoPdf) || gerarPdfWeb), bloqueiaNomePaciente, pdf && (!Funcoes.textoVazio(arquivoPdf) || gerarPdfWeb), temCertificadoRT, temCertificadoRTSub, ordenarPorSetor, exigeConferencia, utilizarPrecoPorMetodologia);
                    doc.setDadosBanco(dadosExameRequisicao);
                    String cabecalhoRodape = ImpressaoResultados.getCabecalhoRodape(stTmp, filial, codigoRequisicao, usarLaudoWeb, layoutPadrao);
                    doc.setCabecalhoRodape(cabecalhoRodape);
                    String parametros = StringUtil.getValor(cabecalhoRodape, "propriedades");
                    parametros = StringUtil.getValor(parametros, "assinaturaRodape");
                    String usuarioAssinatura = StringUtil.getValor(parametros, "campoBanco");
                    certificadoUser.beforeFirst();
                    if (usuarioAssinatura.equals("rt") && !Funcoes.textoVazio(rsCertificado.getString("certificadoRT"))) {
                        ImpressaoResultados.setRazaoAssinatura(stTmp, stConferidos, rsCertificado, filial, codigoRequisicao, rsCertificado.getString("certificadoRT"), rsCertificado.getString("senhart"));
                    } else if (!Funcoes.textoVazio(rsCertificado.getString("certificadoRTSub"))) {
                        ImpressaoResultados.setRazaoAssinatura(stTmp, stConferidos, rsCertificado, filial, codigoRequisicao, rsCertificado.getString("certificadoRTSub"), rsCertificado.getString("senhartsub"));
                    } else if (certificadoUser.next() && certificadoUser.getString("usr_certificado") != null && !Funcoes.textoVazio(certificadoUser.getString("usr_certificado"))) {
                        ImpressaoResultados.setRazaoAssinatura(stTmp, stConferidos, certificadoUser, filial, codigoRequisicao, certificadoUser.getString("usr_certificado"), certificadoUser.getString("usr_senhacertificado"));
                    }
                    if (pdf && (!Funcoes.textoVazio(arquivoPdf) || gerarPdfWeb)) {
                        if (gerarPdfWeb) {
                            arquivoPdf = "tempJalis.pdf";
                        }
                        doc.setArquivoPdf(arquivoPdf);
                        ByteArrayOutputStream arrayPdf = ImpressaoResultados.getResultadoEmBytes(doc, !imprimirParaStandalone);
                        res.last();
                        int contador = res.getRow();
                        if (!gerarPdfWeb) {
                            FileOutputStream fos = new FileOutputStream(arquivoPdf);
                            byte[] pdfBytes = arrayPdf.toByteArray();
                            byte[] bytesDB = null;
                            byte[] bytesDBAux = null;
                            Integer contaDB = 0;
                            if (null != exames && exames.length > 0) {
                                for (int posicaoExame = 0; posicaoExame < exames.length; ++posicaoExame) {
                                    String resultado = "";
                                    byte[] bytes = null;
                                    bytesDB = null;
                                    resultado = ResultadosUtil.geraResultadoPDF(stTmp, filial, codigoRequisicao, exames[posicaoExame], materiais[posicaoExame]);
                                    if (!Funcoes.textoVazio(resultado)) {
                                        bytes = new Base64().decode(resultado);
                                        bytesDB = ResultadosUtil.concatenarPdfs(bytesDB, bytes, "Resultado(s)");
                                        bytesDBAux = ResultadosUtil.concatenarPdfs(bytesDBAux, bytes, "Resultado(s)");
                                        Integer n = contaDB;
                                        Integer n2 = contaDB = Integer.valueOf(contaDB + 1);
                                    }
                                    pdfBytes = contaDB == contador ? bytesDBAux : ResultadosUtil.concatenarPdfs(bytesDB, pdfBytes, "Resultado(s)");
                                }
                            }
                            fos.write(pdfBytes);
                            fos.close();
                        }
                        if (doc.getAssinarDigitalmente()) {
                            byte[] pdfAssinado = null;
                            boolean existeAssinaturaConferencia = Boolean.FALSE;
                            int margemEsquerda = doc.getMargemEsquerda();
                            int margemDireita = doc.getMargemDireita();
                            int margemInferior = doc.getMargemInferior();
                            int posicaoHorizontalAssinatura = doc.getPosicaoHorizontalAssinatura();
                            int posicaoVerticalAssinatura = doc.getPosicaoVerticalAssinatura();
                            int alturaAssinaturaRodape = doc.getAlturaAssinaturaRodape();
                            int alturaRodape = doc.getAlturaRodape();
                            int posicaoVertitcalAbsolutaAssinatura = doc.getPosicaoVerticalAbsolutaAssinatura();
                            float margemAssinatura = doc.getMargemAssinaturaDigital();
                            int tipoAssinaturaRodape = doc.getAssinaturaRodape().getTipo();
                            DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital = doc.getAssinaturaRodape().getDimensoesAssinaturaDigital();
                            String tipo = ImpressaoResultados.getTipoCertificacao(stTmp, filial);
                            ResultSet examesConferidos = ImpressaoResultados.getExamesAssinar(filial, codigoRequisicao, stTmp);
                            if (tipo.equalsIgnoreCase("U") || Variaveis.tipoFilialPadrao.equals("A") && tipo.equalsIgnoreCase("S")) {
                                while (examesConferidos.next()) {
                                    String codUsuarioConferencia = examesConferidos.getString("usr_codassina");
                                    ResultSet certificadoUsuario = Variaveis.tipoFilialPadrao.equals("A") && tipo.equalsIgnoreCase("S") ? this.getCamposAssinaturaDigitalSetor(filial, codigoRequisicao, stCertificacaoSetor) : ImpressaoResultados.getCamposAssinaturaDigitalUsuario(codUsuarioConferencia, stCertificacaoUsuario);
                                    if (!certificadoUsuario.next()) continue;
                                    if (posicaoHorizontalAssinatura == 4) {
                                        margemDireita += 103;
                                    }
                                    String assinaturaPersonalizada = !Funcoes.textoVazio(certificadoUsuario.getString("usr_textoassinaturadigital")) ? certificadoUsuario.getString("usr_textoassinaturadigital") : "";
                                    byte[] byteCertificadoUsuario = new Base64().decode(certificadoUsuario.getString("usr_certificado"));
                                    if (byteCertificadoUsuario != null) {
                                        String senhaCertificado = certificadoUsuario.getString("usr_senhacertificado");
                                        margemDireita = doc.getMargemDireita();
                                        String oidLogo = certificadoUsuario.getString("usr_assinaturaweb");
                                        ByteArrayInputStream logo = null;
                                        if (!Funcoes.textoVazio(oidLogo)) {
                                            logo = new ByteArrayInputStream(Base64.decodeBase64((String)oidLogo));
                                        }
                                        pdfAssinado = this.assinaPDF(arquivoPdf, gerarPdfWeb, data, arrayPdf, pdfAssinado, existeAssinaturaConferencia, margemEsquerda, margemDireita, margemInferior, posicaoHorizontalAssinatura, posicaoVerticalAssinatura, alturaAssinaturaRodape, alturaRodape, posicaoVertitcalAbsolutaAssinatura, margemAssinatura, tipoAssinaturaRodape, dimensoesAssinaturaDigital, assinaturaPersonalizada, byteCertificadoUsuario, senhaCertificado, logo, "", "");
                                    }
                                    if (posicaoHorizontalAssinatura == 2) {
                                        int n = margemEsquerda = dimensoesAssinaturaDigital.getLarguraAssinatura() > 0 ? margemEsquerda + dimensoesAssinaturaDigital.getLarguraAssinatura() : margemEsquerda + ImpressaoResultados.getLarguraAssinaturaDigitalPadraoItext(alturaAssinaturaRodape);
                                    }
                                    if (posicaoHorizontalAssinatura == 4) {
                                        margemDireita = dimensoesAssinaturaDigital.getLarguraAssinatura() > 0 ? margemDireita + dimensoesAssinaturaDigital.getLarguraAssinatura() : margemDireita + ImpressaoResultados.getLarguraAssinaturaDigitalPadraoItext(alturaAssinaturaRodape);
                                    }
                                    existeAssinaturaConferencia = Boolean.TRUE;
                                }
                            }
                            if (pdfAssinado == null && (tipo.equalsIgnoreCase("F") || tipo.equalsIgnoreCase("U") || Variaveis.tipoFilialPadrao.equals("A") && tipo.equalsIgnoreCase("S")) && rsCertificado.getString("certificadoRT") != null && !Funcoes.textoVazio(rsCertificado.getString("certificadoRT"))) {
                                rsCertificado.beforeFirst();
                                if (rsCertificado.next()) {
                                    boolean isTipoAssinaturaRT = doc.getTipoAssinaturaDigital() == CampoAssinaturaLaudo.RESPONSAVEL_TECNICO_DIGITAL;
                                    Base64 base64e = new Base64();
                                    byte[] byteCertificado = Base64.decodeBase64((String)(isTipoAssinaturaRT ? rsCertificado.getString("certificadoRT") : rsCertificado.getString("certificadoRTSub")));
                                    if (byteCertificado != null) {
                                        String senhaCertificado = isTipoAssinaturaRT ? rsCertificado.getString("senhaRT") : rsCertificado.getString("senhaRTSub");
                                        String razao = rsCertificado.getString("razaoAssinatura");
                                        String local = rsCertificado.getString("localAssinatura");
                                        String oidLogo = isTipoAssinaturaRT ? rsCertificado.getString("logoAssinaturaRT") : rsCertificado.getString("logoAssinaturaRTSub");
                                        ByteArrayInputStream logo = null;
                                        if (!Funcoes.textoVazio(oidLogo)) {
                                            logo = new ByteArrayInputStream(Base64.decodeBase64((String)oidLogo));
                                        }
                                        this.assinaPDF(arquivoPdf, gerarPdfWeb, data, arrayPdf, pdfAssinado, existeAssinaturaConferencia, margemEsquerda, margemDireita, margemInferior, posicaoHorizontalAssinatura, posicaoVerticalAssinatura, alturaAssinaturaRodape, alturaRodape, posicaoVertitcalAbsolutaAssinatura, margemAssinatura, tipoAssinaturaRodape, dimensoesAssinaturaDigital, null, byteCertificado, senhaCertificado, logo, razao, local);
                                    }
                                }
                            }
                        }
                        if (gerarPdfWeb && res.first()) {
                            retorno.setResultadoPdfWeb(arrayPdf.toByteArray());
                            do {
                                String resultadoTextoWeb = ResultadosUtil.geraResultadoTextoParaWeb(stTmp, filial, res.getString("con_codigo"), res.getString("des_codigo"), res.getInt("req_idade"), res.getString("req_anomes"), res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("met_codigo"), res.getString("exr_resultado"), layoutPadrao);
                                ExamesImpressos examesImpressos = new ExamesImpressos(res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("hash"), Funcoes.formataData("yyyy-MM-dd HH:mm:ss", res.getTimestamp("exr_dataassina")), res.getString("codigoUsuarioAssinatura"), resultadoTextoWeb);
                                retorno.getExames().add(examesImpressos);
                                retorno.setResultadoTextoWeb(resultadoTextoWeb);
                                retorno.setDataConferencia(res.getDate("exr_dataassina"));
                                retorno.setUsuarioConferencia(res.getString("codigoUsuarioAssinatura"));
                                retorno.setAssinaturaUsuarioConferencia(res.getString("assinaturaUsuarioConferencia"));
                                retorno.setHash(res.getString("hash"));
                                String resultadoPDF = ResultadosUtil.geraResultadoPDfDB(stTmp, filial, codigoRequisicao, res.getString("exa_codigo"), res.getString("mco_codigo"));
                                if (Funcoes.textoVazio(resultadoPDF)) continue;
                                byte[] bytes = new Base64().decode(resultadoPDF);
                                retorno.setResultadoPdfWeb(ResultadosUtil.concatenarPdfs(bytes, arrayPdf.toByteArray(), "Resultado(s)"));
                            } while (res.next());
                        }
                    } else {
                        doc.prepararImpressao();
                        doc.setVariavel("dataImpressao", new Date());
                        String impressora = ImpressaoResultados.getImpressora(stTmp, filial, codigoRequisicao, tipoSequenciaImpressora);
                        impressora = jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(impressora);
                        if (c != null && impressora.equals("Selecionar Impressora")) {
                            if (Funcoes.textoVazio(impressoraSelecionada) && !ParametrosLocais.isTrue("imprimirCapaLaudo")) {
                                DialogoImpressao digImp = DialogoImpressao.novaInstancia(c, "Impress\u00e3o de resultados", false);
                                digImp.setVisible(true);
                                impressoraSelecionada = digImp.ok() ? digImp.getImpressoraSelecionada() : "";
                                retorno.setImpressoraSelecionada(impressoraSelecionada);
                                digImp.dispose();
                            }
                            impressora = impressoraSelecionada;
                        }
                        if (!Funcoes.textoVazio(impressora)) {
                            Impressao imp = new Impressao(impressora);
                            Book resultadosAgrupados = ImpressaoResultados.agruparResultadosPdf(doc, res);
                            if (usarThread) {
                                imp.imprimirAgrupadosThread(resultadosAgrupados, doc.getCopias());
                            } else {
                                imp.imprimirAgrupados(resultadosAgrupados, doc.getCopias());
                            }
                            retorno.setImprimiuResultado(true);
                        } else {
                            isImpressaoRealizada = false;
                            retorno.setImprimiuResultado(false);
                        }
                    }
                    if ((!pdf || isColetaWeb) && marcarDataImpressao && isImpressaoRealizada) {
                        bui.delete(0, bui.length());
                        bui.append("update examerequisicao set exr_dataimpresso = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("', usr_codimpressao = '");
                        bui.append(Variaveis.login);
                        bui.append("' where exr_datadigita is not null ");
                        if (exigeConferencia) {
                            bui.append("and exr_dataassina is not null ");
                        }
                        bui.append("and fil_codigo = ");
                        bui.append(filial);
                        bui.append(" and req_codigo = ");
                        bui.append(codigoRequisicao);
                        bui.append(" and exr_excluido = false ");
                        if (examesParaImprimir != null && examesParaImprimir.length > 0 && (materiaisParaImprimir == null || materiaisParaImprimir.length == 0)) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressao("exa_codigo", examesParaImprimir, true));
                        } else if (examesParaImprimir != null && examesParaImprimir.length > 0 || materiaisParaImprimir != null && materiaisParaImprimir.length > 0) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressaoExameMaterial("exa_codigo", "mco_codigo", examesParaImprimir, materiaisParaImprimir));
                        }
                        if (isColetaWeb) {
                            stTmp.executeUpdate(bui.toString());
                        } else {
                            Conexao.executeUpdate(filial, stTmp, bui.toString());
                        }
                        ImpressaoResultados.registraQtdePaginasImpressas(filial, codigoRequisicao, doc.getQuantidadePaginas(), stTmp, isColetaWeb);
                        bui.delete(0, bui.length());
                        bui.append("select exa_codigo, mco_codigo from examerequisicao ");
                        bui.append("where ");
                        if (!reimprimir) {
                            if (!exigeConferencia) {
                                bui.append(" exr_datadigita is not null and exr_situacao in ('");
                                bui.append("L").append("', '").append("C");
                                bui.append("') and ");
                            } else {
                                bui.append(" exr_dataassina is not null and exr_situacao = '");
                                bui.append("C");
                                bui.append("' and ");
                            }
                        }
                        bui.append(" fil_codigo = ");
                        bui.append(filial);
                        bui.append(" and req_codigo = ");
                        bui.append(codigoRequisicao);
                        bui.append(" and exr_excluido = false ");
                        if (examesParaImprimir != null && examesParaImprimir.length > 0 && (materiaisParaImprimir == null || materiaisParaImprimir.length == 0)) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressao("exa_codigo", examesParaImprimir, true));
                        } else if (examesParaImprimir != null && examesParaImprimir.length > 0 || materiaisParaImprimir != null && materiaisParaImprimir.length > 0) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressaoExameMaterial("exa_codigo", "mco_codigo", examesParaImprimir, materiaisParaImprimir));
                        }
                        ArrayList<String> inserirHistorico = new ArrayList<String>();
                        ArrayList<ExamesImpressos> examesImpressos = new ArrayList<ExamesImpressos>();
                        ResultSet rs = stTmp.executeQuery(bui.toString());
                        while (rs.next()) {
                            bui.setLength(0);
                            bui.append("insert into examerequisicaosituacoes(fil_codigo, req_codigo, exa_codigo, mco_codigo, usr_codigo, ers_situacao, ers_datahora) values (");
                            bui.append(filial).append(", ");
                            bui.append(codigoRequisicao).append(", ");
                            bui.append("'").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("', ");
                            bui.append(rs.getString("mco_codigo")).append(", ");
                            bui.append("'").append(StringUtil.textoDB(Variaveis.login)).append("', ");
                            bui.append("'").append("I").append("', ");
                            bui.append("'").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss.SSS", new Date())).append("')");
                            inserirHistorico.add(bui.toString());
                            examesImpressos.add(new ExamesImpressos(rs.getString("exa_codigo"), rs.getInt("mco_codigo")));
                        }
                        retorno.setExames(examesImpressos);
                        bui.delete(0, bui.length());
                        bui.append("update examerequisicao set exr_situacao = '");
                        bui.append("I");
                        bui.append("', usr_codimpressao = '");
                        bui.append(Variaveis.login);
                        bui.append("' where ");
                        if (!exigeConferencia) {
                            bui.append(" exr_datadigita is not null and exr_situacao in ('");
                            bui.append("L").append("', '").append("C");
                            bui.append("') ");
                        } else {
                            bui.append(" exr_dataassina is not null and exr_situacao = '");
                            bui.append("C");
                            bui.append("' ");
                        }
                        bui.append("and fil_codigo = ");
                        bui.append(filial);
                        bui.append(" and req_codigo = ");
                        bui.append(codigoRequisicao);
                        if (examesParaImprimir != null && examesParaImprimir.length > 0 && (materiaisParaImprimir == null || materiaisParaImprimir.length == 0)) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressao("exa_codigo", examesParaImprimir, true));
                        } else if (examesParaImprimir != null && examesParaImprimir.length > 0 || materiaisParaImprimir != null && materiaisParaImprimir.length > 0) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressaoExameMaterial("exa_codigo", "mco_codigo", examesParaImprimir, materiaisParaImprimir));
                        }
                        if (isColetaWeb) {
                            stTmp.executeUpdate(bui.toString());
                        } else {
                            Conexao.executeUpdate(filial, stTmp, bui.toString());
                        }
                        for (String s : inserirHistorico) {
                            if (isColetaWeb) {
                                stTmp.executeUpdate(s);
                                continue;
                            }
                            Conexao.executeUpdate(filial, stTmp, s);
                        }
                        ArrayList<String> tmp = new ArrayList<String>();
                        tmp.add("codigoRequisicao");
                        tmp.add(IntegracaoUtil.formataCodigoRequisicao(filial, codigoRequisicao, stTmp, digitosFilial, digitosRequisicao));
                        tmp.add("codigoBase");
                        tmp.add(ExportaWeb.getCodigoBaseWeb(st, filial));
                        tmp.add("codigoExameRequisicao");
                        tmp.add("");
                        tmp.add("materialExameRequisicao");
                        tmp.add("");
                        tmp.add("situacaoExameRequisicao");
                        tmp.add("I");
                        tmp.add("dataEnvioExameRequisicao");
                        tmp.add("current_timestamp");
                        bui.delete(0, bui.length());
                        bui.append("select exa_codigo, mco_codigo from examerequisicao where exr_datadigita is not null and req_codigo = ");
                        bui.append(codigoRequisicao);
                        bui.append(" and fil_codigo = ");
                        bui.append(filial);
                        if (exigeConferencia) {
                            bui.append(" and exr_dataassina is not null");
                        }
                        if (examesParaImprimir != null && examesParaImprimir.length > 0 && (materiaisParaImprimir == null || materiaisParaImprimir.length == 0)) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressao("exa_codigo", examesParaImprimir, true));
                        } else if (examesParaImprimir != null && examesParaImprimir.length > 0 || materiaisParaImprimir != null && materiaisParaImprimir.length > 0) {
                            bui.append(" and ");
                            bui.append(ImpressaoResultados.getExpressaoExameMaterial("exa_codigo", "mco_codigo", examesParaImprimir, materiaisParaImprimir));
                        }
                        res = st.executeQuery(bui.toString());
                        while (res.next()) {
                            tmp.set(5, res.getString("exa_codigo"));
                            tmp.set(7, res.getString("mco_codigo"));
                            DBUtil.insereExportaWebGerarResultadoPDF(filial, stTmp, "requisicaoexame", "A", true, false, tmp.toArray(new String[tmp.size()]));
                            ExportaFiliais.gravaRequisicao(Integer.parseInt(filial), Integer.parseInt(codigoRequisicao), res.getString("exa_codigo"), res.getInt("mco_codigo"), "U", "U", stConferidos, stTmp);
                        }
                    }
                    retorno.setDocumentoImpressao(doc);
                }
            }
            catch (IOException e) {
                Funcoes.mensagem(c, "Falha na impress\u00e3o - PDF inv\u00e1lido.\n Por favor, remova e importe o PDF novamente.", 2);
            }
            catch (Exception e) {
                if (!enviarErroConsole) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 339\n" + bui.toString());
                } else {
                    e.printStackTrace();
                }
                retorno.setImprimiuResultado(false);
            }
            if (retorno != null && retorno.getResultadoPdfWeb() != null && (pdf || gerarPdfWeb)) {
                retorno.setImprimiuResultado(true);
            }
        }
        return retorno;
    }

    private byte[] assinaPDF(String arquivoPdf, boolean gerarPdfWeb, Date data, ByteArrayOutputStream arrayPdf, byte[] pdfAssinado, boolean existeAssinaturaConferencia, int margemEsquerda, int margemDireita, int margemInferior, int posicaoHorizontalAssinatura, int posicaoVerticalAssinatura, int alturaAssinaturaRodape, int alturaRodape, int posicaoVertitcalAbsolutaAssinatura, float margemAssinatura, int tipoAssinaturaRodape, DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital, String assinaturaPersonalizada, byte[] byteCertificadoUsuario, String senhaCertificado, InputStream logo, String razao, String local) throws Exception {
        if (gerarPdfWeb) {
            ByteArrayInputStream bais = null;
            bais = existeAssinaturaConferencia ? new ByteArrayInputStream(pdfAssinado) : new ByteArrayInputStream(arrayPdf.toByteArray());
            DadosAssinaturaDigitalDTO dadosAssinatura = new DadosAssinaturaDigitalDTO.Builder().pdfOriginal(bais).certificado(byteCertificadoUsuario).senhaCertificado(senhaCertificado).assinaturaPersonalizada(assinaturaPersonalizada).razao(razao).local(local).imagem(logo).posicaoHorizontalAssinatura(posicaoHorizontalAssinatura).posicaoVerticalAssinatura(posicaoVerticalAssinatura).margemEsquerda(margemEsquerda).margemDireita(margemDireita).margemInferior(margemInferior).margemAssinatura(margemAssinatura).alturaAssinatura(alturaAssinaturaRodape).alturaRodape(alturaRodape).posicaoVerticalAbsolutaAssinatura(posicaoVertitcalAbsolutaAssinatura).data(data).tipoAssinaturaRodape(tipoAssinaturaRodape).dimensoesAssinaturaDigital(dimensoesAssinaturaDigital).build();
            pdfAssinado = ResultadosUtil.assinarPdfComCertificadoDigital(dadosAssinatura);
            bais.close();
            if (pdfAssinado != null) {
                arrayPdf.reset();
                arrayPdf.write(pdfAssinado);
            }
        } else {
            FileInputStream fis = new FileInputStream(arquivoPdf);
            InputStream is = null;
            is = existeAssinaturaConferencia ? new ByteArrayInputStream(pdfAssinado) : fis;
            DadosAssinaturaDigitalDTO dadosAssinatura = new DadosAssinaturaDigitalDTO.Builder().pdfOriginal(is).certificado(byteCertificadoUsuario).senhaCertificado(senhaCertificado).assinaturaPersonalizada(assinaturaPersonalizada).razao(razao).local(local).imagem(logo).posicaoHorizontalAssinatura(posicaoHorizontalAssinatura).posicaoVerticalAssinatura(posicaoVerticalAssinatura).margemEsquerda(margemEsquerda).margemDireita(margemDireita).margemInferior(margemInferior).margemAssinatura(margemAssinatura).alturaAssinatura(alturaAssinaturaRodape).alturaRodape(alturaRodape).posicaoVerticalAbsolutaAssinatura(posicaoVertitcalAbsolutaAssinatura).data(data).tipoAssinaturaRodape(tipoAssinaturaRodape).dimensoesAssinaturaDigital(dimensoesAssinaturaDigital).build();
            pdfAssinado = ResultadosUtil.assinarPdfComCertificadoDigital(dadosAssinatura);
            is.close();
            fis.close();
            if (pdfAssinado != null) {
                FileOutputStream fosAssinado = new FileOutputStream(arquivoPdf);
                fosAssinado.write(pdfAssinado);
                fosAssinado.close();
            }
        }
        return pdfAssinado;
    }

    private ResultSet getCamposAssinaturaDigitalSetor(String filial, String codigoRequisicao, Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select s.set_assinarlaudodigital, s.usr_codlaudodigital, u.usr_nome, u.usr_senha, ");
        buf.append(" u.usr_assinatura, u.tpu_codigo, u.usr_foto, ");
        buf.append(" u.usr_lasttimelogin, u.usr_lastdtlogin, u.usr_codcoletor, ");
        buf.append(" u.fil_codigo, u.usr_alterasenha, u.usr_inativo, ");
        buf.append(" u.usr_datainativo, u.usr_assinaturaweb, u.usr_digital, ");
        buf.append(" u.usr_mensagemweb, u.usr_validadecertificado, u.usr_senhacertificado, u.usr_textoassinaturadigital, ");
        buf.append(" u.usr_certificado ");
        buf.append(" FROM usuario u ");
        buf.append(" inner join setores s on s.usr_codlaudodigital = u.usr_codigo ");
        buf.append(" inner join examesetor e on e.fil_codigo = s.fil_codigo and e.set_codigo = s.set_codigo and e.ese_default = true ");
        buf.append(" inner join examerequisicao er on er.fil_codigo = s.fil_codigo and er.exa_codigo = e.exa_codigo ");
        buf.append(" where er.fil_codigo = ").append(filial);
        buf.append(" and er.req_codigo = ").append(codigoRequisicao);
        buf.append(" and u.usr_certificado is not null ");
        return st.executeQuery(buf.toString());
    }

    private static int getLarguraAssinaturaDigitalPadraoItext(int alturaAssinatura) {
        int largura = 100 * alturaAssinatura / 70;
        largura = 190 * largura / 100;
        return largura;
    }

    private static Book agruparResultadosPdf(Documento doc, ResultSet res) throws Exception {
        byte[] resultadosExternosAgrupados = null;
        res.beforeFirst();
        int contadorPDF = 0;
        while (res.next()) {
            if (Funcoes.textoVazio(res.getString("ert_resultadopdf"))) continue;
            byte[] pdfEmbytes = new Base64().decode(res.getString("ert_resultadopdf"));
            resultadosExternosAgrupados = ResultadosUtil.concatenarPdfs(resultadosExternosAgrupados, pdfEmbytes, "Resultado(s)");
            ++contadorPDF;
        }
        Book book = new Book();
        if (doc.getResultados().get(0).length != 0) {
            book.append(doc, doc.getFormatoPagina(), doc.getQuantidadePaginas());
        }
        if (resultadosExternosAgrupados != null) {
            PDDocument pdDoc = PDDocument.load(resultadosExternosAgrupados);
            int paginasJalis = doc.getResultados().get(0).length != 0 ? doc.getQuantidadePaginas() : 0;
            PDFPageable pdfPag = new PDFPageable(pdDoc, Orientation.AUTO, false, 288.0f, paginasJalis);
            for (int i = 0; i < pdfPag.getNumberOfPages(); ++i) {
                book.append(pdfPag.getPrintable(i), pdfPag.getPageFormat(i));
            }
        }
        return book;
    }

    public static ByteArrayOutputStream getResultadoEmBytes(Documento doc, boolean compactarPDF) throws Exception {
        doc.setConsiderarPDF(true);
        doc.prepararImpressao();
        int totalPaginas = doc.getQuantidadePaginas();
        int largura = doc.getLarguraAreaImpressao() + doc.getMargemDireita() + doc.getMargemEsquerda();
        int altura = doc.getAlturaAreaImpressao() + doc.getMargemInferior() + doc.getMargemSuperior();
        Document document = new Document(new Rectangle((float)largura, (float)altura));
        ByteArrayOutputStream arrayPdf = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)arrayPdf);
        writer.setFullCompression();
        document.setMargins((float)doc.getMargemEsquerda(), (float)doc.getMargemDireita(), (float)doc.getMargemSuperior(), (float)doc.getMargemInferior());
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        writer.setMargins((float)doc.getMargemEsquerda(), (float)doc.getMargemDireita(), (float)doc.getMargemSuperior(), (float)doc.getMargemInferior());
        String mascaraPDF = doc.getMascaraPdf();
        for (int p = 0; p < totalPaginas; ++p) {
            if (!Funcoes.textoVazio(mascaraPDF)) {
                PdfReader layoutCliente = new PdfReader(Base64.decodeBase64((String)mascaraPDF));
                PdfImportedPage ip = writer.getImportedPage(layoutCliente, 1);
                cb = writer.getDirectContent();
                cb.addTemplate((PdfTemplate)ip, 0.0f, 0.0f);
            }
            PdfTemplate tp = cb.createTemplate((float)largura, (float)altura);
            PdfGraphics2D g2 = new PdfGraphics2D(cb, (float)largura, (float)altura, (FontMapper)mapper, false, false, 0.0f);
            doc.print((Graphics)g2, new PageFormat(), p);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.newPage();
        }
        document.close();
        writer.close();
        if (compactarPDF) {
            arrayPdf = ImpressaoResultados.diminuiTamanhoPDF(arrayPdf);
            arrayPdf = OtimizadorImagensPDF.retornaPDFOtimizado(arrayPdf.toByteArray(), doc.getQualidadeImagensPDF());
        }
        return arrayPdf;
    }

    private static void preencheValorCampoLaudo(Statement stTmp, Map<String, Object> dadosExameRequisicao, String filial, String codigoRequisicao, String senhaWebRequisicao, int digitosFilial, int digitosRequisicao) throws SQLException {
        for (int i = 0; i < jalis.laboratorio.util.impressao.Impressao.CAMPOS_LAUDO.length; ++i) {
            if (!jalis.laboratorio.util.impressao.Impressao.CAMPOS_LAUDO[i].equals("chaveAcessoRequisicao")) continue;
            String baseWeb = ExportaWeb.getCodigoBaseWeb(stTmp, filial);
            boolean agrupada = false;
            agrupada = ExportaWeb.isBaseWebAgrupada(stTmp, filial);
            if (agrupada) {
                try {
                    Map<String, Object> o = ExportaWeb.getBaseWebAgrupada(stTmp, filial);
                    baseWeb = o.get("baseWeb") != null ? o.get("baseWeb").toString() : "";
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
            }
            String chaveAcesso = "";
            JSONObject jsonObject = new JSONObject();
            try {
                String tmp = Funcoes.preencheZero(filial, digitosFilial) + Funcoes.preencheZero(codigoRequisicao, digitosRequisicao);
                jsonObject.put("c", (Object)(agrupada ? tmp : codigoRequisicao));
                jsonObject.put("b", (Object)baseWeb);
                jsonObject.put("p", (Object)senhaWebRequisicao);
                chaveAcesso = new IntegracaoAplicativoService().encript(jsonObject.toString());
                chaveAcesso = Base64.encodeBase64String((byte[])chaveAcesso.getBytes());
            }
            catch (JSONException e) {
                throw new SQLException(e.getCause());
            }
            dadosExameRequisicao.put("chaveacessorequisicao", chaveAcesso);
            break;
        }
    }

    private static void registraQtdePaginasImpressas(String filCodigo, String reqCodigo, Integer qtdePaginas, Statement st, boolean isColetaWeb) {
        RequisicaoPaginasImpressasService service = new RequisicaoPaginasImpressasService();
        RequisicaoPaginasImpressasVO reqPaginasImpressasVO = new RequisicaoPaginasImpressasVO();
        String data = Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date());
        reqPaginasImpressasVO.setFilCodigo(filCodigo);
        reqPaginasImpressasVO.setReqCodigo(reqCodigo);
        reqPaginasImpressasVO.setDataHora(data);
        reqPaginasImpressasVO.setUsrCodigo(Variaveis.login);
        reqPaginasImpressasVO.setQtdePaginas(qtdePaginas);
        try {
            service.registraImpressao(reqPaginasImpressasVO, st, isColetaWeb);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel registrar a quantidade de paginas impressas.\n" + e.getMessage(), e.getStackTrace(), "Erro de impress\u00e3o: 1267");
        }
    }

    private static ByteArrayOutputStream diminuiTamanhoPDF(OutputStream inputStream) throws IOException, DocumentException {
        PdfReader reader = null;
        reader = inputStream instanceof ByteArrayOutputStream ? new PdfReader(((ByteArrayOutputStream)inputStream).toByteArray()) : new PdfReader(((FileOutputStream)inputStream).toString());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document document = new Document();
        PdfSmartCopy pdfCopy = new PdfSmartCopy(document, (OutputStream)bos);
        document.open();
        int pageNumber = 0;
        while (pageNumber < reader.getNumberOfPages()) {
            pdfCopy.addPage(pdfCopy.getImportedPage(reader, ++pageNumber));
        }
        document.close();
        pdfCopy.close();
        reader.close();
        return bos;
    }

    @Deprecated
    private static ResultSet getCamposAssinaturaDigitalFilial(String filial, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_certificadort as certificadoRT ");
        buf.append("       ,fil_certificadortsub as certificadoRTSub ");
        buf.append("       ,fil_senhart as senhaRT ");
        buf.append("       ,fil_senhartsub as senhaRTSub ");
        buf.append("       ,fil_motivocertificado as razaoAssinatura ");
        buf.append("       ,fil_localcertificado as localAssinatura ");
        buf.append("       ,fil_logocertificadort as logoAssinaturaRT ");
        buf.append("       ,fil_logocertificadortsub as logoAssinaturaRTSub ");
        buf.append("  from filiais_postocoleta ");
        buf.append(" where fil_codigo = ").append(filial);
        return st.executeQuery(buf.toString());
    }

    public static void setRazaoAssinatura(Statement stExamesConferidos2, Statement stCertificacaoUsuario2, ResultSet rsCertificado, String filial, String codigoRequisicao, String assinatura, String senha) throws SQLException {
        ResultSet examesConferidos = ImpressaoResultados.getExamesAssinar(filial, codigoRequisicao, stExamesConferidos2);
        while (examesConferidos.next()) {
            String codUsuarioConferencia = examesConferidos.getString("usr_codassina");
            ResultSet certificadoUsuario = ImpressaoResultados.getCamposAssinaturaDigitalUsuario(codUsuarioConferencia, stCertificacaoUsuario2);
            if (!certificadoUsuario.next()) continue;
            Base64 base64e = new Base64();
            byte[] byteCertificadoUsuario = base64e.decode(assinatura);
            String senhaCertificadoUsuario = senha;
            ByteArrayInputStream certificado = new ByteArrayInputStream(byteCertificadoUsuario);
            razaoAssinatura = ImpressaoResultados.user(certificado, senhaCertificadoUsuario);
        }
    }

    public static String getRazaoAssinatura() {
        return razaoAssinatura;
    }

    public static String user(InputStream certificado, String senhaCertificado) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String alias = null;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(certificado, senhaCertificado.toCharArray());
            alias = ks.aliases().nextElement();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
        }
        if (alias != null) {
            return alias.toUpperCase();
        }
        return null;
    }

    private static ResultSet getCamposAssinaturaDigitalUsuario(String usuario, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT ");
        buf.append(" usr_codigo, usr_nome, usr_senha, ");
        buf.append(" usr_assinatura, tpu_codigo, usr_foto, ");
        buf.append(" usr_lasttimelogin, usr_lastdtlogin, usr_codcoletor, ");
        buf.append(" fil_codigo, usr_alterasenha, usr_inativo, ");
        buf.append(" usr_datainativo, usr_assinaturaweb, usr_digital, ");
        buf.append(" usr_mensagemweb, usr_validadecertificado, usr_senhacertificado, usr_textoassinaturadigital, ");
        buf.append(" usr_certificado ");
        buf.append(" FROM usuario ");
        buf.append(" where usr_codigo = ");
        buf.append("'");
        buf.append(usuario);
        buf.append("'");
        buf.append(" AND ");
        buf.append(" usr_certificado is not null ");
        return st.executeQuery(buf.toString());
    }

    private static ResultSet getExamesAssinar(String filial, String requisicao, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT ");
        buf.append(" distinct(usr_codassina), ");
        buf.append(" fil_codigo, req_codigo ");
        buf.append(" FROM examerequisicao ");
        buf.append(" WHERE req_codigo = ");
        buf.append(requisicao);
        buf.append(" AND fil_codigo = ");
        buf.append(filial);
        buf.append(" AND usr_codassina is not null; ");
        return st.executeQuery(buf.toString());
    }

    private static String getTipoCertificacao(String filial) {
        String tipo = "";
        Statement st = Conexao.getStatement();
        try {
            tipo = ImpressaoResultados.getTipoCertificacao(st, filial);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Tipo Certifica\u00e7\u00e3o incorreto: 000");
        }
        return tipo;
    }

    private static String getTipoCertificacao(Statement st, String filial) throws Exception {
        ResultSet rs = null;
        String tipo = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select * from filiais_postocoleta where fil_codigo = ").append(filial);
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            tipo = rs.getString("fil_tipocertificacao");
        }
        rs.close();
        return tipo;
    }

    public static byte[] imprimirPdf(Printable printable, PageFormat configuracaoPagina, int qtdePaginas) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document document = new Document(new Rectangle(new Double(configuracaoPagina.getPaper().getWidth()).floatValue(), new Double(configuracaoPagina.getPaper().getHeight()).floatValue()));
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)bos);
        document.open();
        PdfContentByte contentByte = writer.getDirectContent();
        float width = (float)configuracaoPagina.getPaper().getWidth();
        float height = (float)configuracaoPagina.getPaper().getHeight();
        for (int i = 0; i < qtdePaginas; ++i) {
            Graphics2D g2d = contentByte.createGraphics(width, height, null);
            int pageReturn = printable.print(g2d, configuracaoPagina, i);
            g2d.dispose();
            if (pageReturn != 0) break;
            document.newPage();
        }
        document.close();
        writer.close();
        return bos.toByteArray();
    }

    private static String getSOACOA(PreparedStatement ps, String filial, String requisicao, ArrayList<ExameMaterialPagina> exames, String campo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append("select distinct ").append(campo).append(" from exames where fil_codigo = ");
        buf.append(filial);
        buf.append(" and (");
        for (int i = 0; i < exames.size(); ++i) {
            ExameMaterialPagina exm = exames.get(i);
            buf.append(" exa_codigo = '").append(exm.getCodigo()).append("' ");
            if (i >= exames.size() - 1) continue;
            buf.append(" or ");
        }
        buf.append(") ");
        ps = Conexao.getPreparedStatement(buf.toString());
        ResultSet rps = Conexao.executeQuery(ps);
        buf.setLength(0);
        while (rps.next()) {
            if (Funcoes.textoVazio(rps.getString(1))) continue;
            buf.append(buf.length() > 0 ? ", " : "").append(rps.getString(1));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Registro getRequisicao(String filial, String codigoRequisicao) {
        Statement st = Conexao.getStatement();
        Registro retorno = null;
        try {
            retorno = ImpressaoResultados.getRequisicao(st, filial, codigoRequisicao);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 411");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Registro getRequisicao(Statement st, String filial, String codigoRequisicao) {
        if (st != null && ImpressaoResultados.validaCodigoRequisicao(codigoRequisicao)) {
            block5: {
                Registro registro;
                try {
                    StringBuilder buf = new StringBuilder("select a.fil_codigo, a.req_codigo, a.req_data, b.pac_nome from requisicao a ");
                    buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
                    buf.append("where a.fil_codigo = ");
                    buf.append(filial);
                    buf.append(" and a.req_codigo = ");
                    buf.append(codigoRequisicao);
                    buf.append(" and a.req_excluida = false ");
                    ResultSet res = st.executeQuery(buf.toString());
                    if (!res.next()) break block5;
                    Registro reg = new Registro(res);
                    reg.setValor(DATA, Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
                    registro = reg;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 374");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                return registro;
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void carregarExames(String filial, String codigoRequisicao, ModeloResultSet modelo, boolean isMapa) {
        Statement st = Conexao.getStatement();
        try {
            ImpressaoResultados.carregarExames(st, filial, codigoRequisicao, modelo, isMapa);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 410");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void carregarExames(Statement st, String filial, String codigoRequisicao, ModeloResultSet modelo, boolean isMapa) {
        if (st != null && ImpressaoResultados.validaCodigoRequisicao(codigoRequisicao) && modelo != null) {
            try {
                StringBuilder buf = new StringBuilder(SELECT_EXAME);
                buf.append(" where a.fil_codigo = ");
                buf.append(filial);
                buf.append(" and a.req_codigo = ");
                buf.append(codigoRequisicao);
                buf.append(" and a.exr_excluido = false ");
                buf.append(" order by  ");
                String ordem = " a.exr_ordem, d.emc_pagina, d.emc_ordem, a.exa_codigo, a.mco_codigo ";
                if (isMapa) {
                    ordem = " a.exr_ordem, a.exa_codigo, a.mco_codigo ";
                }
                buf.append(ordem);
                ResultSet res = st.executeQuery(buf.toString());
                modelo.limpar();
                while (res.next()) {
                    Registro reg = new Registro(res);
                    reg.setValor(SITUACAO, Tipos.tipoSituacaoExame(res.getString("exr_situacao")));
                    modelo.addRegistro(reg);
                }
                modelo.fireTableDataChanged();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    public static Documento getDocumento(Statement st, Statement st2, ResultSet res, String filial, String codigoRequisicao, boolean trocarExameSemResultado, String mensagemSemResultado, boolean considerarPDF, boolean bloqueiaNomePaciente, boolean isGerarPDF, boolean temCertificadoRT, boolean temCertificadoRTSub, boolean ordenarPorSetor, boolean exigirConferencia, boolean pesquisarPrecoPorMetodologia) {
        Documento doc = new Documento();
        doc.setConsiderarPDF(considerarPDF);
        doc.setGerarPDF(isGerarPDF);
        doc.setTemCertificadoRT(temCertificadoRT);
        doc.setTemCertificadoRTSub(temCertificadoRTSub);
        try {
            ArrayList<String> arrRes = new ArrayList<String>();
            ArrayList arrAss = new ArrayList();
            ArrayList<ExameMaterialPagina> arrExame = new ArrayList<ExameMaterialPagina>();
            ArrayList<String> arrRef = new ArrayList<String>();
            ArrayList<String> arrSOA = new ArrayList<String>();
            ArrayList<String> arrCOA = new ArrayList<String>();
            ArrayList<String> arrSetor = new ArrayList<String>();
            ArrayList<Boolean> arrInmetro = new ArrayList<Boolean>();
            int ultimoSetor = -1;
            int ultimaPagina = -1;
            if (res.first()) {
                String tipoFilial = ImpressaoResultados.getTipoFilial(st, filial);
                if (tipoFilial != null && tipoFilial.equals("A")) {
                    doc.setCopias(ImpressaoResultados.getQtdeCopias(st, filial, res.getString("con_codigo"), res.getString("des_codigo")));
                } else {
                    doc.setCopias(res.getBoolean("segundavia") ? res.getInt("con_nr2via") : ImpressaoResultados.getQtdeCopias(st, filial, res.getString("con_codigo"), res.getString("des_codigo")));
                }
                do {
                    if (Funcoes.textoVazio(res.getString("exr_resultado")) && !trocarExameSemResultado) continue;
                    String exm = res.getString("exa_codigo");
                    int mat = res.getInt("mco_codigo");
                    int setor = res.getInt("set_codigo");
                    int pagina = res.getInt("emc_pagina");
                    if (ordenarPorSetor && setor != ultimoSetor && ultimoSetor != -1 || (pagina == -1 || pagina != ultimaPagina) && !arrRes.isEmpty()) {
                        doc.addResultados(arrExame.toArray(new ExameMaterialPagina[arrExame.size()]), arrRes.toArray(new String[arrRes.size()]), arrAss.toArray(new Hashtable[arrAss.size()]), arrRef.toArray(new String[arrRef.size()]), arrSOA.toArray(new String[arrSOA.size()]), arrCOA.toArray(new String[arrCOA.size()]), arrSetor.toArray(new String[arrSetor.size()]), arrInmetro.toArray(new Boolean[arrInmetro.size()]));
                        arrAss.clear();
                        arrRes.clear();
                        arrExame.clear();
                        arrRef.clear();
                        arrSOA.clear();
                        arrCOA.clear();
                        arrSetor.clear();
                        arrInmetro.clear();
                    }
                    Hashtable<String, String> table = new Hashtable<String, String>();
                    table.put("assinaturaUsuario", res.getString("assinaturaUsuario") == null ? "" : res.getString("assinaturaUsuario"));
                    table.put("assinaturaUsuarioDigitacao", res.getString("assinaturaUsuarioDigitacao") == null ? "" : res.getString("assinaturaUsuarioDigitacao"));
                    table.put("assinaturaUsuarioConferencia", res.getString("assinaturaUsuarioConferencia") == null ? "" : res.getString("assinaturaUsuarioConferencia"));
                    arrAss.add(table);
                    String campoValidaSemResultado = "exr_datadigita";
                    if (exigirConferencia) {
                        campoValidaSemResultado = "exr_dataassina";
                    }
                    Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(st, st2, codigoRequisicao, exm, String.valueOf(mat), filial, false, null, bloqueiaNomePaciente, exigirConferencia, pesquisarPrecoPorMetodologia);
                    TabelaSimbolos tabelaSimbolo = new TabelaSimbolos();
                    tabelaSimbolo.setDados(dados);
                    String resultado = trocarExameSemResultado && !Funcoes.textoVazio(mensagemSemResultado) && DBUtil.campoNull(res.getString(campoValidaSemResultado)) ? mensagemSemResultado : res.getString("exr_resultado");
                    resultado = resultado == null ? "" : resultado.replace("&apos;", "'");
                    arrRes.add(resultado);
                    arrExame.add(new ExameMaterialPagina(exm, mat, tabelaSimbolo));
                    arrRef.add(res.getString("met_referencia"));
                    arrSOA.add(res.getString("exa_soa"));
                    arrCOA.add(res.getString("exa_coa"));
                    arrSetor.add(res.getString("set_descricao"));
                    arrInmetro.add(res.getBoolean("exa_inmetro"));
                    ultimaPagina = pagina;
                    ultimoSetor = setor;
                } while (res.next());
                doc.addResultados(arrExame.toArray(new ExameMaterialPagina[arrExame.size()]), arrRes.toArray(new String[arrRes.size()]), arrAss.toArray(new Hashtable[arrAss.size()]), arrRef.toArray(new String[arrRef.size()]), arrSOA.toArray(new String[arrSOA.size()]), arrCOA.toArray(new String[arrCOA.size()]), arrSetor.toArray(new String[arrSetor.size()]), arrInmetro.toArray(new Boolean[arrInmetro.size()]));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 463");
        }
        return doc;
    }

    static String getCabecalhoRodape(Statement st, String filial, String codigoRequisicao, boolean usarLaudoWeb, int layoutPadrao) throws Exception {
        String cabecalho = "";
        if (st != null && ImpressaoResultados.validaCodigoRequisicao(codigoRequisicao)) {
            StringBuffer buf = new StringBuffer("select a.con_codigo, a.des_codigo from requisicao a ");
            buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            buf.append("left join destino c on a.fil_codigo = c.fil_codigo and a.des_codigo = c.des_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigoRequisicao);
            buf.append(" and a.req_excluida = false ");
            ResultSet res = st.executeQuery(buf.toString());
            if (res.next()) {
                cabecalho = ImpressaoResultados.getCabecalhoRodape(st, filial, res, usarLaudoWeb, layoutPadrao);
            }
            if (!usarLaudoWeb) {
                int mascaraPdfIni = cabecalho.indexOf("<mascaraPDF>");
                int mascaraPdfFim = cabecalho.indexOf("</mascaraPDF>") + 13;
                if (mascaraPdfIni > -1) {
                    String cabecalhoSemMascara = cabecalho.substring(0, mascaraPdfIni);
                    cabecalho = cabecalhoSemMascara = cabecalhoSemMascara + cabecalho.substring(mascaraPdfFim, cabecalho.length());
                }
            }
        }
        return cabecalho;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCabecalhoRodape(Statement st, String filial, ResultSet res, boolean usarLaudoWeb, int layoutPadrao) throws Exception {
        String con = res.getString("con_codigo");
        String des = res.getString("des_codigo");
        String laudo = "";
        if (con != null && des != null && st != null) {
            StringBuffer buf = new StringBuffer("select lay_cabec, lay_laudoweb ");
            buf.append(" from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(ExameUtil.getCodigoLayout(filial, con, des, st, layoutPadrao));
            try (ResultSet tmp = null;){
                tmp = st.executeQuery(buf.toString());
                if (tmp.next()) {
                    laudo = usarLaudoWeb && !DBUtil.campoNull(tmp.getString("lay_laudoweb")) && !Funcoes.textoVazio(tmp.getString("lay_laudoweb")) ? tmp.getString("lay_laudoweb") : tmp.getString("lay_cabec");
                }
            }
        }
        return laudo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQtdeCopias(String filial, String convenio, String destino) {
        Statement st = Conexao.getStatement();
        int retorno = 1;
        try {
            retorno = ImpressaoResultados.getQtdeCopias(st, filial, convenio, destino);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 412");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static int getQtdeCopias(Statement st, String filial, String convenio, String destino) {
        int retorno = 1;
        try {
            StringBuilder buf = new StringBuilder("select a.con_nr1via, b.dcl_copiaslaudo from convenios a ");
            buf.append("left join destinoconvlayout b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo and b.des_codigo = '").append(StringUtil.textoDB(destino)).append("'");
            buf.append("where a.fil_codigo = ").append(filial);
            buf.append(" and a.con_codigo = ").append(convenio);
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                retorno = DBUtil.campoNull(rs.getString("dcl_copiaslaudo")) || rs.getInt("dcl_copiaslaudo") <= 0 ? rs.getInt("con_nr1via") : rs.getInt("dcl_copiaslaudo");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 812");
        }
        return retorno;
    }

    static String getImpressora(ResultSet res, int tipoSequenciaImpressora) {
        try {
            String impDes = res.getString("des_impressora");
            String impPri = res.getString("pri_impressora");
            ArrayList<String> seq = new ArrayList<String>();
            if (tipoSequenciaImpressora == 1 || tipoSequenciaImpressora == 3) {
                seq.add(impDes);
                if (tipoSequenciaImpressora == 1) {
                    seq.add(impPri);
                }
            } else if (tipoSequenciaImpressora == 0 || tipoSequenciaImpressora == 2) {
                seq.add(impPri);
                if (tipoSequenciaImpressora == 0) {
                    seq.add(impDes);
                }
            }
            seq.add(ParametrosLocais.getParametro("impressoraLaudo"));
            String[] imps = seq.toArray(new String[seq.size()]);
            for (int i = 0; i < imps.length; ++i) {
                if (imps[i] == null || imps[i].trim().length() <= 0) continue;
                return imps[i];
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 559");
        }
        return "";
    }

    static String getImpressora(Statement st, String filial, String codigoRequisicao, int tipoSequenciaImpressora) {
        if (st != null && ImpressaoResultados.validaCodigoRequisicao(codigoRequisicao)) {
            try {
                StringBuffer buf = new StringBuffer("select b.des_impressora, d.pri_impressora from requisicao a ");
                buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
                buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
                buf.append("left join prioridade d on c.fil_codigo = d.fil_codigo and c.pri_codigo = d.pri_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(filial);
                buf.append(" and a.req_codigo = ");
                buf.append(codigoRequisicao);
                buf.append(" and a.req_excluida = false ");
                ResultSet res = st.executeQuery(buf.toString());
                if (res.next()) {
                    return ImpressaoResultados.getImpressora(res, tipoSequenciaImpressora);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoResultados: 590");
            }
        }
        return "";
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(StringUtil.textoDB(valores[i]));
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    public static String getExpressaoExameMaterial(String campoExame, String campoMaterial, String[] exames, String[] materiais) {
        StringBuilder bui = new StringBuilder("(");
        if ((campoExame != null && exames != null && exames.length > 0 || campoMaterial != null && materiais != null && materiais.length > 0) && (exames == null || materiais == null || exames.length == materiais.length)) {
            boolean ambos = campoExame != null && campoMaterial != null;
            int tamanho = (exames == null ? materiais : exames).length;
            for (int i = 0; i < tamanho; ++i) {
                if (i > 0) {
                    bui.append(" or ");
                }
                if (ambos) {
                    bui.append('(');
                }
                if (exames != null) {
                    bui.append(campoExame);
                    bui.append(" = '");
                    bui.append(exames[i]);
                    bui.append('\'');
                }
                if (ambos) {
                    bui.append(" and ");
                }
                if (materiais != null) {
                    bui.append(campoMaterial);
                    bui.append(" = ");
                    bui.append(materiais[i]);
                }
                if (!ambos) continue;
                bui.append(')');
            }
        }
        return bui.append(")").toString();
    }

    private static boolean validaCodigoRequisicao(String codigoRequisicao) {
        return codigoRequisicao != null && codigoRequisicao.matches("\\-?\\d+");
    }

    static String getTipoFilial(Statement st, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder("select fil_tipobase from filiais_postocoleta ");
        buf.append(" where fil_codigo = ").append(filial);
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            return rs.getString("fil_tipobase");
        }
        return "C";
    }

    public static RetornoImpressaoResultados imprimirResultadoPdf(String impressoraSelecionada, byte[] bytes, String filCodigo, String reqCodigo, Container c) {
        RetornoImpressaoResultados retorno = new RetornoImpressaoResultados(true);
        String impressora = ImpressaoResultados.getImpressora(Conexao.getStatement(), filCodigo, reqCodigo, ParametrosGerais.getSequenciaImpressora());
        impressora = jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(impressora);
        if (c != null && impressora.equals("Selecionar Impressora")) {
            if (Funcoes.textoVazio(impressoraSelecionada)) {
                DialogoImpressao digImp = DialogoImpressao.novaInstancia(c, "Impress\u00e3o de resultados", false);
                digImp.setVisible(true);
                impressoraSelecionada = digImp.ok() ? digImp.getImpressoraSelecionada() : "";
                retorno.setImpressoraSelecionada(impressoraSelecionada);
                digImp.dispose();
            }
            impressora = impressoraSelecionada;
        }
        Impressao impressao = new Impressao(impressora);
        impressao.imprimirDocumentThread(bytes);
        return retorno;
    }

    static {
        mapper = new DefaultFontMapper();
        String diretorioFontes = "c:/windows/fonts";
        if (null != ParametrosLocais.getParametro("fontesPath") && !ParametrosLocais.getParametro("fontesPath").equals("")) {
            diretorioFontes = ParametrosLocais.getParametro("fontesPath");
        }
        mapper.insertDirectory(diretorioFontes);
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.con_codigo, c.des_codigo, c.des_naoimprimir, c.des_impressora, \n");
        bui.append("  g.pac_codigo, g.pac_nome, h.pri_separar, h.pri_impressora, a.req_imprimirseparado \n");
        bui.append("from requisicao a \n");
        bui.append("left join convenios b  on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo \n");
        bui.append("left join destino c on a.fil_codigo = c.fil_codigo and upper(a.des_codigo) = upper(c.des_codigo) \n");
        bui.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf \n");
        bui.append("left join situacao e on a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo \n");
        bui.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) \n");
        bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo \n");
        bui.append("left join prioridade h on a.fil_codigo = h.fil_codigo and b.pri_codigo = h.pri_codigo \n");
        SELECT_REQUISICAO = bui.toString();
        bui.delete(0, bui.length());
        bui.append(" select \n");
        bui.append(" row_number() over (order by exr_ordem) as exr_ordem, \n");
        bui.append(" a.exa_codigo, b.exa_descricao, c.mco_codigo, c.mco_abreviatura, a.exr_situacao, \n");
        bui.append(" (a.exr_dataimpresso is not null) as ").append(LAUDO_IMPRESSO);
        bui.append(" ,(a.exr_datamapa is not null) as ").append(MAPA_IMPRESSO).append(" \n");
        bui.append(" ,a.exr_notificacao as notificacao ");
        bui.append(" from examerequisicao a \n");
        bui.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo \n");
        bui.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo \n");
        bui.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo \n");
        bui.append(" left join examesetor set on a.fil_codigo = set.fil_codigo and a.exa_codigo = set.exa_codigo and set.ese_default = true ");
        SELECT_EXAME = bui.toString();
    }
}

