/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.util.StringUtil;

public class ImpressaoNotificacao {
    static final String LANCADO = "lancado";
    static final String CONFERIDO = "conferido";
    static final String IMPRESSO = "impresso";
    static final String ENTREGUE = "entregue";
    static final String SEM_RESULTADO = "sem_resultado";
    static final String MAPA_IMPRESSO = "mapa_impresso";

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(StringUtil.textoDB(valores[i]));
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    static String getSelectRequisicaoExame(String filial, String filtro, Integer codigoRequisicao, boolean filtrarSetor) {
        return ImpressaoNotificacao.getSelectRequisicaoExame(filial, filtro, codigoRequisicao, filtrarSetor, false);
    }

    static String getSelectRequisicaoExame(String filial, String filtro, Integer codigoRequisicao, boolean filtrarSetor, boolean ordenarPorNomePaciente) {
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, \n");
        bui.append("  b.con_codigo, a.req_imprimirseparado, \n");
        bui.append("  c.des_codigo, c.des_naoimprimir, c.des_impressora, \n");
        bui.append("  g.pac_codigo, g.pac_nome, \n");
        bui.append("  h.pri_separar, h.pri_impressora, \n");
        bui.append("  (i.exr_datamapa is not null) as ").append(MAPA_IMPRESSO);
        bui.append("  ,i.exr_situacao = '").append("E").append("' as ").append(ENTREGUE);
        bui.append("  ,i.exr_situacao = '").append("I").append("' as ").append(IMPRESSO);
        bui.append("  ,i.exr_situacao = '").append("C").append("' as ").append(CONFERIDO);
        bui.append("  ,i.exr_situacao = '").append("L").append("' as ").append(LANCADO);
        bui.append("  ,trim(coalesce(i.exr_situacao, '')) = '' as ").append(SEM_RESULTADO);
        bui.append(" \n from requisicao a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo \n");
        bui.append("left join destino c on a.fil_codigo = c.fil_codigo and upper(a.des_codigo) = upper(c.des_codigo) \n");
        bui.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf \n");
        bui.append("left join situacao e on a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo \n");
        bui.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) \n");
        bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo \n");
        bui.append("left join prioridade h on a.fil_codigo = h.fil_codigo and b.pri_codigo = h.pri_codigo \n");
        bui.append("left join examerequisicao i on a.fil_codigo = i.fil_codigo and a.req_codigo = i.req_codigo \n");
        if (filtrarSetor) {
            bui.append("left join examesetor set on i.fil_codigo = set.fil_codigo and i.exa_codigo = set.exa_codigo and set.ese_default = true ");
        }
        bui.append("where ");
        if (filial.matches("\\-?\\d+")) {
            bui.append("a.fil_codigo = ");
        }
        bui.append(filial);
        if (filtro != null) {
            if (filtro.trim().length() == 0) {
                bui.append(" \n");
            } else {
                bui.append(" and ").append(filtro).append(" \n");
            }
            if (codigoRequisicao != null) {
                bui.append(" and a.req_codigo = ").append(codigoRequisicao);
            }
        } else {
            bui.append(" and a.req_codigo = ").append(codigoRequisicao);
        }
        bui.append(" and a.req_excluida = false and i.exr_excluido = false and i.exr_situacao <> '").append("A").append("' ");
        bui.append(" and i.exr_notificacao is not null and i.exr_notificacao <> '' ");
        bui.append("and (i.exr_situacao = '").append("E").append("'");
        bui.append("or i.exr_situacao = '").append("I").append("'");
        bui.append("or i.exr_situacao = '").append("C").append("'");
        bui.append("or i.exr_situacao = '").append("L").append("')");
        bui.append("group by \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_total, a.req_totpago, a.req_deveguia, b.con_codigo, \n");
        bui.append("  c.des_codigo, c.des_naoimprimir, c.des_impressora, g.pac_codigo, g.pac_nome, h.pri_separar, a.req_imprimirseparado, \n");
        bui.append("  h.pri_impressora, impresso, ").append(MAPA_IMPRESSO).append(", ").append(LANCADO).append(" \n");
        bui.append(" ,i.exr_situacao ");
        bui.append("order by \n");
        if (ordenarPorNomePaciente) {
            bui.append(" upper(g.pac_nome) ");
        } else {
            bui.append(" a.req_codigo, a.req_data");
        }
        return bui.toString();
    }
}

