/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.resultados.SituacaoRequisicao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.ImprimirMapa;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class FrmImpressaoRequisicao
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener {
    public static final int LAUDO = 0;
    public static final int MAPA = 1;
    public final int QTDE_QUEBRA = 10;
    public static final String MENSAGEM_REQUISICAO_ADICIONADA = "A requisi\u00e7\u00e3o \" %s \" j\u00e1 foi adicionada.";
    public static final String MENSAGEM_REQUISICAO_INEXISTENTE = "A requisi\u00e7\u00e3o \" %s \" n\u00e3o existe.";
    public static final String MENSAGEM_REQUISICAO_SEM_EXAME_LANCADO = "A requisi\u00e7\u00e3o \" %s \" n\u00e3o tem exames lan\u00e7ados.";
    public static final String MENSAGEM_REQUISICAO_DEVEDORA = "A requisi\u00e7\u00e3o \" %s \" est\u00e1 com saldo devedor.";
    public static final String MENSAGEM_REQUISICAO_SEM_PEDIDO_GUIA = "Requisi\u00e7\u00e3o sem guia";
    private static final String LAUDO_EXIBIR_EXAMES = "FrmImpressaoRequisicaoLaudo.mostrarExames";
    private static final String LAUDO_POSICAO_DIVISOR = "FrmImpressaoRequisicaoLaudo.posicaoDivisor";
    private static final String LAUDO_OCULTAR_MENSAGEM_MULTIGUIA = "FrmImpressaoRequisicaoLaudo.ocultarMensagemMultiguia";
    private static final String LAUDO_ORDEM_ADICAO = "FrmImpressaoRequisicaoLaudo.utilizarOrdemAdicao";
    private static final String MAPA_EXIBIR_EXAMES = "FrmImpressaoRequisicaoMapa.mostrarExames";
    private static final String MAPA_POSICAO_DIVISOR = "FrmImpressaoRequisicaoMapa.posicaoDivisor";
    private static final String MAPA_OCULTAR_MENSAGEM_MULTIGUIA = "FrmImpressaoRequisicaoMapa.ocultarMsgemMultiguia";
    private static final String MAPA_ORDENACAO_REQUISICAO = "FrmImpressaoMapa.ordenacaoRequisicao";
    private final String EXIBIR_EXAMES;
    private final String POSICAO_DIVISOR;
    private final String OCULTAR_MENSAGEM_MULTIGUIA;
    private static final String REIMPRIMIR = "reimprimir";
    private String impressoraSelecionada = "";
    private String impressoraLaudoSelecionada = "";
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JPanel panelTopo = new JPanel(new FlowLayout(0, 0, 3));
    private JPanel panelBarra = new JPanel(new BorderLayout());
    private JPanel panelBarraEsq = new JPanel(new FlowLayout(0, 3, 3));
    private JPanel panelBarraDir = new JPanel(new FlowLayout(2, 3, 3));
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private ModeloResultSet modeloRequisicoes = new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome", "Data", "data");
    private ModeloResultSet modeloExames = new ModeloResultSet("Ordem", "exr_ordem", "C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "Situa\u00e7\u00e3o", "situacao");
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 55, 0, 85);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, (ListSelectionListener)this, 50, 55, 0, 40, 90);
    private JSplitPane splitCentro = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private JButton buttonBuscaRequisicao = new JButton();
    private JButton buttonExibirOcultarExames = new JButton();
    private JCheckBox checkOcultarMensagemMultiguia = ComponenteFactory.novoJCheckBox("Ocultar mensagens de multiguia", this);
    private JCheckBox checkImprimirOrdemAdicao = ComponenteFactory.novoJCheckBox("Imprimir na ordem adicionada", null);
    private JButton buttonImprimirTodos = ComponenteFactory.novoJButton("Imprimir Todos", 'T', this, null, null, false);
    private JButton buttonImprimirRequisicao = ComponenteFactory.novoJButton("Imprimir", '\u0000', this, null, null, false);
    private JButton buttonImprimirExame = ComponenteFactory.novoJButton("Imprimir", '\u0000', this, null, null, false);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JTextField textCodigo = new TTextField(12, 1);
    private TTextField textFilial = new TTextField(5, 1);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, this.textFilial);
    private JButton buttonFilial = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FrmImpressaoRequisicao.this.pesquisarFilial();
        }
    }, true);
    private int tipo;
    private int posicaoDivisor = 400;
    private boolean exibirExames = true;
    private boolean ocultarMensagemMultiguia = false;
    private boolean acessoImprimirDevedor = Acesso.getAcesso(400500106L);
    private boolean acessoOcultarMensagem = false;
    private boolean acessoFiltrarFilial = false;
    boolean filtrarFilial = !ParametrosGerais.getTipoIntegracao().equals("N");
    private boolean ocultarConvenio;
    private boolean ocultaNomePessoa;
    private JCheckBox checkOrdenarRequisicao = ComponenteFactory.novoJCheckBox("Ordena\u00e7\u00e3o da requisi\u00e7\u00e3o", this);

    public FrmImpressaoRequisicao(int tipo) {
        this.tipo = tipo;
        this.ocultarConvenio = false;
        if (tipo == 0) {
            this.filtrarFilial = this.filtrarFilial || Acesso.getAcesso(400500110L);
            this.ocultarConvenio = Acesso.getAcesso(Long.valueOf("0400500119"));
            this.ocultaNomePessoa = Acesso.getAcesso(Long.parseLong("0400500114"));
        } else if (tipo == 1) {
            this.filtrarFilial = this.filtrarFilial || Acesso.getAcesso(300100502L);
            this.ocultarConvenio = Acesso.getAcesso(Long.valueOf("0300100504"));
            this.ocultaNomePessoa = Acesso.getAcesso(Long.valueOf("0300100503"));
        }
        this.acessoOcultarMensagem = tipo == 0 ? Acesso.getAcesso(400500107L) : Acesso.getAcesso(300100501L);
        this.EXIBIR_EXAMES = tipo == 0 ? LAUDO_EXIBIR_EXAMES : MAPA_EXIBIR_EXAMES;
        this.POSICAO_DIVISOR = tipo == 0 ? LAUDO_POSICAO_DIVISOR : MAPA_POSICAO_DIVISOR;
        this.OCULTAR_MENSAGEM_MULTIGUIA = tipo == 0 ? LAUDO_OCULTAR_MENSAGEM_MULTIGUIA : MAPA_OCULTAR_MENSAGEM_MULTIGUIA;
        this.setLayout(new BorderLayout());
        if (tipo == 0) {
            Funcoes.criaBarraDescricao(this, "Impress\u00e3o por requisi\u00e7\u00e3o", "Imprime exames de pacientes a partir do c\u00f3digo da requisi\u00e7\u00e3o", "recepcao/impressao_requisicao.jpg");
        } else {
            Funcoes.criaBarraDescricao(this, "Impress\u00e3o por requisi\u00e7\u00e3o", "Imprime os mapas de pacientes a partir do c\u00f3digo da requisi\u00e7\u00e3o", "triagem/mapa_requisicao.jpg");
        }
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBarra, "South");
        this.panelCentro.add((Component)this.panelTopo, "North");
        this.panelCentro.add((Component)this.splitCentro, "Center");
        this.panelTopo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 3, 1, 1)));
        JLabel labelRequisicao = ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o:", new Dimension(70, 20));
        labelRequisicao.setDisplayedMnemonic('R');
        labelRequisicao.setLabelFor(this.textCodigo);
        if (this.filtrarFilial) {
            this.panelTopo.add(this.labelFilial);
            this.panelTopo.add(this.textFilial);
            this.panelTopo.add(this.buttonFilial);
            JPanel p = new JPanel();
            p.setPreferredSize(new Dimension(10, 20));
            this.panelTopo.add(p);
        }
        this.panelTopo.add(labelRequisicao);
        this.panelTopo.add(this.textCodigo);
        this.panelTopo.add(this.buttonBuscaRequisicao);
        this.splitCentro.setBorder(null);
        this.splitCentro.setDividerSize(3);
        this.splitCentro.setDividerLocation(400);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)new JScrollPane(this.tableRequisicoes), "Center");
        JPanel panelTemp = new JPanel(new FlowLayout(2, 3, 3));
        this.panelRequisicoes.add((Component)panelTemp, "South");
        panelTemp.add(this.buttonImprimirTodos);
        panelTemp.add(this.buttonImprimirRequisicao);
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)new JScrollPane(this.tableExames), "Center");
        panelTemp = new JPanel(new BorderLayout());
        this.panelExames.add((Component)panelTemp, "South");
        this.checkOrdenarRequisicao.setVisible(tipo == 1);
        this.checkOrdenarRequisicao.setEnabled(false);
        panelTemp.add((Component)this.checkOrdenarRequisicao, "West");
        panelTemp.add((Component)this.buttonImprimirExame, "East");
        Insets mrg = this.buttonImprimirTodos.getMargin();
        this.buttonImprimirTodos.setMargin(new Insets(mrg.top, 3, mrg.bottom, 3));
        this.buttonImprimirTodos.setFocusable(false);
        this.buttonImprimirRequisicao.setMargin(this.buttonImprimirTodos.getMargin());
        this.buttonImprimirRequisicao.setFocusable(false);
        this.buttonImprimirExame.setMargin(this.buttonImprimirExame.getMargin());
        this.buttonImprimirExame.setFocusable(false);
        this.panelBarra.add((Component)this.panelBarraEsq, "West");
        this.panelBarra.add((Component)this.panelBarraDir, "East");
        this.panelBarraEsq.add(this.buttonExibirOcultarExames);
        this.panelBarraEsq.add(this.checkOcultarMensagemMultiguia);
        this.panelBarraDir.add(this.buttonFechar);
        this.textCodigo.setHorizontalAlignment(4);
        this.textCodigo.setPreferredSize(new Dimension(80, 20));
        this.textFilial.setPreferredSize(new Dimension(80, 20));
        this.textCodigo.addKeyListener(this);
        this.textFilial.addKeyListener(this);
        this.tableRequisicoes.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(-1, -1, 4));
        this.tableRequisicoes.addKeyListener(this);
        this.tableExames.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(0, 0, -1, 0, 0));
        this.buttonBuscaRequisicao.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setPreferredSize(new Dimension(22, 22));
        this.buttonBuscaRequisicao.addActionListener(this);
        this.buttonBuscaRequisicao.setFocusable(false);
        this.buttonExibirOcultarExames.addActionListener(this);
        this.buttonExibirOcultarExames.setFocusable(false);
        this.buttonFechar.setFocusable(false);
        this.modeloRequisicoes.setOrdenarColunas(true);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.tableRequisicoes.getTableHeader().setToolTipText("<html>Clique sobre a coluna para alterar a ordem de impress\u00e3o dos laudos</html>");
        this.checkOcultarMensagemMultiguia.setVisible(this.acessoOcultarMensagem);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        this.textFilial.setText(Variaveis.filialPadrao);
        ScreenUtil.requisitarFoco(this.filtrarFilial ? this.textFilial : this.textCodigo);
        this.carregarParametros();
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                Registro reg = FrmImpressaoRequisicao.this.modeloRequisicoes.getRegistro(FrmImpressaoRequisicao.this.tableRequisicoes.getSelectedRow());
                if (reg != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !(e.getSource() instanceof JButton)) {
                    FrmImpressaoRequisicao.this.validaCampoFilial();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                FrmImpressaoRequisicao.this.textFilial.selectAll();
            }
        });
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !Funcoes.textoVazio(FrmImpressaoRequisicao.this.textCodigo) && Funcoes.processarFuncaoNumeroTubo(FrmImpressaoRequisicao.this.textFilial, (TTextField)FrmImpressaoRequisicao.this.textCodigo)) {
                    FrmImpressaoRequisicao.this.adicionarRequisicao(FrmImpressaoRequisicao.this.getCodigoFilial(), FrmImpressaoRequisicao.this.textCodigo.getText());
                    FrmImpressaoRequisicao.this.textCodigo.setText("");
                    ScreenUtil.requisitarFoco(FrmImpressaoRequisicao.this.textCodigo);
                }
            }
        });
    }

    private boolean validaCampoFilial() {
        return RecepcaoUtil.buscaDadosFilial(this, this.textFilial, this.buttonFilial, false);
    }

    private String getCodigoFilial() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            return this.textFilial.getText();
        }
        return Variaveis.filialPadrao;
    }

    private void pesquisarFilial() {
        Hashtable resultado = Pesquisas.filial(this.getTopLevelAncestor(), false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (e.getKeyCode() == 113) {
            if (o == this.textCodigo) {
                this.pesquisarRequisicao();
            } else if (o == this.textFilial) {
                this.pesquisarFilial();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.textFilial && e.getKeyCode() == 10) {
            if (this.validaCampoFilial()) {
                ScreenUtil.requisitarFoco(this.textCodigo);
            }
        } else if (e.getKeyCode() == 127 && this.tableRequisicoes.getSelectedRow() > -1 && Funcoes.mensagem(this, "Deseja remover as requisi\u00e7\u00f5es selecionadas?", 4) == 0) {
            this.modeloRequisicoes.removerRegistros(this.tableRequisicoes.getSelectedRows());
            this.modeloRequisicoes.fireTableDataChanged();
            if (this.modeloRequisicoes.getRowCount() == 0) {
                this.modeloExames.limpar();
            }
            ScreenUtil.requisitarFoco(this.textCodigo);
        }
    }

    private void setOcultarMensagemMultiguia(boolean b) {
        this.ocultarMensagemMultiguia = b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkOcultarMensagemMultiguia) {
            this.setOcultarMensagemMultiguia(!this.ocultarMensagemMultiguia);
            this.gravarParametros();
        } else if (o == this.buttonExibirOcultarExames) {
            this.exibirOcultarExames(!this.exibirExames);
            this.gravarParametros();
        } else if (o == this.buttonBuscaRequisicao) {
            this.pesquisarRequisicao();
        } else if (o == this.buttonImprimirTodos) {
            this.imprimirTodasRequisicoes();
        } else if (o == this.buttonImprimirRequisicao) {
            this.imprimirRequisicoesSelecionadas();
        } else if (o == this.buttonImprimirExame) {
            this.imprimirExamesSelecionados();
        } else if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.checkOrdenarRequisicao) {
            this.carregarModeloExames(this.tableRequisicoes.getSelectedRow());
            this.gravarParametros();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro exame;
        Object o = e.getSource();
        if (o == this.tableRequisicoes.getSelectionModel()) {
            this.carregarModeloExames(this.tableRequisicoes.getSelectedRow());
            this.buttonImprimirTodos.setEnabled(this.tableRequisicoes.getSelectedRowCount() > 0);
            this.buttonImprimirRequisicao.setEnabled(this.tableRequisicoes.getSelectedRowCount() > 0);
        } else if (o == this.tableExames.getSelectionModel() && (exame = this.modeloExames.getRegistro(this.tableExames.getSelectedRow())) != null) {
            boolean impresso = exame.getBoolean("laudo_impresso");
            if (impresso && !this.getPermiteReimprimirExames()) {
                this.buttonImprimirExame.setEnabled(false);
            } else {
                this.buttonImprimirExame.setEnabled(this.tableExames.getSelectedRowCount() > 0);
            }
        }
    }

    public static long getModuloAcessoLaudo() {
        return 400500103L;
    }

    public static long getModuloAcessoMapa() {
        return 300100500L;
    }

    private void imprimirTodasRequisicoes() {
        if (this.tipo == 0) {
            try {
                boolean maisDeUmaLinha = this.modeloRequisicoes.getRowCount() > 1;
                ArrayList<Registro> requisicoes = new ArrayList<Registro>();
                for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                    requisicoes.add(this.modeloRequisicoes.getRegistro(i));
                }
                for (Registro reg : requisicoes) {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(this.impressoraSelecionada, this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getBoolean(REIMPRIMIR) && this.getPermiteReimprimirExames(), ParametrosGerais.getConferencia(), null, null, null, false, "", false, false, null, false, "", false, false);
                    Conexao.arquivaSQL();
                    String tempo = ParametrosLocais.getParametro("tempoImpressaoLaudo");
                    if (!maisDeUmaLinha || !Funcoes.isNumeric(tempo) || Integer.parseInt(tempo) <= 0) continue;
                    try {
                        Thread.sleep(Integer.parseInt(tempo));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        } else {
            final boolean naoPermiteVisualizarCliente = Acesso.getAcesso(Long.parseLong("0300100503"));
            final Iterator<Registro> itr = new ArrayList<Registro>(this.modeloRequisicoes.getRegistros()).iterator();
            final Timer timer = new Timer(25000, null);
            timer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (itr.hasNext()) {
                            Registro reg = (Registro)itr.next();
                            ImprimirMapa.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, null, reg.getBoolean(FrmImpressaoRequisicao.REIMPRIMIR), false, true, null, naoPermiteVisualizarCliente, FrmImpressaoRequisicao.this.ocultarConvenio, -1);
                        } else {
                            timer.stop();
                        }
                    }
                    catch (Exception ex) {
                        FrmImpressaoRequisicao.this.anularSQL();
                        ErrorLogger.mostraMensagem(FrmImpressaoRequisicao.this, ex.getMessage(), ex.getStackTrace(), "FrmImpressaoRequisicao: 256");
                    }
                }
            });
            timer.setInitialDelay(0);
            timer.start();
        }
        this.modeloRequisicoes.limpar();
        this.modeloExames.limpar();
    }

    private void imprimirRequisicoesSelecionadas() {
        boolean permiteVisualizarPaciente = Acesso.getAcesso(Long.valueOf("0300100503"));
        int[] reqs = this.tableRequisicoes.getSelectedRows();
        if (this.tipo == 0) {
            try {
                RetornoImpressaoResultados retorno = null;
                for (Registro reg : this.modeloRequisicoes.getRegistros(reqs)) {
                    if (null != reg) {
                        retorno = ImpressaoResultados.imprimirExames(this.impressoraSelecionada, this.getTopLevelAncestor(), this.getCodigoFilial(), reg.getString("req_codigo"), reg.getBoolean(REIMPRIMIR) && this.getPermiteReimprimirExames(), false);
                    }
                    if (Funcoes.textoVazio(this.impressoraSelecionada)) {
                        this.impressoraSelecionada = retorno.getImpressoraSelecionada();
                    }
                    if (Funcoes.textoVazio(this.impressoraLaudoSelecionada) || !Funcoes.textoVazio(retorno.getImpressoraSelecionada())) {
                        this.impressoraLaudoSelecionada = retorno.getImpressoraSelecionada();
                    }
                    Conexao.arquivaSQL();
                    String tempo = ParametrosLocais.getParametro("tempoImpressaoLaudo");
                    if (reqs.length <= 1 || !Funcoes.isNumeric(tempo) || Integer.parseInt(tempo) <= 0) continue;
                    try {
                        Thread.sleep(Integer.parseInt(tempo));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoRequisicao: 302");
            }
        } else {
            final Iterator<Registro> itr = new ArrayList<Registro>(this.modeloRequisicoes.getRegistros(reqs)).iterator();
            final Timer timer = new Timer(25000, null);
            timer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (itr.hasNext()) {
                        try {
                            boolean naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0300100503"));
                            Registro reg = (Registro)itr.next();
                            ImprimirMapa.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, null, reg.getBoolean(FrmImpressaoRequisicao.REIMPRIMIR) && FrmImpressaoRequisicao.this.getPermiteReimprimirExames(), false, true, null, naoPermiteVisualizarPaciente, FrmImpressaoRequisicao.this.ocultarConvenio, -1);
                        }
                        catch (Exception ex) {
                            FrmImpressaoRequisicao.this.anularSQL();
                            ErrorLogger.mostraMensagem(FrmImpressaoRequisicao.this, ex.getMessage(), ex.getStackTrace(), "FrmImpressaoRequisicao: 316");
                        }
                    } else {
                        timer.stop();
                    }
                }
            });
            timer.setInitialDelay(0);
            timer.start();
        }
        this.modeloRequisicoes.removerRegistros(reqs);
        this.modeloRequisicoes.fireTableDataChanged();
        if (this.modeloRequisicoes.getRowCount() > 0) {
            this.tableRequisicoes.setRowSelectionInterval(0, 0);
        } else {
            this.modeloExames.limpar();
        }
    }

    private void imprimirExamesSelecionados() {
        Registro reg = this.modeloRequisicoes.getRegistro(this.tableRequisicoes.getSelectedRow());
        List<Registro> exames = this.modeloExames.getRegistros(this.tableExames.getSelectedRows());
        boolean todosExamesPdf = true;
        if (exames.size() > 0 && reg != null) {
            try {
                ArrayList<String> exa = new ArrayList<String>();
                ArrayList<String> mco = new ArrayList<String>();
                for (Registro r : exames) {
                    exa.add(r.getString("exa_codigo"));
                    if (this.tipo == 0) {
                        mco.add(r.getString("mco_codigo"));
                        continue;
                    }
                    exa.add(r.getString("mco_codigo"));
                }
                boolean impresso = false;
                if (this.tipo == 0) {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(this.impressoraSelecionada, this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getBoolean(REIMPRIMIR) && this.getPermiteReimprimirExames(), null, exa.toArray(new String[exa.size()]), mco.toArray(new String[mco.size()]), false);
                    if (Funcoes.textoVazio(this.impressoraSelecionada)) {
                        this.impressoraSelecionada = retorno.getImpressoraSelecionada();
                    }
                    impresso = retorno.isImprimiuResultado();
                } else {
                    boolean naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0300100503"));
                    impresso = ImprimirMapa.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), exa.toArray(new String[exa.size()]), null, reg.getBoolean(REIMPRIMIR) && this.getPermiteReimprimirExames(), false, true, null, naoPermiteVisualizarPaciente, this.ocultarConvenio, -1);
                }
                Conexao.arquivaSQL();
                if (this.tipo == 0 && impresso) {
                    for (Registro r : exames) {
                        r.setValor("situacao", Tipos.tipoSituacaoExame("I"));
                    }
                }
                this.modeloExames.fireTableDataChanged();
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoRequisicao: 306");
            }
        }
    }

    private void updateExameRequisicao(Statement st, String requisicao, String exame, String material, List<String> campos, List<String> valores) throws SQLException {
        if (st != null && campos.size() == valores.size() && campos.size() > 0) {
            StringBuilder bui = new StringBuilder("update examerequisicao set ");
            boolean gravarHistorico = false;
            String situacao = "";
            String motivoRecoleta = "";
            String justificativaRecoleta = "";
            for (int i = 0; i < campos.size(); ++i) {
                bui.append(i > 0 ? ", " : "");
                bui.append(campos.get(i));
                bui.append(" = ");
                bui.append(Funcoes.textoVazio(valores.get(i)) ? "null" : valores.get(i));
                if (campos.get(i).equalsIgnoreCase("exr_situacao")) {
                    gravarHistorico = true;
                    situacao = valores.get(i).replaceAll("'", "");
                }
                if (campos.get(i).equalsIgnoreCase("mrc_codigo")) {
                    motivoRecoleta = valores.get(i).replaceAll("'", "");
                }
                if (!campos.get(i).equalsIgnoreCase("exr_motivorecoleta")) continue;
                justificativaRecoleta = valores.get(i).replaceAll("'", "");
            }
            bui.append(" where fil_codigo = ");
            bui.append(this.getCodigoFilial());
            bui.append(" and req_codigo = ");
            bui.append(requisicao);
            bui.append(" and exa_codigo = '");
            bui.append(StringUtil.textoDB(exame));
            bui.append("' and mco_codigo = ");
            bui.append(material);
            if (gravarHistorico && situacao.equalsIgnoreCase("R")) {
                DBUtil.gravaLogSituacaoExameRequisicao(st, this.getCodigoFilial(), requisicao, exame, material, situacao, false, motivoRecoleta, justificativaRecoleta);
            } else {
                DBUtil.gravaLogSituacaoExameRequisicao(st, this.getCodigoFilial(), requisicao, exame, material, situacao, false);
            }
            Conexao.executeUpdate(this.getCodigoFilial(), st, bui.toString());
        }
    }

    private void pesquisarRequisicao() {
        Hashtable res = Pesquisas.requisicao(this.getTopLevelAncestor(), this.getCodigoFilial(), false, false, null, null, null, false, this.ocultaNomePessoa, false, this.ocultarConvenio);
        if (res != null) {
            this.adicionarRequisicao(this.getCodigoFilial(), res.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    private void carregarModeloExames(int linha) {
        if (linha >= 0 && linha < this.modeloRequisicoes.getRowCount()) {
            Registro reg = this.modeloRequisicoes.getRegistro(linha);
            ImpressaoResultados.carregarExames(reg.getString("fil_codigo"), reg.getString("req_codigo"), this.modeloExames, this.tipo == 1 && this.checkOrdenarRequisicao.isSelected());
            this.checkOrdenarRequisicao.setEnabled(true);
        }
    }

    protected void adicionarRequisicao(String codigoFilial, String codigoRequisicao) {
        if (codigoRequisicao != null && codigoRequisicao.matches("\\-?\\d+")) {
            if (this.requisicaoJaAdicionada(codigoFilial, codigoRequisicao)) {
                Funcoes.mensagem(this, String.format(MENSAGEM_REQUISICAO_ADICIONADA, codigoRequisicao), 1);
            } else {
                Registro reg = this.verificaRequisicao(codigoFilial, codigoRequisicao);
                if (reg != null) {
                    this.modeloRequisicoes.addRegistro(reg);
                    this.modeloRequisicoes.fireTableDataChanged();
                    Integer[] multi = this.getMultiguia(codigoFilial, codigoRequisicao);
                    if (!this.checkOcultarMensagemMultiguia.isSelected() && multi != null && Funcoes.mensagem(this, this.getMensagemMultiguia(multi), 4, true) == 0) {
                        for (int i = 0; i < multi.length; ++i) {
                            reg = this.verificaRequisicao(codigoFilial, multi[i].toString());
                            if (reg == null || this.requisicaoJaAdicionada(codigoFilial, multi[i].toString())) continue;
                            this.modeloRequisicoes.addRegistro(reg);
                            this.modeloRequisicoes.fireTableDataChanged();
                        }
                    }
                    if (this.modeloRequisicoes.getRowCount() > 0) {
                        this.tableRequisicoes.setRowSelectionInterval(this.tableRequisicoes.getRowCount() - 1, this.tableRequisicoes.getRowCount() - 1);
                    }
                }
            }
        }
    }

    private String getMensagemMultiguia(Integer[] multi) {
        StringBuilder mensagem = new StringBuilder("A requisi\u00e7\u00e3o possui ");
        mensagem.append(multi.length > 1 ? "as seguintes multiguias:\n" : "a seguinte multiguia:\n");
        for (Integer numReq : multi) {
            mensagem.append(numReq).append(", ");
        }
        mensagem.replace(mensagem.length() - 2, mensagem.length(), "");
        mensagem.append("\nDeseja adicionar multiguias?");
        return mensagem.toString();
    }

    private boolean requisicaoJaAdicionada(String codigoFilial, String codigoRequisicao) {
        List<Registro> registros = this.modeloRequisicoes.getRegistros();
        int filial = -1;
        String requisicao = null;
        if (Funcoes.isNumeric(codigoFilial)) {
            filial = Integer.parseInt(codigoFilial);
        }
        if (Funcoes.isNumeric(codigoRequisicao)) {
            requisicao = codigoRequisicao;
        }
        for (Registro r : registros) {
            if (r.getInt("fil_codigo") != filial || !String.valueOf(r.getInt("req_codigo")).equals(requisicao)) continue;
            return true;
        }
        return false;
    }

    protected Registro verificaRequisicao(String codigoFilial, String codigoRequisicao) {
        Registro reg = null;
        String laudoIncompleto = "A requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" n\u00e3o est\u00e1 completa. Deseja imprimir?";
        String laudoImpresso = "A requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" j\u00e1 cont\u00e9m exames impressos. Deseja reimprimir?";
        String mapaImpresso = "A requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" j\u00e1 cont\u00e9m mapas impressos. Deseja reimprimir?";
        boolean imprimirIncompleto = false;
        if (codigoRequisicao.matches("\\-?\\d+")) {
            SituacaoRequisicao sit = new SituacaoRequisicao(codigoFilial, codigoRequisicao);
            if (!sit.existe()) {
                Funcoes.mensagem(this, String.format(MENSAGEM_REQUISICAO_INEXISTENTE, codigoRequisicao), 1);
            } else if (this.tipo == 1) {
                boolean ok = sit.contemMapaImpresso();
                if (!ok || Funcoes.mensagem(this, mapaImpresso, 4, true) == 0) {
                    reg = ImpressaoResultados.getRequisicao(codigoFilial, codigoRequisicao);
                    if (ok) {
                        reg.setValor(REIMPRIMIR, Boolean.TRUE);
                    }
                }
            } else if (!sit.contemLancado()) {
                Funcoes.mensagem(this, String.format(MENSAGEM_REQUISICAO_SEM_EXAME_LANCADO, codigoRequisicao), 2);
            } else if (!this.acessoImprimirDevedor && sit.saldoDevedor) {
                Funcoes.mensagem(this, String.format(MENSAGEM_REQUISICAO_DEVEDORA, codigoRequisicao), 2);
            } else if (!this.acessoImprimirDevedor && sit.isDeveGuia()) {
                Funcoes.mensagem(this, String.format(MENSAGEM_REQUISICAO_SEM_PEDIDO_GUIA, codigoRequisicao), 2);
            } else {
                boolean ok;
                boolean bl = ok = sit.todosConferidos() || sit.todosLancados() && !ParametrosGerais.getConferencia();
                if (sit.isDeveGuia() || sit.saldoDevedor()) {
                    Funcoes.mensagem(this, String.format(sit.isDeveGuia() ? MENSAGEM_REQUISICAO_SEM_PEDIDO_GUIA : MENSAGEM_REQUISICAO_DEVEDORA, codigoRequisicao), 2);
                }
                boolean bl2 = ok || (imprimirIncompleto = Funcoes.mensagem(this, laudoIncompleto, 4, true) == 0) ? true : (ok = false);
                if (ok) {
                    if (sit.contemLaudoImpresso()) {
                        if (sit.todosLaudosImpressos() && !this.getPermiteReimprimirExames()) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Todos os exames foram impressos.\nUsu\u00e1rio n\u00e3o possui acesso para reimpress\u00e3o.", 2);
                            return null;
                        }
                        if (!sit.todosLaudosImpressos() && !this.getPermiteReimprimirExames()) {
                            boolean bl3 = ok = Funcoes.mensagem(this, "Os seguintes exames j\u00e1 foram impressos:\n" + this.quebraString(RecepcaoUtil.getExameImpresso(codigoFilial, codigoRequisicao)) + ".\nO usu\u00e1rio " + Variaveis.login + " n\u00e3o possui permiss\u00e3o para reimprimir.\nDeseja imprimir os demais exames?", 4, true) == 0;
                            if (!ok) {
                                return null;
                            }
                        } else if (!imprimirIncompleto) {
                            boolean bl4 = ok = Funcoes.mensagem(this, laudoImpresso, 4, true) == 0;
                        }
                        if (ok || !sit.todosLaudosImpressos()) {
                            reg = ImpressaoResultados.getRequisicao(codigoFilial, codigoRequisicao);
                            reg.setValor(REIMPRIMIR, ok);
                        }
                    } else {
                        reg = ImpressaoResultados.getRequisicao(codigoFilial, codigoRequisicao);
                        reg.setValor(REIMPRIMIR, false);
                    }
                }
            }
        }
        if (reg != null && Acesso.getAcesso(Long.valueOf("0300100503")) && this.tipo == 1) {
            reg.setValor("pac_nome", "Visualiza\u00e7\u00e3o n\u00e3o permitida");
        } else if (reg != null && Acesso.getAcesso(Long.valueOf("0400500114")) && this.tipo == 0) {
            reg.setValor("pac_nome", "Visualiza\u00e7\u00e3o n\u00e3o permitida");
        }
        return reg;
    }

    private String quebraString(String examesImpresso) {
        if (Funcoes.textoVazio(examesImpresso)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int cont = 0;
        examesImpresso = StringUtil.limpaString(examesImpresso, new String[]{"[", "]"});
        for (int i = 0; i < examesImpresso.toCharArray().length; ++i) {
            if (examesImpresso.toCharArray()[i] == ',') {
                if (++cont == 10) {
                    buf.append("\n");
                    cont = 0;
                    continue;
                }
                buf.append(examesImpresso.toCharArray()[i]);
                continue;
            }
            buf.append(examesImpresso.toCharArray()[i]);
        }
        return buf.toString();
    }

    private Integer[] getMultiguia(String codigoFilial, String codigoRequisicao) {
        Integer[] multi = new Integer[]{};
        try {
            multi = RecepcaoUtil.verificaMultiGuias(codigoFilial, codigoRequisicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoRequisicao: 435");
        }
        return multi;
    }

    private void exibirOcultarExames(boolean exibir) {
        this.exibirExames = exibir;
        this.buttonExibirOcultarExames.setText(exibir ? "Ocultar exames" : "Exibir exames");
        this.buttonExibirOcultarExames.setMnemonic(exibir ? (char)'O' : 'E');
        if (exibir) {
            this.splitCentro.setRightComponent(this.panelExames);
            this.splitCentro.setDividerLocation(this.posicaoDivisor);
        } else {
            this.posicaoDivisor = this.splitCentro.getDividerLocation();
            this.splitCentro.remove(this.panelExames);
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(this.EXIBIR_EXAMES)) {
            this.exibirExames = StringUtil.getBoolean(ParametrosUsuarios.getValor(this.EXIBIR_EXAMES));
        }
        if (ParametrosUsuarios.contemParametro(this.POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(this.POSICAO_DIVISOR));
        }
        if (ParametrosUsuarios.contemParametro(this.OCULTAR_MENSAGEM_MULTIGUIA)) {
            this.checkOcultarMensagemMultiguia.setSelected(StringUtil.getBoolean(ParametrosUsuarios.getValor(this.OCULTAR_MENSAGEM_MULTIGUIA)));
        }
        if (ParametrosUsuarios.contemParametro(LAUDO_ORDEM_ADICAO)) {
            this.checkImprimirOrdemAdicao.setSelected(StringUtil.getBoolean(ParametrosUsuarios.getValor(LAUDO_ORDEM_ADICAO)));
        }
        if (ParametrosUsuarios.contemParametro(MAPA_ORDENACAO_REQUISICAO)) {
            this.checkOrdenarRequisicao.setSelected(StringUtil.getBoolean(ParametrosUsuarios.getValor(MAPA_ORDENACAO_REQUISICAO)));
        }
        this.setOcultarMensagemMultiguia(this.checkOcultarMensagemMultiguia.isSelected());
        this.exibirOcultarExames(this.exibirExames);
    }

    private void gravarParametros() {
        ParametrosUsuarios.setValor(this.EXIBIR_EXAMES, String.valueOf(this.exibirExames));
        ParametrosUsuarios.setValor(this.POSICAO_DIVISOR, String.valueOf(this.exibirExames ? this.splitCentro.getDividerLocation() : this.posicaoDivisor));
        ParametrosUsuarios.setValor(this.OCULTAR_MENSAGEM_MULTIGUIA, String.valueOf(this.ocultarMensagemMultiguia));
        ParametrosUsuarios.setValor(LAUDO_ORDEM_ADICAO, String.valueOf(this.checkImprimirOrdemAdicao.isSelected()));
        ParametrosUsuarios.setValor(MAPA_ORDENACAO_REQUISICAO, String.valueOf(this.checkOrdenarRequisicao.isSelected()));
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoRequisicao: 485");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private boolean getPermiteReimprimirExames() {
        boolean possuiAcesso = Acesso.getAcesso(Long.parseLong("0400500121"));
        return !possuiAcesso;
    }

    protected ModeloResultSet getModeloRequisicoes() {
        return this.modeloRequisicoes;
    }
}

