/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoNotificacao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.notificacao.NotificacaoService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.Legenda;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class FrmImpressaoNotificacaoExame
extends FrmPadrao
implements ActionListener {
    private static final String ULTIMO_FILTRO = "FrmImpressaoNotificacao.ultimoFiltro";
    private static final String DATA = "data";
    private static final String SITUACAO = "situacao";
    private final int EXAME_NOTIFICACAO = 5;
    private JCheckBox checkOrdemPaciente = new JCheckBox("Ordenar por paciente");
    private JCheckBox checkExamesProntos = new JCheckBox("Todos os exames prontos");
    private JCheckBox checkMultiguiaRespeitaFiltro = new JCheckBox("Multiguias respeitam os filtros");
    private JCheckBox checkConsiderarFiltroMapa = new JCheckBox("Considerar filtro ao imprimir");
    private JCheckBox checkAgruparMultiguias = new JCheckBox("Agrupar multiguias");
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelBarraExames = new JPanel(new FlowLayout(0, 0, 3));
    private JProgressBar progress = new JProgressBar();
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private JTabbedPane tabbedRequisicoes = new JTabbedPane();
    private JTabbedPane tabbedExames = new JTabbedPane();
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonExibirOcultar = ComponenteFactory.novoJButton(this, null, null, false);
    private JButton buttonImprimirRequisicoes = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private JButton buttonImprimirTodos = ComponenteFactory.novoJButton("Imprimir Todos", 'T', this, null, null, false);
    private JButton buttonImprimirExames = ComponenteFactory.novoJButton("Imprimir", 'm', this, null, null, false);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonParar = ComponenteFactory.novoJButton("Parar", 'P', this, null, null);
    private ModeloResultSet modeloRequisicoes = new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "data");
    private ModeloResultSet modeloExames = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Material", "mco_abreviatura", "Situa\u00e7\u00e3o", "situacao", "Notificacao", "exr_notificacao");
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemPrioridade;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemExame;
    private CheckItemFiltro itemSetor;
    private CorTableCellRenderer rendererExame = new CorTableCellRenderer();
    private JPanel panelFiltro;
    private static String impressoraSelecionada;
    private Legenda panelLegenda = new Legenda(10);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoNotificacaoExame.this.carregarExames();
        }
    }, new int[0]);
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoNotificacaoExame.this.carregarExames();
        }
    }, 70, 0, 85);
    ListSelectionListener listenerExames = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoNotificacaoExame.this.validarBotaoImprimirExames();
        }
    };
    private boolean exibirExames = true;
    private boolean pararImpressao = false;
    private int posicaoDivisor = 350;
    private boolean filtrarFilial = !ParametrosGerais.getTipoIntegracao().equals("N");
    private boolean ocultarConvenio;

    public FrmImpressaoNotificacaoExame() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Impress\u00e3o de Notifica\u00e7\u00f5es de Exames", "Impress\u00e3o das notifica\u00e7\u00f5es configuradas nos exames", "recepcao/notificacoes.jpg");
        this.buttonImprimirExames.setVisible(false);
        JPanel panelTemp = new JPanel(new BorderLayout());
        this.add((Component)panelTemp, "Center");
        this.panelFiltro = new JPanel();
        panelTemp.add((Component)this.panelFiltro, "North");
        this.montarPanelFiltro(this.panelFiltro);
        panelTemp.add((Component)this.progress, "South");
        panelTemp.add((Component)this.splitCentral, "Center");
        this.progress.setStringPainted(true);
        this.progress.setString("");
        this.progress.setVisible(false);
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        panelTemp = new JPanel(new BorderLayout());
        this.add((Component)panelTemp, "South");
        JPanel panelAux = new JPanel(new FlowLayout(0, 3, 3));
        panelTemp.add((Component)panelAux, "West");
        this.buttonExibirOcultar.setText("Ocultar exames");
        panelAux.add(this.buttonExibirOcultar);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        panelTemp.add((Component)panelAux, "East");
        panelAux.add(this.buttonParar);
        panelAux.add(this.buttonFechar);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.tabbedRequisicoes, "Center");
        panelTemp = new JPanel(new FlowLayout(2, 0, 3));
        this.panelRequisicoes.add((Component)panelTemp, "South");
        panelAux = new JPanel();
        panelAux.setPreferredSize(new Dimension(3, 10));
        panelTemp.add(this.buttonImprimirTodos);
        panelTemp.add(panelAux);
        panelTemp.add(this.buttonImprimirRequisicoes);
        Insets mrg = this.buttonImprimirTodos.getMargin();
        this.buttonImprimirTodos.setMargin(new Insets(mrg.top, 3, mrg.bottom, 3));
        this.buttonImprimirRequisicoes.setMargin(this.buttonImprimirTodos.getMargin());
        this.buttonImprimirExames.setMargin(this.buttonImprimirTodos.getMargin());
        this.buttonParar.setVisible(false);
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelBarraExames.add(this.buttonImprimirExames);
        this.panelLegenda.addItem(Color.GREEN, "Notifica\u00e7\u00e3o preenchida");
        this.panelBarraExames.add(this.panelLegenda.getPanel());
        this.panelExames.add((Component)this.panelBarraExames, "South");
        this.panelExames.revalidate();
        this.panelExames.repaint();
        this.tabbedRequisicoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FrmImpressaoNotificacaoExame.this.carregarExames();
            }
        });
        this.tabbedExames.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FrmImpressaoNotificacaoExame.this.validarBotaoImprimirExames();
            }
        });
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int linha = -1;
                    linha = FrmImpressaoNotificacaoExame.this.tableRequisicoes.getSelectedRow();
                    if (linha > -1 && Funcoes.mensagem(FrmImpressaoNotificacaoExame.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        ((ModeloResultSet)FrmImpressaoNotificacaoExame.this.tableExames.getModel()).limpar();
                        FrmImpressaoNotificacaoExame.this.modeloRequisicoes.removerRegistro(linha);
                        FrmImpressaoNotificacaoExame.this.modeloRequisicoes.fireTableDataChanged();
                        if (FrmImpressaoNotificacaoExame.this.tableRequisicoes.getRowCount() > 0) {
                            ScreenUtil.requisitarFoco(FrmImpressaoNotificacaoExame.this.tableRequisicoes);
                        }
                    }
                }
            }
        });
        this.modeloRequisicoes.setOrdenarColunas(true);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.rendererExame.setAlinhamentoColuna(0, 2);
        this.rendererExame.setAlinhamentoColuna(2, 0);
        this.tableExames.setDefaultRenderer(Object.class, this.rendererExame);
        this.tableExames.setDefaultRenderer(Number.class, this.rendererExame);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableRequisicoes.getColumnModel().getColumn(2).setMinWidth(80);
        this.carregarParametros();
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                Registro reg = FrmImpressaoNotificacaoExame.this.modeloRequisicoes.getRegistro(FrmImpressaoNotificacaoExame.this.tableRequisicoes.getSelectedRow());
                if (reg != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
            }
        });
        this.checkAgruparMultiguias.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FrmImpressaoNotificacaoExame.this.checkAgruparMultiguias.isSelected() && !FrmImpressaoNotificacaoExame.this.checkMultiguiaRespeitaFiltro.isSelected()) {
                    FrmImpressaoNotificacaoExame.this.checkMultiguiaRespeitaFiltro.setSelected(true);
                }
            }
        });
        this.checkMultiguiaRespeitaFiltro.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!FrmImpressaoNotificacaoExame.this.checkMultiguiaRespeitaFiltro.isSelected() || !FrmImpressaoNotificacaoExame.this.checkAgruparMultiguias.isSelected()) {
                    FrmImpressaoNotificacaoExame.this.checkAgruparMultiguias.setSelected(false);
                }
            }
        });
    }

    @Override
    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block20: {
            try {
                Object o = e.getSource();
                if (o == this.buttonDataIni) {
                    Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
                    break block20;
                }
                if (o == this.buttonDataFin) {
                    Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
                    break block20;
                }
                if (o == this.buttonFechar) {
                    this.acaoFechar();
                    break block20;
                }
                if (o == this.buttonParar) {
                    this.pararImpressao = true;
                    break block20;
                }
                if (o == this.buttonConsultar) {
                    this.consultarRequisicoes();
                    try {
                        this.modeloRequisicoes.ordenarColuna(0, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.gravarParametros();
                    break block20;
                }
                if (o == this.buttonExibirOcultar) {
                    this.exibirOcultarExames(!this.exibirExames);
                    this.gravarParametros();
                } else if (o == this.buttonImprimirRequisicoes) {
                    if (this.tableRequisicoes.getSelectedRows().length > 0) {
                        this.imprimirRequisicoes(this.modeloRequisicoes, this.tableRequisicoes.getSelectedRows());
                    } else {
                        int[] linhas = new int[this.tableRequisicoes.getRowCount()];
                        for (int i = 0; i < linhas.length; ++i) {
                            linhas[i] = i;
                        }
                        this.imprimirRequisicoes(this.modeloRequisicoes, linhas);
                    }
                } else if (o == this.buttonImprimirTodos) {
                    int[] linhas = new int[this.tableRequisicoes.getRowCount()];
                    for (int i = 0; i < linhas.length; ++i) {
                        linhas[i] = i;
                    }
                    this.imprimirRequisicoes(this.modeloRequisicoes, linhas);
                } else if (o == this.buttonImprimirExames) {
                    this.imprimirExames();
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmImpressaoNotificacaoExame: 217");
            }
        }
    }

    private void acaoFechar() {
        impressoraSelecionada = "";
        this.setVisible(false);
        if (this.getParent() != null) {
            this.getParent().removeAll();
        }
    }

    private void montarPanelFiltro(JPanel panel) {
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        Dimension dim = new Dimension(150, 20);
        cons.fill = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.gridx = 0;
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setPreferredSize(dim);
        this.itemFilial.setMinimumSize(dim);
        cons.gridy = 0;
        if (this.filtrarFilial) {
            panel.add((Component)this.itemFilial, cons);
            ++cons.gridy;
        }
        this.itemColeta = new CheckItemFiltro("Coletas", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dim);
        this.itemColeta.setMinimumSize(dim);
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dim);
        this.itemDestino.setMinimumSize(dim);
        panel.add((Component)this.itemDestino, cons);
        this.ocultarConvenio = false;
        if (!this.ocultarConvenio) {
            ++cons.gridy;
            this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            this.itemConvenio.setColunaHint(1);
            this.itemConvenio.setPreferredSize(dim);
            this.itemConvenio.setMinimumSize(dim);
            panel.add((Component)this.itemConvenio, cons);
        }
        ++cons.gridy;
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dim);
        this.itemExame.setMinimumSize(dim);
        panel.add((Component)this.itemExame, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.insets = new Insets(1, 20, 1, 1);
        this.itemPrioridade = new CheckItemFiltro("Prioridade", "Filtrar", "Filtrando prioridades", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPrioridade.setDados("prioridade", new String[]{"pri_codigo", "pri_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemPrioridade.setColunaHint(1);
        this.itemPrioridade.setPreferredSize(dim);
        this.itemPrioridade.setMinimumSize(dim);
        panel.add((Component)this.itemPrioridade, cons);
        ++cons.gridy;
        this.itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, true);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(2);
        this.itemMedico.setPreferredSize(dim);
        this.itemMedico.setMinimumSize(dim);
        panel.add((Component)this.itemMedico, cons);
        ++cons.gridy;
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSituacao.setDados(SITUACAO, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemSituacao.setPreferredSize(dim);
        this.itemSituacao.setMinimumSize(dim);
        panel.add((Component)this.itemSituacao, cons);
        ++cons.gridy;
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setPreferredSize(dim);
        this.itemSetor.setMinimumSize(dim);
        panel.add((Component)this.itemSetor, cons);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.anchor = 17;
        this.textDataIni.setPreferredSize(new Dimension(100, 20));
        this.textDataIni.setMinimumSize(new Dimension(100, 20));
        this.buttonDataIni.setFocusable(false);
        this.buttonDataIni.setPreferredSize(new Dimension(20, 20));
        this.buttonDataIni.setMinimumSize(new Dimension(20, 20));
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 0, 1, 1);
        panel.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 2;
        this.textDataFin.setPreferredSize(new Dimension(100, 20));
        this.textDataFin.setMinimumSize(new Dimension(100, 20));
        this.buttonDataFin.setFocusable(false);
        this.buttonDataFin.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFin.setMinimumSize(new Dimension(20, 20));
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 0, 1, 1);
        panel.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 2;
        cons.gridwidth = 3;
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.checkExamesProntos, cons);
        ++cons.gridy;
        cons.gridx = 2;
        cons.gridwidth = 3;
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.checkMultiguiaRespeitaFiltro, cons);
        ++cons.gridy;
        cons.gridx = 2;
        cons.gridwidth = 3;
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.checkAgruparMultiguias, cons);
        cons.gridx = 6;
        cons.gridwidth = 2;
        cons.anchor = 17;
        this.buttonConsultar.setPreferredSize(new Dimension(110, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(110, 20));
        cons.insets = new Insets(1, 5, 1, 1);
        panel.add((Component)this.buttonConsultar, cons);
        cons.gridy = 0;
        cons.gridx = 6;
        cons.weightx = 1.0;
        cons.fill = 2;
        panel.add((Component)new JPanel(), cons);
    }

    private void consultarRequisicoes() {
        if (Funcoes.textoVazio(this.textDataIni.getText()) || Funcoes.textoVazio(this.textDataFin.getText())) {
            Funcoes.mensagem(this, "Os campos \"Data Inicial\" e \"Data Final\" devem ser informados!", 2);
        } else if (Funcoes.verificaData(this.textDataIni.getText()) && Funcoes.verificaData(this.textDataFin.getText())) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String SQL = "";
                    try {
                        FrmImpressaoNotificacaoExame.this.progress.setString("Pesquisando. Aguarde...");
                        FrmImpressaoNotificacaoExame.this.progress.setValue(0);
                        FrmImpressaoNotificacaoExame.this.progress.setIndeterminate(true);
                        FrmImpressaoNotificacaoExame.this.progress.setVisible(true);
                        FrmImpressaoNotificacaoExame.this.tabbedRequisicoes.removeAll();
                        FrmImpressaoNotificacaoExame.this.tabbedExames.removeAll();
                        FrmImpressaoNotificacaoExame.this.modeloRequisicoes.limpar();
                        FrmImpressaoNotificacaoExame.this.rendererExame.limpar();
                        FrmImpressaoNotificacaoExame.this.habilitarDesabilitar(false);
                        Statement st = Conexao.getStatement();
                        if (st != null) {
                            String filiais = Variaveis.filialPadrao;
                            if (FrmImpressaoNotificacaoExame.this.itemFilial.isSelected() && FrmImpressaoNotificacaoExame.this.itemFilial.getSelecionados(0) != null && FrmImpressaoNotificacaoExame.this.itemFilial.getSelecionados(0).length > 0) {
                                filiais = ImpressaoNotificacao.getExpressao("a.fil_codigo", FrmImpressaoNotificacaoExame.this.itemFilial.getSelecionados(0), false);
                            }
                            SQL = ImpressaoNotificacao.getSelectRequisicaoExame(filiais, FrmImpressaoNotificacaoExame.this.getFiltro(), null, true);
                            Registro[] consultados = Registro.getRegistros(Conexao.executeQuery(st, SQL));
                            FrmImpressaoNotificacaoExame.this.progress.setMaximum(consultados.length);
                            FrmImpressaoNotificacaoExame.this.progress.setIndeterminate(false);
                            FrmImpressaoNotificacaoExame.this.progress.setString(StringUtil.getStringProgresso("Consultando: ", FrmImpressaoNotificacaoExame.this.progress));
                            int indice = 0;
                            while (indice < consultados.length) {
                                FrmImpressaoNotificacaoExame.this.progress.setValue(indice);
                                FrmImpressaoNotificacaoExame.this.progress.setString(StringUtil.getStringProgresso("Consultando: ", FrmImpressaoNotificacaoExame.this.progress));
                                Registro reg = consultados[indice];
                                indice = FrmImpressaoNotificacaoExame.this.adicionaRequisicaoModelo(consultados, indice);
                                Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(reg.getString("fil_codigo"), reg.getString("req_codigo"));
                                int i = 0;
                                while (multiguias != null && i < multiguias.length) {
                                    SQL = ImpressaoNotificacao.getSelectRequisicaoExame(filiais, FrmImpressaoNotificacaoExame.this.checkMultiguiaRespeitaFiltro.isSelected() ? FrmImpressaoNotificacaoExame.this.getFiltro() : null, multiguias[i++], true);
                                    Registro[] multi = Registro.getRegistros(Conexao.executeQuery(st, SQL));
                                    if (multi == null || multi.length <= 0) continue;
                                    FrmImpressaoNotificacaoExame.this.adicionaRequisicaoModelo(multi, 0);
                                }
                            }
                            FrmImpressaoNotificacaoExame.this.tabbedRequisicoes.addTab("Requisi\u00e7\u00f5es", new JScrollPane(FrmImpressaoNotificacaoExame.this.tableRequisicoes));
                            FrmImpressaoNotificacaoExame.this.tabbedRequisicoes.addChangeListener(new ChangeListener(){

                                @Override
                                public void stateChanged(ChangeEvent e) {
                                    int tab = FrmImpressaoNotificacaoExame.this.tabbedRequisicoes.getSelectedIndex();
                                    FrmImpressaoNotificacaoExame.this.carregarModeloExames(FrmImpressaoNotificacaoExame.this.modeloRequisicoes, FrmImpressaoNotificacaoExame.this.tableRequisicoes.getSelectedRow(), FrmImpressaoNotificacaoExame.this.getFiltroExames());
                                    FrmImpressaoNotificacaoExame.this.validarBotoesImprimirRequisicoes(FrmImpressaoNotificacaoExame.this.tableRequisicoes, FrmImpressaoNotificacaoExame.this.modeloRequisicoes);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(FrmImpressaoNotificacaoExame.this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "FrmImpressaoNotificacaoExame: 408");
                    }
                    finally {
                        FrmImpressaoNotificacaoExame.this.habilitarDesabilitar(true);
                        FrmImpressaoNotificacaoExame.this.progress.setVisible(false);
                        FrmImpressaoNotificacaoExame.this.validarBotoesImprimirRequisicoes(FrmImpressaoNotificacaoExame.this.tableRequisicoes, FrmImpressaoNotificacaoExame.this.modeloRequisicoes);
                    }
                }
            }.start();
        }
    }

    private int adicionaRequisicaoModelo(Registro[] regs, int indice) {
        try {
            if (regs[indice].getString("req_codigo") == null) {
                return -1;
            }
            int i = indice;
            int req = regs[indice].getInt("req_codigo");
            String filCodigo = regs[indice].getString("fil_codigo");
            regs[indice].setValor(DATA, Funcoes.formataData("dd/MM/yyyy", regs[indice].getDate("req_data")));
            if (this.checkAgruparMultiguias.isSelected()) {
                Integer[] filhas = null;
                filhas = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, regs[indice].getString("req_codigo"));
            }
            if (!this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice])) {
                this.modeloRequisicoes.addRegistro(regs[indice]);
            }
            return i + 1;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoNotificacaoExame: 472");
            return indice + 1;
        }
    }

    public static boolean getTodosExamesConferidos(Statement st, String filial, String codigoRequisicao, Integer[] filhas) throws Exception {
        if (st == null) {
            throw new Exception("Erro ao verificar se todos os exames da requisi\u00e7\u00e3o est\u00e3o conferidos. Statement = NULL.");
        }
        StringBuilder bui = new StringBuilder();
        bui.append(" select SUM(CASE WHEN exr_situacao IN ('").append("C").append("', '").append("I").append("', '").append("E").append("') THEN 1 ELSE 0 END) = COUNT(*) as todosConferidos ");
        bui.append("   from examerequisicao ");
        bui.append("  where fil_codigo = ").append(filial);
        bui.append("    and req_codigo  in ( ").append(codigoRequisicao).append(" ");
        if (null != filhas) {
            for (int i = 0; i < filhas.length; ++i) {
                bui.append(", ").append(filhas[i]);
            }
        }
        bui.append(" )");
        bui.append("    and not exr_excluido ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            return rs.getBoolean("todosConferidos");
        }
        return false;
    }

    private boolean contemRequisicao(Registro[] regs, Registro reg) {
        int req = reg.getInt("req_codigo");
        for (int i = 0; i < regs.length; ++i) {
            if (regs[i].getInt("req_codigo") != req) continue;
            return true;
        }
        return false;
    }

    private boolean contemExameRequisicao(List<Registro> registros, Registro reg) {
        int req = reg.getInt("req_codigo");
        String exa = reg.getString("exa_codigo");
        int mat = reg.getInt("mat_codigo");
        String filCodigo = reg.getString("fil_codigo");
        for (int i = 0; i < registros.size(); ++i) {
            Registro aux = registros.get(i);
            if (aux.getInt("req_codigo") != req || !aux.getString("exa_codigo").equalsIgnoreCase(exa) || aux.getInt("mat_codigo") != mat || !aux.getString("fil_codigo").equalsIgnoreCase(filCodigo)) continue;
            return true;
        }
        return false;
    }

    private void imprimirRequisicoes(final ModeloResultSet mod, final int[] linhas) {
        this.pararImpressao = false;
        this.habilitarDesabilitar(false);
        this.buttonParar.setVisible(true);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<Registro> regs = mod.getRegistros(linhas);
                    FrmImpressaoNotificacaoExame.this.buttonConsultar.setEnabled(false);
                    FrmImpressaoNotificacaoExame.this.progress.setMaximum(regs.size());
                    FrmImpressaoNotificacaoExame.this.progress.setValue(0);
                    FrmImpressaoNotificacaoExame.this.progress.setString("Imprimindo: 0%");
                    FrmImpressaoNotificacaoExame.this.progress.setVisible(true);
                    int resp = -1;
                    for (int i = 0; i < regs.size() && !FrmImpressaoNotificacaoExame.this.pararImpressao; ++i) {
                        Registro reg = regs.get(i);
                        FrmImpressaoNotificacaoExame.this.progress.setValue(i + 1);
                        FrmImpressaoNotificacaoExame.this.progress.setString("Imprimindo: " + (int)(FrmImpressaoNotificacaoExame.this.progress.getPercentComplete() * 100.0) + " %");
                        NotificacaoService service = new NotificacaoService();
                        service.imprimirRequisicao(FrmImpressaoNotificacaoExame.this.getFiltroExames(), reg);
                        Conexao.arquivaSQL();
                        if (FrmImpressaoNotificacaoExame.this.tabbedRequisicoes.getSelectedIndex() == 0) {
                            if (linhas.length == 1 && FrmImpressaoNotificacaoExame.this.todosExamesImpressos(mod.getRegistro(linhas[0]).getString("req_codigo"), mod.getRegistro(linhas[0]).getString("fil_codigo"))) {
                                Registro regReq = mod.getRegistro(linhas[0]);
                                FrmImpressaoNotificacaoExame.this.modeloRequisicoes.removerRegistro(regReq);
                                FrmImpressaoNotificacaoExame.this.modeloRequisicoes.fireTableDataChanged();
                                FrmImpressaoNotificacaoExame.this.tabbedRequisicoes.setSelectedIndex(0);
                            }
                            FrmImpressaoNotificacaoExame.this.consultarRequisicoes();
                        }
                        FrmImpressaoNotificacaoExame.this.progress.setVisible(false);
                        FrmImpressaoNotificacaoExame.this.buttonConsultar.setEnabled(true);
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(FrmImpressaoNotificacaoExame.this, e.getMessage(), e.getStackTrace(), "FrmImpressaoNotificacaoExame: 553");
                }
                finally {
                    FrmImpressaoNotificacaoExame.this.habilitarDesabilitar(true);
                    FrmImpressaoNotificacaoExame.this.buttonParar.setVisible(false);
                }
            }
        }.start();
    }

    private void imprimirExames() {
        if (this.tableExames != null) {
            try {
                boolean abaRequisicoes = this.tabbedRequisicoes.getSelectedIndex() == 0;
                ModeloResultSet mod = this.modeloRequisicoes;
                JTable tabela = this.tableRequisicoes;
                Registro regReq = mod.getRegistro(tabela.getSelectedRow());
                List<Registro> regs = ((ModeloResultSet)this.tableExames.getModel()).getRegistros(this.tableExames.getSelectedRows());
                ArrayList<String> exa = new ArrayList<String>();
                ArrayList mco = new ArrayList();
                for (Registro reg : regs) {
                    exa.add(reg.getString("exa_codigo"));
                    exa.add(reg.getString("mco_codigo"));
                }
                Object retorno = null;
                Conexao.arquivaSQL();
                if (abaRequisicoes && this.todosExamesImpressos(regReq.getString("req_codigo"), regReq.getString("fil_codigo"))) {
                    this.modeloRequisicoes.removerRegistro(regReq);
                    this.modeloRequisicoes.fireTableDataChanged();
                    this.tabbedRequisicoes.setSelectedIndex(1);
                }
                this.consultarRequisicoes();
                this.carregarExames();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoNotificacaoExame: 607");
            }
        }
    }

    private boolean todosExamesImpressos(String codigoRequisicao, String codigoFilial) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder bui = new StringBuilder("select exa_codigo from examerequisicao where exr_dataimpresso is null and fil_codigo = ");
            bui.append(codigoFilial);
            bui.append(" and req_codigo = ");
            bui.append(codigoRequisicao);
            bui.append(" and exr_excluido = false ");
            return !Conexao.executeQuery(st, bui.toString()).next();
        }
        return false;
    }

    private void carregarExames() {
        JTable tabela = this.tableRequisicoes;
        ModeloResultSet modelo = this.modeloRequisicoes;
        if (tabela.getSelectedRowCount() == 1) {
            this.carregarModeloExames(modelo, tabela.getSelectedRow(), this.getFiltroExames());
        } else {
            this.panelExames.removeAll();
            this.panelExames.add((Component)this.panelBarraExames, "South");
            this.panelExames.revalidate();
            this.panelExames.repaint();
        }
        this.validarBotoesImprimirRequisicoes(tabela, modelo);
        this.validarBotaoImprimirExames();
    }

    private String getFiltroExames() {
        StringBuilder bui = new StringBuilder();
        try {
            if (this.itemSetor.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("set.set_codigo", this.itemSetor.getSelecionados(0), false));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        if (bui.toString().trim().length() > 0) {
            return bui.toString();
        }
        return null;
    }

    private void carregarModeloExames(ModeloResultSet modelo, int linha, String filtroExames) {
        if (modelo != null && linha >= 0 && linha < modelo.getRowCount()) {
            try {
                this.modeloExames.limpar();
                ModeloResultSet modeloTmp = null;
                this.panelExames.removeAll();
                Registro reg = modelo.getRegistro(linha);
                Statement st = Conexao.getStatement();
                if (st != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select \n");
                    buf.append("  a.exa_codigo, b.exa_descricao, c.mco_codigo, c.mco_abreviatura, a.exr_situacao, \n");
                    buf.append(" a.exr_notificacao as notificacao ");
                    buf.append(" from examerequisicao a \n");
                    buf.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo \n");
                    buf.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo \n");
                    buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo \n");
                    buf.append(" left join examesetor set on a.fil_codigo = set.fil_codigo and a.exa_codigo = set.exa_codigo and set.ese_default = true ");
                    buf.append(" where a.fil_codigo = ").append(reg.getValor("fil_codigo"));
                    buf.append("   and a.req_codigo = ").append(reg.getValor("req_codigo"));
                    buf.append("   and a.exr_excluido = false ");
                    if (filtroExames != null) {
                        buf.append("   and ").append(filtroExames);
                    }
                    buf.append(" order by d.emc_pagina ");
                    buf.append("      ,d.emc_ordem ");
                    buf.append("      ,a.exa_codigo ");
                    buf.append("      ,a.mco_codigo ");
                    ResultSet res = Conexao.executeQuery(st, buf.toString());
                    int index = 0;
                    if (res.first()) {
                        modeloTmp = this.modeloExames;
                        do {
                            Registro tmp = new Registro(res);
                            if (!res.getString("exr_situacao").equalsIgnoreCase("C") && !res.getString("exr_situacao").equalsIgnoreCase("I") && !res.getString("exr_situacao").equalsIgnoreCase("E")) continue;
                            modeloTmp.addRegistro(tmp);
                            tmp.setValor(SITUACAO, Tipos.tipoSituacaoExame(res.getString("exr_situacao")));
                            if (tmp.getValor("notificacao") != null && !tmp.getValor("notificacao").toString().isEmpty()) {
                                this.rendererExame.setCorLinha(Color.green, index);
                                this.rendererExame.setHintLinha(index, "Notifica\u00e7\u00e3o");
                            } else {
                                this.rendererExame.setCorLinha(Color.white, index);
                            }
                            ++index;
                        } while (res.next());
                    }
                }
                if (this.tabbedExames.getTabCount() > 0) {
                    while (this.tabbedExames.getTabCount() > 0) {
                        this.tabbedExames.removeTabAt(0);
                    }
                }
                this.tableExames = ComponenteFactory.novoJTable(modeloTmp, this.listenerExames, 60, 0, 60, 85);
                this.tabbedExames.addTab(reg.getString("req_codigo") + "-" + reg.getString("pac_nome"), new JScrollPane(this.tableExames));
                this.tableExames.setDefaultRenderer(Object.class, this.rendererExame);
                this.tableExames.setDefaultRenderer(Number.class, this.rendererExame);
                this.panelExames.add(this.tabbedExames);
                this.panelExames.add((Component)this.panelBarraExames, "South");
                this.panelExames.revalidate();
                this.panelExames.repaint();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoNotificacaoExame: 684");
            }
        }
    }

    private String getFiltro() {
        StringBuilder bui = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            bui.append(" i.exr_notificacao is not null and i.exr_notificacao <> '' ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                Date dataInicial = sdf.parse(this.textDataIni.getText());
                if (null != dataInicial && !this.textDataIni.getText().equals("")) {
                    if (bui.length() > 0) {
                        bui.append(" and ");
                    }
                    bui.append("a.req_data >= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText())));
                    bui.append("' ");
                    bui.append(" and ");
                    bui.append("CAST(i.exr_datadigita AS DATE) >= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText())));
                    bui.append("' ");
                }
                if (Funcoes.verificaData(this.textDataFin.getText())) {
                    if (bui.length() > 0) {
                        bui.append(" and ");
                    }
                    bui.append("a.req_data <= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText())));
                    bui.append("' ");
                    bui.append(" and ");
                    bui.append("CAST(i.exr_datadigita AS DATE) <= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText())));
                    bui.append("' ");
                }
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (!this.ocultarConvenio && this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemSituacao.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("a.sit_codigo", this.itemSituacao.getSelecionados(0), false));
            }
            if (this.itemSetor.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("set.set_codigo", this.itemSetor.getSelecionados(0), false));
            }
            if (this.itemPrioridade.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("b.pri_codigo", this.itemPrioridade.getSelecionados(0), false));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ImpressaoNotificacao.getExpressao("i.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            if (this.itemMedico.isSelected() && this.itemMedico.getSelecionadosAvancado() != null && this.itemMedico.getSelecionadosAvancado().length > 0) {
                String[] conselho = this.itemMedico.getSelecionadosAvancado(0);
                String[] crm = this.itemMedico.getSelecionadosAvancado(1);
                String[] uf = this.itemMedico.getSelecionadosAvancado(2);
                if (bui.length() > 0) {
                    bui.append("and ");
                }
                bui.append("(");
                for (int i = 0; i < crm.length && i < uf.length; ++i) {
                    if (i > 0) {
                        bui.append(" or ");
                    }
                    bui.append("(a.med_conselho = '").append(conselho[i]).append("' and upper(a.med_crm) = upper('");
                    bui.append(crm[i]);
                    bui.append("') and upper(a.med_uf) = upper('");
                    bui.append(uf[i]);
                    bui.append("'))");
                }
                bui.append(") ");
            }
            if (this.checkExamesProntos.isSelected()) {
                if (ParametrosGerais.getConferencia()) {
                    bui.append(" and (select COUNT(CASE WHEN aux.exr_situacao <> '").append("A").append("' THEN 1 ELSE NULL END) = COUNT(CASE WHEN aux.exr_situacao IN ('").append("C").append("', '").append("E").append("', '");
                    bui.append("I").append("') THEN 1 ELSE NULL END) ");
                } else {
                    bui.append(" and (select COUNT(CASE WHEN aux.exr_situacao <> '").append("A").append("' THEN 1 ELSE NULL END) = COUNT(CASE WHEN aux.exr_situacao IN ('").append("L").append("', '").append("C").append("', '");
                    bui.append("E").append("', '").append("I").append("') THEN 1 ELSE NULL END) ");
                }
                bui.append("        from examerequisicao aux ");
                bui.append("       where aux.fil_codigo = a.fil_codigo ");
                bui.append("         and aux.req_codigo = a.req_codigo ");
                bui.append("         and NOT aux.exr_excluido) ");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoNotificacaoExame: 740");
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tabbedRequisicoes.setEnabled(valor);
        this.tableRequisicoes.setEnabled(valor);
        this.tabbedExames.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        if (!this.ocultarConvenio) {
            this.itemConvenio.setEnabled(valor);
        }
        this.itemDestino.setEnabled(valor);
        this.itemSituacao.setEnabled(valor);
        this.itemSetor.setEnabled(valor);
        this.itemPrioridade.setEnabled(valor);
        this.itemMedico.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.itemFilial.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonExibirOcultar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.buttonImprimirExames.setEnabled(valor);
        this.buttonImprimirRequisicoes.setEnabled(valor);
        this.buttonImprimirTodos.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
        this.checkOrdemPaciente.setEnabled(valor);
        this.checkMultiguiaRespeitaFiltro.setEnabled(valor);
        this.checkExamesProntos.setEnabled(valor);
        this.checkAgruparMultiguias.setEnabled(valor);
    }

    private void exibirOcultarExames(boolean exibir) {
        this.buttonExibirOcultar.setText(exibir ? "Ocultar exames" : "Exibir exames");
        if (exibir) {
            this.splitCentral.setRightComponent(this.panelExames);
            this.splitCentral.setDividerLocation(this.posicaoDivisor);
        } else {
            if (this.exibirExames) {
                this.posicaoDivisor = this.splitCentral.getDividerLocation();
            }
            this.splitCentral.remove(this.panelExames);
        }
        this.exibirExames = exibir;
    }

    private void validarBotaoImprimirExames() {
        if (this.tableExames != null) {
            int[] rows = this.tableExames.getSelectedRows();
            if (rows.length == 0) {
                this.buttonImprimirExames.setEnabled(false);
            } else if (this.tableExames.getModel() instanceof ModeloResultSet) {
                ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
                boolean ok = true;
                this.buttonImprimirExames.setToolTipText(null);
                int tab = this.tabbedRequisicoes.getSelectedIndex();
                JTable tableTemp = this.tableRequisicoes;
                ModeloResultSet modTemp = this.modeloRequisicoes;
                Registro reg = modTemp.getRegistro(tableTemp.getSelectedRow());
                for (int i = 0; i < rows.length && ok; ++i) {
                    reg = mod.getRegistro(rows[i]);
                    ok = reg != null && (reg.getString("exr_situacao").equalsIgnoreCase("L") || reg.getString("exr_situacao").equalsIgnoreCase("C") || reg.getString("exr_situacao").equalsIgnoreCase("I") || reg.getString("exr_situacao").equalsIgnoreCase("E") || reg.getString("exr_situacao") == null || reg.getString("exr_situacao").equals("") || reg.getString("exr_situacao").equals(" "));
                }
                this.buttonImprimirExames.setEnabled(ok);
            }
        }
    }

    private void validarBotoesImprimirRequisicoes(JTable tab, ModeloResultSet mod) {
        if (tab != null && mod != null) {
            boolean ok = true;
            int[] rows = tab.getSelectedRows();
            for (int i = 0; i < rows.length && !ok; ++i) {
                Registro reg = mod.getRegistro(rows[i]);
                ok = reg != null;
            }
            this.buttonImprimirRequisicoes.setToolTipText(null);
            this.buttonImprimirTodos.setToolTipText(null);
            this.buttonImprimirTodos.setEnabled(mod.getRowCount() > 0 && ok);
            this.buttonImprimirRequisicoes.setEnabled(ok);
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemFilial, StringUtil.getValor(str, "filial"));
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.setAtributosFiltro(this.itemPrioridade, StringUtil.getValor(str, "prioridade"));
            this.setAtributosFiltro(this.itemMedico, StringUtil.getValor(str, "medico"));
            this.setAtributosFiltro(this.itemSituacao, StringUtil.getValor(str, SITUACAO));
            this.setAtributosFiltro(this.itemSetor, StringUtil.getValor(str, "setor"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
            this.checkExamesProntos.setSelected(StringUtil.getValor(str, "todosexamesprontos") != null && StringUtil.getBoolean(str, "todosexamesprontos"));
            this.checkMultiguiaRespeitaFiltro.setSelected(StringUtil.getValor(str, "multiguiasfiltro") != null && StringUtil.getBoolean(str, "multiguiasfiltro"));
            this.checkAgruparMultiguias.setSelected(StringUtil.getValor(str, "agruparmultiguias") != null && StringUtil.getBoolean(str, "agruparmultiguias"));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemFilial, "filial"));
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemSituacao, SITUACAO));
        bui.append(this.getAtributosFiltro(this.itemSetor, "setor"));
        bui.append(this.getAtributosFiltro(this.itemPrioridade, "prioridade"));
        bui.append(this.getAtributosFiltro(this.itemMedico, "medico"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag("todosexamesprontos", this.checkExamesProntos.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag("multiguiasfiltro", this.checkMultiguiaRespeitaFiltro.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag("agruparmultiguias", this.checkAgruparMultiguias.isSelected() ? "true" : "false"));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    public static long getModuloAcessoRecepcao() {
        return 301300100L;
    }

    public static long getModuloAcessoResultado() {
        return 400500122L;
    }
}

