/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RenderProtocolo;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.ImprimirMapa;
import jalis.laboratorio.util.impressao.ImprimirProtocoloDestino;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class FrmImpressaoLote
extends FrmPadrao
implements ActionListener {
    private boolean naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0300100302"));
    public static final int LAUDO = 0;
    public static final int MAPA = 1;
    public static final int PROTOCOLO = 2;
    private static final String DATA = "data";
    private static final String SITUACAO = "situacao";
    private static final String EXIBIR_EXAMES_LAUDO = "FrmImpressaoLoteLaudo.exibirExames";
    private static final String POSICAO_DIVISOR_LAUDO = "FrmImpressaoLoteLaudo.posicaoDivisor";
    private static final String ULTIMO_FILTRO_LAUDO = "FrmImpressaoLoteLaudo.ultimoFiltro";
    private static final String EXIBIR_EXAMES_MAPA = "FrmImpressaoLoteMapa.exibirExames";
    private static final String POSICAO_DIVISOR_MAPA = "FrmImpressaoLoteMapa.posicaoDivisor";
    private static final String ULTIMO_FILTRO_MAPA = "FrmImpressaoLoteMapa.ultimoFiltro";
    private static final String EXIBIR_EXAMES_PROTOCOLO = "FrmImpressaoLoteProtocolo.exibirExames";
    private static final String POSICAO_DIVISOR_PROTOCOLO = "FrmImpressaoLoteProtocolo.posicaoDivisor";
    private static final String ULTIMO_FILTRO_PROTOCOLO = "FrmImpressaoLoteProtocolo.ultimoFiltro";
    private final String EXIBIR_EXAMES;
    private final String POSICAO_DIVISOR;
    private final String ULTIMO_FILTRO;
    private JCheckBox checkOrdemPaciente = new JCheckBox("Ordenar por paciente");
    private JCheckBox checkFiltrarImpressao = ComponenteFactory.novoJCheckBox("Filtrar por data e hora de impress\u00e3o", this);
    private JCheckBox checkExamesProntos = new JCheckBox("Todos os exames prontos");
    private JCheckBox checkMultiguiaRespeitaFiltro = new JCheckBox("Multiguias respeitam os filtros");
    private JCheckBox checkConsiderarFiltroMapa = new JCheckBox("Considerar filtro ao imprimir");
    private JCheckBox checkReimprimirExames = new JCheckBox("Reimprimir exames impressos anteriormente (segunda via)");
    private JCheckBox checkAgruparMultiguias = new JCheckBox("Agrupar multiguias");
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelBarraExames = new JPanel(new FlowLayout(2, 0, 3));
    private JProgressBar progress = new JProgressBar();
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private JTabbedPane tabbedRequisicoes = new JTabbedPane();
    private JTabbedPane tabbedExames = new JTabbedPane();
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private TTextField textHoraIni = new TTextField(5, 6);
    private TTextField textHoraFin = new TTextField(5, 6);
    private JButton buttonExibirOcultar = ComponenteFactory.novoJButton(this, null, null, false);
    private JButton buttonImprimirRequisicoes = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private JButton buttonImprimirTodos = ComponenteFactory.novoJButton("Imprimir Todos", 'T', this, null, null, false);
    private JButton buttonImprimirExames = ComponenteFactory.novoJButton("Imprimir", 'm', this, null, null, false);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonParar = ComponenteFactory.novoJButton("Parar", 'P', this, null, null);
    private ModeloResultSet modeloRequisicoes = new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "data");
    private ModeloResultSet modeloSegundaVia = new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "data");
    private ModeloResultSet modeloExames = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Material", "mco_abreviatura", "Situa\u00e7\u00e3o", "situacao");
    private ModeloResultSet modeloExamesSegundaVia = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Material", "mco_abreviatura", "Situa\u00e7\u00e3o", "situacao");
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemPrioridade;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemExame;
    private CheckItemFiltro itemSetor;
    private CorTableCellRenderer rendererReq = new CorTableCellRenderer();
    private CorTableCellRenderer rendererSegVia = new CorTableCellRenderer();
    private JPanel panelFiltro;
    private static String impressoraSelecionada;
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoLote.this.carregarExames();
        }
    }, new int[0]);
    private JTable tableExamesSegundaVia = ComponenteFactory.novoJTable((TableModel)this.modeloExamesSegundaVia, new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoLote.this.carregarExames();
        }
    }, new int[0]);
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoLote.this.carregarExames();
        }
    }, 70, 0, 85);
    private JTable tableSegundaVia = ComponenteFactory.novoJTable((TableModel)this.modeloSegundaVia, new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoLote.this.carregarExames();
        }
    }, 70, 0, 85);
    ListSelectionListener listenerExames = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoLote.this.validarBotaoImprimirExames();
        }
    };
    ListSelectionListener listenerExamesSegundaVia = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FrmImpressaoLote.this.validarBotaoImprimirExamesSegundaVia();
        }
    };
    private boolean exibirExames = true;
    private boolean pararImpressao = false;
    private int posicaoDivisor = 350;
    private int tipo;
    private boolean acessoImprimirDevedor = Acesso.getAcesso(400500105L);
    private boolean acessoProibirSegundaVia = Acesso.getAcesso(400500111L);
    private boolean filtrarFilial = !ParametrosGerais.getTipoIntegracao().equals("N");
    private boolean ocultarConvenio;

    public FrmImpressaoLote(int tipo) {
        this.tipo = tipo;
        String string = tipo == 0 ? EXIBIR_EXAMES_LAUDO : (this.EXIBIR_EXAMES = tipo == 1 ? EXIBIR_EXAMES_MAPA : EXIBIR_EXAMES_PROTOCOLO);
        String string2 = tipo == 0 ? POSICAO_DIVISOR_LAUDO : (this.POSICAO_DIVISOR = tipo == 1 ? POSICAO_DIVISOR_MAPA : POSICAO_DIVISOR_PROTOCOLO);
        this.ULTIMO_FILTRO = tipo == 0 ? ULTIMO_FILTRO_LAUDO : (tipo == 1 ? ULTIMO_FILTRO_MAPA : ULTIMO_FILTRO_PROTOCOLO);
        this.setLayout(new BorderLayout());
        if (tipo == 0) {
            Funcoes.criaBarraDescricao(this, "Impress\u00e3o por lote", "Impress\u00e3o de resultados por lote", "recepcao/impressao_lote.jpg");
            this.filtrarFilial = this.filtrarFilial || Acesso.getAcesso(400500109L);
        } else if (tipo == 1) {
            Funcoes.criaBarraDescricao(this, "Impress\u00e3o por lote", "Impress\u00e3o de mapas por lote", "triagem/mapa_lote.jpg");
            this.filtrarFilial = this.filtrarFilial || Acesso.getAcesso(300100301L);
        } else if (tipo == 2) {
            Funcoes.criaBarraDescricao(this, "Impress\u00e3o de protocolo de destino", "Impress\u00e3o de protocolos de destino por lote", "recepcao/protocolo_destino.jpg");
            this.buttonImprimirExames.setVisible(false);
        }
        JPanel panelTemp = new JPanel(new BorderLayout());
        this.add((Component)panelTemp, "Center");
        this.panelFiltro = new JPanel();
        panelTemp.add((Component)this.panelFiltro, "North");
        this.montarPanelFiltro(this.panelFiltro);
        panelTemp.add((Component)this.progress, "South");
        panelTemp.add((Component)this.splitCentral, "Center");
        this.progress.setStringPainted(true);
        this.progress.setString("");
        this.progress.setVisible(false);
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        panelTemp = new JPanel(new BorderLayout());
        this.add((Component)panelTemp, "South");
        JPanel panelAux = new JPanel(new FlowLayout(0, 3, 3));
        panelTemp.add((Component)panelAux, "West");
        panelAux.add(this.buttonExibirOcultar);
        if (tipo == 0 && this.getPermiteReimprimirExames()) {
            panelAux.add(this.checkReimprimirExames);
        } else if (!this.getPermiteReimprimirExames()) {
            this.checkReimprimirExames.setSelected(false);
        }
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        panelTemp.add((Component)panelAux, "East");
        panelAux.add(this.buttonParar);
        panelAux.add(this.buttonFechar);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.tabbedRequisicoes, "Center");
        panelTemp = new JPanel(new FlowLayout(2, 0, 3));
        this.panelRequisicoes.add((Component)panelTemp, "South");
        panelAux = new JPanel();
        panelAux.setPreferredSize(new Dimension(3, 10));
        panelTemp.add(this.buttonImprimirTodos);
        panelTemp.add(panelAux);
        panelTemp.add(this.buttonImprimirRequisicoes);
        Insets mrg = this.buttonImprimirTodos.getMargin();
        this.buttonImprimirTodos.setMargin(new Insets(mrg.top, 3, mrg.bottom, 3));
        this.buttonImprimirRequisicoes.setMargin(this.buttonImprimirTodos.getMargin());
        this.buttonImprimirExames.setMargin(this.buttonImprimirTodos.getMargin());
        this.buttonParar.setVisible(false);
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelBarraExames.add(this.buttonImprimirExames);
        this.tabbedRequisicoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FrmImpressaoLote.this.carregarExames();
            }
        });
        this.tabbedExames.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int tab = FrmImpressaoLote.this.tabbedExames.getSelectedIndex();
                if (tab == 0) {
                    FrmImpressaoLote.this.validarBotaoImprimirExames();
                } else {
                    FrmImpressaoLote.this.validarBotaoImprimirExamesSegundaVia();
                }
            }
        });
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int linha = -1;
                    linha = FrmImpressaoLote.this.tableRequisicoes.getSelectedRow();
                    if (linha > -1 && Funcoes.mensagem(FrmImpressaoLote.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        ((ModeloResultSet)FrmImpressaoLote.this.tableExames.getModel()).limpar();
                        ((ModeloResultSet)FrmImpressaoLote.this.tableExamesSegundaVia.getModel()).limpar();
                        FrmImpressaoLote.this.modeloRequisicoes.removerRegistro(linha);
                        FrmImpressaoLote.this.modeloRequisicoes.fireTableDataChanged();
                        if (FrmImpressaoLote.this.tableRequisicoes.getRowCount() > 0) {
                            ScreenUtil.requisitarFoco(FrmImpressaoLote.this.tableRequisicoes);
                        }
                    }
                }
            }
        });
        this.modeloRequisicoes.setOrdenarColunas(true);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        if (tipo == 2) {
            this.tableRequisicoes.setDefaultRenderer(Object.class, new RenderProtocolo());
            this.tableRequisicoes.setDefaultRenderer(Number.class, new RenderProtocolo());
        } else {
            this.tableRequisicoes.setDefaultRenderer(Object.class, this.rendererReq);
            this.tableRequisicoes.setDefaultRenderer(Number.class, this.rendererReq);
        }
        this.rendererReq.setAlinhamentoColuna(0, 4);
        this.rendererReq.setAlinhamentoColuna(2, 0);
        this.tableSegundaVia.setDefaultRenderer(Object.class, this.rendererSegVia);
        this.tableSegundaVia.setDefaultRenderer(Number.class, this.rendererSegVia);
        this.rendererSegVia.setAlinhamentoColuna(0, 4);
        this.rendererSegVia.setAlinhamentoColuna(2, 0);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableRequisicoes.getColumnModel().getColumn(2).setMinWidth(80);
        this.tableSegundaVia.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableSegundaVia.getColumnModel().getColumn(2).setMinWidth(80);
        this.modeloSegundaVia.setOrdenarColunas(true);
        this.tableSegundaVia.getTableHeader().addMouseListener(this.modeloSegundaVia);
        this.carregarParametros();
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Registro reg;
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                Registro registro = reg = FrmImpressaoLote.this.tabbedRequisicoes.getSelectedIndex() == 0 ? FrmImpressaoLote.this.modeloRequisicoes.getRegistro(FrmImpressaoLote.this.tableRequisicoes.getSelectedRow()) : FrmImpressaoLote.this.modeloSegundaVia.getRegistro(FrmImpressaoLote.this.tableSegundaVia.getSelectedRow());
                if (reg != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
            }
        });
        this.checkAgruparMultiguias.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FrmImpressaoLote.this.checkAgruparMultiguias.isSelected() && !FrmImpressaoLote.this.checkMultiguiaRespeitaFiltro.isSelected()) {
                    FrmImpressaoLote.this.checkMultiguiaRespeitaFiltro.setSelected(true);
                }
            }
        });
        this.checkMultiguiaRespeitaFiltro.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!FrmImpressaoLote.this.checkMultiguiaRespeitaFiltro.isSelected() || !FrmImpressaoLote.this.checkAgruparMultiguias.isSelected()) {
                    FrmImpressaoLote.this.checkAgruparMultiguias.setSelected(false);
                }
            }
        });
    }

    @Override
    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        } else if (this.checkFiltrarImpressao.hasFocus()) {
            this.textHoraFin.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block21: {
            try {
                Object o = e.getSource();
                if (o == this.buttonDataIni) {
                    Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
                    break block21;
                }
                if (o == this.buttonDataFin) {
                    Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
                    break block21;
                }
                if (o == this.buttonFechar) {
                    this.acaoFechar();
                    break block21;
                }
                if (o == this.buttonParar) {
                    this.pararImpressao = true;
                    break block21;
                }
                if (o == this.buttonConsultar) {
                    this.consultarRequisicoes();
                    try {
                        this.modeloRequisicoes.ordenarColuna(0, 1);
                        this.modeloSegundaVia.ordenarColuna(0, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.gravarParametros();
                    break block21;
                }
                if (o == this.buttonExibirOcultar) {
                    this.exibirOcultarExames(!this.exibirExames);
                    this.gravarParametros();
                } else if (o == this.buttonImprimirRequisicoes) {
                    if (this.tabbedRequisicoes.getSelectedIndex() == 0) {
                        this.imprimirRequisicoes(this.modeloRequisicoes, this.tableRequisicoes.getSelectedRows());
                    } else {
                        this.imprimirRequisicoes(this.modeloSegundaVia, this.tableSegundaVia.getSelectedRows());
                    }
                } else if (o == this.buttonImprimirTodos) {
                    int[] linhas = new int[this.tabbedRequisicoes.getSelectedIndex() == 0 ? this.tableRequisicoes.getRowCount() : this.tableSegundaVia.getRowCount()];
                    for (int i = 0; i < linhas.length; ++i) {
                        linhas[i] = i;
                    }
                    this.imprimirRequisicoes(this.tabbedRequisicoes.getSelectedIndex() == 0 ? this.modeloRequisicoes : this.modeloSegundaVia, linhas);
                } else if (o == this.buttonImprimirExames) {
                    this.imprimirExames();
                } else if (o == this.checkFiltrarImpressao) {
                    this.apresentarFiltroHora(this.checkFiltrarImpressao.isSelected());
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmImpressaoLote: 217");
            }
        }
    }

    private void acaoFechar() {
        impressoraSelecionada = "";
        this.setVisible(false);
        if (this.getParent() != null) {
            this.getParent().removeAll();
        }
    }

    public static long getModuloAcessoLaudo() {
        return 400500102L;
    }

    public static long getModuloAcessoMapa() {
        return 300100300L;
    }

    public static long getModuloAcessoProtocolo() {
        return 201300100L;
    }

    private void montarPanelFiltro(JPanel panel) {
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        Dimension dim = new Dimension(150, 20);
        cons.fill = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.gridx = 0;
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setPreferredSize(dim);
        this.itemFilial.setMinimumSize(dim);
        cons.gridy = 0;
        if (this.filtrarFilial) {
            panel.add((Component)this.itemFilial, cons);
            ++cons.gridy;
        }
        this.itemColeta = new CheckItemFiltro("Coletas", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dim);
        this.itemColeta.setMinimumSize(dim);
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dim);
        this.itemDestino.setMinimumSize(dim);
        panel.add((Component)this.itemDestino, cons);
        this.ocultarConvenio = false;
        if (this.tipo == 0) {
            this.ocultarConvenio = Acesso.getAcesso(Long.parseLong("0400500118"));
            this.naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0400500111"));
        } else if (this.tipo == 1) {
            this.ocultarConvenio = Acesso.getAcesso(Long.parseLong("0300100303"));
            this.naoPermiteVisualizarPaciente = Acesso.getAcesso(Long.parseLong("0300100302"));
        }
        if (!this.ocultarConvenio) {
            ++cons.gridy;
            this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            this.itemConvenio.setColunaHint(1);
            this.itemConvenio.setPreferredSize(dim);
            this.itemConvenio.setMinimumSize(dim);
            panel.add((Component)this.itemConvenio, cons);
        }
        ++cons.gridy;
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dim);
        this.itemExame.setMinimumSize(dim);
        panel.add((Component)this.itemExame, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.insets = new Insets(1, 20, 1, 1);
        this.itemPrioridade = new CheckItemFiltro("Prioridade", "Filtrar", "Filtrando prioridades", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPrioridade.setDados("prioridade", new String[]{"pri_codigo", "pri_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemPrioridade.setColunaHint(1);
        this.itemPrioridade.setPreferredSize(dim);
        this.itemPrioridade.setMinimumSize(dim);
        panel.add((Component)this.itemPrioridade, cons);
        ++cons.gridy;
        this.itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, true);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(2);
        this.itemMedico.setPreferredSize(dim);
        this.itemMedico.setMinimumSize(dim);
        panel.add((Component)this.itemMedico, cons);
        ++cons.gridy;
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSituacao.setDados(SITUACAO, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemSituacao.setPreferredSize(dim);
        this.itemSituacao.setMinimumSize(dim);
        panel.add((Component)this.itemSituacao, cons);
        ++cons.gridy;
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setPreferredSize(dim);
        this.itemSetor.setMinimumSize(dim);
        panel.add((Component)this.itemSetor, cons);
        this.textHoraIni.setPreferredSize(new Dimension(60, 20));
        this.textHoraIni.setMinimumSize(new Dimension(60, 20));
        this.textHoraFin.setPreferredSize(new Dimension(60, 20));
        this.textHoraFin.setMinimumSize(new Dimension(60, 20));
        cons.gridx = 2;
        cons.gridy = 0;
        cons.anchor = 17;
        this.textDataIni.setPreferredSize(new Dimension(100, 20));
        this.textDataIni.setMinimumSize(new Dimension(100, 20));
        this.buttonDataIni.setFocusable(false);
        this.buttonDataIni.setPreferredSize(new Dimension(20, 20));
        this.buttonDataIni.setMinimumSize(new Dimension(20, 20));
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 0, 1, 1);
        panel.add((Component)this.buttonDataIni, cons);
        if (this.tipo == 2) {
            ++cons.gridx;
            cons.insets = new Insets(1, 1, 1, 0);
            panel.add((Component)this.textHoraIni, cons);
        }
        ++cons.gridy;
        cons.gridx = 2;
        this.textDataFin.setPreferredSize(new Dimension(100, 20));
        this.textDataFin.setMinimumSize(new Dimension(100, 20));
        this.buttonDataFin.setFocusable(false);
        this.buttonDataFin.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFin.setMinimumSize(new Dimension(20, 20));
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        cons.insets = new Insets(1, 0, 1, 1);
        panel.add((Component)this.buttonDataFin, cons);
        if (this.tipo == 2) {
            ++cons.gridx;
            cons.insets = new Insets(1, 1, 1, 1);
            panel.add((Component)this.textHoraFin, cons);
        }
        ++cons.gridy;
        cons.gridx = 2;
        cons.gridwidth = this.tipo == 2 ? 4 : 3;
        cons.insets = new Insets(1, 20, 1, 1);
        if (this.tipo == 0) {
            panel.add((Component)this.checkExamesProntos, cons);
        } else if (this.tipo == 2) {
            panel.add((Component)this.checkFiltrarImpressao, cons);
        } else if (this.tipo == 1) {
            panel.add((Component)this.checkConsiderarFiltroMapa, cons);
        }
        ++cons.gridy;
        cons.gridx = 2;
        cons.gridwidth = this.tipo == 2 ? 4 : 3;
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.checkMultiguiaRespeitaFiltro, cons);
        ++cons.gridy;
        cons.gridx = 2;
        cons.gridwidth = this.tipo == 2 ? 4 : 3;
        cons.insets = new Insets(1, 20, 1, 1);
        panel.add((Component)this.checkAgruparMultiguias, cons);
        if (this.tipo == 2) {
            ++cons.gridy;
            cons.insets = new Insets(1, 20, 1, 1);
            panel.add((Component)this.checkOrdemPaciente, cons);
        }
        if (this.tipo != 2) {
            cons.gridx = 6;
            cons.gridwidth = 2;
            cons.anchor = 17;
            this.buttonConsultar.setPreferredSize(new Dimension(110, 20));
            this.buttonConsultar.setMinimumSize(new Dimension(110, 20));
            cons.insets = new Insets(1, 5, 1, 1);
            panel.add((Component)this.buttonConsultar, cons);
            cons.gridy = 0;
            cons.gridx = 6;
            cons.weightx = 1.0;
            cons.fill = 2;
            panel.add((Component)new JPanel(), cons);
        } else {
            cons.gridx = 4;
            cons.gridwidth = 2;
            cons.anchor = 17;
            this.buttonConsultar.setPreferredSize(new Dimension(110, 20));
            this.buttonConsultar.setMinimumSize(new Dimension(110, 20));
            cons.insets = new Insets(1, 5, 1, 1);
            panel.add((Component)this.buttonConsultar, cons);
            cons.gridy = 0;
            cons.gridx = 6;
            cons.weightx = 1.0;
            cons.fill = 2;
            panel.add((Component)new JPanel(), cons);
        }
    }

    private void consultarRequisicoes() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String SQL = "";
                try {
                    FrmImpressaoLote.this.progress.setString("Pesquisando. Aguarde...");
                    FrmImpressaoLote.this.progress.setValue(0);
                    FrmImpressaoLote.this.progress.setIndeterminate(true);
                    FrmImpressaoLote.this.progress.setVisible(true);
                    FrmImpressaoLote.this.tabbedRequisicoes.removeAll();
                    FrmImpressaoLote.this.tabbedExames.removeAll();
                    FrmImpressaoLote.this.modeloRequisicoes.limpar();
                    FrmImpressaoLote.this.modeloSegundaVia.limpar();
                    FrmImpressaoLote.this.rendererReq.limpar();
                    FrmImpressaoLote.this.rendererSegVia.limpar();
                    FrmImpressaoLote.this.habilitarDesabilitar(false);
                    Statement st = Conexao.getStatement();
                    if (st != null) {
                        String filiais = (FrmImpressaoLote.this.tipo == 2 ? "a.fil_codigo = " : "") + Variaveis.filialPadrao;
                        if (FrmImpressaoLote.this.itemFilial.isSelected() && FrmImpressaoLote.this.itemFilial.getSelecionados(0) != null && FrmImpressaoLote.this.itemFilial.getSelecionados(0).length > 0) {
                            filiais = ImpressaoResultados.getExpressao("a.fil_codigo", FrmImpressaoLote.this.itemFilial.getSelecionados(0), false);
                        }
                        SQL = FrmImpressaoLote.this.tipo == 2 ? ImpressaoResultados.getSelectImpressaoProtocolo(filiais, FrmImpressaoLote.this.getFiltro(), FrmImpressaoLote.this.checkOrdemPaciente.isSelected()) : (FrmImpressaoLote.this.tipo == 1 ? ImpressaoResultados.getSelectRequisicaoExameMapa(filiais, FrmImpressaoLote.this.getFiltro(), null, true, null, false) : ImpressaoResultados.getSelectRequisicaoExame(filiais, FrmImpressaoLote.this.getFiltro(), null, true));
                        Registro[] consultados = Registro.getRegistros(Conexao.executeQuery(st, SQL));
                        FrmImpressaoLote.this.progress.setMaximum(consultados.length);
                        FrmImpressaoLote.this.progress.setIndeterminate(false);
                        FrmImpressaoLote.this.progress.setString(StringUtil.getStringProgresso("Consultando: ", FrmImpressaoLote.this.progress));
                        int indice = 0;
                        while (indice < consultados.length) {
                            FrmImpressaoLote.this.progress.setValue(indice);
                            FrmImpressaoLote.this.progress.setString(StringUtil.getStringProgresso("Consultando: ", FrmImpressaoLote.this.progress));
                            Registro reg = consultados[indice];
                            indice = FrmImpressaoLote.this.adicionaRequisicaoModelo(consultados, indice);
                            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(reg.getString("fil_codigo"), reg.getString("req_codigo"));
                            int i = 0;
                            while (multiguias != null && i < multiguias.length) {
                                SQL = FrmImpressaoLote.this.tipo == 1 ? ImpressaoResultados.getSelectRequisicaoExameMapa(filiais, FrmImpressaoLote.this.getFiltro(), null, true, multiguias[i++].toString(), false) : ImpressaoResultados.getSelectRequisicaoExame(filiais, FrmImpressaoLote.this.checkMultiguiaRespeitaFiltro.isSelected() ? FrmImpressaoLote.this.getFiltro() : null, multiguias[i++], true);
                                Registro[] multi = Registro.getRegistros(Conexao.executeQuery(st, SQL));
                                if (multi == null || multi.length <= 0) continue;
                                FrmImpressaoLote.this.adicionaRequisicaoModelo(multi, 0);
                            }
                        }
                        FrmImpressaoLote.this.tabbedRequisicoes.addTab("Requisi\u00e7\u00f5es", new JScrollPane(FrmImpressaoLote.this.tableRequisicoes));
                        if (FrmImpressaoLote.this.modeloSegundaVia.getRowCount() > 0 && FrmImpressaoLote.this.tipo != 2) {
                            FrmImpressaoLote.this.tabbedRequisicoes.addTab("Segunda via", new JScrollPane(FrmImpressaoLote.this.tableSegundaVia));
                        }
                        FrmImpressaoLote.this.tabbedRequisicoes.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent e) {
                                int tab = FrmImpressaoLote.this.tabbedRequisicoes.getSelectedIndex();
                                FrmImpressaoLote.this.carregarModeloExames(tab == 0 ? FrmImpressaoLote.this.modeloRequisicoes : FrmImpressaoLote.this.modeloSegundaVia, (tab == 0 ? FrmImpressaoLote.this.tableRequisicoes : FrmImpressaoLote.this.tableSegundaVia).getSelectedRow(), FrmImpressaoLote.this.getFiltroExames(), tab != 0);
                                FrmImpressaoLote.this.validarBotoesImprimirRequisicoes(tab == 0 ? FrmImpressaoLote.this.tableRequisicoes : FrmImpressaoLote.this.tableSegundaVia, tab == 0 ? FrmImpressaoLote.this.modeloRequisicoes : FrmImpressaoLote.this.modeloSegundaVia);
                            }
                        });
                        if (!FrmImpressaoLote.this.acessoImprimirDevedor) {
                            int i;
                            for (i = 0; i < FrmImpressaoLote.this.modeloRequisicoes.getRowCount(); ++i) {
                                if (!FrmImpressaoLote.this.modeloRequisicoes.getRegistro(i).getBoolean("saldo_devedor")) continue;
                                FrmImpressaoLote.this.rendererReq.setCorLinha(new Color(255, 80, 80), i);
                                FrmImpressaoLote.this.rendererReq.setHintLinha(i, "Requisi\u00e7\u00e3o com saldo devedor");
                            }
                            for (i = 0; i < FrmImpressaoLote.this.modeloSegundaVia.getRowCount(); ++i) {
                                if (!FrmImpressaoLote.this.modeloSegundaVia.getRegistro(i).getBoolean("saldo_devedor")) continue;
                                FrmImpressaoLote.this.rendererSegVia.setCorLinha(new Color(255, 80, 80), i);
                                FrmImpressaoLote.this.rendererSegVia.setHintLinha(i, "Requisi\u00e7\u00e3o com saldo devedor");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(FrmImpressaoLote.this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "FrmImpressaoLote: 408");
                }
                finally {
                    FrmImpressaoLote.this.habilitarDesabilitar(true);
                    FrmImpressaoLote.this.progress.setVisible(false);
                    FrmImpressaoLote.this.validarBotoesImprimirRequisicoes(FrmImpressaoLote.this.tableRequisicoes, FrmImpressaoLote.this.modeloRequisicoes);
                }
            }
        }.start();
    }

    private int adicionaRequisicaoModelo(Registro[] regs, int indice) {
        try {
            int i;
            if (regs[indice].getString("req_codigo") == null) {
                return -1;
            }
            int req = regs[indice].getInt("req_codigo");
            String filCodigo = regs[indice].getString("fil_codigo");
            boolean todosImpressos = this.tipo == 0 ? true : regs[indice].getBoolean("mapa_impresso");
            boolean algumLancado = false;
            boolean algumConferido = false;
            boolean algumImpresso = false;
            boolean algumSemResultado = false;
            boolean todosConferidos = false;
            for (i = indice; i < regs.length && regs[i].getInt("req_codigo") == req && regs[i].getString("fil_codigo").equalsIgnoreCase(filCodigo); ++i) {
                if (this.tipo == 1 && !regs[i].getBoolean("mapa_impresso") || this.tipo == 0 && !regs[i].getBoolean("impresso") && !regs[i].getBoolean("entregue")) {
                    todosImpressos = false;
                }
                algumImpresso = regs[i].getBoolean("impresso");
                if (regs[i].getBoolean("lancado") || regs[i].getBoolean("conferido")) {
                    algumLancado = true;
                }
                if (regs[i].getBoolean("conferido")) {
                    algumConferido = true;
                }
                if (!regs[i].getBoolean("sem_resultado")) continue;
                algumSemResultado = true;
            }
            regs[indice].setValor(DATA, Funcoes.formataData("dd/MM/yyyy", regs[indice].getDate("req_data")));
            regs[indice].setValor("lancado", new Boolean(algumLancado));
            if (Acesso.getAcesso(Long.parseLong("0300100302")) && this.tipo == 1) {
                regs[indice].setValor("pac_nome", "Visualiza\u00e7\u00e3o n\u00e3o permitida");
            } else if (Acesso.getAcesso(Long.parseLong("0400500112")) && this.tipo == 0) {
                regs[indice].setValor("pac_nome", "Visualiza\u00e7\u00e3o n\u00e3o permitida");
            }
            if (this.checkAgruparMultiguias.isSelected()) {
                Integer[] filhas = null;
                filhas = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, regs[indice].getString("req_codigo"));
                todosConferidos = FrmImpressaoLote.getTodosExamesConferidos(Conexao.getStatement(), regs[indice].getString("fil_codigo"), regs[indice].getString("req_codigo"), filhas);
            }
            if (this.tipo == 0) {
                if (algumImpresso && !this.acessoProibirSegundaVia && !this.contemExameRequisicao(this.modeloSegundaVia.getRegistros(), regs[indice])) {
                    this.modeloSegundaVia.addRegistro(regs[indice]);
                }
                if (!todosImpressos && ParametrosGerais.getConferencia()) {
                    if (!(!algumConferido || this.checkAgruparMultiguias.isSelected() && this.checkExamesProntos.isSelected())) {
                        if (!this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice])) {
                            this.modeloRequisicoes.addRegistro(regs[indice]);
                        }
                    } else if (this.checkAgruparMultiguias.isSelected() && todosConferidos && !this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice])) {
                        this.modeloRequisicoes.addRegistro(regs[indice]);
                    }
                } else if (algumLancado || algumConferido) {
                    if (this.checkAgruparMultiguias.isSelected() && todosConferidos) {
                        if (!this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice])) {
                            this.modeloRequisicoes.addRegistro(regs[indice]);
                        }
                    } else if (!(this.checkAgruparMultiguias.isSelected() && this.checkExamesProntos.isSelected() || this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice]))) {
                        this.modeloRequisicoes.addRegistro(regs[indice]);
                    }
                }
            } else if (this.tipo == 1) {
                if (todosImpressos) {
                    if (!this.contemExameRequisicao(this.modeloSegundaVia.getRegistros(), regs[indice])) {
                        this.modeloSegundaVia.addRegistro(regs[indice]);
                    }
                } else if (algumSemResultado && !this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice])) {
                    this.modeloRequisicoes.addRegistro(regs[indice]);
                }
            } else if (!this.contemExameRequisicao(this.modeloRequisicoes.getRegistros(), regs[indice])) {
                this.modeloRequisicoes.addRegistro(regs[indice]);
            }
            return i;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoLote: 472");
            return indice + 1;
        }
    }

    public static boolean getTodosExamesConferidos(Statement st, String filial, String codigoRequisicao, Integer[] filhas) throws Exception {
        if (st == null) {
            throw new Exception("N\u00e3o foi poss\u00edvel verificar se todos os exames da requisi\u00e7\u00e3o est\u00e3o conferidos. Statement = NULL.");
        }
        StringBuilder bui = new StringBuilder();
        bui.append(" select SUM(CASE WHEN exr_situacao IN ('").append("C").append("', '").append("I").append("', '").append("E").append("') THEN 1 ELSE 0 END) = COUNT(*) as todosConferidos ");
        bui.append("   from examerequisicao ");
        bui.append("  where fil_codigo = ").append(filial);
        bui.append("    and req_codigo  in ( ").append(codigoRequisicao).append(" ");
        if (null != filhas) {
            for (int i = 0; i < filhas.length; ++i) {
                bui.append(", ").append(filhas[i]);
            }
        }
        bui.append(" )");
        bui.append("    and not exr_excluido ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            return rs.getBoolean("todosConferidos");
        }
        return false;
    }

    private boolean contemRequisicao(Registro[] regs, Registro reg) {
        int req = reg.getInt("req_codigo");
        for (int i = 0; i < regs.length; ++i) {
            if (regs[i].getInt("req_codigo") != req) continue;
            return true;
        }
        return false;
    }

    private boolean contemExameRequisicao(List<Registro> registros, Registro reg) {
        int req = reg.getInt("req_codigo");
        String exa = reg.getString("exa_codigo");
        int mat = reg.getInt("mat_codigo");
        String filCodigo = reg.getString("fil_codigo");
        for (int i = 0; i < registros.size(); ++i) {
            Registro aux = registros.get(i);
            if (aux.getInt("req_codigo") != req || !aux.getString("exa_codigo").equalsIgnoreCase(exa) || aux.getInt("mat_codigo") != mat || !aux.getString("fil_codigo").equalsIgnoreCase(filCodigo)) continue;
            return true;
        }
        return false;
    }

    private void imprimirRequisicoes(final ModeloResultSet mod, final int[] linhas) {
        this.pararImpressao = false;
        this.habilitarDesabilitar(false);
        this.buttonParar.setVisible(true);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<Registro> regs = mod.getRegistros(linhas);
                    FrmImpressaoLote.this.buttonConsultar.setEnabled(false);
                    FrmImpressaoLote.this.progress.setMaximum(regs.size());
                    FrmImpressaoLote.this.progress.setValue(0);
                    FrmImpressaoLote.this.progress.setString("Imprimindo: 0%");
                    FrmImpressaoLote.this.progress.setVisible(true);
                    String[] setores = FrmImpressaoLote.this.itemSetor.getSelecionados();
                    String[] exames = FrmImpressaoLote.this.itemExame.getSelecionados();
                    int resp = -1;
                    for (int i = 0; i < regs.size() && !FrmImpressaoLote.this.pararImpressao; ++i) {
                        Registro reg = regs.get(i);
                        FrmImpressaoLote.this.progress.setValue(i + 1);
                        FrmImpressaoLote.this.progress.setString("Imprimindo: " + (int)(FrmImpressaoLote.this.progress.getPercentComplete() * 100.0) + " %");
                        RetornoImpressaoResultados retorno = null;
                        if (FrmImpressaoLote.this.tipo == 0 && reg.getBoolean("lancado") && (FrmImpressaoLote.this.acessoImprimirDevedor || !reg.getBoolean("saldo_devedor"))) {
                            retorno = Acesso.getAcesso(Long.parseLong("0400500112")) && FrmImpressaoLote.this.tipo == 0 ? ImpressaoResultados.imprimirExames(impressoraSelecionada, FrmImpressaoLote.this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), FrmImpressaoLote.this.checkReimprimirExames.isSelected(), ParametrosGerais.getConferencia(), setores, exames, null, false, "", false, false, null, false, "", false, true) : ImpressaoResultados.imprimirExames(impressoraSelecionada, FrmImpressaoLote.this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), FrmImpressaoLote.this.checkReimprimirExames.isSelected(), ParametrosGerais.getConferencia(), setores, exames, null, false, "", false, false, null, false, "", false, false);
                            if (Funcoes.textoVazio(impressoraSelecionada)) {
                                impressoraSelecionada = retorno.getImpressoraSelecionada();
                            }
                        } else if (FrmImpressaoLote.this.tipo == 0 && reg.getBoolean("impresso") && (FrmImpressaoLote.this.acessoImprimirDevedor || !reg.getBoolean("saldo_devedor"))) {
                            if (resp == -1 && FrmImpressaoLote.this.getPermiteReimprimirExames()) {
                                resp = Funcoes.mensagem(FrmImpressaoLote.this, "Deseja reimprimir os laudos?", 4);
                            }
                            if (resp == 0 && FrmImpressaoLote.this.getPermiteReimprimirExames()) {
                                retorno = Acesso.getAcesso(Long.parseLong("0400500112")) && FrmImpressaoLote.this.tipo == 0 ? ImpressaoResultados.imprimirExames(impressoraSelecionada, FrmImpressaoLote.this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), FrmImpressaoLote.this.checkReimprimirExames.isSelected(), ParametrosGerais.getConferencia(), setores, exames, null, false, "", false, false, null, false, "", false, true) : ImpressaoResultados.imprimirExames(impressoraSelecionada, FrmImpressaoLote.this.getTopLevelAncestor(), reg.getString("fil_codigo"), reg.getString("req_codigo"), FrmImpressaoLote.this.checkReimprimirExames.isSelected(), ParametrosGerais.getConferencia(), setores, exames, null, false, "", false, false, null, false, "", false, false);
                                if (Funcoes.textoVazio(impressoraSelecionada)) {
                                    impressoraSelecionada = retorno.getImpressoraSelecionada();
                                }
                            }
                        } else if (FrmImpressaoLote.this.tipo == 1) {
                            if (FrmImpressaoLote.this.checkConsiderarFiltroMapa.isSelected()) {
                                if (FrmImpressaoLote.this.itemSetor.getSelecionados(0) != null && FrmImpressaoLote.this.itemSetor.getSelecionados(0).length > 0) {
                                    setores = new String[FrmImpressaoLote.this.itemSetor.getSelecionados(0).length];
                                    for (int j = 0; j < FrmImpressaoLote.this.itemSetor.getSelecionados(0).length; ++j) {
                                        if (!Funcoes.isNumeric(FrmImpressaoLote.this.itemSetor.getSelecionados(0)[j])) continue;
                                        setores[j] = FrmImpressaoLote.this.itemSetor.getSelecionados(0)[j];
                                    }
                                }
                                if (FrmImpressaoLote.this.itemExame.getSelecionados(0) != null && FrmImpressaoLote.this.itemExame.getSelecionados(0).length > 0) {
                                    exames = FrmImpressaoLote.this.itemExame.getSelecionados(0);
                                }
                            }
                            ImprimirMapa.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), exames, setores, true, false, false, null, FrmImpressaoLote.this.naoPermiteVisualizarPaciente, FrmImpressaoLote.this.ocultarConvenio, -1);
                        } else if (FrmImpressaoLote.this.tipo == 2) {
                            ImprimirProtocoloDestino.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), true, false);
                            reg.setValor("jaimprimiu", new Boolean(true));
                        }
                        if (FrmImpressaoLote.this.tipo != 2) continue;
                        String tempo = ParametrosLocais.getParametro("tempoImpressaoLaudo");
                        if (!Funcoes.isNumeric(tempo) || Funcoes.isNumeric(tempo) && Integer.parseInt(tempo) == 0) {
                            tempo = "1000";
                        }
                        14.sleep(Integer.parseInt(tempo));
                    }
                    Conexao.arquivaSQL();
                    if (FrmImpressaoLote.this.tipo != 2 && FrmImpressaoLote.this.tabbedRequisicoes.getSelectedIndex() == 0) {
                        if (linhas.length == 1 && FrmImpressaoLote.this.todosExamesImpressos(mod.getRegistro(linhas[0]).getString("req_codigo"), mod.getRegistro(linhas[0]).getString("fil_codigo"))) {
                            Registro regReq = mod.getRegistro(linhas[0]);
                            FrmImpressaoLote.this.modeloRequisicoes.removerRegistro(regReq);
                            FrmImpressaoLote.this.modeloRequisicoes.fireTableDataChanged();
                            FrmImpressaoLote.this.modeloSegundaVia.addRegistro(regReq, "req_codigo");
                            FrmImpressaoLote.this.modeloSegundaVia.fireTableDataChanged();
                            if (FrmImpressaoLote.this.tabbedRequisicoes.getTabCount() == 1) {
                                FrmImpressaoLote.this.tabbedRequisicoes.addTab("Segunda via", new JScrollPane(FrmImpressaoLote.this.tableSegundaVia));
                            }
                            FrmImpressaoLote.this.tabbedRequisicoes.setSelectedIndex(1);
                            int indice = FrmImpressaoLote.this.modeloSegundaVia.getIndice(regReq);
                            FrmImpressaoLote.this.tableSegundaVia.setRowSelectionInterval(indice, indice);
                            FrmImpressaoLote.this.tableSegundaVia.scrollRectToVisible(FrmImpressaoLote.this.tableSegundaVia.getCellRect(indice, 0, true));
                        }
                        FrmImpressaoLote.this.consultarRequisicoes();
                    }
                    FrmImpressaoLote.this.progress.setVisible(false);
                    FrmImpressaoLote.this.buttonConsultar.setEnabled(true);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(FrmImpressaoLote.this, e.getMessage(), e.getStackTrace(), "FrmImpressaoLote: 553");
                }
                finally {
                    FrmImpressaoLote.this.habilitarDesabilitar(true);
                    FrmImpressaoLote.this.buttonParar.setVisible(false);
                }
            }
        }.start();
    }

    private void imprimirExames() {
        if (this.tableExames != null) {
            try {
                boolean abaRequisicoes = this.tabbedRequisicoes.getSelectedIndex() == 0;
                ModeloResultSet mod = abaRequisicoes ? this.modeloRequisicoes : this.modeloSegundaVia;
                JTable tabela = abaRequisicoes ? this.tableRequisicoes : this.tableSegundaVia;
                Registro regReq = mod.getRegistro(tabela.getSelectedRow());
                List<Registro> regs = null;
                regs = this.tabbedExames.getSelectedIndex() == 1 ? ((ModeloResultSet)this.tableExamesSegundaVia.getModel()).getRegistros(this.tableExamesSegundaVia.getSelectedRows()) : ((ModeloResultSet)this.tableExames.getModel()).getRegistros(this.tableExames.getSelectedRows());
                ArrayList<String> exa = new ArrayList<String>();
                ArrayList<String> mco = new ArrayList<String>();
                String exame1 = "";
                Integer material1 = null;
                for (Registro reg : regs) {
                    exa.add(reg.getString("exa_codigo"));
                    exame1 = reg.getString("exa_codigo");
                    if (this.tipo == 0) {
                        mco.add(reg.getString("mco_codigo"));
                        material1 = reg.getInt("mco_codigo");
                        continue;
                    }
                    exa.add(reg.getString("mco_codigo"));
                    material1 = reg.getInt("mco_codigo");
                }
                RetornoImpressaoResultados retorno = null;
                if (this.tipo == 0 && (this.acessoImprimirDevedor || !regReq.getBoolean("saldo_devedor"))) {
                    retorno = ImpressaoResultados.imprimirExames(impressoraSelecionada, this.getTopLevelAncestor(), regReq.getString("fil_codigo"), regReq.getString("req_codigo"), abaRequisicoes ? this.checkReimprimirExames.isSelected() : this.getPermiteReimprimirExames(), ParametrosGerais.getConferencia(), null, exa.toArray(new String[exa.size()]), mco.toArray(new String[mco.size()]), false);
                    if (Funcoes.textoVazio(impressoraSelecionada)) {
                        impressoraSelecionada = retorno.getImpressoraSelecionada();
                    }
                } else if (this.tipo == 1) {
                    ImprimirMapa.imprimir(regReq.getString("fil_codigo"), regReq.getString("req_codigo"), exame1, material1, true, false);
                }
                Conexao.arquivaSQL();
                if (abaRequisicoes && this.todosExamesImpressos(regReq.getString("req_codigo"), regReq.getString("fil_codigo"))) {
                    this.modeloRequisicoes.removerRegistro(regReq);
                    this.modeloRequisicoes.fireTableDataChanged();
                    this.modeloSegundaVia.addRegistro(regReq, "req_codigo");
                    this.modeloSegundaVia.fireTableDataChanged();
                    if (this.tabbedRequisicoes.getTabCount() == 1) {
                        this.tabbedRequisicoes.addTab("Segunda via", new JScrollPane(this.tableSegundaVia));
                    }
                    this.tabbedRequisicoes.setSelectedIndex(1);
                    int indice = this.modeloSegundaVia.getIndice(regReq);
                    this.tableSegundaVia.setRowSelectionInterval(indice, indice);
                    this.tableSegundaVia.scrollRectToVisible(this.tableSegundaVia.getCellRect(indice, 0, true));
                }
                this.consultarRequisicoes();
                this.carregarExames();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoLote: 607");
            }
        }
    }

    private boolean todosExamesImpressos(String codigoRequisicao, String codigoFilial) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder bui = new StringBuilder("select exa_codigo from examerequisicao where exr_dataimpresso is null and fil_codigo = ");
            bui.append(codigoFilial);
            bui.append(" and req_codigo = ");
            bui.append(codigoRequisicao);
            bui.append(" and exr_excluido = false ");
            return !Conexao.executeQuery(st, bui.toString()).next();
        }
        return false;
    }

    private void carregarExames() {
        ModeloResultSet modelo;
        JTable tabela = this.tabbedRequisicoes.getSelectedIndex() == 0 ? this.tableRequisicoes : this.tableSegundaVia;
        ModeloResultSet modeloResultSet = modelo = this.tabbedRequisicoes.getSelectedIndex() == 0 ? this.modeloRequisicoes : this.modeloSegundaVia;
        if (tabela.getSelectedRowCount() == 1) {
            this.carregarModeloExames(modelo, tabela.getSelectedRow(), this.getFiltroExames(), this.tabbedRequisicoes.getSelectedIndex() != 0);
        } else {
            this.panelExames.removeAll();
            this.panelExames.repaint();
        }
        this.validarBotoesImprimirRequisicoes(tabela, modelo);
        this.validarBotaoImprimirExames();
        this.validarBotaoImprimirExamesSegundaVia();
    }

    private String getFiltroExames() {
        StringBuilder bui = new StringBuilder();
        try {
            if (this.itemSetor.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("set.set_codigo", this.itemSetor.getSelecionados(0), false));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        if (bui.toString().trim().length() > 0) {
            return bui.toString();
        }
        return null;
    }

    private void carregarModeloExames(ModeloResultSet modelo, int linha, String filtroExames, boolean isSegundaVia) {
        if (modelo != null && linha >= 0 && linha < modelo.getRowCount()) {
            try {
                this.modeloExames.limpar();
                ModeloResultSet modeloTmp = null;
                this.panelExames.removeAll();
                Registro reg = modelo.getRegistro(linha);
                Statement st = Conexao.getStatement();
                if (st != null) {
                    StringBuilder buf = new StringBuilder(ImpressaoResultados.SELECT_EXAME);
                    buf.append(" where a.fil_codigo = ").append(reg.getValor("fil_codigo"));
                    buf.append("   and a.req_codigo = ").append(reg.getValor("req_codigo"));
                    buf.append("   and a.exr_excluido = false ");
                    if (filtroExames != null) {
                        buf.append("   and ").append(filtroExames);
                    }
                    if (this.tipo == 0) {
                        if (isSegundaVia) {
                            buf.append(" and a.exr_situacao IN ('").append("I").append("' ,'").append("E").append("') ");
                        } else if (ParametrosGerais.getConferencia()) {
                            buf.append(" and a.exr_situacao = '").append("C").append("' ");
                        } else {
                            buf.append(" and a.exr_situacao IN ('").append("C").append("' ,'").append("L").append("') ");
                        }
                    } else if (this.tipo == 1) {
                        buf.append(" and COALESCE(trim(a.exr_situacao), '') = '' ");
                    }
                    buf.append(" order by d.emc_pagina ");
                    buf.append("      ,d.emc_ordem ");
                    buf.append("      ,a.exa_codigo ");
                    buf.append("      ,a.mco_codigo ");
                    ResultSet res = Conexao.executeQuery(st, buf.toString());
                    if (res.first()) {
                        modeloTmp = this.modeloExames;
                        do {
                            Registro tmp = new Registro(res);
                            modeloTmp.addRegistro(tmp);
                            tmp.setValor(SITUACAO, Tipos.tipoSituacaoExame(res.getString("exr_situacao")));
                        } while (res.next());
                    }
                }
                if (this.tabbedExames.getTabCount() > 0) {
                    while (this.tabbedExames.getTabCount() > 0) {
                        this.tabbedExames.removeTabAt(0);
                    }
                }
                this.tableExames = ComponenteFactory.novoJTable(modeloTmp, this.listenerExames, 60, 0, 60, 85);
                this.tabbedExames.addTab(reg.getString("req_codigo") + "-" + this.getNomePaciente(reg), new JScrollPane(this.tableExames));
                this.carregarModeloExamesSegundaVia(modelo, linha, filtroExames, this.tabbedExames);
                this.panelExames.add(this.tabbedExames);
                this.panelExames.add((Component)this.panelBarraExames, "South");
                this.panelExames.revalidate();
                this.panelExames.repaint();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoLote: 684");
            }
        }
    }

    private void carregarModeloExamesSegundaVia(ModeloResultSet modelo, int linha, String filtroExames, JTabbedPane jTabbedPane) {
        if (modelo != null && linha >= 0 && linha < modelo.getRowCount()) {
            try {
                this.modeloExamesSegundaVia.limpar();
                ModeloResultSet modeloTmp = this.modeloExamesSegundaVia;
                Registro reg = modelo.getRegistro(linha);
                Statement st = Conexao.getStatement();
                if (st != null) {
                    StringBuilder buf = new StringBuilder(ImpressaoResultados.SELECT_EXAME);
                    buf.append(" where a.fil_codigo = ").append(reg.getValor("fil_codigo"));
                    buf.append("   and a.req_codigo = ").append(reg.getValor("req_codigo"));
                    buf.append("   and a.exr_excluido = false ");
                    if (filtroExames != null) {
                        buf.append("   and ").append(filtroExames);
                    }
                    if (this.tipo == 0) {
                        buf.append(" and a.exr_situacao IN ('").append("I").append("' ,'").append("E").append("') ");
                    } else if (this.tipo == 1) {
                        buf.append(" and COALESCE(trim(a.exr_situacao), '') = '' ");
                    }
                    buf.append(" order by d.emc_pagina ");
                    buf.append("      ,d.emc_ordem ");
                    buf.append("      ,a.exa_codigo ");
                    buf.append("      ,a.mco_codigo ");
                    ResultSet res = Conexao.executeQuery(st, buf.toString());
                    if (res.first()) {
                        do {
                            Registro tmp = new Registro(res);
                            modeloTmp.addRegistro(tmp);
                            tmp.setValor(SITUACAO, Tipos.tipoSituacaoExame(res.getString("exr_situacao")));
                        } while (res.next());
                    }
                }
                this.panelExames.add(jTabbedPane);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private String getNomePaciente(Registro reg) {
        if (Acesso.getAcesso(Long.parseLong("0300100302")) && this.tipo == 1) {
            return "Visualiza\u00e7\u00e3o n\u00e3o permitida";
        }
        if (Acesso.getAcesso(Long.parseLong("0400500112")) && this.tipo == 0) {
            return "Visualiza\u00e7\u00e3o n\u00e3o permitida";
        }
        return reg.getString("pac_nome");
    }

    private String getFiltro() {
        StringBuilder bui = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            if (this.tipo == 2 && this.checkFiltrarImpressao.isSelected()) {
                if (Funcoes.verificaData(this.textDataIni.getText()) && Funcoes.verificaHora(this.textHoraIni.getText())) {
                    bui.append("i.exr_dataimpresso >= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText())));
                    bui.append(" ").append(this.textHoraIni.getText());
                    bui.append("' ");
                }
                if (Funcoes.verificaData(this.textDataFin.getText()) && Funcoes.verificaHora(this.textHoraFin.getText())) {
                    if (bui.length() > 0) {
                        bui.append(" and ");
                    }
                    bui.append("i.exr_dataimpresso <= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText())));
                    bui.append(" ").append(this.textHoraFin.getText());
                    bui.append("' ");
                }
                if (Funcoes.verificaData(this.textDataIni.getText()) && !Funcoes.verificaHora(this.textHoraIni.getText())) {
                    if (bui.length() > 0) {
                        bui.append(" and ");
                    }
                    bui.append("cast(i.exr_dataimpresso as date) >= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText())));
                    bui.append("' ");
                }
                if (Funcoes.verificaData(this.textDataFin.getText()) && !Funcoes.verificaHora(this.textHoraFin.getText())) {
                    if (bui.length() > 0) {
                        bui.append(" and ");
                    }
                    bui.append("cast(i.exr_dataimpresso as date) <= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText())));
                    bui.append("' ");
                }
            } else {
                Date dataInicial;
                if (Funcoes.verificaData(this.textDataIni.getText()) && null != (dataInicial = sdf.parse(this.textDataIni.getText())) && !this.textDataIni.getText().equals("")) {
                    if (this.tipo == 1) {
                        bui.append("cast(i.exr_datamaterial as date) >= '");
                    } else {
                        bui.append("a.req_data >= '");
                    }
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText())));
                    bui.append("' ");
                }
                if (Funcoes.verificaData(this.textDataFin.getText())) {
                    if (bui.length() > 0) {
                        bui.append(" and ");
                    }
                    if (this.tipo == 1) {
                        bui.append("cast(i.exr_datamaterial as date) <= '");
                    } else {
                        bui.append("a.req_data <= '");
                    }
                    bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText())));
                    bui.append("' ");
                }
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (!this.ocultarConvenio && this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemSituacao.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("a.sit_codigo", this.itemSituacao.getSelecionados(0), false));
            }
            if (this.itemSetor.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("set.set_codigo", this.itemSetor.getSelecionados(0), false));
            }
            if (this.itemPrioridade.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("b.pri_codigo", this.itemPrioridade.getSelecionados(0), false));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ImpressaoResultados.getExpressao("i.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            if (this.itemMedico.isSelected() && this.itemMedico.getSelecionadosAvancado(1) != null && this.itemMedico.getSelecionadosAvancado(1).length > 0) {
                String[] conselho = this.itemMedico.getSelecionadosAvancado(0);
                String[] crm = this.itemMedico.getSelecionadosAvancado(1);
                String[] uf = this.itemMedico.getSelecionadosAvancado(2);
                if (bui.length() > 0) {
                    bui.append("and ");
                }
                bui.append("(");
                for (int i = 0; i < crm.length && i < uf.length; ++i) {
                    if (i > 0) {
                        bui.append(" or ");
                    }
                    bui.append("(a.med_conselho = '").append(conselho[i]).append("' and upper(a.med_crm) = upper('");
                    bui.append(crm[i]);
                    bui.append("') and upper(a.med_uf) = upper('");
                    bui.append(uf[i]);
                    bui.append("'))");
                }
                bui.append(") ");
            }
            if (this.checkExamesProntos.isSelected()) {
                if (ParametrosGerais.getConferencia()) {
                    bui.append(" and (select COUNT(CASE WHEN aux.exr_situacao <> '").append("A").append("' THEN 1 ELSE NULL END) = COUNT(CASE WHEN aux.exr_situacao IN ('").append("C").append("', '").append("E").append("', '");
                    bui.append("I").append("') THEN 1 ELSE NULL END) ");
                } else {
                    bui.append(" and (select COUNT(CASE WHEN aux.exr_situacao <> '").append("A").append("' THEN 1 ELSE NULL END) = COUNT(CASE WHEN aux.exr_situacao IN ('").append("L").append("', '").append("C").append("', '");
                    bui.append("E").append("', '").append("I").append("') THEN 1 ELSE NULL END) ");
                }
                bui.append("        from examerequisicao aux ");
                bui.append("       where aux.fil_codigo = a.fil_codigo ");
                bui.append("         and aux.req_codigo = a.req_codigo ");
                bui.append("         and NOT aux.exr_excluido) ");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoLote: 740");
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tabbedRequisicoes.setEnabled(valor);
        this.tableRequisicoes.setEnabled(valor);
        this.tableSegundaVia.setEnabled(valor);
        this.tableExamesSegundaVia.setEnabled(valor);
        this.tabbedExames.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        if (!this.ocultarConvenio) {
            this.itemConvenio.setEnabled(valor);
        }
        this.itemDestino.setEnabled(valor);
        this.itemSituacao.setEnabled(valor);
        this.itemSetor.setEnabled(valor);
        this.itemPrioridade.setEnabled(valor);
        this.itemMedico.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.itemFilial.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonExibirOcultar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.buttonImprimirExames.setEnabled(valor);
        this.buttonImprimirRequisicoes.setEnabled(valor);
        this.buttonImprimirTodos.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
        this.textHoraFin.setEnabled(valor);
        this.textHoraIni.setEnabled(valor);
        this.checkOrdemPaciente.setEnabled(valor);
        this.checkFiltrarImpressao.setEnabled(valor);
        this.checkMultiguiaRespeitaFiltro.setEnabled(valor);
        this.checkExamesProntos.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.checkAgruparMultiguias.setEnabled(valor);
    }

    private void exibirOcultarExames(boolean exibir) {
        this.buttonExibirOcultar.setText(exibir ? "Ocultar exames" : "Exibir exames");
        if (exibir) {
            this.splitCentral.setRightComponent(this.panelExames);
            this.splitCentral.setDividerLocation(this.posicaoDivisor);
        } else {
            if (this.exibirExames) {
                this.posicaoDivisor = this.splitCentral.getDividerLocation();
            }
            this.splitCentral.remove(this.panelExames);
        }
        this.exibirExames = exibir;
    }

    private void validarBotaoImprimirExamesSegundaVia() {
        if (this.tableExamesSegundaVia != null) {
            int[] rows = this.tableExamesSegundaVia.getSelectedRows();
            if (rows.length == 0) {
                this.buttonImprimirExames.setEnabled(false);
            } else if (this.tableExamesSegundaVia.getModel() instanceof ModeloResultSet) {
                ModeloResultSet mod = (ModeloResultSet)this.tableExamesSegundaVia.getModel();
                boolean ok = true;
                this.buttonImprimirExames.setToolTipText(null);
                int tab = this.tabbedExames.getSelectedIndex();
                JTable tableTemp = tab == 0 ? this.tableExames : this.tableExamesSegundaVia;
                ModeloResultSet modTemp = tab == 0 ? this.modeloExames : this.modeloExamesSegundaVia;
                Registro reg = modTemp.getRegistro(tableTemp.getSelectedRow());
                if (reg != null && this.tipo == 0 && !this.acessoImprimirDevedor && reg.getBoolean("saldo_devedor")) {
                    ok = false;
                } else {
                    for (int i = 0; i < rows.length && ok; ++i) {
                        reg = mod.getRegistro(rows[i]);
                        ok = reg != null && (reg.getString("exr_situacao").equalsIgnoreCase("L") || reg.getString("exr_situacao").equalsIgnoreCase("C") || this.tipo == 0 && reg.getString("exr_situacao").equalsIgnoreCase("I") || reg.getString("exr_situacao").equalsIgnoreCase("E") || this.tipo == 1 && (reg.getString("exr_situacao") == null || reg.getString("exr_situacao").equals("") || reg.getString("exr_situacao").equals(" ")));
                    }
                }
                if (tab == 1) {
                    this.buttonImprimirExames.setEnabled(ok && this.getPermiteReimprimirExames());
                    if (!this.getPermiteReimprimirExames()) {
                        this.buttonImprimirExames.setToolTipText("Usu\u00e1rio n\u00e3o tem acesso para reimpress\u00e3o");
                    }
                } else {
                    this.buttonImprimirExames.setEnabled(ok);
                }
            }
        }
    }

    private void validarBotaoImprimirExames() {
        if (this.tableExames != null) {
            int[] rows = this.tableExames.getSelectedRows();
            if (rows.length == 0) {
                this.buttonImprimirExames.setEnabled(false);
            } else if (this.tableExames.getModel() instanceof ModeloResultSet) {
                ModeloResultSet mod = (ModeloResultSet)this.tableExames.getModel();
                boolean ok = true;
                this.buttonImprimirExames.setToolTipText(null);
                int tab = this.tabbedRequisicoes.getSelectedIndex();
                JTable tableTemp = tab == 0 ? this.tableRequisicoes : this.tableSegundaVia;
                ModeloResultSet modTemp = tab == 0 ? this.modeloRequisicoes : this.modeloSegundaVia;
                Registro reg = modTemp.getRegistro(tableTemp.getSelectedRow());
                if (reg != null && this.tipo == 0 && !this.acessoImprimirDevedor && reg.getBoolean("saldo_devedor")) {
                    ok = false;
                } else {
                    for (int i = 0; i < rows.length && ok; ++i) {
                        reg = mod.getRegistro(rows[i]);
                        ok = reg != null && (reg.getString("exr_situacao").equalsIgnoreCase("L") || reg.getString("exr_situacao").equalsIgnoreCase("C") || this.tipo == 0 && reg.getString("exr_situacao").equalsIgnoreCase("I") || reg.getString("exr_situacao").equalsIgnoreCase("E") || this.tipo == 1 && (reg.getString("exr_situacao") == null || reg.getString("exr_situacao").equals("") || reg.getString("exr_situacao").equals(" ")));
                    }
                }
                if (tab == 1) {
                    this.buttonImprimirExames.setEnabled(ok && this.getPermiteReimprimirExames());
                    if (!this.getPermiteReimprimirExames()) {
                        this.buttonImprimirExames.setToolTipText("Usu\u00e1rio n\u00e3o tem acesso para reimpress\u00e3o");
                    }
                } else {
                    this.buttonImprimirExames.setEnabled(ok);
                }
            }
        }
    }

    private void validarBotoesImprimirRequisicoes(JTable tab, ModeloResultSet mod) {
        if (tab != null && mod != null) {
            boolean ok = this.acessoImprimirDevedor;
            int[] rows = tab.getSelectedRows();
            for (int i = 0; i < rows.length && !ok; ++i) {
                Registro reg = mod.getRegistro(rows[i]);
                ok = reg != null && (this.tipo != 0 || this.tipo == 0 && !reg.getBoolean("saldo_devedor") && !reg.getBoolean("laudo_impresso"));
            }
            this.buttonImprimirRequisicoes.setToolTipText(null);
            this.buttonImprimirTodos.setToolTipText(null);
            if (this.tabbedRequisicoes.getSelectedIndex() == 1) {
                this.buttonImprimirTodos.setEnabled(mod.getRowCount() > 0 && ok && this.getPermiteReimprimirExames());
                this.buttonImprimirRequisicoes.setEnabled(this.contemExameLancadoImpresso(mod, rows) && ok && this.getPermiteReimprimirExames());
                if (!this.getPermiteReimprimirExames()) {
                    this.buttonImprimirRequisicoes.setToolTipText("Usu\u00e1rio n\u00e3o tem acesso para reimpress\u00e3o");
                    this.buttonImprimirTodos.setToolTipText("Usu\u00e1rio n\u00e3o tem acesso para reimpress\u00e3o");
                }
            } else {
                this.buttonImprimirTodos.setEnabled(mod.getRowCount() > 0 && ok);
                this.buttonImprimirRequisicoes.setEnabled(this.contemExameLancadoImpresso(mod, rows) && ok);
            }
        }
    }

    private boolean contemExameLancadoImpresso(ModeloResultSet modelo, int[] linhas) {
        boolean contem = false;
        if (modelo != null && linhas != null) {
            List<Registro> regs = modelo.getRegistros(linhas);
            for (int i = 0; i < regs.size() && !contem; ++i) {
                contem = (regs.get(i).getBoolean("lancado") || regs.get(i).getBoolean("impresso")) && this.tipo == 0 || this.tipo == 1 && (regs.get(i).getString("exr_situacao") == null || regs.get(i).getString("exr_situacao").equals("") || regs.get(i).getString("exr_situacao").equals(" ")) && !regs.get(i).getBoolean("laudo_impresso") || this.tipo == 2;
            }
        }
        return contem;
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(this.ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(this.ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            if (!this.ocultarConvenio) {
                this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            }
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemSituacao, StringUtil.getValor(str, SITUACAO));
            this.setAtributosFiltro(this.itemSetor, StringUtil.getValor(str, "setor"));
            this.setAtributosFiltro(this.itemPrioridade, StringUtil.getValor(str, "prioridade"));
            this.setAtributosFiltro(this.itemMedico, StringUtil.getValor(str, "medico"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
            this.textHoraIni.setText(StringUtil.getValor(str, "horaInicial"));
            this.textHoraFin.setText(StringUtil.getValor(str, "horaFinal"));
            if (this.tipo == 2) {
                this.checkOrdemPaciente.setSelected(StringUtil.getValor(str, "ordemPaciente") != null && StringUtil.getBoolean(str, "ordemPaciente"));
                this.checkFiltrarImpressao.setSelected(StringUtil.getValor(str, "filtroImpressao") != null && StringUtil.getBoolean(str, "filtroImpressao"));
                this.apresentarFiltroHora(StringUtil.getValor(str, "filtroImpressao") != null && StringUtil.getBoolean(str, "filtroImpressao"));
            }
            if (this.tipo == 1) {
                this.checkConsiderarFiltroMapa.setSelected(StringUtil.getValor(str, "considerarFiltroMapa") != null && StringUtil.getBoolean(str, "considerarFiltroMapa"));
            }
            this.checkExamesProntos.setSelected(StringUtil.getValor(str, "todosexamesprontos") != null && StringUtil.getBoolean(str, "todosexamesprontos"));
            this.checkMultiguiaRespeitaFiltro.setSelected(StringUtil.getValor(str, "multiguiasfiltro") != null && StringUtil.getBoolean(str, "multiguiasfiltro"));
            this.checkAgruparMultiguias.setSelected(StringUtil.getValor(str, "agruparmultiguias") != null && StringUtil.getBoolean(str, "agruparmultiguias"));
        }
        if (ParametrosUsuarios.contemParametro(this.EXIBIR_EXAMES)) {
            this.exibirExames = StringUtil.getBoolean(ParametrosUsuarios.getValor(this.EXIBIR_EXAMES));
        }
        if (ParametrosUsuarios.contemParametro(this.POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(this.POSICAO_DIVISOR));
        }
        this.exibirOcultarExames(this.exibirExames);
    }

    private void apresentarFiltroHora(boolean apresentar) {
        this.textHoraIni.setVisible(apresentar);
        this.textHoraFin.setVisible(apresentar);
        if (!apresentar) {
            this.textHoraIni.clear();
            this.textHoraFin.clear();
        }
        this.panelFiltro.revalidate();
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        if (!this.ocultarConvenio) {
            bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        }
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemSituacao, SITUACAO));
        bui.append(this.getAtributosFiltro(this.itemSetor, "setor"));
        bui.append(this.getAtributosFiltro(this.itemPrioridade, "prioridade"));
        bui.append(this.getAtributosFiltro(this.itemMedico, "medico"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag("horaInicial", this.textHoraIni.getText()));
        bui.append(StringUtil.getTag("horaFinal", this.textHoraFin.getText()));
        if (this.tipo == 2) {
            bui.append(StringUtil.getTag("ordemPaciente", this.checkOrdemPaciente.isSelected() ? "true" : "false"));
            bui.append(StringUtil.getTag("filtroImpressao", this.checkFiltrarImpressao.isSelected() ? "true" : "false"));
        }
        if (this.tipo == 1) {
            bui.append(StringUtil.getTag("considerarFiltroMapa", this.checkConsiderarFiltroMapa.isSelected() ? "true" : "false"));
        }
        bui.append(StringUtil.getTag("todosexamesprontos", this.checkExamesProntos.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag("multiguiasfiltro", this.checkMultiguiaRespeitaFiltro.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag("agruparmultiguias", this.checkAgruparMultiguias.isSelected() ? "true" : "false"));
        ParametrosUsuarios.setValor(this.ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(this.EXIBIR_EXAMES, String.valueOf(this.exibirExames));
        ParametrosUsuarios.setValor(this.POSICAO_DIVISOR, String.valueOf(this.exibirExames ? this.splitCentral.getDividerLocation() : this.posicaoDivisor));
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private boolean getPermiteReimprimirExames() {
        boolean possuiAcesso = Acesso.getAcesso(Long.parseLong("0400500117"));
        return !possuiAcesso;
    }
}

