/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.DialogoFiltroEtiquetas;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.SituacaoRequisicao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class FrmImpressaoColetaTriagem
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener {
    private static final String MODELO_EXAMES = "modelo_exames";
    private static final String ETQTRIAGEM_IMPRESSA = "etqtriagem_impressa";
    private static final String ETQCOLETA_IMPRESSA = "etqcoleta_impressa";
    private static final String REIMPRIMIR = "reimprimir";
    private ModeloResultSet modeloReq = new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome", "Data", "data");
    private ModeloResultSet modeloExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "Situa\u00e7\u00e3o", "exr_situacao", "#", "exameselecionado");
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloReq, (ListSelectionListener)this, 55, 0, 85);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExa, (ListSelectionListener)this, 55, 0, 40, 90, 28);
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JPanel panelTopo = new JPanel(new FlowLayout(0, 0, 3));
    private JPanel panelBarra = new JPanel(new BorderLayout());
    private JPanel panelBarraEsq = new JPanel(new FlowLayout(0, 3, 3));
    private JPanel panelBarraDir = new JPanel(new FlowLayout(2, 3, 3));
    private JPanel panelRequisicao = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JButton buttonBuscaRequisicao = new JButton();
    private JSplitPane splitCentro = new JSplitPane(1, this.panelRequisicao, this.panelExames);
    private JButton buttonImprimirRequisicao = ComponenteFactory.novoJButton("Imprimir", 'i', this, null, null, false);
    private JButton buttonImprimirExame = ComponenteFactory.novoJButton("Imprimir", 'm', this, null, null, false);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'A', this, null, null);
    private JTextField textCodigo = new TTextField(12, 1);
    private TTextField textFilial = new TTextField(5, 1);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, this.textFilial);
    private JPopupMenu menuImprimirRequisicao = new JPopupMenu();
    private JMenuItem subImprimirTodosRequisicao = ComponenteFactory.novoJMenu(this.menuImprimirRequisicao, "Imprimir Todos", '\u0000');
    private JMenuItem subImprimirRequisicao = ComponenteFactory.novoJMenu(this.menuImprimirRequisicao, "", '\u0000');
    private JMenuItem itemImprimirRequisicaoTodosColeta = ComponenteFactory.novoJMenuItem(this.subImprimirTodosRequisicao, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirRequisicaoTodosTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirTodosRequisicao, "Etiqueta triagem", (ActionListener)this);
    private JMenuItem itemImprimirRequisicaoColeta = ComponenteFactory.novoJMenuItem(this.subImprimirRequisicao, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirRequisicaoTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirRequisicao, "Etiqueta triagem", (ActionListener)this);
    private JPopupMenu menuImprimirExame = new JPopupMenu();
    private JMenuItem subImprimirTodosExame = ComponenteFactory.novoJMenu(this.menuImprimirExame, "Imprimir Todos", '\u0000');
    private JMenuItem subImprimirExame = ComponenteFactory.novoJMenu(this.menuImprimirExame, "", '\u0000');
    private JMenuItem itemImprimirExameTodosColeta = ComponenteFactory.novoJMenuItem(this.subImprimirTodosExame, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirExameTodosTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirTodosExame, "Etiqueta triagem", (ActionListener)this);
    private JMenuItem itemImprimirExameColeta = ComponenteFactory.novoJMenuItem(this.subImprimirExame, "Etiqueta coleta", (ActionListener)this);
    private JMenuItem itemImprimirExameTriagem = ComponenteFactory.novoJMenuItem(this.subImprimirExame, "Etiqueta triagem", (ActionListener)this);
    private final int ETIQUETA_COLETA = 1;
    private final int ETIQUETA_TRIAGEM = 2;
    public final int ETIQUETA_COLETA_SELECIONADA = 3;
    public final int ETIQUETA_TRIAGEM_SELECIONADA = 4;
    private JButton buttonFilial = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FrmImpressaoColetaTriagem.this.pesquisarFilial();
        }
    }, true);
    boolean integrar = !ParametrosGerais.getTipoIntegracao().equals("N");
    boolean mensagemVisualizada = false;
    boolean ok = false;

    public FrmImpressaoColetaTriagem() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Impress\u00e3o de Etiquetas de Coleta/Triagem", "Imprime etiquetas de coleta/triagem a partir do c\u00f3digo da requisi\u00e7\u00e3o", "triagem/imprimir_etiquetas.jpg");
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBarra, "South");
        this.panelCentro.add((Component)this.panelTopo, "North");
        this.panelCentro.add((Component)this.splitCentro, "Center");
        this.panelTopo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 3, 1, 1)));
        JLabel labelRequisicao = ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o:", new Dimension(70, 20));
        labelRequisicao.setDisplayedMnemonic('R');
        labelRequisicao.setLabelFor(this.textCodigo);
        if (this.integrar) {
            this.panelTopo.add(this.labelFilial);
            this.panelTopo.add(this.textFilial);
            this.panelTopo.add(this.buttonFilial);
            JPanel p = new JPanel();
            p.setPreferredSize(new Dimension(10, 20));
            this.panelTopo.add(p);
        }
        this.panelTopo.add(labelRequisicao);
        this.panelTopo.add(this.textCodigo);
        this.panelTopo.add(this.buttonBuscaRequisicao);
        this.splitCentro.setBorder(null);
        this.splitCentro.setDividerSize(3);
        this.splitCentro.setDividerLocation(400);
        this.panelRequisicao.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicao.add((Component)new JScrollPane(this.tableRequisicoes), "Center");
        JPanel panelTemp = new JPanel(new FlowLayout(2, 3, 3));
        this.panelRequisicao.add((Component)panelTemp, "South");
        panelTemp.add(this.buttonImprimirRequisicao);
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)new JScrollPane(this.tableExames), "Center");
        panelTemp = new JPanel(new FlowLayout(2, 3, 3));
        this.panelExames.add((Component)panelTemp, "South");
        panelTemp.add(this.buttonImprimirExame);
        this.buttonImprimirRequisicao.setMargin(this.buttonImprimirRequisicao.getMargin());
        this.buttonImprimirRequisicao.setFocusable(false);
        this.buttonImprimirExame.setMargin(this.buttonImprimirExame.getMargin());
        this.buttonImprimirExame.setFocusable(false);
        this.panelBarra.add((Component)this.panelBarraEsq, "West");
        this.panelBarraEsq.add(this.buttonFiltrar);
        this.panelBarra.add((Component)this.panelBarraDir, "East");
        this.panelBarraDir.add(this.buttonFechar);
        this.textCodigo.setHorizontalAlignment(4);
        this.textCodigo.setPreferredSize(new Dimension(80, 20));
        this.textFilial.setPreferredSize(new Dimension(80, 20));
        this.textCodigo.addKeyListener(this);
        this.textFilial.addKeyListener(this);
        this.tableRequisicoes.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(-1, -1, 4));
        this.tableRequisicoes.addKeyListener(this);
        this.tableExames.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(0, -1, 0, 0));
        this.tableExames.addKeyListener(this);
        this.buttonBuscaRequisicao.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaRequisicao.setMinimumSize(new Dimension(20, 20));
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaRequisicao.addActionListener(this);
        this.buttonBuscaRequisicao.setFocusable(false);
        this.buttonFechar.setFocusable(false);
        this.subImprimirTodosExame.setText("Imprimir Todos os Exames marcados");
        this.subImprimirTodosRequisicao.setText("Imprimir Todas as Requisi\u00e7\u00f5es");
        this.modeloReq.setOrdenarColunas(true);
        this.modeloExa.setColunaEditavel("exameselecionado");
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        this.textFilial.setText(Variaveis.filialPadrao);
        ScreenUtil.requisitarFoco(this.integrar ? this.textFilial : this.textCodigo);
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                Registro reg = FrmImpressaoColetaTriagem.this.modeloReq.getRegistro(FrmImpressaoColetaTriagem.this.tableRequisicoes.getSelectedRow());
                if (reg != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !(e.getSource() instanceof JButton)) {
                    FrmImpressaoColetaTriagem.this.validaCampoFilial();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                FrmImpressaoColetaTriagem.this.textFilial.selectAll();
            }
        });
    }

    private boolean validaCampoFilial() {
        return RecepcaoUtil.buscaDadosFilial(this, this.textFilial, this.buttonFilial, false);
    }

    private String getCodigoFilial() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            return this.textFilial.getText();
        }
        return Variaveis.filialPadrao;
    }

    private void pesquisarFilial() {
        Hashtable resultado = Pesquisas.filial(this.getTopLevelAncestor(), false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (e.getKeyCode() == 113) {
            if (o == this.textCodigo) {
                this.pesquisarRequisicao();
            } else if (o == this.textFilial) {
                this.pesquisarFilial();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int indice;
        Registro reg;
        Object o = e.getSource();
        if (o == this.textCodigo && e.getKeyCode() == 10 || e.getKeyChar() == '\t') {
            if (Funcoes.processarFuncaoNumeroTubo(this.textFilial, (TTextField)this.textCodigo)) {
                this.adicionarRequisicao(this.getCodigoFilial(), this.textCodigo.getText(), true, null, null, 1);
            }
            this.textCodigo.setText("");
            ScreenUtil.requisitarFoco(this.textCodigo);
        } else if (o == this.textFilial && e.getKeyCode() == 10) {
            if (this.validaCampoFilial()) {
                ScreenUtil.requisitarFoco(this.textCodigo);
            }
        } else if (e.getKeyCode() == 127 && (reg = this.modeloReq.getRegistro(indice = this.tableRequisicoes.getSelectedRow())) != null) {
            String req = reg.getString("req_codigo");
            if (Funcoes.mensagem(this, "Deseja remover a requisi\u00e7\u00e3o " + req + " ?", 4) == 0) {
                this.removerRegistroRequisicao(indice);
                int n = indice = indice > this.modeloReq.getRowCount() - 1 ? this.modeloReq.getRowCount() - 1 : indice;
                if (indice > -1) {
                    this.tableRequisicoes.setRowSelectionInterval(indice, indice);
                }
                this.buttonImprimirRequisicao.setEnabled(this.tableRequisicoes.getRowCount() > 0);
                this.buttonImprimirExame.setEnabled(this.tableExames.getRowCount() > 0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonBuscaRequisicao) {
                this.pesquisarRequisicao();
            } else if (o == this.buttonFechar) {
                this.setVisible(false);
                if (this.getParent() != null) {
                    this.getParent().removeAll();
                }
            } else if (o == this.buttonFechar) {
                if (this.getParent() != null) {
                    this.getParent().removeAll();
                }
                this.setVisible(false);
            } else if (o == this.buttonImprimirRequisicao) {
                this.menuImprimirRequisicao.show(this.buttonImprimirRequisicao.getParent(), this.buttonImprimirRequisicao.getX(), this.buttonImprimirRequisicao.getY() - this.menuImprimirRequisicao.getPreferredSize().height - 1);
            } else if (o == this.buttonImprimirExame) {
                this.menuImprimirExame.show(this.buttonImprimirExame.getParent(), this.buttonImprimirExame.getX(), this.buttonImprimirExame.getY() - this.menuImprimirRequisicao.getPreferredSize().height - 1);
            } else if (o == this.itemImprimirRequisicaoTodosColeta) {
                this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableRequisicoes.getRowCount()), 3, false);
            } else if (o == this.itemImprimirRequisicaoTodosTriagem) {
                this.imprimirRequisicoes(ArraysUtil.getArrayIndexado(this.tableRequisicoes.getRowCount()), 4, false);
            } else if (o == this.itemImprimirRequisicaoColeta) {
                this.imprimirRequisicoes(this.tableRequisicoes.getSelectedRows(), 1, false);
            } else if (o == this.itemImprimirRequisicaoTriagem) {
                this.imprimirRequisicoes(this.tableRequisicoes.getSelectedRows(), 2, false);
            } else if (o == this.itemImprimirExameTodosColeta) {
                this.imprimirExames(ArraysUtil.getArrayIndexado(this.tableExames.getRowCount()), 3, false);
            } else if (o == this.itemImprimirExameTodosTriagem) {
                this.imprimirExames(ArraysUtil.getArrayIndexado(this.tableExames.getRowCount()), 4, false);
            } else if (o == this.itemImprimirExameColeta) {
                this.imprimirExames(this.tableExames.getSelectedRows(), 3, true);
            } else if (o == this.itemImprimirExameTriagem) {
                this.imprimirExames(this.tableExames.getSelectedRows(), 4, true);
            } else if (o == this.buttonFiltrar) {
                this.filtrar();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmImpressaoColetaTriagem");
        }
    }

    private void filtrar() throws InterruptedException {
        DialogoFiltroEtiquetas dialogo = DialogoFiltroEtiquetas.novaInstancia(this.getTopLevelAncestor());
        dialogo.setLocationRelativeTo(this.getTopLevelAncestor());
        dialogo.setVisible(true);
        if (dialogo.getOk()) {
            this.setCursor(new Cursor(3));
            List<Registro> registros = dialogo.getRequisicoesSelecionados();
            int qtde = registros.size();
            boolean i = false;
            this.mensagemVisualizada = false;
            for (Registro r : registros) {
                if (this.modeloReq.contemValor("req_codigo", r.getString("req_codigo"))) continue;
                this.adicionarRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"), false, dialogo.getFiltroSetor(), dialogo.getFiltroExame(), qtde);
                this.tableRequisicoes.revalidate();
            }
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object o = e.getSource();
        if (o == this.tableRequisicoes.getSelectionModel()) {
            ModeloResultSet mrs;
            this.carregarModeloExames(this.tableRequisicoes.getSelectedRow());
            this.buttonImprimirRequisicao.setEnabled(this.tableRequisicoes.getSelectedRowCount() > 0);
            this.buttonImprimirExame.setEnabled(this.tableExames.getSelectedRowCount() > 0);
            Registro reg = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow());
            if (reg != null && (mrs = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) != null) {
                this.tableExames.setModel(mrs);
                if (mrs.getRowCount() > 0) {
                    this.tableExames.setRowSelectionInterval(0, 0);
                }
            }
            this.atualizarTextoBotaoImprimir(this.tableRequisicoes);
        } else if (o == this.tableExames.getSelectionModel()) {
            this.carregarModeloExames(this.tableRequisicoes.getSelectedRow());
            this.buttonImprimirRequisicao.setEnabled(this.tableExames.getSelectedRowCount() > 0);
            this.buttonImprimirExame.setEnabled(this.tableExames.getSelectedRowCount() > 0);
            ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
            this.atualizarTextoBotaoImprimir(this.tableExames);
        }
        this.modeloExa.setTamanhoColunas(this.tableExames, 55, 0, 40, 90, 28);
    }

    private void atualizarTextoBotaoImprimir(JTable table) {
        if (table == this.tableRequisicoes) {
            this.subImprimirRequisicao.setText(table.getSelectedRowCount() > 1 ? "Imprimir Requisi\u00e7\u00f5es" : "Imprimir Requisi\u00e7\u00e3o");
        } else if (table == this.tableExames) {
            this.subImprimirExame.setText(table.getSelectedRowCount() > 1 ? "Imprimir Exames Selecionados" : "Imprimir Exame Selecionado");
        }
    }

    public static long getModuloAcesso() {
        return 300300200L;
    }

    private List<Registro> getRequisicoesJaTriadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            ModeloResultSet modExa;
            Registro reg = this.modeloReq.getRegistro(i);
            if (reg == null || (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) == null) continue;
            boolean triado = false;
            for (int j = 0; !triado && j < modExa.getRowCount(); ++j) {
                Registro r = modExa.getRegistro(j);
                triado = r != null && r.getBoolean(ETQTRIAGEM_IMPRESSA);
            }
            if (!triado) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private List<Registro> getRequisicoesJaColetadas(int[] indices) {
        ArrayList<Registro> list = null;
        for (int i : indices) {
            ModeloResultSet modExa;
            Registro reg = this.modeloReq.getRegistro(i);
            if (reg == null || (modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES)) == null) continue;
            boolean coletado = false;
            for (int j = 0; !coletado && j < modExa.getRowCount(); ++j) {
                Registro r = modExa.getRegistro(j);
                coletado = r != null && r.getBoolean(ETQCOLETA_IMPRESSA);
            }
            if (!coletado) continue;
            if (list == null) {
                list = new ArrayList<Registro>();
            }
            list.add(reg);
        }
        return list;
    }

    private void imprimirRequisicoes(int[] indices, int etiqueta, boolean isImpressaoSelecionada) {
        String chaveImp = "campoImprimir";
        Statement st = Conexao.getStatement();
        try {
            ArrayList<String> exames = new ArrayList<String>();
            ArrayList<Integer> materiais = new ArrayList<Integer>();
            for (Registro reg : this.modeloReq.getRegistros(indices)) {
                exames.clear();
                materiais.clear();
                ModeloResultSet modExa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
                if (this.contemValor(modExa)) {
                    for (Registro regExa : modExa.getRegistros()) {
                        if (!this.podeImprimir(etiqueta, reg) || !this.adicionaExameMaterial(exames, materiais, regExa) || !this.isExameSelecionado(regExa) && !isImpressaoSelecionada) continue;
                        exames.add(regExa.getString("exa_codigo"));
                        materiais.add(new Integer(regExa.getInt("mco_codigo")));
                    }
                }
                if (!this.contemExames(exames)) continue;
                int[] mat = new int[materiais.size()];
                int pos = 0;
                Iterator iterator = materiais.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    mat[pos++] = i;
                }
                if (this.isEtiquetaTriagem(etiqueta)) {
                    ImprimirEtiquetasColetaTriagem.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), mat, true, Variaveis.login, 2);
                } else {
                    ImprimirEtiquetasColetaTriagem.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), exames.toArray(new String[exames.size()]), mat, true, Variaveis.login, 1);
                }
                Conexao.arquivaSQL();
            }
        }
        catch (Exception e) {
            this.anularSQL();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoColetaTriagem");
        }
    }

    private boolean adicionaExameMaterial(ArrayList<String> exames, ArrayList<Integer> materiais, Registro regExa) {
        return !exames.contains(regExa.getString("exa_codigo")) || !materiais.contains(new Integer(regExa.getInt("mco_codigo")));
    }

    private int[] getInteiros(ArrayList<Integer> lista) {
        int[] ints = new int[lista.size()];
        for (int i = 0; i < lista.size(); ++i) {
            ints[i] = lista.get(i);
        }
        return ints;
    }

    private void imprimirExames(int[] indices, int etiqueta, boolean isImpressaoSelecionada) {
        Statement st = Conexao.getStatement();
        String chaveImp = "campoImprimir";
        Registro regReq = this.modeloReq.getRegistro(this.tableRequisicoes.getSelectedRow());
        if (this.contemValor(regReq)) {
            try {
                ModeloResultSet modExa = (ModeloResultSet)this.tableExames.getModel();
                ArrayList<String> exames = new ArrayList<String>();
                ArrayList<Integer> materiais = new ArrayList<Integer>();
                for (Registro reg : modExa.getRegistros(indices)) {
                    if (!this.podeImprimir(etiqueta, reg) || !this.isExameSelecionado(reg) && !isImpressaoSelecionada) continue;
                    exames.add(reg.getString("exa_codigo"));
                    materiais.add(reg.getInt("mco_codigo"));
                }
                int[] mat = new int[materiais.size()];
                int pos = 0;
                Iterator iterator = materiais.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    mat[pos++] = i;
                }
                if (this.contemExames(exames)) {
                    ImprimirEtiquetasColetaTriagem.imprimir(regReq.getString("fil_codigo"), regReq.getString("req_codigo"), exames.toArray(new String[exames.size()]), mat, true, Variaveis.login, etiqueta);
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), e.getStackTrace(), "FrmImpressaoColetaTriagem");
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoColetaTriagem");
            }
        }
    }

    private boolean contemExames(ArrayList<String> exames) {
        return exames.size() > 0;
    }

    private boolean isExameSelecionado(Registro reg) {
        return reg.getBoolean("exameselecionado");
    }

    private boolean podeImprimir(int etiqueta, Registro reg) {
        return !this.etiquetaTriagemJaImpressa(etiqueta, reg) || !this.etiquetaColetaJaImpressa(etiqueta, reg) || reg.getBoolean(REIMPRIMIR);
    }

    private boolean etiquetaTriagemJaImpressa(int etiqueta, Registro reg) {
        return this.isEtiquetaTriagem(etiqueta) && !reg.getBoolean(ETQTRIAGEM_IMPRESSA);
    }

    private boolean etiquetaColetaJaImpressa(int etiqueta, Registro reg) {
        return this.isEtiquetaColeta(etiqueta) && !reg.getBoolean(ETQCOLETA_IMPRESSA);
    }

    private boolean isEtiquetaTriagem(int etiqueta) {
        return etiqueta == 2 || etiqueta == 4;
    }

    private boolean isEtiquetaColeta(int etiqueta) {
        return etiqueta == 1 || etiqueta == 3;
    }

    private boolean contemValor(Object obj) {
        return obj != null;
    }

    private void pesquisarRequisicao() {
        Hashtable res = Pesquisas.requisicao(this.getTopLevelAncestor(), this.getCodigoFilial(), false, false, false);
        if (res != null) {
            this.adicionarRequisicao(this.getCodigoFilial(), res.get("req_codigo").toString(), true, null, null, 1);
        }
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    private void carregarModeloExames(int linha) {
        if (linha >= 0 && linha < this.modeloReq.getRowCount()) {
            Registro registro = this.modeloReq.getRegistro(linha);
        }
    }

    private void adicionarRequisicao(String codigoFilial, String codigoRequisicao, boolean emiteMsgDuplicacao, String[] filtroSetor, String[] filtroExame, int count) {
        if (codigoRequisicao != null && codigoRequisicao.matches("\\-?\\d+")) {
            if (this.requisicaoJaAdicionada(codigoFilial, codigoRequisicao)) {
                if (emiteMsgDuplicacao) {
                    Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" j\u00e1 foi adicionada.", 1);
                }
            } else {
                Registro reg = this.verificaRequisicao(codigoFilial, codigoRequisicao, filtroSetor, filtroExame, count);
                if (reg != null && this.modeloReq.getRowCount() > 0) {
                    this.tableRequisicoes.setRowSelectionInterval(this.tableRequisicoes.getRowCount() - 1, this.tableRequisicoes.getRowCount() - 1);
                }
            }
        }
    }

    private String verificaEtiquetas(String codigoFilial, String codigoRequisicao, Registro reg, String[] filtroSetor, String[] filtroExame, int count) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        String EtiquetaTriagemImpressa = "";
        String EtiquetaColetaImpressa = "";
        if (st != null && this.modeloReq != null) {
            try {
                StringBuilder bui = new StringBuilder("select i.fil_codigo, i.req_codigo, i.exa_codigo, i.mco_codigo, ");
                bui.append(" b.pac_nome, c.exa_descricao, d.mco_abreviatura, a.con_codigo, ");
                bui.append(" i.exr_dataetqcoleta as ").append(ETQCOLETA_IMPRESSA).append(", ");
                bui.append(" i.exr_dataetqtriagem as ").append(ETQTRIAGEM_IMPRESSA).append(", ");
                bui.append(" i.exr_situacao, CASE WHEN i.exr_intervaloJejum is null then TO_CHAR(i.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(i.exr_intervaloJejum,'HH24:MI:SS') end as tempoJejum, i.exr_dataetqtriagem, ");
                bui.append(" true as exameselecionado, array_to_string(array_agg(exas.set_codigo), ',') as setores, ");
                bui.append(" true as exameselecionado, array_to_string(array_agg(c.exa_codigo), ',') as exames ");
                bui.append(" from examerequisicao i ");
                bui.append(" left join requisicao a on i.fil_codigo = a.fil_codigo and i.req_codigo = a.req_codigo");
                bui.append(" left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo");
                bui.append(" left join exames c on i.fil_codigo = c.fil_codigo and i.exa_codigo = c.exa_codigo");
                bui.append(" left join materialcoleta d on i.fil_codigo = d.fil_codigo and i.mco_codigo = d.mco_codigo");
                bui.append(" left join examesetor exas on i.fil_codigo = exas.fil_codigo and i.exa_codigo = exas.exa_codigo ");
                bui.append(" where i.fil_codigo = ");
                bui.append(codigoFilial);
                bui.append(" and i.req_codigo = ");
                bui.append(codigoRequisicao);
                bui.append(" and i.exr_excluido = false and a.req_excluida = false ");
                bui.append(" group by i.fil_codigo, i.req_codigo, i.exa_codigo, i.mco_codigo, b.pac_nome, c.exa_descricao, d.mco_abreviatura, ");
                bui.append("          a.con_codigo, i.exr_dataetqcoleta, i.exr_dataetqtriagem, i.exr_situacao, i.exr_dataetqtriagem, CASE WHEN i.exr_intervaloJejum is null then TO_CHAR(i.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(i.exr_intervaloJejum,'HH24:MI:SS') end ");
                bui.append(" order by i.exa_codigo ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                if (res.first()) {
                    ArrayList<String> listExa = new ArrayList<String>();
                    ModeloResultSet modExa = (ModeloResultSet)this.modeloExa.clone();
                    modExa.limpar();
                    do {
                        StringTokenizer token;
                        String obj;
                        if (listExa.contains(obj = res.getString("exa_codigo") + res.getString("mco_codigo"))) continue;
                        Registro tmp = new Registro();
                        tmp.setValor("exa_codigo", res.getString("exa_codigo"));
                        tmp.setValor("mco_codigo", res.getObject("mco_codigo"));
                        tmp.setValor("mco_abreviatura", res.getString("mco_abreviatura"));
                        tmp.setValor("exa_descricao", res.getString("exa_descricao"));
                        tmp.setValor("exr_situacao", Tipos.tipoSituacaoExame(res.getString("exr_situacao")));
                        tmp.setValor("req_codigo", res.getString("req_codigo"));
                        tmp.setValor("con_codigo", res.getString("con_codigo"));
                        tmp.setValor(ETQCOLETA_IMPRESSA, res.getObject(ETQCOLETA_IMPRESSA) != null);
                        tmp.setValor(ETQTRIAGEM_IMPRESSA, res.getObject(ETQTRIAGEM_IMPRESSA) != null);
                        tmp.setValor("exameselecionado", res.getBoolean("exameselecionado"));
                        if (filtroSetor != null && filtroSetor.length > 0) {
                            token = new StringTokenizer(res.getString("setores"), ",", false);
                            int setoresEncontrados = 0;
                            while (token.hasMoreTokens()) {
                                if (!ArraysUtil.contem(filtroSetor, token.nextToken())) continue;
                                ++setoresEncontrados;
                            }
                            tmp.setValor("exameselecionado", setoresEncontrados > 0);
                        }
                        if (filtroExame != null && filtroExame.length > 0) {
                            token = new StringTokenizer(res.getString("exames"), ",", false);
                            int examesEncontrados = 0;
                            while (token.hasMoreTokens()) {
                                if (!ArraysUtil.contem(filtroExame, token.nextToken())) continue;
                                ++examesEncontrados;
                            }
                            tmp.setValor("exameselecionado", examesEncontrados > 0);
                        }
                        if (EtiquetaColetaImpressa.length() == 0 && res.getObject(ETQCOLETA_IMPRESSA) != null) {
                            EtiquetaColetaImpressa = "coleta";
                        }
                        if (EtiquetaTriagemImpressa.length() == 0 && res.getObject(ETQTRIAGEM_IMPRESSA) != null) {
                            EtiquetaTriagemImpressa = "triagem";
                        }
                        modExa.addRegistro(tmp);
                        modExa.fireTableDataChanged();
                        listExa.add(obj);
                    } while (res.next());
                    reg.setValor(MODELO_EXAMES, modExa);
                    this.modeloReq.addRegistro(reg);
                    this.modeloReq.fireTableDataChanged();
                }
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "FrmImpressaoColetaTriagem");
            }
        }
        if (EtiquetaColetaImpressa.length() > 1 && EtiquetaTriagemImpressa.length() > 1) {
            return "A Requisi\u00e7\u00e3o ".concat(codigoRequisicao).concat(" j\u00e1 possui etiquetas de ").concat(EtiquetaColetaImpressa).concat(" e ").concat(EtiquetaTriagemImpressa).concat(" impressa. Deseja reimprimir?");
        }
        if (EtiquetaColetaImpressa.length() == 0 && EtiquetaTriagemImpressa.length() == 0) {
            return null;
        }
        if (count > 1) {
            return "Existem requisi\u00e7\u00f5es selecionadas que as etiquetas de Coleta/Triagem j\u00e1 foram impressas. Deseja imprimir mesmo assim ?";
        }
        this.mensagemVisualizada = false;
        return "A Requisi\u00e7\u00e3o ".concat(codigoRequisicao).concat(" j\u00e1 possui etiquetas de ").concat(EtiquetaColetaImpressa).concat(" e ").concat(EtiquetaTriagemImpressa).concat(" impressa. Deseja reimprimir?");
    }

    private boolean requisicaoJaAdicionada(String codigoFilial, String codigoRequisicao) {
        List<Registro> registros = this.modeloReq.getRegistros();
        int filial = -1;
        int requisicao = -1;
        if (Funcoes.isNumeric(codigoFilial)) {
            filial = Integer.parseInt(codigoFilial);
        }
        if (Funcoes.isNumeric(codigoRequisicao)) {
            requisicao = Integer.parseInt(codigoRequisicao);
        }
        for (Registro r : registros) {
            if (!r.getString("fil_codigo").equals(codigoFilial) || !r.getString("req_codigo").equals(codigoRequisicao)) continue;
            return true;
        }
        return false;
    }

    private Registro verificaRequisicao(String codigoFilial, String codigoRequisicao, String[] filtroSetor, String[] filtroExame, int count) {
        Registro reg = null;
        if (codigoRequisicao.matches("\\-?\\d+")) {
            SituacaoRequisicao sit = new SituacaoRequisicao(codigoFilial, codigoRequisicao);
            if (!sit.existe()) {
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" n\u00e3o existe.", 1);
            } else {
                reg = ImpressaoResultados.getRequisicao(codigoFilial, codigoRequisicao);
                String jaTemImpresso = this.verificaEtiquetas(codigoFilial, codigoRequisicao, reg, filtroSetor, filtroExame, count);
                if (jaTemImpresso != null) {
                    if (!this.mensagemVisualizada) {
                        this.mensagemVisualizada = true;
                        boolean bl = this.ok = Funcoes.mensagem(this, jaTemImpresso, 4, true) == 0;
                    }
                    if (this.ok) {
                        reg.setValor(REIMPRIMIR, this.ok);
                    } else {
                        int indice = this.tableRequisicoes.getRowCount() - 1;
                        this.removerRegistroRequisicao(indice);
                        int n = indice = indice > this.modeloReq.getRowCount() - 1 ? this.modeloReq.getRowCount() - 1 : indice;
                        if (indice > -1) {
                            this.tableRequisicoes.setRowSelectionInterval(indice, indice);
                        }
                        this.buttonImprimirRequisicao.setEnabled(this.tableRequisicoes.getRowCount() > 0);
                        this.buttonImprimirExame.setEnabled(this.tableExames.getRowCount() > 0);
                    }
                } else {
                    reg = ImpressaoResultados.getRequisicao(codigoFilial, codigoRequisicao);
                    reg.setValor(REIMPRIMIR, false);
                }
            }
        }
        return reg;
    }

    private void removerRegistroRequisicao(int indice) {
        Registro reg = this.modeloReq.getRegistro(indice);
        if (reg != null) {
            ModeloResultSet exa = (ModeloResultSet)reg.getValor(MODELO_EXAMES);
            if (exa != null) {
                exa.limpar();
            }
            this.modeloReq.removerRegistro(indice);
            this.modeloReq.fireTableDataChanged();
        }
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmImpressaoColetaTriagem");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

