/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.EmailUtil;
import jalis.util.CheckItemFiltro;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.codec.binary.Base64;

public class EnviarEmailResultado
extends FrmPadrao
implements ActionListener {
    private static final String MODULO_ACESSO = "0400600200";
    private static final int QTDE_MAXIMA_PDFS_EMAIL = 20;
    private static final int COLUNA_CLIENTES_OBJETO = 0;
    private static final int COLUNA_CLIENTES_CONFIGURACAO = 1;
    private static final int COLUNA_REQUISICOES_EXAMES_REQUISICAO = 0;
    private static final int COLUNA_REQUISICOES_EXAMES_EXAME = 1;
    private static final int COLUNA_REQUISICOES_EXAMES_MATERIAL = 2;
    private static final int COLUNA_REQUISICOES_EXAMES_SELECAO = 3;
    private static final int COLUNA_REQUISICOES_EXAMES_OBJETO = 5;
    private static final int COLUNA_REQUISICOES_EXAMES_OBJETO_SEGUNDA_VIA = 5;
    private static final int COLUNA_SEGUNDA_VIA_SELECAO = 4;
    private static final String PARAMETRO_EMAIL = "EnviarEmail.email";
    private JCheckBox checkTodosExamesProntos = new JCheckBox("Todos os exames prontos");
    private JCheckBox checkEnviarCertificadoAnalise = new JCheckBox("Enviar como certificado de an\u00e1lise");
    private JCheckBox checkEnviarEmailFiscalRequisicao = new JCheckBox("Enviar e-mail para fiscal da requisi\u00e7\u00e3o");
    private JCheckBox checkAgruparExamesParaEnvio = new JCheckBox("Agrupar exames p/ envio");
    private JCheckBox checkEnviarVeterinario = new JCheckBox("Enviar somente para o Veterin\u00e1rio");
    private JCheckBox checkEnviarPaciente = new JCheckBox("Enviar somente para o Paciente");
    private TTextField textDataInicial = new TTextField(0, 4);
    private TTextField textDataFinal = new TTextField(0, 4);
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonClientesEnviarTodos = ComponenteFactory.novoJButton("Enviar todos", 'E', this, null, null);
    private JButton buttonClientesEnviarSelecionado = ComponenteFactory.novoJButton("Enviar selecionado", 'n', this, null, null);
    private JButton buttonConfigurarCopia = ComponenteFactory.novoJButton("Configurar c\u00f3pia", 'E', this, null, null);
    private JButton buttonRequisicoesExamesSelecionarTodos = ComponenteFactory.novoJButton("Selecionar todos", 'S', this, null, null);
    private JButton buttonRequisicoesExamesInverterSelecao = ComponenteFactory.novoJButton("Inverter sele\u00e7\u00e3o", 'I', this, null, null);
    private JButton buttonSegundaViaSelecionarTodos = ComponenteFactory.novoJButton("Selecionar todos", 'S', this, null, null);
    private JButton buttonSegundaViaInverterSelecao = ComponenteFactory.novoJButton("Inverter sele\u00e7\u00e3o", 'I', this, null, null);
    private JTable tableClientes = new JTable();
    private JTable tableRequisicoesExames = new JTable();
    private JTable tableSegundaVia = new JTable();
    private ArrayList<String> listaEmailsClienteCopia = null;
    private ModeloGridTable modeloClientes = new ModeloGridTable(new String[]{"C\u00f3digo - Fantasia", "Conf."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Object.class;
            }
            return ArrayList.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    };
    private ModeloGridTable modeloRequisicoesExames = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Exame", "Material", "Sel.", ""}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }
    };
    private ModeloGridTable modeloSegundaVia = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Exame", "Data/Hora Envio", "Material", "Sel."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }
    };
    private JScrollPane scrollClientes = new JScrollPane(this.tableClientes);
    private JScrollPane scrollRequisicoesExames = new JScrollPane(this.tableRequisicoesExames);
    private JScrollPane scrollSegundaVia = new JScrollPane(this.tableSegundaVia);
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemExame;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemCliente;
    private JPanel panelClientes = new JPanel(new BorderLayout());
    private JPanel panelClientesBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelRequisicoesExamesBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelRequisicoesExames = new JPanel(new BorderLayout());
    private JPanel panelSegundaVia = new JPanel(new BorderLayout());
    private JPanel panelSegundaViaBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private JPanel panelClientesRequisicoesExames = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentral = new JPanel(new BorderLayout());
    JTabbedPane tabbedSouth = new JTabbedPane();
    private LinkedHashMap<Integer, DadosCliente> mapaClientes = new LinkedHashMap();
    private Boolean isCarregandoRequisicoesExames = false;
    private SplashMensagem mensagem = null;

    public EnviarEmailResultado() {
        this.montaTela();
        this.montaListeners();
    }

    private void montaListeners() {
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EnviarEmailResultado.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EnviarEmailResultado.this.buttonDataFinal.doClick();
                }
            }
        });
        this.tableClientes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                final int row = EnviarEmailResultado.this.tableClientes.getSelectedRow();
                Boolean bl = EnviarEmailResultado.this.isCarregandoRequisicoesExames;
                synchronized (bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EnviarEmailResultado.this.isCarregandoRequisicoesExames = true;
                            EnviarEmailResultado.this.modeloRequisicoesExames.clear();
                            EnviarEmailResultado.this.modeloSegundaVia.clear();
                            if (row > -1) {
                                DadosCliente dadosCliente = (DadosCliente)EnviarEmailResultado.this.modeloClientes.getValueAt(row, 0);
                                if (dadosCliente != null) {
                                    for (DadosRequisicoesExames reqExa : dadosCliente.getListaRequisicoesExames()) {
                                        if (reqExa.getDataEnvioEmail() != null) {
                                            EnviarEmailResultado.this.modeloSegundaVia.addLine(new Object[]{!Funcoes.textoVazio(reqExa.getSuplemento()) ? reqExa.getCodigoRequisicao() + reqExa.getSuplemento() : reqExa.getCodigoRequisicao(), reqExa.getCodigoExame(), Funcoes.formataDataEHora(reqExa.getDataEnvioEmail()), reqExa.getAbreviaturaMaterial(), reqExa.isSelecionado(), reqExa});
                                            continue;
                                        }
                                        EnviarEmailResultado.this.modeloRequisicoesExames.addLine(new Object[]{!Funcoes.textoVazio(reqExa.getSuplemento()) ? reqExa.getCodigoRequisicao() + reqExa.getSuplemento() : reqExa.getCodigoRequisicao(), reqExa.getCodigoExame(), reqExa.getAbreviaturaMaterial(), reqExa.isSelecionado(), reqExa.getDataEnvioEmail(), reqExa});
                                    }
                                    EnviarEmailResultado.this.validaBotoesCliente(dadosCliente);
                                } else {
                                    EnviarEmailResultado.this.validaBotoesCliente(null);
                                }
                            } else {
                                EnviarEmailResultado.this.validaBotoesCliente(null);
                            }
                            EnviarEmailResultado.this.isCarregandoRequisicoesExames = false;
                        }
                    });
                }
            }
        });
        this.tableRequisicoesExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isSelecionado;
                int row = EnviarEmailResultado.this.tableRequisicoesExames.getSelectedRow();
                if (row < 0) {
                    return;
                }
                if (e.getKeyCode() == 32 && EnviarEmailResultado.this.tableRequisicoesExames.getSelectedColumn() != 3) {
                    isSelecionado = (Boolean)EnviarEmailResultado.this.modeloRequisicoesExames.getValueAt(row, 3);
                    EnviarEmailResultado.this.modeloRequisicoesExames.setValueAt(!isSelecionado, row, 3);
                }
                isSelecionado = (Boolean)EnviarEmailResultado.this.modeloRequisicoesExames.getValueAt(row, 3);
                DadosRequisicoesExames reqExa = (DadosRequisicoesExames)EnviarEmailResultado.this.modeloRequisicoesExames.getValueAt(row, 5);
                if (reqExa != null) {
                    reqExa.setSelecionado(isSelecionado);
                }
            }
        });
        this.modeloRequisicoesExames.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!EnviarEmailResultado.this.isCarregandoRequisicoesExames.booleanValue() && e.getColumn() == 3) {
                    int row = e.getLastRow();
                    if (row < 0) {
                        return;
                    }
                    boolean isSelecionado = (Boolean)EnviarEmailResultado.this.modeloRequisicoesExames.getValueAt(row, 3);
                    DadosRequisicoesExames reqExa = (DadosRequisicoesExames)EnviarEmailResultado.this.modeloRequisicoesExames.getValueAt(row, 5);
                    if (reqExa != null) {
                        reqExa.setSelecionado(isSelecionado);
                    }
                }
            }
        });
        this.tableSegundaVia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isSelecionado;
                int row = EnviarEmailResultado.this.tableSegundaVia.getSelectedRow();
                if (row < 0) {
                    return;
                }
                if (e.getKeyCode() == 32 && EnviarEmailResultado.this.tableSegundaVia.getSelectedColumn() != 4) {
                    isSelecionado = (Boolean)EnviarEmailResultado.this.modeloSegundaVia.getValueAt(row, 4);
                    EnviarEmailResultado.this.modeloSegundaVia.setValueAt(!isSelecionado, row, 4);
                }
                isSelecionado = (Boolean)EnviarEmailResultado.this.modeloSegundaVia.getValueAt(row, 4);
                DadosRequisicoesExames reqExa = (DadosRequisicoesExames)EnviarEmailResultado.this.modeloSegundaVia.getValueAt(row, 5);
                if (reqExa != null) {
                    reqExa.setSelecionado(isSelecionado);
                }
            }
        });
        this.modeloSegundaVia.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!EnviarEmailResultado.this.isCarregandoRequisicoesExames.booleanValue() && e.getColumn() == 4) {
                    int row = e.getLastRow();
                    if (row < 0) {
                        return;
                    }
                    boolean isSelecionado = (Boolean)EnviarEmailResultado.this.modeloSegundaVia.getValueAt(row, 4);
                    DadosRequisicoesExames reqExa = (DadosRequisicoesExames)EnviarEmailResultado.this.modeloSegundaVia.getValueAt(row, 5);
                    if (reqExa != null) {
                        reqExa.setSelecionado(isSelecionado);
                    }
                }
            }
        });
        this.checkEnviarCertificadoAnalise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnviarEmailResultado.this.tableClientes.repaint();
                int row = EnviarEmailResultado.this.tableClientes.getSelectedRow();
                if (row > -1) {
                    EnviarEmailResultado.this.validaBotoesCliente((DadosCliente)EnviarEmailResultado.this.modeloClientes.getValueAt(row, 0));
                }
            }
        });
        this.checkEnviarCertificadoAnalise.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnviarEmailResultado.this.checkEnviarEmailFiscalRequisicao.setEnabled(true);
                    EnviarEmailResultado.this.checkTodosExamesProntos.setSelected(true);
                    EnviarEmailResultado.this.checkAgruparExamesParaEnvio.setSelected(false);
                    if (EnviarEmailResultado.this.tableClientes.getRowCount() > 0) {
                        EnviarEmailResultado.this.consultar();
                    }
                } else {
                    EnviarEmailResultado.this.checkEnviarEmailFiscalRequisicao.setEnabled(false);
                    EnviarEmailResultado.this.checkEnviarEmailFiscalRequisicao.setSelected(false);
                }
                EnviarEmailResultado.this.tableClientes.repaint();
                int row = EnviarEmailResultado.this.tableClientes.getSelectedRow();
                if (row > -1) {
                    EnviarEmailResultado.this.validaBotoesCliente((DadosCliente)EnviarEmailResultado.this.modeloClientes.getValueAt(row, 0));
                }
            }
        });
        this.checkAgruparExamesParaEnvio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnviarEmailResultado.this.checkEnviarCertificadoAnalise.setSelected(false);
                }
                if (EnviarEmailResultado.this.tableClientes.getRowCount() > 0) {
                    EnviarEmailResultado.this.consultar();
                }
            }
        });
        this.checkEnviarVeterinario.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnviarEmailResultado.this.checkEnviarPaciente.setSelected(false);
            }
        });
        this.checkEnviarPaciente.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnviarEmailResultado.this.checkEnviarVeterinario.setSelected(false);
            }
        });
    }

    private void validaBotoesCliente(DadosCliente dadosCliente) {
        this.buttonClientesEnviarTodos.setEnabled(this.modeloClientes.getRowCount() > 0);
        this.buttonConfigurarCopia.setEnabled(this.modeloClientes.getRowCount() > 0);
        if (dadosCliente == null) {
            this.buttonClientesEnviarSelecionado.setEnabled(false);
            this.buttonRequisicoesExamesInverterSelecao.setEnabled(false);
            this.buttonRequisicoesExamesSelecionarTodos.setEnabled(false);
        } else {
            if (this.checkEnviarCertificadoAnalise.isSelected()) {
                this.buttonClientesEnviarSelecionado.setEnabled(!Funcoes.textoVazio(dadosCliente.getUFCliente()));
            } else {
                this.buttonClientesEnviarSelecionado.setEnabled(dadosCliente.listaEmailsCliente != null && dadosCliente.listaEmailsCliente.size() > 0);
            }
            this.buttonRequisicoesExamesInverterSelecao.setEnabled(this.modeloRequisicoesExames.getRowCount() > 0);
            this.buttonRequisicoesExamesSelecionarTodos.setEnabled(this.modeloRequisicoesExames.getRowCount() > 0);
        }
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        String campo = "Paciente";
        Funcoes.criaBarraDescricao(this, "Enviar e-mail", "Envio de e-mail de resultados para pacientes", "resultados/enviar_email.jpg");
        if (Tipos.isFilialAlimentos(Variaveis.tipoFilialPadrao)) {
            campo = "Fantasia";
            Funcoes.criaBarraDescricao(this, "Enviar e-mail", "Envio de e-mail de resultados para clientes", "resultados/enviar_email.jpg");
        }
        this.modeloClientes = new ModeloGridTable(new String[]{"C\u00f3digo - " + campo, "Conf."}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Object.class;
                }
                return ArrayList.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }
        };
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.montaPanelFiltro();
        this.montaPanelCentral();
        this.montaPanelBotoes();
        this.carregarParametros();
    }

    private void montaPanelBotoes() {
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
    }

    private void montaPanelCentral() {
        this.panelCentral.add((Component)this.panelFiltro, "North");
        this.panelCentral.add((Component)this.panelClientesRequisicoesExames, "Center");
        this.montaPanelClientesRequisicoesExames();
    }

    private void montaPanelClientesRequisicoesExames() {
        if (Tipos.isFilialAlimentos(Variaveis.tipoFilialPadrao)) {
            this.panelClientes.setBorder(new TitledBorder("Clientes"));
        } else {
            this.panelClientes.setBorder(new TitledBorder("Pacientes"));
        }
        this.tabbedSouth.addTab("Requisi\u00e7\u00f5es/Exames", this.panelRequisicoesExames);
        this.tabbedSouth.addTab("Segunda Via", this.panelSegundaVia);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.18;
        c.weighty = 1.0;
        this.panelClientesRequisicoesExames.add((Component)this.panelClientes, c);
        ++c.gridx;
        c.weightx = 0.65;
        this.panelClientesRequisicoesExames.add((Component)this.tabbedSouth, c);
        this.montaPanelClientes();
        this.montaPanelRequisicoesExames();
        this.montaPanelSegundaVia();
    }

    private void montaPanelClientes() {
        this.panelClientes.add((Component)this.scrollClientes, "Center");
        this.panelClientes.add((Component)this.panelClientesBotoes, "South");
        this.panelClientesBotoes.add(this.buttonConfigurarCopia);
        this.panelClientesBotoes.add(this.buttonClientesEnviarTodos);
        this.panelClientesBotoes.add(this.buttonClientesEnviarSelecionado);
        this.tableClientes.setModel(this.modeloClientes);
        this.modeloClientes.setColumnSize(new int[]{0, 40}, this.tableClientes);
        this.tableClientes.setDefaultRenderer(Object.class, new ClienteRenderer());
        this.tableClientes.setDefaultRenderer(ArrayList.class, new ClienteConfiguracaoRendererEditor());
        this.tableClientes.setDefaultEditor(ArrayList.class, new ClienteConfiguracaoRendererEditor());
    }

    private void montaPanelRequisicoesExames() {
        this.panelRequisicoesExames.add((Component)this.scrollRequisicoesExames, "Center");
        this.panelRequisicoesExames.add((Component)this.panelRequisicoesExamesBotoes, "South");
        this.panelRequisicoesExamesBotoes.add(this.buttonRequisicoesExamesSelecionarTodos);
        this.panelRequisicoesExamesBotoes.add(this.buttonRequisicoesExamesInverterSelecao);
        this.tableRequisicoesExames.setModel(this.modeloRequisicoesExames);
        this.modeloRequisicoesExames.setColumnSize(new int[]{80, 0, 55, 25, 1}, this.tableRequisicoesExames);
    }

    private void montaPanelSegundaVia() {
        this.panelSegundaVia.add((Component)this.scrollSegundaVia, "Center");
        this.panelSegundaVia.add((Component)this.panelSegundaViaBotoes, "South");
        this.panelSegundaViaBotoes.add(this.buttonSegundaViaSelecionarTodos);
        this.panelSegundaViaBotoes.add(this.buttonSegundaViaInverterSelecao);
        this.tableSegundaVia.setModel(this.modeloSegundaVia);
        this.modeloSegundaVia.setColumnSize(new int[]{80, 0, 120, 70, 25}, this.tableSegundaVia);
    }

    private void montaPanelFiltro() {
        this.panelFiltro.setBorder(BorderFactory.createTitledBorder("Filtro"));
        this.panelFiltro.setLayout(new GridBagLayout());
        Dimension dim = new Dimension(150, 20);
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setPreferredSize(dim);
        this.itemFilial.setMinimumSize(dim);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dim);
        this.itemColeta.setMinimumSize(dim);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dim);
        this.itemDestino.setMinimumSize(dim);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dim);
        this.itemConvenio.setMinimumSize(dim);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dim);
        this.itemExame.setMinimumSize(dim);
        if (Tipos.isFilialVeterinaria(Variaveis.tipoFilialPadrao)) {
            this.itemSituacao = new CheckItemFiltro("Veterin\u00e1rio", "Filtrar", "Filtrando veterin\u00e1rios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemSituacao.setDados("medico", new String[]{"med_crm", "med_conselho", "med_uf", "med_nome"}, new String[]{"C\u00f3digo", "Conselho", "UF", "Nome"}, new int[]{70, 70, 30, 0});
            this.itemSituacao.setColunaHint(1);
            this.itemSituacao.setPreferredSize(dim);
            this.itemSituacao.setMinimumSize(dim);
        } else {
            this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.itemSituacao.setColunaHint(1);
            this.itemSituacao.setPreferredSize(dim);
            this.itemSituacao.setMinimumSize(dim);
        }
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setPreferredSize(dim);
        this.itemSetor.setMinimumSize(dim);
        if (Tipos.isFilialAlimentos(Variaveis.tipoFilialPadrao)) {
            this.itemCliente = new CheckItemFiltro("Cliente", "Filtrar", "Filtrando empresa", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemCliente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            this.itemCliente.setColunaHint(1);
            this.itemCliente.setPreferredSize(dim);
            this.itemCliente.setMinimumSize(dim);
        } else {
            this.itemCliente = new CheckItemFiltro("Pacientes", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemCliente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            this.itemCliente.setColunaHint(1);
            this.itemCliente.setPreferredSize(dim);
            this.itemCliente.setMinimumSize(dim);
        }
        this.textDataInicial.setPreferredSize(new Dimension(100, 20));
        this.textDataInicial.setMinimumSize(new Dimension(100, 20));
        this.buttonDataInicial.setFocusable(false);
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.textDataFinal.setPreferredSize(new Dimension(100, 20));
        this.textDataFinal.setMinimumSize(new Dimension(100, 20));
        this.buttonDataFinal.setFocusable(false);
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.buttonConsultar.setPreferredSize(new Dimension(110, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(110, 20));
        Insets insetNormal = new Insets(1, 1, 1, 1);
        Insets insetEspacamento = new Insets(1, 20, 1, 1);
        Insets insetEspacamentoMaior = new Insets(1, 37, 1, 1);
        Insets insetEspacamentoMenor = new Insets(1, 17, 1, 1);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetNormal;
        this.panelFiltro.add((Component)this.itemFilial, cons);
        ++cons.gridy;
        this.panelFiltro.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        this.panelFiltro.add((Component)this.itemDestino, cons);
        ++cons.gridy;
        this.panelFiltro.add((Component)this.itemSetor, cons);
        ++cons.gridy;
        cons.gridwidth = 2;
        this.checkTodosExamesProntos.setSelected(true);
        this.panelFiltro.add((Component)this.checkTodosExamesProntos, cons);
        ++cons.gridx;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.insets = insetEspacamentoMaior;
        this.panelFiltro.add((Component)this.itemConvenio, cons);
        ++cons.gridy;
        this.panelFiltro.add((Component)this.itemExame, cons);
        ++cons.gridy;
        this.panelFiltro.add((Component)this.itemSituacao, cons);
        ++cons.gridy;
        this.panelFiltro.add((Component)this.itemCliente, cons);
        if (Tipos.isFilialAlimentos(Variaveis.tipoFilialPadrao)) {
            ++cons.gridy;
            this.panelFiltro.add((Component)this.checkAgruparExamesParaEnvio, cons);
        }
        cons.gridx = 2;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.insets = insetEspacamento;
        this.panelFiltro.add((Component)this.labelDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetNormal;
        this.panelFiltro.add((Component)this.textDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetNormal;
        this.panelFiltro.add((Component)this.buttonDataInicial, cons);
        ++cons.gridy;
        cons.gridx = 2;
        cons.insets = insetEspacamento;
        this.panelFiltro.add((Component)this.labelDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetNormal;
        this.panelFiltro.add((Component)this.textDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetNormal;
        this.panelFiltro.add((Component)this.buttonDataFinal, cons);
        Integer diferenca = 3;
        if (Tipos.isFilialAlimentos(Variaveis.tipoFilialPadrao)) {
            ++cons.gridy;
            cons.gridx = 2;
            cons.gridwidth = 3;
            cons.insets = insetEspacamentoMenor;
            this.panelFiltro.add((Component)this.checkEnviarCertificadoAnalise, cons);
            ++cons.gridy;
            this.checkEnviarEmailFiscalRequisicao.setEnabled(false);
            this.panelFiltro.add((Component)this.checkEnviarEmailFiscalRequisicao, cons);
            diferenca = 1;
        }
        if (Tipos.isFilialVeterinaria(Variaveis.tipoFilialPadrao)) {
            ++cons.gridy;
            cons.gridx = 2;
            cons.gridwidth = 3;
            cons.insets = insetEspacamentoMenor;
            this.panelFiltro.add((Component)this.checkEnviarVeterinario, cons);
            ++cons.gridy;
            this.checkEnviarEmailFiscalRequisicao.setEnabled(false);
            this.panelFiltro.add((Component)this.checkEnviarPaciente, cons);
            diferenca = 1;
        }
        cons.gridy += diferenca.intValue();
        cons.gridx = 3;
        cons.gridwidth = 3;
        cons.weightx = 1.0;
        cons.anchor = 13;
        cons.insets = insetNormal;
        this.panelFiltro.add((Component)this.buttonConsultar, cons);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonConsultar) {
            this.consultar();
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, this.panelFiltro, false);
        } else if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, this.panelFiltro, false);
        } else if (e.getSource() == this.buttonClientesEnviarSelecionado) {
            this.enviarClienteSelecionado(false);
        } else if (e.getSource() == this.buttonClientesEnviarTodos) {
            this.enviarTodosClientes();
        } else if (e.getSource() == this.buttonRequisicoesExamesInverterSelecao) {
            this.inverterSelecaoExames();
        } else if (e.getSource() == this.buttonRequisicoesExamesSelecionarTodos) {
            this.selecionarTodosExames();
        } else if (e.getSource() == this.buttonSegundaViaInverterSelecao) {
            this.inverterSelecaoSegundaViaExames();
        } else if (e.getSource() == this.buttonSegundaViaSelecionarTodos) {
            this.selecionarSegundaViaTodosExames();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonConfigurarCopia) {
            this.configurarCopia();
        }
    }

    private void configurarCopia() {
        DadosCliente dadosCliente;
        if (this.tableClientes.getSelectedRow() > -1 && (dadosCliente = (DadosCliente)this.modeloClientes.getValueAt(this.tableClientes.getSelectedRow(), 0)) != null) {
            DialogConfiguracaoEmails dialog = new DialogConfiguracaoEmails(Laboratorio.getInstancia(), dadosCliente, true);
            dialog.setVisible(true);
        }
    }

    private void carregarParametros() {
        String[] emails;
        this.listaEmailsClienteCopia = new ArrayList();
        for (String email : emails = ParametrosUsuarios.getValor(PARAMETRO_EMAIL).split(";")) {
            if (Funcoes.textoVazio(email)) continue;
            this.listaEmailsClienteCopia.add(email);
        }
    }

    private void novo() {
        this.modeloClientes.clear();
        this.modeloRequisicoesExames.clear();
        this.modeloSegundaVia.clear();
        this.mapaClientes.clear();
        this.itemCliente.setSelected(false);
        this.itemColeta.setSelected(false);
        this.itemConvenio.setSelected(false);
        this.itemDestino.setSelected(false);
        this.itemExame.setSelected(false);
        this.itemFilial.setSelected(false);
        this.itemSetor.setSelected(false);
        this.itemSituacao.setSelected(false);
        this.textDataFinal.clear();
        this.textDataInicial.clear();
        this.checkEnviarCertificadoAnalise.setSelected(false);
        this.checkTodosExamesProntos.setSelected(true);
        this.checkEnviarVeterinario.setSelected(false);
        this.checkEnviarPaciente.setSelected(false);
        this.validaBotoesCliente(null);
    }

    private void selecionarTodosExames() {
        for (int i = 0; i < this.modeloRequisicoesExames.getRowCount(); ++i) {
            this.modeloRequisicoesExames.setValueAt(true, i, 3);
        }
    }

    private void selecionarSegundaViaTodosExames() {
        for (int i = 0; i < this.modeloSegundaVia.getRowCount(); ++i) {
            this.modeloSegundaVia.setValueAt(true, i, 4);
        }
    }

    private void inverterSelecaoExames() {
        for (int i = 0; i < this.modeloRequisicoesExames.getRowCount(); ++i) {
            this.modeloRequisicoesExames.setValueAt((Boolean)this.modeloRequisicoesExames.getValueAt(i, 3) == false, i, 3);
        }
    }

    private void inverterSelecaoSegundaViaExames() {
        for (int i = 0; i < this.modeloSegundaVia.getRowCount(); ++i) {
            this.modeloSegundaVia.setValueAt((Boolean)this.modeloSegundaVia.getValueAt(i, 4) == false, i, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarTodosClientes() {
        new SplashMensagem();
        this.mensagem = SplashMensagem.getInstancia(this);
        this.mensagem.mostrar("Aguarde...");
        try {
            this.modeloRequisicoesExames.clear();
            this.modeloSegundaVia.clear();
            for (int i = 0; i < this.tableClientes.getRowCount(); ++i) {
                this.tableClientes.setRowSelectionInterval(i, i);
                int row = this.tableClientes.getSelectedRow();
                DadosCliente dadosCliente = (DadosCliente)this.modeloClientes.getValueAt(row, 0);
                if (this.checkEnviarCertificadoAnalise.isSelected() || dadosCliente.getListaEmailsCliente().size() > 0) {
                    for (DadosRequisicoesExames reqExa : dadosCliente.getListaRequisicoesExames()) {
                        if (reqExa.getDataEnvioEmail() != null) {
                            this.modeloSegundaVia.addLine(new Object[]{!Funcoes.textoVazio(reqExa.getSuplemento()) ? reqExa.getCodigoRequisicao() + reqExa.getSuplemento() : reqExa.getCodigoRequisicao(), reqExa.getCodigoExame(), reqExa.getDataEnvioEmail(), reqExa.getAbreviaturaMaterial(), reqExa.isSelecionado(), reqExa});
                            continue;
                        }
                        this.modeloRequisicoesExames.addLine(new Object[]{!Funcoes.textoVazio(reqExa.getSuplemento()) ? reqExa.getCodigoRequisicao() + reqExa.getSuplemento() : reqExa.getCodigoRequisicao(), reqExa.getCodigoExame(), reqExa.getAbreviaturaMaterial(), reqExa.isSelecionado(), reqExa.getDataEnvioEmail(), reqExa});
                    }
                    this.enviarClienteSelecionado(true);
                    this.modeloRequisicoesExames.clear();
                    this.modeloSegundaVia.clear();
                    continue;
                }
                dadosCliente.setEnviado(false);
            }
        }
        finally {
            this.mensagem.apagar();
            this.mensagem = null;
            this.tableClientes.repaint();
            this.consultar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarClienteSelecionado(boolean enviandoTodos) {
        if (!enviandoTodos) {
            new SplashMensagem();
            this.mensagem = SplashMensagem.getInstancia(this);
            this.mensagem.mostrar("Aguarde...");
        }
        try {
            int row = this.tableClientes.getSelectedRow();
            if (row > -1) {
                DadosCliente dadosCliente = (DadosCliente)this.modeloClientes.getValueAt(row, 0);
                if (!this.checkEnviarCertificadoAnalise.isSelected() && dadosCliente.getListaEmailsCliente().size() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 e-mail configurado para o cliente.", 2);
                    return;
                }
                ArrayList<DadosRequisicoesExames> listaReqExa = this.getListaRequisicoesSelecionadosCliente(dadosCliente);
                if (listaReqExa.size() == 0) {
                    Funcoes.mensagem(this, "Nenhum exame selecionado para envio.", 2);
                    return;
                }
                HashMap<String, LinkedList<DadosRequisicoesExames>> mapaReqExa = this.agrupaRequisicoesExamesMaterial(listaReqExa);
                if (mapaReqExa != null) {
                    HashMap<DadosRequisicoesExames, LinkedList<RetornoImpressaoResultados2>> mapaPDFsRequisicao = new HashMap<DadosRequisicoesExames, LinkedList<RetornoImpressaoResultados2>>();
                    for (String requisicao : mapaReqExa.keySet()) {
                        DadosRequisicoesExames dadosRequisicao = mapaReqExa.get(requisicao).get(0);
                        LinkedList<RetornoImpressaoResultados2> listaPDF = this.criaPDFsRequisicoesExames(mapaReqExa.get(requisicao), dadosRequisicao);
                        if (mapaPDFsRequisicao.containsKey(dadosRequisicao)) {
                            LinkedList listaAux = (LinkedList)mapaPDFsRequisicao.get(dadosRequisicao);
                            listaAux.addAll(listaPDF);
                            continue;
                        }
                        mapaPDFsRequisicao.put(dadosRequisicao, listaPDF);
                    }
                    ArrayList<String> listaMateriais = new ArrayList<String>();
                    for (DadosRequisicoesExames filialRequisicao : mapaPDFsRequisicao.keySet()) {
                        String chave = filialRequisicao.abreviaturaMaterial;
                        if (listaMateriais.contains(chave)) continue;
                        listaMateriais.add(chave);
                    }
                    for (String key : listaMateriais) {
                        HashMap mapaPDFsMaterial = new HashMap();
                        for (DadosRequisicoesExames filialRequisicao : mapaPDFsRequisicao.keySet()) {
                            if (!filialRequisicao.abreviaturaMaterial.equalsIgnoreCase(key)) continue;
                            mapaPDFsMaterial.put(filialRequisicao, mapaPDFsRequisicao.get(filialRequisicao));
                        }
                        int cont = 0;
                        int qt = mapaPDFsMaterial.size();
                        LinkedList<RetornoImpressaoResultados2> agrupaPDF = new LinkedList<RetornoImpressaoResultados2>();
                        for (DadosRequisicoesExames filialRequisicao : mapaPDFsMaterial.keySet()) {
                            LinkedList listaPDF = (LinkedList)mapaPDFsMaterial.get(filialRequisicao);
                            if (cont == 0 && !agrupaPDF.isEmpty()) {
                                agrupaPDF.clear();
                            }
                            agrupaPDF.addAll(listaPDF);
                            if ((cont += listaPDF.size()) < 20 && --qt > 0) continue;
                            cont = 0;
                            this.criarEmail(dadosCliente, filialRequisicao, agrupaPDF);
                        }
                    }
                }
            }
        }
        finally {
            if (!enviandoTodos) {
                this.mensagem.apagar();
                this.mensagem = null;
                this.tableClientes.repaint();
                this.consultar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void criarEmail(DadosCliente dadosCliente, DadosRequisicoesExames filialRequisicao, LinkedList<RetornoImpressaoResultados2> listaPDF) {
        Statement st;
        ArrayList<String> listaEmailsCopia;
        ArrayList<String> listaEmails;
        ArrayList<byte[]> resultadosCompactados;
        block23: {
            resultadosCompactados = this.geraXmlPDFs(dadosCliente, filialRequisicao, listaPDF);
            listaEmails = new ArrayList<String>();
            listaEmailsCopia = new ArrayList<String>();
            if (this.checkEnviarCertificadoAnalise.isSelected()) {
                ArrayList<String> listaEmailsCertificadoAnalise;
                block22: {
                    listaEmailsCertificadoAnalise = new ArrayList<String>();
                    if (Funcoes.textoVazio(dadosCliente.getUFCliente())) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Informe a cidade do cliente " + dadosCliente.getFantasiaCliente(), 2);
                        return;
                    }
                    String emailGoverno = this.buscaEmailCidadeCliente(dadosCliente.getCodigoCliente(), filialRequisicao.getCodigoFilial());
                    if (Funcoes.textoVazio(emailGoverno)) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum e-mail informado na cidade para o envio de certificado de an\u00e1lise.", 2);
                        return;
                    }
                    String arquivo = System.getProperty("user.home") + System.getProperty("file.separator") + "debug_email.jalis";
                    boolean debug = Funcoes.arquivoExiste(arquivo);
                    if (debug) {
                        try {
                            String conteudoArquivo = StringUtil.lerArquivoTexto(arquivo);
                            if (!Funcoes.textoVazio(conteudoArquivo)) {
                                String[] emailDebug;
                                for (String email : emailDebug = conteudoArquivo.trim().split("\\;")) {
                                    listaEmailsCertificadoAnalise.add(email);
                                }
                                break block22;
                            }
                            listaEmailsCertificadoAnalise.add(emailGoverno);
                            if (this.checkEnviarEmailFiscalRequisicao.isSelected() && !Funcoes.textoVazio(filialRequisicao.getEmailFiscal())) {
                                listaEmailsCertificadoAnalise.add(filialRequisicao.getEmailFiscal());
                            }
                            listaEmails.addAll(dadosCliente.listaEmailsCliente);
                            listaEmailsCopia.addAll(this.listaEmailsClienteCopia);
                        }
                        catch (Exception e) {
                            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel ler o arquivo de configura\u00e7\u00e3o (debug_email.jalis).\nMensagem: " + e.getMessage(), 1);
                        }
                    } else {
                        listaEmailsCertificadoAnalise.add(emailGoverno);
                        if (this.checkEnviarEmailFiscalRequisicao.isSelected() && !Funcoes.textoVazio(filialRequisicao.getEmailFiscal())) {
                            listaEmailsCertificadoAnalise.add(filialRequisicao.getEmailFiscal());
                        }
                        listaEmails.addAll(dadosCliente.listaEmailsCliente);
                        listaEmailsCopia.addAll(this.listaEmailsClienteCopia);
                    }
                }
                for (String emailcerti : listaEmailsCertificadoAnalise) {
                    if (listaEmails.contains(emailcerti)) continue;
                    listaEmails.add(emailcerti);
                }
            } else {
                listaEmails.addAll(dadosCliente.listaEmailsCliente);
                listaEmailsCopia.addAll(this.listaEmailsClienteCopia);
            }
            st = Conexao.getStatement();
            if (!this.checkEnviarCertificadoAnalise.isSelected()) break block23;
            String sql = "select fil_fraseemailcertificadoanalise from filiais_postocoleta where fil_codigo = " + Variaveis.filialPadrao;
            ResultSet resultSet = Conexao.executeQuery(this.getStatement(), sql);
            if (!resultSet.next() || !Funcoes.textoVazio(resultSet.getString("fil_fraseemailcertificadoanalise"))) break block23;
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma configura\u00e7\u00e3o de e-mail para certificado de an\u00e1lise foi encontrada.", 2);
            Conexao.fecharStatement(st);
            return;
        }
        try {
            for (byte[] resultado : resultadosCompactados) {
                String codigoRequisicao;
                String xmlDec = new String(resultado);
                String[] anexos = StringUtil.getValores(xmlDec, "pdf");
                if (anexos == null) continue;
                String descricaoMaterial = StringUtil.getValor(anexos[0], "material");
                String codigoFilial = StringUtil.getValor(anexos[0], "filial");
                if (!EmailUtil.criaLogEmailResultadoPDF(codigoFilial, codigoRequisicao = StringUtil.getValor(anexos[0], "requisicao"), descricaoMaterial, listaEmails, listaEmailsCopia, resultado, this.checkEnviarCertificadoAnalise.isSelected() ? EmailUtil.TipoEmail.RESULTADO_CERTIFICADO_ANALISE : EmailUtil.TipoEmail.RESULTADO_PDF, st)) {
                    Conexao.anulaSQL();
                    break;
                }
                this.atualizaDadosRequisicoes(anexos);
            }
            Conexao.arquivaSQL();
            dadosCliente.setEnviado(true);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel enviar e-mail do cliente selecionado.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void atualizaDadosRequisicoes(String[] anexos) throws SQLException {
        Statement st = Conexao.getStatementTratandoShutdown();
        PreparedStatement prstAtualizaExameRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), this.montaSQL());
        for (int i = 0; i < anexos.length; ++i) {
            String codigoFilial = StringUtil.getValor(anexos[i], "filial");
            String codigoRequisicao = StringUtil.getValor(anexos[i], "requisicao");
            prstAtualizaExameRequisicao.setString(1, Variaveis.login);
            prstAtualizaExameRequisicao.setTimestamp(2, new Timestamp(new Date().getTime()));
            prstAtualizaExameRequisicao.setInt(3, Integer.parseInt(codigoFilial));
            prstAtualizaExameRequisicao.setInt(4, Integer.parseInt(codigoRequisicao));
            prstAtualizaExameRequisicao.executeUpdate();
        }
    }

    private String montaSQL() {
        StringBuilder buf = new StringBuilder();
        buf.append(" update examerequisicao  ");
        buf.append("  set usr_codenvioemail = ?  ");
        buf.append("  ,exr_dataenvioemail = ?  ");
        buf.append("   where fil_codigo = ?  ");
        buf.append("   and req_codigo = ?  ");
        return buf.toString();
    }

    private String buscaEmailCidadeCliente(Integer codigoCliente, Integer fil_codigo) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select c.cid_emaillaudooficial from paciente p ");
            buf.append("inner join cidades c on (p.fil_codigo = c.fil_codigo and p.cid_codigo = c.cid_codigo)");
            buf.append(" where p.fil_codigo = ").append(fil_codigo);
            buf.append(" and p.pac_codigo = ").append(codigoCliente);
            ResultSet resultSet = Conexao.executeQuery(this.getStatement(), buf.toString());
            return resultSet.next() ? resultSet.getString("cid_emaillaudooficial") : "";
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar e-mail no cadastro da cidade.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private ArrayList<byte[]> geraXmlPDFs(DadosCliente dadosCliente, DadosRequisicoesExames filialRequisicao, LinkedList<RetornoImpressaoResultados2> mapaPDFsRequisicao) {
        ArrayList<byte[]> listaZip = new ArrayList<byte[]>();
        XMLStringBuilder baos = new XMLStringBuilder();
        baos.escreveHeader("1.0", "ISO-8859-1");
        baos.abrir("anexos");
        int qtde = 0;
        int qtdeLista = 0;
        for (RetornoImpressaoResultados2 pdf : mapaPDFsRequisicao) {
            String nomeFile = pdf.getSoa().replaceAll("[.;:|\\/\\\\-]", "_");
            nomeFile = this.checkEnviarCertificadoAnalise.isSelected() ? (Funcoes.textoVazio(nomeFile) ? pdf.getSoa() + "." + pdf.getSifCliente() + "." + Funcoes.formataData("yyyy", pdf.getDataRequisicao()) : nomeFile) + ".pdf" : Funcoes.preencheZero(pdf.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(pdf.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + ".pdf";
            try {
                baos.abrir("pdf");
                baos.escrever("nome", nomeFile);
                baos.escrever("conteudo", new Base64().encodeAsString(pdf.getImpressao().getResultadoPdfWeb()));
                baos.escrever("filial", pdf.getFilial().toString());
                baos.escrever("requisicao", pdf.getRequisicao().toString());
                baos.escrever("material", pdf.getMaterial().toString());
                baos.fechar("pdf");
                if (++qtde != 20 && qtde != mapaPDFsRequisicao.size() && ++qtdeLista != mapaPDFsRequisicao.size()) continue;
                baos.fechar("anexos");
                listaZip.add(baos.getXML().getBytes());
                if (mapaPDFsRequisicao.size() > qtdeLista) {
                    baos = new XMLStringBuilder();
                    baos.escreveHeader("1.0", "ISO-8859-1");
                    baos.abrir("anexos");
                }
                qtde = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel compactar os PDFs para enviar.", e.getStackTrace());
            }
        }
        return listaZip;
    }

    private LinkedList<RetornoImpressaoResultados2> criaPDFsRequisicoesExames(LinkedList<DadosRequisicoesExames> listaReqExa, DadosRequisicoesExames dadosExame) {
        LinkedList<RetornoImpressaoResultados2> listaPDF = new LinkedList<RetornoImpressaoResultados2>();
        DadosRequisicoesExames reqExaAux = listaReqExa.get(0);
        String[] codigosExames = this.getArrayCodigosExames(listaReqExa);
        String[] codigosMateriais = this.getArrayCodigosMateriais(listaReqExa);
        try {
            RetornoImpressaoResultados2 pdf = new RetornoImpressaoResultados2(ImpressaoResultados.imprimirExames(null, this.getTopLevelAncestor(), reqExaAux.getCodigoFilial().toString(), reqExaAux.getCodigoRequisicao().toString(), true, true, null, codigosExames, codigosMateriais, true, null, true, true, null, false, null, false, false), reqExaAux.soaExame, reqExaAux.getCodigoFilial().toString(), reqExaAux.getCodigoRequisicao().toString(), reqExaAux.getDataRequisicao(), dadosExame.getCodigoSOAExame(), reqExaAux.descricaoMaterial);
            if (pdf != null) {
                listaPDF.add(pdf);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel compactar os PDFs para enviar.", e.getStackTrace());
        }
        return listaPDF;
    }

    private String[] getArrayCodigosExames(LinkedList<DadosRequisicoesExames> listaReqExa) {
        if (listaReqExa == null) {
            return null;
        }
        String[] arrayExames = new String[listaReqExa.size()];
        for (int i = 0; i < listaReqExa.size(); ++i) {
            DadosRequisicoesExames reqExa = listaReqExa.get(i);
            arrayExames[i] = reqExa.getCodigoExame();
        }
        return arrayExames;
    }

    private String[] getArrayCodigosMateriais(LinkedList<DadosRequisicoesExames> listaReqExa) {
        if (listaReqExa == null) {
            return null;
        }
        String[] arrayExames = new String[listaReqExa.size()];
        for (int i = 0; i < listaReqExa.size(); ++i) {
            DadosRequisicoesExames reqExa = listaReqExa.get(i);
            arrayExames[i] = reqExa.getCodigoMaterial().toString();
        }
        return arrayExames;
    }

    private HashMap<String, LinkedList<DadosRequisicoesExames>> agrupaRequisicoesExamesMaterial(ArrayList<DadosRequisicoesExames> listaRequisicoes) {
        if (listaRequisicoes == null) {
            return null;
        }
        HashMap<String, LinkedList<DadosRequisicoesExames>> mapaExames = new HashMap<String, LinkedList<DadosRequisicoesExames>>();
        for (DadosRequisicoesExames reqExa : listaRequisicoes) {
            ArrayList<DadosRequisicoesExames> listaDesagrupaExame = this.desagrupaExames(reqExa);
            for (DadosRequisicoesExames reqExames : listaDesagrupaExame) {
                String chave = (!Funcoes.textoVazio(reqExa.getCodigoSOAExame()) ? reqExa.getCodigoSOAExame() + "_" : "") + reqExa.getCodigoFilial() + "_" + reqExa.getCodigoRequisicao() + "_" + reqExa.getCodigoMaterial();
                LinkedList<DadosRequisicoesExames> listaAux = mapaExames.get(chave);
                if (listaAux != null) {
                    listaAux.add(reqExames);
                    continue;
                }
                listaAux = new LinkedList();
                listaAux.add(reqExames);
                mapaExames.put(chave, listaAux);
            }
        }
        return mapaExames;
    }

    private ArrayList<DadosRequisicoesExames> desagrupaExames(DadosRequisicoesExames listaExame) {
        String[] exames;
        ArrayList<DadosRequisicoesExames> listaDesagrupaExame = new ArrayList<DadosRequisicoesExames>();
        for (String exa : exames = listaExame.getCodigoExame().split(",")) {
            DadosRequisicoesExames reqAux = listaExame.getClone();
            reqAux.codigoExame = exa;
            listaDesagrupaExame.add(reqAux);
        }
        return listaDesagrupaExame;
    }

    private ArrayList<DadosRequisicoesExames> getListaRequisicoesSelecionadosCliente(DadosCliente dadosCliente) {
        int i;
        ArrayList<DadosRequisicoesExames> listaReqExa = new ArrayList<DadosRequisicoesExames>();
        for (i = 0; i < this.modeloSegundaVia.getRowCount(); ++i) {
            if (!this.modeloSegundaVia.getValueAt(i, 4).equals(Boolean.TRUE)) continue;
            listaReqExa.add((DadosRequisicoesExames)this.modeloSegundaVia.getValueAt(i, 5));
        }
        for (i = 0; i < this.modeloRequisicoesExames.getRowCount(); ++i) {
            if (!this.modeloRequisicoesExames.getValueAt(i, 3).equals(Boolean.TRUE)) continue;
            listaReqExa.add((DadosRequisicoesExames)this.modeloRequisicoesExames.getValueAt(i, 5));
        }
        return listaReqExa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultar() {
        String[] situacoes;
        String[] clientes;
        String[] exames;
        String[] convenios;
        String[] setores;
        String[] destinos;
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct pac.pac_codigo as codigoCliente ");
        buf.append("      ,pac.pac_nome as fantasiaCliente ");
        if (this.checkEnviarPaciente.isSelected() || !Tipos.isFilialVeterinaria(Variaveis.tipoFilialPadrao)) {
            buf.append("      ,pac.pac_email as emailCliente ");
        } else if (this.checkEnviarVeterinario.isSelected()) {
            buf.append("      ,med.med_email as emailCliente ");
        } else {
            buf.append("      ,pac.pac_email as emailCliente ");
            buf.append("      ,med.med_email as emailVeterinario ");
        }
        buf.append("      ,pac.pac_sif as sifCliente ");
        buf.append("      ,req.fil_codigo as codigoFilial ");
        buf.append("      ,req.req_codigo as codigoRequisicao ");
        buf.append("      ,req.req_data as dataRequisicao ");
        buf.append("      ,array_agg(distinct exr.exa_codigo) as codigoExame ");
        buf.append("      ,exr.mco_codigo as codigoMaterial ");
        buf.append("      ,mco.mco_abreviatura as abreviaturaMaterial ");
        buf.append("      ,mco.mco_descricao as descricaoMaterial ");
        if (this.checkAgruparExamesParaEnvio.isSelected()) {
            buf.append("      , CASE WHEN req.req_nrsolicitacaoproduto = '' THEN '0' ELSE req.req_nrsolicitacaoproduto END AS soaExame ");
        } else {
            buf.append("      ,COALESCE(NULLIF(TRIM(req.req_nrsolicitacaoproduto), ''), NULLIF(TRIM(exa.exa_soa), ''), '0') as soaExame ");
        }
        buf.append(" ,CASE WHEN req.req_nrsuplemento = 0 THEN '' ELSE ' - s' || req.req_nrsuplemento END  as suplementoRequisicao ");
        buf.append("      ,cid.cid_uf as ufCliente ");
        buf.append("      ,ent.ent_email as emailFiscal ");
        buf.append(" \t\t ,exr.exr_dataenvioemail as dataEnvioEmail");
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("  join filiais_postocoleta fil on req.fil_codigo = req.fil_codigo ");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  left join cidades cid on pac.fil_codigo = cid.fil_codigo and pac.cid_codigo = cid.cid_codigo ");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  left join coletas col on req.fil_codigo = col.fil_codigo and req.col_codigo = col.col_codigo ");
        buf.append("  left join destino des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
        buf.append("  left join situacao sit on req.fil_codigo = sit.fil_codigo and req.sit_codigo = sit.sit_codigo ");
        buf.append("  left join entidade ent on req.fil_codigo = ent.fil_codigo and req.ent_codigo = ent.ent_codigo and upper(ent.ent_tipo) = '").append("I").append("' ");
        buf.append("  left join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm ");
        if (this.itemSetor.getSelecionados() != null && this.itemSetor.getSelecionados().length > 0) {
            buf.append("left join examesetor set on exa.fil_codigo = set.fil_codigo and exa.exa_codigo = set.exa_codigo and set.ese_default = true ");
        }
        buf.append(" where req.fil_codigo IN (");
        String[] filiais = this.itemFilial.getSelecionados();
        if (filiais == null || filiais.length == 0) {
            buf.append(Variaveis.filialPadrao);
        } else {
            for (int i = 0; i < filiais.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(filiais[i]);
            }
        }
        buf.append(") ");
        buf.append(" and not req.req_excluida ");
        String[] coletas = this.itemColeta.getSelecionados();
        if (coletas != null && coletas.length > 0) {
            buf.append(" and col.col_codigo IN ('");
            for (int i = 0; i < coletas.length; ++i) {
                if (i > 0) {
                    buf.append("', '");
                }
                buf.append(coletas[i]);
            }
            buf.append("') ");
        }
        if ((destinos = this.itemDestino.getSelecionados()) != null && destinos.length > 0) {
            buf.append(" and des.des_codigo IN ('");
            for (int i = 0; i < destinos.length; ++i) {
                if (i > 0) {
                    buf.append("', '");
                }
                buf.append(destinos[i]);
            }
            buf.append("') ");
        }
        if ((setores = this.itemSetor.getSelecionados()) != null && setores.length > 0) {
            buf.append(" and set.set_codigo IN (");
            for (int i = 0; i < setores.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(setores[i]);
            }
            buf.append(") ");
        }
        if ((convenios = this.itemConvenio.getSelecionados()) != null && convenios.length > 0) {
            buf.append(" and con.con_codigo IN (");
            for (int i = 0; i < convenios.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(convenios[i]);
            }
            buf.append(") ");
        }
        if ((exames = this.itemExame.getSelecionados()) != null && exames.length > 0) {
            buf.append(" and exa.exa_codigo IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("'").append(exames[i]).append("'");
            }
            buf.append(") ");
        }
        if ((clientes = this.itemCliente.getSelecionados()) != null && clientes.length > 0) {
            buf.append(" and pac.pac_codigo IN (");
            for (int i = 0; i < clientes.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(clientes[i]);
            }
            buf.append(") ");
        }
        if ((situacoes = this.itemSituacao.getSelecionados()) != null && situacoes.length > 0) {
            if (Tipos.isFilialVeterinaria(Variaveis.tipoFilialPadrao)) {
                buf.append(" and med.med_crm IN ('");
            } else {
                buf.append(" and sit.sit_codigo IN ('");
            }
            for (int i = 0; i < situacoes.length; ++i) {
                if (i > 0) {
                    buf.append("', '");
                }
                buf.append(situacoes[i]);
            }
            buf.append("') ");
        }
        buf.append(" and not exr.exr_excluido ");
        buf.append(" and req.req_total - req.req_totpago = 0 ");
        buf.append(" and exr.exr_situacao IN ('").append("C").append("', '").append("E").append("', '");
        buf.append("I").append("') ");
        if (this.checkTodosExamesProntos.isSelected()) {
            buf.append(" and (select COUNT(1) from examerequisicao exr1 where exr.fil_codigo = exr1.fil_codigo and exr.req_codigo = exr1.req_codigo and not exr1.exr_excluido ");
            buf.append("      and exr1.exr_situacao IN ('").append("C").append("', '").append("E").append("', '").append("I").append("')) ");
            buf.append(" = (select COUNT(1) from examerequisicao exr1 where exr.fil_codigo = exr1.fil_codigo and exr.req_codigo = exr1.req_codigo and not exr1.exr_excluido) ");
        }
        if (!Funcoes.textoVazio(this.textDataInicial)) {
            buf.append(" and req.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append("' ");
        }
        if (!Funcoes.textoVazio(this.textDataFinal)) {
            buf.append(" and req.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append("' ");
        }
        buf.append(" group by pac.pac_codigo ");
        buf.append("         ,pac.pac_nome ");
        buf.append("         ,pac.pac_email ");
        buf.append("         ,med.med_email ");
        buf.append("         ,req.fil_codigo ");
        buf.append("         ,req.req_codigo ");
        buf.append("         ,req.req_nrsolicitacaoproduto ");
        buf.append("         ,exr.mco_codigo ");
        buf.append("         ,mco.mco_abreviatura ");
        buf.append("         ,exa.exa_soa ");
        buf.append("         ,pac.pac_sif ");
        buf.append("         ,req.req_data ");
        buf.append("         ,cid.cid_uf ");
        buf.append("         ,mco.mco_descricao ");
        buf.append("         ,ent.ent_email ");
        buf.append(" \t\t\t\t ,exr.exr_dataenvioemail");
        buf.append("         ,req.req_nrsuplemento ");
        buf.append(" order by pac.pac_nome ");
        buf.append("         ,pac.pac_codigo ");
        buf.append("         ,req.fil_codigo ");
        buf.append("         ,req.req_codigo ");
        buf.append("         ,exr.mco_codigo ");
        this.mapaClientes.clear();
        this.modeloClientes.clear();
        this.modeloRequisicoesExames.clear();
        this.validaBotoesCliente(null);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                this.carregaDados(rs);
            }
            this.preencheDados();
        }
        catch (SQLException sqle) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as requisi\u00e7\u00f5es.\n" + sqle.getMessage(), sqle.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void preencheDados() {
        DadosCliente dadosCliente = null;
        for (Integer codigoCliente : this.mapaClientes.keySet()) {
            dadosCliente = this.mapaClientes.get(codigoCliente);
            for (int i = 0; i < dadosCliente.getListaRequisicoesExames().size(); ++i) {
                if (dadosCliente.getListaRequisicoesExames().get(i).getDataEnvioEmail() != null) continue;
                dadosCliente.getListaRequisicoesExames().get(i).setSelecionado(true);
            }
            this.modeloClientes.addLine(new Object[]{dadosCliente, null});
        }
        if (this.tableClientes.getRowCount() > 0) {
            this.tableClientes.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.validaBotoesCliente(dadosCliente);
    }

    private void carregaDados(ResultSet rs) throws SQLException {
        do {
            Integer codigoCliente = rs.getInt("codigoCliente");
            String nomeCliente = rs.getString("fantasiaCliente");
            String emailCliente = rs.getString("emailCliente");
            String emailFiscal = rs.getString("emailFiscal");
            String sifCliente = rs.getString("sifCliente");
            String ufCliente = rs.getString("ufCliente");
            DadosCliente dadosCliente = this.mapaClientes.get(codigoCliente);
            HashSet<String> emails = new HashSet<String>();
            if (dadosCliente == null) {
                dadosCliente = new DadosCliente(codigoCliente, nomeCliente, emailCliente, sifCliente, ufCliente);
                if (Tipos.isFilialVeterinaria(Variaveis.tipoFilialPadrao) && !this.checkEnviarVeterinario.isSelected() && !this.checkEnviarPaciente.isSelected()) {
                    dadosCliente.getListaEmailsCliente().add(rs.getString("emailVeterinario"));
                }
                for (String email : dadosCliente.getListaEmailsCliente()) {
                    StringTokenizer parser = new StringTokenizer(email, ";,/ ");
                    while (parser.hasMoreTokens()) {
                        String emailParse = parser.nextToken();
                        emails.add(emailParse.trim());
                    }
                }
                dadosCliente.listaEmailsCliente.clear();
                for (String key : emails) {
                    if (dadosCliente.listaEmailsCliente.contains(key)) continue;
                    dadosCliente.listaEmailsCliente.add(key.trim());
                }
                this.mapaClientes.put(codigoCliente, dadosCliente);
            }
            dadosCliente.addExame(rs.getInt("codigoFilial"), rs.getInt("codigoRequisicao"), StringUtil.limpaString(rs.getString("codigoExame"), new String[]{"{", "}"}), rs.getInt("codigoMaterial"), rs.getString("abreviaturaMaterial"), rs.getString("descricaoMaterial"), rs.getString("soaExame"), rs.getDate("dataRequisicao"), emailFiscal, rs.getString("suplementoRequisicao"), rs.getString("dataEnvioEmail"));
        } while (rs.next());
    }

    public static long getModuloAcesso() {
        return Long.parseLong(MODULO_ACESSO);
    }

    private void salvarListaEmail() {
        String emails = "";
        for (String email : this.listaEmailsClienteCopia) {
            if (Funcoes.textoVazio(email)) continue;
            emails = Funcoes.textoVazio(emails) ? email : emails + ";" + email;
        }
        ParametrosUsuarios.setValor(PARAMETRO_EMAIL, emails);
        ParametrosUsuarios.salvarParametros(true);
    }

    private class RetornoImpressaoResultados2 {
        private RetornoImpressaoResultados impressao = null;
        private String soa = null;
        private String filial = null;
        private String requisicao = null;
        private Date dataRequisicao = null;
        private String sifCliente = null;
        private String material = null;

        public RetornoImpressaoResultados2(RetornoImpressaoResultados impressao, String soa, String filial, String requisicao, Date dataRequisicao, String sifCliente, String material) {
            this.impressao = impressao;
            this.soa = soa;
            this.filial = filial;
            this.requisicao = requisicao;
            this.dataRequisicao = dataRequisicao;
            this.sifCliente = sifCliente;
            this.material = material;
        }

        public RetornoImpressaoResultados2(RetornoImpressaoResultados impressao, String soa) {
            this.impressao = impressao;
            this.soa = soa;
        }

        public String getFilial() {
            return this.filial;
        }

        public String getRequisicao() {
            return this.requisicao;
        }

        public Date getDataRequisicao() {
            return this.dataRequisicao;
        }

        public String getSifCliente() {
            return this.sifCliente;
        }

        public String getMaterial() {
            return this.material;
        }

        public String getSoa() {
            return this.soa;
        }

        public RetornoImpressaoResultados getImpressao() {
            return this.impressao;
        }
    }

    private class DialogConfiguracaoEmails
    extends AbstractDialogoOKCancelar {
        private static final int COLUNA_EMAILS_EMAIL = 0;
        private JTable tableEmails;
        private ModeloGridTable modeloEmails;
        private JScrollPane scrollEmails;
        private JLabel labelEmail;
        private TTextField textEmail;
        private JButton buttonAdicionar;
        private DadosCliente dadosCliente;
        private int linhaEdicao;
        private boolean isCopia;

        public DialogConfiguracaoEmails(Frame pai, DadosCliente dadosCliente, boolean isCopia) {
            super(pai, isCopia ? "Configurando e-mails para c\u00f3pia" : "Configurando e-mails");
            this.tableEmails = new JTable();
            this.modeloEmails = new ModeloGridTable(new String[]{"E-mail"});
            this.scrollEmails = new JScrollPane(this.tableEmails);
            this.labelEmail = new JLabel("E-mail:");
            this.textEmail = new TTextField(100, 15);
            this.buttonAdicionar = new JButton("Adicionar");
            this.dadosCliente = null;
            this.linhaEdicao = -1;
            this.dadosCliente = dadosCliente;
            this.isCopia = isCopia;
            this.setDefaultCloseOperation(0);
            this.setSize(new Dimension(450, 300));
            this.setResizable(false);
            ScreenUtil.centralizar(this);
            this.montaTela();
            this.montaListeners();
            this.preencheEmails(isCopia ? EnviarEmailResultado.this.listaEmailsClienteCopia : dadosCliente.getListaEmailsCliente());
            ScreenUtil.requisitarFoco(this.textEmail);
        }

        private void montaTela() {
            this.getPanelCentral().setLayout(new GridBagLayout());
            this.tableEmails.setModel(this.modeloEmails);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(1, 1, 0, 1);
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.getPanelCentral().add((Component)this.labelEmail, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.textEmail.setPreferredSize(new Dimension(20, 20));
            this.textEmail.setMinimumSize(new Dimension(20, 20));
            this.getPanelCentral().add((Component)this.textEmail, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.buttonAdicionar.setPreferredSize(new Dimension(110, 20));
            this.buttonAdicionar.setMinimumSize(new Dimension(110, 20));
            this.buttonAdicionar.setMnemonic('A');
            this.getPanelCentral().add((Component)this.buttonAdicionar, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 3;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.fill = 1;
            this.getPanelCentral().add((Component)this.scrollEmails, c);
        }

        private void montaListeners() {
            this.buttonAdicionar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Funcoes.textoVazio(DialogConfiguracaoEmails.this.textEmail) && Funcoes.validaEmail(DialogConfiguracaoEmails.this.textEmail.getText())) {
                        boolean jaInserido = false;
                        for (int i = 0; i < DialogConfiguracaoEmails.this.modeloEmails.getRowCount(); ++i) {
                            if (!DialogConfiguracaoEmails.this.modeloEmails.getValueAt(i, 0).toString().equals(DialogConfiguracaoEmails.this.textEmail.getText()) || i == DialogConfiguracaoEmails.this.linhaEdicao) continue;
                            jaInserido = true;
                            break;
                        }
                        if (jaInserido) {
                            Funcoes.mensagem(DialogConfiguracaoEmails.this, "O e-mail j\u00e1 foi adicionado.", 2);
                            DialogConfiguracaoEmails.this.textEmail.selectAll();
                            ScreenUtil.requisitarFoco(DialogConfiguracaoEmails.this.textEmail);
                            return;
                        }
                        if (DialogConfiguracaoEmails.this.linhaEdicao > -1) {
                            DialogConfiguracaoEmails.this.modeloEmails.setValueAt(DialogConfiguracaoEmails.this.textEmail.getText(), DialogConfiguracaoEmails.this.linhaEdicao, 0);
                            DialogConfiguracaoEmails.this.linhaEdicao = -1;
                        } else {
                            DialogConfiguracaoEmails.this.modeloEmails.addLine(new Object[]{DialogConfiguracaoEmails.this.textEmail.getText()});
                        }
                        DialogConfiguracaoEmails.this.textEmail.clear();
                        ScreenUtil.requisitarFoco(DialogConfiguracaoEmails.this.textEmail);
                    }
                }
            });
            this.tableEmails.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int row = DialogConfiguracaoEmails.this.tableEmails.getSelectedRow();
                    if (row > -1) {
                        if (e.getKeyCode() == 127) {
                            DialogConfiguracaoEmails.this.modeloEmails.removeLine(row);
                        } else if (e.getKeyCode() == 32) {
                            DialogConfiguracaoEmails.this.linhaEdicao = DialogConfiguracaoEmails.this.tableEmails.getSelectedRow();
                            if (DialogConfiguracaoEmails.this.linhaEdicao > -1) {
                                DialogConfiguracaoEmails.this.textEmail.setText(DialogConfiguracaoEmails.this.modeloEmails.getValueAt(DialogConfiguracaoEmails.this.linhaEdicao, 0).toString());
                                ScreenUtil.requisitarFoco(DialogConfiguracaoEmails.this.textEmail);
                            }
                        }
                    }
                }
            });
            this.tableEmails.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (DialogConfiguracaoEmails.this.linhaEdicao > -1 && DialogConfiguracaoEmails.this.tableEmails.getSelectedRow() != DialogConfiguracaoEmails.this.linhaEdicao) {
                        DialogConfiguracaoEmails.this.linhaEdicao = -1;
                        DialogConfiguracaoEmails.this.textEmail.clear();
                    }
                }
            });
        }

        private void preencheEmails(ArrayList<String> listaEmails) {
            if (listaEmails == null) {
                return;
            }
            for (String email : listaEmails) {
                if (Funcoes.textoVazio(email)) continue;
                this.modeloEmails.addLine(new Object[]{email});
            }
        }

        @Override
        protected boolean acaoOk() {
            if (this.isCopia) {
                EnviarEmailResultado.this.listaEmailsClienteCopia.clear();
                for (int i = 0; i < this.modeloEmails.getRowCount(); ++i) {
                    EnviarEmailResultado.this.listaEmailsClienteCopia.add(this.modeloEmails.getValueAt(i, 0).toString());
                }
                EnviarEmailResultado.this.salvarListaEmail();
            } else {
                this.dadosCliente.listaEmailsCliente.clear();
                for (int i = 0; i < this.modeloEmails.getRowCount(); ++i) {
                    this.dadosCliente.listaEmailsCliente.add(this.modeloEmails.getValueAt(i, 0).toString());
                }
            }
            return true;
        }
    }

    private class ClienteConfiguracaoRendererEditor
    extends JPanel
    implements TableCellRenderer,
    TableCellEditor {
        private DadosCliente dadosCliente = null;
        private int selectedRow = -1;
        private int selectedColumn;

        public ClienteConfiguracaoRendererEditor() {
            this.setOpaque(true);
            JButton buttonConfiguracao = new JButton("...");
            buttonConfiguracao.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClienteConfiguracaoRendererEditor.this.dadosCliente = (DadosCliente)EnviarEmailResultado.this.modeloClientes.getValueAt(ClienteConfiguracaoRendererEditor.this.selectedRow, 0);
                    if (ClienteConfiguracaoRendererEditor.this.dadosCliente != null) {
                        DialogConfiguracaoEmails dialog = new DialogConfiguracaoEmails(Laboratorio.getInstancia(), ClienteConfiguracaoRendererEditor.this.dadosCliente, false);
                        dialog.setVisible(true);
                        EnviarEmailResultado.this.modeloClientes.setValueAt(ClienteConfiguracaoRendererEditor.this.dadosCliente, ClienteConfiguracaoRendererEditor.this.selectedRow, 0);
                        EnviarEmailResultado.this.buttonClientesEnviarSelecionado.setEnabled(true);
                        EnviarEmailResultado.this.buttonClientesEnviarTodos.setEnabled(true);
                    }
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)buttonConfiguracao, c);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.dadosCliente = (DadosCliente)value;
            this.selectedRow = row;
            return this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.dadosCliente = (DadosCliente)value;
            this.selectedRow = row;
            return this;
        }

        @Override
        public void addCellEditorListener(CellEditorListener arg0) {
        }

        @Override
        @Deprecated
        public void cancelCellEditing() {
        }

        @Override
        @Deprecated
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject arg0) {
            return true;
        }

        @Override
        @Deprecated
        public void removeCellEditorListener(CellEditorListener arg0) {
        }

        @Override
        public boolean shouldSelectCell(EventObject arg0) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }
    }

    private class ClienteRenderer
    extends JLabel
    implements TableCellRenderer {
        public ClienteRenderer() {
            this.setOpaque(true);
            this.setFont(this.getFont().deriveFont(0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DadosCliente dadosCliente = (DadosCliente)EnviarEmailResultado.this.modeloClientes.getValueAt(row, 0);
            if (dadosCliente == null) {
                return new JLabel();
            }
            int larguraMaxima = table.getColumnModel().getColumn(column).getWidth();
            StringBuilder buf = new StringBuilder();
            buf.append("<html><table><tr><td width=").append(larguraMaxima).append("><b>").append(dadosCliente.getCodigoCliente()).append(" - ").append(dadosCliente.getFantasiaCliente()).append("</td></tr>");
            if (EnviarEmailResultado.this.checkEnviarCertificadoAnalise.isSelected()) {
                if (!Funcoes.textoVazio(dadosCliente.getUFCliente())) {
                    String email = EnviarEmailResultado.this.buscaEmailCidadeCliente(dadosCliente.getCodigoCliente(), dadosCliente.getListaRequisicoesExames().get(0).getCodigoFilial());
                    if (Funcoes.textoVazio(email) || DBUtil.campoNull(email)) {
                        buf.append("<tr><td width=").append(larguraMaxima).append("<font color='red'><i> &nbsp - (E-mail SIPOA na cidade do cliente n\u00e3o informada)</i></font></td></tr>");
                    } else {
                        buf.append("<tr><td width=").append(larguraMaxima).append("><i> &nbsp;  - ").append(email).append("</i></td></tr>");
                        this.addEmail(table, dadosCliente, larguraMaxima, buf);
                    }
                } else {
                    buf.append("<tr><td width=").append(larguraMaxima).append("><font color='red'><i> &nbsp - (Cidade do cliente n\u00e3o informada)</i></font></td></tr>");
                }
            } else if (dadosCliente.getListaEmailsCliente().size() == 0) {
                buf.append("<tr><td width=").append(larguraMaxima).append("><font color='red'><i> &nbsp; - (Nenhum e-mail informado)</i></font></td></tr>");
            } else {
                this.addEmail(table, dadosCliente, larguraMaxima, buf);
            }
            if (Funcoes.textoVazio(dadosCliente.getSIFCliente()) && Tipos.isFilialAlimentos(Variaveis.tipoFilialPadrao)) {
                buf.append("<tr><td width=").append(larguraMaxima).append("><font color='red'><i> &nbsp; - (SIF do cliente n\u00e3o informado)</i></font></td></tr>");
            }
            this.setText(buf.toString() + "</table></html>");
            if (isSelected) {
                if (dadosCliente.getEnviado()) {
                    this.setBackground(ScreenUtil.clarearCor(Color.GREEN, 100));
                } else {
                    this.setBackground((Color)UIManager.get("Table.selectionBackground"));
                }
                this.setForeground((Color)UIManager.get("Table.selectionForeground"));
            } else {
                if (dadosCliente.getEnviado()) {
                    this.setBackground(ScreenUtil.clarearCor(Color.GREEN, 200));
                } else {
                    this.setBackground(table.getBackground());
                }
                this.setForeground(table.getForeground());
            }
            int height = this.getPreferredSize().height;
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, height);
            }
            return this;
        }

        private void addEmail(JTable table, DadosCliente dadosCliente, int larguraMaxima, StringBuilder buf) {
            for (int i = 0; i < dadosCliente.getListaEmailsCliente().size(); ++i) {
                String email = dadosCliente.getListaEmailsCliente().get(i);
                email = this.getTextoLargura(table, email, larguraMaxima);
                buf.append("<tr><td width=").append(larguraMaxima).append("><i> &nbsp; - ").append(email).append("</i></td></tr>");
            }
        }

        private String getTextoLargura(JTable table, String texto, int larguraMaxima) {
            if (Funcoes.textoVazio(texto)) {
                return "";
            }
            FontMetrics metrics = table.getFontMetrics(table.getFont());
            int largura = metrics.stringWidth(texto);
            String textoTemp = "";
            int tamaho = 1;
            if (largura > larguraMaxima) {
                while (metrics.stringWidth(textoTemp) < larguraMaxima - 50) {
                    textoTemp = texto.substring(0, tamaho);
                    ++tamaho;
                }
                return textoTemp + "...";
            }
            return texto;
        }
    }

    private class DadosRequisicoesExames
    implements Cloneable {
        private Integer codigoFilial = null;
        private Integer codigoRequisicao = null;
        private Integer codigoMaterial = null;
        private String codigoExame = null;
        private String abreviaturaMaterial = null;
        private String soaExame = null;
        private Date dataRequisicao = null;
        private String descricaoMaterial = null;
        private String emailFiscal = null;
        private boolean isSelecionado = false;
        private String suplemento = null;
        private String dataEnvioEmail = null;

        public DadosRequisicoesExames(Integer codigoFilial, Integer codigoRequisicao) {
            this.codigoFilial = codigoFilial;
            this.codigoRequisicao = codigoRequisicao;
        }

        public DadosRequisicoesExames(Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial, String abreviaturaMaterial, String descricaoMaterial, String soaExame, Date dataRequisicao, String emailFiscal, String supemento, String dataEnvioEmail) {
            this.codigoFilial = codigoFilial;
            this.codigoRequisicao = codigoRequisicao;
            this.codigoMaterial = codigoMaterial;
            this.codigoExame = codigoExame;
            this.abreviaturaMaterial = abreviaturaMaterial;
            this.soaExame = soaExame;
            this.dataRequisicao = dataRequisicao;
            this.descricaoMaterial = descricaoMaterial;
            this.emailFiscal = emailFiscal;
            this.suplemento = supemento;
            this.dataEnvioEmail = dataEnvioEmail;
        }

        public Date getDataRequisicao() {
            return this.dataRequisicao;
        }

        public String getDataEnvioEmail() {
            return this.dataEnvioEmail;
        }

        public Integer getCodigoFilial() {
            return this.codigoFilial;
        }

        public Integer getCodigoRequisicao() {
            return this.codigoRequisicao;
        }

        public Integer getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public String getCodigoExame() {
            return this.codigoExame;
        }

        public String getDescricaoMaterial() {
            return this.descricaoMaterial;
        }

        public String getAbreviaturaMaterial() {
            return this.abreviaturaMaterial;
        }

        public boolean isSelecionado() {
            return this.isSelecionado;
        }

        public String getSuplemento() {
            return this.suplemento;
        }

        public void setSelecionado(boolean isSelecionado) {
            this.isSelecionado = isSelecionado;
        }

        public String getCodigoSOAExame() {
            return this.soaExame;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DadosRequisicoesExames)) {
                return false;
            }
            DadosRequisicoesExames aux = (DadosRequisicoesExames)o;
            return aux.codigoFilial.equals(this.codigoFilial) && aux.codigoRequisicao.equals(this.codigoRequisicao);
        }

        public int hashCode() {
            return this.codigoFilial + this.codigoRequisicao;
        }

        public DadosRequisicoesExames getClone() {
            try {
                return (DadosRequisicoesExames)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public String getEmailFiscal() {
            return this.emailFiscal;
        }
    }

    private class DadosCliente {
        private Integer codigoCliente = null;
        private String fantasiaCliente = null;
        private String sifCliente = null;
        private String ufCliente = null;
        private ArrayList<String> listaEmailsCliente = null;
        private ArrayList<DadosRequisicoesExames> listaRequisicoesExames = null;
        private boolean isEnviado = false;

        private void setEnviado(boolean isEnviado) {
            this.isEnviado = isEnviado;
        }

        private boolean getEnviado() {
            return this.isEnviado;
        }

        public DadosCliente(Integer codigoCliente, String fantasiaCliente, String emailCliente, String sifCliente, String ufCliente) {
            this.codigoCliente = codigoCliente;
            this.fantasiaCliente = fantasiaCliente;
            this.sifCliente = sifCliente;
            this.ufCliente = ufCliente;
            this.listaEmailsCliente = new ArrayList();
            this.listaRequisicoesExames = new ArrayList();
            if (!Funcoes.textoVazio(emailCliente)) {
                this.listaEmailsCliente.add(emailCliente);
            }
        }

        public Integer getCodigoCliente() {
            return this.codigoCliente;
        }

        public String getFantasiaCliente() {
            return this.fantasiaCliente;
        }

        public String getUFCliente() {
            return this.ufCliente;
        }

        public void setListaEmailsCliente(ArrayList<String> listaEmailsCliente) {
            this.listaEmailsCliente = listaEmailsCliente;
        }

        public ArrayList<String> getListaEmailsClienteCopia() {
            return EnviarEmailResultado.this.listaEmailsClienteCopia;
        }

        public void addExame(Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial, String abreviaturaMaterial, String descricaoMaterial, String soaExame, Date dataRequisicao, String emailFiscal, String suplemento, String dataEnvioEmail) {
            this.listaRequisicoesExames.add(new DadosRequisicoesExames(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial, abreviaturaMaterial, descricaoMaterial, soaExame, dataRequisicao, emailFiscal, suplemento, dataEnvioEmail));
        }

        public ArrayList<String> getListaEmailsCliente() {
            return this.listaEmailsCliente;
        }

        public ArrayList<DadosRequisicoesExames> getListaRequisicoesExames() {
            return this.listaRequisicoesExames;
        }

        public String getSIFCliente() {
            return this.sifCliente;
        }
    }
}

