/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.resultados.DadosExameRequisicao;
import jalis.laboratorio.resultados.DadosLayoutIncerteza;
import jalis.laboratorio.resultados.DadosXMLIncerteza;
import jalis.laboratorio.resultados.TabbedPaneDigitacao;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.importador.imagem.AbstractImportadorImagem;
import jalis.laboratorio.util.importador.imagem.FabricaImportarImagem;
import jalis.model.bean.recepcao.ExameRequisicaoIncertezaBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.recepcao.ExameRequisicaoIncertezaService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class DigitacaoIncerteza
extends FrmCadPadrao
implements DigitacaoListener {
    private static final long ACESSO_REMOVER_INCERTEZA = Long.parseLong("0400300404");
    private static final int TEMPO_MOSTRAR_MENSAGEM_SUCESSO = 3500;
    private static final String TOOL_TIP_TEXT = "<html>Ctrl + H - Informa\u00e7\u00f5es do exame<br>Ctrl + I - Informa\u00e7\u00f5es da requisi\u00e7\u00e3o</html>";
    private TTextField textFilial = new TTextField(8, 1);
    private TTextField textRequisicao = new TTextField(12, 1);
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelDataRecebimento = new JLabel("Dt. Recebimento:");
    private JLabel labelProduto = new JLabel("Produto:");
    private JLabel labelArea = new JLabel("\u00c1rea:");
    private JLabel labelModalidade = new JLabel("Modalidade:");
    private JLabel labelLocalColeta = new JLabel("Local de Coleta:");
    private JLabel labelLacre = new JLabel("Lacre:");
    private JLabel labelDataFabricacao = new JLabel("Dt. Fabrica\u00e7\u00e3o:");
    private JLabel labelLoteProduto = new JLabel("Lote:");
    private JLabel labelSIF = new JLabel("S.I.F.:");
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelDataColeta = new JLabel("Dt. Coleta:");
    private JLabel labelVlrFilial = new JLabel();
    private JLabel labelVlrCliente = new JLabel();
    private JLabel labelVlrDataRecebimento = new JLabel();
    private JLabel labelVlrProduto = new JLabel();
    private JLabel labelVlrArea = new JLabel();
    private JLabel labelVlrCodigoModalidade = new JLabel();
    private JLabel labelVlrModalidade = new JLabel();
    private JLabel labelVlrSIF = new JLabel();
    private JLabel labelVlrLocalColeta = new JLabel();
    private JLabel labelVlrLacre = new JLabel();
    private JLabel labelVlrDataFabricacao = new JLabel();
    private JLabel labelVlrLoteProduto = new JLabel();
    private JLabel labelVlrMaterial = new JLabel();
    private JLabel labelVlrDataColeta = new JLabel();
    private JButton buttonBuscaFilial = new JButton("");
    private JButton buttonBuscaRequisicao = new JButton("");
    private TabbedPaneDigitacao tabbedPaneIncerteza = new TabbedPaneDigitacao(2);
    private boolean acessoNaoVisualizarNomeCliente = Acesso.getAcesso(Long.parseLong("0400300401"));
    private boolean acessoNaoVerMotivoRecoleta = Acesso.getAcesso(Long.parseLong("0400300402"));
    private boolean acessoImprimir = Acesso.getAcesso(Long.parseLong("0400300403"));
    private boolean acessoVisualizarHistorico = Acesso.getAcesso(Long.parseLong("0400300404"));
    private FilialVO filialVO = null;
    private Registro dadosRequisicao = null;
    private HashMap<String, DadosExameRequisicao> listaExames = null;
    private HashMap<String, HashMap<Integer, DadosLayoutIncerteza>> listaLayouts = null;
    private AbstractImportadorImagem importadorImagem = FabricaImportarImagem.getImportadorDeConfiguracao(ParametrosLocais.getParametro("importadorImagemDigitacao"));

    public DigitacaoIncerteza() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLabelFormulario("Incerteza");
        this.setLabelDescricao("Digita\u00e7\u00e3o das incertezas");
        this.setIcone(ImagemUtils.carregaImagemJalis("resultados/incerteza.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrFilial, this.labelVlrCliente, this.labelVlrDataRecebimento, this.labelVlrProduto, this.labelVlrArea, this.labelVlrCodigoModalidade, this.labelVlrModalidade, this.labelVlrSIF, this.labelVlrLocalColeta, this.labelVlrLacre, this.labelVlrDataFabricacao, this.labelVlrLoteProduto, this.labelVlrMaterial, this.labelVlrDataColeta}, new TitledBorder(""));
        Dimension dimensaoCodigos = new Dimension(105, 20);
        Dimension dimensaoLabels = new Dimension(20, 20);
        Dimension dimensaoBotoesBusca = new Dimension(20, 20);
        Dimension dimensaoDatas = new Dimension(120, 20);
        Insets insetNormal = new Insets(1, 1, 0, 0);
        Insets insetEspaco = new Insets(1, 20, 0, 0);
        Insets insetDireita = new Insets(1, 1, 0, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (!ParametrosGerais.getTipoIntegracao().equals("N")) {
            this.labelFilial.setLabelFor(this.textFilial);
            this.labelFilial.setDisplayedMnemonic('l');
            this.painelCentral.add((Component)this.labelFilial, c);
            ++c.gridx;
            this.textFilial.setPreferredSize(dimensaoCodigos);
            this.textFilial.setMinimumSize(dimensaoCodigos);
            this.painelCentral.add((Component)this.textFilial, c);
            ++c.gridx;
            this.buttonBuscaFilial.setPreferredSize(dimensaoBotoesBusca);
            this.buttonBuscaFilial.setMinimumSize(dimensaoBotoesBusca);
            this.buttonBuscaFilial.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonBuscaFilial);
            this.painelCentral.add((Component)this.buttonBuscaFilial, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.insets = insetDireita;
            this.labelVlrFilial.setPreferredSize(dimensaoLabels);
            this.labelVlrFilial.setMinimumSize(dimensaoLabels);
            this.painelCentral.add((Component)this.labelVlrFilial, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.labelRequisicao.setLabelFor(this.textRequisicao);
        this.labelRequisicao.setDisplayedMnemonic('R');
        this.painelCentral.add((Component)this.labelRequisicao, c);
        ++c.gridx;
        this.textRequisicao.setPreferredSize(dimensaoCodigos);
        this.textRequisicao.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.textRequisicao, c);
        ++c.gridx;
        this.buttonBuscaRequisicao.setPreferredSize(dimensaoBotoesBusca);
        this.buttonBuscaRequisicao.setMinimumSize(dimensaoBotoesBusca);
        this.buttonBuscaRequisicao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        this.painelCentral.add((Component)this.buttonBuscaRequisicao, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.insets = insetDireita;
        this.labelVlrCliente.setPreferredSize(dimensaoLabels);
        this.labelVlrCliente.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrCliente, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelProduto, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.labelVlrProduto.setPreferredSize(dimensaoLabels);
        this.labelVlrProduto.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrProduto, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelArea, c);
        ++c.gridx;
        c.insets = insetNormal;
        c.insets = insetDireita;
        this.labelVlrArea.setPreferredSize(dimensaoDatas);
        this.labelVlrArea.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrArea, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelModalidade, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelVlrCodigoModalidade.setPreferredSize(dimensaoCodigos);
        this.labelVlrCodigoModalidade.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.labelVlrCodigoModalidade, c);
        c.gridx += 2;
        this.labelVlrModalidade.setPreferredSize(dimensaoLabels);
        this.labelVlrModalidade.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrModalidade, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelDataRecebimento, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrDataRecebimento.setPreferredSize(dimensaoDatas);
        this.labelVlrDataRecebimento.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrDataRecebimento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelLocalColeta, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.labelVlrLocalColeta.setPreferredSize(dimensaoLabels);
        this.labelVlrLocalColeta.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrLocalColeta, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelSIF, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrSIF.setPreferredSize(dimensaoDatas);
        this.labelVlrSIF.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrSIF, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelLacre, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelVlrLacre.setPreferredSize(dimensaoCodigos);
        this.labelVlrLacre.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.labelVlrLacre, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelLoteProduto, c);
        ++c.gridx;
        c.insets = insetNormal;
        c.weightx = 1.0;
        this.labelVlrLoteProduto.setPreferredSize(dimensaoLabels);
        this.labelVlrLoteProduto.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrLoteProduto, c);
        ++c.gridx;
        c.insets = insetEspaco;
        c.weightx = 0.0;
        this.painelCentral.add((Component)this.labelDataFabricacao, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrDataFabricacao.setPreferredSize(dimensaoDatas);
        this.labelVlrDataFabricacao.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrDataFabricacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelMaterial, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.labelVlrMaterial.setPreferredSize(dimensaoCodigos);
        this.labelVlrMaterial.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.labelVlrMaterial, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelDataColeta, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrDataColeta.setPreferredSize(dimensaoDatas);
        this.labelVlrDataColeta.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrDataColeta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)this.tabbedPaneIncerteza, c);
        this.montaPainelBotoes();
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DigitacaoIncerteza.this.buscaDadosFilial(DigitacaoIncerteza.this.textFilial.getText());
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DigitacaoIncerteza.this.pesquisaFilial();
                }
            }
        });
        this.textRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (DigitacaoIncerteza.this.filialVO != null && Funcoes.processarFuncaoNumeroTubo(DigitacaoIncerteza.this.textFilial, DigitacaoIncerteza.this.textRequisicao)) {
                    DigitacaoIncerteza.this.buscaDadosRequisicao(DigitacaoIncerteza.this.filialVO.getCodigo().toString(), DigitacaoIncerteza.this.textRequisicao.getText());
                }
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DigitacaoIncerteza.this.pesquisaRequisicao();
                }
            }
        });
        this.buttonBuscaFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DigitacaoIncerteza.this.pesquisaFilial();
            }
        });
        this.buttonBuscaRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DigitacaoIncerteza.this.pesquisaRequisicao();
            }
        });
        this.novo();
    }

    private void pesquisaFilial() {
        this.filialVO = (FilialVO)new FilialService().pesquisaVO(Laboratorio.getInstancia(), new FilialVO(), "Buscando filiais", true);
        if (this.filialVO != null) {
            this.textFilial.setText(this.filialVO.getCodigo().toString());
            this.labelVlrFilial.setText(this.filialVO.getDescricao());
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private void pesquisaRequisicao() {
        this.labelVlrCliente.setText("");
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), this.filialVO.getCodigo().toString(), false, false, this.acessoNaoVisualizarNomeCliente);
        if (resultado != null) {
            this.textRequisicao.setText(resultado.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    private void buscaDadosFilial(String codigoFilial) {
        try {
            if (!Funcoes.textoVazio(codigoFilial)) {
                this.filialVO = (FilialVO)new FilialService().getVO(codigoFilial);
                if (this.filialVO != null) {
                    this.textFilial.setText(this.filialVO.getCodigo().toString());
                    this.labelVlrFilial.setText(this.filialVO.getDescricao());
                    ScreenUtil.requisitarFoco(this.textRequisicao);
                } else {
                    this.labelVlrFilial.setText("N\u00e3o cadastrado");
                }
            }
            this.controlaCampos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da filial.\n" + e.getMessage(), e.getStackTrace());
            this.filialVO = null;
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 2;
        this.textFilial.setEnabled(enabled && this.dadosRequisicao == null);
        this.buttonBuscaFilial.setEnabled(enabled && this.dadosRequisicao == null);
        this.textRequisicao.setEnabled(enabled && this.filialVO != null && this.dadosRequisicao == null);
        this.buttonBuscaRequisicao.setEnabled(enabled && this.filialVO != null && this.dadosRequisicao == null);
        this.botaoNovo.setEnabled(true);
        this.botaoFechar.setEnabled(true);
    }

    private void montaPainelBotoes() {
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new FlowLayout(2));
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.botaoFechar);
    }

    @Override
    public void novo() {
        this.setStatus(2);
        this.limpaCampos();
        this.buscaDadosFilial(Variaveis.filialPadrao);
        if (!ParametrosGerais.getTipoIntegracao().equals("N")) {
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textFilial);
        } else {
            this.buscaDadosFilial(Variaveis.filialPadrao);
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private void limpaCampos() {
        this.textFilial.clear();
        this.labelVlrFilial.setText("");
        this.textRequisicao.clear();
        this.labelVlrCliente.setText("");
        this.labelVlrProduto.setText("");
        this.labelVlrArea.setText("");
        this.labelVlrCodigoModalidade.setText("");
        this.labelVlrModalidade.setText("");
        this.labelVlrDataRecebimento.setText("");
        this.labelVlrLocalColeta.setText("");
        this.labelVlrSIF.setText("");
        this.labelVlrLacre.setText("");
        this.labelVlrLoteProduto.setText("");
        this.labelVlrDataFabricacao.setText("");
        this.labelVlrMaterial.setText("");
        this.labelVlrDataColeta.setText("");
        this.tabbedPaneIncerteza.removeAll();
        this.filialVO = null;
        this.dadosRequisicao = null;
        this.listaExames = null;
        this.listaLayouts = null;
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void cancelar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    private JPanel montaComponenteAba(Component c) {
        JPanel p = new JPanel(new BorderLayout());
        p.add(c, "Center");
        return p;
    }

    private String getTituloAba(DadosExameRequisicao exameRequisicao) {
        StringBuilder buf = new StringBuilder();
        if (exameRequisicao != null) {
            String descricaoMaterial = exameRequisicao.getDescricaoMaterial();
            descricaoMaterial = descricaoMaterial.length() > 14 ? descricaoMaterial.substring(0, 14) : descricaoMaterial;
            buf.append("<html><font size=2>").append(exameRequisicao.getCodigoExame()).append(" (<font color=#FF0000>").append(exameRequisicao.getAbreviaturaMaterial()).append("</font>)");
            buf.append("<br>");
            buf.append(descricaoMaterial);
            buf.append("</font></html>");
        }
        return buf.toString();
    }

    private Component getComponenteAba(DadosExameRequisicao dadosExameRequisicao, HashMap<Integer, DadosLayoutIncerteza> dadosLayout) throws SQLException {
        return this.getComponenteAba(dadosExameRequisicao, dadosLayout, -1, null);
    }

    private Component getComponenteAba(final DadosExameRequisicao dadosExameRequisicao, HashMap<Integer, DadosLayoutIncerteza> dadosLayout, int ordemAtualizar, JTabbedPane tab) throws SQLException {
        boolean haXML = dadosExameRequisicao.haXMLIncerteza();
        String situacao = dadosExameRequisicao.getSituacaoExameRequisicao();
        if (dadosLayout == null || dadosLayout.size() == 0) {
            return new JLabel("Exame sem layout de incerteza.", 0);
        }
        if (situacao.equalsIgnoreCase("F")) {
            return new JLabel("A situa\u00e7\u00e3o do material \u00e9 FALTA MATERIAL.", 0);
        }
        if (situacao.equalsIgnoreCase("T")) {
            return new JLabel("A situa\u00e7\u00e3o do material \u00e9 A COLETAR.", 0);
        }
        if (situacao.equalsIgnoreCase("R")) {
            StringBuilder buf = new StringBuilder();
            buf.append("<html>O material deve ser RECOLETADO.");
            if (!Funcoes.textoVazio(dadosExameRequisicao.getMotivoRecoleta()) && !this.acessoNaoVerMotivoRecoleta) {
                buf.append("<br>").append("<font size=2>Motivo: ").append(dadosExameRequisicao.getMotivoRecoleta()).append(".</font>");
            }
            buf.append("</html>");
            return new JLabel(buf.toString(), 0);
        }
        if (situacao.equalsIgnoreCase("O")) {
            return new JLabel("O resultado do exame est\u00e1 EM REPETI\u00c7\u00c3O.", 0);
        }
        if (situacao.equalsIgnoreCase("A")) {
            if (dadosExameRequisicao.getDataDigitacao() != null) {
                return new JLabel("Exame marcado como APENAS FATURAMENTO: " + Funcoes.formataData("dd/MM/yyyy HH:mm", dadosExameRequisicao.getDataDigitacao()) + ".", 0);
            }
            return new JLabel("Exame marcado como APENAS FATURAMENTO.", 0);
        }
        if (situacao.equalsIgnoreCase("L") || situacao.equalsIgnoreCase("C") || situacao.equalsIgnoreCase("I") || situacao.equalsIgnoreCase("E")) {
            HashMap<Integer, DadosXMLIncerteza> xmls = dadosExameRequisicao.getMapaXmlIncerteza();
            JTabbedPane tabLayouts = new JTabbedPane(1);
            for (Integer ordem : xmls.keySet()) {
                DadosXMLIncerteza dadosXML = xmls.get(ordem);
                Digitacao digitacao = new Digitacao();
                digitacao.carregarCampos(dadosXML.getXML());
                digitacao.exibirBotaoRemover(Acesso.getAcesso(ACESSO_REMOVER_INCERTEZA));
                digitacao.exibirBotaoSalvar(false);
                digitacao.exibirBotaoSalvarParcial(false);
                digitacao.exibirBotaoImprimir(this.acessoImprimir);
                digitacao.exibirCheckBoxImprimir(false);
                digitacao.addDigitacaoListener(this);
                digitacao.setCodigoExame(dadosExameRequisicao.getCodigoExame());
                digitacao.setCodigoMaterialColeta(dadosExameRequisicao.getCodigoMaterial());
                digitacao.setOrdem(ordem);
                digitacao.setEditando(false);
                JScrollPane aux = new JScrollPane(digitacao);
                aux.setBorder(null);
                tabLayouts.insertTab(dadosXML.getDescricao(), null, aux, null, ordem - 1);
            }
            return tabLayouts;
        }
        JTabbedPane tabLayouts = new JTabbedPane(1);
        HashMap<Integer, DadosXMLIncerteza> xmls = dadosExameRequisicao.getMapaXmlIncerteza();
        for (Integer chave : dadosLayout.keySet()) {
            if (ordemAtualizar > -1 && ordemAtualizar != chave) continue;
            DadosLayoutIncerteza layout = dadosLayout.get(chave);
            DadosXMLIncerteza dadosXML = xmls.get(layout.getOrdem());
            Digitacao digitacao = new Digitacao();
            if (dadosXML == null || Funcoes.textoVazio(dadosXML.getXML())) {
                digitacao.setVerificarCompleto(true);
                digitacao.exibirBotaoSalvarParcial(false);
                digitacao.exibirBotaoImprimir(this.acessoImprimir);
                digitacao.exibirCheckBoxImprimir(false);
                digitacao.addDigitacaoListener(this);
                digitacao.setCodigoExame(dadosExameRequisicao.getCodigoExame());
                digitacao.setCodigoMaterialColeta(dadosExameRequisicao.getCodigoMaterial());
                digitacao.setOrdem(layout.getOrdem());
                digitacao.setEditando(true);
                DadosXMLIncerteza modeloAtual = dadosExameRequisicao.getXMLIncertezaOrdem(layout.getOrdem());
                String formato = modeloAtual == null || Funcoes.textoVazio(modeloAtual.getXML()) ? layout.getXML() : modeloAtual.getXML();
                Map<String, Object> mapaIncerteza = DigitacaoIncerteza.getCamposIncerteza(formato);
                digitacao.carregarCampos(formato, mapaIncerteza, null, null, null, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1);
                digitacao.adicionaListenerTabelaSimbolos(new TabelaSimbolosListener(){

                    @Override
                    public Object simboloNaoLocalizado(String simbolo) {
                        Map valores = DigitacaoIncerteza.this.getCamposJaDigitados(dadosExameRequisicao, simbolo);
                        return valores != null && valores.containsKey(simbolo.toUpperCase()) ? valores.get(simbolo.toUpperCase()) : null;
                    }
                });
            } else {
                digitacao.carregarCampos(dadosXML.getXML());
                digitacao.exibirBotaoRemover(Acesso.getAcesso(ACESSO_REMOVER_INCERTEZA));
                digitacao.exibirBotaoSalvar(false);
                digitacao.exibirBotaoImprimir(this.acessoImprimir);
                digitacao.exibirCheckBoxImprimir(false);
                digitacao.exibirBotaoSalvarParcial(false);
                digitacao.addDigitacaoListener(this);
                digitacao.setCodigoExame(dadosExameRequisicao.getCodigoExame());
                digitacao.setCodigoMaterialColeta(dadosExameRequisicao.getCodigoMaterial());
                digitacao.setOrdem(layout.getOrdem());
                digitacao.setEditando(false);
            }
            if (ordemAtualizar > -1 && tab != null) {
                tab.setComponentAt(layout.getOrdem() - 1, digitacao);
                continue;
            }
            tabLayouts.insertTab(layout.getDescricao(), null, digitacao, null, layout.getOrdem() - 1);
        }
        if (ordemAtualizar > -1 && tab != null) {
            return tab;
        }
        return tabLayouts;
    }

    public static Map<String, Object> getCamposIncerteza(String xmlIncerteza) {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        Resultado res = new Resultado(xmlIncerteza);
        for (Component comp : res.getComponentes()) {
            if (!(comp instanceof ComponenteValor)) continue;
            ComponenteValor compVlr = (ComponenteValor)((Object)comp);
            campos.put(compVlr.getNome().toLowerCase(), compVlr instanceof TextoEstatico ? ((TextoEstatico)compVlr).getText() : (compVlr.getValor() != null ? compVlr.getValor() : ""));
        }
        return campos;
    }

    private Map<String, Object> getCamposJaDigitados(DadosExameRequisicao exameRequisicao, String simbolo) {
        if (this.tabbedPaneIncerteza.getTabCount() == 1) {
            return null;
        }
        String exameAPesquisar = simbolo.indexOf("_") > 0 ? simbolo.substring(0, simbolo.indexOf("_")) : "";
        HashMap<String, Object> campos = new HashMap<String, Object>();
        for (int i = 0; i < this.tabbedPaneIncerteza.getTabCount(); ++i) {
            Digitacao tmp;
            String situacao = exameRequisicao.getSituacaoExameRequisicao();
            String exame = exameRequisicao.getCodigoExame();
            if (!Funcoes.textoVazio(exameAPesquisar) && !exame.toLowerCase().startsWith(exameAPesquisar.toLowerCase())) continue;
            String titulo = this.tabbedPaneIncerteza.getTitleAt(i);
            if (!situacao.equals("L") && !situacao.equals("C") && !situacao.equals("I") && !situacao.equals("E") || (tmp = this.localizaComponenteDigitacao((JPanel)this.tabbedPaneIncerteza.getComponentAt(i))) == null) continue;
            Digitacao dig = tmp;
            Map<String, Object> map = Resultado.getCamposResultado(dig.getResultado());
            for (String key : map.keySet()) {
                campos.put((exame + "_" + key).toUpperCase(), map.get(key));
            }
        }
        return campos.size() == 0 ? null : campos;
    }

    private Digitacao localizaComponenteDigitacao(Component c) {
        JComponent tmp;
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            if (((JLabel)c).getText().toLowerCase().startsWith("carregando")) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (c instanceof Digitacao) {
            return (Digitacao)c;
        }
        if (c instanceof JPanel) {
            tmp = (JPanel)c;
            int n = 0;
            Component[] componentArray = ((JPanel)c).getComponents();
            int n2 = componentArray.length;
            if (n < n2) {
                Component comp = componentArray[n];
                if (comp instanceof Digitacao) {
                    return (Digitacao)comp;
                }
                return this.localizaComponenteDigitacao(comp);
            }
        } else if (c instanceof JScrollPane) {
            tmp = (JScrollPane)c;
            int n = 0;
            Component[] componentArray = ((JScrollPane)c).getViewport().getComponents();
            int n3 = componentArray.length;
            if (n < n3) {
                Component comp = componentArray[n];
                if (comp instanceof Digitacao) {
                    return (Digitacao)comp;
                }
                return this.localizaComponenteDigitacao(comp);
            }
        }
        return null;
    }

    private HashMap<Integer, DadosLayoutIncerteza> buscaDadosLayoutIncerteza(DadosExameRequisicao dadosExameRequisicao) {
        Registro reg = null;
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                String codigoLayoutAux = ExameUtil.getCodigoLayout(this.dadosRequisicao.getString("codigofilial"), this.dadosRequisicao.getString("codigoconvenio"), this.dadosRequisicao.getString("codigodestino"));
                int codigoLayout = codigoLayoutAux.matches("\\-?\\d+") ? Integer.parseInt(codigoLayoutAux) : -1;
                StringBuilder buf = new StringBuilder();
                buf.append(" select elm.lay_codigo as codigoLayout ");
                buf.append("       ,elm.ela_idadeini as idadeInicial ");
                buf.append("       ,elm.ela_idadefim as idadeFinal ");
                buf.append("       ,elm.ela_idadeinitipo as tipoIdadeInicial ");
                buf.append("       ,elm.ela_idadefimtipo as tipoIdadeFinal ");
                buf.append("       ,elm.ela_padrao as padrao ");
                buf.append("       ,emc.met_codigo as codigoMetodologia ");
                buf.append("   from examematcoleta emc ");
                buf.append("   left join examelayout elm on emc.fil_codigo = elm.fil_codigo and emc.exa_codigo = elm.exa_codigo and emc.mco_codigo = elm.mco_codigo ");
                buf.append("  where emc.fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
                buf.append("    and emc.exa_codigo = '").append(dadosExameRequisicao.getCodigoExame()).append("' ");
                buf.append("    and emc.mco_codigo = ").append(dadosExameRequisicao.getCodigoMaterial());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("padrao");
                    int idadeInicial = rs.getInt("idadeInicial");
                    int idadeFinal = rs.getInt("idadeFinal");
                    String tipoIdadeInicial = rs.getString("tipoIdadeInicial");
                    String tipoIdadeFinal = rs.getString("tipoIdadeFinal");
                    boolean intervaloValido = codigoLayout == rs.getInt("codigoLayout") && this.intervaloValido(idadeInicial, idadeFinal, tipoIdadeInicial, tipoIdadeFinal, this.dadosRequisicao.getString("anomespaciente"), this.dadosRequisicao.getInt("idadepaciente"));
                    boolean bl = idadeZero = codigoLayout == rs.getInt("codigoLayout") && idadeInicial == 0 && idadeFinal == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !intervaloValido) continue;
                    linha = rs.getRow();
                    if (!intervaloValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    reg = new Registro(rs);
                    buf.setLength(0);
                    buf.append(" select eli.eli_xml as xmlIncerteza ");
                    buf.append("       ,eli.eli_descricao as descricaoIncerteza ");
                    buf.append("       ,eli.eli_ordem as ordemIncerteza ");
                    buf.append("       ,met.met_codigo as codigoMetodologia ");
                    buf.append("       ,met.met_descricao as descricaoMetodologia ");
                    buf.append("       ,lay.lay_incerteza as cabecalhoLayout ");
                    buf.append("   from examelayoutmetodoincerteza eli ");
                    buf.append("   left join metodologia met on eli.fil_codigo = met.fil_codigo and eli.met_codigo = met.met_codigo ");
                    buf.append("   left join layout lay on eli.fil_codigo = lay.fil_codigo and eli.lay_codigo = lay.lay_codigo ");
                    buf.append("  where eli.fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
                    buf.append("    and eli.exa_codigo = '").append(dadosExameRequisicao.getCodigoExame()).append("' ");
                    buf.append("    and eli.mco_codigo = ").append(dadosExameRequisicao.getCodigoMaterial());
                    buf.append("    and eli.lay_codigo = ").append(rs.getString("codigoLayout"));
                    buf.append("    and eli.ela_idadeini = ").append(rs.getString("idadeInicial"));
                    buf.append("    and eli.ela_idadefim = ").append(rs.getString("idadeFinal"));
                    buf.append("    and eli.ela_idadeinitipo = '").append(rs.getString("tipoIdadeInicial")).append("' ");
                    buf.append("    and eli.ela_idadefimtipo = '").append(rs.getString("tipoIdadeFinal")).append("' ");
                    rs = Conexao.executeQuery(st, buf.toString());
                    HashMap<Integer, DadosLayoutIncerteza> layoutIncertezas = new HashMap<Integer, DadosLayoutIncerteza>();
                    while (rs.next()) {
                        if (rs.getInt("codigoMetodologia") != dadosExameRequisicao.getCodigoMetodologia().intValue()) continue;
                        layoutIncertezas.put(rs.getInt("ordemIncerteza"), new DadosLayoutIncerteza(rs.getInt("ordemIncerteza"), rs.getString("descricaoIncerteza"), rs.getString("xmlIncerteza"), rs.getString("cabecalhoLayout"), rs.getInt("codigoMetodologia")));
                    }
                    return layoutIncertezas;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "" + e.getMessage(), e.getStackTrace());
            }
        }
        return null;
    }

    private boolean intervaloValido(int idadeInicial, int idadeFinal, String tipoIni, String tipoFin, String anoMesIdade, int idadePaciente) {
        if (anoMesIdade != null) {
            int idPac = anoMesIdade.equalsIgnoreCase("A") ? idadePaciente * 365 : (anoMesIdade.equalsIgnoreCase("M") ? idadePaciente * 31 : idadePaciente);
            int idIni = tipoIni.equalsIgnoreCase("A") ? idadeInicial * 365 : (tipoIni.equalsIgnoreCase("M") ? idadeInicial * 31 : idadeInicial);
            int idFin = tipoFin.equalsIgnoreCase("A") ? idadeFinal * 365 : (tipoFin.equalsIgnoreCase("M") ? idadeFinal * 31 : idadeFinal);
            return idIni <= idPac && idPac <= idFin;
        }
        return false;
    }

    @Override
    @Deprecated
    public void acaoSalvarParcial(DigitacaoEvento e) {
    }

    private void setFocoPrimeiroCampo(JComponent comp) {
        if (comp != null && comp instanceof JPanel && (comp = (JComponent)comp.getComponent(0)) != null && comp instanceof JTabbedPane && (comp = (JComponent)((JTabbedPane)comp).getSelectedComponent()) != null && comp instanceof Digitacao) {
            ((Digitacao)comp).setFocoPrimeiroCampo();
        }
    }

    private void editarRequisicaoExportaFiliais(Registro exame) {
        try {
            ExportaFiliais.gravaRequisicao(this.dadosRequisicao.getInt("codigofilial"), this.dadosRequisicao.getInt("codigorequisicao"), exame.getString("codigoexame"), exame.getInt("codigomaterial"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel exportar filiais.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void revalidarAba(int indice, int ordem) throws SQLException {
        if (this.listaExames.size() > indice) {
            JPanel comp;
            JComponent compPanelAux;
            DadosExameRequisicao dadosExame = this.tabbedPaneIncerteza.getDadosExame(indice);
            HashMap<Integer, DadosLayoutIncerteza> dadosLayout = this.listaLayouts.get(dadosExame.getCodigoExame() + dadosExame.getCodigoMaterial());
            JTabbedPane tabAtual = null;
            JComponent compAux = (JComponent)this.tabbedPaneIncerteza.getComponentAt(indice);
            if (compAux != null && compAux instanceof JPanel && (compPanelAux = (JComponent)(comp = (JPanel)compAux).getComponent(0)) != null && compPanelAux instanceof JTabbedPane) {
                tabAtual = (JTabbedPane)compPanelAux;
            }
            this.getComponenteAba(dadosExame, dadosLayout, ordem, tabAtual);
            this.tabbedPaneIncerteza.setSelectedIndex(indice);
            this.tabbedPaneIncerteza.revalidate();
            this.tabbedPaneIncerteza.repaint();
        }
    }

    private Digitacao getComponenteDigitacao() {
        Component comp = this.getComponenteAba();
        if (comp instanceof Digitacao) {
            return (Digitacao)comp;
        }
        return null;
    }

    private Component getComponenteAba() {
        try {
            JPanel panel = (JPanel)this.tabbedPaneIncerteza.getSelectedComponent();
            Component aux = panel.getComponent(0);
            if (aux instanceof JScrollPane) {
                aux = ((JScrollPane)aux).getViewport().getComponent(0);
            }
            return aux;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void acaoSalvar(DigitacaoEvento e) {
        this.salvarIncerteza((Digitacao)e.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvarIncerteza(Digitacao componente) {
        DadosExameRequisicao exameRequisicao = this.listaExames.get(componente.getCodigoExame() + componente.getCodigoMaterialColeta());
        HashMap<Integer, DadosLayoutIncerteza> listaLayoutIncerteza = this.listaLayouts.get(componente.getCodigoExame() + componente.getCodigoMaterialColeta());
        Statement st = Conexao.getStatement();
        if (st != null && exameRequisicao != null && listaLayoutIncerteza != null) {
            block15: {
                try {
                    String incerteza = StringUtil.textoDB(componente.getResultado());
                    DadosLayoutIncerteza layoutIncerteza = listaLayoutIncerteza.get(componente.getOrdem());
                    this.gravarExameRequisicaoIncerteza(exameRequisicao, incerteza, layoutIncerteza);
                    exameRequisicao.addIncerteza(componente.getOrdem(), layoutIncerteza.getDescricao(), incerteza);
                    Conexao.arquivaSQL();
                    try {
                        this.revalidarAba(this.tabbedPaneIncerteza.getSelectedIndex(), componente.getOrdem());
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel revalidar aba.\n" + e.getMessage(), e.getStackTrace());
                    }
                    JComponent aux = (JComponent)this.tabbedPaneIncerteza.getComponentAt(this.tabbedPaneIncerteza.getSelectedIndex());
                    aux = (JComponent)((JPanel)aux).getComponent(0);
                    if (aux != null && aux instanceof JTabbedPane) {
                        JTabbedPane tabbedPane = (JTabbedPane)aux;
                        if (componente.getOrdem() - 1 < tabbedPane.getTabCount() - 1) {
                            tabbedPane.setSelectedIndex(componente.getOrdem());
                            this.setFocoPrimeiroCampo((JComponent)tabbedPane.getComponentAt(componente.getOrdem()));
                        } else if (this.tabbedPaneIncerteza.getSelectedIndex() < this.tabbedPaneIncerteza.getTabCount() - 1) {
                            this.tabbedPaneIncerteza.setSelectedIndex(this.tabbedPaneIncerteza.getSelectedIndex() + 1);
                            this.setFocoPrimeiroCampo((JComponent)this.tabbedPaneIncerteza.getComponentAt(this.tabbedPaneIncerteza.getSelectedIndex()));
                        } else {
                            ScreenUtil.requisitarFoco(this.botaoFechar);
                        }
                        break block15;
                    }
                    if (this.tabbedPaneIncerteza.getSelectedIndex() < this.tabbedPaneIncerteza.getTabCount() - 1) {
                        this.tabbedPaneIncerteza.setSelectedIndex(this.tabbedPaneIncerteza.getSelectedIndex() + 1);
                        this.setFocoPrimeiroCampo((JComponent)this.tabbedPaneIncerteza.getComponentAt(this.tabbedPaneIncerteza.getSelectedIndex()));
                        break block15;
                    }
                    ScreenUtil.requisitarFoco(this.botaoFechar);
                }
                catch (Exception ex) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar a incerteza.\n" + ex.getMessage(), ex.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removerIncerteza(Digitacao componente) {
        DadosExameRequisicao exameRequisicao = this.listaExames.get(componente.getCodigoExame() + componente.getCodigoMaterialColeta());
        HashMap<Integer, DadosLayoutIncerteza> listaLayoutIncerteza = this.listaLayouts.get(componente.getCodigoExame() + componente.getCodigoMaterialColeta());
        if (exameRequisicao != null && !this.podeRemoverIncertezaExame(this.dadosRequisicao.getInt("codigofilial"), this.dadosRequisicao.getString("codigorequisicao"), exameRequisicao.getCodigoExame(), exameRequisicao.getCodigoMaterial())) {
            return;
        }
        DadosLayoutIncerteza layoutIncerteza = listaLayoutIncerteza.get(componente.getOrdem());
        Statement st = Conexao.getStatement();
        if (st != null && exameRequisicao != null) {
            try {
                this.gravarExameRequisicaoIncerteza(exameRequisicao, null, layoutIncerteza);
                exameRequisicao.addIncerteza(layoutIncerteza.getOrdem(), layoutIncerteza.getDescricao(), null);
                Conexao.arquivaSQL();
                try {
                    this.revalidarAba(this.tabbedPaneIncerteza.getSelectedIndex(), componente.getOrdem());
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel revalidar aba.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover a incerteza.\n" + ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private boolean podeRemoverIncertezaExame(int codigoFilial, String codigoRequisicao, String codigoExame, int codigoMaterial) {
        try {
            String situacao = this.getSituacaoExameRequisicao(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
            if (Funcoes.textoVazio(situacao)) {
                return true;
            }
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover a incerteza, pois a situa\u00e7\u00e3o do exame \u00e9 \"" + Tipos.tipoSituacaoExame(situacao) + "\".", 2);
            return false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a situa\u00e7\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    public String getSituacaoExameRequisicao(int codigoFilial, String codigoRequisicao, String codigoExame, int codigoMaterial) throws Exception {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" select exr_situacao as situacao ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and mco_codigo = ").append(codigoMaterial);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("situacao");
        }
        throw new Exception("N\u00e3o foi poss\u00edvel localizar o exame \"" + codigoExame + "\" material = \"" + codigoMaterial + "\" na requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" da filial \"" + codigoFilial + "\".");
    }

    private void gravarExameRequisicaoIncerteza(DadosExameRequisicao exameRequisicao, String incerteza, DadosLayoutIncerteza layout) throws Exception {
        ExameRequisicaoIncertezaService service = new ExameRequisicaoIncertezaService();
        ExameRequisicaoIncertezaBean exameRequisicaoIncertezaBean = new ExameRequisicaoIncertezaBean();
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(this.dadosRequisicao.getString("codigofilial")));
        exameRequisicaoIncertezaBean.setFilial(filialVO);
        ExameVO exameVO = new ExameVO();
        exameVO.setCodigo(exameRequisicao.getCodigoExame());
        exameRequisicaoIncertezaBean.setExame(exameVO);
        MaterialColetaVO materialColetaVO = new MaterialColetaVO();
        materialColetaVO.setCodigo(exameRequisicao.getCodigoMaterial());
        exameRequisicaoIncertezaBean.setMaterialColeta(materialColetaVO);
        RequisicaoVO requisicao = new RequisicaoVO();
        requisicao.setCodigo(Integer.parseInt(this.dadosRequisicao.getString("codigorequisicao")));
        exameRequisicaoIncertezaBean.setRequisicao(requisicao);
        exameRequisicaoIncertezaBean.setContador(layout.getOrdem());
        exameRequisicaoIncertezaBean.setDescricao(layout.getDescricao());
        exameRequisicaoIncertezaBean.setXml(incerteza);
        exameRequisicaoIncertezaBean.setDataHora(new Date());
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setCodigo(Variaveis.login);
        exameRequisicaoIncertezaBean.setUsuario(usuarioVO);
        service.insert(exameRequisicaoIncertezaBean, Variaveis.filialPadrao);
    }

    private String selecionaImpressora() {
        int tipoSeq = ParametrosGerais.getSequenciaImpressora();
        ArrayList<String> seq = new ArrayList<String>();
        seq.add(jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraIncerteza")));
        String[] seqImp = seq.toArray(new String[seq.size()]);
        if (seqImp != null) {
            for (int i = 0; i < seqImp.length; ++i) {
                if (seqImp == null || seqImp[i] == null || seqImp[i].length() <= 0) continue;
                return seqImp[i];
            }
        }
        return "";
    }

    @Override
    @Deprecated
    public void acaoFechar(DigitacaoEvento e) {
    }

    @Override
    public void acaoImprimir(DigitacaoEvento e) {
        if (e != null) {
            Digitacao componente = (Digitacao)e.getSource();
            if (componente.isEditando()) {
                int resposta = Funcoes.mensagem(this, "Deseja salvar as altera\u00e7\u00f5es ?", 4);
                if (resposta == 1) {
                    return;
                }
                this.salvarIncerteza(componente);
            }
            DadosExameRequisicao exameRequisicao = this.listaExames.get(componente.getCodigoExame() + componente.getCodigoMaterialColeta());
            Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(this.dadosRequisicao.getString("codigorequisicao"), exameRequisicao.getCodigoExame(), exameRequisicao.getCodigoMaterial().toString(), this.dadosRequisicao.getString("codigofilial"), this.acessoNaoVisualizarNomeCliente, true);
            HashMap<Integer, DadosLayoutIncerteza> layouts = this.listaLayouts.get(componente.getCodigoExame() + componente.getCodigoMaterialColeta());
            DadosLayoutIncerteza layout = layouts.get(componente.getOrdem());
            String incerteza = componente.getResultado();
            if (Funcoes.textoVazio(layout.getCabecalhoRodape())) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 layout de impress\u00e3o definido para o modelo \"" + layout.getDescricao() + "\".", 2);
                return;
            }
            TabelaSimbolos tabelaSimbolo = new TabelaSimbolos();
            tabelaSimbolo.setDados(dados);
            Documento doc = new Documento();
            doc.setDadosBanco(dados);
            doc.setCabecalhoRodape(layout.getCabecalhoRodape() == null ? "" : layout.getCabecalhoRodape());
            doc.setCopias(1);
            doc.addResultados(new ExameMaterialPagina[]{new ExameMaterialPagina(exameRequisicao.getCodigoExame(), exameRequisicao.getCodigoMaterial(), tabelaSimbolo)}, new String[]{incerteza});
            Impressao imp = new Impressao(this.selecionaImpressora());
            imp.imprimir(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosRequisicao(String codigoFilial, String codigoRequisicao) {
        Statement st;
        block6: {
            this.labelVlrCliente.setText("");
            if (Funcoes.textoVazio(codigoFilial) || Funcoes.textoVazio(codigoRequisicao)) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select des.des_codigo as codigoDestino ");
            buf.append("       ,des.des_descricao as descricaoDestino ");
            buf.append("       ,pac.pac_nome as nomeCliente ");
            buf.append("       ,req.req_descricaoproduto as descricaoProduto ");
            buf.append("       ,req.req_areaproduto as areaProduto ");
            buf.append("       ,req.req_datarecebimentoproduto as dataRecebimentoProduto ");
            buf.append("       ,pac.pac_sif as sif ");
            buf.append("       ,req.req_lacreproduto as lacreProduto ");
            buf.append("       ,req.req_localcoletaproduto as localColetaProduto ");
            buf.append("       ,req.req_numeroloteproduto loteProduto ");
            buf.append("       ,req.req_datafabricacao as dataFabricacaoProduto ");
            buf.append("       ,req.req_datacoletaproduto as dataColetaProduto ");
            buf.append("       ,req.fil_codigo as codigoFilial ");
            buf.append("       ,req.req_codigo as codigoRequisicao ");
            buf.append("       ,req.con_codigo as codigoConvenio ");
            buf.append("   from requisicao req ");
            buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("   left join destino des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
            buf.append("  where req.fil_codigo = ").append(codigoFilial);
            buf.append("    and req.req_codigo = ").append(codigoRequisicao);
            buf.append("    and not req.req_excluida ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.dadosRequisicao = new Registro(rs);
                    this.preencheDadosRequisicao(this.dadosRequisicao);
                    this.buscaDadosExames();
                    this.controlaCampos();
                    break block6;
                }
                this.labelVlrCliente.setText("Requisi\u00e7\u00e3o n\u00e3o encontrada");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "Erro o buscar os dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                    this.dadosRequisicao = null;
                    this.controlaCampos();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return;
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosExames() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr.exr_datamaterial as dataColetaMaterial ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_descricaomaterial), ''), mco.mco_descricao) as descricaoMaterial ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,mco.mco_codigo as codigoMaterial ");
        buf.append("       ,mco.mco_abreviatura as abreviaturaMaterial ");
        buf.append("       ,exr.exr_situacao as situacaoExameRequisicao ");
        buf.append("       ,exr.exr_motivorecoleta as motivoRecoletaExameRequisicao ");
        buf.append("       ,exr.exr_datadigita as dataDigitacaoExameRequisicao ");
        buf.append("       ,exi.exi_contador as ordemIncertezaExameRequisicao ");
        buf.append("       ,exi.exi_descricao as descricaoIncertezaExameRequisicao ");
        buf.append("       ,exi.exi_xml as xmlIncertezaExameRequisicao ");
        buf.append("       ,COALESCE(exr.met_codigo, emc.met_codigo) as codigoMetodologia ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("   join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("   left join examerequisicaoincerteza exi on exr.fil_codigo = exi.fil_codigo and exr.req_codigo = exi.req_codigo and exr.exa_codigo = exi.exa_codigo and exr.mco_codigo = exi.mco_codigo ");
        buf.append("  where exr.fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
        buf.append("    and exr.req_codigo = ").append(this.dadosRequisicao.getString("codigorequisicao"));
        buf.append("    and not exr.exr_excluido ");
        buf.append("  order by exr.exa_codigo ");
        buf.append("          ,exr.mco_codigo ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            this.listaExames = new HashMap();
            while (rs.next()) {
                DadosExameRequisicao aux = this.listaExames.get(rs.getString("codigoExame") + rs.getString("codigoMaterial"));
                if (aux == null) {
                    aux = new DadosExameRequisicao(rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getDate("dataColetaMaterial"), rs.getString("descricaoMaterial"), rs.getString("abreviaturaMaterial"), rs.getString("situacaoExameRequisicao"), rs.getString("motivoRecoletaExameRequisicao"), rs.getDate("dataDigitacaoExameRequisicao"), rs.getInt("codigoMetodologia"));
                    this.listaExames.put(rs.getString("codigoExame") + rs.getInt("codigoMaterial"), aux);
                }
                aux.addIncerteza(rs.getInt("ordemIncertezaExameRequisicao"), rs.getString("descricaoIncertezaExameRequisicao"), rs.getString("xmlIncertezaExameRequisicao"));
            }
            this.preencheDadosExamesRequisicao(this.listaExames);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados dos exames da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
    }

    private void preencheDadosExamesRequisicao(HashMap<String, DadosExameRequisicao> mapaExames) throws Exception {
        Iterator<String> iterator = mapaExames.keySet().iterator();
        while (iterator.hasNext()) {
            String chave = iterator.next();
            DadosExameRequisicao exameRequisicao = mapaExames.get(chave);
            HashMap<Integer, DadosLayoutIncerteza> listaDadosLayout = this.buscaDadosLayoutIncerteza(exameRequisicao);
            this.labelVlrMaterial.setText(exameRequisicao.getDescricaoMaterial());
            this.listaExames = new HashMap();
            this.listaLayouts = new HashMap();
            int contador = 0;
            this.listaExames.put(exameRequisicao.getCodigoExame() + exameRequisicao.getCodigoMaterial(), exameRequisicao);
            this.listaLayouts.put(exameRequisicao.getCodigoExame() + exameRequisicao.getCodigoMaterial(), listaDadosLayout);
            this.tabbedPaneIncerteza.insertTab(this.getTituloAba(exameRequisicao), this.montaComponenteAba(this.getComponenteAba(exameRequisicao, listaDadosLayout)), contador, exameRequisicao);
            this.tabbedPaneIncerteza.setToolTipTextAt(contador++, TOOL_TIP_TEXT);
            while (iterator.hasNext()) {
                chave = iterator.next();
                exameRequisicao = mapaExames.get(chave);
                this.listaExames.put(exameRequisicao.getCodigoExame() + exameRequisicao.getCodigoMaterial(), exameRequisicao);
                listaDadosLayout = this.buscaDadosLayoutIncerteza(exameRequisicao);
                this.listaLayouts.put(exameRequisicao.getCodigoExame() + exameRequisicao.getCodigoMaterial(), listaDadosLayout);
                JLabel label = ComponenteFactory.novoJLabel("Carregando exame", null, 0);
                this.tabbedPaneIncerteza.insertTab(this.getTituloAba(exameRequisicao), this.montaComponenteAba(label), contador, exameRequisicao);
                this.tabbedPaneIncerteza.setToolTipTextAt(contador++, TOOL_TIP_TEXT);
            }
        }
        new Thread("CarregaExame"){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < DigitacaoIncerteza.this.tabbedPaneIncerteza.getTabCount(); ++i) {
                        if (i == 0) continue;
                        DadosExameRequisicao exameRequisicao = DigitacaoIncerteza.this.tabbedPaneIncerteza.getDadosExame(i);
                        JPanel panel = (JPanel)DigitacaoIncerteza.this.tabbedPaneIncerteza.getComponentAt(i);
                        panel.removeAll();
                        Component c = DigitacaoIncerteza.this.getComponenteAba(exameRequisicao, (HashMap)DigitacaoIncerteza.this.listaLayouts.get(exameRequisicao.getCodigoExame() + exameRequisicao.getCodigoMaterial()));
                        c.repaint();
                        panel.add(c, "Center");
                        panel.revalidate();
                        panel.repaint();
                        Thread.sleep(50L);
                    }
                    DigitacaoIncerteza.this.tabbedPaneIncerteza.revalidate();
                    DigitacaoIncerteza.this.tabbedPaneIncerteza.repaint();
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(DigitacaoIncerteza.this, e.getMessage(), e.getStackTrace());
                }
            }
        }.start();
    }

    private void preencheDadosRequisicao(Registro dadosRequisicao) throws Exception {
        if (dadosRequisicao == null) {
            return;
        }
        if (this.acessoNaoVisualizarNomeCliente) {
            this.labelVlrCliente.setText("Visualiza\u00e7\u00e3o n\u00e3o permitida");
        } else {
            this.labelVlrCliente.setText(dadosRequisicao.getString("nomecliente"));
        }
        this.labelVlrProduto.setText(dadosRequisicao.getString("descricaoproduto"));
        this.labelVlrArea.setText(dadosRequisicao.getString("areaproduto"));
        this.labelVlrCodigoModalidade.setText(dadosRequisicao.getString("codigodestino"));
        this.labelVlrModalidade.setText(dadosRequisicao.getString("descricaodestino"));
        this.labelVlrDataRecebimento.setText(Funcoes.formataData("dd/MM/yyyy", dadosRequisicao.getDate("datarecebimentoproduto")));
        this.labelVlrLocalColeta.setText(dadosRequisicao.getString("localcoletaproduto"));
        this.labelVlrSIF.setText(dadosRequisicao.getString("sif"));
        this.labelVlrLacre.setText(dadosRequisicao.getString("lacreproduto"));
        this.labelVlrLoteProduto.setText(dadosRequisicao.getString("loteproduto"));
        this.labelVlrDataFabricacao.setText(dadosRequisicao.getString("datafabricacaoproduto"));
        this.labelVlrDataColeta.setText(Funcoes.formataData("dd/MM/yyyy", dadosRequisicao.getDate("datacoletaproduto")));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0400300400");
    }

    @Override
    public void acaoRemover(DigitacaoEvento e) {
        this.removerIncerteza((Digitacao)e.getSource());
    }
}

