/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.laboratorio.digitacao.evento.ImagemDigitacaoListener;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.resultados.DialogoHistoricoDadosBrutos;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.importador.imagem.AbstractImportadorImagem;
import jalis.laboratorio.util.importador.imagem.FabricaImportarImagem;
import jalis.laboratorio.util.importador.imagem.ProtocoloImportarImagem;
import jalis.model.bean.recepcao.ExameRequisicaoDadosBrutosBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.recepcao.ExameRequisicaoDadosBrutosService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class DigitacaoDadosBrutos
extends FrmCadPadrao
implements DigitacaoListener,
ImagemDigitacaoListener {
    private static final String METODOS = "metodos";
    private static final String METODO_SELECIONADO = "metodoselecionado";
    private static final String METODOLOGIA_EXAME = "metodologiaexame";
    private static final String MODELO_ATUAL = "modeloatual";
    private static final String CABECALHO_LAYOUT = "cabecalholayout";
    private static final int TEMPO_MOSTRAR_MENSAGEM_SUCESSO = 3500;
    private static final String TOOL_TIP_TEXT = "<html>Ctrl + H - Informa\u00e7\u00f5es do exame<br>Ctrl + I - Informa\u00e7\u00f5es da requisi\u00e7\u00e3o</html>";
    private TTextField textFilial = new TTextField(8, 1);
    private TTextField textRequisicao = new TTextField(12, 1);
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelDataRecebimento = new JLabel("Dt. Recebimento:");
    private JLabel labelProduto = new JLabel("Produto:");
    private JLabel labelArea = new JLabel("\u00c1rea:");
    private JLabel labelModalidade = new JLabel("Modalidade:");
    private JLabel labelLocalColeta = new JLabel("Local de Coleta:");
    private JLabel labelLacre = new JLabel("Lacre:");
    private JLabel labelDataFabricacao = new JLabel("Dt. Fabrica\u00e7\u00e3o:");
    private JLabel labelLoteProduto = new JLabel("Lote:");
    private JLabel labelSIF = new JLabel("S.I.F.:");
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelDataColeta = new JLabel("Dt. Coleta:");
    private JLabel labelVlrFilial = new JLabel();
    private JLabel labelVlrCliente = new JLabel();
    private JLabel labelVlrDataRecebimento = new JLabel();
    private JLabel labelVlrProduto = new JLabel();
    private JLabel labelVlrArea = new JLabel();
    private JLabel labelVlrCodigoModalidade = new JLabel();
    private JLabel labelVlrModalidade = new JLabel();
    private JLabel labelVlrSIF = new JLabel();
    private JLabel labelVlrLocalColeta = new JLabel();
    private JLabel labelVlrLacre = new JLabel();
    private JLabel labelVlrDataFabricacao = new JLabel();
    private JLabel labelVlrLoteProduto = new JLabel();
    private JLabel labelVlrMaterial = new JLabel();
    private JLabel labelVlrDataColeta = new JLabel();
    private JLabel labelMensagemSalvoSucesso = new JLabel("Dados brutos salvos com sucesso");
    private JButton buttonBuscaHistorico = new JButton("Hist\u00f3rico");
    private JButton buttonBuscaFilial = new JButton("");
    private JButton buttonBuscaRequisicao = new JButton("");
    private JTabbedPane tabbedPaneDadosBrutos = new JTabbedPane(2);
    private AbstractImportadorImagem importadorImagem = FabricaImportarImagem.getImportadorDeConfiguracao(ParametrosLocais.getParametro("importadorImagemDigitacao"));
    private Registro dadosRequisicao = null;
    private ArrayList<Registro> listaExames = null;
    private ArrayList<Registro> listaLayouts = null;
    FilialVO filialVO = null;
    private ExameRequisicaoDadosBrutosService requisicaoDadosBrutosService = new ExameRequisicaoDadosBrutosService();
    private boolean acessoNaoVisualizarNomeCliente = Acesso.getAcesso(Long.parseLong("0400300301"));
    private boolean acessoNaoVerMotivoRecoleta = Acesso.getAcesso(Long.parseLong("0400300302"));
    private boolean acessoImprimir = Acesso.getAcesso(Long.parseLong("0400300303"));
    private boolean acessoVisualizarHistorico = Acesso.getAcesso(Long.parseLong("0400300304"));

    public DigitacaoDadosBrutos() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLabelFormulario("Dados Brutos");
        this.setLabelDescricao("Digita\u00e7\u00e3o dos dados brutos das an\u00e1lises");
        this.setIcone(ImagemUtils.carregaImagemJalis("resultados/dados_brutos.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        this.buttonBuscaHistorico.setMnemonic('H');
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrFilial, this.labelVlrCliente, this.labelVlrDataRecebimento, this.labelVlrProduto, this.labelVlrArea, this.labelVlrCodigoModalidade, this.labelVlrModalidade, this.labelVlrSIF, this.labelVlrLocalColeta, this.labelVlrLacre, this.labelVlrDataFabricacao, this.labelVlrLoteProduto, this.labelVlrMaterial, this.labelVlrDataColeta}, new TitledBorder(""));
        Dimension dimensaoCodigos = new Dimension(105, 20);
        Dimension dimensaoLabels = new Dimension(20, 20);
        Dimension dimensaoBotoesBusca = new Dimension(20, 20);
        Dimension dimensaoDatas = new Dimension(120, 20);
        Insets insetNormal = new Insets(1, 1, 0, 0);
        Insets insetEspaco = new Insets(1, 20, 0, 0);
        Insets insetDireita = new Insets(1, 1, 0, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (!ParametrosGerais.getTipoIntegracao().equals("N")) {
            this.labelFilial.setLabelFor(this.textFilial);
            this.labelFilial.setDisplayedMnemonic('l');
            this.painelCentral.add((Component)this.labelFilial, c);
            ++c.gridx;
            this.textFilial.setPreferredSize(dimensaoCodigos);
            this.textFilial.setMinimumSize(dimensaoCodigos);
            this.painelCentral.add((Component)this.textFilial, c);
            ++c.gridx;
            this.buttonBuscaFilial.setPreferredSize(dimensaoBotoesBusca);
            this.buttonBuscaFilial.setMinimumSize(dimensaoBotoesBusca);
            this.buttonBuscaFilial.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonBuscaFilial);
            this.painelCentral.add((Component)this.buttonBuscaFilial, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.insets = insetDireita;
            this.labelVlrFilial.setPreferredSize(dimensaoLabels);
            this.labelVlrFilial.setMinimumSize(dimensaoLabels);
            this.painelCentral.add((Component)this.labelVlrFilial, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.labelRequisicao.setLabelFor(this.textRequisicao);
        this.labelRequisicao.setDisplayedMnemonic('R');
        this.painelCentral.add((Component)this.labelRequisicao, c);
        ++c.gridx;
        this.textRequisicao.setPreferredSize(dimensaoCodigos);
        this.textRequisicao.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.textRequisicao, c);
        ++c.gridx;
        this.buttonBuscaRequisicao.setPreferredSize(dimensaoBotoesBusca);
        this.buttonBuscaRequisicao.setMinimumSize(dimensaoBotoesBusca);
        this.buttonBuscaRequisicao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        this.painelCentral.add((Component)this.buttonBuscaRequisicao, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.insets = insetDireita;
        this.labelVlrCliente.setPreferredSize(dimensaoLabels);
        this.labelVlrCliente.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrCliente, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelProduto, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.labelVlrProduto.setPreferredSize(dimensaoLabels);
        this.labelVlrProduto.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrProduto, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelArea, c);
        ++c.gridx;
        c.insets = insetNormal;
        c.insets = insetDireita;
        this.labelVlrArea.setPreferredSize(dimensaoDatas);
        this.labelVlrArea.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrArea, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelModalidade, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelVlrCodigoModalidade.setPreferredSize(dimensaoCodigos);
        this.labelVlrCodigoModalidade.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.labelVlrCodigoModalidade, c);
        c.gridx += 2;
        this.labelVlrModalidade.setPreferredSize(dimensaoLabels);
        this.labelVlrModalidade.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrModalidade, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelDataRecebimento, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrDataRecebimento.setPreferredSize(dimensaoDatas);
        this.labelVlrDataRecebimento.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrDataRecebimento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelLocalColeta, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.labelVlrLocalColeta.setPreferredSize(dimensaoLabels);
        this.labelVlrLocalColeta.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrLocalColeta, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelSIF, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrSIF.setPreferredSize(dimensaoDatas);
        this.labelVlrSIF.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrSIF, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelLacre, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelVlrLacre.setPreferredSize(dimensaoCodigos);
        this.labelVlrLacre.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.labelVlrLacre, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelLoteProduto, c);
        ++c.gridx;
        c.insets = insetNormal;
        c.weightx = 1.0;
        this.labelVlrLoteProduto.setPreferredSize(dimensaoLabels);
        this.labelVlrLoteProduto.setMinimumSize(dimensaoLabels);
        this.painelCentral.add((Component)this.labelVlrLoteProduto, c);
        ++c.gridx;
        c.insets = insetEspaco;
        c.weightx = 0.0;
        this.painelCentral.add((Component)this.labelDataFabricacao, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrDataFabricacao.setPreferredSize(dimensaoDatas);
        this.labelVlrDataFabricacao.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrDataFabricacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = insetNormal;
        this.painelCentral.add((Component)this.labelMaterial, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.labelVlrMaterial.setPreferredSize(dimensaoCodigos);
        this.labelVlrMaterial.setMinimumSize(dimensaoCodigos);
        this.painelCentral.add((Component)this.labelVlrMaterial, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = insetEspaco;
        this.painelCentral.add((Component)this.labelDataColeta, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.labelVlrDataColeta.setPreferredSize(dimensaoDatas);
        this.labelVlrDataColeta.setMinimumSize(dimensaoDatas);
        this.painelCentral.add((Component)this.labelVlrDataColeta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)this.tabbedPaneDadosBrutos, c);
        this.montaPainelBotoes();
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DigitacaoDadosBrutos.this.buscaDadosFilial(DigitacaoDadosBrutos.this.textFilial.getText());
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DigitacaoDadosBrutos.this.pesquisaFilial();
                }
            }
        });
        this.textRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (DigitacaoDadosBrutos.this.filialVO != null && Funcoes.processarFuncaoNumeroTubo(DigitacaoDadosBrutos.this.textFilial, DigitacaoDadosBrutos.this.textRequisicao)) {
                    DigitacaoDadosBrutos.this.buscaDadosRequisicao(DigitacaoDadosBrutos.this.filialVO.getCodigo().toString(), DigitacaoDadosBrutos.this.textRequisicao.getText());
                }
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DigitacaoDadosBrutos.this.pesquisaRequisicao();
                }
            }
        });
        this.buttonBuscaFilial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DigitacaoDadosBrutos.this.pesquisaFilial();
            }
        });
        this.buttonBuscaRequisicao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DigitacaoDadosBrutos.this.pesquisaRequisicao();
            }
        });
        this.buttonBuscaHistorico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DigitacaoDadosBrutos.this.visualizarHistoricoExames();
            }
        });
        this.novo();
    }

    private void visualizarHistoricoExames() {
        DialogoHistoricoDadosBrutos dialogo = DialogoHistoricoDadosBrutos.novaInstancia(this.getTopLevelAncestor());
        if (dialogo != null) {
            String filial = "";
            filial = !ParametrosGerais.getTipoIntegracao().equals("N") ? this.textFilial.getText() : Variaveis.filialPadrao;
            if (Funcoes.textoVazio(this.textRequisicao.getText())) {
                ScreenUtil.requisitarFoco(this.textRequisicao);
                return;
            }
            boolean visivel = dialogo.setPaciente(filial, this.textRequisicao.getText(), this.getRegistroExameRequisicao());
            if (visivel) {
                dialogo.setVisible(true);
            }
        }
    }

    private void montaPainelBotoes() {
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        this.painelBotoes.add((Component)panelEsquerda, "West");
        this.painelBotoes.add((Component)panelDireita, "East");
        this.labelMensagemSalvoSucesso.setForeground(Color.RED);
        this.labelMensagemSalvoSucesso.setVisible(false);
        panelEsquerda.add(this.labelMensagemSalvoSucesso);
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && this.acessoVisualizarHistorico) {
            panelDireita.add(this.buttonBuscaHistorico);
        }
        panelDireita.add(this.botaoNovo);
        panelDireita.add(this.botaoFechar);
    }

    private void buscaDadosFilial(String codigoFilial) {
        try {
            if (!Funcoes.textoVazio(codigoFilial)) {
                this.filialVO = (FilialVO)new FilialService().getVO(codigoFilial);
                if (this.filialVO != null) {
                    this.textFilial.setText(this.filialVO.getCodigo().toString());
                    this.labelVlrFilial.setText(this.filialVO.getDescricao());
                    ScreenUtil.requisitarFoco(this.textRequisicao);
                } else {
                    this.labelVlrFilial.setText("N\u00e3o cadastrado");
                }
            }
            this.controlaCampos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da filial.\n" + e.getMessage(), e.getStackTrace());
            this.filialVO = null;
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 2;
        this.textFilial.setEnabled(enabled && this.dadosRequisicao == null);
        this.buttonBuscaFilial.setEnabled(enabled && this.dadosRequisicao == null);
        this.textRequisicao.setEnabled(enabled && this.filialVO != null && this.dadosRequisicao == null);
        this.buttonBuscaRequisicao.setEnabled(enabled && this.filialVO != null && this.dadosRequisicao == null);
        this.buttonBuscaHistorico.setEnabled(enabled && this.dadosRequisicao != null);
        this.botaoNovo.setEnabled(true);
        this.botaoFechar.setEnabled(true);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0400300300");
    }

    private void pesquisaFilial() {
        this.filialVO = (FilialVO)new FilialService().pesquisaVO(Laboratorio.getInstancia(), new FilialVO(), "Buscando filiais", true);
        if (this.filialVO != null) {
            this.textFilial.setText(this.filialVO.getCodigo().toString());
            this.labelVlrFilial.setText(this.filialVO.getDescricao());
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private void pesquisaRequisicao() {
        this.labelVlrCliente.setText("");
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), this.filialVO.getCodigo().toString(), false, false, this.acessoNaoVisualizarNomeCliente);
        if (resultado != null) {
            this.textRequisicao.setText(resultado.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    @Override
    public void novo() {
        this.setStatus(2);
        this.limpaCampos();
        this.buscaDadosFilial(Variaveis.filialPadrao);
        if (!ParametrosGerais.getTipoIntegracao().equals("N")) {
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textFilial);
        } else {
            this.buscaDadosFilial(Variaveis.filialPadrao);
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private void limpaCampos() {
        this.textFilial.clear();
        this.labelVlrFilial.setText("");
        this.textRequisicao.clear();
        this.labelVlrCliente.setText("");
        this.labelVlrProduto.setText("");
        this.labelVlrArea.setText("");
        this.labelVlrCodigoModalidade.setText("");
        this.labelVlrModalidade.setText("");
        this.labelVlrDataRecebimento.setText("");
        this.labelVlrLocalColeta.setText("");
        this.labelVlrSIF.setText("");
        this.labelVlrLacre.setText("");
        this.labelVlrLoteProduto.setText("");
        this.labelVlrDataFabricacao.setText("");
        this.labelVlrMaterial.setText("");
        this.labelVlrDataColeta.setText("");
        this.tabbedPaneDadosBrutos.removeAll();
        this.filialVO = null;
        this.dadosRequisicao = null;
        this.listaExames = null;
        this.listaLayouts = null;
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void cancelar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosRequisicao(String codigoFilial, String codigoRequisicao) {
        Statement st;
        block6: {
            this.labelVlrCliente.setText("");
            if (Funcoes.textoVazio(codigoFilial) || Funcoes.textoVazio(codigoRequisicao)) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select des.des_codigo as codigoDestino ");
            buf.append("       ,des.des_descricao as descricaoDestino ");
            buf.append("       ,pac.pac_nome as nomeCliente ");
            buf.append("       ,req.req_descricaoproduto as descricaoProduto ");
            buf.append("       ,req.req_areaproduto as areaProduto ");
            buf.append("       ,req.req_datarecebimentoproduto as dataRecebimentoProduto ");
            buf.append("       ,pac.pac_sif as sif ");
            buf.append("       ,req.req_lacreproduto as lacreProduto ");
            buf.append("       ,req.req_localcoletaproduto as localColetaProduto ");
            buf.append("       ,req.req_numeroloteproduto loteProduto ");
            buf.append("       ,req.req_datafabricacao as dataFabricacaoProduto ");
            buf.append("       ,req.req_datacoletaproduto as dataColetaProduto ");
            buf.append("       ,req.fil_codigo as codigoFilial ");
            buf.append("       ,req.req_codigo as codigoRequisicao ");
            buf.append("       ,req.con_codigo as codigoConvenio ");
            buf.append("   from requisicao req ");
            buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("   left join destino des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
            buf.append("  where req.fil_codigo = ").append(codigoFilial);
            buf.append("    and req.req_codigo = ").append(codigoRequisicao);
            buf.append("    and not req.req_excluida ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.dadosRequisicao = new Registro(rs);
                    this.preencheDadosRequisicao(this.dadosRequisicao);
                    this.buscaDadosExames();
                    this.controlaCampos();
                    break block6;
                }
                this.labelVlrCliente.setText("Requisi\u00e7\u00e3o n\u00e3o encontrada");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "Erro o buscar os dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                    this.dadosRequisicao = null;
                    this.controlaCampos();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return;
            }
        }
        Conexao.fecharStatement(st);
    }

    private void preencheDadosRequisicao(Registro dadosRequisicao) throws Exception {
        if (dadosRequisicao == null) {
            return;
        }
        if (this.acessoNaoVisualizarNomeCliente) {
            this.labelVlrCliente.setText("Visualiza\u00e7\u00e3o n\u00e3o permitida");
        } else {
            this.labelVlrCliente.setText(dadosRequisicao.getString("nomecliente"));
        }
        this.labelVlrProduto.setText(dadosRequisicao.getString("descricaoproduto"));
        this.labelVlrArea.setText(dadosRequisicao.getString("areaproduto"));
        this.labelVlrCodigoModalidade.setText(dadosRequisicao.getString("codigodestino"));
        this.labelVlrModalidade.setText(dadosRequisicao.getString("descricaodestino"));
        this.labelVlrDataRecebimento.setText(Funcoes.formataData("dd/MM/yyyy", dadosRequisicao.getDate("datarecebimentoproduto")));
        this.labelVlrLocalColeta.setText(dadosRequisicao.getString("localcoletaproduto"));
        this.labelVlrSIF.setText(dadosRequisicao.getString("sif"));
        this.labelVlrLacre.setText(dadosRequisicao.getString("lacreproduto"));
        this.labelVlrLoteProduto.setText(dadosRequisicao.getString("loteproduto"));
        this.labelVlrDataFabricacao.setText(dadosRequisicao.getString("datafabricacaoproduto"));
        this.labelVlrDataColeta.setText(Funcoes.formataData("dd/MM/yyyy", dadosRequisicao.getDate("datacoletaproduto")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosExames() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr.exr_datamaterial as dataColetaMaterial ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_descricaomaterial), ''), mco.mco_descricao) as descricaoMaterial ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,mco.mco_codigo as codigoMaterial ");
        buf.append("       ,mco.mco_abreviatura as abreviaturaMaterial ");
        buf.append("       ,exr.exr_situacao as situacaoExameRequisicao ");
        buf.append("       ,exr.exr_motivorecoleta as motivoRecoletaExameRequisicao ");
        buf.append("       ,exr.exr_datadigita as dataDigitacaoExameRequisicao ");
        buf.append("       ,exr.exr_dadosbrutos as dadosBrutosExameRequisicao ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("  where exr.fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
        buf.append("    and exr.req_codigo = ").append(this.dadosRequisicao.getString("codigorequisicao"));
        buf.append("    and not exr.exr_excluido ");
        buf.append("  order by exr.exa_codigo ");
        buf.append("          ,exr.mco_codigo ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                this.preencheDadosExamesRequisicao(rs);
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados dos exames da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
    }

    private void preencheDadosExamesRequisicao(ResultSet rsExameRequisicao) throws Exception {
        Registro dadosExameRequisicao = new Registro(rsExameRequisicao);
        Registro dadosLayout = this.buscaDadosLayoutDadosBrutos(dadosExameRequisicao);
        this.labelVlrMaterial.setText(rsExameRequisicao.getString("descricaoMaterial"));
        this.listaExames = new ArrayList();
        this.listaLayouts = new ArrayList();
        int contador = 0;
        this.listaExames.add(dadosExameRequisicao);
        this.listaLayouts.add(dadosLayout);
        this.tabbedPaneDadosBrutos.add(this.getTituloAba(dadosExameRequisicao), this.montaComponenteAba(this.getComponenteAba(dadosExameRequisicao, dadosLayout)));
        this.tabbedPaneDadosBrutos.setToolTipTextAt(contador++, TOOL_TIP_TEXT);
        while (rsExameRequisicao.next()) {
            dadosExameRequisicao = new Registro(rsExameRequisicao);
            this.listaExames.add(dadosExameRequisicao);
            dadosLayout = this.buscaDadosLayoutDadosBrutos(dadosExameRequisicao);
            this.listaLayouts.add(dadosLayout);
            JLabel label = ComponenteFactory.novoJLabel("Carregando exame", null, 0);
            this.tabbedPaneDadosBrutos.add(this.getTituloAba(dadosExameRequisicao), this.montaComponenteAba(label));
            this.tabbedPaneDadosBrutos.setToolTipTextAt(contador++, TOOL_TIP_TEXT);
        }
        new Thread("CarregaExame"){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < DigitacaoDadosBrutos.this.listaExames.size(); ++i) {
                        if (i == 0) continue;
                        Registro reg = (Registro)DigitacaoDadosBrutos.this.listaExames.get(i);
                        JPanel panel = (JPanel)DigitacaoDadosBrutos.this.tabbedPaneDadosBrutos.getComponentAt(i);
                        panel.removeAll();
                        Component c = DigitacaoDadosBrutos.this.getComponenteAba(reg, (Registro)DigitacaoDadosBrutos.this.listaLayouts.get(i));
                        c.repaint();
                        panel.add(c, "Center");
                        panel.revalidate();
                        panel.repaint();
                        Thread.sleep(50L);
                    }
                    DigitacaoDadosBrutos.this.tabbedPaneDadosBrutos.revalidate();
                    DigitacaoDadosBrutos.this.tabbedPaneDadosBrutos.repaint();
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(DigitacaoDadosBrutos.this, e.getMessage(), e.getStackTrace());
                }
            }
        }.start();
    }

    private JPanel montaComponenteAba(Component c) {
        JPanel p = new JPanel(new BorderLayout());
        p.add(c, "Center");
        return p;
    }

    private String getTituloAba(Registro regExameRequisicao) {
        StringBuilder buf = new StringBuilder();
        if (regExameRequisicao != null) {
            String descricaoMaterial = regExameRequisicao.getString("descricaomaterial");
            descricaoMaterial = descricaoMaterial.length() > 14 ? descricaoMaterial.substring(0, 14) : descricaoMaterial;
            buf.append("<html><font size=2>").append(regExameRequisicao.getString("codigoexame")).append(" (<font color=#FF0000>").append(regExameRequisicao.getString("abreviaturamaterial")).append("</font>)");
            buf.append("<br>");
            buf.append(descricaoMaterial);
            buf.append("</font></html>");
        }
        return buf.toString();
    }

    private Component getComponenteAba(Registro dadosExameRequisicao, Registro dadosLayout) throws SQLException {
        String dadosBrutos = dadosExameRequisicao.getString("dadosbrutosexamerequisicao");
        String xmlLayout = dadosLayout.getString("dadosbrutos");
        String situacao = dadosExameRequisicao.getString("situacaoexamerequisicao");
        if (Funcoes.textoVazio(dadosBrutos) && Funcoes.textoVazio(xmlLayout)) {
            return new JLabel("Exame sem layout de dados brutos.", 0);
        }
        if (situacao.equalsIgnoreCase("F")) {
            return new JLabel("A situa\u00e7\u00e3o do material \u00e9 FALTA MATERIAL.", 0);
        }
        if (situacao.equalsIgnoreCase("T")) {
            return new JLabel("A situa\u00e7\u00e3o do material \u00e9 A COLETAR.", 0);
        }
        if (situacao.equalsIgnoreCase("R")) {
            StringBuilder buf = new StringBuilder();
            buf.append("<html>O material deve ser RECOLETADO.");
            if (!Funcoes.textoVazio(dadosExameRequisicao.getString("motivorecoletaexamerequisicao")) && !this.acessoNaoVerMotivoRecoleta) {
                buf.append("<br>").append("<font size=2>Motivo: ").append(dadosExameRequisicao.getString("motivorecoletaexamerequisicao")).append(".</font>");
            }
            buf.append("</html>");
            return new JLabel(buf.toString(), 0);
        }
        if (situacao.equalsIgnoreCase("O")) {
            return new JLabel("O resultado do exame est\u00e1 EM REPETI\u00c7\u00c3O.", 0);
        }
        if (situacao.equalsIgnoreCase("A")) {
            if (!Funcoes.textoVazio(dadosExameRequisicao.getString("datadigitacaoexamerequisicao"))) {
                return new JLabel("Exame marcado como APENAS FATURAMENTO: " + Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.stringToDate("yyyy/MM/dd HH:mm", dadosExameRequisicao.getString("datadigitacaoexamerequisicao"))) + ".", 0);
            }
            return new JLabel("Exame marcado como APENAS FATURAMENTO.", 0);
        }
        if (situacao.equalsIgnoreCase("L") || situacao.equalsIgnoreCase("C") || situacao.equalsIgnoreCase("I") || situacao.equalsIgnoreCase("E")) {
            Digitacao digitacao = new Digitacao();
            digitacao.carregarCampos(dadosExameRequisicao.getString("dadosbrutosexamerequisicao"));
            JScrollPane aux = new JScrollPane(digitacao);
            aux.setBorder(null);
            return aux;
        }
        Map<String, Object> mapaDadosBrutos = DigitacaoDadosBrutos.getCamposDadosBrutos(dadosExameRequisicao.getString("dadosbrutosexamerequisicao"));
        Digitacao digitacao = new Digitacao();
        digitacao.setVerificarCompleto(true);
        digitacao.exibirBotaoSalvarParcial(false);
        digitacao.exibirBotaoImprimir(this.acessoImprimir);
        digitacao.exibirCheckBoxImprimir(false);
        digitacao.addDigitacaoListener(this);
        if (this.importadorImagem != null && this.importadorImagem.getProtocolo() != ProtocoloImportarImagem.SELECIONAR) {
            digitacao.addImagemDigitacaoListener(this);
        }
        ModeloResultSet met = (ModeloResultSet)dadosExameRequisicao.getValor(METODOS);
        String modeloAtual = dadosExameRequisicao.getString(MODELO_ATUAL);
        String formato = modeloAtual.length() > 0 ? modeloAtual : xmlLayout;
        digitacao.carregarCampos(formato, mapaDadosBrutos, null, null, null, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1);
        digitacao.adicionaListenerTabelaSimbolos(new TabelaSimbolosListener(){

            @Override
            public Object simboloNaoLocalizado(String simbolo) {
                Map valores = DigitacaoDadosBrutos.this.getCamposJaDigitados(simbolo);
                return valores != null && valores.containsKey(simbolo.toUpperCase()) ? valores.get(simbolo.toUpperCase()) : null;
            }
        });
        dadosExameRequisicao.setValor(MODELO_ATUAL, formato);
        return digitacao;
    }

    public static Map<String, Object> getCamposDadosBrutos(String xmlDadosBrutos) {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        Resultado res = new Resultado(xmlDadosBrutos);
        for (Component comp : res.getComponentes()) {
            if (!(comp instanceof ComponenteValor)) continue;
            ComponenteValor compVlr = (ComponenteValor)((Object)comp);
            campos.put(compVlr.getNome().toLowerCase(), compVlr instanceof TextoEstatico ? ((TextoEstatico)compVlr).getText() : (compVlr.getValor() != null ? compVlr.getValor() : ""));
        }
        return campos;
    }

    private Map<String, Object> getCamposJaDigitados(String simbolo) {
        if (this.tabbedPaneDadosBrutos.getTabCount() == 1) {
            return null;
        }
        String exameAPesquisar = simbolo.indexOf("_") > 0 ? simbolo.substring(0, simbolo.indexOf("_")) : "";
        HashMap<String, Object> campos = new HashMap<String, Object>();
        for (int i = 0; i < this.tabbedPaneDadosBrutos.getTabCount(); ++i) {
            Digitacao tmp;
            String situacao = this.listaExames.get(i).getString("situacaoexame");
            String exame = this.listaExames.get(i).getString("codigoexame");
            if (!Funcoes.textoVazio(exameAPesquisar) && !exame.toLowerCase().startsWith(exameAPesquisar.toLowerCase())) continue;
            String titulo = this.tabbedPaneDadosBrutos.getTitleAt(i);
            if (!situacao.equals("L") && !situacao.equals("C") && !situacao.equals("I") && !situacao.equals("E") || (tmp = this.localizaComponenteDigitacao((JPanel)this.tabbedPaneDadosBrutos.getComponentAt(i))) == null) continue;
            Digitacao dig = tmp;
            Map<String, Object> map = Resultado.getCamposResultado(dig.getResultado());
            for (String key : map.keySet()) {
                campos.put((exame + "_" + key).toUpperCase(), map.get(key));
            }
        }
        return campos.size() == 0 ? null : campos;
    }

    private Digitacao localizaComponenteDigitacao(Component c) {
        JComponent tmp;
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            if (((JLabel)c).getText().toLowerCase().startsWith("carregando")) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (c instanceof Digitacao) {
            return (Digitacao)c;
        }
        if (c instanceof JPanel) {
            tmp = (JPanel)c;
            int n = 0;
            Component[] componentArray = ((JPanel)c).getComponents();
            int n2 = componentArray.length;
            if (n < n2) {
                Component comp = componentArray[n];
                if (comp instanceof Digitacao) {
                    return (Digitacao)comp;
                }
                return this.localizaComponenteDigitacao(comp);
            }
        } else if (c instanceof JScrollPane) {
            tmp = (JScrollPane)c;
            int n = 0;
            Component[] componentArray = ((JScrollPane)c).getViewport().getComponents();
            int n3 = componentArray.length;
            if (n < n3) {
                Component comp = componentArray[n];
                if (comp instanceof Digitacao) {
                    return (Digitacao)comp;
                }
                return this.localizaComponenteDigitacao(comp);
            }
        }
        return null;
    }

    private Registro buscaDadosLayoutDadosBrutos(Registro dadosExameRequisicao) {
        Registro reg = null;
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                String codigoLayoutAux = ExameUtil.getCodigoLayout(this.dadosRequisicao.getString("codigofilial"), this.dadosRequisicao.getString("codigoconvenio"), this.dadosRequisicao.getString("codigodestino"));
                int codigoLayout = codigoLayoutAux.matches("\\-?\\d+") ? Integer.parseInt(codigoLayoutAux) : -1;
                StringBuilder buf = new StringBuilder();
                buf.append(" select elm.lay_codigo as codigoLayout ");
                buf.append("       ,elm.ela_idadeini as idadeInicial ");
                buf.append("       ,elm.ela_idadefim as idadeFinal ");
                buf.append("       ,elm.ela_idadeinitipo as tipoIdadeInicial ");
                buf.append("       ,elm.ela_idadefimtipo as tipoIdadeFinal ");
                buf.append("       ,elm.ela_padrao as padrao ");
                buf.append("       ,emc.met_codigo as codigoMetodologia ");
                buf.append("   from examematcoleta emc ");
                buf.append("   left join examelayout elm on emc.fil_codigo = elm.fil_codigo and emc.exa_codigo = elm.exa_codigo and emc.mco_codigo = elm.mco_codigo ");
                buf.append("  where emc.fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
                buf.append("    and emc.exa_codigo = '").append(dadosExameRequisicao.getString("codigoexame")).append("' ");
                buf.append("    and emc.mco_codigo = ").append(dadosExameRequisicao.getString("codigomaterial"));
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("padrao");
                    int idadeInicial = rs.getInt("idadeInicial");
                    int idadeFinal = rs.getInt("idadeFinal");
                    String tipoIdadeInicial = rs.getString("tipoIdadeInicial");
                    String tipoIdadeFinal = rs.getString("tipoIdadeFinal");
                    boolean intervaloValido = codigoLayout == rs.getInt("codigoLayout") && this.intervaloValido(idadeInicial, idadeFinal, tipoIdadeInicial, tipoIdadeFinal, this.dadosRequisicao.getString("anomespaciente"), this.dadosRequisicao.getInt("idadepaciente"));
                    boolean bl = idadeZero = codigoLayout == rs.getInt("codigoLayout") && idadeInicial == 0 && idadeFinal == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !intervaloValido) continue;
                    linha = rs.getRow();
                    if (!intervaloValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    reg = new Registro(rs);
                    buf.setLength(0);
                    buf.append(" select elm.elm_dadosbrutos as dadosBrutos ");
                    buf.append("       ,met.met_codigo as codigoMetodologia ");
                    buf.append("       ,met.met_descricao as descricaoMetodologia ");
                    buf.append("       ,lay.lay_dadosbrutos as cabecalhoLayout ");
                    buf.append("   from examelayoutmetodo elm ");
                    buf.append("   left join metodologia met on elm.fil_codigo = met.fil_codigo and elm.met_codigo = met.met_codigo ");
                    buf.append("   left join layout lay on elm.fil_codigo = lay.fil_codigo and elm.lay_codigo = lay.lay_codigo ");
                    buf.append("  where elm.fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
                    buf.append("    and elm.exa_codigo = '").append(dadosExameRequisicao.getString("codigoexame")).append("' ");
                    buf.append("    and elm.mco_codigo = ").append(dadosExameRequisicao.getString("codigomaterial"));
                    buf.append("    and elm.lay_codigo = ").append(rs.getString("codigoLayout"));
                    buf.append("    and elm.ela_idadeini = ").append(rs.getString("idadeInicial"));
                    buf.append("    and elm.ela_idadefim = ").append(rs.getString("idadeFinal"));
                    buf.append("    and elm.ela_idadeinitipo = '").append(rs.getString("tipoIdadeInicial")).append("' ");
                    buf.append("    and elm.ela_idadefimtipo = '").append(rs.getString("tipoIdadeFinal")).append("' ");
                    rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        if (rs.getInt("codigoMetodologia") != dadosExameRequisicao.getInt("codigometodologia")) continue;
                        reg.setValor("dadosbrutos", rs.getString("dadosBrutos"));
                        break;
                    }
                    reg.setValor(METODO_SELECIONADO, dadosExameRequisicao.getInt("codigometodologia"));
                    reg.setValor(CABECALHO_LAYOUT, rs.getString(CABECALHO_LAYOUT));
                    reg.setValor(METODOS, new ModeloResultSet(rs, "C\u00f3digo", "codigoMetodologia", "Descri\u00e7\u00e3o", "descricaoMetodologia"));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "" + e.getMessage(), e.getStackTrace());
            }
        }
        return reg;
    }

    private boolean intervaloValido(int idadeInicial, int idadeFinal, String tipoIni, String tipoFin, String anoMesIdade, int idadePaciente) {
        if (anoMesIdade != null) {
            int idPac = anoMesIdade.equalsIgnoreCase("A") ? idadePaciente * 365 : (anoMesIdade.equalsIgnoreCase("M") ? idadePaciente * 31 : idadePaciente);
            int idIni = tipoIni.equalsIgnoreCase("A") ? idadeInicial * 365 : (tipoIni.equalsIgnoreCase("M") ? idadeInicial * 31 : idadeInicial);
            int idFin = tipoFin.equalsIgnoreCase("A") ? idadeFinal * 365 : (tipoFin.equalsIgnoreCase("M") ? idadeFinal * 31 : idadeFinal);
            return idIni <= idPac && idPac <= idFin;
        }
        return false;
    }

    @Override
    @Deprecated
    public void acaoSalvarParcial(DigitacaoEvento e) {
    }

    private void setFocoPrimeiroCampo() {
        Component comp = this.getComponenteAba();
        if (comp instanceof Digitacao) {
            ((Digitacao)comp).setFocoPrimeiroCampo();
        }
    }

    private void editarRequisicaoExportaFiliais(Registro exame) {
        try {
            ExportaFiliais.gravaRequisicao(this.dadosRequisicao.getInt("codigofilial"), this.dadosRequisicao.getInt("codigorequisicao"), exame.getString("codigoexame"), exame.getInt("codigomaterial"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel exportar filiais.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void revalidarAba() throws SQLException {
        this.revalidarAba(this.tabbedPaneDadosBrutos.getSelectedIndex());
    }

    private void revalidarAba(int indice) throws SQLException {
        if (this.listaExames.size() > indice) {
            Registro dadosExame = this.listaExames.get(indice);
            Registro dadosLayout = this.listaLayouts.get(indice);
            this.tabbedPaneDadosBrutos.remove(indice);
            this.tabbedPaneDadosBrutos.insertTab(this.getTituloAba(dadosExame), null, this.montaComponenteAba(this.getComponenteAba(dadosExame, dadosLayout)), "", indice);
            this.tabbedPaneDadosBrutos.setSelectedIndex(indice);
        }
    }

    private Registro getRegistroExameRequisicao() {
        int i = this.tabbedPaneDadosBrutos.getSelectedIndex();
        if (i > -1 && i < this.listaExames.size()) {
            return this.listaExames.get(i);
        }
        return null;
    }

    private Registro getRegistroLayout() {
        int i = this.tabbedPaneDadosBrutos.getSelectedIndex();
        if (i > -1 && i < this.listaLayouts.size()) {
            return this.listaLayouts.get(i);
        }
        return null;
    }

    private Digitacao getComponenteDigitacao() {
        Component comp = this.getComponenteAba();
        if (comp instanceof Digitacao) {
            return (Digitacao)comp;
        }
        return null;
    }

    private Component getComponenteAba() {
        try {
            JPanel panel = (JPanel)this.tabbedPaneDadosBrutos.getSelectedComponent();
            Component aux = panel.getComponent(0);
            if (aux instanceof JScrollPane) {
                aux = ((JScrollPane)aux).getViewport().getComponent(0);
            }
            return aux;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void acaoSalvar(DigitacaoEvento e) {
        this.salvarDadosBrutos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvarDadosBrutos() {
        Registro exame = this.getRegistroExameRequisicao();
        Registro layout = this.getRegistroLayout();
        Digitacao digitacao = this.getComponenteDigitacao();
        Statement st = Conexao.getStatement();
        if (st != null && exame != null && digitacao != null) {
            block8: {
                try {
                    String dadosBrutos = digitacao.getResultado();
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_dadosbrutos = '").append(StringUtil.textoDB(dadosBrutos)).append("' ");
                    buf.append("  where fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
                    buf.append("    and req_codigo = ").append(this.dadosRequisicao.getString("codigorequisicao"));
                    buf.append("    and exa_codigo = '").append(exame.getString("codigoexame")).append("' ");
                    buf.append("    and mco_codigo = ").append(exame.getString("codigomaterial"));
                    Conexao.executeUpdate(this.dadosRequisicao.getString("codigofilial"), st, buf);
                    this.gravarExameRequisicaoDadosBrutos(exame, dadosBrutos);
                    Conexao.arquivaSQL();
                    this.mostrarMensagemSalvoSucesso();
                    if (this.tabbedPaneDadosBrutos.getSelectedIndex() < this.tabbedPaneDadosBrutos.getTabCount() - 1) {
                        this.tabbedPaneDadosBrutos.setSelectedIndex(this.tabbedPaneDadosBrutos.getSelectedIndex() + 1);
                        this.setFocoPrimeiroCampo();
                        break block8;
                    }
                    ScreenUtil.requisitarFoco(this.botaoFechar);
                }
                catch (Exception ex) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar os dados brutos.\n" + ex.getMessage(), ex.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    private void gravarExameRequisicaoDadosBrutos(Registro exame, String dadosBrutos) throws Exception {
        ExameRequisicaoDadosBrutosBean exameRequisicaoDadosBrutosBean = new ExameRequisicaoDadosBrutosBean();
        exameRequisicaoDadosBrutosBean.setDadosBrutos(StringUtil.textoDB(dadosBrutos));
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(this.dadosRequisicao.getString("codigofilial")));
        exameRequisicaoDadosBrutosBean.setFilial(filialVO);
        RequisicaoVO requisicao = new RequisicaoVO();
        requisicao.setCodigo(Integer.parseInt(this.dadosRequisicao.getString("codigorequisicao")));
        exameRequisicaoDadosBrutosBean.setRequisicao(requisicao);
        ExameVO exameVO = new ExameVO();
        exameVO.setCodigo(exame.getString("codigoexame"));
        exameRequisicaoDadosBrutosBean.setExame(exameVO);
        MaterialColetaVO materialColetaVO = new MaterialColetaVO();
        materialColetaVO.setCodigo(Integer.parseInt(exame.getString("codigomaterial")));
        exameRequisicaoDadosBrutosBean.setMaterialColeta(materialColetaVO);
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setCodigo(Variaveis.login);
        exameRequisicaoDadosBrutosBean.setUsuario(usuarioVO);
        this.requisicaoDadosBrutosService.insert(exameRequisicaoDadosBrutosBean, Variaveis.filialPadrao);
    }

    private void mostrarMensagemSalvoSucesso() {
        this.labelMensagemSalvoSucesso.setVisible(true);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DigitacaoDadosBrutos.this.labelMensagemSalvoSucesso.setVisible(false);
            }
        }, 3500L);
    }

    private String selecionaImpressora() {
        int tipoSeq = ParametrosGerais.getSequenciaImpressora();
        ArrayList<String> seq = new ArrayList<String>();
        seq.add(jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraDadosBrutos")));
        String[] seqImp = seq.toArray(new String[seq.size()]);
        if (seqImp != null) {
            for (int i = 0; i < seqImp.length; ++i) {
                if (seqImp == null || seqImp[i] == null || seqImp[i].length() <= 0) continue;
                return seqImp[i];
            }
        }
        return "";
    }

    @Override
    @Deprecated
    public void acaoFechar(DigitacaoEvento e) {
    }

    @Override
    public void acaoImprimir(DigitacaoEvento e) {
        if (e != null) {
            int resposta = Funcoes.mensagem(this, "Deseja salvar as altera\u00e7\u00f5es ?", 4);
            if (resposta == 1) {
                return;
            }
            this.salvarDadosBrutos();
            Registro exame = this.getRegistroExameRequisicao();
            Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(this.dadosRequisicao.getString("codigorequisicao"), exame.getString("codigoexame"), exame.getString("codigomaterial"), this.dadosRequisicao.getString("codigofilial"), this.acessoNaoVisualizarNomeCliente, true);
            Registro layout = this.getRegistroLayout();
            String dadosBrutos = this.getComponenteDigitacao().getResultado();
            TabelaSimbolos tabelaSimbolo = new TabelaSimbolos();
            tabelaSimbolo.setDados(dados);
            Documento doc = new Documento();
            doc.setDadosBanco(dados);
            doc.setCabecalhoRodape(layout.getString(CABECALHO_LAYOUT));
            doc.setCopias(1);
            doc.addResultados(new ExameMaterialPagina[]{new ExameMaterialPagina(exame.getString("codigoexame"), exame.getInt("codigomaterial"), tabelaSimbolo)}, new String[]{dadosBrutos});
            Impressao imp = new Impressao(this.selecionaImpressora());
            imp.imprimir(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selecionarImagem(ImagemDigitacao e) {
        block7: {
            ImageIcon imagem;
            if (this.importadorImagem == null) break block7;
            String codigoImagem = "";
            if (this.importadorImagem.getProtocolo() == ProtocoloImportarImagem.DCM4CHE_2_0_25) {
                Statement st;
                block6: {
                    st = Conexao.getStatement();
                    Registro dadosExameRequisicao = this.getRegistroExameRequisicao();
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select rec_codigo as codigoRecipiente ");
                    buf.append("   from examerequisicaorecipiente ");
                    buf.append("  where fil_codigo = ").append(this.dadosRequisicao.getString("codigofilial"));
                    buf.append("    and req_codigo = ").append(this.dadosRequisicao.getString("codigorequisicao"));
                    buf.append("    and exa_codigo = '").append(dadosExameRequisicao.getString("codigoexame")).append("' ");
                    buf.append("    and mco_codigo = ").append(dadosExameRequisicao.getString("codigomaterial"));
                    try {
                        ResultSet rs = Conexao.executeQuery(st, buf);
                        if (!rs.next()) break block6;
                        codigoImagem = Funcoes.preencheZero(this.dadosRequisicao.getString("codigofilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(this.dadosRequisicao.getString("codigorequisicao"), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(this.dadosRequisicao.getString("codigorecipiente"), ParametrosGerais.getDigitosTuboTubo());
                    }
                    catch (Exception e2) {
                        try {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel selecionar imagem.\n" + e2.getMessage(), e2.getStackTrace());
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
            }
            if ((imagem = this.importadorImagem.selecionarImagem(codigoImagem)) != null) {
                // empty if block
            }
            e.setImagem(imagem);
        }
    }

    @Override
    @Deprecated
    public void acaoRemover(DigitacaoEvento e) {
    }
}

