/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.DigitacaoConferencia;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;

public class DigitacaoConferenciaLote
extends FrmCadPadrao
implements ActionListener,
KeyListener,
ThreadFinalizadaListener {
    private int tipoTela = 0;
    private boolean isBuscando = false;
    private String MENSAGEM_DIGITACAO_CONFERENCIA = "";
    private final int POSICAO_SPLIT = 195;
    private final String MENSAGEM_LOCALIZAR = "<b>Pressione F2 para localizar</b><br>";
    private final int COLUNA_CODIGO_COMPOSTO = 0;
    private final int COLUNA_PACIENTE = 1;
    private final int COLUNA_COLETA = 2;
    private final int COLUNA_CONVENIO = 3;
    private final int COLUNA_EXAMES = 4;
    private final int COLUNA_FILIAL = 5;
    private final int COLUNA_CODIGO = 6;
    private final int CAMPO_DATA_REQUISICAO = 0;
    private final int CAMPO_DATA_COLETA = 1;
    private final int CAMPO_DATA_MAPA = 2;
    private final int CAMPO_DATA_CONFERENCIA = 3;
    private final int CAMPO_DATA_ENTREGA = 4;
    private String PARAMETROS_DIGITACAO_CONFERENCIA_LOTE = null;
    private final String PARAMETRO_FILIAL = "filial";
    private final String PARAMETRO_EXAME = "exame";
    private final String PARAMETRO_PACIENTE = "paciente";
    private final String PARAMETRO_CONVENIO = "convenio";
    private final String PARAMETRO_MEDICO = "medico";
    private final String PARAMETRO_MATERIAL = "material";
    private final String PARAMETRO_SITUACAO = "situacao";
    private final String PARAMETRO_SETOR = "setor";
    private final String PARAMETRO_COLETA = "coleta";
    private final String PARAMETRO_DESTINO = "destino";
    private final String PARAMETRO_LAB_EXTERNO = "labexterno";
    private final String PARAMETRO_INTERFACE = "interface";
    private final String PARAMETRO_SOMENTE_ATRASADOS = "somenteatrasados";
    private final String PARAMETRO_RESULTADOS_CRITICOS = "resultadocritico";
    private final String PARAMETRO_TRAZER_SEM_RESULTADO = "trazersemresultado";
    private final String PARAMETRO_CAMPO_DATA = "campodata";
    private final String PARAMETRO_DATA_INICIAL = "datainicial";
    private final String PARAMETRO_DATA_FINAL = "datafinal";
    private final String PARAMETRO_HORA_INICIAL = "horainicial";
    private final String PARAMETRO_HORA_FINAL = "horafinal";
    private final String PARAMETRO_DIGITACAO_SEQUENCIAL = "digitacaosequencial";
    String[] filiais = null;
    Object[] pacientes = null;
    Object[] convenios = null;
    Object[] medicos = null;
    String[] situacoes = null;
    Object[] exames = null;
    String[] materiais = null;
    String[] coletas = null;
    String[] destinos = null;
    String[] setores = null;
    String[] labExternos = null;
    String[] interfaces = null;
    private final String[] CAMPOS_BANCO_SEM_HORARIO_DIGITACAO = new String[]{"req.req_data", "cast(exr.exr_datamaterial as date)", "cast(exr.exr_datamapa as date)", "cast(exr.exr_dataentregaprev as date)"};
    private final String[] CAMPOS_BANCO_COM_HORARIO_DIGITACAO = new String[]{"req.req_data", "exr.exr_datamaterial", "exr.exr_datamapa", "exr.exr_dataentregaprev"};
    private final String[] CAMPOS_BANCO_SEM_HORARIO_CONFERENCIA = new String[]{"req.req_data", "cast(exr.exr_datamaterial as date)", "cast(exr.exr_datamapa as date)", "cast(exr.exr_datadigita as date)", "cast(exr.exr_dataentregaprev as date)"};
    private final String[] CAMPOS_BANCO_COM_HORARIO_CONFERENCIA = new String[]{"req.req_data", "exr.exr_datamaterial", "exr.exr_datamapa", "exr.exr_datadigita", "exr.exr_dataentregaprev"};
    private final String[] CAMPOS_DIGITACAO = new String[]{"Requisi\u00e7\u00e3o", "Coleta", "Mapa", "Entrega"};
    private final String[] CAMPOS_CONFERENCIA = new String[]{"Requisi\u00e7\u00e3o", "Coleta", "Mapa", "Digita\u00e7\u00e3o", "Entrega"};
    private CheckItemFiltro itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", null);
    private CheckItemFiltro itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao, true);
    private CheckItemFiltro itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao, true);
    private CheckItemFiltro itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, true);
    private CheckItemFiltro itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao, true);
    private CheckItemFiltro itemMaterial = new CheckItemFiltro("Material Coleta", "Filtrar", "Filtrando materiais de coleta", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemLabExterno = new CheckItemFiltro("Lab. Externo", "Filtrar", "Filtrando laborat\u00f3rios externos", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemInterface = new CheckItemFiltro("Interface", "Filtrar", "Filtrando Interfaces", "fil_codigo = " + Variaveis.filialPadrao);
    private JLabel labelCampoData = new JLabel("Campo Data:");
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelHoraInicial = new JLabel("Hora Inicial:");
    private JLabel labelHoraFinal = new JLabel("Hora Final:");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textLocalizar = new TTextField(100, 3);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private JButton buttonDataInicial = new JButton();
    private JButton buttonDataFinal = new JButton();
    private JButton buttonFiltrar = new JButton("Filtrar");
    private JButton buttonFecharLocalizar = new JButton();
    private JCheckBox checkSomenteAtrasados = new JCheckBox("Somente atrasados");
    private JCheckBox checkResultadosCriticos = new JCheckBox("Resultados cr\u00edticos");
    private JCheckBox checkTrazerSemResultado = new JCheckBox("Trazer sem resultado");
    private JComboBox comboCampoData = null;
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelLocalizar = new JPanel(new GridBagLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelLegenda = new JPanel(new GridBagLayout());
    private JPanel panelInferior = new JPanel(new BorderLayout());
    private JPanel panelDigitacaoSequencial = new JPanel(new GridBagLayout());
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Coleta", "Conv\u00eanio", "Exames"});
    private JTable tableExames = new JTable(this.modeloExame);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JSplitPane split = new JSplitPane(1, (Component)this.panelFiltros, (Component)this.panelExames){

        @Override
        public int getDividerLocation() {
            return super.getLastDividerLocation() >= 195 ? 0 : 195;
        }
    };
    private int row = -1;
    private boolean ocultarConvenio;

    public DigitacaoConferenciaLote(int tipoTela) {
        this.tipoTela = tipoTela;
        this.PARAMETROS_DIGITACAO_CONFERENCIA_LOTE = tipoTela == 0 ? "DigitacaoLote.ultimoFiltro" : "ConferenciaLote.ultimoFiltro";
        this.inicializaAcessos();
        this.montaTela();
        this.split.setDividerLocation(195);
        this.definirTeclaAtalho();
        this.novo();
        this.carregaParametrosUsuario();
    }

    private void definirTeclaAtalho() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao infReq = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                if (DigitacaoConferenciaLote.this.modeloExame.getRowCount() > 0 && DigitacaoConferenciaLote.this.tableExames.getSelectedRow() > -1) {
                    String filial = (String)DigitacaoConferenciaLote.this.modeloExame.getValueAt(DigitacaoConferenciaLote.this.row, 5);
                    String codigo = (String)DigitacaoConferenciaLote.this.modeloExame.getValueAt(DigitacaoConferenciaLote.this.row, 6);
                    infReq.setRequisicao(filial, Integer.parseInt(codigo));
                }
                infReq.setVisible(true);
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
    }

    private void inicializaAcessos() {
        this.ocultarConvenio = false;
        if (this.tipoTela == 0) {
            this.ocultarConvenio = Acesso.getAcesso(Long.valueOf("0400100202"));
        } else if (this.tipoTela == 1) {
            this.ocultarConvenio = Acesso.getAcesso(Long.valueOf("0400300202"));
        }
    }

    private void carregaParametrosUsuario() {
        String parametros = ParametrosUsuarios.getValor(this.PARAMETROS_DIGITACAO_CONFERENCIA_LOTE);
        if (!Funcoes.textoVazio(parametros)) {
            Object[] aux;
            int i;
            Object[] filtro;
            String[] codigos;
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.itemFilial.setSelecionados(tmp.split(";"));
                this.itemFilial.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exame"))) {
                codigos = StringUtil.getValor(tmp, "codigo").split(";");
                String[] descricoes = StringUtil.getValor(tmp, "descricao").split(";");
                filtro = new Object[codigos.length];
                for (i = 0; i < filtro.length; ++i) {
                    filtro[i] = aux = new Object[]{codigos[i], descricoes[i]};
                }
                this.itemExame.setSelecionadosAvancado(filtro);
                this.itemExame.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "paciente"))) {
                codigos = StringUtil.getValor(tmp, "codigo").split(";");
                String[] nomes = StringUtil.getValor(tmp, "nome").split(";");
                filtro = new Object[codigos.length];
                for (i = 0; i < filtro.length; ++i) {
                    filtro[i] = aux = new Object[]{codigos[i], nomes[i]};
                }
                this.itemPaciente.setSelecionadosAvancado(filtro);
                this.itemPaciente.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "convenio"))) {
                codigos = StringUtil.getValor(tmp, "codigo").split(";");
                String[] fantasia = StringUtil.getValor(tmp, "fantasia").split(";");
                filtro = new Object[codigos.length];
                for (i = 0; i < filtro.length; ++i) {
                    filtro[i] = aux = new Object[]{codigos[i], fantasia[i]};
                }
                this.itemConvenio.setSelecionadosAvancado(filtro);
                this.itemConvenio.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "medico"))) {
                String[] conselhos = StringUtil.getValor(tmp, "conselho").split(";");
                String[] numeros = StringUtil.getValor(tmp, "numero").split(";");
                String[] ufs = StringUtil.getValor(tmp, "uf").split(";");
                String[] nomes = StringUtil.getValor(tmp, "nome").split(";");
                Object[] filtro2 = new Object[conselhos.length];
                for (int i2 = 0; i2 < filtro2.length; ++i2) {
                    Object[] aux2;
                    filtro2[i2] = aux2 = new Object[]{conselhos[i2], numeros[i2], ufs[i2], nomes[i2]};
                }
                this.itemMedico.setSelecionadosAvancado(filtro2);
                this.itemMedico.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "material"))) {
                this.itemMaterial.setSelecionados(tmp.split(";"));
                this.itemMaterial.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "situacao"))) {
                this.itemSituacao.setSelecionados(tmp.split(";"));
                this.itemSituacao.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "setor"))) {
                this.itemSetor.setSelecionados(tmp.split(";"));
                this.itemSetor.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "coleta"))) {
                this.itemColeta.setSelecionados(tmp.split(";"));
                this.itemColeta.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "destino"))) {
                this.itemDestino.setSelecionados(tmp.split(";"));
                this.itemDestino.setSelected(true);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "interface"))) {
                this.itemInterface.setSelecionados(tmp.split(";"));
                this.itemInterface.setSelected(true);
            }
            if (this.tipoTela == 1) {
                tmp = StringUtil.getValor(parametros, "labexterno");
                if (!Funcoes.textoVazio(tmp)) {
                    this.itemLabExterno.setSelecionados(tmp.split(";"));
                    this.itemLabExterno.setSelected(true);
                }
                if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "trazersemresultado"))) {
                    this.checkTrazerSemResultado.setSelected(new Boolean(tmp));
                }
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "somenteatrasados"))) {
                this.checkSomenteAtrasados.setSelected(new Boolean(tmp));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "resultadocritico"))) {
                this.checkResultadosCriticos.setSelected(new Boolean(tmp));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "campodata"))) {
                this.comboCampoData.setSelectedItem(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.textDataInicial.setText(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.textDataFinal.setText(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.textHoraInicial.setText(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.textHoraFinal.setText(tmp);
            }
        }
    }

    private void montaTela() {
        if (this.tipoTela == 0) {
            this.setLabelFormulario("Digita\u00e7\u00e3o em Lote");
            this.setLabelDescricao("Digita\u00e7\u00e3o de resultado em lote");
            this.setIcone(ImagemUtils.carregaImagemJalis("resultados/digitacao_lote.jpg"));
            this.checkTrazerSemResultado.setVisible(false);
            this.itemLabExterno.setVisible(false);
            this.comboCampoData = new JComboBox<String>(this.CAMPOS_DIGITACAO);
            this.MENSAGEM_DIGITACAO_CONFERENCIA = "<b>Pressione ESPA\u00c7O para digitar o resultado</b><br>";
        } else {
            this.setLabelFormulario("Confer\u00eancia em Lote");
            this.setLabelDescricao("Confer\u00eancia de resultado em lote");
            this.setIcone(ImagemUtils.carregaImagemJalis("resultados/conferencia_lote.jpg"));
            this.comboCampoData = new JComboBox<String>(this.CAMPOS_CONFERENCIA);
            this.MENSAGEM_DIGITACAO_CONFERENCIA = "<b>Pressione ESPA\u00c7O para conferir o resultado</b><br>";
        }
        this.botaoEditar.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.botaoCancelar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.painelCentral.setLayout(new BorderLayout());
        this.painelCentral.add((Component)this.split, "Center");
        this.panelExames.add((Component)this.panelDigitacaoSequencial, "North");
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.panelExames.add((Component)this.panelInferior, "South");
        this.split.setOneTouchExpandable(true);
        this.tableExames.addKeyListener(this);
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DigitacaoConferenciaLote.this.row = DigitacaoConferenciaLote.this.tableExames.getSelectedRow();
                if (DigitacaoConferenciaLote.this.row > -1 && e.getClickCount() == 2) {
                    DigitacaoConferenciaLote.this.invocaDigitacaoConferencia();
                }
            }
        });
        this.tableExames.getTableHeader().setReorderingAllowed(true);
        this.tableExames.getTableHeader().addMouseListener(this.modeloExame);
        ModeloGridTable.TamanhoColuna[] colunas = new ModeloGridTable.TamanhoColuna[]{new ModeloGridTable.TamanhoColuna(90, 90), new ModeloGridTable.TamanhoColuna(170, 170), new ModeloGridTable.TamanhoColuna(150, 400), new ModeloGridTable.TamanhoColuna(120, 120), new ModeloGridTable.TamanhoColuna(0, 0)};
        this.modeloExame.setColumnSize(colunas, this.tableExames);
        this.modeloExame.ordenarColuna(0);
        this.tableExames.setDefaultRenderer(Object.class, new ArrayExamesRenderer());
        this.panelLocalizar.setBorder(new TitledBorder("Localizar"));
        this.panelInferior.add((Component)this.panelLocalizar, "North");
        this.panelInferior.add((Component)this.panelLegenda, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 0);
        this.textLocalizar.addActionListener(this);
        this.textLocalizar.addKeyListener(this);
        Dimension d = new Dimension(20, 20);
        this.textLocalizar.setPreferredSize(d);
        this.textLocalizar.setMinimumSize(d);
        this.panelLocalizar.add((Component)this.textLocalizar, c);
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridx;
        this.buttonFecharLocalizar.addActionListener(this);
        d = new Dimension(15, 14);
        this.buttonFecharLocalizar.setPreferredSize(d);
        this.buttonFecharLocalizar.setMinimumSize(d);
        this.buttonFecharLocalizar.setIcon(ImagemUtils.carregaImagemJalis("fechar_pequeno.gif"));
        this.panelLocalizar.add((Component)this.buttonFecharLocalizar, c);
        this.panelLocalizar.setVisible(false);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 0);
        c.gridwidth = 3;
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        d = new Dimension(190, 20);
        this.itemFilial.setPreferredSize(d);
        this.itemFilial.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemFilial, c);
        ++c.gridy;
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, false, true, false);
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(d);
        this.itemExame.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemExame, c);
        ++c.gridy;
        if (!Acesso.getAcesso(Long.valueOf("0400100201")) && this.tipoTela == 0 || !Acesso.getAcesso(Long.valueOf("0400300201")) && this.tipoTela == 1) {
            this.addFiltroPaciente(d, c);
        }
        if (!this.ocultarConvenio) {
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0}, 1, false, true, false);
            this.itemConvenio.setColunaHint(1);
            this.itemConvenio.setPreferredSize(d);
            this.itemConvenio.setMinimumSize(d);
            this.panelFiltros.add((Component)this.itemConvenio, c);
            ++c.gridy;
        }
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(1);
        this.itemMedico.setPreferredSize(d);
        this.itemMedico.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemMedico, c);
        ++c.gridy;
        this.itemMaterial.setDados("materialcoleta", new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemMaterial.setColunaHint(1);
        this.itemMaterial.setPreferredSize(d);
        this.itemMaterial.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemMaterial, c);
        ++c.gridy;
        this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemSituacao.setPreferredSize(d);
        this.itemSituacao.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemSituacao, c);
        ++c.gridy;
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setPreferredSize(d);
        this.itemSetor.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemSetor, c);
        ++c.gridy;
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(d);
        this.itemColeta.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemColeta, c);
        ++c.gridy;
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(d);
        this.itemDestino.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemDestino, c);
        ++c.gridy;
        this.itemInterface.setDados("interface", new String[]{"int_codigo", "int_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemInterface.setColunaHint(1);
        this.itemInterface.setPreferredSize(d);
        this.itemInterface.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemInterface, c);
        ++c.gridy;
        this.itemLabExterno.setDados("labexterno", new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemLabExterno.setColunaHint(1);
        this.itemLabExterno.setPreferredSize(d);
        this.itemLabExterno.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemLabExterno, c);
        ++c.gridy;
        this.checkSomenteAtrasados.setMnemonic('S');
        this.panelFiltros.add((Component)this.checkSomenteAtrasados, c);
        this.checkSomenteAtrasados.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DigitacaoConferenciaLote.this.checkSomenteAtrasados.isSelected()) {
                    DigitacaoConferenciaLote.this.checkTrazerSemResultado.setSelected(true);
                }
            }
        });
        ++c.gridy;
        this.checkTrazerSemResultado.setMnemonic('T');
        this.panelFiltros.add((Component)this.checkTrazerSemResultado, c);
        this.checkTrazerSemResultado.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DigitacaoConferenciaLote.this.checkTrazerSemResultado.isSelected()) {
                    DigitacaoConferenciaLote.this.checkSomenteAtrasados.setSelected(false);
                }
            }
        });
        if (this.tipoTela == 1) {
            ++c.gridy;
            this.checkResultadosCriticos.setMnemonic('R');
            this.panelFiltros.add((Component)this.checkResultadosCriticos, c);
            this.checkResultadosCriticos.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!DigitacaoConferenciaLote.this.checkResultadosCriticos.isSelected()) {
                        DigitacaoConferenciaLote.this.checkResultadosCriticos.setSelected(false);
                    }
                }
            });
        }
        c.gridwidth = 1;
        ++c.gridy;
        int y = c.gridy++;
        this.labelCampoData.setDisplayedMnemonic('C');
        this.labelCampoData.setLabelFor(this.comboCampoData);
        this.panelFiltros.add((Component)this.labelCampoData, c);
        this.labelDataInicial.setDisplayedMnemonic('I');
        this.labelDataInicial.setLabelFor(this.textDataInicial);
        this.panelFiltros.add((Component)this.labelDataInicial, c);
        ++c.gridy;
        this.labelDataFinal.setDisplayedMnemonic('a');
        this.labelDataFinal.setLabelFor(this.textDataFinal);
        this.panelFiltros.add((Component)this.labelDataFinal, c);
        ++c.gridy;
        this.labelHoraInicial.setDisplayedMnemonic('H');
        this.labelHoraInicial.setLabelFor(this.textHoraInicial);
        this.panelFiltros.add((Component)this.labelHoraInicial, c);
        ++c.gridy;
        this.labelHoraFinal.setDisplayedMnemonic('o');
        this.labelHoraFinal.setLabelFor(this.textHoraFinal);
        this.panelFiltros.add((Component)this.labelHoraFinal, c);
        c.gridy = y;
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(1, 1, 0, 0);
        d = new Dimension(110, 20);
        this.comboCampoData.setPreferredSize(d);
        this.comboCampoData.setMinimumSize(d);
        this.panelFiltros.add((Component)this.comboCampoData, c);
        ++c.gridy;
        c.gridwidth = 1;
        d = new Dimension(90, 20);
        this.textDataInicial.setPreferredSize(d);
        this.textDataInicial.setMinimumSize(d);
        this.textDataInicial.addKeyListener(this);
        this.panelFiltros.add((Component)this.textDataInicial, c);
        ++c.gridy;
        this.textDataFinal.setPreferredSize(d);
        this.textDataFinal.setMinimumSize(d);
        this.textDataFinal.addKeyListener(this);
        this.panelFiltros.add((Component)this.textDataFinal, c);
        ++c.gridy;
        d = new Dimension(50, 20);
        this.textHoraInicial.setPreferredSize(d);
        this.textHoraInicial.setMinimumSize(d);
        this.panelFiltros.add((Component)this.textHoraInicial, c);
        ++c.gridy;
        this.textHoraFinal.setPreferredSize(d);
        this.textHoraFinal.setMinimumSize(d);
        this.panelFiltros.add((Component)this.textHoraFinal, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(1, 0, 0, 0);
        this.buttonFiltrar.addActionListener(this);
        this.buttonFiltrar.setPreferredSize(d);
        this.buttonFiltrar.setMinimumSize(d);
        this.buttonFiltrar.setMnemonic('l');
        this.panelFiltros.add((Component)this.buttonFiltrar, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelFiltros.add((Component)new JLabel(), c);
        c.gridy = y + 1;
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        d = new Dimension(20, 20);
        this.buttonDataInicial.setPreferredSize(d);
        this.buttonDataInicial.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataInicial);
        this.buttonDataInicial.addActionListener(this);
        this.buttonDataInicial.setFocusable(false);
        this.panelFiltros.add((Component)this.buttonDataInicial, c);
        ++c.gridy;
        this.buttonDataFinal.setPreferredSize(d);
        this.buttonDataFinal.setMinimumSize(d);
        this.buttonDataFinal.addActionListener(this);
        this.buttonDataFinal.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonDataFinal);
        this.panelFiltros.add((Component)this.buttonDataFinal, c);
        this.montaLegenda();
    }

    private void addFiltroPaciente(Dimension d, GridBagConstraints c) {
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, 2, false, true, false);
        this.itemPaciente.setColunaHint(1);
        this.itemPaciente.setPreferredSize(d);
        this.itemPaciente.setMinimumSize(d);
        this.panelFiltros.add((Component)this.itemPaciente, c);
        ++c.gridy;
    }

    private void montaLegenda() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel aux = new JPanel();
        aux.setPreferredSize(new Dimension(10, 10));
        aux.setBackground(Tipos.COR_SEM_RESULTADO[0]);
        aux.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.panelLegenda.add((Component)aux, c);
        JLabel lblLegenda = new JLabel("Sem resultado");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        if (this.tipoTela == 1) {
            ++c.gridx;
            c.insets = new Insets(1, 20, 1, 1);
            aux = new JPanel();
            aux.setPreferredSize(new Dimension(10, 10));
            aux.setBackground(Tipos.COR_SALVO_PARCIAL[0]);
            aux.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.panelLegenda.add((Component)aux, c);
            lblLegenda = new JLabel(Tipos.tipoSituacaoExame("P"));
            lblLegenda.setFont(font);
            ++c.gridx;
            c.insets = new Insets(1, 1, 1, 1);
            this.panelLegenda.add((Component)lblLegenda, c);
            ++c.gridx;
            c.insets = new Insets(1, 20, 1, 1);
            aux = new JPanel();
            aux.setPreferredSize(new Dimension(10, 10));
            aux.setBackground(Tipos.COR_LANCADO[0]);
            aux.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.panelLegenda.add((Component)aux, c);
            lblLegenda = new JLabel(Tipos.tipoSituacaoExame("L"));
            lblLegenda.setFont(font);
            ++c.gridx;
            c.insets = new Insets(1, 1, 1, 1);
            this.panelLegenda.add((Component)lblLegenda, c);
        }
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        aux = new JPanel();
        aux.setPreferredSize(new Dimension(10, 10));
        aux.setBackground(Tipos.COR_URGENTE[0]);
        aux.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.panelLegenda.add((Component)aux, c);
        lblLegenda = new JLabel(Tipos.tipoSituacaoExame("U"));
        lblLegenda.setFont(font);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelLegenda.add((Component)new JLabel(), c);
    }

    public static long getModuloAcessoDigitacao() {
        return Long.parseLong("0400100200");
    }

    public static long getModuloAcessoConferencia() {
        return Long.parseLong("0400300200");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFiltrar) {
            this.executaBusca();
        } else if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, this.panelFiltros, true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, this.panelFiltros, true);
        } else if (e.getSource() == this.buttonFecharLocalizar) {
            this.panelLocalizar.setVisible(false);
            ScreenUtil.requisitarFoco(this.tableExames);
        }
    }

    @Override
    public void novo() {
        this.limpaCampos();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textDataInicial);
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void cancelar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    private void limpaCampos() {
        this.itemFilial.clear();
        this.itemExame.clear();
        this.itemPaciente.clear();
        this.itemColeta.clear();
        this.itemMedico.clear();
        this.itemMaterial.clear();
        this.itemSituacao.clear();
        this.itemSetor.clear();
        this.itemColeta.clear();
        this.itemDestino.clear();
        this.itemInterface.clear();
        this.itemLabExterno.clear();
        this.checkSomenteAtrasados.setSelected(false);
        this.checkResultadosCriticos.setSelected(false);
        this.checkTrazerSemResultado.setSelected(false);
        this.comboCampoData.setSelectedIndex(0);
        this.textDataInicial.clear();
        this.textDataFinal.clear();
        this.textHoraInicial.clear();
        this.textHoraFinal.clear();
        this.modeloExame.clear();
        this.textLocalizar.clear();
        this.row = -1;
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public Object[] getDadosProximaRequisicao() {
        ++this.row;
        String[] listaExames = null;
        if (this.exames != null && this.exames.length > 0) {
            listaExames = new String[this.exames.length];
            for (int i = 0; i < this.exames.length; ++i) {
                listaExames[i] = (String)((Object[])this.exames[i])[0];
            }
        }
        if (this.row >= this.modeloExame.getRowCount()) {
            return null;
        }
        return new Object[]{(String)this.modeloExame.getValueAt(this.row, 5), (String)this.modeloExame.getValueAt(this.row, 6), listaExames, this.materiais};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executaBusca() {
        this.row = -1;
        if (Funcoes.textoVazio(this.textDataInicial)) {
            Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return;
        }
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Aguarde...");
        String sql = this.getSqlBusca(null, null);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, sql);
            this.preencheValores(rs);
            this.gravaParametrosUsuario();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar os exames.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            splash.apagar();
        }
    }

    private void gravaParametrosUsuario() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTagPreenchida("filial", this.filiais));
        buf.append(this.getTagPreenchida("exame", this.exames));
        buf.append(this.getTagPreenchida("paciente", this.pacientes));
        buf.append(this.getTagPreenchida("convenio", this.convenios));
        buf.append(this.getTagPreenchida("medico", this.medicos));
        buf.append(this.getTagPreenchida("material", this.materiais));
        buf.append(this.getTagPreenchida("situacao", this.situacoes));
        buf.append(this.getTagPreenchida("setor", this.setores));
        buf.append(this.getTagPreenchida("coleta", this.coletas));
        buf.append(this.getTagPreenchida("destino", this.destinos));
        buf.append(this.getTagPreenchida("interface", this.interfaces));
        buf.append(this.getTagPreenchida("somenteatrasados", this.checkSomenteAtrasados.isSelected()));
        buf.append(this.getTagPreenchida("resultadocritico", this.checkResultadosCriticos.isSelected()));
        buf.append(this.getTagPreenchida("campodata", this.comboCampoData.getSelectedItem().toString()));
        buf.append(this.getTagPreenchida("datainicial", this.textDataInicial.getText()));
        buf.append(this.getTagPreenchida("datafinal", this.textDataFinal.getText()));
        buf.append(this.getTagPreenchida("horainicial", this.textHoraInicial.getText()));
        buf.append(this.getTagPreenchida("horafinal", this.textHoraFinal.getText()));
        if (this.tipoTela == 1) {
            buf.append(this.getTagPreenchida("labexterno", this.labExternos));
            buf.append(this.getTagPreenchida("trazersemresultado", this.checkTrazerSemResultado.isSelected()));
        }
        ParametrosUsuarios.setValor(this.PARAMETROS_DIGITACAO_CONFERENCIA_LOTE, buf.toString());
    }

    private String getTagPreenchida(String tag, Object valor) {
        if (tag != null) {
            String retorno = "<" + tag + ">";
            if (valor != null) {
                if (valor instanceof String[]) {
                    String[] aux = (String[])valor;
                    for (int i = 0; i < aux.length; ++i) {
                        retorno = retorno + aux[i];
                        if (i >= aux.length - 1) continue;
                        retorno = retorno + ";";
                    }
                } else if (valor instanceof Object[]) {
                    Object[] aux = (Object[])valor;
                    if (valor == this.medicos) {
                        String conselhos = "";
                        String numeros = "";
                        String ufs = "";
                        String nomes = "";
                        for (int i = 0; i < aux.length; ++i) {
                            Object[] aux2 = (Object[])aux[i];
                            conselhos = conselhos + (conselhos.length() > 0 ? ";" : "") + aux2[0].toString();
                            numeros = numeros + (numeros.length() > 0 ? ";" : "") + aux2[1].toString();
                            ufs = ufs + (ufs.length() > 0 ? ";" : "") + aux2[2].toString();
                            nomes = nomes + (nomes.length() > 0 ? ";" : "") + aux2[3].toString();
                        }
                        retorno = retorno + "<conselho>" + conselhos + "</conselho>";
                        retorno = retorno + "<numero>" + numeros + "</numero>";
                        retorno = retorno + "<uf>" + ufs + "</uf>";
                        retorno = retorno + "<nome>" + nomes + "</nome>";
                    } else if (valor == this.pacientes) {
                        String codigos = "";
                        String nomes = "";
                        for (int i = 0; i < aux.length; ++i) {
                            Object[] aux2 = (Object[])aux[i];
                            codigos = codigos + (codigos.length() > 0 ? ";" : "") + aux2[0].toString();
                            nomes = nomes + (nomes.length() > 0 ? ";" : "") + aux2[1].toString();
                        }
                        retorno = retorno + "<codigo>" + codigos + "</codigo>";
                        retorno = retorno + "<nome>" + nomes + "</nome>";
                    } else if (valor == this.convenios) {
                        String codigos = "";
                        String fantasias = "";
                        for (int i = 0; i < aux.length; ++i) {
                            Object[] aux2 = (Object[])aux[i];
                            codigos = codigos + (codigos.length() > 0 ? ";" : "") + aux2[0].toString();
                            fantasias = fantasias + (fantasias.length() > 0 ? ";" : "") + aux2[1].toString();
                        }
                        retorno = retorno + "<codigo>" + codigos + "</codigo>";
                        retorno = retorno + "<fantasia>" + fantasias + "</fantasia>";
                    } else if (valor == this.exames) {
                        String codigos = "";
                        String descricoes = "";
                        for (int i = 0; i < aux.length; ++i) {
                            Object[] aux2 = (Object[])aux[i];
                            codigos = codigos + (codigos.length() > 0 ? ";" : "") + aux2[0].toString();
                            descricoes = descricoes + (descricoes.length() > 0 ? ";" : "") + aux2[1].toString();
                        }
                        retorno = retorno + "<codigo>" + codigos + "</codigo>";
                        retorno = retorno + "<descricao>" + descricoes + "</descricao>";
                    }
                } else {
                    retorno = retorno + valor.toString();
                }
            }
            retorno = retorno + "</" + tag + ">";
            return retorno;
        }
        return null;
    }

    private String getSqlBusca(String codigoFilial, String codigoRequisicao) {
        Object[] aux;
        int i;
        this.filiais = this.itemFilial.getSelecionados();
        this.pacientes = this.itemPaciente.getSelecionadosAvancado();
        this.convenios = this.itemConvenio.getSelecionadosAvancado();
        this.medicos = this.itemMedico.getSelecionadosAvancado();
        this.situacoes = this.itemSituacao.getSelecionados();
        this.exames = this.itemExame.getSelecionadosAvancado();
        this.materiais = this.itemMaterial.getSelecionados();
        this.coletas = this.itemColeta.getSelecionados();
        this.destinos = this.itemDestino.getSelecionados();
        this.interfaces = this.itemInterface.getSelecionados();
        this.setores = this.itemSetor.getSelecionados();
        this.labExternos = this.itemLabExterno.getSelecionados();
        StringBuilder bufWhere = new StringBuilder();
        if (this.filiais == null) {
            this.filiais = new String[]{Variaveis.filialPadrao};
        }
        bufWhere.append(" and req.fil_codigo IN (");
        for (i = 0; i < this.filiais.length; ++i) {
            bufWhere.append(i > 0 ? ", " : "").append(this.filiais[i]);
        }
        bufWhere.append(") ");
        if (this.pacientes != null && this.pacientes.length > 0) {
            bufWhere.append(" and pac.pac_codigo IN (");
            for (i = 0; i < this.pacientes.length; ++i) {
                aux = (Object[])this.pacientes[i];
                bufWhere.append(i > 0 ? ", " : "").append(aux[0].toString());
            }
            bufWhere.append(") ");
        }
        if (this.convenios != null && this.convenios.length > 0) {
            bufWhere.append(" and con.con_codigo IN (");
            for (i = 0; i < this.convenios.length; ++i) {
                aux = (Object[])this.convenios[i];
                bufWhere.append(i > 0 ? ", " : "").append(aux[0].toString());
            }
            bufWhere.append(") ");
        }
        if (this.medicos != null && this.medicos.length > 0) {
            bufWhere.append(" and (med.med_conselho, med.med_crm, med.med_uf) IN (");
            for (i = 0; i < this.medicos.length; ++i) {
                aux = (Object[])this.medicos[i];
                bufWhere.append(i > 0 ? ", ('" : "('").append(aux[0].toString()).append("','").append(aux[1].toString()).append("','").append(aux[2].toString()).append("') ");
            }
            bufWhere.append(") ");
        }
        if (this.situacoes != null && this.situacoes.length > 0) {
            bufWhere.append(" and req.sit_codigo IN (");
            for (i = 0; i < this.situacoes.length; ++i) {
                bufWhere.append(i > 0 ? ", " : "").append(this.situacoes[i].toString());
            }
            bufWhere.append(") ");
        }
        if (this.exames != null && this.exames.length > 0) {
            bufWhere.append(" and exr.exa_codigo IN (");
            for (i = 0; i < this.exames.length; ++i) {
                aux = (Object[])this.exames[i];
                bufWhere.append(i > 0 ? ", '" : "'").append(aux[0].toString()).append("'");
            }
            bufWhere.append(") ");
        }
        if (this.materiais != null && this.materiais.length > 0) {
            bufWhere.append(" and exr.mco_codigo IN (");
            for (i = 0; i < this.materiais.length; ++i) {
                bufWhere.append(i > 0 ? ", " : "").append(this.materiais[i].toString());
            }
            bufWhere.append(") ");
        }
        if (this.coletas != null && this.coletas.length > 0) {
            bufWhere.append(" and col.col_codigo IN (");
            for (i = 0; i < this.coletas.length; ++i) {
                bufWhere.append(i > 0 ? ", '" : "'").append(this.coletas[i].toString()).append("'");
            }
            bufWhere.append(") ");
        }
        if (this.destinos != null && this.destinos.length > 0) {
            bufWhere.append(" and des.des_codigo IN (");
            for (i = 0; i < this.destinos.length; ++i) {
                bufWhere.append(i > 0 ? ", '" : "'").append(this.destinos[i].toString()).append("'");
            }
            bufWhere.append(") ");
        }
        if (this.interfaces != null && this.interfaces.length > 0) {
            bufWhere.append(" and int.int_codigo IN (");
            for (i = 0; i < this.interfaces.length; ++i) {
                bufWhere.append(i > 0 ? ", " : "").append(this.interfaces[i]);
            }
            bufWhere.append(") ");
        } else {
            bufWhere.append(" and (emi.emi_padrao = true OR emi.emi_padrao IS NULL) ");
        }
        if (this.setores != null && this.setores.length > 0) {
            bufWhere.append(" and ese.set_codigo IN (");
            for (i = 0; i < this.setores.length; ++i) {
                bufWhere.append(i > 0 ? ", " : "").append(this.setores[i].toString());
            }
            bufWhere.append(") ");
        }
        if (this.labExternos != null && this.labExternos.length > 0) {
            bufWhere.append(" and lotereq.lae_codigo in (");
            for (i = 0; i < this.labExternos.length; ++i) {
                bufWhere.append(i > 0 ? ", " : "").append(this.labExternos[i].toString());
            }
            bufWhere.append(") ");
            bufWhere.append(" and lotereq.ler_datahoraestorno is null");
        }
        if (this.checkSomenteAtrasados.isSelected()) {
            bufWhere.append(" and ");
            bufWhere.append(" (exr.exr_dataentregaprev < '").append(Funcoes.formataData("yyyy-MM-dd", new Date())).append("' ");
            bufWhere.append(" and ");
            bufWhere.append(" (exr.exr_situacao IS NULL OR TRIM(exr.exr_situacao) = '')) ");
        }
        if (this.tipoTela == 1 && this.checkResultadosCriticos.isSelected()) {
            bufWhere.append(" and exr.exr_dataresultadocritico IS NOT NULL ");
        }
        if (this.tipoTela == 0) {
            bufWhere.append(" and ");
            bufWhere.append(" (exr.exr_situacao IS NULL OR TRIM(exr.exr_situacao) = '')");
        } else {
            bufWhere.append(" and ");
            bufWhere.append(" (exr.exr_situacao IN ('").append("L").append("', '").append("P").append("') ");
            if (this.checkTrazerSemResultado.isSelected()) {
                bufWhere.append(" OR exr.exr_situacao IS NULL OR TRIM(exr.exr_situacao) = '' ");
            }
            bufWhere.append(" ) ");
        }
        String[] camposBanco = null;
        if (!Funcoes.textoVazio(this.textDataInicial)) {
            bufWhere.append(" and ");
            if (Funcoes.textoVazio(this.textHoraInicial)) {
                camposBanco = this.tipoTela == 0 ? this.CAMPOS_BANCO_SEM_HORARIO_DIGITACAO : this.CAMPOS_BANCO_SEM_HORARIO_CONFERENCIA;
                bufWhere.append(camposBanco[this.comboCampoData.getSelectedIndex()]).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append("' ");
            } else {
                String[] stringArray = camposBanco = this.tipoTela == 0 ? this.CAMPOS_BANCO_COM_HORARIO_DIGITACAO : this.CAMPOS_BANCO_COM_HORARIO_CONFERENCIA;
                if (this.comboCampoData.getSelectedIndex() == 0) {
                    bufWhere.append(camposBanco[this.comboCampoData.getSelectedIndex()]).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append("' ");
                    bufWhere.append(" and req.req_hora >= '").append(Funcoes.formataDataHora("HH:mm", this.textHoraInicial.getText())).append("' ");
                } else {
                    bufWhere.append(camposBanco[this.comboCampoData.getSelectedIndex()]).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText()) + " " + Funcoes.formataDataHora("HH:mm", this.textHoraInicial.getText())).append("' ");
                }
            }
        }
        if (!Funcoes.textoVazio(this.textDataFinal)) {
            bufWhere.append(" and ");
            if (Funcoes.textoVazio(this.textHoraFinal)) {
                camposBanco = this.tipoTela == 0 ? this.CAMPOS_BANCO_SEM_HORARIO_DIGITACAO : this.CAMPOS_BANCO_SEM_HORARIO_CONFERENCIA;
                bufWhere.append(camposBanco[this.comboCampoData.getSelectedIndex()]).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append("' ");
            } else {
                String[] stringArray = camposBanco = this.tipoTela == 0 ? this.CAMPOS_BANCO_COM_HORARIO_DIGITACAO : this.CAMPOS_BANCO_COM_HORARIO_CONFERENCIA;
                if (this.comboCampoData.getSelectedIndex() == 0) {
                    bufWhere.append(camposBanco[this.comboCampoData.getSelectedIndex()]).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append("' ");
                    bufWhere.append(" and req.req_hora <= '").append(Funcoes.formataDataHora("HH:mm", this.textHoraFinal.getText())).append("' ");
                } else {
                    bufWhere.append(camposBanco[this.comboCampoData.getSelectedIndex()]).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText()) + " " + Funcoes.formataDataHora("HH:mm", this.textHoraFinal.getText())).append("' ");
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT ");
        buf.append(" \t\ttab.filial, tab.codigoRequisicao, tab.requisicaoUrgente, tab.nomePaciente, tab.descricaoColeta, ");
        if (this.ocultarConvenio) {
            buf.append("      'Visualiza\u00e7\u00e3o n\u00e3o permitida' as fantasiaConvenio, ");
        } else {
            buf.append("tab.fantasiaConvenio,");
        }
        buf.append(" \t\tarray_agg(exames) as exames, ");
        buf.append(" \t\tarray_agg(COALESCE(tab.situacoes, '')) AS situacoes,  ");
        buf.append(" \t\tArray_agg(Coalesce(tab.examesUrgente, FALSE)) AS examesUrgente, ");
        buf.append(" \t\tarray_to_string(array_agg(tab.setores), ',') AS setores, ");
        buf.append(" \t\tarray_to_string(array_agg(tab.paginas), ',') AS paginas, ");
        buf.append(" \t\tarray_to_string(array_agg(tab.ordens), ',') AS ordens, ");
        buf.append(" \t\tarray_to_string(array_agg(tab.materiais), ',') AS materiais ");
        buf.append(" FROM ");
        buf.append(" \t\t(SELECT ");
        buf.append(" \t\t\t\t req.fil_codigo as filial ");
        buf.append("       \t,req.req_codigo as codigoRequisicao ");
        if (!this.ocultarConvenio) {
            buf.append("        ,con.con_fantasia as fantasiaConvenio ");
        }
        buf.append("       \t,COALESCE(req.req_urgente, FALSE) as requisicaoUrgente ");
        buf.append("       \t,pac.pac_nome as nomePaciente ");
        buf.append("      \t,col.col_descricao as descricaoColeta ");
        buf.append("       \t,exr.exa_codigo as exames ");
        buf.append("       \t,COALESCE(exr.exr_situacao, '') AS situacoes ");
        buf.append("       \t,Coalesce(exr.exr_urgente, FALSE) AS examesUrgente ");
        buf.append("       \t,ese.set_codigo AS setores ");
        buf.append("       \t,emc.emc_pagina AS paginas ");
        buf.append("       \t,emc.emc_ordem AS ordens ");
        buf.append("       \t,exr.mco_codigo AS materiais ");
        buf.append("   FROM requisicao req ");
        buf.append("   \t\t\tJOIN examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   \t\t\tJOIN examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append(" \t \t\t\tJOIN convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append(" \t \t\t\tJOIN medico med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_uf = med.med_uf and req.med_crm = med.med_crm ");
        buf.append("   \t\t\tJOIN coletas col on req.fil_codigo = col.fil_codigo and upper(req.col_codigo) = upper(col.col_codigo) ");
        buf.append("   \t\t\tJOIN destino des on req.fil_codigo = des.fil_codigo and upper(req.des_codigo) = upper(des.des_codigo) ");
        buf.append("   \t\t\tJOIN paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("\t \t\t\tLEFT JOIN examematinterface emi on emc.fil_codigo = emi.fil_codigo and emc.exa_codigo = emi.exa_codigo and emc.mco_codigo = emi.mco_codigo ");
        buf.append("\t \t\t\tLEFT JOIN interface int on emi.fil_codigo = int.fil_codigo and emi.int_codigo = int.int_codigo ");
        buf.append("   \t\t\tLEFT JOIN situacao sit on req.fil_codigo = sit.fil_codigo and req.sit_codigo = sit.sit_codigo ");
        buf.append("   \t\t\tLEFT JOIN examesetor ese on exr.fil_codigo = ese.fil_codigo and exr.exa_codigo = ese.exa_codigo and ese.ese_default ");
        buf.append("\t      LEFT JOIN loteexternoexamerequisicao lotereq on exr.fil_codigo = lotereq.fil_codigo and exr.exa_codigo = lotereq.exa_codigo and exr.mco_codigo = lotereq.mco_codigo and req.req_codigo = lotereq.req_codigo  ");
        buf.append("  WHERE req.req_excluida = false ");
        buf.append("    AND exr.exr_excluido = false ");
        if (!Funcoes.textoVazio(codigoRequisicao)) {
            buf.append("  AND req.req_codigo = ").append(codigoRequisicao);
        }
        if (!Funcoes.textoVazio(codigoFilial)) {
            buf.append("  AND req.fil_codigo = ").append(codigoFilial);
        }
        if (bufWhere.length() > 0) {
            buf.append(bufWhere.toString());
        }
        buf.append("  GROUP BY ");
        buf.append(" \t\t\t\treq.fil_codigo ");
        buf.append("       ,req.req_codigo ");
        buf.append("       ,req.req_urgente ");
        buf.append("       ,pac.pac_nome ");
        buf.append("       ,col.col_descricao ");
        buf.append("       ,con.con_fantasia ");
        buf.append(" \t\t\t ,req.fil_codigo ");
        buf.append("\t\t\t ,req.req_codigo ");
        buf.append("\t\t\t ,req.req_urgente ");
        buf.append("\t\t\t ,pac.pac_nome ");
        buf.append("\t\t\t ,col.col_descricao ");
        buf.append("\t\t\t ,con.con_fantasia ");
        buf.append("\t\t\t ,exr.exa_codigo ");
        buf.append("\t\t\t ,exr.exr_situacao ");
        buf.append("\t\t\t ,exr.exr_urgente ");
        buf.append("\t\t\t ,ese.set_codigo ");
        buf.append("\t\t\t ,emc.emc_pagina ");
        buf.append("\t\t\t ,emc.emc_ordem ");
        buf.append("\t\t\t ,exr.mco_codigo ");
        buf.append("  ORDER BY  ");
        buf.append(" \t\t\treq.fil_codigo ");
        buf.append("      ,req.req_codigo ");
        buf.append("      ,req.req_urgente ");
        buf.append(" \t\t\t,exames) as tab ");
        buf.append(" group by  ");
        buf.append(" \t\t\ttab.filial, ");
        buf.append(" \t\t \ttab.codigoRequisicao, ");
        buf.append(" \t\t\ttab.requisicaoUrgente, ");
        buf.append(" \t\t\ttab.nomePaciente, ");
        buf.append(" \t\t\ttab.descricaoColeta, ");
        buf.append(" \t\t\tfantasiaConvenio ");
        buf.append(" ORDER BY tab.filial, ");
        buf.append("\t\t tab.codigorequisicao,");
        buf.append("\t\t tab.requisicaourgente ");
        return buf.toString();
    }

    private void preencheValores(ResultSet rs) throws SQLException {
        this.modeloExame.clear();
        if (rs != null) {
            while (rs.next()) {
                Array exames = rs.getArray("exames");
                Array situacoes = rs.getArray("situacoes");
                Array examesUrgente = rs.getArray("examesUrgente");
                String setores = rs.getString("setores");
                String paginas = rs.getString("paginas");
                String ordens = rs.getString("ordens");
                String materiais = rs.getString("materiais");
                ArrayList<Integer> listaSetores = new ArrayList<Integer>();
                StringTokenizer tokenizer = new StringTokenizer(setores, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    listaSetores.add(Integer.parseInt(tokenizer.nextToken()));
                }
                ArrayList<Integer> listaPaginas = new ArrayList<Integer>();
                tokenizer = new StringTokenizer(paginas, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    listaPaginas.add(Integer.parseInt(tokenizer.nextToken()));
                }
                ArrayList<Integer> listaOrdens = new ArrayList<Integer>();
                tokenizer = new StringTokenizer(ordens, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    listaOrdens.add(Integer.parseInt(tokenizer.nextToken()));
                }
                ArrayList<Integer> listaMateriais = new ArrayList<Integer>();
                tokenizer = new StringTokenizer(materiais, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    listaMateriais.add(Integer.parseInt(tokenizer.nextToken()));
                }
                if (exames == null || situacoes == null) continue;
                ListaObjetoExame lista = new ListaObjetoExame(this.getArrayExameSituacao((String[])exames.getArray(), (String[])situacoes.getArray(), listaSetores.toArray(new Integer[0]), listaPaginas.toArray(new Integer[0]), listaOrdens.toArray(new Integer[0]), listaMateriais.toArray(new Integer[0]), (Boolean[])examesUrgente.getArray()));
                String codigo = Funcoes.preencheZero(rs.getInt("filial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(String.valueOf(rs.getInt("codigoRequisicao")), ParametrosGerais.getDigitosTuboRequisicao());
                String nomePaciente = rs.getString("nomePaciente");
                if (this.visualizarNomePaciente()) {
                    nomePaciente = "Visualiza\u00e7\u00e3o n\u00e3o permitida";
                }
                this.modeloExame.addLine(new Object[]{codigo, nomePaciente, rs.getString("descricaoColeta"), rs.getString("fantasiaConvenio"), lista, rs.getString("filial"), rs.getString("codigoRequisicao"), rs.getBoolean("requisicaoUrgente")});
            }
        }
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 2 && !this.isBuscando;
        this.itemFilial.setEnabled(enabled);
        this.itemPaciente.setEnabled(enabled);
        this.itemConvenio.setEnabled(enabled);
        this.itemMedico.setEnabled(enabled);
        this.itemSituacao.setEnabled(enabled);
        this.itemExame.setEnabled(enabled);
        this.itemMaterial.setEnabled(enabled);
        this.itemColeta.setEnabled(enabled);
        this.itemDestino.setEnabled(enabled);
        this.itemSetor.setEnabled(enabled);
        this.itemLabExterno.setEnabled(enabled);
        this.itemInterface.setEnabled(enabled);
        this.textDataInicial.setEnabled(enabled);
        this.textDataFinal.setEnabled(enabled);
        this.textHoraInicial.setEnabled(enabled);
        this.textHoraFinal.setEnabled(enabled);
        this.textLocalizar.setEnabled(enabled);
        this.buttonDataInicial.setEnabled(enabled);
        this.buttonDataFinal.setEnabled(enabled);
        this.buttonFiltrar.setEnabled(enabled);
        this.buttonFecharLocalizar.setEnabled(enabled);
        this.checkSomenteAtrasados.setEnabled(enabled);
        this.checkResultadosCriticos.setEnabled(enabled);
        this.checkTrazerSemResultado.setEnabled(enabled);
        this.comboCampoData.setEnabled(enabled);
        this.tableExames.setEnabled(enabled);
        this.split.setEnabled(enabled);
        this.tableExames.setEnabled(enabled);
        this.botaoFechar.setEnabled(!this.isBuscando);
    }

    private ObjetoExame[] getArrayExameSituacao(String[] exame, String[] situacao, Integer[] setor, Integer[] pagina, Integer[] ordem, Integer[] material, Boolean[] examesUrgente) {
        if (exame != null && situacao != null) {
            ObjetoExame[] lista = new ObjetoExame[exame.length];
            for (int i = 0; i < exame.length; ++i) {
                lista[i] = new ObjetoExame(exame[i], situacao[i], setor[i], pagina[i], ordem[i], material[i], examesUrgente[i]);
            }
            return lista;
        }
        return null;
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.textLocalizar) {
            this.localizar();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.tableExames || e.getSource() == this.textLocalizar) {
            if (e.getKeyCode() == 113) {
                boolean isVisible = this.panelLocalizar.isVisible();
                this.panelLocalizar.setVisible(!isVisible);
                if (!isVisible) {
                    ScreenUtil.requisitarFoco(this.textLocalizar);
                } else {
                    ScreenUtil.requisitarFoco(this.tableExames);
                }
            } else if (e.getKeyCode() == 32) {
                this.row = this.tableExames.getSelectedRow();
                if (this.row > -1) {
                    this.invocaDigitacaoConferencia();
                }
            }
        } else if (e.getSource() == this.textLocalizar) {
            if (e.getKeyCode() == 27) {
                this.panelLocalizar.setVisible(false);
                ScreenUtil.requisitarFoco(this.tableExames);
            }
        } else if (e.getSource() == this.textDataInicial) {
            if (e.getKeyCode() == 113) {
                this.buttonDataInicial.doClick();
            }
        } else if (e.getSource() == this.textDataFinal && e.getKeyCode() == 113) {
            this.buttonDataFinal.doClick();
        }
    }

    private void invocaDigitacaoConferencia() {
        JDialog dialog = new JDialog();
        GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)this.getRootPane().getGlassPane();
        dialog.setGlassPane(glassPaneMensagem);
        DigitacaoConferencia digitacaoConferencia = new DigitacaoConferencia(this.tipoTela, true, dialog, this, glassPaneMensagem);
        String[] listaExames = null;
        if (this.exames != null && this.exames.length > 0) {
            listaExames = new String[this.exames.length];
            for (int i = 0; i < this.exames.length; ++i) {
                listaExames[i] = (String)((Object[])this.exames[i])[0];
            }
        }
        digitacaoConferencia.carregarDadosConferenciaDigitacaoLote((String)this.modeloExame.getValueAt(this.row, 5), (String)this.modeloExame.getValueAt(this.row, 6), listaExames, this.materiais);
        if (this.tipoTela == 0) {
            dialog.setTitle("Digita\u00e7\u00e3o");
        } else {
            dialog.setTitle("Confer\u00eancia");
        }
        dialog.setModal(true);
        dialog.setSize(790, 590);
        dialog.setMinimumSize(new Dimension(790, 590));
        dialog.setContentPane(digitacaoConferencia);
        dialog.setLocationRelativeTo(Laboratorio.getInstancia());
        int rowAtual = this.row;
        dialog.setVisible(true);
        this.getRootPane().setGlassPane(glassPaneMensagem);
        while (rowAtual <= this.row && rowAtual < this.modeloExame.getRowCount()) {
            String sql = this.getSqlBusca((String)this.modeloExame.getValueAt(rowAtual, 5), (String)this.modeloExame.getValueAt(rowAtual, 6));
            boolean manterRequisicao = false;
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql);
                while (rs.next()) {
                    Array exames = rs.getArray("exames");
                    Array situacoes = rs.getArray("situacoes");
                    Array examesUrgente = rs.getArray("examesUrgente");
                    String setores = rs.getString("setores");
                    String paginas = rs.getString("paginas");
                    String ordens = rs.getString("ordens");
                    String materiais = rs.getString("materiais");
                    ArrayList<Integer> listaSetores = new ArrayList<Integer>();
                    StringTokenizer tokenizer = new StringTokenizer(setores, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        listaSetores.add(Integer.parseInt(tokenizer.nextToken()));
                    }
                    ArrayList<Integer> listaPaginas = new ArrayList<Integer>();
                    tokenizer = new StringTokenizer(paginas, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        listaPaginas.add(Integer.parseInt(tokenizer.nextToken()));
                    }
                    ArrayList<Integer> listaOrdens = new ArrayList<Integer>();
                    tokenizer = new StringTokenizer(ordens, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        listaOrdens.add(Integer.parseInt(tokenizer.nextToken()));
                    }
                    ArrayList<Integer> listaMateriais = new ArrayList<Integer>();
                    tokenizer = new StringTokenizer(materiais, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        listaMateriais.add(Integer.parseInt(tokenizer.nextToken()));
                    }
                    if (exames == null || situacoes == null) continue;
                    ListaObjetoExame lista = new ListaObjetoExame(this.getArrayExameSituacao((String[])exames.getArray(), (String[])situacoes.getArray(), listaSetores.toArray(new Integer[0]), listaPaginas.toArray(new Integer[0]), listaOrdens.toArray(new Integer[0]), listaMateriais.toArray(new Integer[0]), (Boolean[])examesUrgente.getArray()));
                    String codigo = Funcoes.preencheZero(rs.getInt("filial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(String.valueOf(rs.getInt("codigoRequisicao")), ParametrosGerais.getDigitosTuboRequisicao());
                    this.modeloExame.setValueAt(codigo, rowAtual, 0);
                    this.modeloExame.setValueAt(rs.getString("nomePaciente"), rowAtual, 1);
                    if (this.visualizarNomePaciente()) {
                        this.modeloExame.setValueAt("Visualiza\u00e7\u00e3o n\u00e3o permitida", rowAtual, 1);
                    }
                    this.modeloExame.setValueAt(rs.getString("descricaoColeta"), rowAtual, 2);
                    this.modeloExame.setValueAt(rs.getString("fantasiaConvenio"), rowAtual, 3);
                    this.modeloExame.setValueAt(lista, rowAtual, 4);
                    this.modeloExame.setValueAt(rs.getString("filial"), rowAtual, 5);
                    this.modeloExame.setValueAt(rs.getString("codigoRequisicao"), rowAtual, 6);
                    manterRequisicao = true;
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar a situa\u00e7\u00e3o da requisi\u00e7\u00e3o." + e.getMessage(), e.getStackTrace());
                return;
            }
            if (!manterRequisicao) {
                this.modeloExame.removeLine(rowAtual);
                --this.row;
                continue;
            }
            ++rowAtual;
        }
        this.modeloExame.ordenarColunaSemTrocarSentido(this.modeloExame.getColunaOrdenacao());
        this.tableExames.getSelectionModel().setSelectionInterval(rowAtual, rowAtual);
        ScreenUtil.requisitarFoco(this.tableExames);
    }

    private static DigitacaoConferenciaLote getInstancia() {
        return null;
    }

    private boolean visualizarNomePaciente() {
        return Acesso.getAcesso(Long.valueOf("0400100201")) && this.tipoTela == 0 || Acesso.getAcesso(Long.valueOf("0400300201")) && this.tipoTela == 1;
    }

    private void localizar() {
        String texto = this.textLocalizar.getText();
        int row = -1;
        row = this.modeloExame.getColunaOrdenacao() == 4 ? this.modeloExame.localizarContendo(this.modeloExame.getColunaOrdenacao(), texto) : this.modeloExame.localizarParcial(this.modeloExame.getColunaOrdenacao(), texto);
        if (row > -1) {
            Rectangle rect = this.tableExames.getCellRect(row, 0, true);
            this.tableExames.getSelectionModel().setSelectionInterval(row, row);
            this.tableExames.scrollRectToVisible(rect);
        }
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isBuscando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isBuscando = false;
        this.controlaCampos();
    }

    class ArrayExamesRenderer
    extends DefaultTableCellRenderer {
        ArrayExamesRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object[] linha = DigitacaoConferenciaLote.this.modeloExame.getLineValue(row);
            StringBuilder bufValor = new StringBuilder();
            Boolean requisicaoUrgente = (Boolean)linha[7];
            ArrayList<ObjetoExame> examesUrgentes = ((ListaObjetoExame)linha[4]).getExamesUrgente();
            if (value != null && value instanceof ListaObjetoExame) {
                ObjetoExame[] aux = ((ListaObjetoExame)value).getListaExames();
                StringBuilder bufToolTip = new StringBuilder();
                bufValor.append("<html>");
                bufToolTip.append("<html>");
                bufToolTip.append("<b>Pressione F2 para localizar</b><br>");
                bufToolTip.append(DigitacaoConferenciaLote.this.MENSAGEM_DIGITACAO_CONFERENCIA);
                for (int i = 0; i < aux.length; ++i) {
                    ObjetoExame exameSituacao = aux[i];
                    if (requisicaoUrgente.booleanValue() && examesUrgentes.size() == 0) {
                        exameSituacao.examesUrgente = true;
                    }
                    bufValor.append(exameSituacao.toString());
                    bufToolTip.append(exameSituacao.toString());
                    if (i >= aux.length - 1) continue;
                    bufValor.append(", ");
                    bufToolTip.append(", ");
                }
                bufValor.append("</html>");
                bufToolTip.append("</html>");
                ((JLabel)comp).setText(bufValor.toString());
                table.setToolTipText(bufToolTip.toString());
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("<html>");
                buf.append("<b>Pressione F2 para localizar</b><br>");
                buf.append(DigitacaoConferenciaLote.this.MENSAGEM_DIGITACAO_CONFERENCIA);
                if (value != null) {
                    buf.append(value.toString());
                }
                buf.append("</html>");
                if (requisicaoUrgente.booleanValue() || examesUrgentes.size() > 0) {
                    bufValor.append("<html>");
                    StringBuilder bufFonte = new StringBuilder();
                    bufFonte.append("<font style=\"color:rgb(").append(Tipos.COR_URGENTE[0].getRed()).append(",").append(Tipos.COR_URGENTE[0].getGreen()).append(",").append(Tipos.COR_URGENTE[0].getBlue()).append(")\">");
                    bufValor.append(bufFonte.toString());
                    bufValor.append(value.toString());
                    bufValor.append("</html>");
                    ((JLabel)comp).setText(bufValor.toString());
                } else {
                    comp.setForeground(Tipos.COR_DEFAULT_TEXTO[0]);
                }
                table.setToolTipText(buf.toString());
            }
            return comp;
        }
    }

    class ObjetoExame
    implements Comparable {
        String exame = null;
        String situacao = null;
        Integer setor = null;
        Integer pagina = null;
        Integer ordem = null;
        Integer material = null;
        Boolean examesUrgente = null;

        public ObjetoExame(String exame, String situacao, Integer setor, Integer pagina, Integer ordem, Integer material, Boolean examesUrgente) {
            this.exame = exame;
            this.situacao = situacao;
            this.setor = setor;
            this.pagina = pagina;
            this.ordem = ordem;
            this.material = material;
            this.examesUrgente = examesUrgente;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("<font style=\"");
            if (this.situacao.equalsIgnoreCase("L")) {
                buf.append("background:rgb(").append(Tipos.COR_LANCADO[0].getRed()).append(",").append(Tipos.COR_LANCADO[0].getGreen()).append(",").append(Tipos.COR_LANCADO[0].getBlue()).append(");");
            } else if (this.situacao.equalsIgnoreCase("P")) {
                buf.append("background:rgb(").append(Tipos.COR_SALVO_PARCIAL[0].getRed()).append(",").append(Tipos.COR_SALVO_PARCIAL[0].getGreen()).append(",").append(Tipos.COR_SALVO_PARCIAL[0].getBlue()).append(");");
            }
            if (this.examesUrgente.booleanValue()) {
                buf.append(" color:rgb(").append(Tipos.COR_URGENTE[0].getRed()).append(",").append(Tipos.COR_URGENTE[0].getGreen()).append(",").append(Tipos.COR_URGENTE[0].getBlue()).append(")");
            }
            buf.append("\">");
            buf.append(this.exame);
            buf.append("</font>");
            return buf.toString();
        }

        public int compareTo(Object o) {
            ObjetoExame aux = (ObjetoExame)o;
            int compare = 0;
            compare = this.setor.compareTo(aux.setor);
            if (compare != 0) {
                return compare;
            }
            compare = this.pagina.compareTo(aux.pagina);
            if (compare != 0) {
                return compare;
            }
            compare = this.ordem.compareTo(aux.ordem);
            if (compare != 0) {
                return compare;
            }
            compare = this.exame.compareTo(aux.exame);
            if (compare != 0) {
                return compare;
            }
            compare = this.material.compareTo(aux.material);
            if (compare != 0) {
                return compare;
            }
            compare = this.examesUrgente.compareTo(aux.examesUrgente);
            return compare;
        }
    }

    class ListaObjetoExame {
        private ObjetoExame[] listaExames = null;

        public ListaObjetoExame(ObjetoExame ... listaExames) {
            this.listaExames = listaExames;
            ArrayList<ObjetoExame> listaAux = new ArrayList<ObjetoExame>();
            for (ObjetoExame aux : listaExames) {
                listaAux.add(aux);
            }
            Collections.sort(listaAux);
            this.listaExames = new ObjetoExame[listaAux.size()];
            for (int i = 0; i < listaAux.size(); ++i) {
                this.listaExames[i] = (ObjetoExame)listaAux.get(i);
            }
        }

        public String toString() {
            String aux = "";
            if (this.listaExames != null) {
                for (int i = 0; i < this.listaExames.length; ++i) {
                    if (!Funcoes.textoVazio(aux)) {
                        aux = aux + ", ";
                    }
                    aux = aux + this.listaExames[i].exame;
                }
            }
            return aux;
        }

        public ObjetoExame[] getListaExames() {
            return this.listaExames;
        }

        public ArrayList<ObjetoExame> getExamesUrgente() {
            ArrayList<ObjetoExame> examesUrgentes = new ArrayList<ObjetoExame>();
            for (ObjetoExame obj : this.listaExames) {
                if (!obj.examesUrgente.booleanValue()) continue;
                examesUrgentes.add(obj);
            }
            return examesUrgentes;
        }
    }
}

