/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.rendering.PDFRenderer;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.relatorio.gerador.DialogoImpressao;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.axis.encoding.Base64;

public class DialogoVisualizarResultadoPdf
extends JDialog
implements ActionListener {
    public static JPanel panelPrincipal;
    private static String titulo;
    private JButton botaoOk = ComponenteFactory.novoJButton("OK", 'O', null, null, null);
    private JButton botaoImprimir = ComponenteFactory.novoJButton("Imprimir", 'O', null, null, null);
    private JButton botaoFechar = ComponenteFactory.novoJButton("Fechar", 'O', null, null, null);
    private String cabecalhoImpressaoSistema = "";
    private ExameMaterialPagina exameMaterialPagina;
    private static boolean isRequisicao;
    private byte[] byteArray;
    private String impressoraSelecionada;

    public static DialogoVisualizarResultadoPdf novaInstancia(Object pai, boolean isAnexo) {
        titulo = isAnexo ? "Visualizar anexo" : "Visualizar Resultado";
        isRequisicao = isAnexo;
        if (pai instanceof Dialog) {
            return new DialogoVisualizarResultadoPdf((Dialog)pai);
        }
        return new DialogoVisualizarResultadoPdf((Frame)pai);
    }

    public DialogoVisualizarResultadoPdf() {
        this.setTitle(titulo);
    }

    public DialogoVisualizarResultadoPdf(Dialog pai) {
        this.montaTela();
    }

    public DialogoVisualizarResultadoPdf(Frame pai) {
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setTitle(titulo);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.setSize(new Dimension(750, 700));
        panelPrincipal = new JPanel();
        panelPrincipal.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(panelPrincipal);
        scroll.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)scroll, "Center");
        this.botaoOk.setPreferredSize(new Dimension(40, 20));
        this.botaoImprimir.setPreferredSize(new Dimension(70, 20));
        this.botaoFechar.setPreferredSize(new Dimension(70, 20));
        this.botaoOk.addActionListener(this);
        this.botaoFechar.addActionListener(this);
        this.botaoImprimir.addActionListener(this);
        JPanel panelBotao = new JPanel();
        panelBotao.setLayout(new BorderLayout());
        if (!isRequisicao) {
            panelBotao = ComponenteFactory.novoJPanelFlowLayout(2, this.botaoOk);
            this.add((Component)panelBotao, "South");
        } else {
            panelBotao = ComponenteFactory.novoJPanelFlowLayout(2, this.botaoImprimir, this.botaoFechar);
            this.add((Component)panelBotao, "South");
        }
        this.setLocationRelativeTo(Laboratorio.getInstancia());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.dispose();
        }
        if (e.getSource() == this.botaoFechar) {
            this.dispose();
        }
        if (e.getSource() == this.botaoImprimir) {
            Digitacao dig = new Digitacao();
            Documento doc = new Documento();
            if (!Funcoes.textoVazio(this.cabecalhoImpressaoSistema)) {
                doc.setCabecalhoRodape(this.cabecalhoImpressaoSistema);
            }
            doc.setCopias(1);
            this.exameMaterialPagina = new ExameMaterialPagina("", -1, null);
            doc.addResultados(new ExameMaterialPagina[]{this.exameMaterialPagina}, new String[]{dig.getResultado()});
            Impressao imp = new Impressao(this.selecionarImpressora());
            imp.imprimirDocument(this.byteArray);
        }
    }

    private String selecionarImpressora() {
        String impressoraPadraoSistema = "";
        if (Funcoes.textoVazio(this.impressoraSelecionada) && !ParametrosLocais.isTrue("imprimirCapaLaudo")) {
            DialogoImpressao digImp = DialogoImpressao.novaInstancia(Laboratorio.getInstancia(), "Impress\u00e3o de resultados", false);
            digImp.setVisible(true);
            this.impressoraSelecionada = digImp.ok() ? digImp.getImpressoraSelecionada() : "";
            digImp.dispose();
        }
        impressoraPadraoSistema = this.impressoraSelecionada;
        return impressoraPadraoSistema;
    }

    public void setPDf(String pdf) throws IOException {
        byte[] b = Base64.decode((String)pdf);
        panelPrincipal.add((Component)this.setup(b), "Center");
        this.byteArray = b;
    }

    private JLabel setup(byte[] b) throws IOException {
        JLabel pdf = null;
        PDDocument pdDocument = PDDocument.load((byte[])b);
        PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
        BufferedImage joinBufferedImage = new BufferedImage(10, 10, 2);
        for (int i = 0; i < pdDocument.getNumberOfPages(); ++i) {
            BufferedImage bImage = pdfRenderer.renderImage(i);
            joinBufferedImage = this.mesclarImagemDoPDF(joinBufferedImage, bImage);
        }
        pdf = new JLabel(new ImageIcon(joinBufferedImage));
        pdDocument.close();
        return pdf;
    }

    public BufferedImage mesclarImagemDoPDF(BufferedImage img1, BufferedImage img2) {
        int largura = Math.max(img1.getWidth(), img2.getWidth());
        int altura = img1.getHeight() + img2.getHeight();
        BufferedImage newImage = new BufferedImage(largura, altura, 1);
        Graphics2D g2 = newImage.createGraphics();
        Color corOriginal = g2.getColor();
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, largura, altura);
        g2.setColor(corOriginal);
        g2.drawImage(img1, null, 0, 0);
        g2.drawImage(img2, null, 0, img1.getHeight());
        g2.dispose();
        return newImage;
    }

    static {
        titulo = "";
    }
}

