/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.resultados.ValidarXMLAssinado;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class DialogoResultadosHash
extends AbstractDialogoOKCancelar {
    private static final String DADOS_ASSINATURA = "X509SubjectName";
    private static final String EM_BRANCO = "EM BRANCO";
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JTabbedPane tabbedExames = new JTabbedPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            for (int i = 0; i < this.getTabCount(); ++i) {
                Registro exa = new Registro();
                Rectangle rec = this.getBoundsAt(i);
                if (exa == null || rec == null) continue;
                g.setColor(Tipos.getCorSituacaoExame(exa.getString("exr_situacao"))[0]);
                g.fillRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
                g.setColor(Color.black);
                g.drawRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
            }
        }
    };
    private JPanel panelDadosHash = new JPanel(new GridBagLayout());
    private ModeloGridTable modeloHash = new ModeloGridTable(new String[]{""});
    private JTable tabelaHash = new JTable(this.modeloHash);
    private JPanel panelHash = ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", new JScrollPane(this.tabelaHash));
    private JLabel labelHash = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private JLabel labelDadosAssinatura = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private JLabel labelXMLValido = new JLabel("");
    private final int COLUNA_VISUAL = 0;
    private final int COLUNA_DATA = 1;
    private final int COLUNA_USUARIO_CODIGO = 2;
    private final int COLUNA_HASH = 3;
    private final int COLUNA_LAUDO = 4;
    private String codigoExame = "";
    private String codigoMaterial = "";
    private String codigoRequisicao = "";
    private String codigoFilial = Variaveis.filialPadrao;

    public DialogoResultadosHash(Dialog pai, String titulo, String exame, String material) {
        super(pai, titulo);
        this.iniciar(exame, material);
    }

    public DialogoResultadosHash(Frame pai, String titulo, String exame, String material) {
        super(pai, titulo);
        this.iniciar(exame, material);
    }

    public static DialogoResultadosHash novaInstancia(Object owner, String exame, String material) {
        if (owner instanceof Frame) {
            return new DialogoResultadosHash((Frame)owner, "Resultados Hash", exame, material);
        }
        return new DialogoResultadosHash((Dialog)owner, "Resultados Hash", exame, material);
    }

    private void iniciar(String exame, String material) {
        this.codigoExame = exame;
        this.codigoMaterial = material;
        this.setSize(new Dimension(750, 550));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(true);
        this.modeloHash.setColumnSize(new int[]{80, 0}, this.tabelaHash);
        this.tabelaHash.setRowHeight(40);
        this.tabelaHash.setDefaultRenderer(Object.class, new RenderResultadosHash());
        this.tabbedExames.setTabLayoutPolicy(1);
        this.getBotaoCancelar().setVisible(false);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelHash.setPreferredSize(new Dimension(200, 100));
        this.panelHash.setMinimumSize(this.panelHash.getPreferredSize());
        panelCentro.add((Component)this.panelHash, "West");
        panelCentro.add((Component)this.panelExames, "Center");
        JPanel PanelEsquerda = this.getPanelBotoesEsquerda();
        this.labelXMLValido.setPreferredSize(new Dimension(400, 25));
        this.labelXMLValido.setMinimumSize(this.labelXMLValido.getPreferredSize());
        this.labelXMLValido.setVisible(false);
        this.labelXMLValido.setForeground(Color.RED);
        PanelEsquerda.add((Component)this.labelXMLValido, "West");
        this.tabelaHash.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DialogoResultadosHash.this.carregaLaudo(DialogoResultadosHash.this.tabelaHash.getSelectedRow());
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 0, 1);
        this.panelDadosHash.add((Component)new JLabel("Hash:"), c);
        c.gridx = 1;
        c.fill = 2;
        this.labelHash.setPreferredSize(new Dimension(100, 20));
        this.labelHash.setMinimumSize(this.labelHash.getPreferredSize());
        this.panelDadosHash.add((Component)this.labelHash, c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelDadosHash.add((Component)new JLabel("Inf. Ass.:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.labelDadosAssinatura.setPreferredSize(new Dimension(100, 120));
        this.labelDadosAssinatura.setMinimumSize(this.labelDadosAssinatura.getPreferredSize());
        this.panelDadosHash.add((Component)this.labelDadosAssinatura, c);
    }

    private void carregaLaudo(int linha) {
        if (this.tabelaHash.getRowCount() > linha) {
            this.panelExames.removeAll();
            String xml = this.modeloHash.getValueAt(linha, 4).toString();
            String dadosAssintura = StringUtil.getValor(xml, DADOS_ASSINATURA);
            this.labelHash.setText(this.modeloHash.getValueAt(linha, 3).toString());
            StringBuilder info = new StringBuilder();
            if (!Funcoes.textoVazio(dadosAssintura)) {
                String[] dados;
                info.append("<html>");
                for (String s : dados = dadosAssintura.split(",")) {
                    if (s.toUpperCase().contains(EM_BRANCO)) continue;
                    info.append(s.substring(s.indexOf("=") + 1)).append("<br>");
                }
                info.append("</html>");
            }
            this.labelDadosAssinatura.setText(info.toString());
            final Digitacao dig = new Digitacao();
            dig.carregarCampos(this.modeloHash.getValueAt(linha, 4).toString());
            dig.exibirBotaoFechar(false);
            dig.exibirBotaoImprimir(false);
            dig.exibirBotaoSalvar(false);
            dig.exibirBotaoSalvarParcial(false);
            dig.exibirCheckBoxImprimir(false);
            this.panelExames.removeAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogoResultadosHash.this.panelExames.add((Component)DialogoResultadosHash.this.panelDadosHash, "North");
                    DialogoResultadosHash.this.panelExames.add((Component)dig, "Center");
                    DialogoResultadosHash.this.panelExames.revalidate();
                    DialogoResultadosHash.this.panelExames.repaint();
                }
            });
            try {
                if (!ValidarXMLAssinado.validaXML(xml, this.codigoFilial, this.codigoRequisicao, this.codigoExame, this.codigoMaterial)) {
                    this.labelXMLValido.setText(" A assinatura do XML de resultado n\u00e3o \u00e9 v\u00e1lida.");
                    this.labelXMLValido.setVisible(true);
                } else {
                    this.labelXMLValido.setText("");
                    this.labelXMLValido.setVisible(false);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel validar XML.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPaciente(Window owner, Statement st, String filial, String paciente, String nomePaciente, String requisicaoAtual) {
        this.codigoFilial = filial;
        this.codigoRequisicao = requisicaoAtual;
        this.modeloHash.clear();
        try {
            StringBuilder buf = new StringBuilder("select a.exh_datahora, a.usr_codigo, a.exh_codigo, a.exh_hash, a.exh_resultado ");
            buf.append("from examerequisicaohash a ");
            buf.append(" where ");
            if (!Funcoes.textoVazio(filial)) {
                buf.append(" a.fil_codigo = ").append(filial).append(" and ");
            }
            buf.append(" a.req_codigo = ").append(requisicaoAtual);
            if (!Funcoes.textoVazio(filial)) {
                buf.append(" and a.exa_codigo = ").append(DBUtil.bdText(this.codigoExame));
            } else {
                buf.append(" and a.exa_codigo = '").append(this.codigoExame).append("' ");
            }
            buf.append(" and a.mco_codigo = ").append(this.codigoMaterial);
            buf.append(" order by exh_datahora desc");
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    this.modeloHash.addLine(new Object[]{new JLabel(), Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("exh_datahora")), rs.getString("usr_codigo"), rs.getString("exh_hash"), rs.getString("exh_resultado")});
                }
            }
            if (this.modeloHash.getRowCount() > 0) {
                this.tabelaHash.setRowSelectionInterval(0, 0);
                this.setTitle("Hash de resultados - " + (nomePaciente == null ? "" : nomePaciente));
                ScreenUtil.requisitarFoco(this.tabelaHash);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    class RenderResultadosHash
    extends DefaultTableCellRenderer {
        RenderResultadosHash() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value != null ? value.toString() : "");
            label.setFont(table.getFont().deriveFont(11.0f));
            label.setOpaque(isSelected);
            label.setText(this.getHtml(row, (ModeloGridTable)table.getModel()));
            return label;
        }

        private String getHtml(int row, ModeloGridTable model) {
            StringBuilder html = new StringBuilder("<html>");
            html.append("<b>Data/hora: </b>").append(model.getValueAt(row, 1)).append("<br>");
            html.append("<b>Usu\u00e1rio: </b>").append(model.getValueAt(row, 2)).append("<br>");
            html.append("</html>");
            return html.toString();
        }
    }
}

