/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.resultados.DialogoVisualizarResultadoPdf;
import jalis.laboratorio.resultados.LabelResultadoPDF;
import jalis.laboratorio.resultados.RenderResultadosAnteriores;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.service.autocopia.AutocopiaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoResultadosAnteriores
extends AbstractDialogoOKCancelar {
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JTabbedPane tabbedExames = new JTabbedPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            for (int i = 0; i < this.getTabCount(); ++i) {
                Rectangle rec = this.getBoundsAt(i);
                if (DialogoResultadosAnteriores.this.tabbedExames.getComponentAt(i) instanceof LabelResultadoPDF) {
                    LabelResultadoPDF label = (LabelResultadoPDF)DialogoResultadosAnteriores.this.tabbedExames.getComponentAt(i);
                    g.setColor(Tipos.getCorSituacaoExame(label.getSituacao())[0]);
                    g.fillRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
                    g.setColor(Color.black);
                    g.drawRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
                    continue;
                }
                Digitacao digi = (Digitacao)DialogoResultadosAnteriores.this.tabbedExames.getComponentAt(i);
                if (digi == null || rec == null) continue;
                g.setColor(Tipos.getCorSituacaoExame(digi.getSituacao())[0]);
                g.fillRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
                g.setColor(Color.black);
                g.drawRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
            }
        }
    };
    private JPanel panelDadosRequisicao = new JPanel(new GridBagLayout());
    private JLabel labelMedico = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private JLabel labelIdade = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "Data", "Requisi\u00e7\u00e3o"});
    private JTable tabelaRequisicoes = new JTable(this.modeloRequisicoes);
    private JPanel panelRequisicoes = ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", new JScrollPane(this.tabelaRequisicoes));
    JButton botaoVisualizar = new JButton("Visualizar");
    private String filialSelecionada = Variaveis.filialPadrao;
    private AutocopiaService autocopia = AutocopiaService.criar();
    static final int COLUNA_FILIAL = 0;
    static final int COLUNA_DATA = 1;
    static final int COLUNA_CODIGO = 2;
    static final int COLUNA_MEDICO = 3;
    static final int COLUNA_IDADE = 4;

    public DialogoResultadosAnteriores(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public DialogoResultadosAnteriores(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static DialogoResultadosAnteriores novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new DialogoResultadosAnteriores((Frame)owner, "Resultados anteriores");
        }
        return new DialogoResultadosAnteriores((Dialog)owner, "Resultados anteriores");
    }

    private void iniciar() {
        this.setSize(new Dimension(720, 550));
        this.setLocationRelativeTo(this.getParent());
        this.modeloRequisicoes.setColumnSize(new int[]{50, 80, 0}, this.tabelaRequisicoes);
        this.tabelaRequisicoes.setDefaultRenderer(Object.class, new RenderResultadosAnteriores());
        this.tabbedExames.setTabLayoutPolicy(1);
        this.getBotaoCancelar().setVisible(false);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelRequisicoes.setPreferredSize(new Dimension(250, 100));
        this.panelRequisicoes.setMinimumSize(this.panelRequisicoes.getPreferredSize());
        panelCentro.add((Component)this.panelRequisicoes, "West");
        this.getPanelBotoesDireita().add((Component)ComponenteFactory.novoJPanelFlowLayout(0, new Component[0]), "West");
        this.getPanelBotoesDireita().add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.botaoVisualizar, this.buttonOK), "East");
        panelCentro.add((Component)this.panelExames, "Center");
        this.botaoVisualizar.setVisible(false);
        this.tabelaRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DialogoResultadosAnteriores.this.buscaExames(DialogoResultadosAnteriores.this.tabelaRequisicoes.getSelectedRow());
            }
        });
        this.tabbedExames.addChangeListener(a -> {
            if (this.tabbedExames.getSelectedComponent() instanceof LabelResultadoPDF) {
                LabelResultadoPDF label = (LabelResultadoPDF)this.tabbedExames.getSelectedComponent();
                for (ActionListener al : this.botaoVisualizar.getActionListeners()) {
                    this.botaoVisualizar.removeActionListener(al);
                }
                this.botaoVisualizar.addActionListener(e -> this.visualizarResultadoEmPdf(label.getFilial(), label.getRequisicao(), label.getExame(), label.getMaterial()));
                this.botaoVisualizar.setVisible(true);
            } else {
                this.botaoVisualizar.setVisible(false);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.panelDadosRequisicao.add((Component)new JLabel("M\u00e9dico:"), c);
        c.gridy = 1;
        this.panelDadosRequisicao.add((Component)new JLabel("Idade:"), c);
        c.gridx = 1;
        this.labelIdade.setPreferredSize(new Dimension(100, 20));
        this.labelIdade.setMinimumSize(this.labelIdade.getPreferredSize());
        this.panelDadosRequisicao.add((Component)this.labelIdade, c);
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelMedico.setPreferredSize(new Dimension(100, 20));
        this.panelDadosRequisicao.add((Component)this.labelMedico, c);
    }

    private void visualizarResultadoEmPdf(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) {
        DialogoVisualizarResultadoPdf pdf = DialogoVisualizarResultadoPdf.novaInstancia(this, false);
        Statement st = Conexao.getStatement();
        try {
            String resultadoEmPDF = ResultadosUtil.geraResultadoPDfDB(st, codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
            pdf.setPDf(resultadoEmPDF);
            pdf.setVisible(true);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        catch (IOException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel visualizar", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaExames(int linha) {
        if (this.tabelaRequisicoes.getRowCount() > linha) {
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Pesquisando exames. Aguarde...");
            Statement st = Conexao.getStatement();
            try {
                this.labelMedico.setText(this.modeloRequisicoes.getValueAt(linha, 3).toString());
                this.labelIdade.setText(this.modeloRequisicoes.getValueAt(linha, 4).toString());
                StringBuilder buf = new StringBuilder("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.exr_resultadoempdf, c.mco_abreviatura,    ");
                buf.append(" b.exa_importarpdf, b.exa_descricao, a.mco_codigo, c.mco_descricao, ");
                buf.append("pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_situacao, ");
                buf.append("(select distinct lae.lae_protocolo from labexterno lae join loteexternoexamerequisicao lte on ");
                buf.append("lae.fil_codigo = lte.fil_kodigo and lae.lae_codigo=lte.lae_codigo ");
                buf.append("where lte.fil_kodigo = a.fil_codigo and lte.req_codigo = a.req_codigo and lte.exa_codigo = a.exa_codigo ");
                buf.append("and lte.mco_codigo = a.mco_codigo and lte.ler_datahoraestorno is null limit 1) as lae_protocolo ");
                buf.append("from examerequisicao a ");
                buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                buf.append("where ");
                buf.append("  a.fil_codigo = ").append(this.modeloRequisicoes.getValueAt(linha, 0).toString());
                buf.append(" and a.req_codigo = ").append(this.modeloRequisicoes.getValueAt(linha, 2).toString());
                buf.append(" and a.exr_excluido = false ");
                buf.append(" order by ");
                buf.append("d.emc_pagina, d.emc_ordem, a.exa_codigo, a.mco_codigo ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                this.tabbedExames.removeAll();
                while (rs.next()) {
                    Registro reg = new Registro(rs);
                    Digitacao dig = new Digitacao();
                    if (rs.getBoolean("exr_resultadoempdf")) {
                        LabelResultadoPDF lbl = new LabelResultadoPDF("Resultado importado no formato PDF");
                        if (!rs.getBoolean("exa_importarpdf") && !Funcoes.textoVazio(rs.getString("lae_protocolo"))) {
                            lbl = new LabelResultadoPDF("Resultado importado no formato PDF do laborat\u00f3rio de apoio: ".concat(this.getDescricaoLaboratorioApoio(rs.getString("lae_protocolo"))));
                        }
                        lbl.setExame(reg.getString("exa_codigo"));
                        lbl.setMaterial(reg.getString("mco_codigo"));
                        lbl.setRequisicao(reg.getString("req_codigo"));
                        lbl.setFilial(reg.getString("fil_codigo"));
                        lbl.setSituacao(reg.getString("exr_situacao"));
                        lbl.setHorizontalAlignment(0);
                        this.tabbedExames.add(this.getTituloAba(reg), lbl);
                        continue;
                    }
                    dig.carregarCampos(reg.getString("exr_resultado"));
                    dig.exibirBotaoFechar(false);
                    dig.exibirBotaoImprimir(false);
                    dig.exibirBotaoSalvar(false);
                    dig.exibirBotaoSalvarParcial(false);
                    dig.exibirCheckBoxImprimir(false);
                    dig.setCodigoExame(reg.getString("exa_codigo"));
                    dig.setCodigoMaterialColeta(reg.getInt("mco_codigo"));
                    dig.setSituacao(reg.getString("exr_situacao"));
                    this.tabbedExames.add((Component)dig, this.getTituloAba(reg));
                }
                splash.apagar();
                this.panelExames.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogoResultadosAnteriores.this.panelExames.add((Component)DialogoResultadosAnteriores.this.panelDadosRequisicao, "North");
                        DialogoResultadosAnteriores.this.panelExames.add((Component)DialogoResultadosAnteriores.this.tabbedExames, "Center");
                        DialogoResultadosAnteriores.this.panelExames.revalidate();
                        DialogoResultadosAnteriores.this.panelExames.repaint();
                    }
                });
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosAnteriores: 155");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private String getDescricaoLaboratorioApoio(String codigoProtocolo) {
        switch (Protocolo.getProtocolo(codigoProtocolo)) {
            case Alvaro: {
                return "Alvaro";
            }
            case Balague: {
                return "Balague";
            }
            case Cerba: {
                return "Cerba";
            }
            case Concent: {
                return "Concent";
            }
            case Criesp: {
                return "Criesp";
            }
            case DB: {
                return "Diagn\u00f3stico Brasil";
            }
            case DBV2: {
                return "Diagn\u00f3stico Brasil";
            }
            case HPardini: {
                return "Hermes Pardini";
            }
            case Jalis: {
                return "Jalis";
            }
            case Maricondi: {
                return "Maricondi";
            }
            case Reacao: {
                return "Rea\u00e7\u00e3o";
            }
            case Rede: {
                return "Rede";
            }
            case SaoCamilo: {
                return "S\u00e3o Camilo";
            }
            case SaoMarcos: {
                return "S\u00e3o Marcos";
            }
            case SergioFranco: {
                return "S\u00e9rgio Franco";
            }
            case Solucao: {
                return "Solu\u00e7\u00e3o";
            }
            case SolucaoV2: {
                return "Solu\u00e7\u00e3o";
            }
            case Syslab: {
                return "Syslab";
            }
            case Unilab: {
                return "Unilab";
            }
            case JalisWS: {
                return "Jalis WS";
            }
            case MercolabWS: {
                return "Mercolab WS";
            }
            case Shift: {
                return "Shift";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRequisicao(Window owner, String filial, String nomePaciente, String requisicao) {
        boolean bl;
        Statement st;
        block6: {
            this.panelRequisicoes.setVisible(false);
            this.modeloRequisicoes.clear();
            st = Conexao.getStatement();
            this.filialSelecionada = filial;
            StringBuilder where = new StringBuilder();
            where.append(" where a.fil_codigo = ").append(filial);
            where.append(" and a.req_codigo = ").append(requisicao);
            String sql = this.getSql(where.toString());
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                String idade = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                this.modeloRequisicoes.addLine(new String[]{rs.getString("fil_codigo"), Funcoes.formataData(rs.getDate("req_data")), rs.getString("req_codigo"), rs.getString("med_nome"), idade});
            }
            if (this.modeloRequisicoes.getRowCount() <= 0) break block6;
            this.tabelaRequisicoes.setRowSelectionInterval(0, 0);
            this.setTitle("Resultados - " + filial + "." + requisicao + (nomePaciente == null ? "" : " - " + nomePaciente));
            ScreenUtil.requisitarFoco(this.tabelaRequisicoes);
            boolean bl2 = true;
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            Funcoes.mensagem(owner, "N\u00e3o h\u00e1 exames para a requisi\u00e7\u00e3o selecionada", 2);
            bl = false;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosAnteriores: 241");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    private String getSql(String where) {
        StringBuilder buf = new StringBuilder("select a.req_codigo, a.req_data, a.req_idade, a.req_anomes, b.med_nome, a.fil_codigo ");
        buf.append("from requisicao a ");
        buf.append("left join medico b on a.fil_codigo = b.fil_codigo and a.med_conselho = b.med_conselho and a.med_crm = b.med_crm and a.med_uf = b.med_uf ");
        buf.append(where);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPaciente(Window owner, String filial, String paciente, String nomePaciente, String requisicaoAtual) {
        boolean bl;
        Statement st;
        block6: {
            this.modeloRequisicoes.clear();
            st = Conexao.getStatement();
            this.filialSelecionada = filial;
            StringBuilder where = new StringBuilder();
            where.append(" where a.fil_codigo = ").append(filial);
            where.append(" and a.pac_codigo = ").append(paciente);
            where.append(" and a.req_excluida = false ");
            where.append(" order by req_data desc, req_hora desc ");
            String sql = this.getSql(where.toString());
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                int requisicao = rs.getInt("req_codigo");
                if (!this.saoDiferentes(requisicaoAtual, requisicao)) continue;
                String idade = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                this.modeloRequisicoes.addLine(new String[]{rs.getString("fil_codigo"), Funcoes.formataData(rs.getDate("req_data")), rs.getString("req_codigo"), rs.getString("med_nome"), idade});
            }
            if (this.modeloRequisicoes.getRowCount() <= 0) break block6;
            this.tabelaRequisicoes.setRowSelectionInterval(0, 0);
            this.setTitle("Resultados anteriores - " + (nomePaciente == null ? "" : nomePaciente));
            ScreenUtil.requisitarFoco(this.tabelaRequisicoes);
            bl = true;
            Conexao.fecharStatement(st);
            return bl;
        }
        try {
            Funcoes.mensagem(owner, "N\u00e3o h\u00e1 exames anteriores para o paciente", 2);
            bl = false;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosAnteriores: 85");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    private boolean saoDiferentes(String requisicaoAtual, int requisicao) {
        return !Funcoes.isNumeric(requisicaoAtual) || Integer.parseInt(requisicaoAtual) != requisicao;
    }

    private String getTituloAba(Registro reg) {
        StringBuilder str = new StringBuilder();
        if (reg != null) {
            str.append("<html><font size=2>");
            str.append(reg.getValor("exa_codigo"));
            str.append(" (<font color=#FF0000>");
            str.append(reg.getValor("mco_abreviatura"));
            str.append("</font>)<br>");
            String tmp = reg.getString("exr_descricaomaterial").trim().length() == 0 ? reg.getString("mco_descricao") : reg.getString("exr_descricaomaterial");
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("<br>");
            tmp = Tipos.tipoSituacaoExame(reg.getString("exr_situacao"));
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("</font></html>");
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPacienteAutocopia(Window owner, String filial, String paciente, String nomePaciente, String requisicaoAtual) {
        boolean bl;
        Statement st;
        block6: {
            this.modeloRequisicoes.clear();
            st = Conexao.getStatement();
            this.filialSelecionada = filial;
            StringBuilder where = new StringBuilder();
            List<Integer> filiais = this.autocopia.getFiliaisPaciente();
            filiais.add(Integer.valueOf(Variaveis.filialPadrao));
            where.append(" where a.fil_codigo in (").append(this.getCondicaoIn(filiais)).append(")");
            where.append(" and a.pac_codigo = ").append(paciente);
            where.append(" and a.req_excluida = false ");
            where.append(" order by req_data desc, req_hora desc ");
            String sql = this.getSql(where.toString());
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                int requisicao = rs.getInt("req_codigo");
                if (!this.saoDiferentes(requisicaoAtual, requisicao)) continue;
                String idade = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                this.modeloRequisicoes.addLine(new String[]{rs.getString("fil_codigo"), Funcoes.formataData(rs.getDate("req_data")), rs.getString("req_codigo"), rs.getString("med_nome"), idade});
            }
            if (this.modeloRequisicoes.getRowCount() <= 0) break block6;
            this.tabelaRequisicoes.setRowSelectionInterval(0, 0);
            this.setTitle("Resultados anteriores - " + (nomePaciente == null ? "" : nomePaciente));
            ScreenUtil.requisitarFoco(this.tabelaRequisicoes);
            bl = true;
            Conexao.fecharStatement(st);
            return bl;
        }
        try {
            Funcoes.mensagem(owner, "N\u00e3o h\u00e1 exames anteriores para o paciente", 2);
            bl = false;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosAnteriores: 85");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    private Object getCondicaoIn(List<Integer> filiais) {
        StringBuilder condicao = new StringBuilder();
        for (Integer filial : filiais) {
            condicao.append(filial).append(",");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRequisicaoAutocopia(Window owner, String filial, String nomePaciente, String requisicao) {
        boolean bl;
        Statement st;
        block6: {
            this.panelRequisicoes.setVisible(false);
            this.modeloRequisicoes.clear();
            st = Conexao.getStatement();
            this.filialSelecionada = filial;
            StringBuilder where = new StringBuilder();
            List<Integer> filiais = this.autocopia.getFiliaisPaciente();
            filiais.add(Integer.valueOf(Variaveis.filialPadrao));
            where.append(" where a.fil_codigo in ( ").append(this.getCondicaoIn(filiais)).append(")");
            where.append(" and a.req_codigo = ").append(requisicao);
            String sql = this.getSql(where.toString());
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                String idade = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                this.modeloRequisicoes.addLine(new String[]{rs.getString("fil_codigo"), Funcoes.formataData(rs.getDate("req_data")), rs.getString("req_codigo"), rs.getString("med_nome"), idade});
            }
            if (this.modeloRequisicoes.getRowCount() <= 0) break block6;
            this.tabelaRequisicoes.setRowSelectionInterval(0, 0);
            this.setTitle("Resultados - " + filial + "." + requisicao + (nomePaciente == null ? "" : " - " + nomePaciente));
            ScreenUtil.requisitarFoco(this.tabelaRequisicoes);
            boolean bl2 = true;
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            Funcoes.mensagem(owner, "N\u00e3o h\u00e1 exames para a requisi\u00e7\u00e3o selecionada", 2);
            bl = false;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosAnteriores: 241");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }
}

