/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class DialogoObservacaoPaciente
extends JDialog
implements ActionListener {
    JTextArea textObs = new JTextArea(new TTextAreaDocument(500));
    JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private static final String TITULO = "Observa\u00e7\u00e3o do Paciente";
    boolean ok;

    public static DialogoObservacaoPaciente novaInstancia(Object pai, String obs, boolean salvar) {
        DialogoObservacaoPaciente dobs = null;
        if (pai instanceof Frame) {
            dobs = new DialogoObservacaoPaciente((Frame)pai);
        } else if (pai instanceof Dialog) {
            dobs = new DialogoObservacaoPaciente((Dialog)pai);
        }
        if (dobs != null) {
            dobs.textObs.setText(obs);
            dobs.textObs.setEditable(salvar);
            dobs.buttonSalvar.setVisible(salvar);
        }
        return dobs;
    }

    public DialogoObservacaoPaciente(Frame pai) {
        super(pai, TITULO, true);
        this.iniciar();
    }

    public DialogoObservacaoPaciente(Dialog pai) {
        super(pai, TITULO, true);
        this.iniciar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonSalvar || o == this.buttonFechar) {
            this.ok = o == this.buttonSalvar;
            this.dispose();
        }
    }

    private void iniciar() {
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.textObs), "Center");
        this.getContentPane().add((Component)panel, "South");
        panel.add(this.buttonSalvar);
        panel.add(this.buttonFechar);
        this.textObs.setEditable(false);
        this.setSize(new Dimension(450, 300));
        ScreenUtil.centralizar(this);
    }

    public String getObservacaoPaciente() {
        return this.textObs.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarObservacaoPaciente(String codFilial, String codPaciente) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            try {
                if (Funcoes.textoVazio(codFilial) || Funcoes.textoVazio(codPaciente)) break block4;
                this.atualizarIntegracao(codFilial, codPaciente);
                SalvaDados salvar = new SalvaDados("paciente", 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, codFilial);
                salvar.adicionaCampo("pac_codigo", 2, false, true, codPaciente);
                salvar.adicionaCampo("pac_observ", 0, true, false, StringUtil.textoDBEscape(this.getObservacaoPaciente()));
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaPaciente());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoObservacaoPaciente");
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizarIntegracao(String codFilial, String codPaciente) {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder bui = new StringBuilder();
            bui.append("update paciente set pac_observ=").append(StringUtil.textoDBEscape(this.getObservacaoPaciente()));
            bui.append(" where fil_codigo = ").append(codFilial);
            bui.append(" and pac_codigo = ").append(codPaciente);
            Conexao.executeUpdate(codFilial, st, bui.toString());
        }
        catch (Exception e) {
            try {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoObservacaoPaciente");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoObservacaoPaciente");
        }
    }
}

