/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DialogoMedicamentos
extends JDialog
implements ListSelectionListener {
    private JTextArea textIndicacao = new JTextArea();
    private JTextArea textInteracao = new JTextArea();
    private JTable tableMedicamentos;
    private ModeloResultSet modelo;

    public static DialogoMedicamentos novaInstancia(Object pai, ModeloResultSet modelo) {
        if (pai instanceof Frame) {
            return new DialogoMedicamentos((Frame)pai, modelo);
        }
        if (pai instanceof Dialog) {
            return new DialogoMedicamentos((Dialog)pai, modelo);
        }
        return null;
    }

    public DialogoMedicamentos(Frame pai, ModeloResultSet modelo) {
        super(pai, "Medicamentos", true);
        this.iniciar(modelo);
    }

    public DialogoMedicamentos(Dialog pai, ModeloResultSet modelo) {
        super(pai, "Medicamentos", true);
        this.iniciar(modelo);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modelo.getRegistro(this.tableMedicamentos.getSelectedRow());
        if (reg != null) {
            this.textIndicacao.setText(reg.getString("mto_indicacao"));
            this.textInteracao.setText(reg.getString("mto_interacao"));
        }
    }

    private void iniciar(ModeloResultSet modelo) {
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        panel.add(ComponenteFactory.novoJButton("Fechar", 'F', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoMedicamentos.this.dispose();
            }
        }, null, null));
        panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "Center");
        GridBagConstraints cons = new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(1, 1, 1, 1), 0, 0);
        this.modelo = modelo;
        this.tableMedicamentos = ComponenteFactory.novoJTable((TableModel)this.modelo, (ListSelectionListener)this, new int[0]);
        panel.add((Component)new JScrollPane(this.tableMedicamentos), cons);
        cons.gridy = 1;
        JTabbedPane tabbed = new JTabbedPane(1);
        tabbed.addTab("Indica\u00e7\u00e3o", this.textIndicacao);
        tabbed.addTab("Intera\u00e7\u00e3o", this.textInteracao);
        this.textIndicacao.setEditable(false);
        this.textInteracao.setEditable(false);
        panel.add((Component)tabbed, cons);
        TableColumnModel model = this.tableMedicamentos.getColumnModel();
        model.getColumn(1).setMaxWidth(60);
        model.getColumn(1).setMinWidth(60);
        model.getColumn(2).setMaxWidth(100);
        model.getColumn(2).setMinWidth(100);
        model.getColumn(3).setMaxWidth(70);
        model.getColumn(3).setMinWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(1, 4);
        renderer.setAlinhamentoColuna(2, 0);
        renderer.setAlinhamentoColuna(3, 0);
        this.tableMedicamentos.setDefaultRenderer(Object.class, renderer);
        if (this.tableMedicamentos.getRowCount() > 0) {
            this.tableMedicamentos.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.setSize(new Dimension(550, 300));
        ScreenUtil.centralizar(this);
    }
}

