/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoLaudoRetificado
extends AbstractDialogoOKCancelar {
    private JPanel panelExames = new JPanel(new GridBagLayout());
    private JPanel panelExamesLaudo = new JPanel(new BorderLayout());
    private JTextArea textMotivo = new JTextArea();
    private JLabel labelSituacaoAnterior = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private ModeloGridTable modeloDatas = new ModeloGridTable(new String[]{"Data", "Usu\u00e1rio"});
    private JTable tabelaDatas = new JTable(this.modeloDatas);
    private JPanel panelDatas = ComponenteFactory.novoJPanelBorderLayout("Datas", new JScrollPane(this.tabelaDatas));
    static final int COLUNA_DATA = 0;
    static final int COLUNA_USUARIO = 1;
    static final int COLUNA_MOTIVO = 2;
    static final int COLUNA_SITUACAO_ANTERIOR = 3;
    static final int COLUNA_RESULTADO = 4;
    static final int COLUNA_DATA_SITUACAO_ANTERIOR = 5;
    static final int COLUNA_USUARIO_SITUACAO_ANTERIOR = 6;

    public DialogoLaudoRetificado(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public DialogoLaudoRetificado(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static DialogoLaudoRetificado novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new DialogoLaudoRetificado((Frame)owner, "Resultados retificados");
        }
        return new DialogoLaudoRetificado((Dialog)owner, "Resultados retificados");
    }

    private void iniciar() {
        this.setSize(new Dimension(720, 550));
        this.setLocationRelativeTo(this.getParent());
        this.modeloDatas.setColumnSize(new int[]{107, 0}, this.tabelaDatas);
        this.getBotaoCancelar().setVisible(false);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelDatas.setPreferredSize(new Dimension(200, 100));
        this.panelDatas.setMinimumSize(this.panelDatas.getPreferredSize());
        panelCentro.add((Component)this.panelDatas, "West");
        panelCentro.add((Component)this.panelExames, "Center");
        this.tabelaDatas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DialogoLaudoRetificado.this.buscaRetificado(DialogoLaudoRetificado.this.tabelaDatas.getSelectedRow());
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        this.panelExames.add((Component)new JLabel("Motivo:"), c);
        ++c.gridy;
        c.anchor = 17;
        this.panelExames.add((Component)new JLabel("Situa\u00e7\u00e3o:"), c);
        c.gridy = 0;
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        JScrollPane scroll = new JScrollPane(this.textMotivo);
        scroll.setPreferredSize(new Dimension(100, 60));
        scroll.setMinimumSize(new Dimension(100, 60));
        this.panelExames.add((Component)scroll, c);
        this.textMotivo.setEditable(false);
        this.textMotivo.setBackground(this.getBackground());
        ++c.gridy;
        c.fill = 2;
        this.labelSituacaoAnterior.setPreferredSize(new Dimension(200, 20));
        this.labelSituacaoAnterior.setMinimumSize(new Dimension(200, 20));
        this.panelExames.add((Component)this.labelSituacaoAnterior, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelExames.add((Component)this.panelExamesLaudo, c);
    }

    private void buscaRetificado(int linha) {
        this.panelExamesLaudo.removeAll();
        this.labelSituacaoAnterior.setBackground(this.getBackground());
        this.labelSituacaoAnterior.setForeground(this.getForeground());
        this.labelSituacaoAnterior.setOpaque(false);
        if (this.tabelaDatas.getRowCount() > linha) {
            this.textMotivo.setText(this.modeloDatas.getValueAt(linha, 2).toString());
            ScreenUtil.posicionaTextoTopo(this.textMotivo);
            this.labelSituacaoAnterior.setText((this.modeloDatas.getValueAt(linha, 3) == null ? "Sem resultado" : Tipos.tipoSituacaoExame(this.modeloDatas.getValueAt(linha, 3).toString())) + (this.modeloDatas.getValueAt(linha, 5) != null ? " em " + this.modeloDatas.getValueAt(linha, 0).toString() : "") + (this.modeloDatas.getValueAt(linha, 1) != null ? " por " + this.modeloDatas.getValueAt(linha, 1).toString() : ""));
            Color[] cor = Tipos.getCorSituacaoExame(this.modeloDatas.getValueAt(linha, 3).toString());
            this.labelSituacaoAnterior.setBackground(cor[0]);
            this.labelSituacaoAnterior.setForeground(cor[1]);
            this.labelSituacaoAnterior.setOpaque(true);
            Digitacao dig = new Digitacao();
            dig.carregarCampos(this.modeloDatas.getValueAt(linha, 4).toString());
            dig.exibirBotaoFechar(false);
            dig.exibirBotaoImprimir(false);
            dig.exibirBotaoSalvar(false);
            dig.exibirBotaoSalvarParcial(false);
            dig.exibirCheckBoxImprimir(false);
            this.panelExamesLaudo.add(dig);
            this.panelExamesLaudo.revalidate();
            this.panelExamesLaudo.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequisicaoExame(String filial, String requisicao, String codigoExame, String codigoMaterial) {
        Statement st;
        block6: {
            this.modeloDatas.clear();
            st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder("select a.ehl_datahora, a.ehl_motivo, a.ehl_situacao, a.usr_codigo, a.ehl_resultado, a.ehl_datasituacao, a.usr_codsituacao ");
                buf.append("from examerequisicaohistoricolaudo a ");
                buf.append(" where a.fil_codigo = ").append(filial);
                buf.append(" and a.req_codigo = ").append(requisicao);
                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' ");
                buf.append(" and a.mco_codigo = ").append(codigoMaterial);
                buf.append(" order by a.ehl_datahora desc");
                ResultSet rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    this.modeloDatas.addLine(new String[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("ehl_datahora")), rs.getString("usr_codigo"), rs.getString("ehl_motivo"), rs.getString("ehl_situacao"), rs.getString("ehl_resultado"), Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("ehl_datasituacao")), rs.getString("usr_codsituacao")});
                }
                if (this.modeloDatas.getRowCount() <= 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 exames retificados", 2);
                    break block6;
                }
                this.tabelaDatas.setRowSelectionInterval(0, 0);
                ScreenUtil.requisitarFoco(this.tabelaDatas);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoLaudoRetificado: 164");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }
}

