/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.resultados.RenderHistoricoDadosBrutos;
import jalis.model.bean.recepcao.ExameRequisicaoDadosBrutosBean;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.recepcao.ExameRequisicaoDadosBrutosService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoHistoricoDadosBrutos
extends AbstractDialogoOKCancelar {
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JTabbedPane tabbedExames = new JTabbedPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            for (int i = 0; i < this.getTabCount(); ++i) {
                Registro exa = new Registro();
                Rectangle rec = this.getBoundsAt(i);
                if (exa == null || rec == null) continue;
                g.setColor(Tipos.getCorSituacaoExame(exa.getString("exr_situacao"))[0]);
                g.fillRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
                g.setColor(Color.black);
                g.drawRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
            }
        }
    };
    private JPanel panelDadosRequisicao = new JPanel(new GridBagLayout());
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Data", "Usu\u00e1rio"});
    private JTable tabelaRequisicoes = new JTable(this.modeloRequisicoes);
    private JPanel panelRequisicoes = ComponenteFactory.novoJPanelBorderLayout("Mudan\u00e7as", new JScrollPane(this.tabelaRequisicoes));
    private String filialSelecionada = Variaveis.filialPadrao;
    static final int COLUNA_DATA = 0;
    static final int COLUNA_OBJETO = 2;
    static final int COLUNA_REGISTRO = 3;
    private RequisicaoVO requisicaoVO = null;
    private ExameRequisicaoDadosBrutosService exameRequisicaoDadosBrutosService = new ExameRequisicaoDadosBrutosService();

    public DialogoHistoricoDadosBrutos(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public DialogoHistoricoDadosBrutos(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static DialogoHistoricoDadosBrutos novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new DialogoHistoricoDadosBrutos((Frame)owner, "Hist\u00f3rico dados brutos");
        }
        return new DialogoHistoricoDadosBrutos((Dialog)owner, "Hist\u00f3rico dados brutos");
    }

    private void iniciar() {
        this.setSize(new Dimension(720, 550));
        this.setLocationRelativeTo(this.getParent());
        this.modeloRequisicoes.setColumnSize(new int[]{140, 0}, this.tabelaRequisicoes);
        this.tabelaRequisicoes.setDefaultRenderer(Object.class, new RenderHistoricoDadosBrutos());
        this.tabbedExames.setTabLayoutPolicy(1);
        this.getBotaoCancelar().setVisible(false);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelRequisicoes.setPreferredSize(new Dimension(270, 100));
        this.panelRequisicoes.setMinimumSize(this.panelRequisicoes.getPreferredSize());
        panelCentro.add((Component)this.panelRequisicoes, "West");
        panelCentro.add((Component)this.panelExames, "Center");
        this.tabelaRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DialogoHistoricoDadosBrutos.this.buscaExames();
            }
        });
    }

    private void buscaExames() {
        int linha = this.tabelaRequisicoes.getSelectedRow();
        if (this.tabelaRequisicoes.getRowCount() > linha) {
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Pesquisando hist\u00f3rico. Aguarde...");
            try {
                ExameRequisicaoDadosBrutosBean dadosBrutosBean = (ExameRequisicaoDadosBrutosBean)this.modeloRequisicoes.getValueAt(linha, 2);
                Registro registro = (Registro)this.modeloRequisicoes.getValueAt(linha, 3);
                this.tabbedExames.removeAll();
                if (dadosBrutosBean != null) {
                    Digitacao dig = new Digitacao();
                    dig.carregarCampos(dadosBrutosBean.getDadosBrutos());
                    dig.exibirBotaoFechar(false);
                    dig.exibirBotaoImprimir(false);
                    dig.exibirBotaoSalvar(false);
                    dig.exibirBotaoSalvarParcial(false);
                    dig.exibirCheckBoxImprimir(false);
                    this.tabbedExames.add((Component)dig, this.getTituloAba(registro));
                }
                splash.apagar();
                this.panelExames.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogoHistoricoDadosBrutos.this.panelExames.add((Component)DialogoHistoricoDadosBrutos.this.panelDadosRequisicao, "North");
                        DialogoHistoricoDadosBrutos.this.panelExames.add((Component)DialogoHistoricoDadosBrutos.this.tabbedExames, "Center");
                        DialogoHistoricoDadosBrutos.this.panelExames.revalidate();
                        DialogoHistoricoDadosBrutos.this.panelExames.repaint();
                    }
                });
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPaciente(String filial, String requisicaoAtual, Registro registro) {
        boolean bl;
        Statement st;
        block9: {
            block8: {
                this.modeloRequisicoes.clear();
                st = Conexao.getStatement();
                this.filialSelecionada = filial;
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", filial);
                chaves.put("req_codigo", requisicaoAtual);
                this.requisicaoVO = (RequisicaoVO)new RequisicaoService().getVO(chaves);
                if (this.requisicaoVO != null) break block8;
                boolean bl2 = false;
                Conexao.fecharStatement(st);
                return bl2;
            }
            Set brutosBeans = this.exameRequisicaoDadosBrutosService.load(" where fil_codigo = " + filial + " and req_codigo = " + requisicaoAtual + " and mco_codigo = " + registro.getValor("codigomaterial") + " and exa_codigo = '" + registro.getValor("codigoexame") + "' order by eda_datahora ");
            if (brutosBeans != null) {
                for (ExameRequisicaoDadosBrutosBean exameRequisicaoDadosBrutosBean : brutosBeans) {
                    this.modeloRequisicoes.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy hh:mm:ss", exameRequisicaoDadosBrutosBean.getDataHora()), exameRequisicaoDadosBrutosBean.getUsuario().getCodigo(), exameRequisicaoDadosBrutosBean, registro});
                }
            }
            this.modeloRequisicoes.ordenarColuna(0);
            if (this.modeloRequisicoes.getRowCount() <= 0) break block9;
            this.tabelaRequisicoes.setRowSelectionInterval(0, 0);
            this.setTitle("Visualizando hist\u00f3rico de dados brutos");
            ScreenUtil.requisitarFoco(this.tabelaRequisicoes);
            boolean bl3 = true;
            Conexao.fecharStatement(st);
            return bl3;
        }
        try {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 hist\u00f3ricos anteriores.", 2);
            bl = false;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosAnteriores: 85");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    private String getTituloAba(Registro reg) {
        StringBuilder str = new StringBuilder();
        if (reg != null) {
            str.append("<html><font size=2>");
            str.append(reg.getValor("codigoexame"));
            str.append(" (<font color=#FF0000>");
            str.append(reg.getValor("abreviaturamaterial"));
            str.append("</font>)<br>");
            String tmp = reg.getString("descricaomaterial").trim().length() == 0 ? reg.getString("mco_descricao") : reg.getString("descricaomaterial");
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("<br>");
            tmp = Tipos.tipoSituacaoExame(reg.getString("situacaoexamerequisicao"));
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("</font></html>");
        }
        return str.toString();
    }
}

