/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

class DialogoFiltroEtiquetas
extends JDialog
implements ActionListener {
    private static final String SELECIONADO = "selecionado";
    private final JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'N', this);
    private final JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private final JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private final JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private final JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private final JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private final JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private final TTextField textDataIni = new TTextField(0, 4);
    private final TTextField textDataFin = new TTextField(0, 4);
    private final TTextField textHoraIni = new TTextField(0, 6);
    private final TTextField textHoraFin = new TTextField(0, 6);
    private final ModeloResultSet modReq = new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "req_data", "", "selecionado");
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemExame;
    private boolean ok;

    public static DialogoFiltroEtiquetas novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoFiltroEtiquetas((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltroEtiquetas((Dialog)pai);
        }
        return null;
    }

    public DialogoFiltroEtiquetas(Frame pai) {
        super(pai, "Filtrando requisi\u00e7\u00f5es", true);
        this.iniciar();
    }

    public DialogoFiltroEtiquetas(Dialog pai) {
        super(pai, "Sele\u00e7\u00e3o de requisi\u00e7\u00f5es", true);
        this.iniciar();
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<Registro> getRequisicoesSelecionados() {
        ArrayList<Registro> sel = new ArrayList<Registro>();
        for (Registro reg : this.modReq.getRegistros()) {
            if (!reg.getBoolean(SELECIONADO)) continue;
            sel.add(reg);
        }
        return sel;
    }

    public String[] getFiltroSetor() {
        return this.itemSetor.getSelecionados();
    }

    public String[] getFiltroExame() {
        return this.itemExame.getSelecionados();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (Registro reg : this.modReq.getRegistros()) {
                reg.setValor(SELECIONADO, marcar);
            }
            this.modReq.fireTableDataChanged();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
        }
    }

    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        if (this.permiteConsultar() && st != null) {
            try {
                this.modReq.limpar();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Registro reg = new Registro(res);
                    this.modReq.addRegistro(reg);
                }
                this.modReq.fireTableDataChanged();
                this.modReq.ordenarColunaSemMudarSentido(this.modReq.getColunaOrdenada());
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoFiltroEntregarResultado (638)");
            }
        }
    }

    private boolean permiteConsultar() {
        if (Funcoes.textoVazio(this.textDataFin) && Funcoes.textoVazio(this.textDataIni) && Funcoes.textoVazio(this.textHoraFin) && Funcoes.textoVazio(this.textHoraIni) && this.itemColeta.getSelecionados() == null && this.itemDestino.getSelecionados() == null && this.itemSetor.getSelecionados() == null && this.itemConvenio.getSelecionados() == null && this.itemExame.getSelecionados() == null) {
            Funcoes.mensagem(this, "Informe no m\u00ednimo um valor nos filtros.", 2);
            ScreenUtil.requisitarFoco(this.textDataIni);
            return false;
        }
        return true;
    }

    private String getSelect() {
        StringBuilder bui = new StringBuilder();
        try {
            bui.append("select distinct a.req_codigo ");
            bui.append("      ,a.fil_codigo ");
            bui.append("      ,a.req_data ");
            bui.append("      ,a.req_hora ");
            bui.append("      ,b.pac_nome ");
            bui.append("      ,false as ").append(SELECIONADO);
            bui.append("  from requisicao a ");
            bui.append("  left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
            bui.append("  left join examerequisicao req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
            bui.append("  left join exames exa on a.fil_codigo = exa.fil_codigo and exa.exa_codigo = req.exa_codigo ");
            bui.append("  left join examesetor exas on a.fil_codigo = exas.fil_codigo and exa.exa_codigo = exas.exa_codigo ");
            bui.append("  left join setores setor on a.fil_codigo = setor.fil_codigo and exas.set_codigo = setor.set_codigo ");
            bui.append("  left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            bui.append(" where a.req_excluida = false ");
            bui.append(" and a.fil_codigo = ").append(Variaveis.filialPadrao);
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                bui.append(" and a.req_data ").append(" >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataIni.getText())).append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                bui.append(" and a.req_data ").append(" <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataFin.getText())).append("' ");
            }
            if (Funcoes.verificaHora(this.textHoraIni.getText())) {
                bui.append(" and a.req_hora ").append(" >= '");
                bui.append(this.textHoraIni.getText()).append("' ");
            }
            if (Funcoes.verificaHora(this.textHoraFin.getText())) {
                bui.append(" and a.req_hora ").append(" <= '");
                bui.append(this.textHoraFin.getText()).append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, " a.col_codigo ", this.itemColeta, true);
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, " a.des_codigo ", this.itemDestino, true);
            }
            if (this.itemSetor.isSelected()) {
                this.addExpressao(bui, " setor.set_codigo ", this.itemSetor, true);
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, " con.con_codigo ", this.itemConvenio, true);
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, " exa.exa_codigo ", this.itemExame, true);
            }
            bui.append(" group by a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, b.pac_nome, selecionado ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String campo, CheckItemFiltro itemFiltro, boolean aspas) {
        if (itemFiltro.isPesquisaAvancada() && itemFiltro.getSelecionadosAvancado(0) != null && itemFiltro.getSelecionadosAvancado(0).length > 0) {
            bui.append("and \n  ");
            bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionadosAvancado(0), aspas));
        } else if (itemFiltro.getSelecionados(0) != null && itemFiltro.getSelecionados(0).length > 0) {
            bui.append("and \n  ");
            bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionados(0), aspas));
        }
        bui.append(" ");
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.getContentPane().add((Component)panelAux, "Center");
        this.modReq.setColunaEditavel(SELECIONADO);
        JTable table = ComponenteFactory.novoJTable((TableModel)this.modReq, 75, 0, 85, 25);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String valor = "";
                if (value != null) {
                    valor = column == 2 ? Funcoes.formataData("dd/MM/yyyy", Funcoes.stringToDate("yyyy/MM/dd", value.toString())) : value.toString();
                }
                this.setValue(valor);
                return this;
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 250));
        panelAux.add((Component)scroll, "Center");
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando Setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanios", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemExame = new CheckItemFiltro("Exames", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        panelAux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Filtros"));
        this.getContentPane().add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 2);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        panelAux.add((Component)this.itemSetor, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemDestino, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemConvenio, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemExame, cons);
        cons.insets = new Insets(1, 0, 1, 0);
        cons.fill = 1;
        cons.gridy = 0;
        ++cons.gridx;
        int x = cons.gridx++;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        JLabel jLabelDataInicial = new JLabel("Data Inicial:", 2);
        jLabelDataInicial.setPreferredSize(new Dimension(120, 15));
        jLabelDataInicial.setMinimumSize(new Dimension(120, 15));
        panelAux.add((Component)jLabelDataInicial, cons);
        this.textDataIni.setPreferredSize(new Dimension(122, 22));
        this.textDataIni.setMinimumSize(new Dimension(122, 22));
        panelAux.add((Component)this.textDataIni, cons);
        this.buttonDataIni.setPreferredSize(new Dimension(20, 20));
        this.buttonDataIni.setMinimumSize(new Dimension(20, 20));
        this.buttonDataIni.setFocusable(false);
        ++cons.gridx;
        panelAux.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = x;
        JLabel jLabelDatanInivcial = new JLabel("Data Final:", 2);
        jLabelDatanInivcial.setPreferredSize(new Dimension(120, 15));
        jLabelDatanInivcial.setMinimumSize(new Dimension(120, 15));
        panelAux.add((Component)jLabelDatanInivcial, cons);
        this.textDataFin.setPreferredSize(new Dimension(90, 22));
        this.textDataFin.setMinimumSize(new Dimension(90, 22));
        this.buttonDataFin.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFin.setMinimumSize(new Dimension(20, 20));
        ++cons.gridx;
        panelAux.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        panelAux.add((Component)this.buttonDataFin, cons);
        cons.gridx = 1;
        ++cons.gridy;
        JLabel labelHoraInicial = new JLabel("Hora Inicial:", 2);
        labelHoraInicial.setPreferredSize(new Dimension(120, 15));
        labelHoraInicial.setMinimumSize(new Dimension(120, 15));
        panelAux.add((Component)labelHoraInicial, cons);
        ++cons.gridx;
        cons.gridwidth = 0;
        cons.weightx = 0.0;
        this.textHoraIni.setPreferredSize(new Dimension(90, 20));
        this.textHoraIni.setMinimumSize(new Dimension(90, 20));
        panelAux.add((Component)this.textHoraIni, cons);
        cons.gridx = 1;
        ++cons.gridy;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        JLabel jLabelHoraFinal = new JLabel("Hora Final:", 2);
        jLabelHoraFinal.setPreferredSize(new Dimension(120, 22));
        jLabelHoraFinal.setMinimumSize(new Dimension(120, 22));
        panelAux.add((Component)jLabelHoraFinal, cons);
        cons.gridwidth = 0;
        cons.weightx = 0.0;
        ++cons.gridx;
        this.textHoraFin.setPreferredSize(new Dimension(90, 20));
        this.textHoraFin.setMinimumSize(new Dimension(90, 20));
        panelAux.add((Component)this.textHoraFin, cons);
        cons.gridwidth = 2;
        cons.gridy += 3;
        cons.gridx = x + 1;
        cons.insets = new Insets(0, 0, 0, 0);
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 1));
        this.buttonConsultar.setPreferredSize(new Dimension(141, 25));
        panel.add(this.buttonConsultar);
        panelAux.add((Component)panel, cons);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoFiltroEtiquetas.this.textDataIni.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroEtiquetas.this.textDataIni, DialogoFiltroEtiquetas.this.buttonDataIni, (JPanel)DialogoFiltroEtiquetas.this.buttonDataIni.getParent(), true);
                } else if (DialogoFiltroEtiquetas.this.textDataFin.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroEtiquetas.this.textDataFin, DialogoFiltroEtiquetas.this.buttonDataFin, (JPanel)DialogoFiltroEtiquetas.this.buttonDataFin.getParent(), true);
                }
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        table.getTableHeader().addMouseListener(this.modReq);
        this.modReq.setOrdenarColunas(true);
        this.modReq.ordenarColuna(0, 1);
    }
}

