/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.resultados.DadosIdade;
import jalis.laboratorio.resultados.DadosMaterialIdadeMetodo;
import jalis.laboratorio.resultados.DadosMetodo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class DialogoExameMaterialLayout
extends JDialog
implements ActionListener,
FocusListener {
    JLabel labelNomeExame = ComponenteFactory.novoJLabel("", new Dimension(22, 22), BorderFactory.createTitledBorder(""));
    JButton buttonBuscaExame = ComponenteFactory.novoJButton(this, null, new Dimension(22, 22), true);
    JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    TTextField textExame = new TTextField(5);
    JComboBox comboMaterial = new JComboBox();
    JComboBox comboMetodo = new JComboBox();
    JComboBox comboIdade = new JComboBox();
    private boolean ok = false;
    private String codigoFilial;
    private String codigoModelo;
    boolean usandoPadrao = false;

    public static DialogoExameMaterialLayout novaInstancia(Object pai, String titulo, String filial) {
        if (pai instanceof Frame) {
            return new DialogoExameMaterialLayout((Frame)pai, titulo, filial);
        }
        if (pai instanceof Dialog) {
            return new DialogoExameMaterialLayout((Dialog)pai, titulo, filial);
        }
        return null;
    }

    public DialogoExameMaterialLayout(Frame pai, String titulo, String filial) {
        super(pai, titulo, true);
        this.codigoFilial = filial;
        this.iniciar(pai);
    }

    public DialogoExameMaterialLayout(Dialog pai, String titulo, String filial) {
        super(pai, titulo, true);
        this.codigoFilial = filial;
        this.iniciar(pai);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.comboMaterial) {
            if (this.comboMaterial.getSelectedItem() == null) {
                return;
            }
            this.comboIdade.removeAllItems();
            ArrayList<DadosIdade> idades = ((DadosMaterialIdadeMetodo)this.comboMaterial.getSelectedItem()).getIdades();
            if (idades != null) {
                for (DadosIdade idade : idades) {
                    this.comboIdade.addItem(idade);
                }
            }
        } else if (o == this.comboIdade) {
            if (this.comboIdade.getSelectedItem() == null) {
                return;
            }
            this.comboMetodo.removeAllItems();
            ArrayList<DadosMetodo> metodos = ((DadosIdade)this.comboIdade.getSelectedItem()).getMetodos();
            if (metodos != null) {
                for (DadosMetodo metodo : metodos) {
                    this.comboMetodo.addItem(metodo);
                }
            }
        } else if (o == this.buttonOk) {
            if (this.labelNomeExame.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "Exame n\u00e3o cadastrado", 1);
                ScreenUtil.requisitarFoco(this.textExame);
            } else if (this.comboMaterial.getSelectedItem() == null) {
                Funcoes.mensagem(this, "Exame n\u00e3o informado", 1);
                ScreenUtil.requisitarFoco(this.textExame);
            } else {
                this.ok = true;
                this.dispose();
            }
        } else if (o == this.buttonCancelar) {
            this.dispose();
        } else if (o == this.buttonBuscaExame) {
            this.buscaExame();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object o;
        if (!e.isTemporary() && (o = e.getSource()) == this.textExame && !(e.getOppositeComponent() instanceof JButton)) {
            this.carregarExame();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public void setCodigoModelo(String codigo) {
        this.codigoModelo = codigo;
    }

    public String getCodigoModelo() {
        return this.codigoModelo;
    }

    public boolean isUsandoPadrao() {
        return this.usandoPadrao;
    }

    public String getCodigoExame() {
        return this.textExame.getText();
    }

    public String getCodigoMaterial() {
        return String.valueOf(((DadosMaterial)this.comboMaterial.getSelectedItem()).getCodigo());
    }

    public String getCodigoMetodo() {
        return String.valueOf(((DadosMetodo)this.comboMetodo.getSelectedItem()).codigo);
    }

    public String getIdadeInicial() {
        return String.valueOf(((DadosIdade)this.comboIdade.getSelectedItem()).idadeInicial);
    }

    public String getIdadeFinal() {
        return String.valueOf(((DadosIdade)this.comboIdade.getSelectedItem()).idadeFinal);
    }

    public String getTipoIdadeInicial() {
        return ((DadosIdade)this.comboIdade.getSelectedItem()).tipoInicial;
    }

    public String getTipoIdadeFinal() {
        return ((DadosIdade)this.comboIdade.getSelectedItem()).tipoFinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregarExame() {
        block6: {
            block7: {
                Statement stMat;
                Statement st;
                block5: {
                    String exa = this.textExame.getText().trim();
                    if (exa.length() <= 0) break block7;
                    st = Conexao.getStatement();
                    stMat = Conexao.getStatement();
                    if (st == null || stMat == null) break block6;
                    try {
                        this.comboMaterial.removeAllItems();
                        StringBuilder bui = new StringBuilder("select exa_descricao ");
                        bui.append("from exames where fil_codigo = ");
                        bui.append(this.codigoFilial);
                        bui.append(" and exa_codigo = '");
                        bui.append(this.textExame.getTextDB());
                        bui.append("'");
                        ResultSet res = Conexao.executeQuery(st, bui.toString());
                        if (res.next()) {
                            this.labelNomeExame.setText(res.getString("exa_descricao"));
                            this.carregarMateriaisColeta(exa, this.codigoFilial, this.comboMaterial);
                            ScreenUtil.requisitarFoco(this.comboMaterial);
                            break block5;
                        }
                        this.labelNomeExame.setText("N\u00e3o cadastrado");
                        ScreenUtil.requisitarFoco(this.textExame);
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoExameMaterialLayout: 185");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            Conexao.fecharStatement(stMat);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                        Conexao.fecharStatement(stMat);
                        break block6;
                    }
                }
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(stMat);
                break block6;
            }
            this.labelNomeExame.setText("");
            this.comboMaterial.setSelectedItem(null);
        }
    }

    private void buscaExame() {
        Hashtable table = Pesquisas.exameAMB(this, false, true);
        if (table != null) {
            this.textExame.setText(table.get("exa_codigo").toString());
            ScreenUtil.requisitarFoco(this.textExame);
        }
    }

    private void definirTeclas() {
        JComponent comp = (JComponent)this.getContentPane();
        ScreenUtil.addActionMap(comp, KeyStroke.getKeyStroke(113, 0, true), "f2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoExameMaterialLayout.this.buscaExame();
            }
        });
        ScreenUtil.addActionMap(comp, KeyStroke.getKeyStroke(10, 0, true), "enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                } else {
                    FocusManager.getCurrentManager().focusNextComponent();
                }
            }
        });
    }

    private void iniciar(Component owner) {
        this.setSize(new Dimension(660, 160));
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        this.getContentPane().add((Component)panel, "South");
        panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        panel.add((Component)new JLabel("Exame:"), cons);
        cons.gridy = 1;
        cons.gridx = 0;
        this.textExame.setPreferredSize(new Dimension(60, 20));
        this.textExame.setUpperCase(true);
        this.textExame.addFocusListener(this);
        panel.add((Component)this.textExame, cons);
        cons.gridx = 1;
        this.buttonBuscaExame.setFocusable(false);
        this.buttonBuscaExame.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaExame.setMaximumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonBuscaExame, cons);
        cons.gridx = 2;
        cons.weightx = 0.5;
        this.labelNomeExame.setPreferredSize(new Dimension(100, 20));
        panel.add((Component)this.labelNomeExame, cons);
        cons.gridy = 0;
        cons.gridx = 3;
        cons.weightx = 0.0;
        panel.add((Component)new JLabel("Material: "), cons);
        cons.gridy = 1;
        cons.gridx = 3;
        this.comboMaterial.setPreferredSize(new Dimension(200, 20));
        this.comboMaterial.setMinimumSize(new Dimension(200, 20));
        panel.add((Component)this.comboMaterial, cons);
        cons.gridy = 2;
        cons.gridx = 0;
        cons.weightx = 0.0;
        panel.add((Component)new JLabel("Idade: "), cons);
        cons.gridy = 3;
        cons.gridx = 0;
        cons.gridwidth = 3;
        cons.weightx = 1.0;
        this.comboIdade.setPreferredSize(new Dimension(200, 20));
        this.comboIdade.setMinimumSize(new Dimension(200, 20));
        panel.add((Component)this.comboIdade, cons);
        cons.gridy = 2;
        cons.gridx = 3;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        panel.add((Component)new JLabel("M\u00e9todo: "), cons);
        cons.gridy = 3;
        cons.gridx = 3;
        this.comboMetodo.setPreferredSize(new Dimension(200, 20));
        this.comboMaterial.setMinimumSize(new Dimension(200, 20));
        panel.add((Component)this.comboMetodo, cons);
        this.comboMaterial.addActionListener(this);
        this.comboIdade.addActionListener(this);
        this.definirTeclas();
        ScreenUtil.requisitarFoco(this.textExame);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregarMateriaisColeta(String exame, String filial, JComboBox combo) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        int posCombo = 0;
        if (st != null && exame != null && filial != null && combo != null) {
            block13: {
                try {
                    combo.removeAllItems();
                    StringBuilder tmp = new StringBuilder("select a.mco_codigo, a.mco_descricao,  ");
                    tmp.append("a.mco_abreviatura, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo ");
                    tmp.append("from examelayout b ");
                    tmp.append("left join materialcoleta a on a.fil_codigo = b.fil_codigo and b.mco_codigo = a.mco_codigo ");
                    tmp.append("left join examematcoleta emc on emc.fil_codigo = a.fil_codigo and emc.mco_codigo = a.mco_codigo and emc.exa_codigo = b.exa_codigo ");
                    tmp.append("where b.fil_codigo =" + filial + " and upper(b.exa_codigo) = upper('");
                    tmp.append(StringUtil.textoDB(exame));
                    tmp.append("')");
                    tmp.append(" and b.lay_codigo = ").append(this.codigoModelo).append(" and emc.emc_proibido=false");
                    tmp.append(" order by a.mco_descricao, ");
                    tmp.append("b.ela_idadeini, b.ela_idadefim ");
                    ResultSet rs = Conexao.executeQuery(st, tmp.toString());
                    if (!rs.next()) {
                        tmp.setLength(0);
                        tmp.append(" select a.mco_codigo ");
                        tmp.append("       ,a.mco_descricao ");
                        tmp.append("       ,a.mco_abreviatura ");
                        tmp.append("       ,b.ela_idadeini ");
                        tmp.append("       ,b.ela_idadefim ");
                        tmp.append("       ,b.ela_idadeinitipo ");
                        tmp.append("       ,b.ela_idadefimtipo ");
                        tmp.append("       ,b.lay_codigo ");
                        tmp.append("   from examelayout b ");
                        tmp.append("   left join materialcoleta a on a.fil_codigo = b.fil_codigo and b.mco_codigo = a.mco_codigo ");
                        tmp.append("  where b.fil_codigo = ").append(filial);
                        tmp.append("    and upper(b.exa_codigo) = upper('").append(StringUtil.textoDB(exame)).append("') ");
                        tmp.append("    and b.ela_padrao ");
                        tmp.append("  order by a.mco_descricao ");
                        tmp.append("          ,b.ela_idadeini ");
                        tmp.append("          ,b.ela_idadefim ");
                        rs = Conexao.executeQuery(st, tmp.toString());
                        this.usandoPadrao = true;
                    } else {
                        rs.beforeFirst();
                    }
                    boolean adicionarMaterial = true;
                    while (rs.next()) {
                        DadosMaterialIdadeMetodo d = null;
                        for (int i = 0; i < this.comboMaterial.getItemCount(); ++i) {
                            if (((DadosMaterialIdadeMetodo)this.comboMaterial.getItemAt(i)).getCodigo() != rs.getInt("mco_codigo")) continue;
                            d = (DadosMaterialIdadeMetodo)this.comboMaterial.getItemAt(i);
                            adicionarMaterial = false;
                            break;
                        }
                        if (adicionarMaterial) {
                            d = new DadosMaterialIdadeMetodo(rs.getInt("mco_codigo"), rs.getString("mco_descricao"));
                            d.setAbreviatura(rs.getString("mco_abreviatura"));
                        }
                        DadosIdade idade = new DadosIdade(rs.getInt("ela_idadeini"), rs.getInt("ela_idadefim"), rs.getString("ela_idadeinitipo"), rs.getString("ela_idadefimtipo"));
                        tmp.setLength(0);
                        tmp.append("select a.met_codigo, b.met_descricao ");
                        tmp.append("from examelayoutmetodo a ");
                        tmp.append("left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo ");
                        tmp.append("where a.fil_codigo = ").append(filial);
                        tmp.append(" and a.exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
                        tmp.append(" and a.mco_codigo = ").append(rs.getString("mco_codigo"));
                        tmp.append(" and a.lay_codigo = ").append(this.usandoPadrao ? Integer.valueOf(rs.getInt("lay_codigo")) : this.codigoModelo);
                        tmp.append(" and a.ela_idadeini = ").append(rs.getString("ela_idadeini"));
                        tmp.append(" and a.ela_idadefim = ").append(rs.getString("ela_idadefim"));
                        tmp.append(" and a.ela_idadeinitipo = '").append(rs.getString("ela_idadeinitipo")).append("' ");
                        tmp.append(" and a.ela_idadefimtipo = '").append(rs.getString("ela_idadefimtipo")).append("' ");
                        ResultSet rsM = Conexao.executeQuery(st2, tmp);
                        while (rsM.next()) {
                            idade.adicionarMetodo(rsM.getString("met_codigo"), rsM.getString("met_descricao"));
                        }
                        if (this.usandoPadrao) {
                            this.setCodigoModelo(rs.getString("lay_codigo"));
                        }
                        d.adicionarIdade(idade);
                        if (adicionarMaterial) {
                            combo.addItem(d);
                        }
                        adicionarMaterial = true;
                    }
                    if (combo.getItemCount() <= 0) break block13;
                    combo.setSelectedIndex(posCombo > -1 ? posCombo : 0);
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 205");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st, st2);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st, st2);
                }
            }
            Conexao.fecharStatement(st, st2);
        }
    }
}

