/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class DialogoExameMaterial
extends JDialog
implements ActionListener,
FocusListener {
    JLabel labelNomeExame = ComponenteFactory.novoJLabel("", new Dimension(22, 22), BorderFactory.createTitledBorder(""));
    JButton buttonBuscaExame = ComponenteFactory.novoJButton(this, null, new Dimension(22, 22), true);
    JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    TTextField textExame = new TTextField(5);
    SteppedComboBox comboMaterial = new SteppedComboBox(150);
    private boolean ok = false;
    private String codigoFilial;
    private String codigoRequisicao;

    public static DialogoExameMaterial novaInstancia(Object pai, String titulo, String filial, String requisica) {
        if (pai instanceof Frame) {
            return new DialogoExameMaterial((Frame)pai, titulo, filial, requisica);
        }
        if (pai instanceof Dialog) {
            return new DialogoExameMaterial((Dialog)pai, titulo, filial, requisica);
        }
        return null;
    }

    public DialogoExameMaterial(Frame pai, String titulo, String filial, String requisicao) {
        super(pai, titulo, true);
        this.codigoFilial = filial;
        this.codigoRequisicao = requisicao;
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public DialogoExameMaterial(Dialog pai, String titulo, String filial, String requisicao) {
        super(pai, titulo, true);
        this.codigoFilial = filial;
        this.codigoRequisicao = requisicao;
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk) {
            if (this.labelNomeExame.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "Exame n\u00e3o cadastrado", 1);
                ScreenUtil.requisitarFoco(this.textExame);
            } else if (this.comboMaterial.getSelectedItem() == null) {
                Funcoes.mensagem(this, "Exame n\u00e3o informado", 1);
                ScreenUtil.requisitarFoco(this.textExame);
            } else {
                this.ok = true;
                this.dispose();
            }
        } else if (o == this.buttonCancelar) {
            this.dispose();
        } else if (o == this.buttonBuscaExame) {
            this.buscaExame();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object o;
        if (!e.isTemporary() && (o = e.getSource()) == this.textExame && !(e.getOppositeComponent() instanceof JButton)) {
            this.carregarExame();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public DadosExames getDadosExames() {
        try {
            Object o = this.comboMaterial.getSelectedItem();
            if (o instanceof DadosMaterial) {
                DadosExames dadosExames = ExameUtil.getDadosExame(this.codigoFilial, this.textExame.getText(), (DadosMaterial)o);
                return ExameUtil.getDadosExame(this.codigoFilial, this.textExame.getText(), (DadosMaterial)o);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoExameMaterial: 139");
        }
        return null;
    }

    public DadosMaterial getDadosMaterial() {
        Object o = this.comboMaterial.getSelectedItem();
        if (o instanceof DadosMaterial) {
            return (DadosMaterial)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregarExame() {
        block7: {
            block8: {
                Statement stMat;
                Statement st;
                block6: {
                    String exa = this.textExame.getText().trim();
                    if (exa.length() <= 0) break block8;
                    st = Conexao.getStatement();
                    stMat = Conexao.getStatement();
                    if (st == null || stMat == null) break block7;
                    try {
                        this.comboMaterial.removeAllItems();
                        StringBuilder bui = new StringBuilder("select exa_descricao, exa_salvaparcial ");
                        bui.append("from exames where fil_codigo = ");
                        bui.append(this.codigoFilial);
                        bui.append(" and exa_codigo = '");
                        bui.append(this.textExame.getTextDB());
                        bui.append("'");
                        ResultSet res = Conexao.executeQuery(st, bui.toString());
                        if (res.next()) {
                            this.labelNomeExame.setText(res.getString("exa_descricao"));
                            ExameUtil.carregarMateriaisColeta(exa, this.codigoFilial, this.comboMaterial);
                            ScreenUtil.requisitarFoco(this.comboMaterial);
                            if (!this.contemComponentesCombo()) {
                                Funcoes.mensagem(this, "O exame est\u00e1 proibido.", 2);
                                this.textExame.selectAll();
                                ScreenUtil.requisitarFoco(this.textExame);
                            }
                            break block6;
                        }
                        this.labelNomeExame.setText("N\u00e3o cadastrado");
                        ScreenUtil.requisitarFoco(this.textExame);
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoExameMaterial: 185");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            Conexao.fecharStatement(stMat);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                        Conexao.fecharStatement(stMat);
                        break block7;
                    }
                }
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(stMat);
                break block7;
            }
            this.labelNomeExame.setText("");
            this.comboMaterial.setSelectedItem(null);
        }
    }

    public boolean contemComponentesCombo() {
        return this.comboMaterial.getItemCount() > 0;
    }

    private void buscaExame() {
        Hashtable table = Pesquisas.exameAMB(this, false, true);
        if (table != null) {
            this.textExame.setText(table.get("exa_codigo").toString());
            ScreenUtil.requisitarFoco(this.textExame);
        }
    }

    private void definirTeclas() {
        JComponent comp = (JComponent)this.getContentPane();
        ScreenUtil.addActionMap(comp, KeyStroke.getKeyStroke(113, 0, true), "f2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoExameMaterial.this.buscaExame();
            }
        });
        ScreenUtil.addActionMap(comp, KeyStroke.getKeyStroke(10, 0, true), "enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                } else {
                    FocusManager.getCurrentManager().focusNextComponent();
                }
            }
        });
    }

    private void iniciar() {
        this.comboMaterial.setPreferredSize(new Dimension(50, 20));
        this.comboMaterial.setMinimumSize(new Dimension(50, 20));
        this.setSize(new Dimension(700, 120));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        this.getContentPane().add((Component)panel, "South");
        panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)new JLabel("Exame:"), cons);
        cons.gridx = 1;
        cons.insets = new Insets(1, 1, 0, 0);
        this.textExame.setPreferredSize(new Dimension(60, 22));
        this.textExame.setUpperCase(true);
        this.textExame.addFocusListener(this);
        panel.add((Component)this.textExame, cons);
        cons.gridx = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        this.buttonBuscaExame.setFocusable(false);
        panel.add((Component)this.buttonBuscaExame, cons);
        cons.gridx = 3;
        cons.weightx = 0.5;
        panel.add((Component)this.labelNomeExame, cons);
        cons.gridx = 4;
        cons.weightx = 0.0;
        panel.add((Component)new JLabel(" Material: "), cons);
        cons.gridx = 5;
        this.comboMaterial.setPreferredSize(new Dimension(100, 22));
        panel.add((Component)this.comboMaterial, cons);
        this.definirTeclas();
        ScreenUtil.requisitarFoco(this.textExame);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

