/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DialogoConferenciaAutomatica
extends JDialog
implements ActionListener {
    JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    JTextArea texto = new JTextArea();
    private JScrollPane scrollTexto = new JScrollPane(this.texto);
    private String codigoFilial;
    private String codigoRequisicao;
    private String codigoExame;
    private String codigoMaterial;
    private String conferencia = "";

    public static DialogoConferenciaAutomatica novaInstancia(Object pai, String titulo, String filial, String requisicao, String exame, String material) {
        if (pai instanceof Frame) {
            return new DialogoConferenciaAutomatica((Frame)pai, titulo, filial, requisicao, exame, material);
        }
        if (pai instanceof Dialog) {
            return new DialogoConferenciaAutomatica((Dialog)pai, titulo, filial, requisicao, exame, material);
        }
        return null;
    }

    public DialogoConferenciaAutomatica(Frame pai, String titulo, String filial, String requisicao, String exame, String material) {
        super(pai, titulo, true);
        this.codigoFilial = filial;
        this.codigoRequisicao = requisicao;
        this.codigoExame = exame;
        this.codigoMaterial = material;
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public DialogoConferenciaAutomatica(Dialog pai, String titulo, String filial, String requisicao, String exame, String material) {
        super(pai, titulo, true);
        this.codigoFilial = filial;
        this.codigoRequisicao = requisicao;
        this.codigoExame = exame;
        this.codigoMaterial = material;
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    private void iniciar() {
        this.texto.setEditable(false);
        this.texto.setLineWrap(true);
        this.texto.setWrapStyleWord(true);
        ScreenUtil.posicionaTextoTopo(this.texto);
        this.setSize(new Dimension(500, 300));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        panel.add(this.buttonFechar);
        this.getContentPane().add((Component)panel, "South");
        this.getContentPane().add((Component)this.scrollTexto, "Center");
        try {
            this.getCamposConferencia();
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoConverenciaAutomatica: 70");
        }
    }

    public static boolean isConferenciaAutomatica(String filial, String requisicao, String exame, String material) {
        Boolean isConferencia = false;
        StringBuilder bui = new StringBuilder();
        bui.append("select count(ier_logconfautomatica) > 0  as isConferencia from interfaceexamerequisicao where fil_codigo = ");
        bui.append(filial);
        bui.append(" and req_codigo  = ");
        bui.append(requisicao);
        bui.append(" and exa_codigo = '");
        bui.append(exame);
        bui.append("' and mco_codigo = ");
        bui.append(material);
        bui.append(" and ier_logconfautomatica is  not null ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet res = Conexao.executeQuery(st, bui.toString());
            if (res.next()) {
                isConferencia = res.getBoolean("isConferencia");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "DialogoConverenciaAutomatica: 93");
        }
        return isConferencia;
    }

    private void getCamposConferencia() throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select ier_logconfautomatica from interfaceexamerequisicao where fil_codigo = ");
        bui.append(this.codigoFilial);
        bui.append(" and req_codigo  = ");
        bui.append(this.codigoRequisicao);
        bui.append("and exa_codigo = '");
        bui.append(this.codigoExame);
        bui.append("' and mco_codigo = ");
        bui.append(this.codigoMaterial);
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, bui.toString());
        if (res.next()) {
            this.conferencia = res.getString("ier_logconfautomatica");
            this.texto.setText(this.conferencia);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.dispose();
        }
    }
}

