/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.resultados;

import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ImpressaoUtil;
import jalis.laboratorio.impressao.ResultadoNaPagina;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class ConteudoTextoResultado {
    private static final Integer TOLERANCIA_ENTRE_LINHAS = 4;
    private final Documento documentoImpressao;

    private ConteudoTextoResultado(Documento documentoImpressao) {
        this.documentoImpressao = documentoImpressao;
    }

    public static ConteudoTextoResultado novaInstancia(Documento documentoImpressao) {
        return new ConteudoTextoResultado(documentoImpressao);
    }

    public StringBuilder getLaudoCompleto() {
        StringBuilder completo = new StringBuilder();
        completo.append((CharSequence)this.getCabecalho());
        completo.append((CharSequence)this.getResultado());
        completo.append((CharSequence)this.getRodapeExame());
        completo.append((CharSequence)this.getSumario());
        completo.append((CharSequence)this.getRodape());
        return completo;
    }

    public StringBuilder getCabecalho() {
        List<ComponenteImpressao> componentes = ImpressaoUtil.getComponentesImpressao(this.documentoImpressao.getComponentesCabecalho(), true);
        return this.converterComponentesParaString(componentes);
    }

    public StringBuilder getResultado() {
        ResultadoNaPagina[] resultado = this.documentoImpressao.getResultadoNaPagina(0);
        ArrayList<ComponenteImpressao> componentesImpressao = new ArrayList<ComponenteImpressao>();
        for (int i = 0; i < resultado.length; ++i) {
            componentesImpressao.addAll(ImpressaoUtil.getComponentesImpressao(resultado[i].getResultado(), null, true));
        }
        return this.converterComponentesParaString(componentesImpressao);
    }

    public StringBuilder getRodapeExame() {
        StringBuilder textoRodapeExame = new StringBuilder();
        if (this.documentoImpressao.exibirRodapeExame()) {
            List<ComponenteImpressao> componentes = ImpressaoUtil.getComponentesImpressao(this.documentoImpressao.getComponentesRodapeExame(), true);
            textoRodapeExame = this.converterComponentesParaString(componentes);
        }
        return textoRodapeExame;
    }

    public StringBuilder getSumario() {
        StringBuilder textoSumario = new StringBuilder();
        if (this.documentoImpressao.exibirSumario()) {
            List<ComponenteImpressao> componentes = ImpressaoUtil.getComponentesImpressao(this.documentoImpressao.getComponentesSumario(), true);
            textoSumario = this.converterComponentesParaString(componentes);
        }
        return textoSumario;
    }

    public StringBuilder getRodape() {
        List<ComponenteImpressao> componentes = ImpressaoUtil.getComponentesImpressao(this.documentoImpressao.getComponentesRodape(), true);
        return this.converterComponentesParaString(componentes);
    }

    private StringBuilder converterComponentesParaString(List<ComponenteImpressao> componentes) {
        Map<Integer, List<ComponenteImpressao>> ordenadosPorLinha = this.definirOrdemDasLinhas(componentes);
        StringBuilder textoComponente = new StringBuilder();
        for (Map.Entry<Integer, List<ComponenteImpressao>> linha : ordenadosPorLinha.entrySet()) {
            List<ComponenteImpressao> ordenadosPorColuna = this.getComponentesOrdenadosPorColuna(linha.getValue());
            StringBuilder conteudoLinha = new StringBuilder();
            for (int c = 0; c < ordenadosPorColuna.size(); ++c) {
                int qtdeEspaco;
                JComponent componente;
                if (ordenadosPorColuna.get(c) instanceof TextoDigitacao) {
                    componente = (TextoDigitacao)ordenadosPorColuna.get(c);
                    int qtdeEspacoAnterior = qtdeEspaco = this.calcularPosicaoTextoDigitacao((TextoDigitacao)componente);
                    if (c > 0) {
                        qtdeEspacoAnterior = qtdeEspaco - conteudoLinha.toString().length();
                    }
                    conteudoLinha.append(this.quebrarLinha((JTextPane)componente, ((JEditorPane)componente).getText(), qtdeEspaco, qtdeEspacoAnterior));
                    continue;
                }
                componente = (TextoEstatico)ordenadosPorColuna.get(c);
                qtdeEspaco = this.calcularPosicaoComponente((TextoEstatico)componente);
                if (c > 0) {
                    qtdeEspaco = ordenadosPorColuna.get(c - 1) instanceof TextoEstatico && ((TextoEstatico)ordenadosPorColuna.get(c - 1)).getHorizontalAlignment() == 4 && ((JLabel)componente).getHorizontalAlignment() == 2 ? (qtdeEspaco -= conteudoLinha.length() * 2) : (qtdeEspaco -= conteudoLinha.length());
                }
                conteudoLinha.append(this.gerarEspacos(qtdeEspaco));
                conteudoLinha.append(((TextoEstatico)componente).getTextoSemHTML());
            }
            textoComponente.append(conteudoLinha.toString() + System.lineSeparator());
        }
        return textoComponente;
    }

    private String gerarEspacos(int qtdeEspacos) {
        StringBuilder espaco = new StringBuilder();
        for (int e = 0; e < qtdeEspacos; ++e) {
            espaco.append(" ");
        }
        return espaco.toString();
    }

    private List<ComponenteImpressao> getComponentesOrdenadosPorColuna(List<ComponenteImpressao> componentesPorLinha) {
        return componentesPorLinha.stream().sorted(Comparator.comparingInt(componente -> (int)componente.getDimensoes().getX())).collect(Collectors.toList());
    }

    private Map<Integer, List<ComponenteImpressao>> definirOrdemDasLinhas(List<ComponenteImpressao> componentes) {
        List<ComponenteImpressao> organizadosPorTopo = this.getComponentesOrdenadosPorTopo(componentes);
        HashMap<Integer, List<ComponenteImpressao>> ordenadosPorLinha = new HashMap<Integer, List<ComponenteImpressao>>();
        ArrayList<ComponenteImpressao> componentesPorLinha = new ArrayList<ComponenteImpressao>();
        int numeroLinha = 1;
        for (int c = 0; c < organizadosPorTopo.size(); ++c) {
            int topoAtual = (int)organizadosPorTopo.get(c).getDimensoes().getY();
            int proximoTopo = -1;
            if (c + 1 < organizadosPorTopo.size()) {
                proximoTopo = (int)organizadosPorTopo.get(c + 1).getDimensoes().getY();
            }
            if (proximoTopo > -1 && proximoTopo - topoAtual <= TOLERANCIA_ENTRE_LINHAS) {
                componentesPorLinha.add(organizadosPorTopo.get(c));
                continue;
            }
            componentesPorLinha.add(organizadosPorTopo.get(c));
            ordenadosPorLinha.put(numeroLinha, componentesPorLinha);
            componentesPorLinha = new ArrayList();
            ++numeroLinha;
        }
        return ordenadosPorLinha;
    }

    private List<ComponenteImpressao> getComponentesOrdenadosPorTopo(List<ComponenteImpressao> componentes) {
        List componentesImpressos = componentes.stream().filter(componente -> (componente instanceof TextoEstatico || componente instanceof TextoDigitacao) && componente.imprimir()).collect(Collectors.toList());
        return componentesImpressos.stream().sorted(Comparator.comparingInt(componente -> (int)componente.getDimensoes().getY())).collect(Collectors.toList());
    }

    private int calcularPosicaoComponente(TextoEstatico componente) {
        int tamanhoString = componente.getTextoSemHTML().length();
        int posicao = this.documentoImpressao.getMargemEsquerda();
        switch (componente.getHorizontalAlignment()) {
            case 4: {
                int posicaoDireita = componente.getX() + componente.getWidth();
                posicao += posicaoDireita <= tamanhoString ? componente.getX() : componente.getX() - tamanhoString;
                break;
            }
            case 0: {
                int posicaoCentro = componente.getX() + componente.getWidth() / 2;
                posicao += posicaoCentro <= tamanhoString ? componente.getX() : posicaoCentro - tamanhoString * 2;
                break;
            }
            default: {
                posicao += componente.getX();
            }
        }
        BigDecimal posicaoCalculada = BigDecimal.ZERO;
        if (posicao / 5 > 1) {
            posicaoCalculada = new BigDecimal(posicao).divide(new BigDecimal("5"), RoundingMode.HALF_EVEN);
        }
        return posicaoCalculada.compareTo(BigDecimal.ONE) <= 0 ? 1 : posicaoCalculada.intValue();
    }

    private String quebrarLinha(JTextPane textPane, String conteudo, int qtdeEspaco, int qtdeEspacoAnterior) {
        int i;
        conteudo = conteudo.replace("&#xa;", System.lineSeparator()).replace("\n", System.lineSeparator()).replace("\r\n", System.lineSeparator());
        Font fonte = new Font("Monospaced", 0, 8);
        FontMetrics fm = textPane.getFontMetrics(fonte);
        StringBuilder linha = new StringBuilder();
        StringBuilder conteudoComQuebra = new StringBuilder();
        boolean adicionarEspaco = true;
        String[] palavras = conteudo.split(" ");
        if (palavras.length == 1) {
            adicionarEspaco = false;
            palavras = new String[conteudo.length()];
            for (i = 0; i < conteudo.length(); ++i) {
                palavras[i] = String.valueOf(conteudo.charAt(i));
            }
        }
        for (i = 0; i < palavras.length; ++i) {
            int larguraCalculada;
            if (adicionarEspaco) {
                linha.append(palavras[i] + " ");
            } else {
                linha.append(palavras[i]);
            }
            if (palavras.length - i <= 1) continue;
            String proximaPalavra = palavras[i + 1];
            int larguraProximaPalavra = fm.charsWidth(proximaPalavra.toCharArray(), 0, proximaPalavra.length());
            if (linha.toString().contains(System.lineSeparator())) {
                int quebra = linha.indexOf(System.lineSeparator());
                String linha1 = linha.substring(0, quebra);
                String linha2 = linha.substring(quebra + 2, linha.length());
                conteudoComQuebra.append(linha1 + System.lineSeparator());
                linha = new StringBuilder();
                linha.append(linha2);
            }
            if ((larguraCalculada = fm.charsWidth(linha.toString().toCharArray(), 0, linha.toString().length())) + larguraProximaPalavra <= textPane.getWidth()) continue;
            conteudoComQuebra.append(linha.toString() + System.lineSeparator());
            linha = new StringBuilder();
        }
        conteudoComQuebra.append(linha.toString());
        StringBuilder bui = new StringBuilder();
        String[] conteudoComponente = conteudoComQuebra.toString().split(System.lineSeparator());
        for (int i2 = 0; i2 < conteudoComponente.length; ++i2) {
            if (i2 != conteudoComponente.length - 1 && i2 == 0) {
                bui.append(this.gerarEspacos(qtdeEspacoAnterior) + conteudoComponente[i2] + "\n");
                continue;
            }
            if (i2 != conteudoComponente.length - 1 && i2 != 0) {
                bui.append(this.gerarEspacos(qtdeEspaco) + conteudoComponente[i2] + "\n");
                continue;
            }
            if (conteudoComponente.length > 1 && i2 != 0) {
                bui.append(this.gerarEspacos(qtdeEspaco) + conteudoComponente[i2]);
                continue;
            }
            bui.append(this.gerarEspacos(qtdeEspacoAnterior) + conteudoComponente[i2]);
        }
        return bui.toString();
    }

    private int calcularPosicaoTextoDigitacao(TextoDigitacao componente) {
        int tamanhoString = componente.getText().length();
        int posicao = this.documentoImpressao.getMargemEsquerda();
        switch (componente.getAlinhamentoHorizontal()) {
            case 2: {
                int posicaoDireita = componente.getX() + componente.getWidth();
                posicao += posicaoDireita <= tamanhoString ? componente.getX() : componente.getX() - tamanhoString;
                break;
            }
            case 3: {
                int posicaoCentro = componente.getX() + componente.getWidth() / 2;
                posicao += posicaoCentro <= tamanhoString ? componente.getX() : posicaoCentro - tamanhoString * 2;
                break;
            }
            default: {
                posicao += componente.getX();
            }
        }
        BigDecimal posicaoCalculada = BigDecimal.ZERO;
        if (posicao / 5 > 1) {
            posicaoCalculada = new BigDecimal(posicao).divide(new BigDecimal("5"), RoundingMode.HALF_EVEN);
        }
        return posicaoCalculada.compareTo(BigDecimal.ONE) <= 0 ? 1 : posicaoCalculada.intValue();
    }
}

