/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioTemperaturas
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_GELADEIRA = "filtroGeladeira";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private static final String FILTRO_INATIVA = "filtroInativa";
    private static final String FILTRO_TEMP_MINIMA = "filtroTempMinima";
    private static final String FILTRO_TEMP_MAXIMA = "filtroTempMaxima";
    private static final String[] CAMPOS_GELADEIRAS = new String[]{"codigoGeladeira", "descricaoGeladeira", "inativaGeladeira", "codigoSetor"};
    private static final String[] CAMPOS_SETORES = new String[]{"descricaoSetor", "siglaSetor"};
    private static final String[] CAMPOS_TEMPERATURAS = new String[]{"temperatura", "dataHoraTemperatura", "temperaturaMinima", "temperaturaMaxima", "codigoUsuarioTemperatura", "observacao"};
    private static String[] campos = null;

    public RelatorioTemperaturas() {
        this.montaBarraDescricao("Relat\u00f3rio de Geladeiras", "Listagem do registro de controle de temperaturas das geladeiras", "relatorios/rel_temperatura_geladeira.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_GELADEIRA, "Geladeira", "geladeiras", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"gel_codigo", "gel_descricao", "gel_inativa"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa"}, new int[]{70, 0, 50});
        this.adicionaFiltroDecimal(FILTRO_TEMP_MINIMA, "Temp. M\u00ednima", 12);
        this.adicionaFiltroDecimal(FILTRO_TEMP_MAXIMA, "Temp. M\u00e1xima", 12);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora Inicial");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora Final");
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_INATIVA, "Mostrar Geladeiras Inativas", false);
        this.setModuloConfigurar(RelatorioTemperaturas.getModuloConfigurar());
        this.setModuloAcesso(RelatorioTemperaturas.getModuloAcesso());
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, CAMPOS_GELADEIRAS);
        campos = ArraysUtil.concatenar(campos, CAMPOS_SETORES);
        campos = ArraysUtil.concatenar(campos, CAMPOS_TEMPERATURAS);
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block29: {
            boolean intervaloHora = this.getFiltroCheck(FILTRO_INTERVALO_HORA);
            if (intervaloHora) {
                if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.gel_codigo \t\t\tas codigoGeladeira ");
                buf.append("       ,a.gel_descricao \tas descricaoGeladeira ");
                buf.append("       ,a.gel_inativa \t\tas inativaGeladeira ");
                buf.append("       ,a.set_codigo \t\t\tas codigoSetor ");
                buf.append("       ,set.set_descricao \tas descricaoSetor ");
                buf.append("       ,set.set_sigla \t\t\tas siglaSetor ");
                buf.append("       ,get.get_temperatura as temperatura ");
                buf.append("       ,get.get_tempminima \tas temperaturaMinima ");
                buf.append("       ,get.get_tempmaxima \tas temperaturaMaxima ");
                buf.append("       ,get.get_datahora \t\tas dataHoraTemperatura ");
                buf.append("       ,get.usr_codigo \t\t\tas codigoUsuarioTemperatura ");
                buf.append("       ,get.get_observacao  as observacao ");
                buf.append(" , ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from geladeiras a ");
                buf.append("  join geladeirastemperaturas get on a.fil_codigo = get.fil_codigo and a.gel_codigo = get.gel_codigo ");
                buf.append("  left join setores set on a.fil_codigo = set.fil_codigo and a.set_codigo = set.set_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                String[] geladeira = this.getSelecionadosFiltro(FILTRO_GELADEIRA, 0);
                if (geladeira != null) {
                    buf.append(" and a.gel_codigo in (");
                    for (int i = 0; i < geladeira.length; ++i) {
                        buf.append(geladeira[i]);
                        if (i >= geladeira.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!this.getFiltroCheck(FILTRO_INATIVA)) {
                    buf.append(" and a.gel_inativa = false ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_TEMP_MINIMA))) {
                    buf.append(" and get.get_temperatura >= ").append(this.getFiltroDecimal(FILTRO_TEMP_MINIMA));
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_TEMP_MAXIMA))) {
                    buf.append(" and get.get_temperatura <= ").append(this.getFiltroDecimal(FILTRO_TEMP_MAXIMA));
                }
                if (intervaloHora) {
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                        buf.append(" and date_trunc('minute', get.get_datahora) >= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                        buf.append(" and date_trunc('minute', get.get_datahora) <= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_FINAL));
                        buf.append("'");
                    }
                } else {
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        buf.append(" and cast(get.get_datahora as date) >= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        buf.append(" and cast(get.get_datahora as date) <= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                        buf.append(" and cast(get.get_datahora as time) >= '");
                        buf.append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                        buf.append("'");
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                        buf.append(" and cast(get.get_datahora as time) <= '");
                        buf.append(this.getFiltroHora(FILTRO_HORA_FINAL));
                        buf.append("'");
                    }
                }
                buf.append(" order by a.gel_codigo, get.get_datahora ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        Object[] o = new Object[campos.length];
                        for (int i = 0; i < campos.length; ++i) {
                            if (campos[i].equals("inativaGeladeira")) {
                                o[i] = rs.getBoolean(campos[i]) ? "Sim" : "N\u00e3o";
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioTemperaturas.campos[i])] = rs.getObject(campos[i]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioTemperaturas.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioTemperaturas.this.panelCentro.removeAll();
                                RelatorioTemperaturas.this.panelCentro.repaint();
                                RelatorioTemperaturas.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_TEMP_MINIMA, this.getFiltroDecimal(FILTRO_TEMP_MINIMA));
                        var.put(FILTRO_TEMP_MAXIMA, this.getFiltroDecimal(FILTRO_TEMP_MAXIMA));
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_HORA_INICIAL, this.getFiltroHora(FILTRO_HORA_INICIAL));
                        var.put(FILTRO_HORA_FINAL, this.getFiltroHora(FILTRO_HORA_FINAL));
                        var.put(FILTRO_INTERVALO_HORA, this.getFiltroCheck(FILTRO_INTERVALO_HORA) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_INATIVA, this.getFiltroCheck(FILTRO_INATIVA) ? "Sim" : "N\u00e3o");
                        buf.delete(0, buf.length());
                        if (geladeira != null) {
                            for (int i = 0; i < geladeira.length; ++i) {
                                buf.append(geladeira[i]);
                                if (i >= geladeira.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_GELADEIRA, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block29;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0890101000");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0890101001");
    }
}

