/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioSoroteca
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_SOROTECA = 0;
    public static final int TIPO_TUBOS_VENCIDOS = 1;
    private int tipoRelatorio = 0;
    private static final String FILTRO_GELADEIRA = "filtroGeladeira";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String[] CAMPOS_EXAME_REQUISICAO_RECIPIENTE = new String[]{"codigoRequisicao", "codigoRecipiente", "dataHoraSoroteca", "codigoUsuarioSoroteca", "codigoEstante", "linhaSoroteca", "colunaSoroteca", "etiqueta", "codigoFilialRequisicao"};
    private static final String[] CAMPOS_REQUISICAO = new String[]{"codigoConvenio", "codigoPaciente", "dataRequisicao", "horaRequisicao"};
    private static final String[] CAMPOS_CONVENIO = new String[]{"razaoSocialConvenio", "fantasiaConvenio"};
    private static final String[] CAMPOS_PACIENTE = new String[]{"nomePaciente", "fonePaciente", "enderecoPaciente", "tipoLogradouroPaciente", "numeroEnderecoPaciente", "complementoPaciente", "cepPaciente", "codigoCidadePaciente", "nomeSocialPaciente"};
    private static final String[] CAMPOS_EXAME_MAT_COLETA = new String[]{"tempoSoroteca", "tipoTempoSoroteca", "conservarSoroteca", "dataRetiradaSoroteca", "tuboVencido"};
    private static final String[] CAMPOS_ESTANTES = new String[]{"linhasEstante", "colunasEstante", "identificadorEstante", "pacoteEstante", "codigoGeladeira", "codigoPrateleira"};
    private static final String[] CAMPOS_GELADEIRAS = new String[]{"descricaoGeladeira", "codigoSetor"};
    private static final String[] CAMPOS_SETORES = new String[]{"descricaoSetor", "siglaSetor"};
    private static final String[] CAMPOS_RECIPIENTE = new String[]{"descricaoRecipiente"};
    private static String[] campos;

    public RelatorioSoroteca(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de Soroteca", "Listagem de tubos nas geladeiras", "relatorios/rel_soroteca.jpg");
        } else if (tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de Tubos Vencidos", "Listagem de tubos vencidos nas geladeiras", "relatorios/rel_soroteca_vencidos.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_GELADEIRA, "Geladeira", "geladeiras", " fil_codigo = " + Variaveis.filialPadrao + " and gel_inativa = false ", 1, new String[]{"gel_codigo", "gel_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao", "set_sigla"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Sigla"}, new int[]{70, 0, 30});
        this.setModuloConfigurar(RelatorioSoroteca.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioSoroteca.getModuloAcesso(tipoRelatorio));
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, CAMPOS_EXAME_REQUISICAO_RECIPIENTE);
        campos = ArraysUtil.concatenar(campos, CAMPOS_REQUISICAO);
        campos = ArraysUtil.concatenar(campos, CAMPOS_CONVENIO);
        campos = ArraysUtil.concatenar(campos, CAMPOS_PACIENTE);
        campos = ArraysUtil.concatenar(campos, CAMPOS_EXAME_MAT_COLETA);
        campos = ArraysUtil.concatenar(campos, CAMPOS_ESTANTES);
        campos = ArraysUtil.concatenar(campos, CAMPOS_GELADEIRAS);
        campos = ArraysUtil.concatenar(campos, CAMPOS_SETORES);
        campos = ArraysUtil.concatenar(campos, CAMPOS_RECIPIENTE);
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block25: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            try {
                String[] setor;
                StringBuilder buf = new StringBuilder();
                buf.append(" select distinct ");
                buf.append("       gel.gel_codigo\t\t\t\t\t\t\tas codigoGeladeira ");
                buf.append("       ,ett.gpa_codigo \t\t\t\t\t\tas codigoPrateleira ");
                buf.append("       ,ett.ett_codigo   \t\t\t\t\tas codigoEstante ");
                buf.append("       ,ett.ett_linhas \t\t\t\t\t\tas linhasEstante ");
                buf.append("       ,ett.ett_colunas \t\t\t\t\tas colunasEstante ");
                buf.append("       ,a.req_codigo   \t\t\t\t\t\tas codigoRequisicao ");
                buf.append("       ,a.rec_codigo              as codigoRecipiente");
                buf.append("       ,a.eso_datahorasoroteca \t  as dataHoraSoroteca ");
                buf.append("       ,a.usr_codsoroteca   \t    as codigoUsuarioSoroteca ");
                buf.append("       ,a.eso_linhasoroteca      \tas linhaSoroteca ");
                buf.append("       ,a.eso_colunasoroteca \t    as colunaSoroteca ");
                buf.append("       ,req.con_codigo \t\t\t\t\t\tas codigoConvenio ");
                buf.append("       ,req.pac_codigo \t\t\t\t\t\tas codigoPaciente ");
                buf.append("       ,req.req_data \t\t\t\t\t\t\tas dataRequisicao ");
                buf.append("       ,req.req_hora \t\t\t\t\t\t\tas horaRequisicao ");
                buf.append("       ,con.con_razao \t\t\t\t\t\tas razaoSocialConvenio ");
                buf.append("       ,con.con_fantasia \t\t\t\t\tas fantasiaConvenio ");
                buf.append("       ,pac.pac_nome \t\t\t\t\t\t\tas nomePaciente ");
                buf.append("       ,pac.pac_fone \t\t\t\t\t\t\tas fonePaciente ");
                buf.append("       ,pac.pac_endereco \t\t\t\t\tas enderecoPaciente ");
                buf.append("       ,pac.pac_numeroendereco\t\tas numeroEnderecoPaciente ");
                buf.append("       ,pac.pac_tipologradouroendereco as tipoLogradouroPaciente ");
                buf.append("       ,pac.pac_complemento \t\t\tas complementoPaciente ");
                buf.append("       ,pac.pac_cep \t\t\t\t\t\t\tas cepPaciente ");
                buf.append("       ,pac.cid_codigo \t\t\t\t\t\tas codigoCidadePaciente ");
                buf.append("       ,pac.pac_nomesocial        as nomeSocialPaciente ");
                buf.append("       ,ett.ett_identificador \t\tas identificadorEstante ");
                buf.append("       ,ett.ett_pacote \t\t\t\t\t\tas pacoteEstante ");
                buf.append("       ,gel.gel_descricao \t\t\t\tas descricaoGeladeira ");
                buf.append("       ,a.set_codigo\t\t\t\t\t  \tas codigoSetor ");
                buf.append("       ,set.set_descricao \t\t\t\tas descricaoSetor ");
                buf.append("       ,set.set_sigla \t\t\t\t\t\tas siglaSetor ");
                buf.append("       ,rec.rec_descricao\t\t\t\t\tas descricaoRecipiente ");
                buf.append("       ,a.eso_codigo ");
                buf.append("       ,a.fil_kodigo \t\t\t\t\t\t\tas codigoFilialRequisicao ");
                buf.append(" , ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("   from examerequisicaosoroteca a ");
                buf.append("   join examerequisicao exr \ton a.fil_kodigo \t= exr.fil_codigo and a.req_codigo \t= exr.req_codigo and a.exa_codigo\t\t= exr.exa_codigo and a.mco_codigo = exr.mco_codigo and exr.exr_excluido = false ");
                buf.append("   join requisicao req \t\t\t\ton exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo and req.req_excluida = false ");
                buf.append("   join estantes ett \t\t\t\t\ton a.fil_codigo \t= ett.fil_codigo and a.ett_codigo \t= ett.ett_codigo ");
                buf.append("   join geladeiras gel \t\t\t\ton ett.fil_codigo = gel.fil_codigo and ett.gel_codigo = gel.gel_codigo and gel.gel_inativa = false ");
                buf.append("   join examesetor ese        on a.fil_kodigo   = ese.fil_codigo and a.set_codigo   = ese.set_codigo and a.exa_codigo = ese.exa_codigo ");
                buf.append("   join setores set\t\t\t\t\t\ton ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
                buf.append("   join recipientes rec \t\t\ton a.fil_kodigo   = rec.fil_codigo and a.rec_codigo   = rec.rec_codigo ");
                buf.append("   join convenios con \t\t\t\ton req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
                buf.append("   join paciente pac \t\t\t\t\ton req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and a.eso_datahoradescarte is null and a.usr_coddescarte is null ");
                buf.append(" and requisicaoEtiqColeta(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) = a.req_codigo ");
                String[] geladeira = this.getSelecionadosFiltro(FILTRO_GELADEIRA, 0);
                if (geladeira != null) {
                    buf.append(" and ett.gel_codigo in (");
                    for (int i = 0; i < geladeira.length; ++i) {
                        buf.append(geladeira[i]);
                        if (i >= geladeira.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((setor = this.getSelecionadosFiltro(FILTRO_SETOR, 0)) != null) {
                    buf.append(" and set.set_codigo in (");
                    for (int i = 0; i < setor.length; ++i) {
                        buf.append(setor[i]);
                        if (i >= setor.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                buf.append(" order by gel.gel_codigo, ett.gpa_codigo, ett.ett_codigo, a.set_codigo, ");
                buf.append("          a.eso_linhasoroteca, a.eso_colunasoroteca ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        Object[] o = new Object[campos.length];
                        for (int i = 0; i < campos.length; ++i) {
                            if (campos[i].equalsIgnoreCase("tipoLogradouroPaciente")) {
                                o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equalsIgnoreCase("etiqueta")) {
                                o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = StringUtil.preencheString(String.valueOf(rs.getInt("codigoFilialRequisicao")), ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(String.valueOf(rs.getInt("codigoRequisicao")), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1) + StringUtil.preencheString(String.valueOf(rs.getInt("codigoRecipiente")), ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                                continue;
                            }
                            if (campos[i].equalsIgnoreCase("linhaSoroteca")) {
                                if (!rs.getBoolean("pacoteEstante")) {
                                    o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = Character.valueOf((char)(rs.getInt(campos[i]) + 65));
                                    continue;
                                }
                                o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = " - ";
                                continue;
                            }
                            if (campos[i].equalsIgnoreCase("colunaSoroteca")) {
                                if (rs.getBoolean("pacoteEstante")) {
                                    o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = " - ";
                                    continue;
                                }
                                o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = rs.getInt(campos[i]) + 1;
                                continue;
                            }
                            if (ArraysUtil.contem(CAMPOS_EXAME_MAT_COLETA, campos[i])) continue;
                            o[modelo.findColumn((String)RelatorioSoroteca.campos[i])] = campos[i].equalsIgnoreCase("dataHoraSoroteca") ? rs.getTimestamp(campos[i]) : rs.getObject(campos[i]);
                        }
                        this.preencheDadosTempoSoroteca(o, modelo);
                        if (this.tipoRelatorio == 1) {
                            if (!((Boolean)o[modelo.findColumn("tuboVencido")]).booleanValue()) continue;
                            modelo.addLine(o);
                            continue;
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (modelo.getRowCount() > 0) {
                        buf.delete(0, buf.length());
                        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                        buf.append(RelatorioSoroteca.getModuloAcesso(this.tipoRelatorio));
                        rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            int i;
                            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                            gerador.setPai(this.panelCentro);
                            gerador.setPreVisualizar(true);
                            gerador.setZoomPreVisualizar(1.0f);
                            gerador.setAcaoFechar(new Runnable(){

                                @Override
                                public void run() {
                                    RelatorioSoroteca.this.panelCentro.removeAll();
                                    RelatorioSoroteca.this.panelCentro.repaint();
                                    RelatorioSoroteca.this.habilitaBotaoImprimir(true);
                                }
                            });
                            HashMap<String, Object> var = new HashMap<String, Object>();
                            buf.delete(0, buf.length());
                            if (geladeira != null) {
                                for (i = 0; i < geladeira.length; ++i) {
                                    buf.append(geladeira[i]);
                                    if (i >= geladeira.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put(FILTRO_GELADEIRA, buf.toString());
                            buf.delete(0, buf.length());
                            if (setor != null) {
                                for (i = 0; i < setor.length; ++i) {
                                    buf.append(setor[i]);
                                    if (i >= setor.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put(FILTRO_SETOR, buf.toString());
                            gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                            this.panelCentro.revalidate();
                        }
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    break block25;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0890100200");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0890100300");
        }
        return -1L;
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0890100201");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0890100301");
        }
        return -1L;
    }

    private void preencheDadosTempoSoroteca(Object[] o, ModeloGridTable modelo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select COALESCE(emc.emc_temposoroteca, 0) as emc_temposoroteca ");
        sql.append("       ,COALESCE(emc.emc_tipotemposoroteca, '").append("D").append("') as emc_tipotemposoroteca ");
        sql.append("       ,a.eso_datahorasoroteca    as dataHoraSoroteca ");
        sql.append("       ,emc.emc_conservarsoroteca ");
        sql.append("   from examerequisicaosoroteca a ");
        sql.append("   join examematcoleta emc on a.fil_kodigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
        sql.append("  where a.fil_kodigo = ").append(o[modelo.findColumn("codigoFilialRequisicao")]);
        sql.append("    and a.fil_codigo = ").append(o[modelo.findColumn("codigoFilial")]);
        sql.append("    and a.req_codigo = ").append(o[modelo.findColumn("codigoRequisicao")]);
        sql.append("    and a.rec_codigo = ").append(o[modelo.findColumn("codigoRecipiente")]);
        sql.append("    and a.set_codigo = ").append(o[modelo.findColumn("codigoSetor")]);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        if (rs.next()) {
            Integer auxMenor = null;
            Integer tempoSoroteca = null;
            String tipoTempoSoroteca = null;
            StringBuilder conservarSoroteca = new StringBuilder();
            Object dataHoraSoroteca = null;
            do {
                Integer mult = 1;
                if (rs.getString("emc_tipotemposoroteca").equalsIgnoreCase("M")) {
                    mult = 30;
                } else if (rs.getString("emc_tipotemposoroteca").equalsIgnoreCase("A")) {
                    mult = 365;
                }
                Integer aux = rs.getInt("emc_temposoroteca") * mult;
                if ((auxMenor == null || auxMenor > aux) && rs.getInt("emc_temposoroteca") > 0) {
                    tempoSoroteca = rs.getInt("emc_temposoroteca");
                    tipoTempoSoroteca = rs.getString("emc_tipotemposoroteca");
                    auxMenor = aux;
                }
                if (rs.getString("emc_conservarsoroteca") == null) continue;
                if (conservarSoroteca.length() > 0) {
                    conservarSoroteca.append("\n");
                }
                conservarSoroteca.append(rs.getString("emc_conservarSoroteca"));
            } while (rs.next());
            o[modelo.findColumn((String)"tempoSoroteca")] = tempoSoroteca;
            o[modelo.findColumn((String)"tipoTempoSoroteca")] = tipoTempoSoroteca;
            o[modelo.findColumn((String)"conservarSoroteca")] = conservarSoroteca.toString();
            if (auxMenor != null) {
                Date dataAux = Funcoes.somaDias((Date)o[modelo.findColumn("dataHoraSoroteca")], auxMenor);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dataAux);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                o[modelo.findColumn((String)"dataRetiradaSoroteca")] = new Date(calendar.getTimeInMillis());
            }
            o[modelo.findColumn((String)"tuboVencido")] = o[modelo.findColumn("dataRetiradaSoroteca")] != null && tempoSoroteca > 0 && ((Date)o[modelo.findColumn("dataRetiradaSoroteca")]).compareTo(new Date()) <= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else {
            o[modelo.findColumn((String)"tempoSoroteca")] = 0;
            o[modelo.findColumn((String)"tipoTempoSoroteca")] = "D";
            o[modelo.findColumn((String)"conservarSoroteca")] = "";
            o[modelo.findColumn((String)"dataRetiradaSoroteca")] = o[modelo.findColumn("dataSoroteca")];
        }
    }
}

