/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.bean.triagem.SolicitarSorotecaBean;
import jalis.relatorio.Gerador;
import jalis.service.triagem.SolicitarSorotecaService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class RelatorioSolicitarTubo
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_SOLICITACAO = "filtroSolicitacao";
    private static final String[] CAMPOS_SOLICITAR_SOROTECA = new String[]{"codigoSolicitacao", "dataHoraSolicitacao", "usuarioSolicitacao", "codigoSetorSolicitacao", "usuarioEntregaSolicitacao", "dataHoraEntregaSolicitacao", "descricaoSetorSolicitacao"};
    private static final String[] CAMPOS_SOLICITAR_SOROTECA_TUBO = new String[]{"codigoExame", "descricaoExame", "codigoMaterialExame", "descricaoMaterialExame"};
    private static final String[] CAMPOS_EXAME_REQUISICAO_RECIPIENTE = new String[]{"codigoRequisicao", "codigoRecipientePai", "codigoRecipienteFilho", "dataHoraSoroteca", "codigoUsuarioSoroteca", "codigoEstante", "linhaSoroteca", "colunaSoroteca", "etiquetaComTraco", "etiqueta", "dataInclusao"};
    private static final String[] CAMPOS_REQUISICAO = new String[]{"codigoConvenio", "codigoPaciente", "dataRequisicao", "horaRequisicao"};
    private static final String[] CAMPOS_CONVENIO = new String[]{"razaoSocialConvenio", "fantasiaConvenio"};
    private static final String[] CAMPOS_PACIENTE = new String[]{"nomePaciente", "fonePaciente", "tipoLogradouroPaciente", "enderecoPaciente", "numeroEnderecoPaciente", "complementoPaciente", "cepPaciente", "codigoCidadePaciente", "nomeSocialPaciente"};
    private static final String[] CAMPOS_EXAME_MAT_COLETA = new String[]{"tempoSoroteca", "tipoTempoSoroteca", "conservarSoroteca", "dataRetiradaSoroteca", "tuboVencido"};
    private static final String[] CAMPOS_ESTANTES = new String[]{"linhasEstante", "colunasEstante", "identificadorEstante", "pacoteEstante", "codigoGeladeira", "codigoPrateleira"};
    private static final String[] CAMPOS_GELADEIRAS = new String[]{"descricaoGeladeira", "codigoSetor"};
    private static final String[] CAMPOS_SETORES = new String[]{"descricaoSetor", "siglaSetor"};
    private static final String[] CAMPOS_RECIPIENTE = new String[]{"descricaoRecipiente"};
    private static String[] campos;
    public String codigoSolicitacao = null;
    Gerador gerador = null;

    public RelatorioSolicitarTubo() {
        this.setModuloConfigurar(RelatorioSolicitarTubo.getModuloConfigurar());
        this.setModuloAcesso(RelatorioSolicitarTubo.getModuloAcesso());
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, CAMPOS_EXAME_REQUISICAO_RECIPIENTE);
        campos = ArraysUtil.concatenar(campos, CAMPOS_SOLICITAR_SOROTECA);
        campos = ArraysUtil.concatenar(campos, CAMPOS_REQUISICAO);
        campos = ArraysUtil.concatenar(campos, CAMPOS_CONVENIO);
        campos = ArraysUtil.concatenar(campos, CAMPOS_PACIENTE);
        campos = ArraysUtil.concatenar(campos, CAMPOS_EXAME_MAT_COLETA);
        campos = ArraysUtil.concatenar(campos, CAMPOS_ESTANTES);
        campos = ArraysUtil.concatenar(campos, CAMPOS_GELADEIRAS);
        campos = ArraysUtil.concatenar(campos, CAMPOS_SETORES);
    }

    public RelatorioSolicitarTubo(boolean montaTela) {
        if (montaTela) {
            this.montaBarraDescricao("Relat\u00f3rio de Solicita\u00e7\u00e3o de Tubos", "Impress\u00e3o de solicita\u00e7\u00f5es de tubos da soroteca", "relatorios/rel_soroteca_tubos.jpg");
            this.adicionaRelatorioListener(this);
            this.adicionaFiltroComPesquisa(FILTRO_SOLICITACAO, "Solicita\u00e7\u00e3o:", 10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Hashtable pesq = Pesquisas.solicitacaoTubos(Laboratorio.getInstancia());
                        if (pesq == null) {
                            return;
                        }
                        SolicitarSorotecaBean solicitacao = (SolicitarSorotecaBean)new SolicitarSorotecaService().get(String.valueOf(pesq.get("sso_codigo")));
                        if (solicitacao != null) {
                            RelatorioSolicitarTubo.this.setFiltroComPesquisa(RelatorioSolicitarTubo.FILTRO_SOLICITACAO, String.valueOf(solicitacao.getCodigo()));
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(RelatorioSolicitarTubo.this, e1.getMessage(), e1.getStackTrace());
                    }
                }
            }, 1);
        }
        this.setModuloConfigurar(RelatorioSolicitarTubo.getModuloConfigurar());
        this.setModuloAcesso(RelatorioSolicitarTubo.getModuloAcesso());
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, CAMPOS_EXAME_REQUISICAO_RECIPIENTE);
        campos = ArraysUtil.concatenar(campos, CAMPOS_SOLICITAR_SOROTECA);
        campos = ArraysUtil.concatenar(campos, CAMPOS_REQUISICAO);
        campos = ArraysUtil.concatenar(campos, CAMPOS_CONVENIO);
        campos = ArraysUtil.concatenar(campos, CAMPOS_PACIENTE);
        campos = ArraysUtil.concatenar(campos, CAMPOS_EXAME_MAT_COLETA);
        campos = ArraysUtil.concatenar(campos, CAMPOS_ESTANTES);
        campos = ArraysUtil.concatenar(campos, CAMPOS_GELADEIRAS);
        campos = ArraysUtil.concatenar(campos, CAMPOS_SETORES);
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imprimirPressionado(String codigoSolicitacao) {
        Statement st;
        block9: {
            this.codigoSolicitacao = codigoSolicitacao;
            st = Conexao.getStatement();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                StringBuilder buf = this.getSql();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = this.gerarModelo(rs);
                    if (modelo.getRowCount() > 0) {
                        buf.delete(0, buf.length());
                        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                        buf.append(RelatorioSolicitarTubo.getModuloAcesso());
                        rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            HashMap<String, Object> variaveis = new HashMap<String, Object>();
                            variaveis.put(FILTRO_SOLICITACAO, codigoSolicitacao == null ? this.getFiltroComPesquisa(FILTRO_SOLICITACAO) : codigoSolicitacao);
                            Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                            gerador.setPreVisualizar(true);
                            gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, variaveis);
                        } else {
                            Funcoes.mensagem(this, "Layout do relat\u00f3rio n\u00e3o definido.", 2);
                        }
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    }
                    break block9;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block9: {
            if (this.codigoSolicitacao == null && (this.getFiltroComPesquisa(FILTRO_SOLICITACAO) == null || Funcoes.textoVazio(this.getFiltroComPesquisa(FILTRO_SOLICITACAO)))) {
                Funcoes.mensagem(this, "Selecione uma solicita\u00e7\u00e3o.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            try {
                StringBuilder buf = this.getSql();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = this.gerarModelo(rs);
                    if (modelo.getRowCount() > 0) {
                        buf.delete(0, buf.length());
                        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                        buf.append(RelatorioSolicitarTubo.getModuloAcesso());
                        rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            this.gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                            this.gerador.setPai(this.panelCentro);
                            this.gerador.setPreVisualizar(true);
                            this.gerador.setZoomPreVisualizar(1.0f);
                            this.gerador.setAcaoFechar(new Runnable(){

                                @Override
                                public void run() {
                                    RelatorioSolicitarTubo.this.panelCentro.removeAll();
                                    RelatorioSolicitarTubo.this.panelCentro.repaint();
                                    RelatorioSolicitarTubo.this.habilitaBotaoImprimir(true);
                                    if (RelatorioSolicitarTubo.this.codigoSolicitacao != null) {
                                        RelatorioSolicitarTubo.this.getParent().getParent().getParent().setVisible(false);
                                    }
                                }
                            });
                            HashMap<String, Object> var = new HashMap<String, Object>();
                            var.put(FILTRO_SOLICITACAO, this.codigoSolicitacao == null ? this.getFiltroComPesquisa(FILTRO_SOLICITACAO) : this.codigoSolicitacao);
                            this.gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                            this.panelCentro.revalidate();
                        }
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    break block9;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private ModeloGridTable gerarModelo(ResultSet rs) throws SQLException {
        ModeloGridTable modelo = new ModeloGridTable(campos);
        do {
            Object[] o = new Object[campos.length];
            for (int i = 0; i < campos.length; ++i) {
                if (campos[i].equalsIgnoreCase("tipoLogradouroPaciente")) {
                    o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                    continue;
                }
                if (campos[i].equalsIgnoreCase("etiqueta")) {
                    o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = StringUtil.preencheString(String.valueOf(rs.getInt("codigoFilial")), ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(String.valueOf(rs.getInt("codigoRequisicao")), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1) + StringUtil.preencheString(String.valueOf(rs.getInt("codigoRecipienteFilho")), ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                    continue;
                }
                if (campos[i].equalsIgnoreCase("etiquetaComTraco")) {
                    o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = StringUtil.preencheString(String.valueOf(rs.getInt("codigoFilial")), ParametrosGerais.getDigitosTuboFilial(), '0', 1) + "-" + StringUtil.preencheString(String.valueOf(rs.getInt("codigoRequisicao")), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1) + "-" + StringUtil.preencheString(String.valueOf(rs.getInt("codigoRecipienteFilho")), ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                    continue;
                }
                if (campos[i].equalsIgnoreCase("linhaSoroteca")) {
                    if (!rs.getBoolean("pacoteEstante")) {
                        o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = Character.valueOf((char)(rs.getInt(campos[i]) + 65));
                        continue;
                    }
                    o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = " - ";
                    continue;
                }
                if (campos[i].equalsIgnoreCase("colunaSoroteca")) {
                    if (rs.getBoolean("pacoteEstante")) {
                        o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = " - ";
                        continue;
                    }
                    o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = rs.getInt(campos[i]) + 1;
                    continue;
                }
                if (ArraysUtil.contem(CAMPOS_EXAME_MAT_COLETA, campos[i]) || campos[i].equalsIgnoreCase("dataHoraSoroteca")) continue;
                o[modelo.findColumn((String)RelatorioSolicitarTubo.campos[i])] = rs.getObject(campos[i]);
            }
            modelo.addLine(o);
        } while (rs.next());
        return modelo;
    }

    private StringBuilder getSql() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct ");
        buf.append("        gel.gel_codigo\t\t\t\t\tas codigoGeladeira ");
        buf.append("       ,ett.gpa_codigo \t\t\t\t\tas codigoPrateleira ");
        buf.append("       ,ett.ett_codigo   \t\t\t\tas codigoEstante ");
        buf.append("       ,ett.ett_linhas \t\t\t\t\tas linhasEstante ");
        buf.append("       ,ett.ett_colunas \t\t\t\tas colunasEstante ");
        buf.append("       ,requisicaoEtiqColeta(eso.fil_codigo, eso.req_codigo, eso.exa_codigo, eso.mco_codigo) as codigoRequisicao ");
        buf.append("       ,eso.rec_codigo          as codigoRecipientePai ");
        buf.append("       ,eso.rec_kodigo          as codigoRecipienteFilho ");
        buf.append("       ,cast(eso.eso_datahorasoroteca as date) as dataInclusao ");
        buf.append("       ,eso.usr_codsoroteca   \tas codigoUsuarioSoroteca ");
        buf.append("       ,eso.eso_linhasoroteca   as linhaSoroteca ");
        buf.append("       ,eso.eso_colunasoroteca \tas colunaSoroteca ");
        buf.append("       ,req.con_codigo \t\t\t\t\tas codigoConvenio ");
        buf.append("       ,req.pac_codigo \t\t\t\t\tas codigoPaciente ");
        buf.append("       ,req.req_data \t\t\t\t\t\tas dataRequisicao ");
        buf.append("       ,req.req_hora \t\t\t\t\t\tas horaRequisicao ");
        buf.append("       ,con.con_razao \t\t\t\t\tas razaoSocialConvenio ");
        buf.append("       ,con.con_fantasia \t\t\t\tas fantasiaConvenio ");
        buf.append("       ,pac.pac_nome \t\t\t\t\t\tas nomePaciente ");
        buf.append("       ,pac.pac_fone \t\t\t\t\t\tas fonePaciente ");
        buf.append("       ,pac.pac_endereco \t\t\t\tas enderecoPaciente ");
        buf.append("       ,pac.pac_numeroendereco\tas numeroEnderecoPaciente ");
        buf.append("       ,pac.pac_tipologradouroendereco as tipoLogradouroPaciente ");
        buf.append("       ,pac.pac_complemento \t\tas complementoPaciente ");
        buf.append("       ,pac.pac_cep \t\t\t\t\t\tas cepPaciente ");
        buf.append("       ,pac.cid_codigo \t\t\t\t\tas codigoCidadePaciente ");
        buf.append("       ,pac.pac_nomesocial      as nomeSocialPaciente ");
        buf.append("       ,ett.ett_identificador \tas identificadorEstante ");
        buf.append("       ,ett.ett_pacote \t\t\t\t\tas pacoteEstante ");
        buf.append("       ,gel.gel_descricao \t\t\tas descricaoGeladeira ");
        buf.append("       ,eso.set_codigo\t\t\t\t\tas codigoSetor ");
        buf.append("       ,set2.set_descricao\t\t\tas descricaoSetorSolicitacao ");
        buf.append("       ,set.set_descricao \t\t\tas descricaoSetor ");
        buf.append("       ,set.set_sigla \t\t\t\t\tas siglaSetor ");
        buf.append("       ,a.sso_codigo \t\t\t\t\t\tas codigoSolicitacao ");
        buf.append("       ,a.sso_datahora\t\t\t\t\tas dataHoraSolicitacao ");
        buf.append("       ,a.usr_codigo            as usuarioSolicitacao ");
        buf.append("       ,a.set_codigo            as codigoSetorSolicitacao ");
        buf.append("       ,a.usr_codentrega        as usuarioEntregaSolicitacao ");
        buf.append("       ,a.sso_datahoraentrega   as dataHoraEntregaSolicitacao ");
        buf.append("       ,set2.set_descricao      as descricaoSetorSolicitacao ");
        buf.append(" , ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("   from solicitarsoroteca a ");
        buf.append("   join solicitarsorotecatubo sst   on a.fil_codigo = sst.fil_codigo and a.sso_codigo = sst.sso_codigo ");
        buf.append("   join setores set2\t\t\t\t\ton a.fil_codigo = set2.fil_codigo and a.set_codigo = set2.set_codigo ");
        buf.append("   join exames\texa\t\t\t\t\t\ton sst.fil_codigo = exa.fil_codigo and sst.exa_codigo = exa.exa_codigo ");
        buf.append("   join materialcoleta mco\t\ton sst.fil_codigo = mco.fil_codigo and sst.mco_codigo = mco.mco_codigo ");
        buf.append("\t join examerequisicaosoroteca eso on sst.fil_codigo = eso.fil_codigo and sst.fil_kodigo = eso.fil_kodigo and sst.ett_codigo = eso.ett_codigo and sst.exa_codigo = eso.exa_codigo and sst.mco_codigo = eso.mco_codigo and sst.req_codigo = eso.req_codigo and sst.rec_codigo = eso.rec_codigo and sst.rec_kodigo = eso.rec_kodigo and sst.eso_codigo = eso.eso_codigo ");
        buf.append("   join estantes ett \t\t\t\t\ton eso.fil_codigo = ett.fil_codigo and eso.ett_codigo = ett.ett_codigo ");
        buf.append("   join geladeiras gel \t\t\t\ton ett.fil_codigo = gel.fil_codigo and ett.gel_codigo = gel.gel_codigo and gel.gel_inativa  = false ");
        buf.append("   join examesetor ese        on eso.fil_codigo = ese.fil_codigo and eso.set_codigo = ese.set_codigo and eso.exa_codigo   = ese.exa_codigo ");
        buf.append("   join setores set\t\t\t\t\t\ton ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        buf.append("   join recipientes rec \t\t\ton eso.fil_codigo = rec.fil_codigo and eso.rec_codigo = rec.rec_codigo ");
        buf.append("   join examerequisicao exr \ton eso.fil_codigo = exr.fil_codigo and eso.req_codigo = exr.req_codigo and eso.exa_codigo\t\t= exr.exa_codigo and eso.mco_codigo = exr.mco_codigo and exr.exr_excluido = false ");
        buf.append("   join requisicao req \t\t\t\ton exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo and req.req_excluida = false ");
        buf.append("   join paciente pac \t\t\t\t\ton req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join convenios con \t\t\t\ton req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and a.sso_codigo = ").append(this.codigoSolicitacao == null ? this.getFiltroComPesquisa(FILTRO_SOLICITACAO) : this.codigoSolicitacao);
        buf.append("   and a.sso_datahoracancelamento is null and a.usr_codcancelamento is null ");
        buf.append(" order by gel.gel_codigo, ett.gpa_codigo, ett.ett_codigo, eso.eso_linhasoroteca, eso.eso_colunasoroteca ");
        return buf;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0890100500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0890100501");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar && this.codigoSolicitacao != null) {
            this.getParent().getParent().getParent().setVisible(false);
        }
        super.actionPerformed(e);
    }
}

