/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioBanhoMaria
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_BANHO_MARIA = "filtroBanhoMaria";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private static final String FILTRO_INATIVO = "filtroInativo";
    private static final String FILTRO_TEMP_MINIMA = "filtroTempMinima";
    private static final String FILTRO_TEMP_MAXIMA = "filtroTempMaxima";
    private static final String[] camposBanhoMaria = new String[]{"codigoBanhoMaria", "descricaoBanhoMaria", "inativoBanhoMaria"};
    private static final String[] camposSetores = new String[]{"codigoSetor", "descricaoSetor", "siglaSetor"};
    private static final String[] camposTemperaturaBanhos = new String[]{"temperatura", "dataHoraTemperatura", "temperaturaMinima", "temperaturaMaxima", "observacaoTemperaturaBanho"};
    private static final String[] campos = ArraysUtil.concatenar(ArraysUtil.concatenar(camposBanhoMaria, camposSetores), camposTemperaturaBanhos);

    public RelatorioBanhoMaria() {
        this.montaBarraDescricao("Relat\u00f3rio de Banhos-Maria", "Listagem do registro de controle de temperatura de Banhos-Maria", "relatorios/rel_temperatura_banho.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_BANHO_MARIA, "Banhos-Maria", "banhomaria", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ban_codigo", "ban_descricao", "ban_inativo"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativo"}, new int[]{70, 0, 50});
        this.adicionaFiltroDecimal(FILTRO_TEMP_MINIMA, "Temp. M\u00ednima", 12);
        this.adicionaFiltroDecimal(FILTRO_TEMP_MAXIMA, "Temp. M\u00e1xima", 12);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora Inicial");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora Final");
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_INATIVO, "Mostrar Inativos", false);
        this.setModuloConfigurar(RelatorioBanhoMaria.getModuloConfigurar());
        this.setModuloAcesso(RelatorioBanhoMaria.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block29: {
            boolean intervaloHora = this.getFiltroCheck(FILTRO_INTERVALO_HORA);
            if (intervaloHora) {
                if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                    Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.ban_codigo \t\t\tas codigoBanhoMaria ");
            buf.append("       ,a.ban_descricao \tas descricaoBanhoMaria ");
            buf.append("       ,a.ban_inativo \t\tas inativoBanhoMaria ");
            buf.append("       ,a.set_codigo \t\t\tas codigoSetor ");
            buf.append("       ,set.set_descricao \tas descricaoSetor ");
            buf.append("       ,set.set_sigla \t\t\tas siglaSetor ");
            buf.append("       ,bat.bat_temperatura as temperatura ");
            buf.append("       ,bat.bat_tempminima \tas temperaturaMinima ");
            buf.append("       ,bat.bat_tempmaxima \tas temperaturaMaxima ");
            buf.append("       ,bat.bat_datahora \t\tas dataHoraTemperatura ");
            buf.append("       ,bat.usr_codigo \t\t\tas codigoUsuarioTemperatura ");
            buf.append("       ,bat.bat_observacao  as observacaoTemperaturaBanho ");
            buf.append(" , ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("  from banhomaria a ");
            buf.append("  join banhomariatemperatura bat on a.fil_codigo = bat.fil_codigo and a.ban_codigo = bat.ban_codigo ");
            buf.append("  left join setores set on a.fil_codigo = set.fil_codigo and a.set_codigo = set.set_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            String[] banhoMaria = this.getSelecionadosFiltro(FILTRO_BANHO_MARIA, 0);
            if (banhoMaria != null) {
                buf.append(" and a.ban_codigo in (");
                for (int i = 0; i < banhoMaria.length; ++i) {
                    buf.append(banhoMaria[i]);
                    if (i >= banhoMaria.length - 1) continue;
                    buf.append(",");
                }
                buf.append(")");
            }
            if (!this.getFiltroCheck(FILTRO_INATIVO)) {
                buf.append(" and a.ban_inativo = false ");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_TEMP_MINIMA))) {
                buf.append(" and bat.bat_temperatura >= ").append(this.getFiltroDecimal(FILTRO_TEMP_MINIMA));
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_TEMP_MAXIMA))) {
                buf.append(" and bat.bat_temperatura <= ").append(this.getFiltroDecimal(FILTRO_TEMP_MAXIMA));
            }
            if (intervaloHora) {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    buf.append(" and date_trunc('minute', bat.bat_datahora) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    buf.append(" and date_trunc('minute', bat.bat_datahora) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    buf.append(" and cast(bat.bat_datahora as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    buf.append(" and cast(bat.bat_datahora as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    buf.append(" and cast(bat.bat_datahora as time) >= '");
                    buf.append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    buf.append(" and cast(date_trunc('minute',bat.bat_datahora) as time) <= '");
                    buf.append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    buf.append("'");
                }
            }
            buf.append(" order by a.ban_codigo, bat.bat_datahora ");
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        Object[] o = new Object[campos.length];
                        for (int i = 0; i < campos.length; ++i) {
                            if (campos[i].equals("inativoBanhoMaria")) {
                                o[i] = rs.getBoolean(campos[i]) ? "Sim" : "N\u00e3o";
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioBanhoMaria.campos[i])] = rs.getObject(campos[i]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioBanhoMaria.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioBanhoMaria.this.panelCentro.removeAll();
                                RelatorioBanhoMaria.this.panelCentro.repaint();
                                RelatorioBanhoMaria.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_TEMP_MINIMA, this.getFiltroDecimal(FILTRO_TEMP_MINIMA));
                        var.put(FILTRO_TEMP_MAXIMA, this.getFiltroDecimal(FILTRO_TEMP_MAXIMA));
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_HORA_INICIAL, this.getFiltroHora(FILTRO_HORA_INICIAL));
                        var.put(FILTRO_HORA_FINAL, this.getFiltroHora(FILTRO_HORA_FINAL));
                        var.put(FILTRO_INTERVALO_HORA, this.getFiltroCheck(FILTRO_INTERVALO_HORA) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_INATIVO, this.getFiltroCheck(FILTRO_INATIVO) ? "Sim" : "N\u00e3o");
                        buf.delete(0, buf.length());
                        if (banhoMaria != null) {
                            for (int i = 0; i < banhoMaria.length; ++i) {
                                buf.append(banhoMaria[i]);
                                if (i >= banhoMaria.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_BANHO_MARIA, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block29;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (SQLException e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0890102000");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0890102001");
    }
}

