/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.triagem.filial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioLoteEnviadoFilial
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_LOTE = "filtroLote";
    protected static final String[] campos = new String[]{"codigoRequisicao", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "idadePaciente", "anoMesPaciente", "horaRequisicao", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "observacaoRequisicao", "codigoExame", "descricaoExame", "dataRequisicao", "codigoLote", "dataLote", "codigoConvenio", "descricaoConvenio", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "situacaoExame", "codigoFilial", "descricaoFilial", "codigoFilialCodigoRequisicao", "codigoUsuarioTransExameSaida", "nomeUsuarioExameTranspSaida", "dataExameTranspSaida", "dataColetaExame", "usuarioLoteEnvio", "usuarioLoteRecebeu", "nomeUsuarioLoteTransSaida", "nomeUsuarioLoteTransRecebeu", "nomeSocialPaciente", "generoPaciente"};

    public RelatorioLoteEnviadoFilial() {
        this.montaBarraDescricao("Relat\u00f3rio de Lote Enviado", "Listagem dos exames de lote enviado", "relatorios/rel_filial_lote.jpg");
        this.adicionaRelatorioListener(this);
        String sql = " select lfi_codigo, lfi_datahora from lotefilial";
        this.adicionaItemFiltro("filtroLote", "Lote", sql, "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lfi_codigo", "lfi_datahora"}, new String[]{"C\u00f3digo", "Data"}, new int[]{70, 0}, new int[]{0, 2}, true);
        this.setModuloConfigurar(RelatorioLoteEnviadoFilial.getModuloConfigurar());
        this.setModuloAcesso(RelatorioLoteEnviadoFilial.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block11: {
            if (this.getSelecionadosFiltro("filtroLote", 0) == null || this.getSelecionadosFiltro("filtroLote", 0).length == 0) {
                Funcoes.mensagem(this, "Lote n\u00e3o selecionado", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getSelecionadosFiltro("filtroLote", 0).length > 1) {
                Funcoes.mensagem(this, "Apenas um lote pode ser selecionado", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder buf = new StringBuilder();
            st = Conexao.getStatement();
            try {
                String[] lotes = this.getSelecionadosFiltro("filtroLote", 0);
                ModeloGridTable modelo = this.getModeloDados(st, lotes);
                if (modelo.getRowCount() > 0) {
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioLoteEnviadoFilial.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioLoteEnviadoFilial.this.panelCentro.removeAll();
                                RelatorioLoteEnviadoFilial.this.panelCentro.repaint();
                                RelatorioLoteEnviadoFilial.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        buf.delete(0, buf.length());
                        if (lotes != null) {
                            for (int i = 0; i < lotes.length; ++i) {
                                buf.append(lotes[i]);
                                if (i >= lotes.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroLote", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 modelo configurado..", 2);
                    }
                    break block11;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public ModeloGridTable getModeloDados(Statement st, String[] lotes) throws Exception {
        ModeloGridTable modelo = new ModeloGridTable(campos);
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            buf.append(" distinct pegacodigomultiguiamae(a.fil_codigo, a.req_codigo) as codigoRequisicao ");
        } else {
            buf.append(" a.req_codigo as codigoRequisicao ");
        }
        buf.append("  ,'' as codigoFilialCodigoRequisicao ");
        buf.append("  ,paciente.pac_nome as nomePaciente, paciente.pac_nomesocial as nomeSocialPaciente ");
        buf.append("  ,a.req_idade as idadePaciente ");
        buf.append("  ,a.req_anomes as anoMesPaciente ");
        buf.append("  ,c.exa_codigo as codigoExame ");
        buf.append("  ,c.exa_descricao as descricaoExame  ");
        buf.append("  ,paciente.pac_datanasc as dataNascimentoPaciente ");
        buf.append("  ,paciente.pac_sexo as sexoPaciente ");
        buf.append("  ,a.med_conselho as conselhoMedico ");
        buf.append("  ,a.med_crm as crmMedico ");
        buf.append("  ,a.med_uf as ufMedico ");
        buf.append("  ,medico.med_nome as nomeMedico ");
        buf.append("  ,a.req_obs as observacaoRequisicao ");
        buf.append("  ,a.req_hora as horaRequisicao ");
        buf.append("  ,coletado.mco_codigo as codigoMaterialColetado ");
        buf.append("  ,coletado.mco_descricao as descricaoMaterialColetado ");
        buf.append("  ,coletado.mco_abreviatura as abreviaturaMaterialColetado ");
        buf.append("  ,exr.exr_situacao as situacaoExame ");
        buf.append("  ,exr.exr_datamaterial as dataColetaExame ");
        buf.append("  ,l.lfi_codigo as codigoLote ");
        buf.append("  ,l.lfi_datahora as dataLote ");
        buf.append("  ,exr.exr_datatransportesaida as dataExameTranspSaida ");
        buf.append("  ,exr.usr_codtransportesaida as codigoUsuarioTransExameSaida ");
        buf.append("  ,usrenv.usr_nome as nomeUsuarioExameTranspSaida ");
        buf.append("  ,l.usr_codenviou as usuarioLoteEnvio ");
        buf.append("  ,l.usr_codrecebeu as usuarioLoteRecebeu ");
        buf.append("  ,usrloteenv.usr_nome as nomeUsuarioLoteTransSaida ");
        buf.append("  ,usrloterec.usr_nome as nomeUsuarioLoteTransRecebeu ");
        buf.append("  ,conv.con_codigo as codigoConvenio ");
        buf.append("  ,conv.con_razao as descricaoConvenio ");
        buf.append("  ,a.req_data as dataRequisicao ");
        buf.append("  ,lote.fil_codigo as codigoFilial ");
        buf.append("  ,fil.fil_descricao as descricaoFilial ");
        buf.append("\t,idg.ige_descricao as generoPaciente ");
        buf.append("  from lotefilialrequisicao lote ");
        buf.append("  join lotefilial l on lote.fil_codigo = l.fil_codigo and lote.lfi_codigo = l.lfi_codigo ");
        buf.append("  join requisicao a on lote.fil_codigo = a.fil_codigo and lote.req_codigo = a.req_codigo ");
        buf.append("  join convenios conv on a.fil_codigo = conv.fil_codigo and a.con_codigo = conv.con_codigo ");
        buf.append("  join lotefilialexamerequisicao b on lote.fil_codigo = b.fil_codigo and lote.req_codigo = b.req_codigo and lote.lfi_codigo = b.lfi_codigo ");
        buf.append("  join examerequisicao exr on b.fil_codigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and b.exa_codigo = exr.exa_codigo and b.mco_codigo = exr.mco_codigo  ");
        buf.append("  left join usuario usrenv on exr.fil_codigo = usrenv.fil_codigo and exr.usr_codtransportesaida = usrenv.usr_codigo ");
        buf.append("  left join usuario usrloteenv on l.fil_codigo = usrloteenv.fil_codigo and l.usr_codenviou = usrloteenv.usr_codigo ");
        buf.append("  left join usuario usrloterec on l.fil_codigo = usrloterec.fil_codigo and l.usr_codrecebeu = usrloterec.usr_codigo ");
        buf.append("  join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo  ");
        buf.append("  join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo  ");
        buf.append("  join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("  join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo  ");
        buf.append("  join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("  join filiais_postocoleta fil on lote.fil_codigo = fil.fil_codigo ");
        buf.append("\tleft join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        buf.append("  where lote.fil_codigo = ").append(Variaveis.filialPadrao);
        if (lotes != null) {
            buf.append(" and lote.lfi_codigo in (");
            for (int i = 0; i < lotes.length; ++i) {
                buf.append(lotes[i]);
                if (i >= lotes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        buf.append(" and a.req_excluida = false and exr.exr_excluido = false ");
        buf.append(" order by l.lfi_codigo, codigoRequisicao ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            do {
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    o[i] = campos[i].equals("codigoFilialCodigoRequisicao") ? Funcoes.preencheZero(rs.getInt("codigoFilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), ParametrosGerais.getDigitosTuboRequisicao()) : (campos[i].equalsIgnoreCase("codigoLote") ? Funcoes.preencheZero(rs.getString("codigoLote"), 6) : (campos[i].equalsIgnoreCase("anoMesPaciente") ? Tipos.tipoIdade(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("sexoPaciente") ? Tipos.tipoSexo(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("situacaoExame") ? Tipos.tipoSituacaoExame(rs.getString(campos[i])) : rs.getObject(campos[i])))));
                }
                modelo.addLine(o);
            } while (rs.next());
        }
        return modelo;
    }

    public String getXMLRelatorio(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioLoteEnviadoFilial.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("rel_xml");
        }
        return "";
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0890200100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0890200101");
    }
}

