/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.resultados.relatoriorecepientesutilizados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.table.TableModel;

public class RelatorioRecipientesUtilizados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_RECIPIENTES = 0;
    public static final int TIPO_ANALITICO = 1;
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_EXAME = "filtroExame";
    private static final String FILTRO_MATERIAL_COLETADO = "filtroMaterialColetado";
    private static final String FILTRO_RECEPIENTE = "filtroRecepiente";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_TIPO = "filtroTipo";
    private static final String FILTRO_CAMPO_DATA = "campoData";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_ANALITICO = "filtroAnalitico";
    private final String[] tipo = new String[]{"Coleta", "Triagem", "Todos"};
    private final String[] campoData = new String[]{"Requisi\u00e7\u00e3o", "Coleta", "Etiqueta coleta", "Etiqueta triagem"};
    private final String[] ordem = new String[]{"C\u00f3d. Recipiente", "Descri\u00e7\u00e3o"};
    private static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRecipiente", "descricaoRecipiente", "quantidadeUtilizado", "codigoRequisicao", "dataRequisicao", "horaRequisicao", "examesRequisicao", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "razaoSocialConvenio"});
    StringBuilder bui = new StringBuilder();

    public RelatorioRecipientesUtilizados() {
        this.montaBarraDescricao("Relat\u00f3rio de recipientes utilizados", "Relat\u00f3rio de recipentes utilizados nas requisi\u00e7\u00f5es", "relatorios/rel_recipiente_utilizado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionarFiltros();
        this.setModuloConfigurar(RelatorioRecipientesUtilizados.getModuloConfigurar(0));
        this.setModuloAcesso(RelatorioRecipientesUtilizados.getModuloAcesso());
        this.setCamposConfigurador(campos);
        JCheckBox checkDetalhar = null;
        if (Acesso.getAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(1))) {
            checkDetalhar = this.adicionaRetornaFiltroCheck(FILTRO_ANALITICO, "Anal\u00edtico", false);
        }
        if (checkDetalhar != null) {
            checkDetalhar.addChangeListener(e -> {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    this.setModuloConfigurar(RelatorioRecipientesUtilizados.getModuloConfigurar(1));
                    this.setModuloAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(1));
                } else {
                    this.setModuloConfigurar(RelatorioRecipientesUtilizados.getModuloConfigurar(0));
                    this.setModuloAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(0));
                }
            });
        }
        this.setModuloConfigurar(RelatorioRecipientesUtilizados.getModuloConfigurar(0));
        this.setModuloAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(0));
    }

    @Override
    public void imprimirPressionado() {
        this.setAcessos();
        if (this.validaFiltros()) {
            try {
                Statement st = Conexao.getStatement();
                if (this.getFiltroCheck(FILTRO_ANALITICO)) {
                    this.executarAnalitico(st);
                } else {
                    this.executarSimples(st);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean validaFiltros() {
        if (Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            Funcoes.mensagem(this, "O campo Data inicial deve ser preenchido", 2);
            ScreenUtil.requisitarFoco(this.getComponentes().get(FILTRO_DATA_INICIAL));
            this.habilitaBotaoImprimir(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
            Funcoes.mensagem(this, "O campo Data final deve ser preenchido", 2);
            ScreenUtil.requisitarFoco(this.getComponentes().get(FILTRO_DATA_FINAL));
            this.habilitaBotaoImprimir(true);
            return false;
        }
        return true;
    }

    private void executarAnalitico(Statement st) throws SQLException {
        ResultSet rs = Conexao.executeQuery(st, this.buscaDadosRequisicao());
        if (rs.next()) {
            Arrays.sort(campos);
            ModeloGridTable modelo = new ModeloGridTable(campos);
            do {
                boolean achou = false;
                for (int i = 0; i < modelo.getRowCount(); ++i) {
                    String recep = (String)modelo.getValueAt(i, 7);
                    String req = (String)modelo.getValueAt(i, 8);
                    if (!recep.equals(rs.getString("codigoRecipiente")) || !req.equals(rs.getString("codigoRequisicao"))) continue;
                    achou = true;
                }
                if (achou) continue;
                modelo.addLine(new String[]{rs.getString("cepFilial"), rs.getString("CNESFilial"), rs.getString("cnpjFilial"), rs.getString("codigoBairroFilial"), rs.getString("codigoCidadeFilial"), rs.getString("codigoFilial"), rs.getString("codigoPaciente"), rs.getString("codigoRecipiente"), rs.getString("codigoRequisicao"), rs.getString("complementoFilial"), Funcoes.formataData("dd/MM/yyyy", Funcoes.pgDatetoDate(rs.getString("dataRequisicao"))), rs.getString("descricaoBairroFilial"), rs.getString("descricaoCidadeFilial"), rs.getString("descricaoFilial"), rs.getString("descricaoRecipiente"), rs.getString("enderecoFilial"), rs.getString("estadoCidadeFilial"), rs.getString("examesRequisicao"), rs.getString("faxFilial"), rs.getString("foneFilial"), rs.getString("horaRequisicao"), rs.getString("nomePaciente"), rs.getString("nomeSocialPaciente"), this.getQuantidadeUtilizado(rs), rs.getString("razaoSocialConvenio"), rs.getString("razaoSocialFilial")});
            } while (rs.next());
            this.executar(st, modelo);
        } else {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            this.habilitaBotaoImprimir(true);
        }
    }

    private String getQuantidadeUtilizado(ResultSet rs) throws SQLException {
        String quantidadeUtilizado = "";
        if (this.getFiltroCombo(FILTRO_TIPO).equals(this.tipo[0])) {
            quantidadeUtilizado = rs.getString("quantidadeUtilizadoColeta");
        } else if (this.getFiltroCombo(FILTRO_TIPO).equals(this.tipo[1])) {
            quantidadeUtilizado = rs.getString("quantidadeUtilizadoTriagem");
        } else {
            Integer quantidadeTriagem = StringUtil.isEmpty(rs.getString("quantidadeUtilizadoTriagem")) ? 0 : Integer.valueOf(rs.getString("quantidadeUtilizadoTriagem"));
            Integer quantidadeColeta = StringUtil.isEmpty(rs.getString("quantidadeUtilizadoColeta")) ? 0 : Integer.valueOf(rs.getString("quantidadeUtilizadoColeta"));
            quantidadeUtilizado = String.valueOf(quantidadeColeta + quantidadeTriagem);
        }
        return quantidadeUtilizado;
    }

    private void executarSimples(Statement st) throws SQLException {
        ResultSet rs = Conexao.executeQuery(st, this.buscaDadosRequisicao());
        if (rs.next()) {
            HashMap<String, String> requisicaoRecipiente = new HashMap<String, String>();
            Arrays.sort(campos);
            ModeloGridTable modelo = new ModeloGridTable(campos);
            do {
                boolean achou = false;
                for (int i = 0; i < modelo.getRowCount(); ++i) {
                    String recep = (String)modelo.getValueAt(i, 7);
                    if (!recep.equalsIgnoreCase(rs.getString("codigoRecipiente"))) continue;
                    achou = true;
                    String req = (String)modelo.getValueAt(i, 8);
                    if (req.equalsIgnoreCase(rs.getString("codigoRequisicao")) || requisicaoRecipiente.containsKey(rs.getString("codigoRequisicao")) && !requisicaoRecipiente.isEmpty() && ((String)requisicaoRecipiente.get(rs.getString("codigoRequisicao"))).equals(recep)) continue;
                    requisicaoRecipiente.put(rs.getString("codigoRequisicao"), rs.getString("codigoRecipiente"));
                    int qde = Integer.parseInt(modelo.getValueAt(i, 23).toString());
                    modelo.setValueAt(String.valueOf(qde + Integer.parseInt(this.getQuantidadeUtilizado(rs))), i, 23);
                }
                if (achou) continue;
                modelo.addLine(new String[]{rs.getString("cepFilial"), rs.getString("CNESFilial"), rs.getString("cnpjFilial"), rs.getString("codigoBairroFilial"), rs.getString("codigoCidadeFilial"), rs.getString("codigoFilial"), rs.getString("codigoPaciente"), rs.getString("codigoRecipiente"), rs.getString("codigoRequisicao"), rs.getString("complementoFilial"), Funcoes.formataData("dd/MM/yyyy", Funcoes.pgDatetoDate(rs.getString("dataRequisicao"))), rs.getString("descricaoBairroFilial"), rs.getString("descricaoCidadeFilial"), rs.getString("descricaoFilial"), rs.getString("descricaoRecipiente"), rs.getString("enderecoFilial"), rs.getString("estadoCidadeFilial"), rs.getString("examesRequisicao"), rs.getString("faxFilial"), rs.getString("foneFilial"), rs.getString("horaRequisicao"), rs.getString("nomePaciente"), rs.getString("nomeSocialPaciente"), this.getQuantidadeUtilizado(rs), rs.getString("razaoSocialConvenio"), rs.getString("razaoSocialFilial")});
            } while (rs.next());
            this.executar(st, modelo);
        } else {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            this.habilitaBotaoImprimir(true);
        }
    }

    private void setAcessos() {
        if (this.getFiltroCheck(FILTRO_ANALITICO)) {
            this.setModuloConfigurar(RelatorioRecipientesUtilizados.getModuloConfigurar(1));
            this.setModuloAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(1));
        } else {
            this.setModuloConfigurar(RelatorioRecipientesUtilizados.getModuloConfigurar(0));
            this.setModuloAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(0));
        }
    }

    private void executar(Statement st, ModeloGridTable modelo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        if (this.getFiltroCheck(FILTRO_ANALITICO)) {
            buf.append(RelatorioRecipientesUtilizados.getModuloAcesso(1));
        } else {
            buf.append(RelatorioRecipientesUtilizados.getModuloAcesso(0));
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
            gerador.setPai(this.panelCentro);
            gerador.setPreVisualizar(true);
            gerador.setZoomPreVisualizar(0.5f);
            gerador.setAcaoFechar(() -> {
                this.panelCentro.removeAll();
                this.panelCentro.repaint();
                this.habilitaBotaoImprimir(true);
            });
            HashMap<String, Object> rel = new HashMap<String, Object>();
            rel.put(FILTRO_FILIAL, this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
            rel.put(FILTRO_CONVENIO, this.getSelecionadosFiltro(FILTRO_CONVENIO, 0));
            rel.put(FILTRO_SETOR, this.getSelecionadosFiltro(FILTRO_SETOR, 0));
            rel.put(FILTRO_EXAME, this.getSelecionadosFiltro(FILTRO_EXAME, 0));
            rel.put(FILTRO_MATERIAL_COLETADO, this.getSelecionadosFiltro(FILTRO_MATERIAL_COLETADO, 0));
            rel.put(FILTRO_RECEPIENTE, this.getSelecionadosFiltro(FILTRO_RECEPIENTE, 0));
            rel.put(FILTRO_TIPO, this.getFiltroCombo(FILTRO_TIPO));
            rel.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
            rel.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
            rel.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
            rel.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
            gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, rel);
            this.panelCentro.revalidate();
        }
    }

    private String buscaDadosRequisicao() {
        this.bui = new StringBuilder();
        this.bui.append(" select req.req_codigo as codigoRequisicao, req.req_data as dataRequisicao, req.req_hora as horaRequisicao, pac.pac_codigo as codigoPaciente, ");
        this.bui.append(" pac.pac_nome as nomePaciente, pac.pac_nomesocial as nomeSocialPaciente, pac.pac_idade as idadePaciente, pac.pac_datanasc as dataNascimentoPaciente, ");
        this.bui.append(" con.con_razao as razaoSocialConvenio, req.req_data as dataRequisicao, err.rec_kodigo as codigoRecipiente, rec.rec_descricao as descricaoRecipiente, ( ");
        this.bui.append("   select string_agg(exa.exa_codigo, ', ')  ");
        this.bui.append("   from examerequisicao exa  ");
        this.bui.append("   left join exameRequisicaoRecipiente e on e.fil_codigo = exa.fil_codigo and e.exa_codigo = exa.exa_codigo and exa.req_codigo = e.req_codigo  ");
        this.bui.append("   where exa.fil_codigo = req.fil_codigo and exa.req_codigo = req.req_codigo and exa.exa_codigo = e.exa_codigo and exa.mco_codigo = e.mco_codigo and e.rec_kodigo = err.rec_kodigo");
        this.getFiltroExame(true);
        this.bui.append("   ) as examesRequisicao, ");
        this.bui.append("   (select count(r.rec_codigo) ");
        this.bui.append("   from recipientes r ");
        this.bui.append("   left join exameRequisicaoRecipiente e on e.fil_codigo = r.fil_codigo and e.rec_codigo = r.rec_codigo ");
        this.bui.append("   where r.fil_codigo = req.fil_codigo and e.req_codigo = req.req_codigo and e.rec_kodigo = err.rec_kodigo ");
        this.getFiltroExame(true);
        this.bui.append("   and e.ere_tipo = '").append("C").append("' ) as quantidadeUtilizadoColeta, ");
        this.bui.append("   (select count(r.rec_codigo) ");
        this.bui.append("   from recipientes r ");
        this.bui.append("   left join exameRequisicaoRecipiente e on e.fil_codigo = r.fil_codigo and e.rec_codigo = r.rec_codigo ");
        this.bui.append("   where r.fil_codigo = req.fil_codigo and e.req_codigo = req.req_codigo and e.rec_kodigo = err.rec_kodigo ");
        this.getFiltroExame(true);
        this.bui.append("   and e.ere_tipo = '").append("T").append("' ) as quantidadeUtilizadoTriagem, ");
        this.bui.append("  filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, ");
        this.bui.append("  filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, ");
        this.bui.append("  filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, ");
        this.bui.append("  cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,");
        this.bui.append("  bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial, (");
        this.bui.append("   select count(e.rec_codigo)  ");
        this.bui.append("   from  exameRequisicaoRecipiente e ");
        this.bui.append("    where e.fil_codigo = req.fil_codigo and e.req_codigo = req.req_codigo and e.rec_codigo = err.rec_codigo ");
        this.bui.append("   ) as quantidadeTotal ");
        this.bui.append(" from requisicao req ");
        this.bui.append(" left join exameRequisicaoRecipiente err on err.fil_codigo = req.fil_codigo and err.req_codigo = req.req_codigo ");
        this.bui.append(" left join recipientes rec on rec.fil_codigo = req.fil_codigo and rec.rec_codigo = err.rec_kodigo ").append(this.getJoin());
        this.getFiltros();
        this.bui.append(" order by ").append(this.getOrdem());
        return this.bui.toString();
    }

    private String getJoin() {
        StringBuilder sql = new StringBuilder();
        sql.append(" left join convenios con on con.fil_codigo = req.fil_codigo and con.con_codigo = req.con_codigo ");
        sql.append(" left join filiais_postocoleta filial on filial.fil_codigo = req.fil_codigo ");
        sql.append(" left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
        sql.append(" left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        this.bui.append(" left join paciente pac on pac.fil_codigo = req.fil_codigo and pac.pac_codigo = req.pac_codigo ");
        this.bui.append(" left join examesetor ext on ext.fil_codigo = err.fil_codigo and ext.exa_codigo = err.exa_codigo and ext.ese_default = true ");
        this.bui.append(" left join setores sto on sto.fil_codigo = err.fil_codigo and sto.set_codigo = ext.set_codigo ");
        this.bui.append(" left join materialcoleta mco on mco.fil_codigo = err.fil_codigo and mco.mco_codigo = err.mco_codigo ");
        this.bui.append(" left join examerequisicao exr on exr.fil_codigo = rec.fil_codigo and exr.exa_codigo = err.exa_codigo and exr.mco_codigo = err.mco_codigo and exr.req_codigo = req.req_codigo ");
        return sql.toString();
    }

    private void getFiltros() {
        this.getFiltroFilial();
        this.getFiltroConvenio();
        this.getFiltroSetor();
        this.getFiltroExame(false);
        this.getFiltroMaterial();
        this.getFiltroRecepiente();
        this.getFiltroData();
        this.getFiltroTipo();
    }

    private void getFiltroTipo() {
        if (this.getFiltroCombo(FILTRO_TIPO).equals(this.tipo[0])) {
            this.bui.append(" and rec.rec_tipo = '").append("C").append("' ");
        } else if (this.getFiltroCombo(FILTRO_TIPO).equals(this.tipo[1])) {
            this.bui.append(" and rec.rec_tipo = '").append("T").append("' ");
        }
    }

    private void getFiltroData() {
        if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            this.bui.append(" and cast(").append(this.getTipoData()).append(" as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append("' ");
        }
        if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
            this.bui.append(" and cast(").append(this.getTipoData()).append(" as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' ");
        }
    }

    private void getFiltroRecepiente() {
        String[] recepiente = this.getSelecionadosFiltro(FILTRO_RECEPIENTE, 0);
        if (recepiente != null) {
            this.bui.append(" and rec.rec_codigo in (");
            for (int i = 0; i < recepiente.length; ++i) {
                this.bui.append(recepiente[i]);
                if (i >= recepiente.length - 1) continue;
                this.bui.append(", ");
            }
            this.bui.append(")");
        }
    }

    private void getFiltroMaterial() {
        String[] material = this.getSelecionadosFiltro(FILTRO_MATERIAL_COLETADO, 0);
        if (material != null) {
            this.bui.append(" and mco.mco_codigo in (");
            for (int i = 0; i < material.length; ++i) {
                this.bui.append(material[i]);
                if (i >= material.length - 1) continue;
                this.bui.append(", ");
            }
            this.bui.append(")");
        }
    }

    private void getFiltroExame(boolean tabelaRecipiente) {
        String[] exame = this.getSelecionadosFiltro(FILTRO_EXAME, 0);
        if (exame != null) {
            if (tabelaRecipiente) {
                this.bui.append(" and e.exa_codigo in ('");
            } else {
                this.bui.append(" and err.exa_codigo in ('");
            }
            for (int i = 0; i < exame.length; ++i) {
                this.bui.append(exame[i]);
                if (i >= exame.length - 1) continue;
                this.bui.append("', '");
            }
            this.bui.append("')");
        }
    }

    private void getFiltroSetor() {
        String[] setor = this.getSelecionadosFiltro(FILTRO_SETOR, 0);
        if (setor != null) {
            this.bui.append(" and sto.set_codigo in (");
            for (int i = 0; i < setor.length; ++i) {
                this.bui.append(setor[i]);
                if (i >= setor.length - 1) continue;
                this.bui.append(", ");
            }
            this.bui.append(")");
        }
    }

    private void getFiltroConvenio() {
        String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
        if (convenio != null) {
            this.bui.append(" and req.con_codigo in (");
            for (int i = 0; i < convenio.length; ++i) {
                this.bui.append(convenio[i]);
                if (i >= convenio.length - 1) continue;
                this.bui.append(", ");
            }
            this.bui.append(")");
        }
    }

    private void getFiltroFilial() {
        String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        this.bui.append(" where err.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            this.bui.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            this.bui.append(", ");
        }
        this.bui.append(")");
    }

    private String getOrdem() {
        if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[0])) {
            return "rec.rec_codigo, req.req_codigo";
        }
        return "rec.rec_descricao, req.req_codigo";
    }

    private String getTipoData() {
        if (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals(this.campoData[0])) {
            return "req.req_data";
        }
        if (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals(this.campoData[1])) {
            return "exr.exr_datamaterial";
        }
        if (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals(this.campoData[2])) {
            return "exr.exr_dataetqcoleta";
        }
        return "exr.exr_dataetqtriagem";
    }

    private void adicionarFiltros() {
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_MATERIAL_COLETADO, "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_RECEPIENTE, "Recipientes", "recipientes", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"rec_codigo", "rec_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo(FILTRO_TIPO, "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", this.campoData, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.ordem, 0);
        if (Acesso.getAcesso(RelatorioRecipientesUtilizados.getModuloAcesso(1))) {
            this.adicionaFiltroCheck(FILTRO_ANALITICO, "Anal\u00edtico", false);
        }
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == 1) {
            return Long.parseLong("0840103200");
        }
        return Long.parseLong("0840103100");
    }

    public static long getModuloConfigurar(int tipo) {
        if (tipo == 1) {
            return Long.parseLong("0840103201");
        }
        return Long.parseLong("0840103101");
    }
}

