/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.resultados.relatorionotificacaocompulsoria;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class RelatorioNotificaoCompulsoriaDao {
    private static String MENSAGEM_COMPULSORIA = "mensagemCompulsoria";
    private String[] filtroFilial;
    private String[] filtroCidade;
    private String[] filtroExame;
    private String filtroSexo;
    private String campoData;
    private String dataInicial;
    private String dataFinal;
    private String horaInicial;
    private String horaFinal;
    private Integer ordem;
    protected static String[] campos;
    private boolean filtroIntervaloHora;
    private String filtroResultado;

    public RelatorioNotificaoCompulsoriaDao() {
        this.montaCampos();
    }

    public ModeloGridTable realizaConsulta() throws SQLException {
        int i;
        StringBuilder bui = new StringBuilder();
        bui.append("select ");
        bui.append("p.pac_codigo as codigoPaciente, ");
        bui.append("p.pac_nome   as nomePaciente, ");
        bui.append("p.pac_sexo as sexoPaciente, ");
        bui.append("p.pac_datanasc as dataNascimentoPaciente, ");
        bui.append("p.pac_endereco as enderecoPaciente,  ");
        bui.append("p.pac_email as emailPaciente,  ");
        bui.append("p.pac_passaporte as passaportePaciente,  ");
        bui.append("p.pac_complemento as complementoEnderecoPaciente,  ");
        bui.append("p.bai_codigo as codigoBairroPaciente,  ");
        bui.append("p.pac_tipologradouroendereco as tipoLogradouroPaciente,  ");
        bui.append("p.pac_numeroendereco as numeroEnderecoPaciente,  ");
        bui.append("bairropaciente.bai_descricao as descricaoBairroPaciente,  ");
        bui.append("p.pac_fone  as telefonePaciente,  ");
        bui.append("cid.cid_codigo as codigoCidadePaciente,   ");
        bui.append("cid.cid_nome as cidadePaciente, ");
        bui.append("cid.cid_uf as ufPaciente, ");
        bui.append("req.req_codigo as codigoRequisicao, ");
        bui.append("req.req_periodogestacional as periodoGestacionalRequisicao, ");
        bui.append("exr.exr_datamaterial as dataColeta, ");
        bui.append("exr.exr_dataassina as dataLiberacao, ");
        bui.append("exr.exa_codigo as codigoExame, ");
        bui.append("exr.mco_codigo as codigoMaterial, ");
        bui.append("exa.exa_descricao as nomeExame, ");
        bui.append("substring(ert_resultado, ((select POSITION('<mensagemCompulsoria>' in ert_resultado)) + 30) ,(select POSITION('</mensagemCompulsoria>' in ert_resultado) - 34) -  (select POSITION('<mensagemCompulsoria>' in ert_resultado)))  as resultado, ");
        bui.append("ert_resultado as resultadoExame, ");
        bui.append("cidadefilial.cid_codigoibge AS codigoIbgeCidadeFilial, ");
        bui.append("p.pac_rg as rgPaciente, ");
        bui.append("p.pac_cpf as cpfPaciente, ");
        bui.append("p.pac_pai as paiPaciente, ");
        bui.append("p.pac_mae as maePaciente, ");
        bui.append("p.pac_responsavel as responsavelPaciente, ");
        bui.append("p.pac_cpfresponsavel as cpfResponsavelPaciente, ");
        bui.append("p.pac_cep as cepPaciente, ");
        bui.append("p.pac_celular as celularPaciente, ");
        bui.append("p.pac_cor as corPaciente, ");
        bui.append("p.pac_idade as idadePaciente, ");
        bui.append("p.pac_cartaosus as cartaoSusPaciente, ");
        bui.append("req.req_prontuario as prontuarioRequisicaoPaciente, ");
        bui.append("req.req_obs as observacaoRequisicao, ");
        bui.append("req.req_dclinicos as dadosClinicosRequisicao, ");
        bui.append("req.med_conselho as siglaConselhoMedico, ");
        bui.append("req.med_crm as crmMedicoSolicitante, ");
        bui.append("med.med_nome as nomeMedicoSolicitante,");
        bui.append("req.med_uf as ufMedicoSolicitante, ");
        bui.append("idg.ige_descricao as generoPaciente, ");
        bui.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        bui.append("from paciente p ");
        bui.append("inner join requisicao req on (p.fil_codigo = req.fil_codigo and p.pac_codigo = req.pac_codigo) ");
        bui.append("inner join examerequisicao exr on (req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo) ");
        bui.append("inner join examerequisicaoresultado ert on (exr.fil_codigo = ert.fil_codigo and exr.req_codigo = ert.req_codigo and exr.exa_codigo = ert.exa_codigo and exr.mco_codigo = ert.mco_codigo ) ");
        bui.append("left join bairro bairropaciente on p.fil_codigo = bairropaciente.fil_codigo and p.bai_codigo = bairropaciente.bai_codigo ");
        bui.append("left join exames exa on (exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo) ");
        bui.append("left join cidades cid on (p.fil_codigo = cid.fil_codigo and p.cid_codigo = cid.cid_codigo) ");
        bui.append("left join filiais_postocoleta filial on p.fil_codigo = filial.fil_codigo ");
        bui.append("left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
        bui.append("left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        bui.append("left join medico med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        bui.append("left join identidadegenero idg on coalesce(p.pac_genero, 0) = idg.ige_codigo ");
        if (this.filtroFilial == null) {
            this.filtroFilial = new String[]{Variaveis.filialPadrao};
        }
        bui.append(" where filial.fil_codigo in (");
        for (i = 0; i < this.filtroFilial.length; ++i) {
            bui.append(this.filtroFilial[i]);
            if (i >= this.filtroFilial.length - 1) continue;
            bui.append(", ");
        }
        bui.append(") ").append(" and exr.exr_compulsorio ");
        if (this.filtroCidade != null) {
            bui.append(" and p.cid_codigo in( ");
            for (i = 0; i < this.filtroCidade.length; ++i) {
                bui.append(this.filtroCidade[i]);
                if (i >= this.filtroCidade.length - 1) continue;
                bui.append(", ");
            }
            bui.append(" ) ");
        }
        if (this.filtroExame != null) {
            bui.append(" and exr.exa_codigo in( '");
            for (i = 0; i < this.filtroExame.length; ++i) {
                bui.append(this.filtroExame[i]);
                if (i >= this.filtroExame.length - 1) continue;
                bui.append("', '");
            }
            bui.append("') ");
        }
        if (!this.isFiltroIntervaloHora()) {
            if (!Funcoes.textoVazio(this.dataInicial)) {
                bui.append(" and cast(").append(this.getTipoData()).append(" as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicial)).append("' ");
            }
            if (!Funcoes.textoVazio(this.dataFinal)) {
                bui.append(" and cast(").append(this.getTipoData()).append(" as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinal)).append("' ");
            }
            if (!Funcoes.textoVazio(this.horaInicial)) {
                bui.append(" and cast(").append(this.getTipoData()).append(" as time) >= '").append(this.horaInicial).append("' ");
            }
            if (!Funcoes.textoVazio(this.horaFinal)) {
                bui.append(" and cast(").append(this.getTipoData()).append(" as time) <= '").append(this.horaFinal).append("' ");
            }
        } else {
            bui.append(" and ").append(this.getTipoData()).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicial));
            bui.append(" ").append(this.horaInicial).append("' ");
            bui.append(" and ").append(this.getTipoData()).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinal));
            bui.append(" ").append(this.horaFinal).append("' ");
        }
        bui.append(this.getSexo());
        bui.append("order by ");
        bui.append("filial.fil_codigo ");
        bui.append(",").append(this.getOrdenacao());
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        ModeloGridTable modelo = new ModeloGridTable(campos);
        while (rs.next()) {
            Object[] o = new Object[campos.length];
            TabelaSimbolos tabela = new TabelaSimbolos();
            int pos = -1;
            for (int i2 = 0; i2 < campos.length; ++i2) {
                if (!campos[i2].equalsIgnoreCase("resultado") && !campos[i2].equalsIgnoreCase("resultadoExame")) {
                    tabela.setSimbolo(campos[i2], rs.getObject(campos[i2]));
                }
                o[i2] = rs.getObject(campos[i2]);
                if (!campos[i2].equalsIgnoreCase("resultado")) continue;
                pos = i2;
                o[i2] = "";
            }
            String resul = rs.getString("resultado");
            boolean resultadoIgualFiltro = false;
            if (pos > -1) {
                String resultado = rs.getString("resultadoExame");
                Map<String, Object> res = Resultado.getCamposResultado(resultado, false);
                for (String key : res.keySet()) {
                    tabela.setSimbolo(key, res.get(key));
                }
                String resultadoCompulsorio = "";
                Execucao exec = new Execucao(rs.getString("resultado"), tabela, 0);
                String msg = String.valueOf(exec.resultadoExpressao());
                if (!Funcoes.textoVazio(msg)) {
                    resultadoCompulsorio = msg;
                }
                o[pos] = resultadoCompulsorio;
                resultadoIgualFiltro = resultadoCompulsorio.equalsIgnoreCase(this.filtroResultado);
            }
            if (!StringUtil.isEmpty(this.filtroResultado) && !resultadoIgualFiltro) continue;
            modelo.addLine(o);
        }
        return modelo;
    }

    private Object pegaResultado(String xml) {
        String compulsorio = StringUtil.limpaCdata(xml);
        return StringUtil.removeCaractere(compulsorio, '\"');
    }

    private Object getSexo() {
        String sql = "";
        if (!Funcoes.textoVazio(this.filtroSexo) && !this.filtroSexo.equals("Todos")) {
            sql = " and  p.pac_sexo = 'M'";
            if (this.filtroSexo.equalsIgnoreCase("Feminino")) {
                sql = " and  p.pac_sexo = 'F'";
            }
        }
        return sql;
    }

    private String getTipoData() {
        if (this.campoData.contains("Coleta")) {
            return "exr.exr_datamaterial";
        }
        return "exr.exr_dataassina";
    }

    private Object getOrdenacao() {
        switch (this.ordem) {
            case 0: {
                return "exr.exr_dataassina";
            }
            case 1: {
                return "exr.exr_datamaterial";
            }
            case 2: {
                return "exa.exa_descricao";
            }
            case 3: {
                return "p.pac_nome";
            }
        }
        return "resultado";
    }

    private void montaCampos() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"nomePaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"sexoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"dataNascimentoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"enderecoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"cidadePaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"ufPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"telefonePaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"codigoRequisicao"});
        campos = ArraysUtil.concatenar(campos, new String[]{"dataColeta"});
        campos = ArraysUtil.concatenar(campos, new String[]{"dataLiberacao"});
        campos = ArraysUtil.concatenar(campos, new String[]{"codigoExame"});
        campos = ArraysUtil.concatenar(campos, new String[]{"codigoMaterial"});
        campos = ArraysUtil.concatenar(campos, new String[]{"nomeExame"});
        campos = ArraysUtil.concatenar(campos, new String[]{"resultado"});
        campos = ArraysUtil.concatenar(campos, new String[]{"codigoIbgeCidadeFilial"});
        campos = ArraysUtil.concatenar(campos, new String[]{"periodoGestacionalRequisicao"});
        campos = ArraysUtil.concatenar(campos, new String[]{"tipoLogradouroPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"numeroEnderecoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"codigoBairroPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"descricaoBairroPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"complementoEnderecoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"emailPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"cpfPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"rgPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"paiPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"maePaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"responsavelPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"cpfResponsavelPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"cepPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"observacaoRequisicao"});
        campos = ArraysUtil.concatenar(campos, new String[]{"dadosClinicosRequisicao"});
        campos = ArraysUtil.concatenar(campos, new String[]{"celularPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"corPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"idadePaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"cartaoSusPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"prontuarioRequisicaoPaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"siglaConselhoMedico"});
        campos = ArraysUtil.concatenar(campos, new String[]{"crmMedicoSolicitante"});
        campos = ArraysUtil.concatenar(campos, new String[]{"nomeMedicoSolicitante"});
        campos = ArraysUtil.concatenar(campos, new String[]{"ufMedicoSolicitante"});
        campos = ArraysUtil.concatenar(campos, new String[]{"passaportePaciente"});
        campos = ArraysUtil.concatenar(campos, new String[]{"generoPaciente"});
    }

    public String[] getFiltroFilial() {
        return this.filtroFilial;
    }

    public void setFiltroFilial(String[] filtroFilial) {
        this.filtroFilial = filtroFilial;
    }

    public String[] getFiltroCidade() {
        return this.filtroCidade;
    }

    public void setFiltroCidade(String[] filtroCidade) {
        this.filtroCidade = filtroCidade;
    }

    public String[] getFiltroExame() {
        return this.filtroExame;
    }

    public void setFiltroExame(String[] filtroExame) {
        this.filtroExame = filtroExame;
    }

    public String getFiltroSexo() {
        return this.filtroSexo;
    }

    public void setFiltroSexo(String filtroSexo) {
        this.filtroSexo = filtroSexo;
    }

    public String getCampoData() {
        return this.campoData;
    }

    public void setCampoData(String campoData) {
        this.campoData = campoData;
    }

    public String getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(String dataInicial) {
        this.dataInicial = dataInicial;
    }

    public String getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(String dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getHoraInicial() {
        return this.horaInicial;
    }

    public void setHoraInicial(String horaInicial) {
        this.horaInicial = horaInicial;
    }

    public String getHoraFinal() {
        return this.horaFinal;
    }

    public void setHoraFinal(String horaFinal) {
        this.horaFinal = horaFinal;
    }

    public Integer getOrdem() {
        return this.ordem;
    }

    public void setOrdem(Integer ordem) {
        this.ordem = ordem;
    }

    public static String[] getCampos() {
        return campos;
    }

    public static void setCampos(String[] campos) {
        RelatorioNotificaoCompulsoriaDao.campos = campos;
    }

    public boolean isFiltroIntervaloHora() {
        return this.filtroIntervaloHora;
    }

    public void setFiltroIntervaloHora(boolean filtroIntervaloHora) {
        this.filtroIntervaloHora = filtroIntervaloHora;
    }

    public String getFiltroResultado() {
        return this.filtroResultado;
    }

    public void setFiltroResultado(String filtroResultado) {
        this.filtroResultado = filtroResultado;
    }

    public String getLayoutRelatorio(long moduloAcesso) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(moduloAcesso);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("rel_xml");
        }
        return null;
    }
}

