/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.resultados.relatorionotificacaocompulsoria;

import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.resultados.relatorionotificacaocompulsoria.RelatorioNotificaoCompulsoriaService;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.RelatorioException;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioNotificacaoCompulsoria
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    protected static final String FILTRO_FILIAL = "filtroFilial";
    protected static final String FILTRO_EXAME = "filtroExame";
    protected static final String FILTRO_CIDADE = "filtroCidade";
    protected static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    protected static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    protected static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    protected static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    protected static final String FILTRO_SEXO = "filtroSexo";
    protected static final String FILTRO_CAMPO_DATA = "campoData";
    protected static final String ORDEM_RELATORIO = "ordem";
    protected static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    protected static final String FILTRO_RESULTADO = "filtroResultado";
    private final String[] sexo = new String[]{"Todos", Tipos.tipoSexo("M"), Tipos.tipoSexo("F")};
    private final String[] ordem = new String[]{"Dt. Confer\u00eancia", "Dt. Coleta", "Nm. Exame", "Nm. Paciente", "Resultado"};
    private final String[] campoData = new String[]{"Coleta", "Confer\u00eancia"};
    private RelatorioNotificaoCompulsoriaService service = new RelatorioNotificaoCompulsoriaService();

    public RelatorioNotificacaoCompulsoria() {
        this.montaBarraDescricao("Relat\u00f3rio de Notifica\u00e7\u00e3o Compuls\u00f3ria", "Listagem dos Pacientes com doen\u00e7as obrigat\u00f3rias de Notifica\u00e7\u00e3o Compuls\u00f3ria", "relatorios/rel_resultado_notificacao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_CIDADE, "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"cid_codigo", "cid_nome", "cid_uf"}, new String[]{"C\u00f3digo", "Nome", "UF"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCombo(FILTRO_SEXO, "Sexo: ", this.sexo, 0);
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", this.campoData, 0);
        this.adicionaFiltroCombo(ORDEM_RELATORIO, "Ordem:", this.ordem, 0);
        this.adicionaFiltroTexto(FILTRO_RESULTADO, "Resultado: ", 50);
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.setModuloConfigurar(RelatorioNotificacaoCompulsoria.getModuloConfigurar());
        this.setModuloAcesso(this.getModuloAcesso());
        this.setCamposConfigurador(this.service.getCampos());
    }

    @Override
    public void imprimirPressionado() {
        try {
            this.validarCampos();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.service.setCampoData(String.valueOf(this.getFiltroCombo(FILTRO_CAMPO_DATA)));
            this.service.setDataInicial(this.getFiltroData(FILTRO_DATA_INICIAL));
            this.service.setDataFinal(this.getFiltroData(FILTRO_DATA_FINAL));
            this.service.setHoraInicial(this.getFiltroData(FILTRO_HORA_INICIAL));
            this.service.setHoraFinal(this.getFiltroData(FILTRO_HORA_FINAL));
            this.service.setFiltroCidade(this.getSelecionadosFiltroAvancado(FILTRO_CIDADE, 0));
            this.service.setFiltroExame(this.getSelecionadosFiltro(FILTRO_EXAME, 0));
            this.service.setFiltroFilial(this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
            this.service.setFiltroSexo(String.valueOf(this.getFiltroCombo(FILTRO_SEXO)));
            this.service.setOrdem(this.getFiltroComboIndice(ORDEM_RELATORIO));
            this.service.setFiltroIntervaloHora(this.getFiltroCheck(FILTRO_INTERVALO_HORA));
            this.service.setFiltroResultado(this.getFiltroTexto(FILTRO_RESULTADO));
            ModeloGridTable modelo = this.service.impressmir();
            if (modelo.getRowCount() == 0) {
                throw new RelatorioException("N\u00e3o h\u00e1 dados para imprimir.");
            }
            String layout = this.service.getLayoutRelatorio(RelatorioNotificacaoCompulsoria.getModuloAcesso());
            if (modelo.getRowCount() > 0) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                Map<String, Object> var = this.service.getFiltros();
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioNotificacaoCompulsoria.this.panelCentro.removeAll();
                        RelatorioNotificacaoCompulsoria.this.panelCentro.repaint();
                        RelatorioNotificacaoCompulsoria.this.habilitaBotaoImprimir(true);
                    }
                });
                gerador.executar(layout, (TableModel)modelo, var);
                this.panelCentro.revalidate();
            }
        }
        catch (RelatorioException e) {
            Funcoes.mensagem(this, e.getMessage(), 2);
            this.habilitaBotaoImprimir(true);
        }
        catch (SQLException e) {
            Funcoes.mensagem(this, e.getMessage(), 2);
            this.habilitaBotaoImprimir(true);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void validarCampos() throws RelatorioException {
        String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
        String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
        String horaInicial = this.getFiltroData(FILTRO_HORA_INICIAL);
        String horaFinal = this.getFiltroData(FILTRO_HORA_FINAL);
        if (Funcoes.textoVazio(dataInicial) || Funcoes.textoVazio(dataFinal)) {
            throw new RelatorioException("Campo Data deve ser preenchido (Data inicial e final)!");
        }
        if (!Funcoes.verificaData(dataInicial)) {
            throw new RelatorioException("A data inicial \u00e9 inv\u00e1lida.");
        }
        if (!Funcoes.textoVazio(dataInicial) && !Funcoes.textoVazio(dataFinal) && Funcoes.getData("dd/MM/yyyy", dataInicial).compareTo(Funcoes.getData("dd/MM/yyyy", dataFinal)) > 0) {
            throw new RelatorioException("A data inicial \u00e9 maior do que a data final.");
        }
        if (this.getFiltroCheck(FILTRO_INTERVALO_HORA) && (Funcoes.textoVazio(horaInicial) || Funcoes.textoVazio(horaFinal))) {
            throw new RelatorioException("Campo hora deve ser preenchido (Hora inicial e final)!");
        }
        if (this.getFiltroCheck(FILTRO_INTERVALO_HORA) && !Funcoes.verificaHora(horaInicial)) {
            throw new RelatorioException("A hora inicial \u00e9 inv\u00e1lida.");
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0840102900");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0840102901");
    }
}

