/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioResultadosRetificados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String VARIAVEL_QTDE_EXAMES = "quantidadeExames";
    private static final String VARIAVEL_QTDE_REQUISICOES = "quantidadeRequisicoes";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "abrevMaterialColetado", "usuarioConferencia", "codigoUsuarioConferencia", "codigoMaterial", "descricaoMaterial", "dataDigitacao", "nomeUsuarioConferencia", "dataConferido", "codigoUsuarioRetificacao", "nomeUsuarioRetificacao", "motivoRetificacao", "codigoRequisicao", "codigoPaciente", "nomePaciente", "dataRequisicao", "codigoConvenio", "fantasiaConvenio", "codigoSetor", "descricaoSetor", "dataHoraRetificao", "nomeSocialPaciente"});

    public RelatorioResultadosRetificados() {
        this.montaBarraDescricao("Relat\u00f3rio de exames retificados", "Listagem de exames retificados", "relatorios/rel_resultado_retificado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", "fil_codigo = " + Variaveis.filialPadrao + " and usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaNomeVariavel(VARIAVEL_QTDE_EXAMES);
        this.adicionaNomeVariavel(VARIAVEL_QTDE_REQUISICOES);
        this.setModuloConfigurar(RelatorioResultadosRetificados.getModuloConfigurar());
        this.setModuloAcesso(this.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0830100400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0830100401");
    }

    @Override
    public void imprimirPressionado() {
        String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
        String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
        if (Funcoes.textoVazio(dataInicial)) {
            Funcoes.mensagem(this, "Os campos de Data devem ser preenchidos.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!Funcoes.verificaData(dataInicial)) {
            Funcoes.mensagem(this, "A data inicial \u00e9 inv\u00e1lida.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!Funcoes.textoVazio(dataInicial) && !Funcoes.textoVazio(dataFinal) && Funcoes.getData("dd/MM/yyyy", dataInicial).compareTo(Funcoes.getData("dd/MM/yyyy", dataFinal)) > 0) {
            Funcoes.mensagem(this, "A data inicial \u00e9 maior do que a data final.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] usuario;
            String[] setor;
            Statement statement = Conexao.getStatement();
            StringBuilder sql = new StringBuilder();
            sql.append("select ");
            sql.append("( SELECT er.usr_codigo || ':' || us.usr_nome FROM examerequisicaosituacoes er JOIN usuario us ON us.usr_codigo = er.usr_codigo AND us.fil_codigo = er.fil_codigo WHERE us.fil_codigo = a.fil_codigo AND er.req_codigo = a.req_codigo ");
            sql.append(" AND er.exa_codigo = a.exa_codigo AND er.mco_codigo = a.mco_codigo AND er.ers_situacao = 'C' AND er.ers_datahora < ehl.ehl_datahora ORDER BY er.ers_datahora DESC LIMIT 1 ");
            sql.append(" ) as usuarioConferencia, ");
            sql.append(" ehl.ehl_datahora as dataHoraRetificao,'' as codigoUsuarioConferencia,'' as nomeUsuarioConferencia, mco.mco_abreviatura as abrevMaterialColetado, exa.exa_codigo as codigoExame, exa.exa_descricao as descricaoExame, ");
            sql.append(" mco.mco_codigo as codigoMaterial, mco.mco_descricao as descricaoMaterial, ");
            sql.append(" a.exr_datadigita as dataDigitacao, a.exr_dataassina as dataConferido, ");
            sql.append(" ehl.usr_codigo as codigoUsuarioRetificacao, usr.usr_nome as nomeUsuarioRetificacao, ");
            sql.append(" ehl.ehl_motivo as motivoRetificacao, req.req_codigo as codigoRequisicao, ");
            sql.append(" pac.pac_codigo as codigoPaciente, pac.pac_nome as nomePaciente, pac.pac_nomesocial as nomeSocialPaciente, ");
            sql.append(" req.req_data as  dataRequisicao, con.con_codigo as codigoConvenio, ");
            sql.append(" con.con_fantasia as fantasiaConvenio, ");
            sql.append(" ese.set_codigo as codigoSetor, setor.set_descricao as descricaoSetor, ");
            sql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            sql.append(" from examerequisicao a ");
            sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            sql.append(" join requisicao req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
            sql.append(" join paciente pac on a.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            sql.append(" join examerequisicaohistoricolaudo ehl on a.fil_codigo = ehl.fil_codigo and a.exa_codigo = ehl.exa_codigo ");
            sql.append(" and a.mco_codigo = ehl.mco_codigo and req.req_codigo = ehl.req_codigo ");
            sql.append(" join exames exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
            sql.append(" join materialcoleta mco on mco.fil_codigo = a.fil_codigo and a.mco_codigo = mco.mco_codigo ");
            sql.append(" join usuario usr on ehl.usr_codigo = usr.usr_codigo ");
            sql.append(" join convenios con on  req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            sql.append(" join examesetor ese on exa.fil_codigo = ese.fil_codigo and exa.exa_codigo = ese.exa_codigo and ese.ese_default = true");
            sql.append(" join setores setor on ese.fil_codigo = setor.fil_codigo and ese.set_codigo = setor.set_codigo  ");
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            sql.append(" where  filial.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                sql.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                sql.append(", ");
            }
            sql.append(") ");
            String[] pacientes = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0);
            if (pacientes != null) {
                sql.append(" and pac.pac_codigo in( ");
                for (int i = 0; i < pacientes.length; ++i) {
                    sql.append(pacientes[i]);
                    if (i >= pacientes.length - 1) continue;
                    sql.append(", ");
                }
                sql.append(" ) ");
            }
            if ((setor = this.getSelecionadosFiltro(FILTRO_SETOR, 0)) != null) {
                sql.append(" and setor.set_codigo in( ");
                for (int i = 0; i < setor.length; ++i) {
                    sql.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    sql.append(", ");
                }
                sql.append(" ) ");
            }
            if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                sql.append(" and usr.usr_codigo in('");
                for (int i = 0; i < usuario.length; ++i) {
                    sql.append(usuario[i]);
                    if (i >= usuario.length - 1) continue;
                    sql.append("','");
                }
                sql.append("') ");
            }
            if (!Funcoes.textoVazio(dataInicial)) {
                sql.append(" and  cast(ehl.ehl_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
            }
            if (!Funcoes.textoVazio(dataFinal)) {
                sql.append(" and  cast(ehl.ehl_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
            }
            sql.append(" order by filial.fil_codigo, req.req_codigo, exa.exa_codigo, mco.mco_codigo, ehl.ehl_datahora ");
            ResultSet rs = Conexao.executeQuery(statement, sql.toString());
            ModeloGridTable modelo = new ModeloGridTable(campos);
            int qtdeExames = 0;
            int qtdeRequisicoes = 0;
            long req = -1L;
            String codigoUsuarioConferencia = "";
            String nomeUsuarioConferencia = "";
            if (rs.next()) {
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        String[] array;
                        if (campos[i].equals("codigoUsuarioConferencia")) {
                            array = rs.getString("usuarioConferencia") != null ? rs.getString("usuarioConferencia").split(":") : new String[]{};
                            o[i] = rs.getString("usuarioConferencia") != null ? array[0] : "";
                            continue;
                        }
                        if (campos[i].equals("nomeUsuarioConferencia")) {
                            array = rs.getString("usuarioConferencia") != null ? rs.getString("usuarioConferencia").split(":") : new String[]{};
                            o[i] = rs.getString("usuarioConferencia") != null ? array[1] : "";
                            continue;
                        }
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                    ++qtdeExames;
                    if (req != -1L && req == Long.parseLong(Funcoes.preencheZero(rs.getString("codigoFilial"), 2) + Funcoes.preencheZero(rs.getString("codigoRequisicao"), 8))) continue;
                    req = Long.parseLong(Funcoes.preencheZero(rs.getString("codigoFilial"), 2) + Funcoes.preencheZero(rs.getString("codigoRequisicao"), 8));
                    ++qtdeRequisicoes;
                } while (rs.next());
                sql.delete(0, sql.length());
                sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
                sql.append(RelatorioResultadosRetificados.getModuloAcesso());
                rs = Conexao.executeQuery(statement, sql.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioResultadosRetificados.this.panelCentro.removeAll();
                            RelatorioResultadosRetificados.this.panelCentro.repaint();
                            RelatorioResultadosRetificados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    sql.delete(0, sql.length());
                    if (setor != null && setor.length > 0) {
                        for (int i = 0; i < setor.length; ++i) {
                            sql.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            sql.append(", ");
                        }
                        var.put(FILTRO_SETOR, sql.toString());
                    }
                    sql.delete(0, sql.length());
                    if (pacientes != null && pacientes.length > 0) {
                        for (int i = 0; i < pacientes.length; ++i) {
                            sql.append(pacientes[i]);
                            if (i >= pacientes.length - 1) continue;
                            sql.append(", ");
                        }
                        var.put(FILTRO_PACIENTE, sql.toString());
                    }
                    sql.delete(0, sql.length());
                    if (filiais != null && filiais.length > 0) {
                        for (int i = 0; i < filiais.length; ++i) {
                            sql.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            sql.append(", ");
                        }
                        var.put(FILTRO_FILIAL, sql.toString());
                    }
                    sql.delete(0, sql.length());
                    if (usuario != null) {
                        for (int i = 0; i < usuario.length; ++i) {
                            sql.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            sql.append(",");
                        }
                    }
                    var.put(FILTRO_USUARIO, sql.toString());
                    var.put(FILTRO_DATA_INICIAL, dataInicial);
                    var.put(FILTRO_DATA_FINAL, dataFinal);
                    var.put(VARIAVEL_QTDE_EXAMES, qtdeExames);
                    var.put(VARIAVEL_QTDE_REQUISICOES, qtdeRequisicoes);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(statement);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            this.habilitaBotaoImprimir(true);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }
}

