/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao.relatorioPacienteExameRealizado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.relatorios.recepcao.relatorioPacienteExameRealizado.RelatorioPacienteExameRealizado;
import jalis.laboratorio.relatorios.recepcao.relatorioPacienteExameRealizado.RelatorioPacienteExameRealizadoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RelatorioPacienteExameRealizadoDAO {
    private static final String SIM = "Sim";
    private static final String TODOS = "Todos";
    private static final String NAO_INFORMADO = "N\u00e3o Informado";
    private HashMap<String, String> ordem;
    private String[] filtroFiliais;
    private String[] filtroCidades;
    private String[] filtroBairro;
    private Object filtroEstados;
    private String[] filtroConvenios;
    private String[] filtroExames;
    private String[] filtroDestinos;
    private Object[] filtroMedico;
    private String[] filtroCrm;
    private String[] filtroConselho;
    private String[] filtroUf;
    private String[] filtroColeta;
    private String dataInicial;
    private String dataFinal;
    private Object filtroSexo;
    private Object filtroDiabetico;
    private Object filtroOrdem;

    public RelatorioPacienteExameRealizadoDAO() {
        this.carregarOrdem();
    }

    private void carregarOrdem() {
        this.ordem = new HashMap();
        this.ordem.put("C\u00f3digo", "pac.pac_codigo");
        this.ordem.put("Nome", "upper(pac.pac_nome)");
        this.ordem.put("Endere\u00e7o completo", "pac.pac_endereco");
        this.ordem.put("Cidade", "pac.cid_codigo");
        this.ordem.put("Estado", "cid.cid_uf");
        this.ordem.put("Telefone", "pac.pac_celular");
        this.ordem.put("E-mail", "pac.pac_email");
    }

    public List<Object> gerarDados(String tituloRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, this.montaSQL());
        ArrayList<Object> listDados = new ArrayList<Object>();
        while (rs.next()) {
            ResultSet result = Conexao.executeQuery(st2, this.montaSQLDados(rs.getString("codigoFilial"), rs.getString("codigoPaciente")));
            if (!result.next()) continue;
            RelatorioPacienteExameRealizadoVO dados = new RelatorioPacienteExameRealizadoVO();
            dados.getDadosPaciente().put("codigoFilial", result.getString("codigoFilial"));
            dados.getDadosPaciente().put("codigoPaciente", result.getString("codigoPaciente"));
            dados.getDadosPaciente().put("nomePaciente", result.getString("nomePaciente"));
            dados.getDadosPaciente().put("nomeSocialPaciente", result.getString("nomeSocialPaciente"));
            dados.getDadosPaciente().put("codigoRequisicao", result.getString("codigoRequisicao"));
            dados.getDadosPaciente().put("dataUtlimaRequisicao", Funcoes.formataData("dd/MM/yyyy", result.getDate("dataRequisicao")));
            dados.getDadosPaciente().put("tempoUltimaRequisicao", this.calculaTempoUltimaRequisicao(result.getString("tempoUltimaRequisicao")));
            dados.getDadosPaciente().put("telefonePaciente", result.getString("celularPaciente"));
            dados.getDadosPaciente().put("emailPaciente", result.getString("emailPaciente"));
            dados.getDadosPaciente().put("descricaoFilial", Variaveis.descricaoFilialPadrao);
            dados.getDadosPaciente().put("tituloRelatorio", tituloRelatorio);
            dados.getDadosPaciente().put("crmMedico", result.getString("crmMedico"));
            dados.getDadosPaciente().put("idadeRequisicao", result.getString("idadeRequisicao"));
            dados.getDadosPaciente().put("anomesIdadeRequisicao", Tipos.tipoIdade(result.getString("anomesIdadeRequisicao")));
            dados.getDadosPaciente().put("generoPaciente", result.getString("generoPaciente"));
            listDados.add(dados);
        }
        Conexao.fecharStatement(st);
        return listDados;
    }

    private StringBuilder montaSQLDados(String codigoFilial, String codigoPaciente) {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT req.req_data AS dataRequisicao, ");
        buf.append("        Age(req.req_data) AS tempoUltimaRequisicao, ");
        buf.append("        pac.fil_codigo     AS codigoFilial, ");
        buf.append("        pac.pac_codigo AS codigoPaciente, ");
        buf.append("        pac.pac_nome AS nomePaciente, ");
        buf.append("        req.req_codigo AS codigoRequisicao, ");
        buf.append("        pac.pac_nomesocial AS nomeSocialPaciente, ");
        buf.append("        pac.pac_celular AS celularPaciente, ");
        buf.append("        pac.pac_email AS emailPaciente, ");
        buf.append("        medico.med_crm  AS crmMedico, ");
        buf.append("        medico.med_nome   AS nomeMedico, ");
        buf.append("        req.req_idade      AS idadeRequisicao, ");
        buf.append("        req.req_anomes      AS anomesIdadeRequisicao, ");
        buf.append("\t\t\t\tidg.ige_descricao    AS generoPaciente ");
        buf.append(" FROM requisicao req ");
        buf.append(" LEFT JOIN paciente pac ");
        buf.append("       ON req.fil_codigo = pac.fil_codigo ");
        buf.append("      AND req.pac_codigo = pac.pac_codigo ");
        buf.append("        LEFT JOIN cidades cid ");
        buf.append("               ON pac.fil_codigo = cid.fil_codigo  ");
        buf.append("                  AND pac.cid_codigo = cid.cid_codigo  ");
        buf.append(" LEFT JOIN examerequisicao exr ");
        buf.append("       ON req.fil_codigo = exr.fil_codigo ");
        buf.append("      AND req.req_codigo = exr.req_codigo ");
        buf.append(" LEFT JOIN medico medico ");
        buf.append("      ON req.fil_codigo = medico.fil_codigo ");
        buf.append("      AND req.med_conselho = medico.med_conselho  ");
        buf.append("      And req.med_crm = medico.med_crm ");
        buf.append("      And req.med_uf = medico.med_uf ");
        buf.append(" LEFT JOIN coletas coleta ");
        buf.append("\t\t\tON req.fil_codigo = coleta.fil_codigo and req.col_codigo = coleta.col_codigo");
        buf.append("\t\t\tAND req.col_codigo = coleta.col_codigo");
        buf.append(" LEFT JOIN identidadegenero idg");
        buf.append(" \t\t\tON coalesce(pac.pac_genero, 0) = idg.ige_codigo ");
        buf.append(" WHERE pac.fil_codigo =  ").append(codigoFilial);
        buf.append(this.getValorFiltroCidade());
        buf.append(this.getValorFiltroBairro());
        buf.append(this.getValorFiltroEstado());
        buf.append(this.getValorFiltroConvenio());
        buf.append(this.getValorFiltroExame());
        buf.append(this.getValorFiltroDestino());
        buf.append(this.getValorFiltroDataInicial());
        buf.append(this.getValorFiltroDataFinal());
        buf.append(this.getValorFiltroSexo());
        buf.append(this.getValorFiltroDiabetico());
        buf.append(this.getValorFiltroMedico());
        buf.append(this.getValorFiltroColeta());
        buf.append("  AND pac.pac_codigo =  ").append(codigoPaciente);
        buf.append(" GROUP BY pac.pac_codigo, ");
        buf.append("   pac.fil_codigo, ");
        buf.append("\t pac.pac_nome, ");
        buf.append("\t pac.pac_nomesocial, ");
        buf.append("\t pac.pac_celular, ");
        buf.append("\t pac.pac_email, ");
        buf.append("   req.req_data, ");
        buf.append("\t req.req_codigo, ");
        buf.append("   medico.med_crm, ");
        buf.append("   medico.med_nome, ");
        buf.append("   req.req_idade, ");
        buf.append("   req.req_anomes, ");
        buf.append("   idg.ige_codigo ");
        buf.append("ORDER BY req.req_codigo desc limit 1 ");
        return buf;
    }

    private String calculaTempoUltimaRequisicao(String tempoUltimaRequisicao) {
        String tempo = tempoUltimaRequisicao.replaceAll("day", "dia").replaceAll("mons", "meses").replaceAll("mon", "m\u00eas").replaceAll("year", "ano");
        return tempo;
    }

    private boolean isRequisicaoRecente(String dataRequisicao, String periodo) {
        Date dtPeriodo;
        Date dataReq = Funcoes.stringToDate(dataRequisicao);
        if (dataReq.compareTo(dtPeriodo = Funcoes.stringToDate(periodo)) < 0 || dataReq.compareTo(dtPeriodo) == 0) {
            // empty if block
        }
        return true;
    }

    public String getModeloRealtorio() throws SQLException {
        String codigoRelatorio = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioPacienteExameRealizado.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            codigoRelatorio = rs.getString("rel_xml");
        }
        return codigoRelatorio;
    }

    private StringBuilder montaSQL() {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT  DISTINCT ");
        buf.append("        pac.fil_codigo     AS codigoFilial, ");
        buf.append("        pac.pac_codigo     AS codigoPaciente,  ");
        buf.append("        upper(pac.pac_nome)       AS nomePaciente, ");
        buf.append("        pac.pac_endereco   AS enderecoPaciente, ");
        buf.append("        pac.cid_codigo     AS cidadePaciente, ");
        buf.append("        cid.cid_uf         AS estadoPaciente, ");
        buf.append("        pac.pac_celular    AS celularPaciente, ");
        buf.append("        pac.pac_email      AS emailPaciente, ");
        buf.append("        ''     AS crmMedico, ");
        buf.append("        ''    AS nomeMedico ");
        buf.append(" FROM   requisicao req  ");
        buf.append("        LEFT JOIN examerequisicao exr  ");
        buf.append("               ON req.fil_codigo = exr.fil_codigo  ");
        buf.append("                  AND req.req_codigo = exr.req_codigo  ");
        buf.append("        LEFT JOIN destino des  ");
        buf.append("               ON req.fil_codigo = des.fil_codigo  ");
        buf.append("                  AND req.des_codigo = des.des_codigo  ");
        buf.append("        LEFT JOIN paciente pac  ");
        buf.append("               ON req.fil_codigo = pac.fil_codigo  ");
        buf.append("                  AND req.pac_codigo = pac.pac_codigo  ");
        buf.append("        LEFT JOIN medico medico   ");
        buf.append("               ON req.fil_codigo = medico.fil_codigo   ");
        buf.append("                  AND req.med_conselho = medico.med_conselho  ");
        buf.append("                  And req.med_crm = medico.med_crm  ");
        buf.append(" \t\t\t\t\t\t\t\t\tAnd req.med_uf = medico.med_uf");
        buf.append("        LEFT JOIN cidades cid ");
        buf.append("               ON pac.fil_codigo = cid.fil_codigo  ");
        buf.append("                  AND pac.cid_codigo = cid.cid_codigo  ");
        buf.append("        LEFT JOIN bairro bai  ");
        buf.append("               ON pac.fil_codigo = bai.fil_codigo  ");
        buf.append("                  AND pac.bai_codigo = bai.bai_codigo  ");
        buf.append("        LEFT JOIN convenios con  ");
        buf.append("               ON pac.fil_codigo = con.fil_codigo  ");
        buf.append("                  AND req.con_codigo = con.con_codigo  ");
        buf.append("\t\t\t\tLEFT JOIN coletas coleta ");
        buf.append("\t\t\t\t\t\t\tON req.fil_codigo = coleta.fil_codigo and req.col_codigo = coleta.col_codigo");
        buf.append("\t\t\t\t         AND req.col_codigo = coleta.col_codigo");
        buf.append("        LEFT JOIN filiais_postocoleta filial  ");
        buf.append("               ON pac.fil_codigo = filial.fil_codigo  ");
        buf.append(" where ");
        buf.append(this.getValorFiltroFilial());
        buf.append(this.getValorFiltroCidade());
        buf.append(this.getValorFiltroBairro());
        buf.append(this.getValorFiltroEstado());
        buf.append(this.getValorFiltroConvenio());
        buf.append(this.getValorFiltroExame());
        buf.append(this.getValorFiltroDestino());
        buf.append(this.getValorFiltroDataInicial());
        buf.append(this.getValorFiltroDataFinal());
        buf.append(this.getValorFiltroSexo());
        buf.append(this.getValorFiltroDiabetico());
        buf.append(this.getValorFiltroMedico());
        buf.append(this.getValorFiltroColeta());
        buf.append(this.getValorFiltroOrdem());
        return buf;
    }

    private String getValorFiltroOrdem() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroOrdem != null) {
            String o = this.ordem.get(this.filtroOrdem.toString());
            buf.append("  ORDER BY ").append(o);
        }
        return buf.toString();
    }

    private String getValorFiltroDiabetico() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroDiabetico != null) {
            if (this.filtroDiabetico.toString().equalsIgnoreCase(NAO_INFORMADO)) {
                buf.append("  and pac.pac_diabetico = '").append("I").append("'");
            } else if (this.filtroDiabetico.toString().equalsIgnoreCase(SIM)) {
                buf.append("  and pac.pac_diabetico = '").append("S").append("'");
            } else {
                buf.append("  and pac.pac_diabetico = '").append("N").append("'");
            }
        }
        return buf.toString();
    }

    private String getValorFiltroEstado() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroEstados != null && !this.filtroEstados.toString().equalsIgnoreCase(TODOS)) {
            buf.append("  and cid_uf = '").append(this.filtroEstados.toString()).append("'");
        }
        return buf.toString();
    }

    private String getValorFiltroSexo() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroSexo != null && !this.filtroSexo.toString().equalsIgnoreCase(TODOS)) {
            buf.append(" and pac.pac_sexo = '").append(this.filtroSexo.toString().substring(0, 1)).append("'");
        }
        return buf.toString();
    }

    private Object getValorFiltroDataFinal() {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(this.dataFinal)) {
            buf.append(" and '").append(Funcoes.formataData("yyyy/MM/dd", this.dataFinal)).append("'");
        }
        return buf.toString();
    }

    private String getValorFiltroDataInicial() {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(this.dataInicial)) {
            buf.append(" and req.req_data between '").append(Funcoes.formataData("yyyy/MM/dd", this.dataInicial)).append("'");
        }
        return buf.toString();
    }

    private Object getValorFiltroDestino() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroDestinos != null) {
            buf.append(" and req.des_codigo in (");
            for (int i = 0; i < this.filtroDestinos.length; ++i) {
                buf.append(StringUtil.textoDBEscape(this.filtroDestinos[i]));
                if (i >= this.filtroDestinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroExame() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroExames != null) {
            buf.append(" and exr.exa_codigo in (");
            for (int i = 0; i < this.filtroExames.length; ++i) {
                buf.append(StringUtil.textoDBEscape(this.filtroExames[i]));
                if (i >= this.filtroExames.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroConvenio() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroConvenios != null) {
            buf.append(" and req.con_codigo in (");
            for (int i = 0; i < this.filtroConvenios.length; ++i) {
                buf.append(this.filtroConvenios[i]);
                if (i >= this.filtroConvenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroBairro() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroBairro != null) {
            buf.append(" and pac.bai_codigo in (");
            for (int i = 0; i < this.filtroBairro.length; ++i) {
                buf.append(StringUtil.textoDBEscape(this.filtroBairro[i]));
                if (i >= this.filtroBairro.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroCidade() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroCidades != null) {
            buf.append(" and pac.cid_codigo in (");
            for (int i = 0; i < this.filtroCidades.length; ++i) {
                buf.append(this.filtroCidades[i]);
                if (i >= this.filtroCidades.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroFilial() {
        StringBuilder buf = new StringBuilder();
        if (this.filtroFiliais != null) {
            buf.append("   pac.fil_codigo in (");
            for (int i = 0; i < this.filtroFiliais.length; ++i) {
                buf.append(this.filtroFiliais[i]);
                if (i >= this.filtroFiliais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        } else {
            buf.append(" pac.fil_codigo = ").append(Variaveis.filialPadrao);
        }
        return buf.toString();
    }

    private String getValorFiltroMedico() {
        String[] conselho = this.getFiltroConselho();
        String[] crm = this.getFiltroCrm();
        String[] uf = this.getFiltroUf();
        StringBuilder buf = new StringBuilder();
        if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (int i = 0; i < crm.length; ++i) {
                buf.append("(req.med_conselho = '");
                buf.append(conselho[i]);
                buf.append("' and req.med_crm = '");
                buf.append(crm[i]);
                buf.append("' and req.med_uf = '");
                buf.append(uf[i]);
                buf.append("')");
                if (!this.adicionaMaisMedico(crm, i)) continue;
                buf.append(" or ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    private String getValorFiltroColeta() {
        StringBuilder buf = new StringBuilder();
        if (this.existeColeta()) {
            buf.append(" and req.col_codigo in (");
            for (int i = 0; i < this.filtroColeta.length; ++i) {
                buf.append(StringUtil.textoDBEscape(this.filtroColeta[i]));
                if (!this.adicionaMaisColeta(i)) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private boolean adicionaMaisMedico(String[] crm, int i) {
        return i < crm.length - 1;
    }

    private boolean adicionaMaisColeta(int i) {
        return i < this.filtroColeta.length - 1;
    }

    private boolean existeColeta() {
        return this.filtroColeta != null;
    }

    public String[] getFiltroFiliais() {
        return this.filtroFiliais;
    }

    public void setFiltroFiliais(String[] filtroFiliais) {
        this.filtroFiliais = filtroFiliais;
    }

    public String[] getFiltroCidades() {
        return this.filtroCidades;
    }

    public void setFiltroCidades(String[] filtroCidades) {
        this.filtroCidades = filtroCidades;
    }

    public String[] getFiltroBairro() {
        return this.filtroBairro;
    }

    public void setFiltroBairro(String[] filtroBairro) {
        this.filtroBairro = filtroBairro;
    }

    public Object getFiltroEstados() {
        return this.filtroEstados;
    }

    public void setFiltroEstados(Object filtroEstados2) {
        this.filtroEstados = filtroEstados2;
    }

    public String[] getFiltroConvenios() {
        return this.filtroConvenios;
    }

    public void setFiltroConvenios(String[] filtroConvenios) {
        this.filtroConvenios = filtroConvenios;
    }

    public String[] getFiltroExames() {
        return this.filtroExames;
    }

    public void setFiltroExames(String[] filtroExames) {
        this.filtroExames = filtroExames;
    }

    public String[] getFiltroDestinos() {
        return this.filtroDestinos;
    }

    public void setFiltroDestinos(String[] filtroDestinos) {
        this.filtroDestinos = filtroDestinos;
    }

    public String getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(String dataInicial) {
        this.dataInicial = dataInicial;
    }

    public String getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(String dataFinal) {
        this.dataFinal = dataFinal;
    }

    public Object getFiltroSexo() {
        return this.filtroSexo;
    }

    public void setFiltroSexo(Object filtroSexo) {
        this.filtroSexo = filtroSexo;
    }

    public Object getFiltroDiabetico() {
        return this.filtroDiabetico;
    }

    public void setFiltroDiabetico(Object filtroDiabetico) {
        this.filtroDiabetico = filtroDiabetico;
    }

    public Object getFiltroOrdem() {
        return this.filtroOrdem;
    }

    public void setFiltroOrdem(Object filtroOrdem) {
        this.filtroOrdem = filtroOrdem;
    }

    public Object[] getFiltroMedico() {
        return this.filtroMedico;
    }

    public void setFiltroMedico(Object[] filtroMedico) {
        this.filtroMedico = filtroMedico;
    }

    public String[] getFiltroCrm() {
        return this.filtroCrm;
    }

    public void setFiltroCrm(String[] filtroCrm) {
        this.filtroCrm = filtroCrm;
    }

    public String[] getFiltroConselho() {
        return this.filtroConselho;
    }

    public void setFiltroConselho(String[] filtroConselho) {
        this.filtroConselho = filtroConselho;
    }

    public String[] getFiltroUf() {
        return this.filtroUf;
    }

    public void setFiltroUf(String[] filtroUf) {
        this.filtroUf = filtroUf;
    }

    public String[] getFiltroColeta() {
        return this.filtroColeta;
    }

    public void setFiltroColeta(String[] filtroColeta) {
        this.filtroColeta = filtroColeta;
    }
}

