/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao.relatorioPacienteExameRealizado;

import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.recepcao.relatorioPacienteExameRealizado.RelatorioPacienteExameRealizadoService;
import jalis.laboratorio.relatorios.recepcao.relatorioPacienteExameRealizado.RelatorioPacienteExameRealizadoVO;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioPacienteExameRealizado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] estados = ArraysUtil.concatenar(new String[]{"Todos"}, ConstantesGerais.ESTADOS);
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_BAIRRO = "filtroBairro";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_DATA_INICIAL = "filtroDataCadastroInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataCadastroFinal";
    private final String FILTRO_SEXO = "filtroSexo";
    private final String FILTRO_DIABETICO = "filtroDiabetico";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private String tituloRelatorio = "";
    private RelatorioPacienteExameRealizadoService service = new RelatorioPacienteExameRealizadoService();

    public RelatorioPacienteExameRealizado() {
        this.setName("RelatorioPacienteExameRealizado");
        this.montaBarraDescricao(this.getTitulo(), this.getDescricao(), this.getImagem());
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroBairro", "Bairro", "bairro", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio ", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_razao"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame ", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{30, 70, 30, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataCadastroInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataCadastroFinal", "Data Final:");
        this.adicionaFiltroCombo("filtroEstado", "Estado:", this.estados, 0);
        this.adicionaFiltroCombo("filtroSexo", "Sexo:", this.service.getSexo(), 2);
        this.adicionaFiltroCombo("filtroDiabetico", "Diab\u00e9tico:", this.service.getDiabetico(), 2);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.service.getOrdem(), 0);
        this.setModuloAcesso(RelatorioPacienteExameRealizado.getModuloAcesso());
        this.setCamposConfigurador(this.service.getCampos());
    }

    private String getImagem() {
        String descricao = "";
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
            descricao = "relatorios/rel_ultimo_paciente.jpg";
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            descricao = "relatorios/rel_ultimo_empresa.jpg";
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            descricao = "relatorios/rel_ultimo_animal.jpg";
        }
        return descricao;
    }

    private String getDescricao() {
        String descricao = "";
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
            descricao = "\u00daltimo Atendimento por Paciente";
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            descricao = "\u00daltimo Atendimento por Empresa";
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            descricao = "\u00daltimo Atendimento por Animal";
        }
        return descricao;
    }

    private String getTitulo() {
        String titulo = "";
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
            this.tituloRelatorio = titulo = "\u00daltimo Atendimento por Paciente";
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.tituloRelatorio = titulo = "\u00daltimo Atendimento por Empresa";
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.tituloRelatorio = titulo = "\u00daltimo Atendimento por Animal";
        }
        return titulo;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0825000100");
    }

    @Override
    public void imprimirPressionado() {
        if (this.isDataValida()) {
            ModeloGridTable modelo = new ModeloGridTable(this.service.getCampos());
            this.service.setFiltroFiliais(this.getSelecionadosFiltro("filtroFilial", 0));
            this.service.setFiltroCidades(this.getSelecionadosFiltro("filtroCidade", 0));
            this.service.setFiltroBairro(this.getSelecionadosFiltro("filtroBairro", 0));
            this.service.setFiltroEstados(this.getFiltroCombo("filtroEstado"));
            this.service.setFiltroConvenios(this.getSelecionadosFiltro("filtroConvenio", 0));
            this.service.setFiltroExames(this.getSelecionadosFiltro("filtroExame", 0));
            this.service.setFiltroDestinos(this.getSelecionadosFiltro("filtroDestino", 0));
            this.service.setDataInicial(this.getFiltroData("filtroDataCadastroInicial"));
            this.service.setDataFinal(this.getFiltroData("filtroDataCadastroFinal"));
            this.service.setFiltroSexo(this.getFiltroCombo("filtroSexo"));
            this.service.setFiltroDiabetico(this.getFiltroCombo("filtroDiabetico"));
            this.service.setFiltroMedico(this.getSelecionadosFiltroAvancado("filtroMedico"));
            this.service.setConselho(this.getSelecionadosFiltroAvancado("filtroMedico", 0));
            this.service.setCrm(this.getSelecionadosFiltroAvancado("filtroMedico", 1));
            this.service.setUf(this.getSelecionadosFiltroAvancado("filtroMedico", 2));
            this.service.setFiltroColeta(this.getSelecionadosFiltro("filtroColeta", 0));
            this.service.setFiltroOrdem(this.getFiltroCombo("ordemRelatorio"));
            try {
                List<Object> listDados = this.service.gerarRelatorio(this.tituloRelatorio);
                if (listDados != null && !listDados.isEmpty()) {
                    Iterator<Object> it = listDados.iterator();
                    boolean contador = true;
                    while (it.hasNext()) {
                        RelatorioPacienteExameRealizadoVO relatorioVO = (RelatorioPacienteExameRealizadoVO)it.next();
                        Object[] o = new Object[this.service.getCampos().length];
                        for (int i = 0; i < this.service.getCampos().length && relatorioVO.getDadosPaciente() != null; ++i) {
                            o[i] = relatorioVO.getDadosPaciente().get(this.service.getCampos()[i]);
                        }
                        modelo.addLine(o);
                    }
                    if (Funcoes.textoVazio(this.service.getModeloRelatorio())) {
                        this.habilitaBotaoImprimir(true);
                        return;
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioPacienteExameRealizado.this.panelCentro.removeAll();
                        RelatorioPacienteExameRealizado.this.panelCentro.repaint();
                        RelatorioPacienteExameRealizado.this.habilitaBotaoImprimir(true);
                    }
                });
                Map<String, Object> varFiltro = this.montaDadosCabecalho();
                gerador.executar(this.service.getModeloRelatorio(), (TableModel)modelo, varFiltro);
                this.panelCentro.revalidate();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do relat\u00f3rio." + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private Map<String, Object> montaDadosCabecalho() {
        int i;
        HashMap<String, Object> varFiltro = new HashMap<String, Object>();
        StringBuilder buf = new StringBuilder();
        if (this.service.getFiltroFiliais() != null) {
            for (i = 0; i < this.service.getFiltroFiliais().length; ++i) {
                buf.append(this.service.getFiltroFiliais()[i]);
                if (i >= this.service.getFiltroFiliais().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroFilial", buf.toString());
        } else {
            varFiltro.put("filtroFilial", Variaveis.filialPadrao);
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroCidades() != null) {
            for (i = 0; i < this.service.getFiltroCidades().length; ++i) {
                buf.append(this.service.getFiltroCidades()[i]);
                if (i >= this.service.getFiltroCidades().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroCidade", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroBairro() != null) {
            for (i = 0; i < this.service.getFiltroBairro().length; ++i) {
                buf.append(this.service.getFiltroBairro()[i]);
                if (i >= this.service.getFiltroBairro().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroBairro", buf.toString());
        }
        if (this.service.getFiltroEstados() != null) {
            varFiltro.put("filtroEstado", this.getFiltroCombo("filtroEstado"));
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroConvenios() != null) {
            for (i = 0; i < this.service.getFiltroConvenios().length; ++i) {
                buf.append(this.service.getFiltroConvenios()[i]);
                if (i >= this.service.getFiltroConvenios().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroConvenio", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroExames() != null) {
            for (i = 0; i < this.service.getFiltroExames().length; ++i) {
                buf.append(this.service.getFiltroExames()[i]);
                if (i >= this.service.getFiltroExames().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroExame", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.existeDestinos()) {
            for (i = 0; i < this.service.getFiltroDestinos().length; ++i) {
                buf.append(this.service.getFiltroDestinos()[i]);
                if (!this.adicionaMaisDestino(i)) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroDestino", buf.toString());
        }
        if (this.service.getDataInicial() != null) {
            varFiltro.put("filtroDataCadastroInicial", this.getFiltroData("filtroDataCadastroInicial"));
        }
        if (this.service.getDataFinal() != null) {
            varFiltro.put("filtroDataCadastroFinal", this.getFiltroData("filtroDataCadastroFinal"));
        }
        if (this.service.getFiltroSexo() != null) {
            varFiltro.put("filtroSexo", this.getFiltroCombo("filtroSexo"));
        }
        if (this.service.getFiltroDiabetico() != null) {
            varFiltro.put("filtroDiabetico", this.getFiltroCombo("filtroDiabetico"));
        }
        if (this.service.getFiltroOrdem() != null) {
            varFiltro.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
        }
        return varFiltro;
    }

    private boolean adicionaMaisDestino(int i) {
        return i < this.service.getFiltroDestinos().length - 1;
    }

    private boolean existeDestinos() {
        return this.service.getFiltroDestinos() != null;
    }

    private boolean isDataValida() {
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroInicial")) || !Funcoes.verificaData(this.getFiltroData("filtroDataCadastroInicial"))) {
            Funcoes.mensagem(this, "Data de cadastro inicial inv\u00e1lida", 1);
            this.habilitaBotaoImprimir(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroFinal")) || !Funcoes.verificaData(this.getFiltroData("filtroDataCadastroFinal"))) {
            Funcoes.mensagem(this, "Data de cadastro final inv\u00e1lida", 1);
            this.habilitaBotaoImprimir(true);
            return false;
        }
        return true;
    }
}

