/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioSemPedido
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Paciente", "Conv\u00eanio", "M\u00e9dico", "Usu\u00e1rio"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "situacaoExameRequisicao", "entregueParaExameRequisicao", "dataAssinaturaExameRequisicao", "dataDigitacaoExameRequisicao", "dataColetaExameRequisicao", "dataEntregueExameRequisicao", "dataImpressaoExameRequisicao", "dataFaturaExameRequisicao", "valorTotalExameRequisicao", "avisarPacienteExameRequisicao", "valorFaturarExameRequisicao", "valorExameExameRequisicao", "valorCHExameExameRequisicao", "materialExternoExameRequisicao", "dataEntregaExameRequisicao", "interfaceadoExameRequisicao", "loteReagenteExameRequisicao", "tipoUltimoPagamentoRequisicao", "observacaoPrazoCarenciaExameRequisicao", "quantidadeReagenteExameRequisicao", "valorCHExameRequisicao", "valorMaterialExameRequisicao", "valorPagoBalcaoExameRequisicao", "dataImpressaoMapaExameRequisicao", "codigoAutorizacaoExameRequisicao", "dataInsercaoExameRequisicao", "observacaoExameRequisicao", "dataCortesiaExameRequisicao", "serialReagenteExameRequisicao", "autorizarExameRequisicao", "tempoJejumExameRequisicao", "descricaoMaterialInformadoExameRequisicao", "urgenteExameRequisicao", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoPaciente", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairrodestino", "descricaoBairrodestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoSetor", "descricaoSetor", "responsavelSetor", "siglaSetor", "corSetor", "codigoUsuarioSetor", "nomeUsuarioSetor", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "percentualAcrescimoConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoPrioridade", "descricaoPrioridade", "codigoTabela", "descricaoTabela", "valorCHTabela", "moedaTabela", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoUsuarioAssina", "nomeUsuarioAssina", "codigoUsuarioDigitador", "nomeUsuarioDigitador", "codigoUsuarioMaterial", "nomeUsuarioMaterial", "codigoUsuarioFatura", "nomeUsuarioFatura", "codigoUsuarioEntrega", "nomeUsuarioEntrega", "codigoUsuarioImpressao", "nomeUsuarioImpressao", "codigoUsuarioExame", "nomeUsuarioExame", "codigoUsuarioMapa", "nomeUsuarioMapa", "codigoUsuarioCortesia", "nomeUsuarioCortesia", "codigoExame", "descricaoExame", "sexoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "padraoExame", "ordemExame", "paginaExame", "codigoCBHPMExame", "codigoAMBExame", "solicitarJejumExame", "solicitarTempoDiureseExame", "solicitarMedicamentoExame", "marcarExternoExame", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "codigoPrazoEntrega", "descricaoPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "rotinaPrazoEntrega", "codigoMetodologia", "descricaoMetodologia", "solicitarDUMExame", "codigoEstacao", "descricaoEstacao", "valorCHExameExameRequisicaoOriginal", "valorCHExameRequisicaoOriginal", "numeroEnderecoPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoMedico", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroMedico", "totalTaxaRequisicao", "nomeSocialPaciente", "generoPaciente", "procedenciaRequisicao"});

    public RelatorioSemPedido() {
        this.setName("RelatorioSemPedido");
        this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es sem pedido/guia", "Listagem das requisi\u00e7\u00f5es sem pedido m\u00e9dico ou guia", "relatorios/rel_req_sem_guia.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioSemPedido.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] convenio;
            String[] coleta;
            String[] destino;
            if (this.getFiltroCheck(FILTRO_INTERVALO_HORA) && (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) || Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraFinal")))) {
                Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos!", 2);
                return;
            }
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_procedencia as procedenciaRequisicao, ");
            buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
            buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
            buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao,  a.req_totaltaxa as totalTaxaRequisicao,");
            buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, ");
            buf.append("a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
            buf.append("a.req_matricula as matriculaRequisicao, a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
            buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao,  ");
            buf.append("a.req_titular as titularRequisicao, a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao,  ");
            buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
            buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
            buf.append("a.req_telacoleta as coletadoRequisicao, a.req_datarequisicao as dataAberturaRequisicao, ");
            buf.append("a.req_neonato as neonatoRequisicao, a.req_validadeguia as validadeGuiaRequisicao,  ");
            buf.append("a.req_guia as guiaRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
            buf.append("b.exr_situacao as situacaoExameRequisicao, b.exr_entrpara as entregueParaExameRequisicao,  ");
            buf.append("b.exr_dataassina as dataAssinaturaExameRequisicao, b.exr_datadigita as dataDigitacaoExameRequisicao, ");
            buf.append("b.exr_datamaterial as dataColetaExameRequisicao, b.exr_dataentreguerst as dataEntregueExameRequisicao, ");
            buf.append("b.exr_dataimpresso as dataImpressaoExameRequisicao, b.exr_datafatura as dataFaturaExameRequisicao, ");
            buf.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorTotalExameRequisicao, ");
            buf.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, false, true, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorFaturarExameRequisicao, ");
            buf.append("b.exr_vlrexame as valorExameExameRequisicao, ");
            buf.append("b.exr_vlrchexame as valorCHExameExameRequisicaoOriginal, ");
            buf.append("calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameExameRequisicao, ");
            buf.append("b.exr_matexterno as materialExternoExameRequisicao, b.exr_dataentregaprev as dataEntregaExameRequisicao, ");
            buf.append("b.exr_interfaciado as interfaceadoExameRequisicao, b.exr_lotereag as loteReagenteExameRequisicao,  ");
            buf.append("b.exr_quantreag as quantidadeReagenteExameRequisicao, ");
            buf.append("b.exr_vlrch as valorCHExameRequisicaoOriginal, ");
            buf.append("calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameRequisicao, ");
            buf.append("b.exr_vlrmaterial as valorMaterialExameRequisicao, b.exr_vlrbalcaoconvenio as valorPagoBalcaoExameRequisicao, ");
            buf.append("b.exr_datamapa as dataImpressaoMapaExameRequisicao, b.exr_codautorizacao as codigoAutorizacaoExameRequisicao, ");
            buf.append("b.exr_data as dataInsercaoExameRequisicao, b.exr_obs as observacaoExameRequisicao, ");
            buf.append("b.exr_datacortesia as dataCortesiaExameRequisicao, b.exr_serialreag as serialReagenteExameRequisicao, ");
            buf.append("b.exr_autorizar as autorizarExameRequisicao,");
            buf.append("CASE WHEN b.exr_intervalojejum IS NULL THEN TO_CHAR(b.exr_tempojejum, 'HH24:MI') ELSE TO_CHAR(b.exr_intervalojejum, 'HH24:MI') END AS tempoJejumExameRequisicao, ");
            buf.append("b.exr_descricaomaterial as descricaoMaterialInformadoExameRequisicao, ");
            buf.append("b.exr_motivoprazo as observacaoPrazoCarenciaExameRequisicao,");
            buf.append(" COALESCE(b.exr_avisarentrega, false) as avisarPacienteExameRequisicao, ");
            buf.append("coalesce(b.exr_urgente, false) as urgenteExameRequisicao, ");
            buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, ");
            buf.append("ala.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
            buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, ");
            buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
            buf.append("paciente.pac_vip as vipPaciente, paciente.pac_grpsangue as grupoSanguineoPaciente, ");
            buf.append("paciente.pac_fatorrh as fatorrhPaciente, paciente.pac_fatordu as fatorduPaciente, ");
            buf.append("paciente.pac_cor as corPaciente, paciente.pac_observ as observacaoPaciente, ");
            buf.append("paciente.pac_dadoclinico as dadosClinicosPaciente, paciente.pac_peso as pesoPaciente, ");
            buf.append("paciente.pac_altura as alturaPaciente, paciente.pac_matricconv as matriculaConvenioPaciente, ");
            buf.append("paciente.pac_titularconv as titularConvenioPaciente, paciente.pac_profissao as profissaoPaciente, ");
            buf.append("paciente.pac_fumante as fumantePaciente, paciente.pac_diabetico as diabeticoPaciente, ");
            buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
            buf.append("paciente.pac_estcivil as estadoCivilPaciente, paciente.pac_numfilho as numeroFilhosPaciente, ");
            buf.append("paciente.pac_datahora as dataHoraCadastroPaciente, paciente.pac_dum as dumPaciente, ");
            buf.append("paciente.pac_fax as faxPaciente, paciente.pac_celular as celularPaciente, ");
            buf.append("paciente.pac_fonecomercial as foneComercialPaciente, paciente.pac_fone as fonePaciente, ");
            buf.append("paciente.pac_cep as cepPaciente, paciente.pac_complemento as complementoPaciente, ");
            buf.append("paciente.pac_endereco as enderecoPaciente, paciente.pac_numeroendereco as numeroEnderecoPaciente, paciente.pac_email as emailPaciente, ");
            buf.append("paciente.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
            buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
            buf.append("paciente.pac_fonecontato as foneContatoPaciente, paciente.pac_nomecontato as contatoPaciente, ");
            buf.append("paciente.pac_mae as maePaciente, paciente.pac_pai as paiPaciente, paciente.pac_nomesocial as nomeSocialPaciente, ");
            buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
            buf.append("cidpaciente.cid_uf as estadoCidadePaciente, ");
            buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
            buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
            buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
            buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino,  ");
            buf.append("destino.des_impressora as impressoraDestino, destino.des_naoimprimir as naoImprimirDestino,  ");
            buf.append("destino.des_cep as cepDestino, destino.des_complemento as complementoDestino, ");
            buf.append("destino.des_endereco as enderecoDestino, destino.des_fone as foneDestino, ");
            buf.append("destino.des_enviarweb as enviarWebDestino,  ");
            buf.append("ciddestino.cid_codigo as codigoCidadeDestino, ciddestino.cid_nome as descricaoCidadeDestino, ");
            buf.append("ciddestino.cid_uf as estadoCidadeDestino, ");
            buf.append("baidestino.bai_codigo as codigoBairroDestino, baidestino.bai_descricao as descricaoBairroDestino, ");
            buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
            buf.append("coleta.col_cep as cepColeta, coleta.col_complemento as complementoColeta, ");
            buf.append("coleta.col_endereco as enderecoColeta, coleta.col_fone as foneColeta, ");
            buf.append("cidcoleta.cid_codigo as codigoCidadeColeta, cidcoleta.cid_nome as descricaoCidadeColeta, ");
            buf.append("cidcoleta.cid_uf as estadoCidadeColeta, ");
            buf.append("baicoleta.bai_codigo as codigoBairroColeta, baicoleta.bai_descricao as descricaoBairroColeta, ");
            buf.append("setor.set_codigo as codigoSetor, setor.set_descricao as descricaoSetor, ");
            buf.append("setor.set_responsavel as responsavelSetor, setor.set_sigla as siglaSetor, ");
            buf.append("setor.set_cor as corSetor,  ");
            buf.append("usrsetor.usr_codigo as codigoUsuarioSetor, usrsetor.usr_nome as nomeUsuarioSetor, ");
            buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
            buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
            buf.append("convenio.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("convenio.con_fatfmaterial as faturarFaltaMaterialConvenio, convenio.con_descexame as habilitarDescontoConvenio,  ");
            buf.append("convenio.con_multa as multaConvenio,  ");
            buf.append("convenio.con_mora as moraConvenio, convenio.con_fatfiliais as faturarFiliaisConvenio, ");
            buf.append("convenio.con_nr1via as quantidade1ViaConvenio, convenio.con_nrexames as numeroExamesConvenio,  ");
            buf.append("convenio.con_viasfatura as viasFaturaConvenio, convenio.con_impbloqueto as imprimirBloquetoConvenio,  ");
            buf.append("convenio.con_nr2via as quantidade2ViaConvenio, convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio,  ");
            buf.append("convenio.con_percpgto as percentualBalcaoConvenio, convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
            buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, convenio.con_titdep as titularDependenteConvenio, ");
            buf.append("convenio.con_maskcart as mascaraCarteiraConvenio, convenio.con_contato as contatoConvenio, ");
            buf.append("convenio.con_informarmat as obrigaMatriculaConvenio, convenio.con_cep as cepConvenio,  ");
            buf.append("convenio.con_complemento as complementoConvenio, convenio.con_endereco as enderecoConvenio,  ");
            buf.append("convenio.con_cepcobranca as cepCobrancaConvenio, convenio.con_complcobranca as complementoCobrancaConvenio,  ");
            buf.append("convenio.con_endcobranca as enderecoCobrancaConvenio, convenio.con_fax as faxConvenio, ");
            buf.append("convenio.con_numeroendereco as numeroEnderecoConvenio, convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
            buf.append("convenio.con_tipologradouroendereco as tipoLogradouroConvenio, convenio.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("convenio.con_fone as foneConvenio, convenio.con_valorfilme as valorFilmeConvenio,  ");
            buf.append("convenio.con_valorch as valorCHConvenio, convenio.con_site as siteConvenio, ");
            buf.append("convenio.con_email2 as email2Convenio, convenio.con_email1 as email1Convenio,  ");
            buf.append("convenio.con_tpcalcch as tipoCalculoCHConvenio, convenio.con_inscmunic as inscricaoMunicipalConvenio,  ");
            buf.append("convenio.con_bonus as percentualBonusConvenio, convenio.con_senhaweb as senhaWebConvenio,  ");
            buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
            buf.append("convenio.con_proibidoweb as proibidoWebConvenio, convenio.con_validadeguia as obrigaValidadeGuiaConvenio,  ");
            buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, convenio.con_diasvalidade as diasValidadeGuia,  ");
            buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("prioridade.pri_codigo as codigoPrioridade, prioridade.pri_descricao as descricaoPrioridade, ");
            buf.append("tabela.tpe_codigo as codigoTabela, tabela.tpe_descricao as descricaoTabela,  ");
            buf.append("tabela.tpe_valorch as valorCHTabela, tabela.tpe_moeda as moedaTabela, ");
            buf.append("cidconvenio.cid_codigo as codigoCidadeConvenio, cidconvenio.cid_nome as descricaoCidadeConvenio,  ");
            buf.append("cidconvenio.cid_uf as estadoCidadeConvenio, ");
            buf.append("baiconvenio.bai_codigo as codigoBairroConvenio, baiconvenio.bai_descricao as descricaoBairroConvenio, ");
            buf.append("layout.lay_codigo as codigoModelo, layout.lay_descricao as descricaoModelo, ");
            buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
            buf.append("medico.med_abrev as abreviaturaMedico, ");
            buf.append("medico.med_tipo as tipoMedico, ");
            buf.append("medico.med_comissao as comissaoMedico, medico.med_cep as cepMedico, medico.med_complemento as complementoMedico,  ");
            buf.append("medico.med_endereco as enderecoMedico, medico.med_celular as celularMedico, medico.med_fax as faxMedico,  ");
            buf.append("medico.med_numeroendereco as numeroEnderecoMedico, medico.med_tipologradouroendereco as tipoLogradouroMedico, ");
            buf.append("medico.med_fone as foneMedico, medico.med_email as emailMedico, medico.med_site as siteMedico, medico.med_senhaweb as senhaWebMedico, ");
            buf.append("cidmedico.cid_codigo as codigoCidadeMedico, cidmedico.cid_nome as descricaoCidadeMedico, cidmedico.cid_uf as estadoCidadeMedico,  ");
            buf.append("baimedico.bai_codigo as codigoBairroMedico, baimedico.bai_descricao as descricaoBairroMedico, ");
            buf.append("usrassina.usr_codigo as codigoUsuarioAssina, usrassina.usr_nome as nomeUsuarioAssina, ");
            buf.append("usrdigitador.usr_codigo as codigoUsuarioDigitador, usrdigitador.usr_nome as nomeUsuarioDigitador, ");
            buf.append("usrmaterial.usr_codigo as codigoUsuarioMaterial, usrmaterial.usr_nome as nomeUsuarioMaterial, ");
            buf.append("usrfatura.usr_codigo as codigoUsuarioFatura, usrFatura.usr_nome as nomeUsuarioFatura, ");
            buf.append("usrentrega.usr_codigo as codigoUsuarioEntrega, usrentrega.usr_nome as nomeUsuarioEntrega, ");
            buf.append("usrimpressao.usr_codigo as codigoUsuarioImpressao, usrimpressao.usr_nome as nomeUsuarioImpressao, ");
            buf.append("usrexame.usr_codigo as codigoUsuarioExame, usrexame.usr_nome as nomeUsuarioExame, ");
            buf.append("usrmapa.usr_codigo as codigoUsuarioMapa, usrmapa.usr_nome as nomeUsuarioMapa, ");
            buf.append("usrcortesia.usr_codigo as codigoUsuarioCortesia, usrcortesia.usr_nome as nomeUsuarioCortesia, ");
            buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame, c.exa_sexo as sexoExame,  ");
            buf.append("c.exa_horaentrada as horaEntradaExame, c.exa_horasaida as horaSaidaExame, ");
            buf.append("c.exa_filtro as filtroExame, c.exa_proibido as proibidoExame, ");
            buf.append("c.exa_idademax as idadeMaximaExame, c.exa_idademin as idadeMinimaExame, ");
            buf.append("c.exa_idademaxtipo as tipoIdadeMaximaExame, c.exa_idademintipo as tipoIdadeMinimaExame, ");
            buf.append("c.exa_proibidoweb as proibidoWebExame, c.exa_qtdeamostras as quantidadeAmostrasExame, ");
            buf.append("d.emc_default as padraoExame, d.emc_ordem as ordemExame,  ");
            buf.append("d.emc_pagina as paginaExame, d.emc_codigocbhpm as codigoCBHPMExame, ");
            buf.append("d.emc_codigoamb as codigoAMBExame, d.emc_solicitarjejum as solicitarJejumExame, ");
            buf.append("d.emc_obrigamedicamento as solicitarMedicamentoExame,  ");
            buf.append("d.emc_obrigadum as solicitarDUMExame,  ");
            buf.append("d.emc_obrigapeso as solicitarPesoExame, ");
            buf.append("d.emc_obrigaaltura as solicitarAlturaExame, ");
            buf.append("d.emc_obrigavolume as solicitarVolumeExame, ");
            buf.append("d.emc_obrigatempodiurese as solicitarTempoDiureseExame, ");
            buf.append("d.emc_marcarexterno as marcarExternoExame, ");
            buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
            buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, ");
            buf.append("prazo.prz_codigo as codigoPrazoEntrega, prazo.prz_descricao as descricaoPrazoEntrega, ");
            buf.append("prazo.prz_dias as diasPrazoEntrega, prazo.prz_horaentrada as horaEntradaPrazoEntrega, ");
            buf.append("prazo.prz_horasaida as horaSaidaPrazoEntrega, prazo.prz_prazo as rotinaPrazoEntrega, ");
            buf.append("metodologia.met_codigo as codigoMetodologia, metodologia.met_descricao as descricaoMetodologia, ");
            buf.append("a.est_codigo as codigoEstacao, estacoes.est_descricao as descricaoEstacao, idg.ige_descricao as generoPaciente, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from requisicao a ");
            buf.append("join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
            buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
            buf.append("left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
            buf.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
            buf.append("join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
            buf.append("join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
            buf.append("join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
            buf.append("left join usuario usrassina on b.usr_codassina = usrassina.usr_codigo ");
            buf.append("left join usuario usrdigitador on b.usr_coddigitador = usrdigitador.usr_codigo ");
            buf.append("left join usuario usrmaterial on b.usr_codmaterial = usrmaterial.usr_codigo ");
            buf.append("left join usuario usrfatura on b.usr_codfatura = usrfatura.usr_codigo ");
            buf.append("left join usuario usrentrega on b.usr_codentrega = usrentrega.usr_codigo ");
            buf.append("left join usuario usrimpressao on b.usr_codimpressao = usrimpressao.usr_codigo ");
            buf.append("left join usuario usrexame on b.usr_codigo = usrexame.usr_codigo ");
            buf.append("left join usuario usrmapa on b.usr_codigo = usrmapa.usr_codigo ");
            buf.append("left join usuario usrcortesia on b.usr_codcortesia = usrcortesia.usr_codigo ");
            buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
            buf.append("left join usuario usrsetor on setor.usr_codigo = usrsetor.usr_codigo ");
            buf.append("join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
            buf.append("join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
            buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
            buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
            buf.append("left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
            buf.append("left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
            buf.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
            buf.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
            buf.append("left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
            buf.append("left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
            buf.append("left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
            buf.append("left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
            buf.append("left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
            buf.append("left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
            buf.append("left join layout on convenio.fil_codigo = layout.fil_codigo and convenio.lay_codigo = layout.lay_codigo ");
            buf.append("left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
            buf.append("left join tabelaprecoexames tabela on convenio.fil_codigo = tabela.fil_codigo and convenio.tpe_codigo = tabela.tpe_codigo ");
            buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
            buf.append("left join prazoentrega prazo on d.fil_codigo = prazo.fil_codigo and d.prz_codigo = prazo.prz_codigo ");
            buf.append("left join metodologia on d.fil_codigo = metodologia.fil_codigo and d.met_codigo = metodologia.met_codigo ");
            buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
            if (usuario != null) {
                buf.append(" and a.usr_codabertura in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((destino = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and a.des_codigo in (");
                for (int i = 0; i < destino.length; ++i) {
                    buf.append("'");
                    buf.append(destino[i]);
                    buf.append("'");
                    if (i >= destino.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coleta = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coleta.length; ++i) {
                    buf.append("'");
                    buf.append(coleta[i]);
                    buf.append("'");
                    if (i >= coleta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and a.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(a.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and a.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and a.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            if (!this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and a.req_data >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and a.req_data <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and a.req_hora >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and a.req_hora <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                buf.append(" and (a.req_data >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("' and a.req_hora >= '");
                buf.append(this.getFiltroHora("filtroHoraInicial"));
                buf.append("') and (a.req_data <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("' and a.req_hora <= '");
                buf.append(this.getFiltroHora("filtroHoraFinal"));
                buf.append("')");
            }
            buf.append(" and a.req_deveguia = true ");
            buf.append(" and a.req_excluida = false and b.exr_excluido = false ");
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.req_data, a.req_hora, a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("upper(paciente.pac_nome), a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("upper(convenio.con_fantasia), a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append("upper(medico.med_nome), a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                buf.append("a.usr_codigo, a.req_codigo");
            } else {
                buf.append("a.req_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroMedico") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : (campos[i].equals("tipoMedico") ? Tipos.tipoMedico(rs.getString("tipoMedico")) : (campos[i].equals("anomesIdadeRequisicao") || campos[i].equals("anomesIdadePaciente") || campos[i].equals("tipoIdadeMinimaExame") || campos[i].equals("tipoIdadeMaximaExame") ? Tipos.tipoIdade(rs.getString(campos[i])) : (campos[i].equals("sexoPaciente") || campos[i].equals("sexoExame") ? Tipos.tipoSexo(rs.getString(campos[i])) : (campos[i].equals("situacaoExameRequisicao") ? Tipos.tipoSituacaoExame(rs.getString(campos[i])) : (campos[i].equals("corPaciente") ? Tipos.tipoCor(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("fumantePaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente")) : (campos[i].equalsIgnoreCase("diabeticoPaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente")) : (campos[i].equals("estadoCivilPaciente") ? Tipos.tipoEstadoCivil(rs.getString(campos[i])) : (campos[i].equals("tipoPagamentoConvenio") ? Tipos.tipoPagamento(rs.getString(campos[i])) : (campos[i].equals("tipoCalculoFaturaConvenio") ? Tipos.tipoCalculoFatura(rs.getString(campos[i])) : (campos[i].equals("titularDependenteConvenio") ? Tipos.tipoTitularDependente(rs.getString(campos[i])) : (campos[i].equals("tipoCalculoCHConvenio") ? Tipos.tipoCalculoCH(rs.getString(campos[i])) : (campos[i].equals("tipoUltimoPagamentoRequisicao") ? Tipos.tipoPagamento(rs.getString(campos[i])) : rs.getObject(campos[i]))))))))))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioSemPedido.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioSemPedido.this.panelCentro.removeAll();
                            RelatorioSemPedido.this.panelCentro.repaint();
                            RelatorioSemPedido.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroUsuario", buf.toString());
                    buf.delete(0, buf.length());
                    if (destino != null) {
                        for (i = 0; i < destino.length; ++i) {
                            buf.append(destino[i]);
                            if (i >= destino.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    buf.delete(0, buf.length());
                    if (coleta != null) {
                        for (i = 0; i < coleta.length; ++i) {
                            buf.append(coleta[i]);
                            if (i >= coleta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (i = 0; i < crm.length; ++i) {
                            buf.append(conselho[i]).append(": ");
                            buf.append(crm[i]);
                            buf.append("(");
                            buf.append(uf[i]);
                            buf.append(")");
                            if (i >= crm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0822000100");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0822000101");
    }
}

