/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRequisicoesResumido
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_REQUISICOES = 0;
    public static final int TIPO_QUANTIDADE_ALTERACOES = 1;
    private static final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Nome Paciente", "Conv\u00eanio", "M\u00e9dico", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Esta\u00e7\u00e3o + Usu\u00e1rio", "Cod.Paciente", "Idade + Req."};
    private static final String[] situacaoPago = new String[]{"Todas", "Em aberto", "Pago parcial", "Pago Total"};
    private static final String[] opcoesFiltroBalcao = new String[]{"Ambas", "Excluir cob. balc\u00e3o", "Apenas cob. balc\u00e3o"};
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P")};
    private int tipo = 0;
    public static final int TIPO_DATA_LAUDO = 0;
    public static final int TIPO_DATA_MAPA = 1;
    public static final int TIPO_DATA_ETQ_COL = 2;
    public static final int TIPO_DATA_ETQ_TRI = 3;
    public static final int TIPO_PGTO_TODAS = 0;
    public static final int TIPO_PGTO_ABERTAS = 1;
    public static final int TIPO_PGTO_PAGO_PARCIAL = 2;
    public static final int TIPO_PGTO_PAGO_TOTAL = 3;
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_ESTACAO = "filtroEstacao";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_SITUACAO_CADASTRO = "filtroSituacaoRequisicao";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_DEVE_GUIA = "deveGuia";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_SITUACAO_PAGO = "filtroSituacaoPago";
    private static final String FILTRO_VIP = "filtroVIP";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_TODOS_EXAMES_MESMA_SITUACAO = "filtroTodosExamesMesmaSituacao";
    private static final String FILTRO_COBRANCA_BALCAO = "filtroCobrancaBalcao";
    private static final String FILTRO_APENAS_DESCONTOS = "filtroApenasDescontos";
    private static final long ACESSO_FILTRARESTACAO = Long.parseLong("0821100102");
    private static final long ACESSO_FILTRARCOLETA = Long.parseLong("0821100103");
    private static final long ACESSO_FILTRARDESTINO = Long.parseLong("0821100104");
    private static final long ACESSO_FILTRARUSUARIO = Long.parseLong("0821100105");
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoSetor", "descricaoSetor", "codigoExames", "descricaoExames", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "cartaoSUSRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "dataRecebeuGuiaRequisicao", "dataGuiaConferidaRequisicao", "dataRecebimentoProdutoRequisicao", "validadeCarteiraRequisicao", "validadeGuiaRepasseRequisicao", "validadeCarteiraRepasseRequisicao", "dataRecebeuGuiaRepasseRequisicao", "prontuarioRequisicao", "complementoDestinoRequisicao", "tipoUltimoPagamentoRequisicao", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigosMultiGuias", "codigoPaciente", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "cartaoSUSPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairrodestino", "descricaoBairrodestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "percentualAcrescimoConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoPrioridade", "descricaoPrioridade", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoEstacao", "descricaoEstacao", "quantidadeExamesRequisicao", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoMedico", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroMedico", "tipoLogradouroResponsavelRequisicao", "passaportePaciente", "generoPaciente", "procedenciaRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao_", "cargoResponsavelRequisicao_", "foneResponsavelRequisicao_", "emailResponsavelRequisicao_", "nomeResponsavelRequisicao", "cargoResponsavelRequisicao", "foneResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "descricaoEmbalagemProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "nomeSocialPaciente", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "motivoExclusao", "codigoOrcamento", "dataHoraOrcamento", "observacaoOrcamento", "validadeOrcamento", "solicitanteOrcamento", "contatoOrcamento", "foneOrcamento", "emailOrcamento", "fonecontatoOrcamento", "proprietarioOrcamento", "valorTotalFaturarRequisicao", "totalTaxaRequisicao", "contador"});

    public RelatorioRequisicoesResumido(int tipo) {
        this.setName("RelatorioRequisicoesResumido");
        this.tipo = tipo;
        if (tipo == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es (resumido)", "Listagem de requisi\u00e7\u00f5es resumida no per\u00edodo", "relatorios/rel_requisicao_resumido.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio de altera\u00e7\u00f5es por requisi\u00e7\u00e3o", "Listagem de altera\u00e7\u00f5es realizadas em requisi\u00e7\u00f5es no per\u00edodo", "relatorios/rel_ger_rec_requisicao_alteracao.jpg");
            this.campos = ArraysUtil.concatenar(this.campos, new String[]{"quantidadeAlteracoesRequisicao", "quantidadeAlteracoesComConferenciaRequisicao", "tipoAlteracao", "motivoAlteracao", "usuarioAlteracao", "dataHoraAlteracao", "codigoMotivoAlteracao", "descricaoMotivoAlteracao", "justificativaAlteracao"});
        }
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            RelatorioRequisicoesResumido.ordem[2] = "Nome Cliente";
            RelatorioRequisicoesResumido.ordem[4] = "Coletador";
            RelatorioRequisicoesResumido.ordem[8] = "C\u00f3d. Cliente";
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (Acesso.getAcesso(ACESSO_FILTRARESTACAO)) {
            this.adicionaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARUSUARIO)) {
            this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARDESTINO)) {
            this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARCOLETA)) {
            this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        }
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.adicionaFiltroCombo(FILTRO_SITUACAO_PAGO, "Sit. pgtos:", situacaoPago, 0);
        if (tipo == 0) {
            this.adicionaFiltroCombo(FILTRO_COBRANCA_BALCAO, "Cob. balc\u00e3o:", opcoesFiltroBalcao, 0);
        }
        this.adicionaFiltroCheck(FILTRO_DEVE_GUIA, "Sem pedido/guia", false);
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_VIP, "Paciente VIP", false);
        this.adicionaFiltroCheck(FILTRO_TODOS_EXAMES_MESMA_SITUACAO, "Exames mesma situa\u00e7\u00e3o", false);
        if (tipo == 0) {
            this.adicionaFiltroCheck(FILTRO_APENAS_DESCONTOS, "Apenas com descontos", false);
        }
        this.setModuloConfigurar(RelatorioRequisicoesResumido.getModuloConfigurar(tipo));
        this.setModuloAcesso(RelatorioRequisicoesResumido.getModuloAcesso(tipo));
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        try {
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            String situacaoAtual = this.getFiltroCombo(FILTRO_SITUACAO).toString();
            String[] situacaoCadastro = this.getSelecionadosFiltro(FILTRO_SITUACAO_CADASTRO, 0);
            String[] estacoes = this.getSelecionadosFiltro(FILTRO_ESTACAO, 0);
            String[] usuarios = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
            String[] destinos = this.getSelecionadosFiltro(FILTRO_DESTINO, 0);
            String[] coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0);
            String[] convenios = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            String[] medicosConselho = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0);
            String[] medicosCrm = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1);
            String[] medicosUf = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2);
            String[] setores = this.getSelecionadosFiltro(FILTRO_SETOR, 0);
            String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
            String horaInicial = this.getFiltroHora(FILTRO_HORA_INICIAL);
            String horaFinal = this.getFiltroHora(FILTRO_HORA_FINAL);
            boolean deveGuia = this.getFiltroCheck(FILTRO_DEVE_GUIA);
            boolean intervaloHora = this.getFiltroCheck(FILTRO_INTERVALO_HORA);
            boolean pacienteVip = this.getFiltroCheck(FILTRO_VIP);
            String[] paciente = null;
            String filtroCobrancaBalcao = this.getFiltroCombo(FILTRO_COBRANCA_BALCAO).toString();
            boolean apenasDesconto = this.getFiltroCheck(FILTRO_APENAS_DESCONTOS);
            if (intervaloHora && (Funcoes.textoVazio(dataInicial) || Funcoes.textoVazio(horaInicial) || Funcoes.textoVazio(dataFinal) || Funcoes.textoVazio(horaFinal))) {
                Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos!", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            String sql = this.getSelect(filiais, estacoes, usuarios, destinos, coletas, convenios, medicosConselho, medicosCrm, medicosUf, situacaoCadastro, setores, paciente, dataInicial, dataFinal, horaInicial, horaFinal, this.getFiltroCombo(FILTRO_ORDEM).toString(), situacaoAtual, deveGuia, intervaloHora, this.getFiltroComboIndice(FILTRO_SITUACAO_PAGO), pacienteVip, filtroCobrancaBalcao, apenasDesconto);
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            Statement st3 = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    if (this.getFiltroCheck(FILTRO_TODOS_EXAMES_MESMA_SITUACAO) && !rs.getBoolean("todosIguais")) continue;
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || this.campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || this.campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("quantidadeExamesRequisicao")) {
                            o[i] = this.quantidadeExameRequisicao(st3, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"));
                            continue;
                        }
                        if (this.campos[i].equals("tipoMedico")) {
                            o[i] = Tipos.tipoMedico(rs.getString("tipoMedico"));
                            continue;
                        }
                        if (this.campos[i].equals("anomesIdadeRequisicao") || this.campos[i].equals("anomesIdadePaciente")) {
                            o[i] = Tipos.tipoIdade(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("corPaciente")) {
                            o[i] = Tipos.tipoCor(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("fumantePaciente")) {
                            o[i] = Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente"));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("diabeticoPaciente")) {
                            o[i] = Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente"));
                            continue;
                        }
                        if (this.campos[i].equals("estadoCivilPaciente")) {
                            o[i] = Tipos.tipoEstadoCivil(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoPagamentoConvenio")) {
                            o[i] = Tipos.tipoPagamento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoCalculoFaturaConvenio")) {
                            o[i] = Tipos.tipoCalculoFatura(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("titularDependenteConvenio")) {
                            o[i] = Tipos.tipoTitularDependente(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoCalculoCHConvenio")) {
                            o[i] = Tipos.tipoCalculoCH(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoUltimoPagamentoRequisicao")) {
                            o[i] = Tipos.tipoPagamento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("valorTotalFaturarRequisicao")) {
                            o[i] = this.getValorTotalExamesRequisicaoParaFatura(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"));
                            continue;
                        }
                        if (this.campos[i].equals("quantidadeAlteracoesRequisicao") && this.tipo == 1) {
                            o[i] = Impressao.getQuantidadeAlteracoesRequisicao(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"));
                            continue;
                        }
                        if (this.campos[i].equals("quantidadeAlteracoesComConferenciaRequisicao") && this.tipo == 1) {
                            o[i] = Impressao.getQuantidadeAlteracoesRequisicaoComConferencia(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"));
                            continue;
                        }
                        if (this.tipo == 1 && (this.campos[i].equalsIgnoreCase("tipoAlteracao") || this.campos[i].equalsIgnoreCase("motivoAlteracao") || this.campos[i].equalsIgnoreCase("usuarioAlteracao") || this.campos[i].equalsIgnoreCase("dataHoraAlteracao") || this.campos[i].equalsIgnoreCase("codigoMotivoAlteracao") || this.campos[i].equalsIgnoreCase("descricaoMotivoAlteracao") || this.campos[i].equalsIgnoreCase("justificativaAlteracao"))) {
                            o[i] = "";
                            continue;
                        }
                        if (this.campos[i].equals("codigosMultiGuias")) {
                            Object[] filhas = RecepcaoUtil.verificaMultiGuias(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), false);
                            if (filhas != null) {
                                o[i] = Arrays.toString(filhas);
                                continue;
                            }
                            o[i] = null;
                            continue;
                        }
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    if (this.tipo == 1) {
                        StringBuilder b = new StringBuilder("select rlo_datahora, rlo_descricaomotivo, usr_codigo, rlo_tipo, rl.mva_codigo, ma.mva_descricao from requisicaolog rl ");
                        b.append("left join motivoalteracao ma on rl.fil_codigo = ma.fil_codigo and rl.mva_codigo = ma.mva_codigo ");
                        b.append("where rl.fil_codigo = ").append(rs.getString("codigoFilial"));
                        b.append(" and req_codigo = ").append(rs.getString("codigoRequisicao"));
                        b.append(" order by rlo_datahora ");
                        ResultSet rss = Conexao.executeQuery(st2, b);
                        if (!rss.next()) continue;
                        do {
                            modelo.addLine((Object[])o.clone());
                            int coluna = ArraysUtil.indice((Object[])this.campos, "tipoAlteracao");
                            if (coluna > -1) {
                                modelo.setValueAt(rss.getString("rlo_tipo"), modelo.getRowCount() - 1, coluna);
                            }
                            if ((coluna = ArraysUtil.indice((Object[])this.campos, "motivoAlteracao")) > -1) {
                                modelo.setValueAt(rss.getString("rlo_descricaomotivo"), modelo.getRowCount() - 1, coluna);
                            }
                            if ((coluna = ArraysUtil.indice((Object[])this.campos, "usuarioAlteracao")) > -1) {
                                modelo.setValueAt(rss.getString("usr_codigo"), modelo.getRowCount() - 1, coluna);
                            }
                            if ((coluna = ArraysUtil.indice((Object[])this.campos, "dataHoraAlteracao")) > -1) {
                                modelo.setValueAt(rss.getTimestamp("rlo_datahora"), modelo.getRowCount() - 1, coluna);
                            }
                            if ((coluna = ArraysUtil.indice((Object[])this.campos, "codigoMotivoAlteracao")) > -1) {
                                modelo.setValueAt(rss.getInt("mva_codigo"), modelo.getRowCount() - 1, coluna);
                            }
                            if ((coluna = ArraysUtil.indice((Object[])this.campos, "descricaoMotivoAlteracao")) > -1) {
                                modelo.setValueAt(rss.getString("mva_descricao"), modelo.getRowCount() - 1, coluna);
                            }
                            if ((coluna = ArraysUtil.indice((Object[])this.campos, "justificativaAlteracao")) <= -1) continue;
                            modelo.setValueAt(rss.getString("rlo_descricaomotivo"), modelo.getRowCount() - 1, coluna);
                        } while (rss.next());
                        continue;
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    Conexao.fecharStatement(st, st2);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                StringBuilder buf = new StringBuilder();
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioRequisicoesResumido.getModuloAcesso(this.tipo));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(() -> {
                        this.panelCentro.removeAll();
                        this.panelCentro.repaint();
                        this.habilitaBotaoImprimir(true);
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO).toString());
                    var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM).toString());
                    var.put(FILTRO_DEVE_GUIA, deveGuia);
                    var.put(FILTRO_DATA_INICIAL, dataInicial);
                    var.put(FILTRO_DATA_FINAL, dataFinal);
                    var.put(FILTRO_HORA_INICIAL, horaInicial);
                    var.put(FILTRO_HORA_FINAL, horaFinal);
                    var.put(FILTRO_VIP, pacienteVip);
                    var.put(FILTRO_SITUACAO, situacaoAtual);
                    var.put(FILTRO_COBRANCA_BALCAO, filtroCobrancaBalcao);
                    buf.delete(0, buf.length());
                    if (estacoes != null) {
                        for (i = 0; i < estacoes.length; ++i) {
                            buf.append(estacoes[i]);
                            if (i >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    } else if (!Acesso.getAcesso(ACESSO_FILTRARESTACAO)) {
                        buf.append(Variaveis.codigoEstacao);
                    }
                    var.put(FILTRO_ESTACAO, buf.toString());
                    buf.delete(0, buf.length());
                    if (usuarios != null) {
                        for (i = 0; i < usuarios.length; ++i) {
                            buf.append(usuarios[i]);
                            if (i >= usuarios.length - 1) continue;
                            buf.append(", ");
                        }
                    } else if (!Acesso.getAcesso(ACESSO_FILTRARUSUARIO)) {
                        buf.append(Variaveis.login);
                    }
                    var.put(FILTRO_USUARIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_DESTINO, buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_COLETA, buf.toString());
                    buf.delete(0, buf.length());
                    if (setores != null) {
                        for (i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_SETOR, buf.toString());
                    buf.delete(0, buf.length());
                    if (convenios != null) {
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (medicosCrm != null && medicosUf != null) {
                        for (i = 0; i < medicosCrm.length; ++i) {
                            buf.append(medicosConselho[i]).append(": ");
                            buf.append(medicosCrm[i]);
                            buf.append("(");
                            buf.append(medicosUf[i]);
                            buf.append(")");
                            if (i >= medicosCrm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_MEDICO, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st, st2);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int quantidadeExameRequisicao(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder buf = new StringBuilder("SELECT COUNT(exr.exa_codigo) AS quantidadeExamesRequisicao ");
        buf.append("FROM examerequisicao exr ");
        buf.append("LEFT JOIN requisicao req ON exr.fil_codigo = req.fil_codigo AND exr.req_codigo = req.req_codigo ");
        buf.append("WHERE exr.exr_excluido = false ");
        buf.append(" AND exr.fil_codigo = ").append(filial);
        buf.append(" AND exr.req_codigo = ").append(requisicao);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeExamesRequisicao");
        }
        return retorno;
    }

    private String getSelect(String[] filiais, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] situacoes, String[] setores, String[] pacientes, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String ordemSelecionada, String situacaoAtual, boolean deveGuia, boolean intervaloHora, int situacaoPagamento, boolean pacienteVIP, String filtroCobrancaBalcao, boolean apenasDesconto) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, ");
        buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao,  a.req_totaltaxa as totalTaxaRequisicao,");
        buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, ");
        buf.append("a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
        buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao,  ");
        buf.append("a.req_titular as titularRequisicao, a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao,  ");
        buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
        buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
        buf.append("a.req_telacoleta as coletadoRequisicao, a.req_datarequisicao as dataAberturaRequisicao, ");
        buf.append("a.req_neonato as neonatoRequisicao, a.req_validadeguia as validadeGuiaRequisicao,  ");
        buf.append("a.req_guia as guiaRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, a.req_cartaosus as cartaoSUSRequisicao, ");
        buf.append("a.req_complementodestino as complementoDestinoRequisicao, a.req_motivoExclusao as motivoExclusao, a.req_procedencia as procedenciaRequisicao, ");
        buf.append("'' as codigosMultiGuias, ");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, ");
        buf.append("ala.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, paciente.pac_cartaosus as cartaoSUSPaciente, ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("paciente.pac_vip as vipPaciente, paciente.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append("paciente.pac_fatorrh as fatorrhPaciente, paciente.pac_fatordu as fatorduPaciente, ");
        buf.append("paciente.pac_cor as corPaciente, paciente.pac_observ as observacaoPaciente, ");
        buf.append("paciente.pac_dadoclinico as dadosClinicosPaciente, paciente.pac_peso as pesoPaciente, ");
        buf.append("paciente.pac_altura as alturaPaciente, paciente.pac_matricconv as matriculaConvenioPaciente, ");
        buf.append("paciente.pac_titularconv as titularConvenioPaciente, paciente.pac_profissao as profissaoPaciente, ");
        buf.append("paciente.pac_fumante as fumantePaciente, paciente.pac_diabetico as diabeticoPaciente, ");
        buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
        buf.append("paciente.pac_estcivil as estadoCivilPaciente, paciente.pac_numfilho as numeroFilhosPaciente, ");
        buf.append("paciente.pac_datahora as dataHoraCadastroPaciente, paciente.pac_dum as dumPaciente, ");
        buf.append("paciente.pac_fax as faxPaciente, paciente.pac_celular as celularPaciente, ");
        buf.append("paciente.pac_fonecomercial as foneComercialPaciente, paciente.pac_fone as fonePaciente, ");
        buf.append("paciente.pac_cep as cepPaciente, paciente.pac_complemento as complementoPaciente, ");
        buf.append("paciente.pac_endereco as enderecoPaciente, paciente.pac_numeroendereco as numeroEnderecoPaciente, paciente.pac_email as emailPaciente, ");
        buf.append("paciente.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
        buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
        buf.append("paciente.pac_fonecontato as foneContatoPaciente, paciente.pac_nomecontato as contatoPaciente, ");
        buf.append("paciente.pac_mae as maePaciente, paciente.pac_pai as paiPaciente, paciente.pac_nomesocial as nomeSocialPaciente, paciente.pac_passaporte as passaportePaciente, ");
        buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
        buf.append("cidpaciente.cid_uf as estadoCidadePaciente, ");
        buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
        buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
        buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
        buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino,  ");
        buf.append("destino.des_impressora as impressoraDestino, destino.des_naoimprimir as naoImprimirDestino,  ");
        buf.append("destino.des_cep as cepDestino, destino.des_complemento as complementoDestino, ");
        buf.append("destino.des_endereco as enderecoDestino, destino.des_fone as foneDestino, ");
        buf.append("destino.des_enviarweb as enviarWebDestino,  ");
        buf.append("ciddestino.cid_codigo as codigoCidadeDestino, ciddestino.cid_nome as descricaoCidadeDestino, ");
        buf.append("ciddestino.cid_uf as estadoCidadeDestino, ");
        buf.append("baidestino.bai_codigo as codigoBairroDestino, baidestino.bai_descricao as descricaoBairroDestino, ");
        buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
        buf.append("coleta.col_cep as cepColeta, coleta.col_complemento as complementoColeta, ");
        buf.append("coleta.col_endereco as enderecoColeta, coleta.col_fone as foneColeta, ");
        buf.append("cidcoleta.cid_codigo as codigoCidadeColeta, cidcoleta.cid_nome as descricaoCidadeColeta, ");
        buf.append("cidcoleta.cid_uf as estadoCidadeColeta, ");
        buf.append("baicoleta.bai_codigo as codigoBairroColeta, baicoleta.bai_descricao as descricaoBairroColeta, ");
        buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
        buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
        buf.append("convenio.con_tppgto as tipoPagamentoConvenio, ");
        buf.append("convenio.con_fatfmaterial as faturarFaltaMaterialConvenio, convenio.con_descexame as habilitarDescontoConvenio,  ");
        buf.append("convenio.con_multa as multaConvenio,  ");
        buf.append("convenio.con_mora as moraConvenio, convenio.con_fatfiliais as faturarFiliaisConvenio, ");
        buf.append("convenio.con_nr1via as quantidade1ViaConvenio, convenio.con_nrexames as numeroExamesConvenio,  ");
        buf.append("convenio.con_viasfatura as viasFaturaConvenio, convenio.con_impbloqueto as imprimirBloquetoConvenio,  ");
        buf.append("convenio.con_nr2via as quantidade2ViaConvenio, convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio,  ");
        buf.append("coalesce(convenio.con_percpgto, 0) as percentualBalcaoConvenio, convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
        buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, convenio.con_titdep as titularDependenteConvenio, ");
        buf.append("convenio.con_maskcart as mascaraCarteiraConvenio, convenio.con_contato as contatoConvenio, ");
        buf.append("convenio.con_informarmat as obrigaMatriculaConvenio, convenio.con_cep as cepConvenio,  ");
        buf.append("convenio.con_complemento as complementoConvenio, convenio.con_endereco as enderecoConvenio,  ");
        buf.append("convenio.con_cepcobranca as cepCobrancaConvenio, convenio.con_complcobranca as complementoCobrancaConvenio,  ");
        buf.append("convenio.con_endcobranca as enderecoCobrancaConvenio, convenio.con_fax as faxConvenio, ");
        buf.append("convenio.con_numeroendereco as numeroEnderecoConvenio, convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
        buf.append("convenio.con_tipologradouroendereco as tipoLogradouroConvenio, convenio.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
        buf.append("convenio.con_fone as foneConvenio, convenio.con_valorfilme as valorFilmeConvenio,  ");
        buf.append("convenio.con_valorch as valorCHConvenio, convenio.con_site as siteConvenio, ");
        buf.append("convenio.con_email2 as email2Convenio, convenio.con_email1 as email1Convenio,  ");
        buf.append("convenio.con_tpcalcch as tipoCalculoCHConvenio, convenio.con_inscmunic as inscricaoMunicipalConvenio,  ");
        buf.append("convenio.con_bonus as percentualBonusConvenio, convenio.con_senhaweb as senhaWebConvenio,  ");
        buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
        buf.append("convenio.con_proibidoweb as proibidoWebConvenio, convenio.con_validadeguia as obrigaValidadeGuiaConvenio,  ");
        buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, convenio.con_diasvalidade as diasValidadeGuia,  ");
        buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
        buf.append("prioridade.pri_codigo as codigoPrioridade, prioridade.pri_descricao as descricaoPrioridade, ");
        buf.append("cidconvenio.cid_codigo as codigoCidadeConvenio, cidconvenio.cid_nome as descricaoCidadeConvenio,  ");
        buf.append("cidconvenio.cid_uf as estadoCidadeConvenio, ");
        buf.append("baiconvenio.bai_codigo as codigoBairroConvenio, baiconvenio.bai_descricao as descricaoBairroConvenio, ");
        buf.append("layout.lay_codigo as codigoModelo, layout.lay_descricao as descricaoModelo, ");
        buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
        buf.append("medico.med_abrev as abreviaturaMedico, ");
        buf.append("medico.med_tipo as tipoMedico, ");
        buf.append("medico.med_comissao as comissaoMedico, medico.med_cep as cepMedico, medico.med_complemento as complementoMedico,  ");
        buf.append("medico.med_endereco as enderecoMedico, medico.med_celular as celularMedico, medico.med_fax as faxMedico,  ");
        buf.append("medico.med_numeroendereco as numeroEnderecoMedico, medico.med_tipologradouroendereco as tipoLogradouroMedico, ");
        buf.append("medico.med_fone as foneMedico, medico.med_email as emailMedico, medico.med_site as siteMedico, medico.med_senhaweb as senhaWebMedico, ");
        buf.append("cidmedico.cid_codigo as codigoCidadeMedico, cidmedico.cid_nome as descricaoCidadeMedico, cidmedico.cid_uf as estadoCidadeMedico,  ");
        buf.append("baimedico.bai_codigo as codigoBairroMedico, baimedico.bai_descricao as descricaoBairroMedico, ");
        buf.append("a.est_codigo as codigoEstacao, estacoes.est_descricao as descricaoEstacao, ");
        buf.append("a.req_prontuario as prontuarioRequisicao, ");
        buf.append("sit.sit_codigo as codigoSituacao, ");
        buf.append("sit.sit_descricao as descricaoSituacao, ");
        buf.append("idg.ige_descricao as generoPaciente, ");
        buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        buf.append("a.req_datarecebeuguia as dataRecebeuGuiaRequisicao, ");
        buf.append("a.req_dataguiaconferida as dataGuiaConferidaRequisicao, ");
        buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
        buf.append("a.req_validadecarteira as validadeCarteiraRequisicao, ");
        buf.append("a.req_validadeguiarepasse as validadeGuiaRepasseRequisicao, ");
        buf.append("a.req_validadecarteirarepasse as validadeCarteiraRepasseRequisicao, ");
        buf.append("a.req_datarecebeuguiarepasse as dataRecebeuGuiaRepasseRequisicao, ");
        buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
        buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
        buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        buf.append("ent.ent_email as emailResponsavelRequisicao, ");
        buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
        buf.append("ent.ent_razaosocial as razaoSocialResponsavelRequisicao, ");
        buf.append("ent.ent_endereco as enderecoResponsavelRequisicao, ");
        buf.append("ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao, ");
        buf.append("ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao, ");
        buf.append("ent.ent_complemento as complementoResponsavelRequisicao, ");
        buf.append("ent.ent_cep as cepResponsavelRequisicao, ");
        buf.append("ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao, ");
        buf.append("cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao, ");
        buf.append("cidentidade.cid_uf as estadoCidadeResponsavelRequisicao, ");
        buf.append("baientidade.bai_descricao as descricaoBairroResponsavelRequisicao, ");
        buf.append("paciente.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        buf.append("paciente.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        buf.append("paciente.pac_razaosocial as razaoSocialPaciente, ");
        buf.append("paciente.pac_cnpj as cnpjPaciente, ");
        buf.append("paciente.pac_ie as inscricaoEstadualPaciente, ");
        buf.append("paciente.pac_proprietario as proprietarioPaciente, ");
        buf.append("paciente.pac_sif as sifPaciente, ");
        buf.append("paciente.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        buf.append("paciente.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        buf.append("paciente.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
        buf.append("paciente.pac_complementocobranca as complementoCobrancaPaciente, ");
        buf.append("paciente.pac_cepcobranca as cepCobrancaPaciente, ");
        buf.append("paciente.pac_fonecobranca as foneCobrancaPaciente, ");
        buf.append("paciente.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        buf.append("orc.orc_codigo as codigoOrcamento, ");
        buf.append("orc.orc_datahora as dataHoraOrcamento, ");
        buf.append("orc.orc_observacao as observacaoOrcamento, ");
        buf.append("orc.orc_validade as validadeOrcamento, ");
        buf.append("orc.orc_solicitante as solicitanteOrcamento, ");
        buf.append("orc.orc_contato as contatoOrcamento, ");
        buf.append("orc.orc_fone as foneOrcamento, ");
        buf.append("orc.orc_email as emailOrcamento, ");
        buf.append("orc.orc_fonecontato as fonecontatoOrcamento, ");
        buf.append("orc.orc_proprietario as proprietarioOrcamento, ");
        buf.append(" array_to_string(array_agg(DISTINCT cast(COALESCE(NULLIF(exr.exr_situacao, ''), '-') AS TEXT)), '')  = (select array_to_string(array_agg(distinct cast(COALESCE(NULLIF(exr2.exr_situacao, ''), '-') as TEXT)), '') ");
        buf.append("                                   from examerequisicao exr2 ");
        buf.append("                                  where a.fil_codigo = exr2.fil_codigo ");
        buf.append("                                    and a.req_codigo = exr2.req_codigo) as todosIguais, ");
        buf.append("array_to_string(array_agg(distinct setor.set_codigo), ', ') AS codigoSetor, ");
        buf.append("array_to_string(array_agg(distinct setor.set_descricao), ', ') AS descricaoSetor, ");
        buf.append("array_to_string(array_agg(distinct exa.exa_codigo), ', ') AS codigoExames, ");
        buf.append("array_to_string(array_agg(distinct exa.exa_descricao), ', ') AS descricaoExames, ");
        buf.append("0.0 as valorTotalFaturarRequisicao, ");
        buf.append("1 as contador, ");
        buf.append("a.req_idade * (case when a.req_anomes='A' then 365 when a.req_anomes='M' then 30 else 1 end), ");
        if (this.tipo == 1) {
            buf.append("0 as quantidadeAlteracoesRequisicao, 0 as quantidadeAlteracoesComConferenciaRequisicao, ");
        }
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("from requisicao a ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append("join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
        buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("left join situacao sit on a.fil_codigo = sit.fil_codigo and a.sit_codigo = sit.sit_codigo ");
        buf.append("join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        buf.append("join examerequisicao exr on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo ");
        buf.append("join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("left join examesetor ese on exa.fil_codigo = ese.fil_codigo and exa.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        buf.append("left join setores setor on ese.fil_codigo = setor.fil_codigo and ese.set_codigo = setor.set_codigo ");
        buf.append("left join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exa.exa_codigo = emc.exa_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("left join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo and emc.mco_codigo = mco.mco_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
        buf.append("left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
        buf.append("left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
        buf.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
        buf.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
        buf.append("left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
        buf.append("left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
        buf.append("left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
        buf.append("left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
        buf.append("left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
        buf.append("left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
        buf.append("left join layout on convenio.fil_codigo = layout.fil_codigo and convenio.lay_codigo = layout.lay_codigo ");
        buf.append("left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
        buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo  and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("left join cidades cidcobranca on paciente.fil_codigo = cidcobranca.fil_codigo and paciente.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on paciente.fil_codigo = baicobranca.fil_codigo and paciente.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        buf.append("left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        buf.append("left join orcamento orc on a.fil_codigo = orc.fil_codigo and a.orc_codigo = orc.orc_codigo ");
        buf.append("left join usuario usrorcamento on usrorcamento.usr_codigo = orc.usr_codigo ");
        buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append("where a.fil_codigo in (");
        for (int i2 = 0; i2 < filiais.length; ++i2) {
            buf.append(filiais[i2]);
            if (i2 >= filiais.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        String situacaoExame = this.getFiltroCombo(FILTRO_SITUACAO).toString();
        if (!situacaoExame.equals(this.situacao[0])) {
            if (situacaoExame.equals(this.situacao[1])) {
                buf.append(" and (exr.exr_situacao = '' or exr.exr_situacao is null or exr.exr_situacao = ' ')");
            } else {
                buf.append(" and exr.exr_situacao = '");
                if (situacaoExame.equals(this.situacao[2])) {
                    buf.append("T");
                } else if (situacaoExame.equals(this.situacao[3])) {
                    buf.append("F");
                } else if (situacaoExame.equals(this.situacao[4])) {
                    buf.append("R");
                } else if (situacaoExame.equals(this.situacao[5])) {
                    buf.append("L");
                } else if (situacaoExame.equals(this.situacao[6])) {
                    buf.append("C");
                } else if (situacaoExame.equals(this.situacao[7])) {
                    buf.append("O");
                } else if (situacaoExame.equals(this.situacao[8])) {
                    buf.append("I");
                } else if (situacaoExame.equals(this.situacao[9])) {
                    buf.append("E");
                } else if (situacaoExame.equals(this.situacao[10])) {
                    buf.append("A");
                } else {
                    buf.append("P");
                }
                buf.append("'");
            }
        }
        if (situacaoPagamento != 0) {
            if (situacaoPagamento == 1) {
                buf.append(" and a.req_totpago = 0 ");
            } else if (situacaoPagamento == 2) {
                buf.append(" and (a.req_totpago > 0 and a.req_totpago < a.req_total) ");
            } else if (situacaoPagamento == 3) {
                buf.append(" and a.req_totpago >= a.req_total ");
            }
        }
        if (!filtroCobrancaBalcao.equals(opcoesFiltroBalcao[0])) {
            if (filtroCobrancaBalcao.equals(opcoesFiltroBalcao[1])) {
                buf.append(" and convenio.con_cobrexame = false ");
            } else {
                buf.append(" and convenio.con_cobrexame = true ");
            }
        }
        if (estacoes != null) {
            buf.append(" and a.est_codigo in (");
            for (i = 0; i < estacoes.length; ++i) {
                buf.append(estacoes[i]);
                if (i >= estacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        } else if (!Acesso.getAcesso(ACESSO_FILTRARESTACAO)) {
            buf.append(" and a.est_codigo = ");
            buf.append(Variaveis.codigoEstacao);
        }
        if (usuarios != null) {
            buf.append(" and a.usr_codabertura in (");
            for (i = 0; i < usuarios.length; ++i) {
                buf.append("'");
                buf.append(usuarios[i]);
                buf.append("'");
                if (i >= usuarios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        } else if (!Acesso.getAcesso(ACESSO_FILTRARUSUARIO)) {
            buf.append(" and a.usr_codabertura = '");
            buf.append(Variaveis.login);
            buf.append("'");
        }
        if (destinos != null) {
            buf.append(" and a.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (coletas != null) {
            buf.append(" and a.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (convenios != null) {
            buf.append(" and a.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (situacoes != null && situacoes.length > 0) {
            buf.append(" and a.sit_codigo in (");
            for (i = 0; i < situacoes.length; ++i) {
                buf.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and setor.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (pacientes != null) {
            buf.append(" and a.pac_codigo in (");
            for (i = 0; i < pacientes.length; ++i) {
                buf.append(pacientes[i]);
                if (i >= pacientes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (medicosCrm != null && medicosUF != null && medicosCrm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (i = 0; i < medicosCrm.length; ++i) {
                buf.append("(a.med_conselho = '");
                buf.append(medicosConselho[i]);
                buf.append("' and a.med_crm = '");
                buf.append(medicosCrm[i]);
                buf.append("' and a.med_uf = '");
                buf.append(medicosUF[i]);
                buf.append("')");
                if (i >= medicosCrm.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(")");
        }
        if (!intervaloHora) {
            if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                buf.append(" and a.req_data >= '").append(Funcoes.formataData("MM/dd/yyyy", dataInicial)).append("'");
            }
            if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                buf.append(" and a.req_data  <= '").append(Funcoes.formataData("MM/dd/yyyy", dataFinal)).append("'");
            }
            if (horaInicial != null && Funcoes.verificaHora(horaInicial)) {
                buf.append(" and a.req_hora >= '").append(horaInicial).append("'");
            }
            if (horaFinal != null && Funcoes.verificaHora(horaFinal)) {
                buf.append(" and a.req_hora <= '").append(horaFinal).append("'");
            }
        } else {
            buf.append(" and ((a.req_data + a.req_hora) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ").append(horaInicial).append("')");
            buf.append(" and ((a.req_data + a.req_hora) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ").append(horaFinal).append("')");
        }
        if (deveGuia) {
            buf.append(" and a.req_deveguia = true ");
        }
        if (pacienteVIP) {
            buf.append(" and paciente.pac_vip = true ");
        }
        buf.append(" and a.req_excluida = false and exr.exr_excluido = false ");
        if (this.tipo == 0 && apenasDesconto) {
            buf.append(" and a.req_vlrdesconto > 0");
        }
        buf.append(" GROUP BY ");
        buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buf.append("\t,a.req_codigo ");
        buf.append(" ,a.req_data                      ");
        buf.append(" ,a.req_dtfatura                  ");
        buf.append(" ,a.req_urgente                   ");
        buf.append(" ,a.req_dataentregaprev           ");
        buf.append(" ,a.req_dclinicos                 ");
        buf.append(" ,a.req_notacaixa                 ");
        buf.append(" ,a.req_obs                       ");
        buf.append(" ,a.req_totpago                   ");
        buf.append(" ,a.req_total                     ");
        buf.append(" ,a.req_horaentregaprev           ");
        buf.append(" ,a.req_horafatura                ");
        buf.append(" ,a.req_hora                      ");
        buf.append(" ,a.req_gestante                  ");
        buf.append(" ,a.req_dum                       ");
        buf.append(" ,a.req_matricula                 ");
        buf.append(" ,a.req_anomes                    ");
        buf.append(" ,a.req_idade                     ");
        buf.append(" ,a.req_avisarpaciente            ");
        buf.append(" ,a.req_senhaweb                  ");
        buf.append(" ,a.req_titular                   ");
        buf.append(" ,a.req_altura                    ");
        buf.append(" ,a.req_peso                      ");
        buf.append(" ,a.req_vlracrescimo              ");
        buf.append(" ,a.req_acrescimo                 ");
        buf.append(" ,a.req_vlrdesconto               ");
        buf.append(" ,a.req_desconto                  ");
        buf.append(" ,a.req_telacoleta                ");
        buf.append(" ,a.req_datarequisicao            ");
        buf.append(" ,a.req_neonato                   ");
        buf.append(" ,a.req_validadeguia              ");
        buf.append(" ,a.req_guia                      ");
        buf.append(" ,a.req_tipoultpagamento          ");
        buf.append(" ,a.req_complementodestino        ");
        buf.append(" ,a.req_motivoexclusao            ");
        buf.append(" ,a.req_totaltaxa                 ");
        buf.append(" ,a.req_quarto                    ");
        buf.append(" ,a.req_leito                     ");
        buf.append(" ,ala.ala_codigo                  ");
        buf.append(" ,ala.ala_descricao               ");
        buf.append(" ,paciente.pac_codigo             ");
        buf.append(" ,paciente.pac_nome               ");
        buf.append(" ,paciente.pac_datanasc           ");
        buf.append(" ,paciente.pac_sexo               ");
        buf.append(" ,paciente.pac_vip                ");
        buf.append(" ,paciente.pac_grpsangue          ");
        buf.append(" ,paciente.pac_fatorrh            ");
        buf.append(" ,paciente.pac_fatordu            ");
        buf.append(" ,paciente.pac_cor                ");
        buf.append(" ,paciente.pac_observ             ");
        buf.append(" ,paciente.pac_dadoclinico        ");
        buf.append(" ,paciente.pac_peso               ");
        buf.append(" ,paciente.pac_altura             ");
        buf.append(" ,paciente.pac_matricconv         ");
        buf.append(" ,paciente.pac_titularconv        ");
        buf.append(" ,paciente.pac_profissao          ");
        buf.append(" ,paciente.pac_fumante            ");
        buf.append(" ,paciente.pac_diabetico          ");
        buf.append(" ,paciente.pac_rg                 ");
        buf.append(" ,paciente.pac_cpf                ");
        buf.append(" ,paciente.pac_estcivil           ");
        buf.append(" ,paciente.pac_numfilho           ");
        buf.append(" ,paciente.pac_datahora           ");
        buf.append(" ,paciente.pac_dum                ");
        buf.append(" ,paciente.pac_fax                ");
        buf.append(" ,paciente.pac_celular            ");
        buf.append(" ,paciente.pac_fonecomercial      ");
        buf.append(" ,paciente.pac_fone               ");
        buf.append(" ,paciente.pac_cep                ");
        buf.append(" ,paciente.pac_complemento        ");
        buf.append(" ,paciente.pac_endereco           ");
        buf.append(" ,paciente.pac_tipologradouroendereco    ");
        buf.append(" ,paciente.pac_numeroendereco     ");
        buf.append(" ,paciente.pac_email              ");
        buf.append(" ,paciente.pac_anomes             ");
        buf.append(" ,paciente.pac_idade              ");
        buf.append(" ,paciente.pac_fonecontato        ");
        buf.append(" ,paciente.pac_nomecontato        ");
        buf.append(" ,paciente.pac_mae                ");
        buf.append(" ,paciente.pac_pai                ");
        buf.append(" ,paciente.pac_nomesocial         ");
        buf.append(" ,cidpaciente.cid_codigo          ");
        buf.append(" ,cidpaciente.cid_nome            ");
        buf.append(" ,cidpaciente.cid_uf              ");
        buf.append(" ,baipaciente.bai_codigo          ");
        buf.append(" ,baipaciente.bai_descricao       ");
        buf.append(" ,usrrequisicao.usr_codigo        ");
        buf.append(" ,usrrequisicao.usr_nome          ");
        buf.append(" ,usrabertura.usr_codigo          ");
        buf.append(" ,usrabertura.usr_nome            ");
        buf.append(" ,destino.des_codigo              ");
        buf.append(" ,destino.des_descricao           ");
        buf.append(" ,destino.des_impressora          ");
        buf.append(" ,destino.des_naoimprimir         ");
        buf.append(" ,destino.des_cep                 ");
        buf.append(" ,destino.des_complemento         ");
        buf.append(" ,destino.des_endereco            ");
        buf.append(" ,destino.des_fone                ");
        buf.append(" ,destino.des_enviarweb           ");
        buf.append(" ,ciddestino.cid_codigo           ");
        buf.append(" ,ciddestino.cid_nome             ");
        buf.append(" ,ciddestino.cid_uf               ");
        buf.append(" ,baidestino.bai_codigo           ");
        buf.append(" ,baidestino.bai_descricao        ");
        buf.append(" ,coleta.col_codigo               ");
        buf.append(" ,coleta.col_descricao            ");
        buf.append(" ,coleta.col_cep                  ");
        buf.append(" ,coleta.col_complemento          ");
        buf.append(" ,coleta.col_endereco             ");
        buf.append(" ,coleta.col_fone                 ");
        buf.append(" ,cidcoleta.cid_codigo            ");
        buf.append(" ,cidcoleta.cid_nome              ");
        buf.append(" ,cidcoleta.cid_uf                ");
        buf.append(" ,baicoleta.bai_codigo            ");
        buf.append(" ,baicoleta.bai_descricao         ");
        buf.append(" ,convenio.con_codigo             ");
        buf.append(" ,convenio.con_razao              ");
        buf.append(" ,convenio.con_fantasia           ");
        buf.append(" ,convenio.con_cnpjcpf            ");
        buf.append(" ,convenio.con_tppgto             ");
        buf.append(" ,convenio.con_fatfmaterial       ");
        buf.append(" ,convenio.con_descexame          ");
        buf.append(" ,convenio.con_multa              ");
        buf.append(" ,convenio.con_mora               ");
        buf.append(" ,convenio.con_fatfiliais         ");
        buf.append(" ,convenio.con_nr1via             ");
        buf.append(" ,convenio.con_nrexames           ");
        buf.append(" ,convenio.con_viasfatura         ");
        buf.append(" ,convenio.con_impbloqueto        ");
        buf.append(" ,convenio.con_nr2via             ");
        buf.append(" ,convenio.con_tpcalcfatu         ");
        buf.append(" ,convenio.con_cobrexame          ");
        buf.append(" ,convenio.con_inscrest           ");
        buf.append(" ,convenio.con_titdep             ");
        buf.append(" ,convenio.con_maskcart           ");
        buf.append(" ,convenio.con_contato            ");
        buf.append(" ,convenio.con_informarmat        ");
        buf.append(" ,convenio.con_cep                ");
        buf.append(" ,convenio.con_complemento        ");
        buf.append(" ,convenio.con_endereco           ");
        buf.append(" ,convenio.con_cepcobranca        ");
        buf.append(" ,convenio.con_complcobranca      ");
        buf.append(" ,convenio.con_endcobranca        ");
        buf.append(" ,convenio.con_numeroendcobranca  ");
        buf.append(" ,convenio.con_numeroendereco     ");
        buf.append(" ,convenio.con_tipologradouroendcobranca   ");
        buf.append(" ,convenio.con_tipologradouroendereco      ");
        buf.append(" ,convenio.con_fax                ");
        buf.append(" ,convenio.con_fone               ");
        buf.append(" ,convenio.con_valorfilme         ");
        buf.append(" ,convenio.con_valorch            ");
        buf.append(" ,convenio.con_site               ");
        buf.append(" ,convenio.con_email2             ");
        buf.append(" ,convenio.con_email1             ");
        buf.append(" ,convenio.con_tpcalcch           ");
        buf.append(" ,convenio.con_inscmunic          ");
        buf.append(" ,convenio.con_bonus              ");
        buf.append(" ,convenio.con_senhaweb           ");
        buf.append(" ,convenio.con_acrescimo          ");
        buf.append(" ,convenio.con_proibidoweb        ");
        buf.append(" ,convenio.con_validadeguia       ");
        buf.append(" ,convenio.con_codigoguia         ");
        buf.append(" ,convenio.con_diasvalidade       ");
        buf.append(" ,convenio.con_ordemfatura        ");
        buf.append(" ,convenio.con_cobrmaterial       ");
        buf.append(" ,prioridade.pri_codigo           ");
        buf.append(" ,prioridade.pri_descricao        ");
        buf.append(" ,cidconvenio.cid_codigo          ");
        buf.append(" ,cidconvenio.cid_nome            ");
        buf.append(" ,cidconvenio.cid_uf              ");
        buf.append(" ,baiconvenio.bai_codigo          ");
        buf.append(" ,baiconvenio.bai_descricao       ");
        buf.append(" ,layout.lay_codigo               ");
        buf.append(" ,layout.lay_descricao            ");
        buf.append(" ,medico.med_conselho             ");
        buf.append(" ,medico.med_crm                  ");
        buf.append(" ,medico.med_uf                   ");
        buf.append(" ,medico.med_nome                 ");
        buf.append(" ,medico.med_abrev                ");
        buf.append(" ,medico.med_tipo                 ");
        buf.append(" ,medico.med_comissao             ");
        buf.append(" ,medico.med_cep                  ");
        buf.append(" ,medico.med_complemento          ");
        buf.append(" ,medico.med_endereco             ");
        buf.append(" ,medico.med_numeroendereco        ");
        buf.append(" ,medico.med_tipologradouroendereco ");
        buf.append(" ,medico.med_celular              ");
        buf.append(" ,medico.med_fax                  ");
        buf.append(" ,medico.med_fone                 ");
        buf.append(" ,medico.med_email                ");
        buf.append(" ,medico.med_site                 ");
        buf.append(" ,medico.med_senhaweb             ");
        buf.append(" ,cidmedico.cid_codigo            ");
        buf.append(" ,cidmedico.cid_nome              ");
        buf.append(" ,cidmedico.cid_uf                ");
        buf.append(" ,baimedico.bai_codigo            ");
        buf.append(" ,baimedico.bai_descricao         ");
        buf.append(" ,a.est_codigo                    ");
        buf.append(" ,estacoes.est_descricao          ");
        buf.append(" ,a.req_prontuario                ");
        buf.append(" ,sit.sit_codigo                  ");
        buf.append(" ,sit.sit_descricao               ");
        buf.append(" ,a.req_descricaoproduto          ");
        buf.append(" ,a.req_datafabricacao            ");
        buf.append(" ,a.req_numeroregistroproduto     ");
        buf.append(" ,a.req_temperaturacoletaproduto  ");
        buf.append(" ,a.req_numeroloteproduto         ");
        buf.append(" ,a.req_datavalidade              ");
        buf.append(" ,a.req_marcaproduto              ");
        buf.append(" ,a.req_lacreproduto               ");
        buf.append(" ,a.req_lacreprodutocontra         ");
        buf.append(" ,a.req_lacreprodutocontraempresa  ");
        buf.append(" ,a.req_doctoreferenciaproduto     ");
        buf.append(" ,a.req_temperaturarecebimento     ");
        buf.append(" ,a.req_sanitariasproduto          ");
        buf.append(" ,a.req_condicoesambproduto        ");
        buf.append(" ,a.req_procedimentocoletaproduto  ");
        buf.append(" ,a.req_tiporecebimentoproduto     ");
        buf.append(" ,a.req_partidaproduto             ");
        buf.append(" ,a.req_qtdeamostraproduto         ");
        buf.append(" ,a.req_qtdeunidadeproduto         ");
        buf.append(" ,a.unm_codigo                     ");
        buf.append(" ,a.req_datarecebeuguia            ");
        buf.append(" ,a.req_dataguiaconferida          ");
        buf.append(" ,a.req_datarecebimentoproduto     ");
        buf.append(" ,a.req_validadecarteira           ");
        buf.append(" ,a.req_validadeguiarepasse        ");
        buf.append(" ,a.req_validadecarteirarepasse    ");
        buf.append(" ,a.req_datarecebeuguiarepasse     ");
        buf.append(" ,a.req_datacoletaproduto          ");
        buf.append(" ,a.req_horacoletaproduto          ");
        buf.append(" ,unidademedida.unm_descricao      ");
        buf.append(" ,a.emb_codigo                     ");
        buf.append(" ,emb.emb_descricao                ");
        buf.append(" ,paccontatos.pco_nome             ");
        buf.append(" ,paccontatos.pco_cargo            ");
        buf.append(" ,paccontatos.pco_email            ");
        buf.append(" ,paccontatos.pco_fone             ");
        buf.append(" ,ent.ent_fantasia                 ");
        buf.append(" ,ent.ent_cargo                    ");
        buf.append(" ,ent.ent_email                    ");
        buf.append(" ,ent.ent_fone                     ");
        buf.append(" ,ent.ent_razaosocial              ");
        buf.append(" ,ent.ent_endereco                 ");
        buf.append(" ,ent.ent_numeroendereco           ");
        buf.append(" ,ent.ent_tipologradouroendereco   ");
        buf.append(" ,ent.ent_complemento              ");
        buf.append(" ,ent.ent_cep                      ");
        buf.append(" ,ent.ent_cpfcnpj                  ");
        buf.append(" ,cidentidade.cid_nome             ");
        buf.append(" ,cidentidade.cid_uf               ");
        buf.append(" ,baientidade.bai_descricao        ");
        buf.append(" ,paciente.bai_codigocobranca      ");
        buf.append(" ,baicobranca.bai_descricao        ");
        buf.append(" ,paciente.cid_codigocobranca      ");
        buf.append(" ,cidcobranca.cid_nome             ");
        buf.append(" ,cidcobranca.cid_uf               ");
        buf.append(" ,paciente.pac_razaosocial         ");
        buf.append(" ,paciente.pac_cnpj                ");
        buf.append(" ,paciente.pac_ie                  ");
        buf.append(" ,paciente.pac_proprietario        ");
        buf.append(" ,paciente.pac_sif                 ");
        buf.append(" ,paciente.pac_enderecocobranca    ");
        buf.append(" ,paciente.pac_numeroenderecocobranca  ");
        buf.append(" ,paciente.pac_tipologradouroendcobranca ");
        buf.append(" ,paciente.pac_complementocobranca ");
        buf.append(" ,paciente.pac_cepcobranca         ");
        buf.append(" ,paciente.pac_fonecobranca        ");
        buf.append(" ,paciente.pac_responsavelcobranca ");
        buf.append(" ,paciente.pac_passaporte ");
        buf.append(" ,orc.orc_codigo                   ");
        buf.append(" ,orc.orc_datahora                 ");
        buf.append(" ,orc.orc_observacao               ");
        buf.append(" ,orc.orc_validade                 ");
        buf.append(" ,orc.orc_solicitante              ");
        buf.append(" ,orc.orc_contato                  ");
        buf.append(" ,orc.orc_fone                     ");
        buf.append(" ,orc.orc_email                    ");
        buf.append(" ,orc.orc_fonecontato              ");
        buf.append(" ,orc.orc_proprietario             ");
        buf.append(" ,convenio.con_percpgto            ");
        buf.append(" ,a.fil_codigo                     ");
        buf.append(" ,a.req_cartaosus                  ");
        buf.append(" ,paciente.pac_cartaosus           ");
        buf.append(" ,a.req_idade * (case when a.req_anomes='A' then 365 when a.req_anomes='M' then 30 else 1 end) ");
        buf.append(" ,idg.ige_descricao ");
        buf.append(" order by ");
        if (ordemSelecionada == null || ordemSelecionada.equals(ordem[0])) {
            buf.append("a.req_codigo ");
        } else if (ordemSelecionada.equals(ordem[1])) {
            buf.append("a.req_data, a.req_hora, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[2])) {
            buf.append("paciente.pac_nome, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[3])) {
            buf.append("convenio.con_fantasia, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[4])) {
            buf.append("medico.med_nome, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[5])) {
            buf.append("a.est_codigo, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[6])) {
            buf.append("usrrequisicao.usr_codigo, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[7])) {
            buf.append("a.est_codigo, usrrequisicao.usr_codigo, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[8])) {
            buf.append("paciente.pac_codigo, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[9])) {
            buf.append("a.req_idade * (case when a.req_anomes='A' then 365 when a.req_anomes='M' then 30 else 1 end), a.req_codigo");
        }
        return buf.toString();
    }

    private Double getValorTotalExamesRequisicaoParaFatura(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select sum(calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, COALESCE(exg.exa_codfilho, exr.exa_codigo), COALESCE(exg.mco_codfilho, exr.mco_codigo), true, coalesce(convenio.con_percpgto, 0) = 0, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ");
        buf.append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(")) as valorTotalFaturarRequisicao ");
        buf.append(" from requisicao a ");
        buf.append(" left join examerequisicao exr on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo ");
        buf.append(" left join examerequisicaoguiaagrupada exg on exr.fil_codigo = exg.fil_codigo and exr.req_codigo = exg.req_codigo and exr.exa_codigo = exg.exa_codigo and exr.mco_codigo = exg.mco_codigo ");
        buf.append(" left join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append("   and a.req_codigo = ").append(requisicao);
        buf.append("   and exr.exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        return rs.next() ? rs.getDouble(1) : 0.0;
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == 0) {
            return Long.parseLong("0823300100");
        }
        return Long.parseLong("0880102200");
    }

    public static long getModuloConfigurar(int tipo) {
        if (tipo == 0) {
            return Long.parseLong("0823300101");
        }
        return Long.parseLong("0880102201");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQuantidadeAlteracoesRequisicao(Statement st, String filial, String requisicao) throws SQLException {
        int retorno = 0;
        StringBuilder bui = new StringBuilder();
        bui.append("select count(req_codigo) from requisicaolog ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and rlo_tipo = '").append("A").append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? rs.getInt(1) : 0;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQuantidadeAlteracoesRequisicaoComConferencia(Statement st, String filial, String requisicao) throws SQLException {
        int retorno = 0;
        StringBuilder bui = new StringBuilder();
        bui.append("select count(req_codigo) from requisicaolog ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(requisicao);
        bui.append(" and rlo_tipo = '").append("C").append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            retorno = rs.next() ? rs.getInt(1) : 0;
        }
        return retorno;
    }
}

