/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRequisicoesContrassenhas
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Nome Paciente", "Conv\u00eanio", "M\u00e9dico", "Esta\u00e7\u00e3o", "Usu\u00e1rio"};
    private static final String[] situacaoPago = new String[]{"Todas", "Em aberto", "Pago parcial", "Pago Total"};
    private final String[] situacao = new String[]{Tipos.tipoSituacaoExame("Sem resultado"), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P")};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_ESTACAO = "filtroEstacao";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_SITUACAO_CADASTRO = "filtroSituacaoRequisicao";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_DEVE_GUIA = "deveGuia";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_SITUACAO_PAGO = "filtroSituacaoPago";
    private static final String FILTRO_VIP = "filtroVIP";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_TODOS_EXAMES_MESMA_SITUACAO = "filtroTodosExamesMesmaSituacao";
    private static final String NUMERICO = "numerico";
    private static final String ALFANUMERICO = "alfanumerico";
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "horaRequisicao", "dataAberturaRequisicao", "urgenteRequisicao", "coletadoRequisicao", "totalPagoRequisicao", "totalRequisicao", "dataFaturaRequisicao", "horaFaturaRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "totalTaxaRequisicao", "valorTotalFaturarRequisicao", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "celularPaciente", "fonePaciente", "foneContatoPaciente", "contatoPaciente", "cepPaciente", "enderecoPaciente", "numeroEndereoPaciente", "emailPaciente", "idadePaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "descricaoExames", "codigoExames", "quantidadeExameRequisicao", "descricaoSetor", "codigoSetor", "codigoDestino", "descricaoDestino", "codigoColeta", "descricaoColeta", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "codigoEstacao", "descricaoEstacao", "codigoOrcamento", "dataHoraOrcamento", "observacaoOrcamento", "validadeOrcamento"});

    public RelatorioRequisicoesContrassenhas() {
        this.setName("RelatorioRequisicoesContrassenhas");
        this.montaBarraDescricao("Relat\u00f3rio de contrassenhas de pagamento m\u00ednimo", "Listagem das contrassenhas de pagamento m\u00ednimo de requisi\u00e7\u00f5es liberadas no per\u00edodo", "relatorios/rel_ger_pagamento_minimo.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.adicionaFiltroCombo(FILTRO_SITUACAO_PAGO, "Sit. pgtos:", situacaoPago, 0);
        this.setModuloConfigurar(RelatorioRequisicoesContrassenhas.getModuloConfigurar());
        this.setModuloAcesso(RelatorioRequisicoesContrassenhas.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        try {
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            String[] estacoes = this.getSelecionadosFiltro(FILTRO_ESTACAO, 0);
            String[] usuarios = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
            String[] destinos = this.getSelecionadosFiltro(FILTRO_DESTINO, 0);
            String[] coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0);
            String[] convenios = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            String[] medicosConselho = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0);
            String[] medicosCrm = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1);
            String[] medicosUf = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2);
            String[] setores = this.getSelecionadosFiltro(FILTRO_SETOR, 0);
            String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
            String horaInicial = this.getFiltroHora(FILTRO_HORA_INICIAL);
            String horaFinal = this.getFiltroHora(FILTRO_HORA_FINAL);
            String situacaoExame = this.getFiltroCombo(FILTRO_SITUACAO).toString();
            String ordemAtual = this.getFiltroCombo(FILTRO_ORDEM).toString();
            String sitPagamento = this.getFiltroCombo(FILTRO_SITUACAO_PAGO).toString();
            this.setCursor(Cursor.getPredefinedCursor(3));
            String sql = this.getSelect(filiais, estacoes, usuarios, destinos, coletas, convenios, medicosConselho, medicosCrm, medicosUf, setores, dataInicial, dataFinal, horaInicial, horaFinal, situacaoExame, ordemAtual, sitPagamento);
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int cont = 0; cont < this.campos.length; ++cont) {
                        o[cont] = rs.getObject(this.campos[cont]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    Conexao.fecharStatement(st, st2);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                StringBuilder buf = new StringBuilder();
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioRequisicoesContrassenhas.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioRequisicoesContrassenhas.this.panelCentro.removeAll();
                            RelatorioRequisicoesContrassenhas.this.panelCentro.repaint();
                            RelatorioRequisicoesContrassenhas.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO).toString());
                    var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM).toString());
                    var.put(FILTRO_SITUACAO_PAGO, this.getFiltroCombo(FILTRO_SITUACAO_PAGO).toString());
                    var.put(FILTRO_DATA_INICIAL, dataInicial);
                    var.put(FILTRO_DATA_FINAL, dataFinal);
                    var.put(FILTRO_HORA_INICIAL, horaInicial);
                    var.put(FILTRO_HORA_FINAL, horaFinal);
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (estacoes != null) {
                        for (i = 0; i < estacoes.length; ++i) {
                            buf.append(estacoes[i]);
                            if (i >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_ESTACAO, buf.toString());
                    buf.delete(0, buf.length());
                    if (usuarios != null) {
                        for (i = 0; i < usuarios.length; ++i) {
                            buf.append(usuarios[i]);
                            if (i >= usuarios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_USUARIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_DESTINO, buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_COLETA, buf.toString());
                    buf.delete(0, buf.length());
                    if (convenios != null) {
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (medicosCrm != null && medicosUf != null) {
                        for (i = 0; i < medicosCrm.length; ++i) {
                            buf.append(medicosConselho[i]).append(": ");
                            buf.append(medicosCrm[i]);
                            buf.append("(");
                            buf.append(medicosUf[i]);
                            buf.append(")");
                            if (i >= medicosCrm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_MEDICO, buf.toString());
                    buf.delete(0, buf.length());
                    if (setores != null) {
                        for (i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_SETOR, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st, st2);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getSelect(String[] filiais, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] setores, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String situacaoExame, String ordemSelecionada, String situacaoPagamento) {
        StringBuilder buf = new StringBuilder();
        buf.append("select");
        buf.append(" req.req_codigo as codigoRequisicao,");
        buf.append(" req.req_data as dataRequisicao,");
        buf.append(" req.req_hora as horaRequisicao,");
        buf.append(" req.req_datarequisicao as dataAberturaRequisicao,");
        buf.append(" req.req_urgente as urgenteRequisicao,");
        buf.append(" req.req_telacoleta as coletadoRequisicao,");
        buf.append(" req.req_totpago as totalPagoRequisicao,");
        buf.append(" req.req_total as totalRequisicao,");
        buf.append(" req.req_dtfatura as dataFaturaRequisicao,");
        buf.append(" req.req_horafatura as horaFaturaRequisicao,");
        buf.append(" req.req_vlracrescimo as valorAcrescimoRequisicao,");
        buf.append(" req.req_acrescimo as percentualAcrescimoRequisicao,");
        buf.append(" req.req_vlrdesconto as valorDescontoRequisicao,");
        buf.append(" req.req_desconto as percentualDescontoRequisicao,");
        buf.append(" req.req_totaltaxa as totalTaxaRequisicao,");
        buf.append(" calculo.valor as valorTotalFaturarRequisicao,");
        buf.append(" usr.usr_codigo as codigoUsuarioRequisicao,");
        buf.append(" usr.usr_nome as nomeUsuarioRequisicao,");
        buf.append(" pac.pac_codigo as codigoPaciente,");
        buf.append(" pac.pac_nome as nomePaciente,");
        buf.append(" pac.pac_nomesocial as nomeSocialPaciente,");
        buf.append(" pac.pac_celular as celularPaciente,");
        buf.append(" pac.pac_fone as fonePaciente,");
        buf.append(" pac.pac_fonecontato as foneContatoPaciente,");
        buf.append(" pac.pac_nomecontato as contatoPaciente,");
        buf.append(" pac.pac_cep as cepPaciente,");
        buf.append(" pac.pac_endereco as enderecoPaciente,");
        buf.append(" pac.pac_numeroendereco as numeroEndereoPaciente,");
        buf.append(" pac.pac_email as emailPaciente,");
        buf.append(" pac.pac_idade as idadePaciente,");
        buf.append(" pac.cid_codigo as codigoCidadePaciente,");
        buf.append(" cid.cid_nome as descricaoCidadePaciente,");
        buf.append(" cid.cid_uf as estadoCidadePaciente,");
        buf.append(" pac.bai_codigo as codigoBairroPaciente,");
        buf.append(" bai.bai_descricao as descricaoBairroPaciente,");
        buf.append(" med.med_crm as crmMedico,");
        buf.append(" med.med_conselho as conselhoMedico,");
        buf.append(" med.med_uf as ufMedico,");
        buf.append(" med.med_nome as nomeMedico,");
        buf.append(" med.med_abrev as abreviaturaMedico,");
        buf.append(" med.med_tipo as tipoMedico,");
        buf.append(" med.med_comissao as comissaoMedico,");
        buf.append(" infoexames.descricaoExames,");
        buf.append(" infoexames.codigoExames,");
        buf.append(" infoexames.quantidade as quantidadeExameRequisicao,");
        buf.append(" array_to_string(array_agg(seto.set_descricao),', ') as descricaoSetor,");
        buf.append(" array_to_string(array_agg(exaset.set_codigo),', ') as codigoSetor,");
        buf.append(" req.des_codigo as codigoDestino,");
        buf.append(" des.des_descricao as descricaoDestino,");
        buf.append(" req.col_codigo as codigoColeta,");
        buf.append(" col.col_descricao as descricaoColeta,");
        buf.append(" req.con_codigo as codigoConvenio,");
        buf.append(" con.con_razao as razaoSocialConvenio,");
        buf.append(" con.con_fantasia as fantasiaConvenio,");
        buf.append(" con.con_cnpjcpf as cnpjConvenio,");
        buf.append(" con.con_tppgto as tipoPagamentoConvenio,");
        buf.append(" req.est_codigo as codigoEstacao,");
        buf.append(" est.est_descricao as descricaoEstacao,");
        buf.append(" req.orc_codigo as codigoOrcamento,");
        buf.append(" orc.orc_datahora as dataHoraOrcamento,");
        buf.append(" orc.orc_observacao as observacaoOrcamento,");
        buf.append(" orc.orc_validade as validadeOrcamento,");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from");
        buf.append(" requisicao req");
        buf.append(" left join (");
        buf.append(" select");
        buf.append(" sum(");
        buf.append(" calculaprecototalexamerequisicao(");
        buf.append(" a.fil_codigo,");
        buf.append(" a.con_codigo,");
        buf.append(" a.req_codigo,");
        buf.append(" COALESCE(");
        buf.append(" exg.exa_codfilho,");
        buf.append(" exr.exa_codigo");
        buf.append(" ),");
        buf.append(" COALESCE(");
        buf.append(" exg.mco_codfilho,");
        buf.append(" exr.mco_codigo");
        buf.append(" ),");
        buf.append(" true,");
        buf.append(" coalesce(");
        buf.append(" convenio.con_percpgto,");
        buf.append(" 0");
        buf.append(" ) = 0,");
        buf.append(" true,");
        buf.append(" exr.exr_vlrchexame,");
        buf.append(" exr.exr_vlrch,");
        buf.append(" exr.exr_valorporte,");
        buf.append(" exr.exr_valorcusto,");
        buf.append(" exr.exr_valoruco,");
        buf.append(" exr.exr_vlrbalcaoconvenio,");
        buf.append(" exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL,");
        buf.append(" exr.exr_vlrmaterial,");
        buf.append(" exr.exr_vlrbalcaoconvenio,");
        buf.append(" convenio.con_precosdiferenciados,");
        buf.append(" convenio.con_reajuste,");
        buf.append(" convenio.con_cobrmaterial,");
        buf.append(" convenio.con_percpgtomaterial,");
        buf.append(" convenio.con_percpgto,");
        buf.append(" convenio.con_tpcalcfatu,");
        buf.append(" convenio.con_tpcalcch,");
        buf.append(" convenio.con_perguntarpercbalcao,");
        buf.append(" convenio.con_acrescimo,");
        buf.append(" convenio.con_bonus,");
        buf.append(" convenio.tpe_codigo,");
        buf.append(" convenio.con_acrescimoporte,");
        buf.append(" convenio.con_acrescimouco,");
        buf.append(" convenio.con_descontoporte,");
        buf.append(" convenio.con_descontouco,");
        buf.append(" convenio.con_valorch,");
        buf.append(ParametrosGerais.getCasasPrecoExame()).append(",");
        buf.append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(",");
        buf.append(ParametrosGerais.getPrecoMetodologia() ? "true," : "false,");
        buf.append(" exr.met_codigo )) as valor,");
        buf.append(" a.fil_codigo,");
        buf.append(" a.req_codigo");
        buf.append(" from requisicao a");
        buf.append(" left join examerequisicao exr on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo");
        buf.append(" left join examerequisicaoguiaagrupada exg on exr.fil_codigo = exg.fil_codigo and exr.req_codigo = exg.req_codigo and exr.exa_codigo = exg.exa_codigo  and exr.mco_codigo = exg.mco_codigo");
        buf.append(" left join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo");
        buf.append(" where exr.exr_excluido = false");
        if (!this.contemValor(filiais)) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" and a.fil_codigo in ( ").append(this.formataString(filiais, NUMERICO)).append(" )");
        if (this.contemValor(dataInicial) && Funcoes.verificaData(dataInicial)) {
            buf.append(" and a.req_data >= '").append(Funcoes.formataData("MM/dd/yyyy", dataInicial)).append("'");
        }
        if (this.contemValor(dataFinal) && Funcoes.verificaData(dataFinal)) {
            buf.append(" and a.req_data <= '").append(Funcoes.formataData("MM/dd/yyyy", dataFinal)).append("'");
        }
        if (this.contemValor(horaInicial) && Funcoes.verificaHora(horaInicial)) {
            buf.append(" and a.req_hora >= '").append(horaInicial).append("'");
        }
        if (this.contemValor(horaFinal) && Funcoes.verificaHora(horaFinal)) {
            buf.append(" and a.req_hora <= '").append(horaFinal).append("'");
        }
        if (situacaoExame.equals(this.situacao[0])) {
            buf.append(" and (exr.exr_situacao = '' or exr.exr_situacao is null or exr.exr_situacao = ' ')");
        } else {
            buf.append(" and exr.exr_situacao = '");
            if (situacaoExame.equals(this.situacao[1])) {
                buf.append("T");
            } else if (situacaoExame.equals(this.situacao[2])) {
                buf.append("F");
            } else if (situacaoExame.equals(this.situacao[3])) {
                buf.append("R");
            } else if (situacaoExame.equals(this.situacao[4])) {
                buf.append("L");
            } else if (situacaoExame.equals(this.situacao[5])) {
                buf.append("C");
            } else if (situacaoExame.equals(this.situacao[6])) {
                buf.append("O");
            } else if (situacaoExame.equals(this.situacao[7])) {
                buf.append("I");
            } else if (situacaoExame.equals(this.situacao[8])) {
                buf.append("E");
            } else if (situacaoExame.equals(this.situacao[9])) {
                buf.append("A");
            } else if (situacaoExame.equals(this.situacao[10])) {
                buf.append("P");
            }
            buf.append("'");
        }
        if (!situacaoPagamento.equals(situacaoPago[0])) {
            if (situacaoPagamento.equals(situacaoPago[1])) {
                buf.append(" and a.req_totpago = 0 ");
            } else if (situacaoPagamento.equals(situacaoPago[2])) {
                buf.append(" and (a.req_totpago > 0 and a.req_totpago < a.req_total) ");
            } else if (situacaoPagamento.equals(situacaoPago[3])) {
                buf.append(" and a.req_totpago >= a.req_total");
            }
        }
        buf.append(" group by a.fil_codigo, a.req_codigo) as calculo on req.fil_codigo = calculo.fil_codigo and req.req_codigo = calculo.req_codigo");
        buf.append(" left join usuario usr on req.fil_codigo = usr.fil_codigo and req.usr_codigo = usr.usr_codigo");
        buf.append(" left join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo");
        buf.append(" left join cidades cid on req.fil_codigo = cid.fil_codigo and pac.cid_codigo = cid.cid_codigo");
        buf.append(" left join bairro bai on req.fil_codigo = bai.fil_codigo and pac.bai_codigo = bai.bai_codigo");
        buf.append(" left join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_uf = med.med_uf and req.med_conselho = med.med_conselho");
        buf.append(" left join examerequisicao exareq on req.fil_codigo = exareq.fil_codigo and req.req_codigo = exareq.req_codigo and exareq.exr_excluido = false");
        buf.append(" left join examesetor exaset on req.fil_codigo = exaset.fil_codigo and exareq.exa_codigo = exaset.exa_codigo");
        buf.append(" left join setores seto on req.fil_codigo = seto.fil_codigo and exaset.set_codigo = seto.set_codigo");
        buf.append(" left join destino des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo");
        buf.append(" left join coletas col on req.fil_codigo = col.fil_codigo and req.col_codigo = col.col_codigo");
        buf.append(" left join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo");
        buf.append(" left join estacoes est on req.fil_codigo = est.fil_codigo and req.est_codigo = est.est_codigo");
        buf.append(" left join orcamento orc on req.fil_codigo = orc.fil_codigo and req.orc_codigo = orc.orc_codigo");
        buf.append(" left join ( select count(*) as quantidade, exareq.req_codigo, exareq.fil_codigo, array_to_string(array_agg(exa.exa_descricao),', ') as descricaoExames,");
        buf.append(" array_to_string(array_agg(exa.exa_codigo),', ') as codigoExames");
        buf.append(" from examerequisicao exareq left join exames exa on exareq.fil_codigo = exa.fil_codigo and exareq.exa_codigo = exa.exa_codigo");
        buf.append(" where exareq.exr_excluido = false");
        if (!this.contemValor(filiais)) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" and exareq.fil_codigo in ( ").append(this.formataString(filiais, NUMERICO)).append(" )");
        if (situacaoExame.equals(this.situacao[0])) {
            buf.append(" and (exareq.exr_situacao = '' or exareq.exr_situacao is null or exareq.exr_situacao = ' ')");
        } else {
            buf.append(" and exareq.exr_situacao = '");
            if (situacaoExame.equals(this.situacao[1])) {
                buf.append("T");
            } else if (situacaoExame.equals(this.situacao[2])) {
                buf.append("F");
            } else if (situacaoExame.equals(this.situacao[3])) {
                buf.append("R");
            } else if (situacaoExame.equals(this.situacao[4])) {
                buf.append("L");
            } else if (situacaoExame.equals(this.situacao[5])) {
                buf.append("C");
            } else if (situacaoExame.equals(this.situacao[6])) {
                buf.append("O");
            } else if (situacaoExame.equals(this.situacao[7])) {
                buf.append("I");
            } else if (situacaoExame.equals(this.situacao[8])) {
                buf.append("E");
            } else if (situacaoExame.equals(this.situacao[9])) {
                buf.append("A");
            } else if (situacaoExame.equals(this.situacao[10])) {
                buf.append("P");
            }
            buf.append("'");
        }
        buf.append(" group by exareq.req_codigo, exareq.fil_codigo ) as infoexames on req.fil_codigo = infoexames.fil_codigo and req.req_codigo = infoexames.req_codigo");
        buf.append(" left join filiais_postocoleta filial on req.fil_codigo = filial.fil_codigo");
        buf.append(" left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo");
        buf.append(" left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo");
        buf.append(" where");
        if (!this.contemValor(filiais)) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" req.fil_codigo in ( ").append(this.formataString(filiais, NUMERICO)).append(" )");
        buf.append(" and exareq.exr_excluido = 'f'");
        if (this.contemValor(estacoes)) {
            buf.append(" and est.est_codigo in ( ").append(this.formataString(estacoes, NUMERICO)).append(" )");
        }
        if (this.contemValor(usuarios)) {
            buf.append(" and usr.usr_codigo in ( ").append(this.formataString(usuarios, ALFANUMERICO)).append(" )");
        }
        if (this.contemValor(destinos)) {
            buf.append(" and des.des_codigo in ( ").append(this.formataString(destinos, ALFANUMERICO)).append(" )");
        }
        if (this.contemValor(coletas)) {
            buf.append(" and col.col_codigo in ( ").append(this.formataString(coletas, ALFANUMERICO)).append(" )");
        }
        if (this.contemValor(convenios)) {
            buf.append(" and con.con_codigo in ( ").append(this.formataString(convenios, NUMERICO)).append(" )");
        }
        if (this.contemValor(medicosConselho) && medicosConselho.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (int cont = 0; cont < medicosConselho.length; ++cont) {
                buf.append(" (med.med_conselho = '").append(medicosConselho[cont]);
                buf.append("' and med.med_crm = '").append(medicosCrm[cont]);
                buf.append("' and med.med_uf = '").append(medicosUF[cont]);
                buf.append("')");
                if (!this.adicionarCondicao(cont, medicosConselho.length)) continue;
                buf.append(" or");
            }
            buf.append(")");
        }
        if (this.contemValor(setores)) {
            buf.append(" and seto.set_codigo in ( ").append(this.formataString(setores, NUMERICO)).append(" )");
        }
        if (this.contemValor(dataInicial) && Funcoes.verificaData(dataInicial)) {
            buf.append(" and req.req_data >= '").append(Funcoes.formataData("MM/dd/yyyy", dataInicial)).append("'");
        }
        if (this.contemValor(dataFinal) && Funcoes.verificaData(dataFinal)) {
            buf.append(" and req.req_data <= '").append(Funcoes.formataData("MM/dd/yyyy", dataFinal)).append("'");
        }
        if (this.contemValor(horaInicial) && Funcoes.verificaHora(horaInicial)) {
            buf.append(" and req.req_hora >= '").append(horaInicial).append("'");
        }
        if (this.contemValor(horaFinal) && Funcoes.verificaHora(horaFinal)) {
            buf.append(" and req.req_hora <= '").append(horaFinal).append("'");
        }
        if (situacaoExame.equals(this.situacao[0])) {
            buf.append(" and (exareq.exr_situacao = '' or exareq.exr_situacao is null or exareq.exr_situacao = ' ')");
        } else {
            buf.append(" and exareq.exr_situacao = '");
            if (situacaoExame.equals(this.situacao[1])) {
                buf.append("T");
            } else if (situacaoExame.equals(this.situacao[2])) {
                buf.append("F");
            } else if (situacaoExame.equals(this.situacao[3])) {
                buf.append("R");
            } else if (situacaoExame.equals(this.situacao[4])) {
                buf.append("L");
            } else if (situacaoExame.equals(this.situacao[5])) {
                buf.append("C");
            } else if (situacaoExame.equals(this.situacao[6])) {
                buf.append("O");
            } else if (situacaoExame.equals(this.situacao[7])) {
                buf.append("I");
            } else if (situacaoExame.equals(this.situacao[8])) {
                buf.append("E");
            } else if (situacaoExame.equals(this.situacao[9])) {
                buf.append("A");
            } else if (situacaoExame.equals(this.situacao[10])) {
                buf.append("P");
            }
            buf.append("'");
        }
        if (!situacaoPagamento.equals(situacaoPago[0])) {
            if (situacaoPagamento.equals(situacaoPago[1])) {
                buf.append(" and req.req_totpago = 0 ");
            } else if (situacaoPagamento.equals(situacaoPago[2])) {
                buf.append(" and (req.req_totpago > 0 and req.req_totpago < req.req_total) ");
            } else if (situacaoPagamento.equals(situacaoPago[3])) {
                buf.append(" and req.req_totpago >= req.req_total");
            }
        }
        buf.append(" group by ");
        buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buf.append(", codigoRequisicao,");
        buf.append(" dataRequisicao,");
        buf.append(" horaRequisicao,");
        buf.append(" dataAberturaRequisicao,");
        buf.append(" urgenteRequisicao,");
        buf.append(" coletadoRequisicao,");
        buf.append(" totalPagoRequisicao,");
        buf.append(" totalRequisicao,");
        buf.append(" dataFaturaRequisicao,");
        buf.append(" horaFaturaRequisicao,");
        buf.append(" valorAcrescimoRequisicao,");
        buf.append(" percentualAcrescimoRequisicao,");
        buf.append(" valorDescontoRequisicao,");
        buf.append(" percentualDescontoRequisicao,");
        buf.append(" totalTaxaRequisicao,");
        buf.append(" valorTotalFaturarRequisicao,");
        buf.append(" codigoUsuarioRequisicao,");
        buf.append(" nomeUsuarioRequisicao,");
        buf.append(" codigoPaciente,");
        buf.append(" nomePaciente,");
        buf.append(" nomeSocialPaciente,");
        buf.append(" celularPaciente,");
        buf.append(" fonePaciente,");
        buf.append(" foneContatoPaciente,");
        buf.append(" contatoPaciente,");
        buf.append(" cepPaciente,");
        buf.append(" enderecoPaciente,");
        buf.append(" numeroEndereoPaciente,");
        buf.append(" emailPaciente,");
        buf.append(" idadePaciente,");
        buf.append(" codigoCidadePaciente,");
        buf.append(" descricaoCidadePaciente,");
        buf.append(" estadoCidadePaciente,");
        buf.append(" codigoBairroPaciente,");
        buf.append(" descricaoBairroPaciente,");
        buf.append(" crmMedico,");
        buf.append(" conselhoMedico,");
        buf.append(" ufMedico,");
        buf.append(" nomeMedico,");
        buf.append(" abreviaturaMedico,");
        buf.append(" tipoMedico,");
        buf.append(" comissaoMedico,");
        buf.append(" infoexames.descricaoExames,");
        buf.append(" infoexames.codigoExames,");
        buf.append(" quantidadeExameRequisicao,");
        buf.append(" codigoDestino,");
        buf.append(" descricaoDestino,");
        buf.append(" codigoColeta,");
        buf.append(" descricaoColeta,");
        buf.append(" codigoConvenio,");
        buf.append(" razaoSocialConvenio,");
        buf.append(" fantasiaConvenio,");
        buf.append(" cnpjConvenio,");
        buf.append(" tipoPagamentoConvenio,");
        buf.append(" codigoEstacao,");
        buf.append(" descricaoEstacao,");
        buf.append(" codigoOrcamento,");
        buf.append(" dataHoraOrcamento,");
        buf.append(" observacaoOrcamento,");
        buf.append(" validadeOrcamento");
        buf.append(" order by");
        if (ordemSelecionada.equals(ordem[0])) {
            buf.append(" req.req_codigo ");
        } else if (ordemSelecionada.equals(ordem[1])) {
            buf.append(" req.req_data, req.req_hora, req.req_codigo");
        } else if (ordemSelecionada.equals(ordem[2])) {
            buf.append(" UPPER(pac.pac_nome), req.req_codigo");
        } else if (ordemSelecionada.equals(ordem[3])) {
            buf.append(" UPPER(con.con_fantasia), req.req_codigo");
        } else if (ordemSelecionada.equals(ordem[4])) {
            buf.append(" UPPER(med.med_nome), req.req_codigo");
        } else if (ordemSelecionada.equals(ordem[5])) {
            buf.append(" UPPER(est.est_descricao), req.req_codigo");
        } else if (ordemSelecionada.equals(ordem[6])) {
            buf.append(" UPPER(usr.usr_codigo), req.req_codigo");
        }
        return buf.toString();
    }

    private boolean adicionarCondicao(int cont, int quantidade) {
        return cont + 1 < quantidade;
    }

    private String formataString(String[] s, String tipo) {
        String resultado = "";
        for (String ss : s) {
            StringBuilder sb = new StringBuilder(resultado);
            if (tipo.equals(NUMERICO)) {
                resultado = sb.append(ss).append(",").toString();
                continue;
            }
            if (!tipo.equals(ALFANUMERICO)) continue;
            resultado = sb.append(StringUtil.textoDBEscape(ss)).append(",").toString();
        }
        resultado = resultado.substring(0, resultado.length() - 1);
        return resultado;
    }

    private boolean contemValor(String[] s) {
        return s != null && s.length > 0;
    }

    private boolean contemValor(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880101703");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880101704");
    }
}

