/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.relatorios.recepcao.RetornoRelatorioRequisicoes;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.service.relatorio.recepcao.RelatorioRequisicoesService;
import jalis.service.resultados.RequisicaoPaginasImpressasService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.postgresql.util.PGInterval;

public class RelatorioRequisicoes
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String PARAMETRO_MEDICO = "medico";
    private static final String PARAMETRO_PACIENTE = "paciente";
    private static final String PARAMETRO_URGENTE = "urgente";
    private static final String PARAMETRO_CONSIDERAR_RESPOSTAS = "considerarRespostas";
    private static final String PARAMETRO_EXAMES_MESMA_SITUACAO = "examesMesmaSituacao";
    private static final String PARAMETRO_NAO_TRIADAS = "naoTriadas";
    private static final String PARAMETRO_VIP = "vip";
    private static final String PARAMETRO_AVISAR_PACIENTE = "avisarPaciente";
    private static final String PARAMETRO_SITUACAO_REQUISICAO = "situacaoExame";
    private static final String PARAMETRO_DATA = "data";
    private static final String PARAMETRO_PACIENTES = "pacientes";
    private static final String PARAMETRO_INTERVALO_HORA = "intervaloHora";
    private static final String PARAMETRO_DEVE_GUIA = "deveGuia";
    private static final String PARAMETRO_SIT_PGTO = "sitPgto";
    private static final String PARAMETRO_ORDEM = "ordem";
    private static final String PARAMETRO_CAMPO_DATA = "campoData";
    private static final String PARAMETRO_HORA_FINAL = "horafinal";
    private static final String PARAMETRO_HORA_INICIAL = "horainicial";
    private static final String PARAMETRO_DATA_FINAL = "datafinal";
    private static final String PARAMETRO_DATA_INICIAL = "datainicial";
    private static final String PARAMETRO_UNIDADE_SAUDE = "unidadeSaude";
    private static final String PARAMETRO_SITUACAO = "situacao";
    private static final String PARAMETRO_SETORES = "setores";
    private static final String PARAMETRO_EXAME = "exame";
    private static final String PARAMETRO_MEDICOS = "medicos";
    private static final String PARAMETRO_CONVENIO = "convenio";
    private static final String PARAMETRO_COLETA = "coleta";
    private static final String PARAMETRO_DESTINO = "destino";
    private static final String PARAMETRO_USUARIO = "usuario";
    private static final String PARAMETRO_ESTACOES = "estacoes";
    private static final String PARAMETRO_FILIAL = "filial";
    private static final String PARAMETRO_DATA_COLETA = "Coleta";
    private static final String PARAMETRO_SEXO = "sexo";
    private static final String PARAMETRO_REQUI_INTERFACEAMENTO = "requisicoesInterfaceamento";
    private static final String PARAMETRO_REQUISICAO_TAXAS = "requisicaoTaxas";
    private static final String PARAMETRO_RESULTADO_CRITICO = "resultadoCritico";
    private static final String PARAMETRO_APENAS_LOTE_EXTERNO = "apenasLoteExterno";
    private static HashMap<String, String> MAPA_TODOS_CAMPOS_DISPONIVEIS = new HashMap();
    private static String LIGACOES = "";
    private static HashMap<String, String> camposUtilizados = new HashMap();
    private static String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Nome Paciente", "Conv\u00eanio", "M\u00e9dico", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Setor", "Filial + Requisi\u00e7\u00e3o", "Esta\u00e7\u00e3o + Usu\u00e1rio", "Cod.Paciente", "Req. + Adi\u00e7\u00e3o"};
    private static final String[] campoData = new String[]{"Requisi\u00e7\u00e3o", "Coleta"};
    private static final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P"), Tipos.tipoSituacaoExame("N")};
    private static final String[] situacaoPago = new String[]{"Todas", "Em aberto", "Pago parcial", "Pago Total"};
    private static final String[] filtrarPorData = new String[]{"Imp. Laudo", "Imp. Mapa", "Imp. Etq. Coleta", "Imp. Etq. Triagem"};
    private static final String[] dataImpresso = new String[]{"b.exr_dataimpresso", "b.exr_datamapa", "b.exr_dataetqcoleta", "b.exr_dataetqtriagem"};
    private static final String[] filtrosexo = new String[]{"Ambos", "Masculino", "Feminino"};
    private static final String[] campoDataTipoExames = new String[]{"Coleta", "Requisi\u00e7\u00e3o"};
    public static final int TIPO_DATA_LAUDO = 0;
    public static final int TIPO_DATA_MAPA = 1;
    public static final int TIPO_DATA_ETQ_COL = 2;
    public static final int TIPO_DATA_ETQ_TRI = 3;
    public static final int TIPO_PGTO_TODAS = 0;
    public static final int TIPO_PGTO_ABERTAS = 1;
    public static final int TIPO_PGTO_PAGO_PARCIAL = 2;
    public static final int TIPO_PGTO_PAGO_TOTAL = 3;
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_ESTACAO = "filtroEstacao";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_EXAME = "filtroExame";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_CAMPODATA = "campoDataRelatorio";
    private static final String FILTRO_DEVE_GUIA = "deveGuia";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_SITUACAO_REQUISICAO = "filtroSituacaoRequisicao";
    private static final String FILTRO_SOMENTE_NAO_TRIADAS = "filtroSomenteNaoTriadas";
    private static final String FILTRO_SITUACAO_PAGO = "filtroSituacaoPago";
    private static final String FILTRO_VIP = "filtroVIP";
    private static final String FILTRO_POR_DATA = "filtroPorData";
    private static final String FILTRO_EXAME_AVISAR_PACIENTE = "filtroExameAvisarPaciente";
    private static final String FILTRO_TODOS_EXAMES_MESMA_SITUACAO = "filtroTodosExamesMesmaSituacao";
    private static final String FILTRO_URGENTE = "filtroUrgente";
    private static final String FILTRO_CONSIDERAR_RESPOSTAS = "filtroConsiderarRespostas";
    public static final String FILTRO_REQUISICAO_TAXAS = "filtroRequisicaoTaxas";
    public static final String FILTRO_RESULTADO_CRITICO = "filtroResultadosCriticos";
    private static final String FILTRO_UNIDADE_SAUDE = "filtroUnidadeSaude";
    public static final String PARAMETROS_RELATORIO_EXAMES_REALIZADOS = "RelatorioExamesRealizadosSocilitados.ultimoFiltro";
    private static final String FILTRO_ALA = "filtroAla";
    private static final String FILTRO_QUARTO = "filtroQuarto";
    private static final String FILTRO_LEITO = "filtroLeito";
    private static final String FILTRO_PRONTUARIO = "filtroProntuario";
    private static final String FILTRO_SEXO = "filtroSexo";
    private static final String FILTRO_REQUI_INTERFACEAMENTO = "requisicoesInterfaceamento";
    private static final String FILTRO_APENAS_LOTE_EXTERNO = "apenasLoteExterno";
    private static Map<Integer, String> listaUltimoFiltro = new HashMap<Integer, String>();
    public static final int TIPO_ABERTAS = 1;
    public static final int TIPO_A_COLETAR = 2;
    public static final int TIPO_SEM_MATERIAL = 3;
    public static final int TIPO_COLETADAS = 4;
    public static final int TIPO_ENTREGUES = 5;
    public static final int TIPO_AGRUPADO_MEDICO = 6;
    public static final int TIPO_AGRUPADO_CONVENIO = 7;
    public static final int TIPO_IMPRESSAS = 8;
    public static final int TIPO_AVISAR_PACIENTE = 9;
    public static final int TIPO_AGRUPADO_USUARIO = 10;
    public static final int TIPO_RECOLETA = 11;
    public static final int TIPO_NAO_TRIADOS = 12;
    public static final int TIPO_AGRUPADO_PACIENTE = 13;
    public static final int TIPO_REPETICAO = 14;
    public static final int TIPO_EXCLUIDAS = 15;
    public static final int TIPO_AUDITORIA_DE_PRODUCAO = 16;
    public static final int TIPO_CONFERIR_DIGITADA = 17;
    public static final int TIPO_CONFERIDA = 18;
    public static final int TIPO_TRANSPORTE = 19;
    public static final long ACESSO_FILTRARESTACAO = Long.parseLong("0821100102");
    private static final long ACESSO_FILTRARCOLETA = Long.parseLong("0821100103");
    private static final long ACESSO_FILTRARDESTINO = Long.parseLong("0821100104");
    public static final long ACESSO_FILTRARUSUARIO = Long.parseLong("0821100105");
    private static int tipoRelatorio = 1;
    private static PGInterval somaTempoTotalAteColetaExame = null;
    private static PGInterval somaTempoTotalAteDigitacaoExame = null;
    private static PGInterval somaTempoTotalAteConferenciaExame = null;
    private static PGInterval somaTempoTotalAteImpressaoExame = null;
    private static PGInterval somaTempoTotalAteEntregaExame = null;
    private static PGInterval somaTempoTotalColetaAteDigitacaoExame = null;
    private static PGInterval somaTempoTotalColetaAteConferenciaExame = null;
    private static PGInterval somaTempoTotalColetaAteImpressaoExame = null;
    private static PGInterval somaTempoTotalColetaAteEntregaExame = null;
    private static PGInterval somaTempoTotalAteChamadaGuiche = null;
    private static PGInterval somaTempoTotalAteGravacaoRequisicao = null;
    private static PGInterval somaTempoTotalChegadaAteColetaExame = null;
    private static PGInterval somaTempoTotalChegadaAteDigitacaoExame = null;
    private static PGInterval somaTempoTotalChegadaAteConferenciaExame = null;
    private static PGInterval somaTempoTotalChegadaAteEntregaExame = null;
    private static PGInterval somaTempoTotalChegadaAteImpressaoExame = null;
    private static PGInterval mediaTempoTotalColetaAteImpressaoExameRequisicao = null;
    private static PGInterval mediaTempoTotalColetaAteConferenciaExameRequisicao = null;
    private static int qtdeColetaExame = 0;
    private static int qtdeDigitacaoExame = 0;
    private static int qtdeConferenciaExame = 0;
    private static int qtdeImpressaoExame = 0;
    private static int qtdeEntregaExame = 0;
    private static int qtdeColetaDigitacaoExame = 0;
    private static int qtdeColetaConferenciaExame = 0;
    private static int qtdeColetaImpressaoExame = 0;
    private static int qtdeColetaEntregaExame = 0;
    private static int qtdeTempoTotalAteChamadaGuiche = 0;
    private static int qtdeTempoTotalAteGravacaoRequisicao = 0;
    private static int qtdeTempoTotalChegadaAteColetaExame = 0;
    private static int qtdeTempoTotalChegadaAteDigitacaoExame = 0;
    private static int qtdeTempoTotalChegadaAteConferenciaExame = 0;
    private static int qtdeTempoTotalChegadaAteEntregaExame = 0;
    private static int qtdeTempoTotalChegadaAteImpressaoExame = 0;
    private static RelatorioRequisicoesService service;
    public static String[] campos;
    public static final String[] camposAuditoriaProducao;
    public static final String[] camposImpressao;

    public RelatorioRequisicoes(int tipoRelatorio) {
        String[] perguntasFilial;
        service = new RelatorioRequisicoesService();
        this.setName("RelatorioRequisicoes");
        this.listaParametros();
        RelatorioRequisicoes.tipoRelatorio = tipoRelatorio;
        if (RelatorioRequisicoes.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo", "relatorios/rel_requisicao.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 2) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es a coletar", "Listagem das requisi\u00e7\u00f5es a serem coletadas no per\u00edodo", "relatorios/rel_req_acoletar.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 3) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es sem material", "Listagem das requisi\u00e7\u00f5es sem material coletado no per\u00edodo", "relatorios/rel_req_sem_material.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 4) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es coletadas", "Listagem das requisi\u00e7\u00f5es com material coletado no per\u00edodo", "relatorios/rel_req_coletadas.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 5) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es entregues", "Listagem das requisi\u00e7\u00f5es entregues no per\u00edodo", "relatorios/rel_req_entregues.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 8) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es impressas", "Listagem das requisi\u00e7\u00f5es impressas no per\u00edodo", "relatorios/rel_requisicao_impressa.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 6) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es por m\u00e9dico", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo agrupada por m\u00e9dicos", "relatorios/rel_req_medicos.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 7) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es por conv\u00eanio", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo agrupada por conv\u00eanios", "relatorios/rel_req_convenio.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 9) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es para avisar", "Listagem das requisi\u00e7\u00f5es marcadas para avisar o paciente", "relatorios/rel_requisicao_avisar.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 10) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es por usu\u00e1rio", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo agrupada por usu\u00e1rios", "relatorios/rel_req_usuario.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 11) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es para recoleta", "Listagem das requisi\u00e7\u00f5es com o material marcado para recoleta", "relatorios/rel_recoleta.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 14) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es em repeti\u00e7\u00e3o", "Listagem das requisi\u00e7\u00f5es com o exame marcado para repeti\u00e7\u00e3o", "relatorios/rel_repeticao.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 12) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es para triagem", "Listagem das requisi\u00e7\u00f5es com os exames ainda n\u00e3o triados", "relatorios/rel_triagem_req_nao_triadas.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 13) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es por paciente", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo agrupada por pacientes", "relatorios/rel_recep_req_por_paciente.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 16) {
            this.montaBarraDescricao("Relat\u00f3rio de auditoria de produ\u00e7\u00e3o", "Listagem das requisi\u00e7\u00f5es para auditoria de produ\u00e7\u00e3o", "relatorios/rel_auditoria_producao.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 15) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es exclu\u00eddas", "Listagem das requisi\u00e7\u00f5es exclu\u00eddas no per\u00edodo", "relatorios/rel_req_excluida.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 17) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es para conferir", "Listagem das requisi\u00e7\u00f5es para conferir no per\u00edodo", "relatorios/rel_req_conferir.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 18) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es conferidas", "Listagem das requisi\u00e7\u00f5es conferidas no per\u00edodo", "relatorios/rel_req_conferida.jpg");
        } else if (RelatorioRequisicoes.tipoRelatorio == 19) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es em transporte", "Listagem das requisi\u00e7\u00f5es com exames em transporte", "relatorios/rel_requisicao_transporte.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (Acesso.getAcesso(ACESSO_FILTRARESTACAO) || tipoRelatorio != 1) {
            this.adicionaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", PARAMETRO_ESTACOES, "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARUSUARIO) || tipoRelatorio != 1) {
            this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", PARAMETRO_USUARIO, " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARDESTINO) || tipoRelatorio != 1) {
            this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", PARAMETRO_DESTINO, "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARCOLETA) || tipoRelatorio != 1) {
            this.adicionaItemFiltro(FILTRO_COLETA, PARAMETRO_DATA_COLETA, "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", PARAMETRO_MEDICO, "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Cons.", "C\u00f3digo", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", PARAMETRO_SETORES, "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (tipoRelatorio != 8) {
            this.adicionaItemFiltro(FILTRO_SITUACAO_REQUISICAO, "Situa\u00e7\u00e3o", PARAMETRO_SITUACAO, "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro(FILTRO_UNIDADE_SAUDE, "Unidade de Sa\u00fade", "unidadesaude", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"uns_codigo", "uns_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (tipoRelatorio == 12 || tipoRelatorio == 6) {
            this.adicionaFiltroCombo(FILTRO_CAMPODATA, "Campo Data:", campoData, 0);
        }
        if (tipoRelatorio == 13) {
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", PARAMETRO_PACIENTE, "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
            } else {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", PARAMETRO_PACIENTE, "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
            }
        }
        if (tipoRelatorio == 16) {
            this.adicionaItemFiltro(FILTRO_ALA, "Ala", "alahospital", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ala_codigo", "ala_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.adicionaFiltroTexto(FILTRO_QUARTO, "Quarto:", 5);
            this.adicionaFiltroTexto(FILTRO_LEITO, "Leito:", 5);
            this.adicionaFiltroTexto(FILTRO_PRONTUARIO, "Prontu\u00e1rio:", 120);
        }
        if (tipoRelatorio == 8) {
            this.adicionaFiltroCombo(FILTRO_POR_DATA, "Data:", filtrarPorData, 0);
        }
        if (tipoRelatorio == 4) {
            this.adicionaFiltroCombo(FILTRO_CAMPODATA, "Campo Data:", campoDataTipoExames, 0);
        }
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        if (tipoRelatorio == 1 || tipoRelatorio == 9 || tipoRelatorio == 16) {
            this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacao, 0);
        }
        ordem = new String[]{"C\u00f3digo", "Data + Hora", "Nome Paciente", "Conv\u00eanio", "M\u00e9dico", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Setor", "Filial + Requisi\u00e7\u00e3o", "Esta\u00e7\u00e3o + Usu\u00e1rio", "Cod.Paciente", "Req. + Adi\u00e7\u00e3o"};
        if (tipoRelatorio == 3 && ordem.length < 13) {
            ordem = ArraysUtil.concatenar(ordem, new String[]{"Usu\u00e1rio abertura"});
        }
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, tipoRelatorio == 1 ? ordem.length - 1 : 0);
        this.adicionaFiltroCombo(FILTRO_SITUACAO_PAGO, "Sit. pgtos:", situacaoPago, 0);
        this.adicionaFiltroCombo(FILTRO_SEXO, "Sexo", filtrosexo, 0);
        this.adicionarFiltrosCheckTipoRelatorio(tipoRelatorio);
        this.setModuloConfigurar(RelatorioRequisicoesService.getModuloConfigurar(RelatorioRequisicoes.tipoRelatorio));
        this.setModuloAcesso(RelatorioRequisicoesService.getModuloAcesso(RelatorioRequisicoes.tipoRelatorio));
        String[] camposFinal = campos;
        if (RelatorioRequisicoes.tipoRelatorio == 16) {
            camposFinal = ArraysUtil.concatenar(campos, camposAuditoriaProducao);
        }
        if (RelatorioRequisicoes.tipoRelatorio == 8) {
            camposFinal = ArraysUtil.concatenar(campos, camposImpressao);
        }
        if (RelatorioRequisicoes.tipoRelatorio == 1) {
            camposFinal = ArraysUtil.concatenar(campos, new String[]{"motivoJustificativa", "motivoAlteracao", "mediaTempoTotalColetaAteConferenciaExameRequisicao", "coletaIncorreta", "motivoColetaIncorreta", "usuarioColetaIncorreta"});
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            camposFinal = ArraysUtil.concatenar(campos, new String[]{"codigoEspecie", "descricaoEspecie", "codigoRaca", "descricaoRaca", "pelagem"});
        }
        if ((perguntasFilial = RecepcaoUtil.getPerguntasFilial(Variaveis.filialPadrao)).length > 0) {
            camposFinal = ArraysUtil.concatenar(camposFinal, perguntasFilial);
        }
        this.setCamposConfigurador(camposFinal);
        String parametros = ParametrosUsuarios.getValor(listaUltimoFiltro.get(tipoRelatorio));
        if (!Funcoes.textoVazio(parametros)) {
            this.carregarFiltros(parametros);
        }
    }

    public void adicionarFiltrosCheckTipoRelatorio(int tipoRelatorio) {
        if (tipoRelatorio == 9) {
            this.adicionaFiltroCheck(FILTRO_EXAME_AVISAR_PACIENTE, "Mostrar exames para avisar", false);
        }
        this.adicionaFiltroCheck("deveGuia", "Sem pedido/guia", false);
        this.adicionaFiltroCheck("intervaloHora", "Intervalo de Hora", false);
        if (RelatorioRequisicoes.tipoRelatorio == 4 || tipoRelatorio == 6) {
            this.adicionaFiltroCheck(FILTRO_SOMENTE_NAO_TRIADAS, "Somente n\u00e3o triadas", false);
        }
        if ((tipoRelatorio != 17 || tipoRelatorio != 18) && tipoRelatorio != 19) {
            this.adicionaFiltroCheck(FILTRO_TODOS_EXAMES_MESMA_SITUACAO, "Exames mesma situa\u00e7\u00e3o", false);
        }
        this.adicionaFiltroCheck(FILTRO_URGENTE, "Urgente", false);
        this.adicionaFiltroCheck(FILTRO_CONSIDERAR_RESPOSTAS, "Considerar resposta", false);
        if (tipoRelatorio != 8) {
            this.adicionaFiltroCheck(FILTRO_VIP, "Paciente VIP", false);
        }
        if (tipoRelatorio == 1) {
            this.adicionaFiltroCheck(FILTRO_REQUISICAO_TAXAS, "Requisi\u00e7\u00f5es com Taxa(s)", false);
        }
        if (tipoRelatorio != 3 && tipoRelatorio != 11 && tipoRelatorio != 12 && tipoRelatorio != 15 && tipoRelatorio != 2 && tipoRelatorio != 19) {
            this.adicionaFiltroCheck(FILTRO_RESULTADO_CRITICO, "Resultados cr\u00edticos", false);
        }
        if (tipoRelatorio == 14) {
            this.adicionaFiltroCheck("requisicoesInterfaceamento", "Requisi\u00e7\u00f5es Interfaceamento", false);
        }
        if (tipoRelatorio == 12) {
            this.adicionaFiltroCheck("apenasLoteExterno", "Apenas com lote para apoio", false);
        }
    }

    private void listaParametros() {
        listaUltimoFiltro.put(1, "RelatorioRequisicaoAbertas.ultimoFiltro");
        listaUltimoFiltro.put(2, "RelatorioRequisicaoColetar.ultimoFiltro");
        listaUltimoFiltro.put(3, "RelatorioRequisicaoSemMaterial.ultimoFiltro");
        listaUltimoFiltro.put(4, "RelatorioRequisicaoColetadas.ultimoFiltro");
        listaUltimoFiltro.put(5, "RelatorioRequisicaoEntregues.ultimoFiltro");
        listaUltimoFiltro.put(6, "RelatorioRequisicaoAgrupadoMedico.ultimoFiltro");
        listaUltimoFiltro.put(7, "RelatorioRequisicaoAgrupadoConvenio.ultimoFiltro");
        listaUltimoFiltro.put(8, "RelatorioRequisicaoImpressas.ultimoFiltro");
        listaUltimoFiltro.put(9, "RelatorioRequisicaoAvisarPaciente.ultimoFiltro");
        listaUltimoFiltro.put(10, "RelatorioRequisicaoAgrupadoUsuario.ultimoFiltro");
        listaUltimoFiltro.put(11, "RelatorioRequisicaoRecoleta.ultimoFiltro");
        listaUltimoFiltro.put(12, "RelatorioRequisicaoNaoTriados.ultimoFiltro");
        listaUltimoFiltro.put(13, "RelatorioRequisicaoAgrupadoPaciente.ultimoFiltro");
        listaUltimoFiltro.put(14, "RelatorioRequisicaoRepeticao.ultimoFiltro");
        listaUltimoFiltro.put(15, "RelatorioRequisicaoExcluidas.ultimoFiltro");
        listaUltimoFiltro.put(16, "RelatorioRequisicaoAuditoriaProducao.ultimoFiltro");
        listaUltimoFiltro.put(17, "RelatorioRequisicaoConferirDigitada.ultimoFiltro");
        listaUltimoFiltro.put(18, "RelatorioRequisicaoConferida.ultimoFiltro");
        listaUltimoFiltro.put(19, "RelatorioRequisicaoTransporte.ultimoFiltro");
    }

    private void carregarFiltros(String parametros) {
        this.setSelecionados(parametros, PARAMETRO_FILIAL, FILTRO_FILIAL);
        if (Acesso.getAcesso(ACESSO_FILTRARESTACAO) || tipoRelatorio != 1) {
            this.setSelecionados(parametros, PARAMETRO_ESTACOES, FILTRO_ESTACAO);
        }
        if (Acesso.getAcesso(ACESSO_FILTRARUSUARIO) || tipoRelatorio != 1) {
            this.setSelecionados(parametros, PARAMETRO_USUARIO, FILTRO_USUARIO);
        }
        if (Acesso.getAcesso(ACESSO_FILTRARDESTINO) || tipoRelatorio != 1) {
            this.setSelecionados(parametros, PARAMETRO_DESTINO, FILTRO_DESTINO);
        }
        if (Acesso.getAcesso(ACESSO_FILTRARCOLETA) || tipoRelatorio != 1) {
            this.setSelecionados(parametros, PARAMETRO_COLETA, FILTRO_COLETA);
        }
        this.setSelecionados(parametros, PARAMETRO_CONVENIO, FILTRO_CONVENIO);
        this.setSelecionadosFiltroAvancado(parametros, PARAMETRO_MEDICOS, PARAMETRO_MEDICO, FILTRO_MEDICO, 4);
        this.setSelecionados(parametros, PARAMETRO_EXAME, FILTRO_EXAME);
        this.setSelecionados(parametros, PARAMETRO_SETORES, FILTRO_SETOR);
        if (tipoRelatorio != 8) {
            this.setSelecionados(parametros, PARAMETRO_SITUACAO_REQUISICAO, FILTRO_SITUACAO_REQUISICAO);
        }
        this.setSelecionados(parametros, PARAMETRO_UNIDADE_SAUDE, FILTRO_UNIDADE_SAUDE);
        this.setSelecionadosFiltroData(parametros, PARAMETRO_DATA_INICIAL, FILTRO_DATA_INICIAL);
        this.setSelecionadosFiltroData(parametros, PARAMETRO_DATA_FINAL, FILTRO_DATA_FINAL);
        this.setSelecionadosFiltroData(parametros, PARAMETRO_HORA_INICIAL, FILTRO_HORA_INICIAL);
        this.setSelecionadosFiltroData(parametros, PARAMETRO_HORA_FINAL, FILTRO_HORA_FINAL);
        this.setSelecionadosFiltroCombo(parametros, PARAMETRO_ORDEM, FILTRO_ORDEM);
        this.setSelecionadosFiltroCombo(parametros, PARAMETRO_CAMPO_DATA, FILTRO_CAMPODATA);
        this.setSelecionadosFiltroCombo(parametros, PARAMETRO_SIT_PGTO, FILTRO_SITUACAO_PAGO);
        this.setSelecionadosFiltroCombo(parametros, PARAMETRO_SEXO, FILTRO_SEXO);
        this.setSelecionadosFiltroCheck(parametros, "deveGuia", "deveGuia");
        this.setSelecionadosFiltroCheck(parametros, "intervaloHora", "intervaloHora");
        if (tipoRelatorio == 13 && !Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && !Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.setSelecionadosFiltroAvancado(parametros, PARAMETRO_PACIENTES, PARAMETRO_PACIENTE, FILTRO_PACIENTE, 3);
        }
        if (tipoRelatorio == 8) {
            this.setSelecionadosFiltroComboIndice(parametros, PARAMETRO_DATA, FILTRO_POR_DATA);
        }
        if (tipoRelatorio == 1 || tipoRelatorio == 9 || tipoRelatorio == 16) {
            this.setSelecionadosFiltroCombo(parametros, PARAMETRO_SITUACAO, FILTRO_SITUACAO);
        }
        if (tipoRelatorio == 9) {
            this.setSelecionadosFiltroCheck(parametros, PARAMETRO_AVISAR_PACIENTE, FILTRO_EXAME_AVISAR_PACIENTE);
        }
        if (tipoRelatorio != 8) {
            this.setSelecionadosFiltroCheck(parametros, PARAMETRO_VIP, FILTRO_VIP);
        }
        if (tipoRelatorio == 4 || tipoRelatorio == 6) {
            this.setSelecionadosFiltroCheck(parametros, PARAMETRO_NAO_TRIADAS, FILTRO_SOMENTE_NAO_TRIADAS);
        }
        if ((tipoRelatorio != 17 || tipoRelatorio != 18) && tipoRelatorio != 19) {
            this.setSelecionadosFiltroCheck(parametros, PARAMETRO_EXAMES_MESMA_SITUACAO, FILTRO_TODOS_EXAMES_MESMA_SITUACAO);
        }
        this.setSelecionadosFiltroCheck(parametros, PARAMETRO_URGENTE, FILTRO_URGENTE);
        this.setSelecionadosFiltroCheck(parametros, PARAMETRO_CONSIDERAR_RESPOSTAS, FILTRO_CONSIDERAR_RESPOSTAS);
        if (tipoRelatorio == 1) {
            this.setSelecionadosFiltroCheck(parametros, PARAMETRO_REQUISICAO_TAXAS, FILTRO_REQUISICAO_TAXAS);
        }
        if (tipoRelatorio != 3 && tipoRelatorio != 11 && tipoRelatorio != 12 && tipoRelatorio != 15 && tipoRelatorio != 2 && tipoRelatorio != 19) {
            this.setSelecionadosFiltroCheck(parametros, PARAMETRO_RESULTADO_CRITICO, FILTRO_RESULTADO_CRITICO);
        }
        if (tipoRelatorio == 14) {
            this.setSelecionadosFiltroCheck(parametros, "requisicoesInterfaceamento", "requisicoesInterfaceamento");
        }
        if (tipoRelatorio == 12) {
            this.setSelecionadosFiltroCheck(parametros, "apenasLoteExterno", "apenasLoteExterno");
        }
        if (tipoRelatorio == 4 || tipoRelatorio == 6) {
            this.setSelecionadosFiltroCombo(parametros, PARAMETRO_CAMPO_DATA, FILTRO_CAMPODATA);
        }
    }

    private void setSelecionadosFiltroCheck(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setFiltroCheck(tipoFiltro, tmp.equalsIgnoreCase("true"));
        }
    }

    private void setSelecionadosFiltroCombo(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setFiltroCombo(tipoFiltro, tmp);
        }
    }

    private void setSelecionadosFiltroComboIndice(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setFiltroComboPorIndice(tipoFiltro, tmp);
        }
    }

    private void setSelecionadosFiltroData(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setFiltroData(tipoFiltro, tmp);
        }
    }

    private void setSelecionadosFiltroAvancado(String parametros, String filtro, String filhoFiltro, String tipoFiltro, Integer colunas) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            String[] lista = StringUtil.getValores(tmp, filhoFiltro);
            Object[] objFiltro = new Object[lista.length];
            for (int i = 0; i < lista.length; ++i) {
                String valor;
                String valores = lista[i];
                Object[] aux = new Object[colunas.intValue()];
                int j = 0;
                while (!Funcoes.textoVazio(valor = StringUtil.getValor(valores, String.valueOf(j)))) {
                    aux[j++] = valor;
                }
                objFiltro[i] = aux;
            }
            this.setSelecionadosFiltroAvancado(tipoFiltro, objFiltro);
        }
    }

    private void setSelecionados(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setSelecionadosFiltro(tipoFiltro, 0, tmp.split(","));
        }
    }

    private void carregaFiltroAbertas(String parametros) {
        String tmp = StringUtil.getValor(parametros, "filialMedico");
        if (!Funcoes.textoVazio(tmp)) {
            this.setSelecionadosFiltro(FILTRO_FILIAL, 0, tmp.split(","));
        }
    }

    @Override
    public void imprimirPressionado() {
        try {
            String filtroCampoData;
            Statement stTemp = Conexao.getStatement();
            if (Funcoes.textoVazio(service.getLayoutRelatorio(tipoRelatorio, stTemp))) {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            Conexao.fecharStatement(stTemp);
            camposUtilizados = new HashMap();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            String situacaoAtual = this.getFiltroCombo(FILTRO_SITUACAO).toString();
            String[] estacao = this.getSelecionadosFiltro(FILTRO_ESTACAO, 0);
            String[] usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
            String[] destino = this.getSelecionadosFiltro(FILTRO_DESTINO, 0);
            String[] coleta = this.getSelecionadosFiltro(FILTRO_COLETA, 0);
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            String[] conselho = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0);
            String[] crm = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1);
            String[] uf = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2);
            String[] exame = this.getSelecionadosFiltro(FILTRO_EXAME, 0);
            String[] setor = this.getSelecionadosFiltro(FILTRO_SETOR, 0);
            String[] situacao = this.getSelecionadosFiltro(FILTRO_SITUACAO_REQUISICAO, 0);
            String[] unidadeSaude = this.getSelecionadosFiltro(FILTRO_UNIDADE_SAUDE, 0);
            String[] alas = this.getSelecionadosFiltro(FILTRO_ALA, 0);
            String quarto = this.getFiltroTexto(FILTRO_QUARTO);
            String leito = this.getFiltroTexto(FILTRO_LEITO);
            String prontuario = this.getFiltroTexto(FILTRO_PRONTUARIO);
            String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
            String campoData = filtroCampoData = this.getFiltroCombo(FILTRO_CAMPODATA).toString();
            String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
            String horaInicial = this.getFiltroHora(FILTRO_HORA_INICIAL);
            String horaFinal = this.getFiltroHora(FILTRO_HORA_FINAL);
            boolean deveGuia = this.getFiltroCheck("deveGuia");
            boolean somenteNaoTriadas = this.getFiltroCheck(FILTRO_SOMENTE_NAO_TRIADAS);
            boolean intervaloHora = this.getFiltroCheck("intervaloHora");
            boolean pacienteVip = this.getFiltroCheck(FILTRO_VIP);
            boolean mostrarExameAvisarPaciente = this.getFiltroCheck(FILTRO_EXAME_AVISAR_PACIENTE);
            boolean todosExamesMesmaSituacao = this.getFiltroCheck(FILTRO_TODOS_EXAMES_MESMA_SITUACAO);
            boolean urgente = this.getFiltroCheck(FILTRO_URGENTE);
            boolean reqComTaxas = this.getFiltroCheck(FILTRO_REQUISICAO_TAXAS);
            boolean resultadoCritico = this.getFiltroCheck(FILTRO_RESULTADO_CRITICO);
            String selecaoSexo = this.getFiltroCombo(FILTRO_SEXO).toString();
            boolean requisicaoInterfaceamento = this.getFiltroCheck("requisicoesInterfaceamento");
            boolean apenasLoteExterno = this.getFiltroCheck("apenasLoteExterno");
            somaTempoTotalAteColetaExame = null;
            somaTempoTotalAteDigitacaoExame = null;
            somaTempoTotalAteConferenciaExame = null;
            somaTempoTotalAteImpressaoExame = null;
            somaTempoTotalAteEntregaExame = null;
            somaTempoTotalColetaAteDigitacaoExame = null;
            somaTempoTotalColetaAteConferenciaExame = null;
            somaTempoTotalColetaAteImpressaoExame = null;
            somaTempoTotalColetaAteEntregaExame = null;
            somaTempoTotalAteChamadaGuiche = null;
            somaTempoTotalAteGravacaoRequisicao = null;
            somaTempoTotalChegadaAteColetaExame = null;
            somaTempoTotalChegadaAteDigitacaoExame = null;
            somaTempoTotalChegadaAteConferenciaExame = null;
            somaTempoTotalChegadaAteEntregaExame = null;
            somaTempoTotalChegadaAteImpressaoExame = null;
            qtdeColetaExame = 0;
            qtdeDigitacaoExame = 0;
            qtdeConferenciaExame = 0;
            qtdeImpressaoExame = 0;
            qtdeEntregaExame = 0;
            qtdeColetaDigitacaoExame = 0;
            qtdeColetaConferenciaExame = 0;
            qtdeColetaImpressaoExame = 0;
            qtdeColetaEntregaExame = 0;
            qtdeTempoTotalAteChamadaGuiche = 0;
            qtdeTempoTotalAteGravacaoRequisicao = 0;
            qtdeTempoTotalChegadaAteColetaExame = 0;
            qtdeTempoTotalChegadaAteDigitacaoExame = 0;
            qtdeTempoTotalChegadaAteConferenciaExame = 0;
            qtdeTempoTotalChegadaAteEntregaExame = 0;
            qtdeTempoTotalChegadaAteImpressaoExame = 0;
            String[] paciente = null;
            Object[] pacienteFiltro = null;
            if (tipoRelatorio == 13) {
                paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0);
                pacienteFiltro = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE);
            }
            Object[] medicoFiltro = null;
            medicoFiltro = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO);
            if (intervaloHora && (Funcoes.textoVazio(dataInicial) || Funcoes.textoVazio(horaInicial) || Funcoes.textoVazio(dataFinal) || Funcoes.textoVazio(horaFinal))) {
                Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos!", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (tipoRelatorio == 4 || tipoRelatorio == 6) {
                service.setComboCampoData(campoData);
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int campoDataImpresso = 0;
            if (tipoRelatorio == 8) {
                campoDataImpresso = this.getFiltroComboIndice(FILTRO_POR_DATA);
            }
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            Statement st3 = Conexao.getStatement();
            String filtroOrdem = this.getFiltroCombo(FILTRO_ORDEM).toString();
            int filtroSituacaoPago = this.getFiltroComboIndice(FILTRO_SITUACAO_PAGO);
            Object filtroCombo = this.getFiltroCombo(FILTRO_SITUACAO_PAGO);
            boolean filtroCheck = this.getFiltroCheck(FILTRO_CONSIDERAR_RESPOSTAS);
            Runnable acaoFechar = new Runnable(){

                @Override
                public void run() {
                    RelatorioRequisicoes.this.panelCentro.removeAll();
                    RelatorioRequisicoes.this.panelCentro.repaint();
                    RelatorioRequisicoes.this.habilitaBotaoImprimir(true);
                }
            };
            Runnable acaoFimRelatorio = new Runnable(){

                @Override
                public void run() {
                    RelatorioRequisicoes.this.habilitaBotaoImprimir(true);
                }
            };
            RelatorioRequisicoes.gerarRelatorioRequisicoes(false, tipoRelatorio, this, this.panelCentro, filiais, situacaoAtual, estacao, usuario, destino, coleta, convenio, conselho, crm, uf, exame, setor, situacao, unidadeSaude, alas, quarto, leito, prontuario, dataInicial, filtroCampoData, campoData, dataFinal, horaInicial, horaFinal, deveGuia, somenteNaoTriadas, intervaloHora, pacienteVip, mostrarExameAvisarPaciente, todosExamesMesmaSituacao, urgente, reqComTaxas, resultadoCritico, selecaoSexo, requisicaoInterfaceamento, apenasLoteExterno, paciente, pacienteFiltro, medicoFiltro, campoDataImpresso, st, filtroOrdem, filtroSituacaoPago, filtroCombo, filtroCheck, acaoFechar, acaoFimRelatorio, Variaveis.filialPadrao, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getPrecoMetodologia(), Variaveis.codigoEstacao, Variaveis.login, Acesso.getAcesso(ACESSO_FILTRARUSUARIO), Acesso.getAcesso(ACESSO_FILTRARESTACAO), ParametrosGerais.getQuantidadeMaximoFiltroAvancado(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), st2, st3, Variaveis.tipoFilialPadrao);
            Conexao.fecharStatement(st, st2, st3);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static RetornoRelatorioRequisicoes gerarRelatorioRequisicoes(boolean isColetaWeb, int tipoRelatorioGerar, RelatorioRequisicoes pai, JPanel panelCentro2, String[] filiais, String situacaoAtual, String[] estacao, String[] usuario, String[] destino, String[] coleta, String[] convenio, String[] conselho, String[] crm, String[] uf, String[] exame, String[] setor, String[] situacao, String[] unidadeSaude, String[] alas, String quarto, String leito, String prontuario, String dataInicial, String filtroCampoData, String campoData, String dataFinal, String horaInicial, String horaFinal, boolean deveGuia, boolean somenteNaoTriadas, boolean intervaloHora, boolean pacienteVip, boolean mostrarExameAvisarPaciente, boolean todosExamesMesmaSituacao, boolean urgente, boolean reqComTaxas, boolean resultadoCritico, String selecaoSexo, boolean requisicaoInterfaceamento, boolean apenasLoteExterno, String[] paciente, Object[] pacienteFiltro, Object[] medicoFiltro, int campoDataImpresso, Statement st, String filtroOrdem, int filtroSituacaoPago, Object filtroCombo, boolean filtroCheck, Runnable acaoFechar, Runnable acaoFimRelatorio, String filialPadrao, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, String codigoEstacao, String login, boolean acessoFiltrarUsuario, boolean acessoFiltrarEstacao, int quantidadeMaximoFiltroAvancado, boolean ordenarSetor, String ordemComprovante, Statement st2, Statement st3, String tipoFilialPadrao) throws SQLException {
        String sql = RelatorioRequisicoes.getSelect(filiais, "", tipoRelatorioGerar, estacao, usuario, destino, coleta, null, convenio, conselho, crm, uf, exame, setor, situacao, paciente, alas, quarto, leito, prontuario, dataInicial, dataFinal, horaInicial, horaFinal, filtroOrdem, situacaoAtual, deveGuia, somenteNaoTriadas, intervaloHora, filtroSituacaoPago, pacienteVip, campoDataImpresso, mostrarExameAvisarPaciente, urgente, reqComTaxas, resultadoCritico, unidadeSaude, filtroCampoData, selecaoSexo, requisicaoInterfaceamento, apenasLoteExterno, st, filialPadrao, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, codigoEstacao, login, acessoFiltrarUsuario, acessoFiltrarEstacao, quantidadeMaximoFiltroAvancado, ordenarSetor, ordemComprovante);
        return RelatorioRequisicoes.imprimirRelatorio(isColetaWeb, pai, panelCentro2, sql, tipoRelatorioGerar, filiais, estacao, usuario, destino, coleta, null, convenio, conselho, crm, uf, exame, setor, situacao, paciente, pacienteFiltro, medicoFiltro, alas, quarto, leito, prontuario, dataInicial, dataFinal, horaInicial, horaFinal, filtroOrdem, situacaoAtual, deveGuia, somenteNaoTriadas, pacienteVip, campoDataImpresso, todosExamesMesmaSituacao, unidadeSaude, acaoFechar, acaoFimRelatorio, urgente, reqComTaxas, resultadoCritico, filtroCombo, intervaloHora, mostrarExameAvisarPaciente, selecaoSexo, requisicaoInterfaceamento, apenasLoteExterno, campoData, filtroCheck, st, st2, st3, tipoFilialPadrao, casasPrecoExame, arredondamentoPrecoExame, acessoFiltrarUsuario, acessoFiltrarEstacao, login, codigoEstacao, filialPadrao);
    }

    public static RetornoRelatorioRequisicoes imprimirRelatorio(boolean isColetaWeb, Component pai, JPanel panel, String sql, int tipoDoRelatorio, String[] filiais, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] cids, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] exames, String[] setores, String[] situacao, String[] pacientes, Object[] pacienteFiltro, Object[] medicoFiltro, String[] alas, String quarto, String leito, String prontuario, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String ordemSelecionada, String situacaoAtual, boolean deveGuia, boolean somenteNaoTriadas, boolean pacienteVIP, int campoDataImpresso, boolean todosExamesMesmaSituacao, String[] unidadeSaude, Runnable acaoFechar, Runnable acaoFimRelatorio, boolean urgente, boolean reqComTaxas, boolean resultadoCritico, Object situacaoPagamento, boolean intervaloHora, boolean mostrarExameAvisarPaciente, String selecaoSexo, boolean requisicaoInterfaceamento, boolean apenasLoteExterno, String campoData, boolean considerarRespostas, Statement st, Statement st2, Statement st3, String tipoFilialPadrao, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean acessoFiltrarUsuario, boolean acessoFiltrarEstacao, String login, String codigoEstacao, String filialPadrao) throws SQLException {
        if (service == null) {
            service = new RelatorioRequisicoesService();
        }
        StringBuilder buf = new StringBuilder();
        tipoRelatorio = tipoDoRelatorio;
        LIGACOES = sql;
        StringBuilder camposAux = new StringBuilder();
        HashMap<String, String> camposObrigatorios = new HashMap<String, String>();
        camposAux.setLength(0);
        camposAux.append(" cast(COALESCE(NULLIF(b.exr_situacao, ''), '-') as TEXT) = (select array_to_string(array_agg(distinct cast(COALESCE(NULLIF(exr2.exr_situacao, ''), '-') as TEXT)), '') ");
        camposAux.append("                                   from examerequisicao exr2 ");
        camposAux.append("                                  where a.fil_codigo = exr2.fil_codigo ");
        camposAux.append("                                    and a.req_codigo = exr2.req_codigo)");
        camposObrigatorios.put("todosIguais", camposAux.toString());
        camposObrigatorios.put("tipoMedico", "medico.med_tipo");
        camposObrigatorios.put("codigoFilial", "filial.fil_codigo");
        camposObrigatorios.put("codigoRequisicao", "a.req_codigo");
        camposObrigatorios.put("dataDigitacaoExameRequisicao", "b.exr_datadigita");
        camposObrigatorios.put("dataColetaExameRequisicao", "b.exr_datamaterial");
        camposObrigatorios.put("dataAssinaturaExameRequisicao", "b.exr_dataassina");
        camposObrigatorios.put("dataImpressaoExameRequisicao", "b.exr_dataimpresso");
        camposObrigatorios.put("dataEntregueExameRequisicao", "b.exr_dataentreguerst");
        camposObrigatorios.put("tempoTotalColetaAteDigitacaoExame", "''");
        camposObrigatorios.put("tempoTotalColetaAteDigitacaoExameMinutos", "''");
        camposObrigatorios.put("tempoTotalAteConferenciaExame", "''");
        camposObrigatorios.put("tempoTotalColetaAteImpressaoExame", "''");
        camposObrigatorios.put("tempoTotalColetaAteEntregaExame", "''");
        camposObrigatorios.put("tempoTotalAteColetaExame", "''");
        camposObrigatorios.put("tempoTotalAteImpressaoExame", "''");
        camposObrigatorios.put("tempoJejumExameRequisicao", "''");
        camposObrigatorios.put("tempoTotalAteDigitacaoExame", "''");
        camposObrigatorios.put("tempoTotalColetaAteConferenciaExame", "''");
        camposObrigatorios.put("tempoTotalColetaAteConferenciaExameMinutos", "''");
        camposObrigatorios.put("tempoDiureseExameRequisicao", "''");
        camposObrigatorios.put("tempoTotalAteEntregaExame", "''");
        camposObrigatorios.put("somaTempoTotalAteColetaExame", "''");
        camposObrigatorios.put("somaTempoTotalAteDigitacaoExame", "''");
        camposObrigatorios.put("somaTempoTotalAteConferenciaExame", "''");
        camposObrigatorios.put("somaTempoTotalAteImpressaoExame", "''");
        camposObrigatorios.put("somaTempoTotalAteEntregaExame", "''");
        camposObrigatorios.put("somaTempoTotalColetaAteDigitacaoExame", "''");
        camposObrigatorios.put("somaTempoTotalColetaAteConferenciaExame", "''");
        camposObrigatorios.put("somaTempoTotalColetaAteImpressaoExame", "''");
        camposObrigatorios.put("somaTempoTotalColetaAteEntregaExame", "''");
        camposObrigatorios.put("mediaTempoTotalColetaAteImpressaoExameRequisicao", "''");
        camposObrigatorios.put("mediaTempoTotalAteColetaExame", "''");
        camposObrigatorios.put("mediaTempoTotalAteDigitacaoExame", "''");
        camposObrigatorios.put("mediaTempoTotalAteConferenciaExame", "''");
        camposObrigatorios.put("mediaTempoTotalAteImpressaoExame", "''");
        camposObrigatorios.put("mediaTempoTotalAteEntregaExame", "''");
        camposObrigatorios.put("mediaTempoTotalColetaAteDigitacaoExame", "''");
        camposObrigatorios.put("mediaTempoTotalColetaAteConferenciaExame", "''");
        camposObrigatorios.put("mediaTempoTotalColetaAteConferenciaExameRequisicao", "''");
        camposObrigatorios.put("mediaTempoTotalColetaAteImpressaoExame", "''");
        camposObrigatorios.put("mediaTempoTotalColetaAteEntregaExame", "''");
        camposObrigatorios.put("detalhamentoTaxasRequisicao", "''");
        camposObrigatorios.put("perguntasRequisicao", "a.req_perguntas");
        camposObrigatorios.put("generoPaciente", "''");
        if (tipoDoRelatorio == 16) {
            camposObrigatorios.put("tempoTotalAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("tempoTotalAteColetaExameMinutos", "''");
            camposObrigatorios.put("tempoTotalAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("tempoTotalAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("tempoTotalAteEntregaExameMinutos", "''");
            camposObrigatorios.put("tempoTotalColetaAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("tempoTotalColetaAteEntregaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteColetaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteEntregaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalColetaAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalColetaAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalColetaAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalColetaAteEntregaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteColetaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteEntregaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalColetaAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalColetaAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalColetaAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalColetaAteEntregaExameMinutos", "''");
            camposObrigatorios.put("dataChegadaPaciente", "''");
            camposObrigatorios.put("dataChamadaPaciente", "''");
            camposObrigatorios.put("horaChegadaPaciente", "''");
            camposObrigatorios.put("horaChamadaPaciente", "''");
            camposObrigatorios.put("tempoTotalAteChamadaGuiche", "''");
            camposObrigatorios.put("tempoTotalAteChamadaGuicheMinutos", "''");
            camposObrigatorios.put("tempoTotalAteGravacaoRequisicao", "''");
            camposObrigatorios.put("tempoTotalAteGravacaoRequisicaoMinutos", "''");
            camposObrigatorios.put("tempoTotalChegadaAteColetaExame", "''");
            camposObrigatorios.put("tempoTotalChegadaAteColetaExameMinutos", "''");
            camposObrigatorios.put("tempoTotalChegadaAteDigitacaoExame", "''");
            camposObrigatorios.put("tempoTotalChegadaAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("tempoTotalChegadaAteConferenciaExame", "''");
            camposObrigatorios.put("tempoTotalChegadaAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("tempoTotalChegadaAteEntregaExame", "''");
            camposObrigatorios.put("tempoTotalChegadaAteEntregaExameMinutos", "''");
            camposObrigatorios.put("tempoTotalChegadaAteImpressaoExame", "''");
            camposObrigatorios.put("tempoTotalChegadaAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteChamadaGuiche", "''");
            camposObrigatorios.put("somaTempoTotalAteChamadaGuicheMinutos", "''");
            camposObrigatorios.put("somaTempoTotalAteGravacaoRequisicao", "''");
            camposObrigatorios.put("somaTempoTotalAteGravacaoRequisicaoMinutos", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteColetaExame", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteColetaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteDigitacaoExame", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteConferenciaExame", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteEntregaExame", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteEntregaExameMinutos", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteImpressaoExame", "''");
            camposObrigatorios.put("somaTempoTotalChegadaAteImpressaoExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteChamadaGuiche", "''");
            camposObrigatorios.put("mediaTempoTotalAteChamadaGuicheMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalAteGravacaoRequisicao", "''");
            camposObrigatorios.put("mediaTempoTotalAteGravacaoRequisicaoMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteColetaExame", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteColetaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteDigitacaoExame", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteDigitacaoExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteConferenciaExame", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteConferenciaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteEntregaExame", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteEntregaExameMinutos", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteImpressaoExame", "''");
            camposObrigatorios.put("mediaTempoTotalChegadaAteImpressaoExameMinutos", "''");
        }
        if (tipoDoRelatorio == 8) {
            camposObrigatorios.put("qtdePaginasImpressasRequisicao", "''");
        }
        camposUtilizados = Relatorio.getCamposBancoLayout(service.getLayoutRelatorio(tipoRelatorio, st), MAPA_TODOS_CAMPOS_DISPONIVEIS, camposObrigatorios);
        StringBuilder sqlFinal = new StringBuilder();
        sqlFinal.append(" select ");
        sqlFinal.append(Relatorio.getFieldsSelect(camposUtilizados));
        sqlFinal.append(LIGACOES);
        ResultSet rs = st3.executeQuery(sqlFinal.toString());
        int contador = 0;
        if (rs.next()) {
            String[] listaCamposUtilizados = new String[camposUtilizados.size()];
            for (String it : camposUtilizados.keySet()) {
                if (it.equalsIgnoreCase("mediatempototalcoletaateimpressaoexamerequisicao")) continue;
                listaCamposUtilizados[contador++] = it;
            }
            listaCamposUtilizados[RelatorioRequisicoes.camposUtilizados.size() - 1] = "mediatempototalcoletaateimpressaoexamerequisicao";
            if (tipoRelatorio == 16) {
                listaCamposUtilizados[RelatorioRequisicoes.camposUtilizados.size() - 1] = "mediatempototalcoletaateconferenciaexamerequisicao";
            }
            ModeloGridTable modelo = new ModeloGridTable(listaCamposUtilizados);
            HashMap<Integer, Integer> quantidadeRequisicao = new HashMap<Integer, Integer>();
            HashMap<Integer, PGInterval> qtdeRequisicoesExames = new HashMap<Integer, PGInterval>();
            HashMap<Integer, PGInterval> qtdeRequisicoesConferenciaExames = new HashMap<Integer, PGInterval>();
            int quantidadeExames = 0;
            int quantidadeExamesRequisicao = 0;
            do {
                ++quantidadeExames;
                if (!quantidadeRequisicao.containsKey(rs.getInt("codigoRequisicao"))) {
                    quantidadeExamesRequisicao = 0;
                }
                if (rs.getObject("dataImpressaoExameRequisicao") == null && rs.getObject("dataassinaturaexamerequisicao") == null) continue;
                quantidadeRequisicao.put(rs.getInt("codigoRequisicao"), ++quantidadeExamesRequisicao);
            } while (rs.next());
            rs.first();
            do {
                Object[] o = new Object[listaCamposUtilizados.length];
                if (todosExamesMesmaSituacao && !rs.getBoolean("todosIguais")) continue;
                Map<String, Object> respostasRequisicao = null;
                for (int i = 0; i < listaCamposUtilizados.length; ++i) {
                    TabelaSimbolos tabela = new TabelaSimbolos();
                    if (!DBUtil.campoNull(rs.getString("perguntasRequisicao")) && !Funcoes.textoVazio(rs.getString("perguntasRequisicao")) && considerarRespostas && (respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"))) != null && !respostasRequisicao.isEmpty()) {
                        respostasRequisicao.entrySet().forEach(k -> {
                            int pos = ArraysUtil.indice((Object[])listaCamposUtilizados, (String)k.getKey());
                            if (pos > -1) {
                                o[pos] = k.getValue();
                            }
                        });
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroPaciente") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroConvenio") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroResponsavelRequisicao") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                        o[i] = Tipos.tipoLogradouroDescricao(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tipoMedico")) {
                        o[i] = Tipos.tipoMedico(rs.getString("tipoMedico"));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("anomesIdadeRequisicao") || listaCamposUtilizados[i].equalsIgnoreCase("anomesIdadePaciente") || listaCamposUtilizados[i].equalsIgnoreCase("tipoIdadeMinimaExame") || listaCamposUtilizados[i].equalsIgnoreCase("tipoIdadeMaximaExame")) {
                        o[i] = Tipos.tipoIdade(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("sexoPaciente") || listaCamposUtilizados[i].equalsIgnoreCase("sexoExame")) {
                        o[i] = Tipos.tipoSexo(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("situacaoExameRequisicao")) {
                        o[i] = Tipos.tipoSituacaoExame(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("corPaciente")) {
                        o[i] = Tipos.tipoCor(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("fumantePaciente")) {
                        o[i] = Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente"));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("diabeticoPaciente")) {
                        o[i] = Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente"));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("estadoCivilPaciente")) {
                        o[i] = Tipos.tipoEstadoCivil(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tipoPagamentoConvenio")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tipoCalculoFaturaConvenio")) {
                        o[i] = Tipos.tipoCalculoFatura(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("titularDependenteConvenio")) {
                        o[i] = Tipos.tipoTitularDependente(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tipoCalculoCHConvenio")) {
                        o[i] = Tipos.tipoCalculoCH(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("codigoFilialCodigoRequisicao")) {
                        o[i] = Funcoes.preencheZero(rs.getInt("codigoFilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), ParametrosGerais.getDigitosTuboRequisicao());
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("detalhamentoTaxasRequisicao")) {
                        o[i] = service.adicionaTaxasRequisicao(rs.getInt("codigoFilial"), rs.getInt("codigoRequisicao"), st2);
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteDigitacaoExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataDigitacaoExameRequisicao") == null) continue;
                            somaTempoTotalAteDigitacaoExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteDigitacaoExame, interval);
                            ++qtdeDigitacaoExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteColetaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteChamadaGuicheMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteGravacaoRequisicaoMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteColetaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteImpressaoExameMinutos")) {
                        o[i] = RelatorioRequisicoesService.getValorMinutosIntervalo(rs.getObject(listaCamposUtilizados[i]));
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteDigitacaoExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataDigitacaoExameRequisicao") == null) continue;
                            somaTempoTotalColetaAteDigitacaoExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalColetaAteDigitacaoExame, interval);
                            ++qtdeColetaDigitacaoExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteColetaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataColetaExameRequisicao") == null) continue;
                            somaTempoTotalAteColetaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteColetaExame, interval);
                            ++qtdeColetaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteConferenciaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataAssinaturaExameRequisicao") == null) continue;
                            somaTempoTotalAteConferenciaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteConferenciaExame, interval);
                            ++qtdeConferenciaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteConferenciaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataAssinaturaExameRequisicao") == null) continue;
                            somaTempoTotalColetaAteConferenciaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalColetaAteConferenciaExame, interval);
                            ++qtdeColetaConferenciaExame;
                            if (!RelatorioRequisicoesService.validaTipoRelatorioProdReq(tipoRelatorio)) continue;
                            if (!qtdeRequisicoesConferenciaExames.containsKey(rs.getInt("codigoRequisicao"))) {
                                mediaTempoTotalColetaAteConferenciaExameRequisicao = null;
                            }
                            mediaTempoTotalColetaAteConferenciaExameRequisicao = RelatorioRequisicoesService.somaIntervalos(mediaTempoTotalColetaAteConferenciaExameRequisicao, interval);
                            qtdeRequisicoesConferenciaExames.put(rs.getInt("codigoRequisicao"), mediaTempoTotalColetaAteConferenciaExameRequisicao);
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteImpressaoExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataImpressaoExameRequisicao") == null) continue;
                            somaTempoTotalAteImpressaoExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteImpressaoExame, interval);
                            ++qtdeImpressaoExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteImpressaoExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataImpressaoExameRequisicao") == null) continue;
                            somaTempoTotalColetaAteImpressaoExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalColetaAteImpressaoExame, interval);
                            ++qtdeColetaImpressaoExame;
                            if (!qtdeRequisicoesExames.containsKey(rs.getInt("codigoRequisicao"))) {
                                mediaTempoTotalColetaAteImpressaoExameRequisicao = null;
                            }
                            mediaTempoTotalColetaAteImpressaoExameRequisicao = RelatorioRequisicoesService.somaIntervalos(mediaTempoTotalColetaAteImpressaoExameRequisicao, interval);
                            qtdeRequisicoesExames.put(rs.getInt("codigoRequisicao"), mediaTempoTotalColetaAteImpressaoExameRequisicao);
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteEntregaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataEntregueExameRequisicao") == null) continue;
                            somaTempoTotalAteEntregaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteEntregaExame, interval);
                            ++qtdeEntregaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalColetaAteEntregaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("dataEntregueExameRequisicao") == null) continue;
                            somaTempoTotalColetaAteEntregaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalColetaAteEntregaExame, interval);
                            ++qtdeColetaEntregaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteChamadaGuiche")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalAteChamadaGuiche") == null) continue;
                            somaTempoTotalAteChamadaGuiche = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteChamadaGuiche, interval);
                            ++qtdeTempoTotalAteChamadaGuiche;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalAteGravacaoRequisicao")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalAteGravacaoRequisicao") == null) continue;
                            somaTempoTotalAteGravacaoRequisicao = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalAteGravacaoRequisicao, interval);
                            ++qtdeTempoTotalAteGravacaoRequisicao;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteColetaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalChegadaAteColetaExame") == null) continue;
                            somaTempoTotalChegadaAteColetaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalChegadaAteColetaExame, interval);
                            ++qtdeTempoTotalChegadaAteColetaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteDigitacaoExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalChegadaAteDigitacaoExame") == null) continue;
                            somaTempoTotalChegadaAteDigitacaoExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalChegadaAteDigitacaoExame, interval);
                            ++qtdeTempoTotalChegadaAteDigitacaoExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteConferenciaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalChegadaAteConferenciaExame") == null) continue;
                            somaTempoTotalChegadaAteConferenciaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalChegadaAteConferenciaExame, interval);
                            ++qtdeTempoTotalChegadaAteConferenciaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteEntregaExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalChegadaAteEntregaExame") == null) continue;
                            somaTempoTotalChegadaAteEntregaExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalChegadaAteEntregaExame, interval);
                            ++qtdeTempoTotalChegadaAteEntregaExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoTotalChegadaAteImpressaoExame")) {
                        PGInterval interval = (PGInterval)rs.getObject(listaCamposUtilizados[i]);
                        if (interval != null) {
                            o[i] = RelatorioRequisicoesService.intervaloParaString(interval);
                            if (rs.getObject("tempoTotalChegadaAteImpressaoExame") == null) continue;
                            somaTempoTotalChegadaAteImpressaoExame = RelatorioRequisicoesService.somaIntervalos(somaTempoTotalChegadaAteImpressaoExame, interval);
                            ++qtdeTempoTotalChegadaAteImpressaoExame;
                            continue;
                        }
                        o[i] = "";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("valorTotalExameRequisicao")) {
                        BigDecimal valor = new BigDecimal(0);
                        o[i] = valor.add(rs.getBigDecimal(listaCamposUtilizados[i]) == null ? BigDecimal.ZERO : rs.getBigDecimal(listaCamposUtilizados[i])).setScale(2, RoundingMode.HALF_UP);
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("tempoDiureseExameRequisicao")) {
                        o[i] = rs.getString("tempoDiureseExameRequisicao");
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalRequisicao")) {
                        o[i] = quantidadeRequisicao.size();
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalExame")) {
                        o[i] = quantidadeExames;
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteColetaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteDigitacaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteConferenciaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteImpressaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteEntregaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteDigitacaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteConferenciaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteImpressaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteEntregaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteChamadaGuiche") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteGravacaoRequisicao") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteColetaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteDigitacaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteConferenciaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteEntregaExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteImpressaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteColetaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteDigitacaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteConferenciaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteImpressaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteEntregaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteDigitacaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteConferenciaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteImpressaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteEntregaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteChamadaGuiche") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteGravacaoRequisicao") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteColetaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteDigitacaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteConferenciaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteEntregaExame") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteImpressaoExame") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteColetaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalColetaAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteChamadaGuicheMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalAteGravacaoRequisicaoMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteColetaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("somaTempoTotalChegadaAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteColetaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteImpressaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteChamadaGuicheMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalAteGravacaoRequisicaoMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteColetaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteDigitacaoExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteConferenciaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteEntregaExameMinutos") || listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalChegadaAteImpressaoExameMinutos")) continue;
                    if (listaCamposUtilizados[i].equalsIgnoreCase("qtdePaginasImpressasRequisicao")) {
                        RequisicaoPaginasImpressasService service = new RequisicaoPaginasImpressasService();
                        int qtdePaginasImpressas = service.getQtdePaginasImpressas(rs.getString("codigofilial"), usuarios, dataInicial, dataFinal, rs.getString("codigorequisicao"), st);
                        o[i] = qtdePaginasImpressas;
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteImpressaoExameRequisicao")) {
                        int qtdeExames = null == quantidadeRequisicao.get(rs.getInt("codigoRequisicao")) ? 0 : (Integer)quantidadeRequisicao.get(rs.getInt("codigoRequisicao"));
                        PGInterval somaTotalExameRequisicao = (PGInterval)qtdeRequisicoesExames.get(rs.getInt("codigoRequisicao"));
                        PGInterval mediaTempoTotalColetaExameRequisicao = RelatorioRequisicoesService.getMediaIntervalo(somaTotalExameRequisicao, qtdeExames);
                        o[i] = RelatorioRequisicoesService.intervaloParaString(mediaTempoTotalColetaExameRequisicao);
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("mediaTempoTotalColetaAteConferenciaExameRequisicao")) {
                        int quantidadeDeExames = null == quantidadeRequisicao.get(rs.getInt("codigoRequisicao")) ? 0 : (Integer)quantidadeRequisicao.get(rs.getInt("codigoRequisicao"));
                        PGInterval tempoTotalConferenciaExame = (PGInterval)qtdeRequisicoesConferenciaExames.get(rs.getInt("codigoRequisicao"));
                        PGInterval mediaTempoTotalConferenciaExameRequisicao = RelatorioRequisicoesService.getMediaIntervalo(tempoTotalConferenciaExame, quantidadeDeExames);
                        o[i] = RelatorioRequisicoesService.intervaloParaString(mediaTempoTotalConferenciaExameRequisicao);
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("coletaIncorreta")) {
                        o[i] = rs.getBoolean("coletaIncorreta") ? "Sim" : "N\u00e3o";
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("descricaoEspecie") && tipoFilialPadrao.equalsIgnoreCase("V")) {
                        String descricaoEspecie = service.getDescricaoEspecie(rs.getInt("codigoEspecie"), st, filialPadrao);
                        o[i] = descricaoEspecie;
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase("descricaoRaca") && tipoFilialPadrao.equalsIgnoreCase("V")) {
                        String descricaoRaca = service.getDescricaoRaca(rs.getInt("codigoRaca"), st, filialPadrao);
                        o[i] = descricaoRaca;
                        continue;
                    }
                    if (listaCamposUtilizados[i].equalsIgnoreCase(PARAMETRO_RESULTADO_CRITICO)) {
                        if (Funcoes.textoVazio(rs.getString(PARAMETRO_RESULTADO_CRITICO))) continue;
                        String mensagemResultadoCritico = rs.getString(PARAMETRO_RESULTADO_CRITICO);
                        Map<String, Object> res = Resultado.getCamposResultado(mensagemResultadoCritico, false);
                        for (String key : res.keySet()) {
                            tabela.setSimbolo(key, res.get(key));
                        }
                        String msgResultadoCritico = "";
                        Execucao exec = new Execucao(StringUtil.getValor(mensagemResultadoCritico, "mensagemResultadoCritico"), tabela, 0);
                        String msg = String.valueOf(exec.resultadoExpressao());
                        if (!Funcoes.textoVazio(msg)) {
                            msgResultadoCritico = msg;
                        }
                        o[i] = msgResultadoCritico;
                        continue;
                    }
                    o[i] = rs.getObject(listaCamposUtilizados[i]);
                }
                modelo.addLine(o);
            } while (rs.next());
            int colAteColeta = modelo.findColumn("somaTempoTotalAteColetaExame");
            int colAteDigitacaoExame = modelo.findColumn("somaTempoTotalAteDigitacaoExame");
            int colAteConferenciaExame = modelo.findColumn("somaTempoTotalAteConferenciaExame");
            int colAteImpressaoExame = modelo.findColumn("somaTempoTotalAteImpressaoExame");
            int colAteEntregaExame = modelo.findColumn("somaTempoTotalAteEntregaExame");
            int colColetaAteDigitacaoExame = modelo.findColumn("somaTempoTotalColetaAteDigitacaoExame");
            int colColetaAteConferenciaExame = modelo.findColumn("somaTempoTotalColetaAteConferenciaExame");
            int colColetaAteImpressaoExame = modelo.findColumn("somaTempoTotalColetaAteImpressaoExame");
            int colColetaAteEntregaExame = modelo.findColumn("somaTempoTotalColetaAteEntregaExame");
            int colSomaTempoTotalAteChamadaGuiche = -1;
            int colSomaTempoTotalAteGravacaoRequisicao = -1;
            int colSomaTempoTotalChegadaAteColetaExame = -1;
            int colSomaTempoTotalChegadaAteDigitacaoExame = -1;
            int colSomaTempoTotalChegadaAteConferenciaExame = -1;
            int colSomaTempoTotalChegadaAteEntregaExame = -1;
            int colSomaTempoTotalChegadaAteImpressaoExame = -1;
            int colMediaAteColetaExame = modelo.findColumn("mediaTempoTotalAteColetaExame");
            int colMediaAteDigitacaoExmae = modelo.findColumn("mediaTempoTotalAteDigitacaoExame");
            int colMediaAteConferenciaExame = modelo.findColumn("mediaTempoTotalAteConferenciaExame");
            int colMediaAteImpressaoExame = modelo.findColumn("mediaTempoTotalAteImpressaoExame");
            int colMediaAteEntregaExame = modelo.findColumn("mediaTempoTotalAteEntregaExame");
            int colMediaColetaAteDigitacaoExame = modelo.findColumn("mediaTempoTotalColetaAteDigitacaoExame");
            int colMediaColetaAteConferenciaExame = modelo.findColumn("mediaTempoTotalColetaAteConferenciaExame");
            int colMediaColetaAteImpressaoExame = modelo.findColumn("mediaTempoTotalColetaAteImpressaoExame");
            int colMediaColetaAteEntregaExame = modelo.findColumn("mediaTempoTotalColetaAteEntregaExame");
            int colMediaTempoTotalAteChamadaGuiche = -1;
            int colMediaTempoTotalAteGravacaoRequisicao = -1;
            int colMediaTempoTotalChegadaAteColetaExame = -1;
            int colMediaTempoTotalChegadaAteDigitacaoExame = -1;
            int colMediaTempoTotalChegadaAteConferenciaExame = -1;
            int colMediaTempoTotalChegadaAteEntregaExame = -1;
            int colMediaTempoTotalChegadaAteImpressaoExame = -1;
            int colAteColetaMinutos = -1;
            int colAteDigitacaoExameMinutos = -1;
            int colAteConferenciaExameMinutos = -1;
            int colAteImpressaoExameMinutos = -1;
            int colAteEntregaExameMinutos = -1;
            int colColetaAteDigitacaoExameMinutos = -1;
            int colColetaAteConferenciaExameMinutos = -1;
            int colColetaAteImpressaoExameMinutos = -1;
            int colColetaAteEntregaExameMinutos = -1;
            int colSomaTempoTotalAteChamadaGuicheMinutos = -1;
            int colSomaTempoTotalAteGravacaoRequisicaoMinutos = -1;
            int colSomaTempoTotalChegadaAteColetaExameMinutos = -1;
            int colSomaTempoTotalChegadaAteDigitacaoExameMinutos = -1;
            int colSomaTempoTotalChegadaAteConferenciaExameMinutos = -1;
            int colSomaTempoTotalChegadaAteEntregaExameMinutos = -1;
            int colSomaTempoTotalChegadaAteImpressaoExameMinutos = -1;
            int colMediaAteColetaExameMinutos = -1;
            int colMediaAteDigitacaoExmaeMinutos = -1;
            int colMediaAteConferenciaExameMinutos = -1;
            int colMediaAteImpressaoExameMinutos = -1;
            int colMediaAteEntregaExameMinutos = -1;
            int colMediaColetaAteDigitacaoExameMinutos = -1;
            int colMediaColetaAteConferenciaExameMinutos = -1;
            int colMediaColetaAteImpressaoExameMinutos = -1;
            int colMediaColetaAteEntregaExameMinutos = -1;
            int colMediaTempoTotalAteChamadaGuicheMinutos = -1;
            int colMediaTempoTotalAteGravacaoRequisicaoMinutos = -1;
            int colMediaTempoTotalChegadaAteColetaExameMinutos = -1;
            int colMediaTempoTotalChegadaAteDigitacaoExameMinutos = -1;
            int colMediaTempoTotalChegadaAteConferenciaExameMinutos = -1;
            int colMediaTempoTotalChegadaAteEntregaExameMinutos = -1;
            int colMediaTempoTotalChegadaAteImpressaoExameMinutos = -1;
            if (tipoDoRelatorio == 16) {
                colAteColetaMinutos = modelo.findColumn("somaTempoTotalAteColetaExameMinutos");
                colAteDigitacaoExameMinutos = modelo.findColumn("somaTempoTotalAteDigitacaoExameMinutos");
                colAteConferenciaExameMinutos = modelo.findColumn("somaTempoTotalAteConferenciaExameMinutos");
                colAteImpressaoExameMinutos = modelo.findColumn("somaTempoTotalAteImpressaoExameMinutos");
                colAteEntregaExameMinutos = modelo.findColumn("somaTempoTotalAteEntregaExameMinutos");
                colColetaAteDigitacaoExameMinutos = modelo.findColumn("somaTempoTotalColetaAteDigitacaoExameMinutos");
                colColetaAteConferenciaExameMinutos = modelo.findColumn("somaTempoTotalColetaAteConferenciaExameMinutos");
                colColetaAteImpressaoExameMinutos = modelo.findColumn("somaTempoTotalColetaAteImpressaoExameMinutos");
                colColetaAteEntregaExameMinutos = modelo.findColumn("somaTempoTotalColetaAteEntregaExameMinutos");
                colMediaAteColetaExameMinutos = modelo.findColumn("mediaTempoTotalAteColetaExameMinutos");
                colMediaAteDigitacaoExmaeMinutos = modelo.findColumn("mediaTempoTotalAteDigitacaoExameMinutos");
                colMediaAteConferenciaExameMinutos = modelo.findColumn("mediaTempoTotalAteConferenciaExameMinutos");
                colMediaAteImpressaoExameMinutos = modelo.findColumn("mediaTempoTotalAteImpressaoExameMinutos");
                colMediaAteEntregaExameMinutos = modelo.findColumn("mediaTempoTotalAteEntregaExameMinutos");
                colMediaColetaAteDigitacaoExameMinutos = modelo.findColumn("mediaTempoTotalColetaAteDigitacaoExameMinutos");
                colMediaColetaAteConferenciaExameMinutos = modelo.findColumn("mediaTempoTotalColetaAteConferenciaExameMinutos");
                colMediaColetaAteImpressaoExameMinutos = modelo.findColumn("mediaTempoTotalColetaAteImpressaoExameMinutos");
                colMediaColetaAteEntregaExameMinutos = modelo.findColumn("mediaTempoTotalColetaAteEntregaExameMinutos");
                colSomaTempoTotalAteChamadaGuiche = modelo.findColumn("somaTempoTotalAteChamadaGuiche");
                colSomaTempoTotalAteGravacaoRequisicao = modelo.findColumn("somaTempoTotalAteGravacaoRequisicao");
                colSomaTempoTotalChegadaAteColetaExame = modelo.findColumn("somaTempoTotalChegadaAteColetaExame");
                colSomaTempoTotalChegadaAteDigitacaoExame = modelo.findColumn("somaTempoTotalChegadaAteDigitacaoExame");
                colSomaTempoTotalChegadaAteConferenciaExame = modelo.findColumn("somaTempoTotalChegadaAteConferenciaExame");
                colSomaTempoTotalChegadaAteEntregaExame = modelo.findColumn("somaTempoTotalChegadaAteEntregaExame");
                colSomaTempoTotalChegadaAteImpressaoExame = modelo.findColumn("somaTempoTotalChegadaAteImpressaoExame");
                colMediaTempoTotalAteChamadaGuiche = modelo.findColumn("mediaTempoTotalAteChamadaGuiche");
                colMediaTempoTotalAteGravacaoRequisicao = modelo.findColumn("mediaTempoTotalAteGravacaoRequisicao");
                colMediaTempoTotalChegadaAteColetaExame = modelo.findColumn("mediaTempoTotalChegadaAteColetaExame");
                colMediaTempoTotalChegadaAteDigitacaoExame = modelo.findColumn("mediaTempoTotalChegadaAteDigitacaoExame");
                colMediaTempoTotalChegadaAteConferenciaExame = modelo.findColumn("mediaTempoTotalChegadaAteConferenciaExame");
                colMediaTempoTotalChegadaAteEntregaExame = modelo.findColumn("mediaTempoTotalChegadaAteEntregaExame");
                colMediaTempoTotalChegadaAteImpressaoExame = modelo.findColumn("mediaTempoTotalChegadaAteImpressaoExame");
                colSomaTempoTotalAteChamadaGuicheMinutos = modelo.findColumn("somaTempoTotalAteChamadaGuicheMinutos");
                colSomaTempoTotalAteGravacaoRequisicaoMinutos = modelo.findColumn("somaTempoTotalAteGravacaoRequisicaoMinutos");
                colSomaTempoTotalChegadaAteColetaExameMinutos = modelo.findColumn("somaTempoTotalChegadaAteColetaExameMinutos");
                colSomaTempoTotalChegadaAteDigitacaoExameMinutos = modelo.findColumn("somaTempoTotalChegadaAteDigitacaoExameMinutos");
                colSomaTempoTotalChegadaAteConferenciaExameMinutos = modelo.findColumn("somaTempoTotalChegadaAteConferenciaExameMinutos");
                colSomaTempoTotalChegadaAteEntregaExameMinutos = modelo.findColumn("somaTempoTotalChegadaAteEntregaExameMinutos");
                colSomaTempoTotalChegadaAteImpressaoExameMinutos = modelo.findColumn("somaTempoTotalChegadaAteImpressaoExameMinutos");
                colMediaTempoTotalAteChamadaGuicheMinutos = modelo.findColumn("mediaTempoTotalAteChamadaGuicheMinutos");
                colMediaTempoTotalAteGravacaoRequisicaoMinutos = modelo.findColumn("mediaTempoTotalAteGravacaoRequisicaoMinutos");
                colMediaTempoTotalChegadaAteColetaExameMinutos = modelo.findColumn("mediaTempoTotalChegadaAteColetaExameMinutos");
                colMediaTempoTotalChegadaAteDigitacaoExameMinutos = modelo.findColumn("mediaTempoTotalChegadaAteDigitacaoExameMinutos");
                colMediaTempoTotalChegadaAteConferenciaExameMinutos = modelo.findColumn("mediaTempoTotalChegadaAteConferenciaExameMinutos");
                colMediaTempoTotalChegadaAteEntregaExameMinutos = modelo.findColumn("mediaTempoTotalChegadaAteEntregaExameMinutos");
                colMediaTempoTotalChegadaAteImpressaoExameMinutos = modelo.findColumn("mediaTempoTotalChegadaAteImpressaoExameMinutos");
            }
            for (int i = 0; i < modelo.getRowCount(); ++i) {
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalAteColetaExame), i, colAteColeta);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalAteDigitacaoExame), i, colAteDigitacaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalAteConferenciaExame), i, colAteConferenciaExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalAteImpressaoExame), i, colAteImpressaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalAteEntregaExame), i, colAteEntregaExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalColetaAteDigitacaoExame), i, colColetaAteDigitacaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalColetaAteConferenciaExame), i, colColetaAteConferenciaExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalColetaAteImpressaoExame), i, colColetaAteImpressaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.tratarInterval(somaTempoTotalColetaAteEntregaExame), i, colColetaAteEntregaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteColetaExame, qtdeColetaExame)), i, colMediaAteColetaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteDigitacaoExame, qtdeDigitacaoExame)), i, colMediaAteDigitacaoExmae);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteConferenciaExame, qtdeConferenciaExame)), i, colMediaAteConferenciaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteImpressaoExame, qtdeImpressaoExame)), i, colMediaAteImpressaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteEntregaExame, qtdeEntregaExame)), i, colMediaAteEntregaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalColetaAteDigitacaoExame, qtdeColetaDigitacaoExame)), i, colMediaColetaAteDigitacaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalColetaAteConferenciaExame, qtdeColetaConferenciaExame)), i, colMediaColetaAteConferenciaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalColetaAteImpressaoExame, qtdeColetaImpressaoExame)), i, colMediaColetaAteImpressaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalColetaAteEntregaExame, qtdeColetaEntregaExame)), i, colMediaColetaAteEntregaExame);
                if (tipoDoRelatorio != 16) continue;
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteColetaExame), i, colAteColetaMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteDigitacaoExame), i, colAteDigitacaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteConferenciaExame), i, colAteConferenciaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteImpressaoExame), i, colAteImpressaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteEntregaExame), i, colAteEntregaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalColetaAteDigitacaoExame), i, colColetaAteDigitacaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalColetaAteConferenciaExame), i, colColetaAteConferenciaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalColetaAteImpressaoExame), i, colColetaAteImpressaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalColetaAteEntregaExame), i, colColetaAteEntregaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteColetaExame, qtdeColetaExame), i, colMediaAteColetaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteDigitacaoExame, qtdeDigitacaoExame), i, colMediaAteDigitacaoExmaeMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteConferenciaExame, qtdeConferenciaExame), i, colMediaAteConferenciaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteImpressaoExame, qtdeImpressaoExame), i, colMediaAteImpressaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteEntregaExame, qtdeEntregaExame), i, colMediaAteEntregaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalColetaAteDigitacaoExame, qtdeColetaDigitacaoExame), i, colMediaColetaAteDigitacaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalColetaAteConferenciaExame, qtdeColetaConferenciaExame), i, colMediaColetaAteConferenciaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalColetaAteImpressaoExame, qtdeColetaImpressaoExame), i, colMediaColetaAteImpressaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalColetaAteEntregaExame, qtdeColetaEntregaExame), i, colMediaColetaAteEntregaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalAteChamadaGuiche), i, colSomaTempoTotalAteChamadaGuiche);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalAteGravacaoRequisicao), i, colSomaTempoTotalAteGravacaoRequisicao);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalChegadaAteColetaExame), i, colSomaTempoTotalChegadaAteColetaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalChegadaAteDigitacaoExame), i, colSomaTempoTotalChegadaAteDigitacaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalChegadaAteConferenciaExame), i, colSomaTempoTotalChegadaAteConferenciaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalChegadaAteEntregaExame), i, colSomaTempoTotalChegadaAteEntregaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(somaTempoTotalChegadaAteImpressaoExame), i, colSomaTempoTotalChegadaAteImpressaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteChamadaGuiche), i, colSomaTempoTotalAteChamadaGuicheMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalAteGravacaoRequisicao), i, colSomaTempoTotalAteGravacaoRequisicaoMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalChegadaAteColetaExame), i, colSomaTempoTotalChegadaAteColetaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalChegadaAteDigitacaoExame), i, colSomaTempoTotalChegadaAteDigitacaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalChegadaAteConferenciaExame), i, colSomaTempoTotalChegadaAteConferenciaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalChegadaAteEntregaExame), i, colSomaTempoTotalChegadaAteEntregaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMinutosIntervalo(somaTempoTotalChegadaAteImpressaoExame), i, colSomaTempoTotalChegadaAteImpressaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteChamadaGuiche, qtdeTempoTotalAteChamadaGuiche)), i, colMediaTempoTotalAteChamadaGuiche);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalAteGravacaoRequisicao, qtdeTempoTotalAteGravacaoRequisicao)), i, colMediaTempoTotalAteGravacaoRequisicao);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalChegadaAteColetaExame, qtdeTempoTotalChegadaAteColetaExame)), i, colMediaTempoTotalChegadaAteColetaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalChegadaAteDigitacaoExame, qtdeTempoTotalChegadaAteDigitacaoExame)), i, colMediaTempoTotalChegadaAteDigitacaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalChegadaAteConferenciaExame, qtdeTempoTotalChegadaAteConferenciaExame)), i, colMediaTempoTotalChegadaAteConferenciaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalChegadaAteEntregaExame, qtdeTempoTotalChegadaAteEntregaExame)), i, colMediaTempoTotalChegadaAteEntregaExame);
                modelo.setValueAt(RelatorioRequisicoesService.intervaloParaString(RelatorioRequisicoesService.getMediaIntervalo(somaTempoTotalChegadaAteImpressaoExame, qtdeTempoTotalChegadaAteImpressaoExame)), i, colMediaTempoTotalChegadaAteImpressaoExame);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteChamadaGuiche, qtdeTempoTotalAteChamadaGuiche), i, colMediaTempoTotalAteChamadaGuicheMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalAteGravacaoRequisicao, qtdeTempoTotalAteGravacaoRequisicao), i, colMediaTempoTotalAteGravacaoRequisicaoMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalChegadaAteColetaExame, qtdeTempoTotalChegadaAteColetaExame), i, colMediaTempoTotalChegadaAteColetaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalChegadaAteDigitacaoExame, qtdeTempoTotalChegadaAteDigitacaoExame), i, colMediaTempoTotalChegadaAteDigitacaoExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalChegadaAteConferenciaExame, qtdeTempoTotalChegadaAteConferenciaExame), i, colMediaTempoTotalChegadaAteConferenciaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalChegadaAteEntregaExame, qtdeTempoTotalChegadaAteEntregaExame), i, colMediaTempoTotalChegadaAteEntregaExameMinutos);
                modelo.setValueAt(RelatorioRequisicoesService.getMediaIntervaloMinutos(somaTempoTotalChegadaAteImpressaoExame, qtdeTempoTotalChegadaAteImpressaoExame), i, colMediaTempoTotalChegadaAteImpressaoExameMinutos);
            }
            if (!isColetaWeb && modelo.getRowCount() == 0) {
                Funcoes.mensagem(pai, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                if (acaoFimRelatorio != null) {
                    acaoFimRelatorio.run();
                }
                return null;
            }
            String layout = service.getLayoutRelatorio(tipoRelatorio, st);
            if (!Funcoes.textoVazio(layout)) {
                int i;
                Gerador gerador = null;
                if (isColetaWeb) {
                    gerador = new Gerador(casasPrecoExame, arredondamentoPrecoExame);
                } else {
                    gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(panel);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                }
                if (acaoFechar != null) {
                    gerador.setAcaoFechar(acaoFechar);
                }
                HashMap<String, Object> var = new HashMap<String, Object>();
                StringBuilder p = new StringBuilder();
                buf.delete(0, buf.length());
                if (filiais != null) {
                    for (i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_FILIAL));
                }
                var.put(FILTRO_FILIAL, buf.toString());
                buf.delete(0, buf.length());
                if (estacoes != null) {
                    for (i = 0; i < estacoes.length; ++i) {
                        buf.append(estacoes[i]);
                        if (i >= estacoes.length - 1) continue;
                        buf.append(",");
                    }
                } else if (!(acessoFiltrarEstacao || tipoDoRelatorio != 1 && tipoDoRelatorio != 16)) {
                    buf.append(codigoEstacao);
                }
                if (!Funcoes.textoVazio(buf.toString())) {
                    p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_ESTACOES));
                }
                var.put(FILTRO_ESTACAO, buf.toString());
                buf.delete(0, buf.length());
                if (usuarios != null) {
                    for (i = 0; i < usuarios.length; ++i) {
                        buf.append(usuarios[i]);
                        if (i >= usuarios.length - 1) continue;
                        buf.append(",");
                    }
                } else if (!(acessoFiltrarUsuario || tipoDoRelatorio != 1 && tipoDoRelatorio != 16)) {
                    buf.append(login);
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_USUARIO));
                var.put(FILTRO_USUARIO, buf.toString());
                buf.delete(0, buf.length());
                if (destinos != null) {
                    for (i = 0; i < destinos.length; ++i) {
                        buf.append(destinos[i]);
                        if (i >= destinos.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_DESTINO));
                var.put(FILTRO_DESTINO, buf.toString());
                buf.delete(0, buf.length());
                if (coletas != null) {
                    for (i = 0; i < coletas.length; ++i) {
                        buf.append(coletas[i]);
                        if (i >= coletas.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_COLETA));
                var.put(FILTRO_COLETA, buf.toString());
                buf.delete(0, buf.length());
                if (convenios != null) {
                    for (i = 0; i < convenios.length; ++i) {
                        buf.append(convenios[i]);
                        if (i >= convenios.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_CONVENIO));
                var.put(FILTRO_CONVENIO, buf.toString());
                buf.delete(0, buf.length());
                if (exames != null) {
                    for (i = 0; i < exames.length; ++i) {
                        buf.append(exames[i]);
                        if (i >= exames.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_EXAME));
                var.put(FILTRO_EXAME, buf.toString());
                buf.delete(0, buf.length());
                if (setores != null) {
                    for (i = 0; i < setores.length; ++i) {
                        buf.append(setores[i]);
                        if (i >= setores.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_SETORES));
                var.put(FILTRO_SETOR, buf.toString());
                buf.delete(0, buf.length());
                if (situacao != null) {
                    for (i = 0; i < situacao.length; ++i) {
                        buf.append(situacao[i]);
                        if (i >= situacao.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_SITUACAO_REQUISICAO));
                var.put(FILTRO_SITUACAO_REQUISICAO, buf.toString());
                buf.delete(0, buf.length());
                if (unidadeSaude != null) {
                    for (i = 0; i < unidadeSaude.length; ++i) {
                        buf.append(unidadeSaude[i]);
                        if (i >= unidadeSaude.length - 1) continue;
                        buf.append(",");
                    }
                }
                p.append(RelatorioRequisicoesService.gravaParametro(buf.toString(), PARAMETRO_UNIDADE_SAUDE));
                var.put(PARAMETRO_UNIDADE_SAUDE, buf.toString());
                if (tipoRelatorio == 4 || tipoRelatorio == 6) {
                    p.append(RelatorioRequisicoesService.gravaParametro(campoData, PARAMETRO_CAMPO_DATA));
                    var.put(FILTRO_CAMPODATA, campoData);
                }
                p.append(RelatorioRequisicoesService.gravaParametro(dataInicial, PARAMETRO_DATA_INICIAL));
                var.put(FILTRO_DATA_INICIAL, dataInicial);
                p.append(RelatorioRequisicoesService.gravaParametro(dataFinal, PARAMETRO_DATA_FINAL));
                var.put(FILTRO_DATA_FINAL, dataFinal);
                p.append(RelatorioRequisicoesService.gravaParametro(horaInicial, PARAMETRO_HORA_INICIAL));
                var.put(FILTRO_HORA_INICIAL, horaInicial);
                p.append(RelatorioRequisicoesService.gravaParametro(horaFinal, PARAMETRO_HORA_FINAL));
                var.put(FILTRO_HORA_FINAL, horaFinal);
                p.append(RelatorioRequisicoesService.gravaParametro(ordemSelecionada, PARAMETRO_ORDEM));
                var.put(FILTRO_ORDEM, ordemSelecionada);
                p.append(RelatorioRequisicoesService.gravaParametro(selecaoSexo, PARAMETRO_SEXO));
                var.put(FILTRO_SEXO, selecaoSexo);
                p.append(RelatorioRequisicoesService.gravaParametro(null != situacaoPagamento ? situacaoPagamento.toString() : "", PARAMETRO_SIT_PGTO));
                var.put(FILTRO_SITUACAO_PAGO, situacaoPagamento);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(deveGuia), "deveGuia"));
                var.put("deveGuia", deveGuia);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(intervaloHora), "intervaloHora"));
                var.put("intervaloHora", intervaloHora);
                if (tipoRelatorio == 13) {
                    buf.delete(0, buf.length());
                    if (pacienteFiltro != null) {
                        StringBuilder parPacientes = new StringBuilder();
                        StringBuilder pac = new StringBuilder();
                        Object[] valores = pacienteFiltro;
                        for (int i2 = 0; i2 < valores.length; ++i2) {
                            Object[] valor = (Object[])valores[i2];
                            for (int j = 0; j < valor.length; ++j) {
                                pac.append("<").append(j).append(">");
                                pac.append(valor[j]);
                                pac.append("</").append(j).append(">");
                            }
                            parPacientes.append(RelatorioRequisicoesService.gravaParametro(pac.toString(), PARAMETRO_PACIENTE));
                            pac.setLength(0);
                            buf.append(valor[0]).append(":").append(valor[0] + "(").append(valor[1] + ") ");
                        }
                        p.append(RelatorioRequisicoesService.gravaParametro(parPacientes.toString(), PARAMETRO_PACIENTES));
                    }
                    var.put(FILTRO_PACIENTE, buf.toString());
                }
                if (tipoDoRelatorio == 8) {
                    p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(campoDataImpresso), PARAMETRO_DATA));
                    var.put(FILTRO_POR_DATA, filtrarPorData[campoDataImpresso]);
                }
                if (tipoDoRelatorio == 1 || tipoDoRelatorio == 9 || tipoDoRelatorio == 16) {
                    p.append(RelatorioRequisicoesService.gravaParametro(situacaoAtual, PARAMETRO_SITUACAO));
                    var.put(FILTRO_SITUACAO, situacaoAtual);
                }
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(pacienteVIP), PARAMETRO_VIP));
                var.put(FILTRO_VIP, pacienteVIP);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(mostrarExameAvisarPaciente), PARAMETRO_AVISAR_PACIENTE));
                var.put(FILTRO_EXAME_AVISAR_PACIENTE, mostrarExameAvisarPaciente);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(somenteNaoTriadas), PARAMETRO_NAO_TRIADAS));
                var.put(FILTRO_SOMENTE_NAO_TRIADAS, somenteNaoTriadas);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(todosExamesMesmaSituacao), PARAMETRO_EXAMES_MESMA_SITUACAO));
                var.put(FILTRO_TODOS_EXAMES_MESMA_SITUACAO, todosExamesMesmaSituacao);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(urgente), PARAMETRO_URGENTE));
                var.put(FILTRO_URGENTE, urgente);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(considerarRespostas), PARAMETRO_CONSIDERAR_RESPOSTAS));
                var.put(FILTRO_CONSIDERAR_RESPOSTAS, considerarRespostas);
                p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(reqComTaxas), PARAMETRO_REQUISICAO_TAXAS));
                var.put(FILTRO_REQUISICAO_TAXAS, reqComTaxas);
                if (tipoRelatorio == 12) {
                    p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(apenasLoteExterno), "apenasLoteExterno"));
                    var.put("apenasLoteExterno", apenasLoteExterno);
                }
                if (tipoRelatorio != 3 && tipoRelatorio != 11 && tipoRelatorio != 12 && tipoRelatorio != 15 && tipoRelatorio != 2 && tipoRelatorio != 19) {
                    p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(resultadoCritico), PARAMETRO_RESULTADO_CRITICO));
                    var.put(FILTRO_RESULTADO_CRITICO, resultadoCritico);
                }
                if (tipoDoRelatorio == 14) {
                    p.append(RelatorioRequisicoesService.gravaParametro(String.valueOf(requisicaoInterfaceamento), "requisicoesInterfaceamento"));
                    var.put("requisicoesInterfaceamento", requisicaoInterfaceamento);
                }
                buf.delete(0, buf.length());
                if (medicosCrm != null && medicosUF != null) {
                    Object[] valores = medicoFiltro;
                    StringBuilder med = new StringBuilder();
                    for (int i3 = 0; i3 < valores.length; ++i3) {
                        med.append("<").append(PARAMETRO_MEDICO).append(">");
                        Object[] valor = (Object[])valores[i3];
                        for (int j = 0; j < valor.length; ++j) {
                            med.append("<").append(j).append(">");
                            med.append(valor[j]);
                            med.append("</").append(j).append(">");
                        }
                        med.append("</").append(PARAMETRO_MEDICO).append(">");
                        buf.append(valor[0]).append(":").append(valor[1] + "(").append(valor[2] + ") ");
                    }
                    p.append(RelatorioRequisicoesService.gravaParametro(med.toString(), PARAMETRO_MEDICOS));
                }
                var.put(FILTRO_MEDICO, buf.toString());
                var.put(FILTRO_ALA, alas);
                var.put(FILTRO_LEITO, leito);
                var.put(FILTRO_QUARTO, quarto);
                var.put(FILTRO_PRONTUARIO, prontuario);
                if (!isColetaWeb && null != listaUltimoFiltro && !listaUltimoFiltro.isEmpty() && listaUltimoFiltro.containsKey(tipoRelatorio)) {
                    ParametrosUsuarios.setValor(listaUltimoFiltro.get(tipoRelatorio), p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                }
                RetornoRelatorioRequisicoes retorno = new RetornoRelatorioRequisicoes();
                if (isColetaWeb) {
                    gerador.executar(layout, modelo, null, false, true, isColetaWeb);
                    retorno.setPdf(Impressao.gerarPdfRelatorio(gerador.getRelatorio(), layout));
                    retorno.setXmlFiltros(p.toString());
                    return retorno;
                }
                gerador.executar(layout, (TableModel)modelo, var);
                panel.revalidate();
            }
        } else {
            if (isColetaWeb) {
                return null;
            }
            Funcoes.mensagem(pai, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            if (acaoFimRelatorio != null) {
                acaoFimRelatorio.run();
            }
        }
        return null;
    }

    public static String getSelect(String[] filiais, String whereAdicional, int tipoDoRelatorio, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] cids, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] exames, String[] setores, String[] situacoes, String[] pacientes, String[] alas, String quarto, String leito, String prontuario, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String ordemSelecionada, String situacaoAtual, Boolean deveGuia, Boolean somenteNaoTriadas, Boolean intervaloHora, Boolean mostrarExamesAvisarPaciente, Boolean urgente, String[] unidadeSaude) {
        return RelatorioRequisicoes.getSelect(filiais, whereAdicional, tipoDoRelatorio, estacoes, usuarios, destinos, coletas, cids, convenios, medicosConselho, medicosCrm, medicosUF, exames, setores, situacoes, pacientes, alas, quarto, leito, prontuario, dataInicial, dataFinal, horaInicial, horaFinal, ordemSelecionada, situacaoAtual, deveGuia, somenteNaoTriadas, intervaloHora, 0, false, 0, mostrarExamesAvisarPaciente, false, false, false, unidadeSaude, "", "", false, false, Conexao.getStatement(), Variaveis.filialPadrao, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getPrecoMetodologia(), Variaveis.codigoEstacao, Variaveis.login, Acesso.getAcesso(ACESSO_FILTRARUSUARIO), Acesso.getAcesso(ACESSO_FILTRARESTACAO), ParametrosGerais.getQuantidadeMaximoFiltroAvancado(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante());
    }

    private static String getSelect(String[] filiais, String whereAdicional, int tipoDoRelatorio, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] cids, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] exames, String[] setores, String[] situacoes, String[] pacientes, String[] alas, String quarto, String leito, String prontuario, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String ordemSelecionada, String situacaoAtual, Boolean deveGuia, Boolean somenteNaoTriadas, Boolean intervaloHora, int situacaoPagamento, Boolean pacienteVIP, int campoDataImpresso, Boolean mostrarExamesAvisarPaciente, Boolean urgente, boolean reqComTaxas, boolean resultadoCritico, String[] unidadeSaude, String campoData, String selecaoSexo, Boolean requisicaoInterfaceamento, boolean apenasLoteExterno, Statement st, String filialPadrao, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, String codigoEstacao, String login, boolean acessoFiltrarUsuario, boolean acessoFiltrarEstacao, int quantidadeMaximoFiltroAvancado, boolean ordenarSetor, String ordemComprovante) {
        StringBuilder sqlLigacao = new StringBuilder();
        tipoRelatorio = tipoDoRelatorio;
        camposUtilizados = new HashMap();
        StringBuilder camposAux = new StringBuilder();
        camposUtilizados.put("codigoFilialCodigoRequisicao", "''");
        camposUtilizados.put("codigoRequisicao", "a.req_codigo");
        camposUtilizados.put("dataRequisicao", "a.req_data");
        camposUtilizados.put("dataFaturaRequisicao", "a.req_dtfatura");
        camposUtilizados.put("quantidadeTotalRequisicao", "''");
        camposUtilizados.put("quantidadeTotalExame", "''");
        camposUtilizados.put("urgenteRequisicao", "a.req_urgente");
        camposUtilizados.put("dataEntregaRequisicao", "a.req_dataentregaprev");
        camposUtilizados.put("dadosClinicosRequisicao", "a.req_dclinicos");
        camposUtilizados.put("notaCaixaRequisicao", "a.req_notacaixa");
        camposUtilizados.put("observacaoRequisicao", "a.req_obs");
        camposUtilizados.put("totalPagoRequisicao", "a.req_totpago");
        camposUtilizados.put("totalRequisicao", "a.req_total");
        camposUtilizados.put("totalTaxaRequisicao", "a.req_totaltaxa");
        camposUtilizados.put("horaEntregaRequisicao", "a.req_horaentregaprev");
        camposUtilizados.put("horaFaturaRequisicao", "a.req_horafatura");
        camposUtilizados.put("horaRequisicao", "a.req_hora");
        camposUtilizados.put("gestanteRequisicao", "a.req_gestante");
        camposUtilizados.put("dumRequisicao", "a.req_dum");
        camposUtilizados.put("matriculaRequisicao", "a.req_matricula");
        camposUtilizados.put("anomesIdadeRequisicao", "a.req_anomes");
        camposUtilizados.put("idadeRequisicao", "a.req_idade");
        camposUtilizados.put("avisarPacienteRequisicao", "a.req_avisarpaciente");
        camposUtilizados.put("senhaWebRequisicao", "a.req_senhaweb");
        camposUtilizados.put("titularRequisicao", "a.req_titular");
        camposUtilizados.put("alturaRequisicao", "a.req_altura");
        camposUtilizados.put("pesoRequisicao", "a.req_peso");
        camposUtilizados.put("valorAcrescimoRequisicao", "a.req_vlracrescimo");
        camposUtilizados.put("percentualAcrescimoRequisicao", "a.req_acrescimo");
        camposUtilizados.put("valorDescontoRequisicao", "a.req_vlrdesconto");
        camposUtilizados.put("percentualDescontoRequisicao", "a.req_desconto");
        camposUtilizados.put("coletadoRequisicao", "a.req_telacoleta");
        camposUtilizados.put("dataAberturaRequisicao", "a.req_datarequisicao");
        camposUtilizados.put("neonatoRequisicao", "a.req_neonato");
        camposUtilizados.put("validadeGuiaRequisicao", "a.req_validadeguia");
        camposUtilizados.put("guiaRequisicao", "a.req_guia");
        camposUtilizados.put("tipoUltimoPagamentoRequisicao", "a.req_tipoultpagamento");
        camposUtilizados.put("complementoDestinoRequisicao", "a.req_complementodestino");
        camposUtilizados.put("motivoExclusao", "a.req_motivoExclusao");
        camposUtilizados.put("guiaExameRequisicao", "b.exr_guia");
        camposUtilizados.put("situacaoExameRequisicao", "b.exr_situacao");
        camposUtilizados.put("entregueParaExameRequisicao", "b.exr_entrpara");
        camposUtilizados.put("dataAssinaturaExameRequisicao", "b.exr_dataassina");
        camposUtilizados.put("dataDigitacaoExameRequisicao", "b.exr_datadigita");
        camposUtilizados.put("dataColetaExameRequisicao", "b.exr_datamaterial");
        camposUtilizados.put("dataEntregueExameRequisicao", "b.exr_dataentreguerst");
        camposUtilizados.put("dataRecoletaExameRequisicao", "b.exr_datarecoleta");
        camposUtilizados.put("motivoRecoletaExameRequisicao", "b.exr_motivorecoleta");
        camposUtilizados.put("justificativaMotivoRecoleta", "b.exr_motivorecoleta");
        camposUtilizados.put("descricaoMotivoRecoleta", "mr.mrc_descricao");
        camposUtilizados.put("codigoMotivoRecoleta", "mr.mrc_codigo");
        camposUtilizados.put("dataRepeticaoExameRequisicao", "b.exr_datarepeticao");
        camposUtilizados.put("dataEtiquetaTriagemExameRequisicao", "b.exr_dataetqtriagem");
        camposUtilizados.put("naoFaturarExameRequisicao", "b.exr_naofaturar");
        camposUtilizados.put("dataTriagemExameRequisicao", "b.exr_datatriagem");
        camposUtilizados.put("dataEtqColetaExameRequisicao", "b.exr_dataetqcoleta");
        camposUtilizados.put("tempoDiureseExameRequisicao", "b.exr_tempodiurese");
        camposUtilizados.put("dataLoteExternoExameRequisicao", "b.exr_dataloteexterno");
        camposUtilizados.put("dataMaterialSetorExameRequisicao", "b.exr_datamaterialsetor");
        camposUtilizados.put("dataExcluidoExameRequisicao", "b.exr_dataexcluido");
        camposUtilizados.put("dataGuiaExameRequisicao", "b.exr_dataguia");
        camposUtilizados.put("validadeGuiaExameRequisicao", "b.exr_validadeguia");
        camposUtilizados.put("dataFaturaRepasseExameRequisicao", "b.exr_datafaturarepasse");
        camposUtilizados.put("urgenteExameRequisicao", "coalesce(b.exr_urgente, false)");
        camposUtilizados.put("dataImpressaoExameRequisicao", "b.exr_dataimpresso");
        camposUtilizados.put("dataFaturaExameRequisicao", "b.exr_datafatura");
        camposUtilizados.put("comissaoMedicoConvenio", "pegavalorcomissaomedicoconvenio(a.fil_codigo, a.con_codigo, a.med_crm, a.med_conselho, a.med_uf)");
        camposUtilizados.put("passaportePaciente", "paciente.pac_passaporte");
        camposUtilizados.put("generoPaciente", "idg.ige_descricao");
        camposUtilizados.put("procedenciaRequisicao", "a.req_procedencia");
        String[] perguntasFilial = RelatorioRequisicoes.getPerguntasFilial(filialPadrao, st);
        if (perguntasFilial.length > 0) {
            for (String s : perguntasFilial) {
                camposUtilizados.put(s, "''");
            }
        }
        camposAux.setLength(0);
        camposAux.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ");
        camposAux.append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ");
        camposAux.append(precoMetodologia ? "true" : "false").append(", b.met_codigo").append(")");
        camposUtilizados.put("valorTotalExameRequisicao", camposAux.toString());
        if (tipoDoRelatorio == 6) {
            camposAux.setLength(0);
            camposAux.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", b.met_codigo").append(") * ((100 - (a.req_desconto - a.req_acrescimo))/100)");
            camposUtilizados.put("valorLiquidoTotalExame", camposAux.toString());
        }
        camposAux.setLength(0);
        camposAux.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, false, true, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(casasPrecoExame).append(", ").append(arredondamentoPrecoExame.ordinal()).append(", ").append(precoMetodologia ? "true" : "false").append(", b.met_codigo").append(")");
        camposUtilizados.put("valorFaturarExameRequisicao", camposAux.toString());
        camposUtilizados.put("valorExameExameRequisicao", "b.exr_vlrexame");
        camposUtilizados.put("valorCHExameExameRequisicaoOriginal", "b.exr_vlrchexame");
        camposAux.setLength(0);
        camposAux.append("calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo)");
        camposUtilizados.put("valorCHExameExameRequisicao", camposAux.toString());
        camposAux.setLength(0);
        camposUtilizados.put("codigosMultiGuias", "(select array_to_string(array_agg(requisicao), ', ') from requisicoesMultiguia(a.fil_codigo, a.req_codigo))");
        camposUtilizados.put("tempoTotalAteColetaExame", "age(case when b.exr_situacao ='T' then b.exr_data else b.exr_datamaterial end, b.exr_data) ");
        camposUtilizados.put("tempoTotalAteDigitacaoExame", "age(coalesce(b.exr_datadigita, b.exr_data), b.exr_data) ");
        camposUtilizados.put("tempoTotalAteConferenciaExame", "age(coalesce(b.exr_dataassina, b.exr_data), b.exr_data)");
        camposUtilizados.put("tempoTotalAteImpressaoExame", "age(coalesce(b.exr_dataimpresso, b.exr_data), b.exr_data)");
        camposUtilizados.put("tempoTotalAteEntregaExame", "age(coalesce(b.exr_dataentreguerst, b.exr_data), b.exr_data)");
        camposUtilizados.put("tempoTotalColetaAteDigitacaoExame", "age(coalesce(b.exr_datadigita, b.exr_datamaterial), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteConferenciaExame", "age(coalesce(b.exr_dataassina, b.exr_datamaterial), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteImpressaoExame", "age(coalesce(b.exr_dataimpresso, b.exr_datamaterial), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteEntregaExame", "age(coalesce(b.exr_dataentreguerst, b.exr_datamaterial), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalAteColetaExameMinutos", "age(coalesce(b.exr_datamaterial, b.exr_data), b.exr_data) ");
        camposUtilizados.put("tempoTotalAteDigitacaoExameMinutos", "age(coalesce(b.exr_datadigita, b.exr_data), b.exr_data) ");
        camposUtilizados.put("tempoTotalAteConferenciaExameMinutos", "age(coalesce(b.exr_dataassina, b.exr_data), b.exr_data)");
        camposUtilizados.put("tempoTotalAteImpressaoExameMinutos", "age(coalesce(b.exr_dataimpresso, b.exr_data), b.exr_data)");
        camposUtilizados.put("tempoTotalAteEntregaExameMinutos", "age(coalesce(b.exr_dataentreguerst, b.exr_data), b.exr_data)");
        camposUtilizados.put("tempoTotalColetaAteDigitacaoExameMinutos", "age(coalesce(b.exr_datadigita, b.exr_data), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteConferenciaExameMinutos", "age(coalesce(b.exr_dataassina, b.exr_data), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteImpressaoExameMinutos", "age(coalesce(b.exr_dataimpresso, b.exr_data), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteEntregaExameMinutos", "age(coalesce(b.exr_dataentreguerst, b.exr_data), b.exr_datamaterial)");
        camposUtilizados.put("tempoTotalColetaAteConferenciaExameMinutos", "age(coalesce(b.exr_dataassina, b.exr_data), b.exr_datamaterial)");
        if (precoMetodologia) {
            camposAux.setLength(0);
            camposAux.append(" COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), dtp.dtp_codamb) ");
            camposUtilizados.put("codigoAMBExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
            camposAux.append(" case when convenio.con_precosdiferenciados = true then cpr.cpr_valor ");
            camposAux.append("      else COALESCE(dtm.dtm_valor, dtp.dtp_valor) end ");
            camposUtilizados.put("valorCHExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
            camposAux.append(" case when convenio.con_precosdiferenciados = true then cpr.cpr_percentual ");
            camposAux.append("      else COALESCE(dtm.dtm_percentual, dtp.dtp_percentual) end ");
            camposUtilizados.put("percentualCBHPMExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
            camposAux.append(" case when convenio.con_precosdiferenciados = true then ");
            camposAux.append(" cpr.tpp_porte ");
            camposAux.append(" else ");
            camposAux.append(" COALESCE(dtm.tpp_porte, dtp.tpp_porte) ");
            camposAux.append(" end ");
            camposUtilizados.put("porteCBHPMExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
        } else {
            camposAux.setLength(0);
            camposAux.append(" dtp.dtp_codamb ");
            camposUtilizados.put("codigoAMBExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
            camposAux.append(" case when convenio.con_precosdiferenciados = true then cpr.cpr_valor ");
            camposAux.append("      else dtp.dtp_valor end ");
            camposUtilizados.put("valorCHExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
            camposAux.append(" case when convenio.con_precosdiferenciados = true then cpr.cpr_percentual ");
            camposAux.append("      else dtp.dtp_percentual end ");
            camposUtilizados.put("percentualCBHPMExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
            camposAux.append(" case when convenio.con_precosdiferenciados = true then ");
            camposAux.append(" cpr.tpp_porte ");
            camposAux.append(" else ");
            camposAux.append(" dtp.tpp_porte ");
            camposAux.append(" end ");
            camposUtilizados.put("porteCBHPMExameTabelaPreco", camposAux.toString());
            camposAux.setLength(0);
        }
        camposUtilizados.put("materialExternoExameRequisicao", "b.exr_matexterno");
        camposUtilizados.put("dataEntregaExameRequisicao", "b.exr_dataentregaprev");
        camposUtilizados.put("interfaceadoExameRequisicao", "b.exr_interfaciado");
        camposUtilizados.put("loteReagenteExameRequisicao", "b.exr_lotereag");
        camposUtilizados.put("quantidadeReagenteExameRequisicao", "b.exr_quantreag");
        camposUtilizados.put("valorCHExameRequisicaoOriginal", "b.exr_vlrch");
        camposUtilizados.put("valorCHExameRequisicao", "calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo)");
        camposUtilizados.put("valorMaterialExameRequisicao", "b.exr_vlrmaterial");
        camposUtilizados.put("valorPagoBalcaoExameRequisicao", "b.exr_vlrbalcaoconvenio");
        camposUtilizados.put("dataImpressaoMapaExameRequisicao", "b.exr_datamapa");
        camposUtilizados.put("codigoAutorizacaoExameRequisicao", "b.exr_codautorizacao");
        camposUtilizados.put("dataInsercaoExameRequisicao", "b.exr_data");
        camposUtilizados.put("observacaoExameRequisicao", "b.exr_obs");
        camposUtilizados.put("dataCortesiaExameRequisicao", "b.exr_datacortesia");
        camposUtilizados.put("serialReagenteExameRequisicao", "b.exr_serialreag");
        camposUtilizados.put("autorizarExameRequisicao", "b.exr_autorizar");
        camposUtilizados.put("coletaIncorreta", "b.exr_coletaincorreta");
        camposUtilizados.put("motivoColetaIncorreta", "b.exr_motivocoletaincorreta");
        camposUtilizados.put("usuarioColetaIncorreta", "b.usr_codcoletaincorreta");
        camposUtilizados.put("tempoJejumExameRequisicao", "CASE WHEN b.exr_intervalojejum IS NULL THEN TO_CHAR(b.exr_tempojejum, 'HH24:MI') ELSE TO_CHAR(b.exr_intervalojejum, 'HH24:MI') END");
        camposUtilizados.put("descricaoMaterialInformadoExameRequisicao", "b.exr_descricaomaterial");
        camposUtilizados.put("observacaoPrazoCarenciaExameRequisicao", "b.exr_motivoprazo");
        camposUtilizados.put("avisarPacienteExameRequisicao", "b.exr_avisarentrega");
        camposUtilizados.put("medicamentosRequisicao", "(select array_to_string(array_agg(medicamentosrequisicao), ', ') from medicamentosRequisicao(a.fil_codigo, a.req_codigo))");
        camposUtilizados.put("quartoRequisicao", "a.req_quarto");
        camposUtilizados.put("leitoRequisicao", "a.req_leito");
        camposUtilizados.put("codigoAla", "ala.ala_codigo");
        camposUtilizados.put("descricaoAla", "ala.ala_descricao");
        camposUtilizados.put("codigoPaciente", "paciente.pac_codigo");
        camposUtilizados.put("nomePaciente", "paciente.pac_nome");
        camposUtilizados.put("nomeSocialPaciente", "paciente.pac_nomesocial");
        camposUtilizados.put("dataNascimentoPaciente", "paciente.pac_datanasc");
        camposUtilizados.put("sexoPaciente", "paciente.pac_sexo");
        camposUtilizados.put("vipPaciente", "paciente.pac_vip");
        camposUtilizados.put("grupoSanguineoPaciente", "paciente.pac_grpsangue");
        camposUtilizados.put("fatorrhPaciente", "paciente.pac_fatorrh");
        camposUtilizados.put("fatorduPaciente", "paciente.pac_fatordu");
        camposUtilizados.put("corPaciente", "paciente.pac_cor");
        camposUtilizados.put("observacaoPaciente", "paciente.pac_observ");
        camposUtilizados.put("dadosClinicosPaciente", "paciente.pac_dadoclinico");
        camposUtilizados.put("pesoPaciente", "paciente.pac_peso");
        camposUtilizados.put("alturaPaciente", "paciente.pac_altura");
        camposUtilizados.put("matriculaConvenioPaciente", "paciente.pac_matricconv");
        camposUtilizados.put("titularConvenioPaciente", "paciente.pac_titularconv");
        camposUtilizados.put("profissaoPaciente", "paciente.pac_profissao");
        camposUtilizados.put("fumantePaciente", "paciente.pac_fumante");
        camposUtilizados.put("diabeticoPaciente", "paciente.pac_diabetico");
        camposUtilizados.put("rgPaciente", "paciente.pac_rg");
        camposUtilizados.put("cpfPaciente", "paciente.pac_cpf");
        camposUtilizados.put("estadoCivilPaciente", "paciente.pac_estcivil");
        camposUtilizados.put("numeroFilhosPaciente", "paciente.pac_numfilho");
        camposUtilizados.put("dataHoraCadastroPaciente", "paciente.pac_datahora");
        camposUtilizados.put("dumPaciente", "paciente.pac_dum");
        camposUtilizados.put("faxPaciente", "paciente.pac_fax");
        camposUtilizados.put("celularPaciente", "paciente.pac_celular");
        camposUtilizados.put("foneComercialPaciente", "paciente.pac_fonecomercial");
        camposUtilizados.put("fonePaciente", "paciente.pac_fone");
        camposUtilizados.put("cepPaciente", "paciente.pac_cep");
        camposUtilizados.put("complementoPaciente", "paciente.pac_complemento");
        camposUtilizados.put("enderecoPaciente", "paciente.pac_endereco");
        camposUtilizados.put("numeroEnderecoPaciente", "paciente.pac_numeroendereco");
        camposUtilizados.put("emailPaciente", "paciente.pac_email");
        camposUtilizados.put("tipoLogradouroPaciente", "paciente.pac_tipologradouroendereco");
        camposUtilizados.put("anomesIdadePaciente", "paciente.pac_anomes");
        camposUtilizados.put("idadePaciente", "paciente.pac_idade");
        camposUtilizados.put("foneContatoPaciente", "paciente.pac_fonecontato");
        camposUtilizados.put("contatoPaciente", "paciente.pac_nomecontato");
        camposUtilizados.put("maePaciente", "paciente.pac_mae");
        camposUtilizados.put("paiPaciente", "paciente.pac_pai");
        camposUtilizados.put("codigoCidadePaciente", "cidpaciente.cid_codigo");
        camposUtilizados.put("descricaoCidadePaciente", "cidpaciente.cid_nome");
        camposUtilizados.put("estadoCidadePaciente", "cidpaciente.cid_uf");
        camposUtilizados.put("codigoBairroPaciente", "baipaciente.bai_codigo");
        camposUtilizados.put("descricaoBairroPaciente", "baipaciente.bai_descricao");
        camposUtilizados.put("codigoUsuarioRequisicao", "usrrequisicao.usr_codigo");
        camposUtilizados.put("nomeUsuarioRequisicao", "usrrequisicao.usr_nome");
        camposUtilizados.put("codigoUsuarioAberturaRequisicao", "usrabertura.usr_codigo");
        camposUtilizados.put("nomeUsuarioAberturaRequisicao", "usrabertura.usr_nome");
        camposUtilizados.put("codigoDestino", "destino.des_codigo");
        camposUtilizados.put("descricaoDestino", "destino.des_descricao");
        camposUtilizados.put("impressoraDestino", "destino.des_impressora");
        camposUtilizados.put("naoImprimirDestino", "destino.des_naoimprimir");
        camposUtilizados.put("cepDestino", "destino.des_cep");
        camposUtilizados.put("complementoDestino", "destino.des_complemento");
        camposUtilizados.put("enderecoDestino", "destino.des_endereco");
        camposUtilizados.put("foneDestino", "destino.des_fone");
        camposUtilizados.put("enviarWebDestino", "destino.des_enviarweb");
        camposUtilizados.put("codigoCidadeDestino", "ciddestino.cid_codigo");
        camposUtilizados.put("descricaoCidadeDestino", "ciddestino.cid_nome");
        camposUtilizados.put("estadoCidadeDestino", "ciddestino.cid_uf");
        camposUtilizados.put("codigoBairroDestino", "baidestino.bai_codigo");
        camposUtilizados.put("descricaoBairroDestino", "baidestino.bai_descricao");
        camposUtilizados.put("codigoColeta", "coleta.col_codigo");
        camposUtilizados.put("descricaoColeta", "coleta.col_descricao");
        camposUtilizados.put("cepColeta", "coleta.col_cep");
        camposUtilizados.put("complementoColeta", "coleta.col_complemento");
        camposUtilizados.put("enderecoColeta", "coleta.col_endereco");
        camposUtilizados.put("foneColeta", "coleta.col_fone");
        camposUtilizados.put("codigoCidadeColeta", "cidcoleta.cid_codigo");
        camposUtilizados.put("descricaoCidadeColeta", "cidcoleta.cid_nome");
        camposUtilizados.put("estadoCidadeColeta", "cidcoleta.cid_uf");
        camposUtilizados.put("codigoBairroColeta", "baicoleta.bai_codigo");
        camposUtilizados.put("descricaoBairroColeta", "baicoleta.bai_descricao");
        camposUtilizados.put("codigoSetor", "setor.set_codigo");
        camposUtilizados.put("descricaoSetor", "setor.set_descricao");
        camposUtilizados.put("responsavelSetor", "setor.set_responsavel");
        camposUtilizados.put("siglaSetor", "setor.set_sigla");
        camposUtilizados.put("corSetor", "setor.set_cor");
        camposUtilizados.put("codigoUsuarioSetor", "usrsetor.usr_codigo");
        camposUtilizados.put("nomeUsuarioSetor", "usrsetor.usr_nome");
        camposUtilizados.put("codigoConvenio", "convenio.con_codigo");
        camposUtilizados.put("razaoSocialConvenio", "convenio.con_razao");
        camposUtilizados.put("fantasiaConvenio", "convenio.con_fantasia");
        camposUtilizados.put("cnpjConvenio", "convenio.con_cnpjcpf");
        camposUtilizados.put("tipoPagamentoConvenio", "convenio.con_tppgto");
        camposUtilizados.put("faturarFaltaMaterialConvenio", "convenio.con_fatfmaterial");
        camposUtilizados.put("habilitarDescontoConvenio", "convenio.con_descexame");
        camposUtilizados.put("normaConvenio", "convenio.con_norma");
        camposUtilizados.put("multaConvenio", "convenio.con_multa");
        camposUtilizados.put("moraConvenio", "convenio.con_mora");
        camposUtilizados.put("faturarFiliaisConvenio", "convenio.con_fatfiliais");
        camposUtilizados.put("quantidade1ViaConvenio", "convenio.con_nr1via");
        camposUtilizados.put("numeroExamesConvenio", "convenio.con_nrexames");
        camposUtilizados.put("viasFaturaConvenio", "convenio.con_viasfatura");
        camposUtilizados.put("imprimirBloquetoConvenio", "convenio.con_impbloqueto");
        camposUtilizados.put("quantidade2ViaConvenio", "convenio.con_nr2via");
        camposUtilizados.put("tipoCalculoFaturaConvenio", "convenio.con_tpcalcfatu");
        camposUtilizados.put("percentualBalcaoConvenio", "coalesce(convenio.con_percpgto, 0)");
        camposUtilizados.put("cobrarExameBalcaoConvenio", "convenio.con_cobrexame");
        camposUtilizados.put("inscricaoEstadualConvenio", "convenio.con_inscrest");
        camposUtilizados.put("titularDependenteConvenio", "convenio.con_titdep");
        camposUtilizados.put("mascaraCarteiraConvenio", "convenio.con_maskcart");
        camposUtilizados.put("contatoConvenio", "convenio.con_contato");
        camposUtilizados.put("obrigaMatriculaConvenio", "convenio.con_informarmat");
        camposUtilizados.put("cepConvenio", "convenio.con_cep");
        camposUtilizados.put("complementoConvenio", "convenio.con_complemento");
        camposUtilizados.put("enderecoConvenio", "convenio.con_endereco");
        camposUtilizados.put("numeroEnderecoConvenio", "convenio.con_numeroendereco");
        camposUtilizados.put("tipoLogradouroConvenio", "convenio.con_tipologradouroendereco");
        camposUtilizados.put("cepCobrancaConvenio", "convenio.con_cepcobranca");
        camposUtilizados.put("complementoCobrancaConvenio", "convenio.con_complcobranca");
        camposUtilizados.put("enderecoCobrancaConvenio", "convenio.con_endcobranca");
        camposUtilizados.put("faxConvenio", "convenio.con_fax");
        camposUtilizados.put("numeroEnderecoCobrancaConvenio", "convenio.con_numeroendcobranca");
        camposUtilizados.put("tipoLogradouroCobrancaConvenio", "convenio.con_tipologradouroendcobranca");
        camposUtilizados.put("foneConvenio", "convenio.con_fone");
        camposUtilizados.put("valorFilmeConvenio", "convenio.con_valorfilme");
        camposUtilizados.put("valorCHConvenio", "convenio.con_valorch");
        camposUtilizados.put("siteConvenio", "convenio.con_site");
        camposUtilizados.put("email2Convenio", "convenio.con_email2");
        camposUtilizados.put("email1Convenio", "convenio.con_email1");
        camposUtilizados.put("tipoCalculoCHConvenio", "convenio.con_tpcalcch");
        camposUtilizados.put("inscricaoMunicipalConvenio", "convenio.con_inscmunic");
        camposUtilizados.put("percentualBonusConvenio", "convenio.con_bonus");
        camposUtilizados.put("senhaWebConvenio", "convenio.con_senhaweb");
        camposUtilizados.put("percentualAcrescimoConvenio", "convenio.con_acrescimo");
        camposUtilizados.put("proibidoWebConvenio", "convenio.con_proibidoweb");
        camposUtilizados.put("obrigaValidadeGuiaConvenio", "convenio.con_validadeguia");
        camposUtilizados.put("obrigaGuiaConvenio", "convenio.con_codigoguia");
        camposUtilizados.put("diasValidadeGuia", "convenio.con_diasvalidade");
        camposUtilizados.put("ordemFaturaConvenio", "convenio.con_ordemfatura");
        camposUtilizados.put("cobrarMateriaisConvenio", "convenio.con_cobrmaterial");
        camposUtilizados.put("codigoPrioridade", "prioridade.pri_codigo");
        camposUtilizados.put("descricaoPrioridade", "prioridade.pri_descricao");
        camposUtilizados.put("codigoTabela", "tabela.tpe_codigo");
        camposUtilizados.put("descricaoTabela", "tabela.tpe_descricao");
        camposUtilizados.put("valorCHTabela", "tabela.tpe_valorch");
        camposUtilizados.put("moedaTabela", "tabela.tpe_moeda");
        camposUtilizados.put("codigoCidadeConvenio", "cidconvenio.cid_codigo");
        camposUtilizados.put("descricaoCidadeConvenio", "cidconvenio.cid_nome");
        camposUtilizados.put("estadoCidadeConvenio", "cidconvenio.cid_uf");
        camposUtilizados.put("codigoBairroConvenio", "baiconvenio.bai_codigo");
        camposUtilizados.put("descricaoBairroConvenio", "baiconvenio.bai_descricao");
        camposUtilizados.put("codigoModelo", "layout.lay_codigo");
        camposUtilizados.put("descricaoModelo", "layout.lay_descricao");
        camposUtilizados.put("conselhoMedico", "medico.med_conselho");
        camposUtilizados.put("crmMedico", "medico.med_crm");
        camposUtilizados.put("ufMedico", "medico.med_uf");
        camposUtilizados.put("nomeMedico", "medico.med_nome");
        camposUtilizados.put("abreviaturaMedico", "medico.med_abrev");
        camposUtilizados.put("tipoMedico", "medico.med_tipo");
        camposUtilizados.put("comissaoMedico", "medico.med_comissao");
        camposUtilizados.put("cepMedico", "medico.med_cep");
        camposUtilizados.put("complementoMedico", "medico.med_complemento");
        camposUtilizados.put("enderecoMedico", "medico.med_endereco");
        camposUtilizados.put("celularMedico", "medico.med_celular");
        camposUtilizados.put("faxMedico", "medico.med_fax");
        camposUtilizados.put("numeroEnderecoMedico", "medico.med_numeroendereco");
        camposUtilizados.put("tipoLogradouroMedico", "medico.med_tipologradouroendereco");
        camposUtilizados.put("foneMedico", "medico.med_fone");
        camposUtilizados.put("emailMedico", "medico.med_email");
        camposUtilizados.put("siteMedico", "medico.med_site");
        camposUtilizados.put("senhaWebMedico", "medico.med_senhaweb");
        camposUtilizados.put("codigoCidadeMedico", "cidmedico.cid_codigo");
        camposUtilizados.put("descricaoCidadeMedico", "cidmedico.cid_nome");
        camposUtilizados.put("estadoCidadeMedico", "cidmedico.cid_uf");
        camposUtilizados.put("codigoBairroMedico", "baimedico.bai_codigo");
        camposUtilizados.put("descricaoBairroMedico", "baimedico.bai_descricao");
        camposUtilizados.put("codigoUsuarioAssina", "usrassina.usr_codigo");
        camposUtilizados.put("nomeUsuarioAssina", "usrassina.usr_nome");
        camposUtilizados.put("codigoUsuarioDigitador", "usrdigitador.usr_codigo");
        camposUtilizados.put("nomeUsuarioDigitador", "usrdigitador.usr_nome");
        camposUtilizados.put("codigoUsuarioMaterial", "usrmaterial.usr_codigo");
        camposUtilizados.put("nomeUsuarioMaterial", "usrmaterial.usr_nome");
        camposUtilizados.put("codigoUsuarioRecoleta", "usrrecoleta.usr_codigo");
        camposUtilizados.put("nomeUsuarioRecoleta", "usrrecoleta.usr_nome");
        camposUtilizados.put("codigoUsuarioRepeticao", "usrrepeticao.usr_codigo");
        camposUtilizados.put("nomeUsuarioRepeticao", "usrrepeticao.usr_nome");
        camposUtilizados.put("codigoUsuarioFatura", "usrfatura.usr_codigo");
        camposUtilizados.put("nomeUsuarioFatura", "usrFatura.usr_nome");
        camposUtilizados.put("codigoUsuarioEntrega", "usrentrega.usr_codigo");
        camposUtilizados.put("nomeUsuarioEntrega", "usrentrega.usr_nome");
        camposUtilizados.put("codigoUsuarioImpressao", "usrimpressao.usr_codigo");
        camposUtilizados.put("nomeUsuarioImpressao", "usrimpressao.usr_nome");
        camposUtilizados.put("codigoUsuarioExame", "usrexame.usr_codigo");
        camposUtilizados.put("nomeUsuarioExame", "usrexame.usr_nome");
        camposUtilizados.put("codigoUsuarioMapa", "usrmapa.usr_codigo");
        camposUtilizados.put("nomeUsuarioMapa", "usrmapa.usr_nome");
        camposUtilizados.put("codigoUsuarioCortesia", "usrcortesia.usr_codigo");
        camposUtilizados.put("nomeUsuarioCortesia", "usrcortesia.usr_nome");
        camposUtilizados.put("codigoUsuarioAColetar", "COALESCE(usracoletar.usr_codigo, a.usr_codabertura)");
        camposUtilizados.put("nomeUsuarioAColetar", "COALESCE(usracoletar.usr_nome, usrabertura.usr_nome)");
        if (tipoRelatorio == 15) {
            camposUtilizados.put("codigoUsuarioExclusao", "COALESCE(usrexclusao.usr_codigo, a.usr_codabertura)");
            camposUtilizados.put("nomeUsuarioExclusao", "COALESCE(usrexclusao.usr_nome, usrabertura.usr_nome)");
        } else {
            camposUtilizados.put("codigoUsuarioExclusao", "usrexclusao.usr_codigo");
            camposUtilizados.put("nomeUsuarioExclusao", "usrexclusao.usr_nome");
        }
        if (tipoRelatorio == 19) {
            camposUtilizados.put("codigoUsuarioTransporte", "COALESCE(usrtransporte.usr_codigo, a.usr_codabertura)");
            camposUtilizados.put("nomeUsuarioTransporte", "COALESCE(usrtransporte.usr_nome, usrabertura.usr_nome)");
        } else {
            camposUtilizados.put("codigoUsuarioTransporte", "usrtransporte.usr_codigo");
            camposUtilizados.put("nomeUsuarioTransporte", "usrtransporte.usr_nome");
        }
        if (tipoRelatorio != 3 && tipoRelatorio != 11 && tipoRelatorio != 12 && tipoRelatorio != 15 && tipoRelatorio != 2 && tipoRelatorio != 19) {
            camposUtilizados.put(PARAMETRO_RESULTADO_CRITICO, "ert.ert_resultado");
        }
        camposUtilizados.put("codigoExame", "c.exa_codigo");
        camposUtilizados.put("descricaoExame", "c.exa_descricao");
        camposUtilizados.put("sexoExame", "c.exa_sexo");
        camposUtilizados.put("horaEntradaExame", "c.exa_horaentrada");
        camposUtilizados.put("horaSaidaExame", "c.exa_horasaida");
        camposUtilizados.put("textoFiltroExame", "c.exa_filtro");
        camposUtilizados.put("proibidoExame", "c.exa_proibido");
        camposUtilizados.put("idadeMaximaExame", "c.exa_idademax");
        camposUtilizados.put("idadeMinimaExame", "c.exa_idademin");
        camposUtilizados.put("tipoIdadeMaximaExame", "c.exa_idademaxtipo");
        camposUtilizados.put("tipoIdadeMinimaExame", "c.exa_idademintipo");
        camposUtilizados.put("proibidoWebExame", "c.exa_proibidoweb");
        camposUtilizados.put("quantidadeAmostrasExame", "c.exa_qtdeamostras");
        camposUtilizados.put("padraoExame", "d.emc_default");
        camposUtilizados.put("ordemExame", "d.emc_ordem");
        camposUtilizados.put("paginaExame", "d.emc_pagina");
        camposUtilizados.put("codigoCBHPMExame", "d.emc_codigocbhpm");
        camposUtilizados.put("codigoAMBExame", "d.emc_codigoamb");
        camposUtilizados.put("solicitarJejumExame", "d.emc_solicitarjejum");
        camposUtilizados.put("solicitarMedicamentoExame", "d.emc_obrigamedicamento");
        camposUtilizados.put("solicitarDUMExame", "d.emc_obrigadum");
        camposUtilizados.put("solicitarPesoExame", "d.emc_obrigapeso");
        camposUtilizados.put("solicitarAlturaExame", "d.emc_obrigaaltura");
        camposUtilizados.put("solicitarVolumeExame", "d.emc_obrigavolume");
        camposUtilizados.put("solicitarTempoDiureseExame", "d.emc_obrigatempodiurese");
        camposUtilizados.put("marcarExternoExame", "d.emc_marcarexterno");
        camposUtilizados.put("codigoMaterialColetado", "coletado.mco_codigo");
        camposUtilizados.put("descricaoMaterialColetado", "coletado.mco_descricao");
        camposUtilizados.put("abreviaturaMaterialColetado", "coletado.mco_abreviatura");
        camposUtilizados.put("codigoPrazoEntrega", "prazo.prz_codigo");
        camposUtilizados.put("descricaoPrazoEntrega", "prazo.prz_descricao");
        camposUtilizados.put("diasPrazoEntrega", "prazo.prz_dias");
        camposUtilizados.put("horaEntradaPrazoEntrega", "prazo.prz_horaentrada");
        camposUtilizados.put("horaSaidaPrazoEntrega", "prazo.prz_horasaida");
        camposUtilizados.put("rotinaPrazoEntrega", "prazo.prz_prazo");
        camposUtilizados.put("codigoMetodologia", "metodologia.met_codigo");
        camposUtilizados.put("descricaoMetodologia", "metodologia.met_descricao");
        camposUtilizados.put("codigoEstacao", "a.est_codigo");
        camposUtilizados.put("descricaoEstacao", "estacoes.est_descricao");
        camposUtilizados.put("prontuarioRequisicao", "a.req_prontuario");
        camposUtilizados.put("codigoSituacao", "sit.sit_codigo");
        camposUtilizados.put("descricaoSituacao", "sit.sit_descricao");
        camposUtilizados.put("detalhamentoTaxasRequisicao", "''");
        camposUtilizados.put("descricaoProdutoRequisicao", "a.req_descricaoproduto");
        camposUtilizados.put("dataFabricacaoProdutoRequisicao", "a.req_datafabricacao");
        camposUtilizados.put("numeroRegistroProdutoRequisicao", "a.req_numeroregistroproduto");
        camposUtilizados.put("temperaturaColetaProdutoRequisicao", "a.req_temperaturacoletaproduto");
        camposUtilizados.put("numeroLoteProdutoRequisicao", "a.req_numeroloteproduto");
        camposUtilizados.put("dataValidadeProdutoRequisicao", "a.req_datavalidade");
        camposUtilizados.put("marcaProdutoRequisicao", "a.req_marcaproduto");
        camposUtilizados.put("lacreProdutoRequisicao", "a.req_lacreproduto");
        camposUtilizados.put("lacreContraProvaProdutoRequisicao", "a.req_lacreprodutocontra");
        camposUtilizados.put("localColetaProdutoRequisicao", "a.req_localcoletaproduto");
        camposUtilizados.put("lacreContraProvaEmpresaProdutoRequisicao", "a.req_lacreprodutocontraempresa");
        camposUtilizados.put("documentoReferenciaProdutoRequisicao", "a.req_doctoreferenciaproduto");
        camposUtilizados.put("temperaturaRecebimentoProdutoRequisicao", "a.req_temperaturarecebimento");
        camposUtilizados.put("caracteristicasSanitariasProdutoRequisicao", "a.req_sanitariasproduto");
        camposUtilizados.put("condicoesAmbientaisProdutoRequisicao", "a.req_condicoesambproduto");
        camposUtilizados.put("procedimentoColetaProdutoRequisicao", "a.req_procedimentocoletaproduto");
        camposUtilizados.put("tipoRecebimentoProdutoRequisicao", "a.req_tiporecebimentoproduto");
        camposUtilizados.put("partidaProdutoRequisicao", "a.req_partidaproduto");
        camposUtilizados.put("qtdeAmostrasProdutoRequisicao", "a.req_qtdeamostraproduto");
        camposUtilizados.put("qtdeUnidadeProdutoRequisicao", "a.req_qtdeunidadeproduto");
        camposUtilizados.put("codigoUnidadeProdutoRequisicao", "a.unm_codigo");
        camposUtilizados.put("dataRecebeuGuiaRequisicao", "a.req_datarecebeuguia");
        camposUtilizados.put("dataGuiaConferidaRequisicao", "a.req_dataguiaconferida");
        camposUtilizados.put("dataRecebimentoProdutoRequisicao", "a.req_datarecebimentoproduto");
        camposUtilizados.put("horaRecebimentoProdutoRequisicao", "a.req_horarecebimentoproduto");
        camposUtilizados.put("validadeCarteiraRequisicao", "a.req_validadecarteira");
        camposUtilizados.put("validadeGuiaRepasseRequisicao", "a.req_validadeguiarepasse");
        camposUtilizados.put("validadeCarteiraRepasseRequisicao", "a.req_validadecarteirarepasse");
        camposUtilizados.put("dataRecebeuGuiaRepasseRequisicao", "a.req_datarecebeuguiarepasse");
        camposUtilizados.put("dataColetaProdutoRequisicao", "a.req_datacoletaproduto");
        camposUtilizados.put("horaColetaProdutoRequisicao", "a.req_horacoletaproduto");
        camposUtilizados.put("fornecedorProdutoRequisicao", "a.req_fornecedorproduto");
        camposUtilizados.put("descricaoUnidadeProdutoRequisicao", "unidademedida.unm_descricao");
        camposUtilizados.put("codigoEmbalagemProdutoRequisicao", "a.emb_codigo");
        camposUtilizados.put("descricaoEmbalagemProdutoRequisicao", "emb.emb_descricao");
        camposUtilizados.put("nomeResponsavelRequisicao_", "paccontatos.pco_nome");
        camposUtilizados.put("cargoResponsavelRequisicao_", "paccontatos.pco_cargo");
        camposUtilizados.put("emailResponsavelRequisicao_", "paccontatos.pco_email");
        camposUtilizados.put("foneResponsavelRequisicao_", "paccontatos.pco_fone");
        camposUtilizados.put("codigoProdutoAlimento", "pal.pal_codigo");
        camposUtilizados.put("descricaoProdutoAlimento", "pal.pal_descricao");
        camposUtilizados.put("codigoCategoriaProdutoAlimento", "cpl.cpl_codigo");
        camposUtilizados.put("descricaoCategoriaProdutoAlimento", "cpl.cpl_descricao");
        camposUtilizados.put("perguntasRequisicao", "a.req_perguntas");
        camposUtilizados.put("codigoEspecie", "paciente.epc_codigo");
        camposUtilizados.put("descricaoEspecie", "''");
        camposUtilizados.put("codigoRaca", "paciente.rac_codigo");
        camposUtilizados.put("descricaoRaca", "''");
        camposUtilizados.put("pelagem", "paciente.pac_pelagem");
        camposUtilizados.put("nomeResponsavelRequisicao", "ent.ent_fantasia");
        camposUtilizados.put("cargoResponsavelRequisicao", "ent.ent_cargo");
        camposUtilizados.put("emailResponsavelRequisicao", "ent.ent_email");
        camposUtilizados.put("foneResponsavelRequisicao", "ent.ent_fone");
        camposUtilizados.put("razaoSocialResponsavelRequisicao", "ent.ent_razaosocial");
        camposUtilizados.put("enderecoResponsavelRequisicao", "ent.ent_endereco");
        camposUtilizados.put("numeroEnderecoResponsavelRequisicao", "ent.ent_numeroendereco");
        camposUtilizados.put("tipoLogradouroResponsavelRequisicao", "ent.ent_tipologradouroendereco");
        camposUtilizados.put("complementoResponsavelRequisicao", "ent.ent_complemento");
        camposUtilizados.put("cepResponsavelRequisicao", "ent.ent_cep");
        camposUtilizados.put("cpfCnpjResponsavelRequisicao", "ent.ent_cpfcnpj");
        camposUtilizados.put("descricaoCidadeResponsavelRequisicao", "cidentidade.cid_nome");
        camposUtilizados.put("estadoCidadeResponsavelRequisicao", "cidentidade.cid_uf");
        camposUtilizados.put("descricaoBairroResponsavelRequisicao", "baientidade.bai_descricao");
        camposUtilizados.put("cartaoSUSRequisicao", "a.req_cartaosus");
        camposUtilizados.put("cartaoSUSPaciente", "paciente.pac_cartaosus");
        camposUtilizados.put("codigoBairroCobrancaPaciente", "paciente.bai_codigocobranca");
        camposUtilizados.put("descricaoBairroCobrancaPaciente", "baicobranca.bai_descricao");
        camposUtilizados.put("codigoCidadeCobrancaPaciente", "paciente.cid_codigocobranca");
        camposUtilizados.put("descricaoCidadeCobrancaPaciente", "cidcobranca.cid_nome");
        camposUtilizados.put("estadoCidadeCobrancaPaciente", "cidcobranca.cid_uf");
        camposUtilizados.put("razaoSocialPaciente", "paciente.pac_razaosocial");
        camposUtilizados.put("cnpjPaciente", "paciente.pac_cnpj");
        camposUtilizados.put("inscricaoEstadualPaciente", "paciente.pac_ie");
        camposUtilizados.put("proprietarioPaciente", "paciente.pac_proprietario");
        camposUtilizados.put("sifPaciente", "paciente.pac_sif");
        camposUtilizados.put("enderecoCobrancaPaciente", "paciente.pac_enderecocobranca");
        camposUtilizados.put("numeroEnderecoCobrancaPaciente", "paciente.pac_numeroenderecocobranca");
        camposUtilizados.put("tipoLogradouroCobrancaPaciente", "paciente.pac_tipologradouroendcobranca");
        camposUtilizados.put("complementoCobrancaPaciente", "paciente.pac_complementocobranca");
        camposUtilizados.put("cepCobrancaPaciente", "paciente.pac_cepcobranca");
        camposUtilizados.put("foneCobrancaPaciente", "paciente.pac_fonecobranca");
        camposUtilizados.put("responsavelCobrancaPaciente", "paciente.pac_responsavelcobranca");
        camposUtilizados.put("codigoOrcamento", "orc.orc_codigo");
        camposUtilizados.put("dataHoraOrcamento", "orc.orc_datahora");
        camposUtilizados.put("observacaoOrcamento", "orc.orc_observacao");
        camposUtilizados.put("validadeOrcamento", "orc.orc_validade");
        camposUtilizados.put("solicitanteOrcamento", "orc.orc_solicitante");
        camposUtilizados.put("contatoOrcamento", "orc.orc_contato");
        camposUtilizados.put("foneOrcamento", "orc.orc_fone");
        camposUtilizados.put("emailOrcamento", "orc.orc_email");
        camposUtilizados.put("fonecontatoOrcamento", "orc.orc_fonecontato");
        camposUtilizados.put("proprietarioOrcamento", "orc.orc_proprietario");
        camposUtilizados.put("codigoUsuarioOrcamento", "usrorcamento.usr_codigo");
        camposUtilizados.put("nomeUsuarioOrcamento", "usrorcamento.usr_nome");
        camposUtilizados.put("codigoUnidadeSaude", "uns.uns_codigo");
        camposUtilizados.put("descricaoUnidadeSaude", "uns.uns_descricao");
        if (tipoDoRelatorio == 16) {
            camposUtilizados.put("dataChegadaPaciente", "a.req_dataretiradasenha");
            camposUtilizados.put("dataChamadaPaciente", "a.req_datachamadasenha");
            camposUtilizados.put("horaChegadaPaciente", "a.req_dataretiradasenha");
            camposUtilizados.put("horaChamadaPaciente", "a.req_datachamadasenha");
            camposUtilizados.put("tempoTotalAteChamadaGuiche", "age(a.req_datachamadasenha, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalAteChamadaGuicheMinutos", "age(a.req_datachamadasenha, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalAteGravacaoRequisicao", "age((cast(a.req_data as text) || ' ' || cast(a.req_hora as text))::timestamp,a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalAteGravacaoRequisicaoMinutos", "age((cast(a.req_data as text) || ' ' || cast(a.req_hora as text))::timestamp,a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteColetaExame", "age(b.exr_datamaterial, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteColetaExameMinutos", "age(b.exr_datamaterial, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteDigitacaoExame", "age(b.exr_datadigita, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteDigitacaoExameMinutos", "age(b.exr_datadigita, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteConferenciaExame", "age(b.exr_dataassina, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteConferenciaExameMinutos", "age(b.exr_dataassina, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteEntregaExame", "age(b.exr_dataentreguerst, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteEntregaExameMinutos", "age(b.exr_dataentreguerst, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteImpressaoExame", "age(b.exr_dataimpresso, a.req_dataretiradasenha)");
            camposUtilizados.put("tempoTotalChegadaAteImpressaoExameMinutos", "age(b.exr_dataimpresso, a.req_dataretiradasenha)");
            camposUtilizados.put("somaTempoTotalAteChamadaGuiche", "''");
            camposUtilizados.put("somaTempoTotalAteChamadaGuicheMinutos", "''");
            camposUtilizados.put("somaTempoTotalAteGravacaoRequisicao", "''");
            camposUtilizados.put("somaTempoTotalAteGravacaoRequisicaoMinutos", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteColetaExame", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteColetaExameMinutos", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteDigitacaoExame", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteDigitacaoExameMinutos", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteConferenciaExame", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteConferenciaExameMinutos", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteEntregaExame", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteEntregaExameMinutos", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteImpressaoExame", "''");
            camposUtilizados.put("somaTempoTotalChegadaAteImpressaoExameMinutos", "''");
            camposUtilizados.put("mediaTempoTotalAteChamadaGuiche", "''");
            camposUtilizados.put("mediaTempoTotalAteChamadaGuicheMinutos", "''");
            camposUtilizados.put("mediaTempoTotalAteGravacaoRequisicao", "''");
            camposUtilizados.put("mediaTempoTotalAteGravacaoRequisicaoMinutos", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteColetaExame", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteColetaExameMinutos", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteDigitacaoExame", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteDigitacaoExameMinutos", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteConferenciaExame", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteConferenciaExameMinutos", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteEntregaExame", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteEntregaExameMinutos", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteImpressaoExame", "''");
            camposUtilizados.put("mediaTempoTotalChegadaAteImpressaoExameMinutos", "''");
        }
        if (tipoDoRelatorio == 11) {
            camposAux.setLength(0);
            camposAux.append(" (select array_to_string(array_agg(distinct usr_codigo),',') ");
            camposAux.append(" from examerequisicaosituacoes ers ");
            camposAux.append(" where a.fil_codigo = ers.fil_codigo and a.req_codigo = ers.req_codigo and b.exa_codigo = ers.exa_codigo ");
            camposAux.append(" and (ers_situacao = ''  or ers_situacao = ' '))");
            camposUtilizados.put("usuariosColetasAnterioresExame", camposAux.toString());
        }
        camposAux.setLength(0);
        camposAux.append(" cast(COALESCE(NULLIF(b.exr_situacao, ''), '-') as TEXT) = (select array_to_string(array_agg(distinct cast(COALESCE(NULLIF(exr2.exr_situacao, ''), '-') as TEXT)), '') ");
        camposAux.append("                                   from examerequisicao exr2 ");
        camposAux.append("                                  where a.fil_codigo = exr2.fil_codigo ");
        camposAux.append("                                    and a.req_codigo = exr2.req_codigo) ");
        camposUtilizados.put("todosIguais", camposAux.toString());
        camposUtilizados.put("coalesce", "cast(COALESCE(NULLIF(b.exr_situacao, ''), '-') as TEXT)");
        camposAux.setLength(0);
        camposAux.append(" ,(select array_to_string(array_agg(distinct cast(COALESCE(NULLIF(exr2.exr_situacao, ''), '-') as TEXT)), '') ");
        camposAux.append("                                     from examerequisicao exr2 ");
        camposAux.append("                                    where a.fil_codigo = exr2.fil_codigo ");
        camposAux.append("                                      and a.req_codigo = exr2.req_codigo) ");
        camposUtilizados.put("array_to_string", camposAux.toString());
        camposAux.setLength(0);
        camposUtilizados.put("valorCustoSimplesExame", "b.exr_custosimples");
        camposUtilizados.put("valorCustoSimplesExameAtual", "d.emc_custosimples ");
        camposUtilizados.putAll(Constantes.MAPA_SELECT_FILIAL);
        camposUtilizados.put("periodoGestacionalRequisicao", "a.req_periodogestacional");
        camposUtilizados.put("motivoJustificativa", "rlo.rlo_descricaomotivo");
        camposUtilizados.put("motivoAlteracao", "mva.mva_descricao ");
        MAPA_TODOS_CAMPOS_DISPONIVEIS = camposUtilizados;
        sqlLigacao.append(" from requisicao a ");
        sqlLigacao.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sqlLigacao.append(" left join requisicaolog rlo ON a.fil_codigo = rlo.fil_codigo and a.req_codigo = rlo.req_codigo and rlo.rlo_codigo = (select max(rlo_codigo) from requisicaolog rlo where rlo.fil_codigo = a.fil_codigo and rlo.req_codigo = a.req_codigo)");
        sqlLigacao.append(" left join motivoalteracao mva ON rlo.fil_codigo = mva.fil_codigo and rlo.mva_codigo = mva.mva_codigo ");
        sqlLigacao.append(" left join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        sqlLigacao.append(" left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        sqlLigacao.append(" left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        sqlLigacao.append(" left join examerequisicaoresultado ert on b.fil_codigo = ert.fil_codigo\tand b.exa_codigo = ert.exa_codigo and b.mco_codigo = ert.mco_codigo\tand a.req_codigo = ert.req_codigo ");
        sqlLigacao.append(" left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true ");
        sqlLigacao.append(" left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
        sqlLigacao.append(" left join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        sqlLigacao.append(" left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        sqlLigacao.append(" join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        sqlLigacao.append(" left join usuario usrassina on b.usr_codassina = usrassina.usr_codigo ");
        sqlLigacao.append(" left join usuario usrdigitador on b.usr_coddigitador = usrdigitador.usr_codigo ");
        sqlLigacao.append(" left join usuario usrmaterial on b.usr_codmaterial = usrmaterial.usr_codigo ");
        sqlLigacao.append(" left join usuario usrrecoleta on b.usr_codrecoleta = usrrecoleta.usr_codigo ");
        sqlLigacao.append(" left join usuario usrrepeticao on b.usr_codrepeticao = usrrepeticao.usr_codigo ");
        sqlLigacao.append(" left join usuario usrfatura on b.usr_codfatura = usrfatura.usr_codigo ");
        sqlLigacao.append(" left join usuario usrentrega on b.usr_codentrega = usrentrega.usr_codigo ");
        sqlLigacao.append(" left join usuario usrimpressao on b.usr_codimpressao = usrimpressao.usr_codigo ");
        sqlLigacao.append(" left join usuario usrexame on b.usr_codigo = usrexame.usr_codigo ");
        sqlLigacao.append(" left join usuario usrmapa on b.usr_codigo = usrmapa.usr_codigo ");
        sqlLigacao.append(" left join usuario usrcortesia on b.usr_codcortesia = usrcortesia.usr_codigo ");
        sqlLigacao.append(" left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
        sqlLigacao.append(" left join usuario usrsetor on setor.usr_codigo = usrsetor.usr_codigo ");
        sqlLigacao.append(" left join usuario usracoletar on b.usr_codcoletar = usracoletar.usr_codigo ");
        sqlLigacao.append(" left join usuario usrexclusao on a.usr_codexcluida = usrexclusao.usr_codigo ");
        sqlLigacao.append(" left join usuario usrtransporte on b.usr_codtransportesaida = usrtransporte.usr_codigo ");
        sqlLigacao.append(" left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        sqlLigacao.append(" left join situacao sit on a.fil_codigo = sit.fil_codigo and a.sit_codigo = sit.sit_codigo ");
        sqlLigacao.append(" left join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        sqlLigacao.append(" left join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        sqlLigacao.append(" left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        sqlLigacao.append(" left join estacoes on a.est_codigo = estacoes.est_codigo ");
        sqlLigacao.append(" left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
        sqlLigacao.append(" left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
        sqlLigacao.append(" left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
        sqlLigacao.append(" left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
        sqlLigacao.append(" left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
        sqlLigacao.append(" left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
        sqlLigacao.append(" left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
        sqlLigacao.append(" left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
        sqlLigacao.append(" left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
        sqlLigacao.append(" left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
        sqlLigacao.append(" left join layout on convenio.fil_codigo = layout.fil_codigo and convenio.lay_codigo = layout.lay_codigo ");
        sqlLigacao.append(" left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
        sqlLigacao.append(" left join tabelaprecoexames tabela on convenio.fil_codigo = tabela.fil_codigo and convenio.tpe_codigo = tabela.tpe_codigo ");
        if (precoMetodologia) {
            sqlLigacao.append(" left join detalhetabelaprecometodologia dtm on a.fil_codigo = dtm.fil_codigo and b.exa_codigo = dtm.exa_codigo and b.mco_codigo = dtm.mco_codigo and tabela.tpe_codigo = dtm.tpe_codigo and b.met_codigo = dtm.met_codigo ");
        }
        sqlLigacao.append(" left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and b.exa_codigo = dtp.exa_codigo and b.mco_codigo = dtp.mco_codigo and tabela.tpe_codigo = dtp.tpe_codigo ");
        sqlLigacao.append(" left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        sqlLigacao.append(" left join prazoentrega prazo on d.fil_codigo = prazo.fil_codigo and d.prz_codigo = prazo.prz_codigo ");
        sqlLigacao.append(" left join metodologia on d.fil_codigo = metodologia.fil_codigo and d.met_codigo = metodologia.met_codigo ");
        sqlLigacao.append(" left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        sqlLigacao.append(" left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo  and a.pco_codigo = paccontatos.pco_codigo ");
        sqlLigacao.append(" left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        sqlLigacao.append(" left join cidades cidcobranca on paciente.fil_codigo = cidcobranca.fil_codigo and paciente.cid_codigocobranca = cidcobranca.cid_codigo ");
        sqlLigacao.append(" left join bairro baicobranca on paciente.fil_codigo = baicobranca.fil_codigo and paciente.bai_codigocobranca = baicobranca.bai_codigo ");
        sqlLigacao.append(" left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        sqlLigacao.append(" left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        sqlLigacao.append(" left join conveniospreco cpr on d.fil_codigo = cpr.fil_codigo and convenio.con_codigo = cpr.con_codigo and d.exa_codigo = cpr.exa_codigo and d.mco_codigo = cpr.mco_codigo ");
        sqlLigacao.append(" left join orcamento orc on a.fil_codigo = orc.fil_codigo and a.orc_codigo = orc.orc_codigo ");
        sqlLigacao.append(" left join usuario usrorcamento on usrorcamento.usr_codigo = orc.usr_codigo ");
        sqlLigacao.append(" left join unidadesaude uns on uns.fil_codigo = a.fil_codigo and uns.uns_codigo = a.uns_codigo ");
        sqlLigacao.append(" left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo ");
        sqlLigacao.append(" left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo ");
        sqlLigacao.append(" left join motivorecoleta mr on b.fil_codigo = mr.fil_codigo and b.mrc_codigo = mr.mrc_codigo ");
        sqlLigacao.append(" left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        if (tipoDoRelatorio == 14 && requisicaoInterfaceamento.booleanValue()) {
            sqlLigacao.append(" left join interfaceexamerequisicao  inreq on b.fil_codigo = inreq.fil_codigo and b.req_codigo = inreq.req_codigo and b.exa_codigo = inreq.exa_codigo and b.mco_codigo = inreq.mco_codigo ");
        }
        if (tipoDoRelatorio == 12 && apenasLoteExterno) {
            sqlLigacao.append(" join loteexternoexamerequisicao lexreq on b.fil_codigo = lexreq.fil_kodigo and b.req_codigo = lexreq.req_codigo and b.exa_codigo = lexreq.exa_codigo and b.mco_codigo = lexreq.mco_codigo and lexreq.ler_datahoraestorno is null ");
        }
        sqlLigacao.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        if (filiais == null) {
            filiais = new String[]{filialPadrao};
        }
        sqlLigacao.append(" where a.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            sqlLigacao.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            sqlLigacao.append(", ");
        }
        sqlLigacao.append(") ");
        if (!Funcoes.textoVazio(whereAdicional)) {
            sqlLigacao.append(" and ").append(whereAdicional);
        }
        if (apenasLoteExterno) {
            sqlLigacao.append(" and (b.exr_situacao is null or b.exr_situacao = '' or b.exr_situacao in (");
            sqlLigacao.append("'").append("T").append("'");
            sqlLigacao.append(",'").append("F").append("'");
            sqlLigacao.append(",'").append("N").append("'");
            sqlLigacao.append(",'").append("O").append("'");
            sqlLigacao.append(",'").append("R").append("'");
            sqlLigacao.append(")) ");
        } else if (tipoDoRelatorio != 1 && tipoDoRelatorio != 7 && tipoDoRelatorio != 6 && tipoDoRelatorio != 13 && tipoDoRelatorio != 10 && tipoDoRelatorio != 9 && tipoDoRelatorio != 15 && tipoDoRelatorio != 16) {
            if (campoDataImpresso == 0) {
                if (tipoDoRelatorio == 4) {
                    sqlLigacao.append(" and (b.exr_situacao NOT IN ('");
                } else {
                    sqlLigacao.append(" and (b.exr_situacao = '");
                }
            }
            if (tipoDoRelatorio == 2) {
                sqlLigacao.append("T").append("') ");
            } else if (tipoDoRelatorio == 4) {
                sqlLigacao.append("F").append("', '").append("T").append("')) ");
            } else if (tipoDoRelatorio == 3) {
                sqlLigacao.append("F").append("') ");
            } else if (tipoDoRelatorio == 5) {
                sqlLigacao.append("E").append("') ");
            } else if (tipoDoRelatorio == 8) {
                if (campoDataImpresso == 0) {
                    sqlLigacao.append("I").append("') ");
                }
            } else if (tipoDoRelatorio == 14 && !requisicaoInterfaceamento.booleanValue()) {
                sqlLigacao.append("O").append("') ");
            } else if (tipoDoRelatorio == 11) {
                sqlLigacao.append("R").append("') ");
            } else if (tipoDoRelatorio != 15) {
                if (tipoDoRelatorio == 17) {
                    sqlLigacao.append("L").append("')");
                } else if (tipoDoRelatorio == 18) {
                    sqlLigacao.append("C").append("')");
                } else if (tipoDoRelatorio == 19) {
                    sqlLigacao.append("N").append("')");
                } else if (tipoDoRelatorio != 4) {
                    sqlLigacao.append("' or b.exr_situacao is null) ");
                }
            }
        } else if (situacaoAtual == null || !situacaoAtual.equals(situacao[0]) && tipoDoRelatorio != 7 && tipoDoRelatorio != 6 && tipoDoRelatorio != 13 && tipoDoRelatorio != 10 && tipoDoRelatorio != 15) {
            String s;
            String string = s = situacaoAtual == null ? "" : situacaoAtual;
            if (s.equals(situacao[1])) {
                sqlLigacao.append(" and (b.exr_situacao = '' or b.exr_situacao is null or b.exr_situacao = ' ')");
            } else {
                sqlLigacao.append(" and b.exr_situacao = '");
                if (s.equals(situacao[2])) {
                    sqlLigacao.append("T");
                } else if (s.equals(situacao[3])) {
                    sqlLigacao.append("F");
                } else if (s.equals(situacao[4])) {
                    sqlLigacao.append("R");
                } else if (s.equals(situacao[5])) {
                    sqlLigacao.append("L");
                } else if (s.equals(situacao[6])) {
                    sqlLigacao.append("C");
                } else if (s.equals(situacao[7])) {
                    sqlLigacao.append("O");
                } else if (s.equals(situacao[8])) {
                    sqlLigacao.append("I");
                } else if (s.equals(situacao[9])) {
                    sqlLigacao.append("E");
                } else if (s.equals(situacao[10])) {
                    sqlLigacao.append("A");
                } else if (s.equals(situacao[11])) {
                    sqlLigacao.append("P");
                } else {
                    sqlLigacao.append("N");
                }
                sqlLigacao.append("'");
            }
        }
        if (situacaoAtual != null && situacaoAtual.equals(situacao[0]) && tipoDoRelatorio == 9) {
            sqlLigacao.append(" and b.exr_situacao <> '").append("E").append("' ");
        }
        if (situacaoPagamento != 0) {
            if (situacaoPagamento == 1) {
                sqlLigacao.append(" and a.req_totpago = 0 ");
            } else if (situacaoPagamento == 2) {
                sqlLigacao.append(" and (a.req_totpago > 0 and a.req_totpago < a.req_total) ");
            } else if (situacaoPagamento == 3) {
                sqlLigacao.append(" and a.req_totpago >= a.req_total ");
            }
        }
        if (estacoes != null) {
            sqlLigacao.append(" and a.est_codigo in (");
            for (int i = 0; i < estacoes.length; ++i) {
                sqlLigacao.append(estacoes[i]);
                if (i >= estacoes.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        } else if (!(acessoFiltrarEstacao || tipoDoRelatorio != 1 && tipoDoRelatorio != 16)) {
            sqlLigacao.append(" and a.est_codigo = ");
            sqlLigacao.append(codigoEstacao);
        }
        if (usuarios != null) {
            sqlLigacao.append(" and ").append(RelatorioRequisicoesService.getCampoUsuario(tipoDoRelatorio)).append(" in (");
            for (int i = 0; i < usuarios.length; ++i) {
                sqlLigacao.append("'");
                sqlLigacao.append(usuarios[i]);
                sqlLigacao.append("'");
                if (i >= usuarios.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        } else if (!(acessoFiltrarUsuario || tipoDoRelatorio != 1 && tipoDoRelatorio != 16)) {
            sqlLigacao.append(" and a.usr_codabertura = '");
            sqlLigacao.append(login);
            sqlLigacao.append("'");
        }
        if (destinos != null) {
            sqlLigacao.append(" and a.des_codigo in (");
            for (int i = 0; i < destinos.length; ++i) {
                sqlLigacao.append("'");
                sqlLigacao.append(destinos[i]);
                sqlLigacao.append("'");
                if (i >= destinos.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (coletas != null) {
            sqlLigacao.append(" and a.col_codigo in (");
            for (int i = 0; i < coletas.length; ++i) {
                sqlLigacao.append("'");
                sqlLigacao.append(coletas[i]);
                sqlLigacao.append("'");
                if (i >= coletas.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (convenios != null) {
            sqlLigacao.append(" and a.con_codigo in (");
            for (int i = 0; i < convenios.length; ++i) {
                sqlLigacao.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (situacoes != null && situacoes.length > 0) {
            sqlLigacao.append(" and a.sit_codigo in (");
            for (int i = 0; i < situacoes.length; ++i) {
                sqlLigacao.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (pacientes != null) {
            sqlLigacao.append(" and a.pac_codigo in (");
            for (int i = 0; i < pacientes.length; ++i) {
                sqlLigacao.append(pacientes[i]);
                if (i >= pacientes.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (medicosCrm != null && medicosUF != null && medicosCrm.length <= quantidadeMaximoFiltroAvancado) {
            sqlLigacao.append(" and (");
            for (int i = 0; i < medicosCrm.length; ++i) {
                sqlLigacao.append("(a.med_conselho = '");
                sqlLigacao.append(medicosConselho[i]);
                sqlLigacao.append("' and a.med_crm = '");
                sqlLigacao.append(medicosCrm[i]);
                sqlLigacao.append("' and a.med_uf = '");
                sqlLigacao.append(medicosUF[i]);
                sqlLigacao.append("')");
                if (i >= medicosCrm.length - 1) continue;
                sqlLigacao.append(" or ");
            }
            sqlLigacao.append(")");
        }
        if (exames != null) {
            sqlLigacao.append(" and b.exa_codigo in (");
            for (int i = 0; i < exames.length; ++i) {
                sqlLigacao.append("'");
                sqlLigacao.append(exames[i]);
                sqlLigacao.append("'");
                if (i >= exames.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (setores != null) {
            sqlLigacao.append(" and e.set_codigo in (");
            for (int i = 0; i < setores.length; ++i) {
                sqlLigacao.append("'");
                sqlLigacao.append(setores[i]);
                sqlLigacao.append("'");
                if (i >= setores.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (unidadeSaude != null) {
            sqlLigacao.append(" and a.uns_codigo in (");
            for (int i = 0; i < unidadeSaude.length; ++i) {
                sqlLigacao.append("'");
                sqlLigacao.append(unidadeSaude[i]);
                sqlLigacao.append("'");
                if (i >= unidadeSaude.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(")");
        }
        if (!intervaloHora.booleanValue()) {
            if (campoData.equals(PARAMETRO_DATA_COLETA) && tipoRelatorio == 12 || tipoRelatorio == 6 && campoData.equals(PARAMETRO_DATA_COLETA)) {
                if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                    sqlLigacao.append(" and ").append("cast(b.exr_datamaterial as date)").append(" >= '");
                    sqlLigacao.append(Funcoes.formataData("yyyy-MM-dd", dataInicial));
                    sqlLigacao.append("'");
                }
                if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                    sqlLigacao.append(" and ").append("cast(b.exr_datamaterial as date)").append(" <= '");
                    sqlLigacao.append(Funcoes.formataData("yyyy-MM-dd", dataFinal));
                    sqlLigacao.append("'");
                }
                if (horaInicial != null && Funcoes.verificaHora(horaInicial)) {
                    sqlLigacao.append(" and ").append("cast(b.exr_datamaterial as time)").append(" >= '");
                    sqlLigacao.append(horaInicial);
                    sqlLigacao.append("'");
                }
                if (horaFinal != null && Funcoes.verificaHora(horaFinal)) {
                    sqlLigacao.append(" and ").append("cast(b.exr_datamaterial as time)").append(" <= '");
                    sqlLigacao.append(horaFinal);
                    sqlLigacao.append("'");
                }
            } else {
                if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                    sqlLigacao.append(" and ").append(RelatorioRequisicoesService.getCampoFiltroData(tipoDoRelatorio, campoDataImpresso)).append(" >= '");
                    sqlLigacao.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                    sqlLigacao.append("'");
                }
                if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                    sqlLigacao.append(" and ").append(RelatorioRequisicoesService.getCampoFiltroData(tipoDoRelatorio, campoDataImpresso)).append(" <= '");
                    sqlLigacao.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                    sqlLigacao.append("'");
                }
                if (horaInicial != null && Funcoes.verificaHora(horaInicial)) {
                    sqlLigacao.append(" and ").append(RelatorioRequisicoesService.getCampoFiltroHora(tipoDoRelatorio, campoDataImpresso)).append(" >= '");
                    sqlLigacao.append(horaInicial);
                    sqlLigacao.append("'");
                }
                if (horaFinal != null && Funcoes.verificaHora(horaFinal)) {
                    sqlLigacao.append(" and ").append(RelatorioRequisicoesService.getCampoFiltroHora(tipoDoRelatorio, campoDataImpresso)).append(" <= '");
                    sqlLigacao.append(horaFinal);
                    sqlLigacao.append("'");
                }
            }
        } else if (campoData.equals(PARAMETRO_DATA_COLETA) && tipoRelatorio == 12 || tipoRelatorio == 6) {
            sqlLigacao.append(" and (").append("b.exr_datamaterial").append(" >= '");
            sqlLigacao.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ");
            sqlLigacao.append(horaInicial);
            sqlLigacao.append("') and (");
            sqlLigacao.append("b.exr_datamaterial").append(" <= '");
            sqlLigacao.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ");
            sqlLigacao.append(horaFinal);
            sqlLigacao.append("')");
        } else {
            sqlLigacao.append(" and ((").append(RelatorioRequisicoesService.getCampoFiltroData(tipoDoRelatorio, campoDataImpresso)).append(" + ");
            sqlLigacao.append(RelatorioRequisicoesService.getCampoFiltroHora(tipoDoRelatorio, campoDataImpresso)).append(") >= '");
            sqlLigacao.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ");
            sqlLigacao.append(horaInicial);
            sqlLigacao.append("') and ((");
            sqlLigacao.append(RelatorioRequisicoesService.getCampoFiltroData(tipoDoRelatorio, campoDataImpresso)).append(" + ");
            sqlLigacao.append(RelatorioRequisicoesService.getCampoFiltroHora(tipoDoRelatorio, campoDataImpresso)).append(") <= '");
            sqlLigacao.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ");
            sqlLigacao.append(horaFinal);
            sqlLigacao.append("')");
        }
        if (tipoRelatorio == 16) {
            if (alas != null) {
                sqlLigacao.append(" and ala.ala_codigo in (");
                for (int i = 0; i < alas.length; ++i) {
                    sqlLigacao.append("'");
                    sqlLigacao.append(alas[i]);
                    sqlLigacao.append("'");
                    if (i >= alas.length - 1) continue;
                    sqlLigacao.append(", ");
                }
                sqlLigacao.append(")");
            }
            if (!Funcoes.textoVazio(quarto)) {
                sqlLigacao.append(" and a.req_quarto ilike '");
                sqlLigacao.append(quarto);
                sqlLigacao.append("'");
            }
            if (!Funcoes.textoVazio(leito)) {
                sqlLigacao.append(" and a.req_leito ilike '");
                sqlLigacao.append(leito);
                sqlLigacao.append("'");
            }
            if (!Funcoes.textoVazio(prontuario)) {
                sqlLigacao.append(" and a.req_prontuario ilike '");
                sqlLigacao.append(prontuario);
                sqlLigacao.append("'");
            }
        }
        if (deveGuia.booleanValue()) {
            sqlLigacao.append(" and a.req_deveguia = true ");
        }
        if (pacienteVIP.booleanValue()) {
            sqlLigacao.append(" and paciente.pac_vip = true ");
        }
        if (urgente.booleanValue()) {
            sqlLigacao.append(" and (a.req_urgente = true or b.exr_urgente = true) ");
        }
        if (reqComTaxas) {
            sqlLigacao.append(" AND (select count(taxa.rtx_valor) from requisicaotaxa taxa where taxa.fil_codigo = a.fil_codigo and taxa.req_codigo = a.req_codigo) > 0 ");
        }
        if (resultadoCritico) {
            sqlLigacao.append(" AND b.exr_dataresultadocritico IS NOT NULL ");
        }
        if (requisicaoInterfaceamento.booleanValue()) {
            sqlLigacao.append(" and (inreq.ier_situacao in (");
            sqlLigacao.append(3).append(",");
            sqlLigacao.append(4).append(",").append(5);
            sqlLigacao.append("))");
        }
        if (tipoDoRelatorio == 9) {
            sqlLigacao.append(" and (a.req_avisarpaciente = true ");
            if (mostrarExamesAvisarPaciente.booleanValue()) {
                sqlLigacao.append(" or b.exr_avisarentrega ");
            }
            sqlLigacao.append(") ");
        }
        if (tipoDoRelatorio == 12 || somenteNaoTriadas.booleanValue()) {
            sqlLigacao.append(" and b.exr_datatriagem is null ");
        }
        if (tipoDoRelatorio == 15) {
            sqlLigacao.append(" and a.req_excluida ");
        } else {
            sqlLigacao.append(" and a.req_excluida = false and b.exr_excluido = false ");
        }
        if (!selecaoSexo.isEmpty() && !selecaoSexo.equals("Ambos")) {
            sqlLigacao.append(" and paciente.pac_sexo = '").append(Tipos.tipoSexoPorDescricao(selecaoSexo)).append("' ");
        }
        sqlLigacao.append("order by (");
        if (tipoDoRelatorio == 16) {
            sqlLigacao.append(" a.fil_codigo, a.est_codigo, ");
        } else if (RelatorioRequisicoesService.isTipoMaterialOrdemUsuario(tipoDoRelatorio, ordemSelecionada)) {
            sqlLigacao.append("  upper(a.usr_codabertura), a.fil_codigo ");
        }
        if (tipoDoRelatorio == 13) {
            if (ordemSelecionada.equals(ordem[2])) {
                sqlLigacao.append("upper(paciente.pac_nome), ");
            } else {
                sqlLigacao.append("a.pac_codigo, ");
            }
        } else if (tipoDoRelatorio == 7) {
            sqlLigacao.append("a.con_codigo, ");
        } else if (tipoDoRelatorio == 6) {
            if (ordemSelecionada.equals(ordem[4])) {
                sqlLigacao.append("upper(medico.med_nome)");
                sqlLigacao.append(", a.req_codigo, ");
            }
            sqlLigacao.append("a.med_conselho, a.med_crm, a.med_uf, ");
        } else if (tipoDoRelatorio == 10) {
            sqlLigacao.append("a.usr_codabertura, a.con_codigo, ");
        }
        if (ordemSelecionada == null || ordemSelecionada.equals(ordem[0])) {
            sqlLigacao.append("a.fil_codigo, a.req_codigo ");
        } else if (ordemSelecionada.equals(ordem[1])) {
            sqlLigacao.append(RelatorioRequisicoesService.getCampoOrdemData(tipoRelatorio, campoDataImpresso)).append(", a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[2])) {
            sqlLigacao.append("upper(paciente.pac_nome)");
            sqlLigacao.append(", a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[3])) {
            sqlLigacao.append("upper(convenio.con_fantasia), a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[4])) {
            sqlLigacao.append("upper(medico.med_nome)");
            sqlLigacao.append(", a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[5])) {
            if (tipoDoRelatorio == 16) {
                sqlLigacao.append("a.req_codigo");
            } else {
                sqlLigacao.append("a.est_codigo, a.req_codigo");
            }
        } else if (ordemSelecionada.equals(ordem[6])) {
            sqlLigacao.append("a.usr_codigo, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[7])) {
            sqlLigacao.append("e.set_codigo, a.req_codigo");
        } else if (ordemSelecionada.equals(ordem[8])) {
            if (tipoDoRelatorio == 16) {
                sqlLigacao.append("a.req_codigo");
            } else {
                sqlLigacao.append("a.fil_codigo, a.req_codigo");
            }
        } else if (ordemSelecionada.equals(ordem[9])) {
            if (tipoDoRelatorio == 16) {
                sqlLigacao.append("a.usr_codigo, a.req_codigo");
            } else {
                sqlLigacao.append("a.est_codigo, a.usr_codigo, a.req_codigo");
            }
        } else if (ordemSelecionada.equals(ordem[10])) {
            sqlLigacao.append("a.pac_codigo");
            if (tipoDoRelatorio == 1 || tipoDoRelatorio == 16) {
                sqlLigacao.append(", a.req_codigo");
            }
        } else if (ordemSelecionada.equals(ordem[11])) {
            sqlLigacao.append("a.req_codigo, b.exr_ordem");
        }
        if (ordemComprovante.equals("A")) {
            sqlLigacao.append(" ,b.exr_ordem, b.exa_codigo, b.mco_codigo ");
        } else {
            if (ordenarSetor) {
                sqlLigacao.append(" ,setor.set_codigo ");
            }
            if (ordemComprovante.equals("C")) {
                sqlLigacao.append(" ,b.exa_codigo, b.mco_codigo ");
            } else if (ordemComprovante.equals("P")) {
                sqlLigacao.append(" ,d.emc_pagina, d.emc_ordem, b.exa_codigo, b.mco_codigo ");
            }
        }
        sqlLigacao.append(")");
        return sqlLigacao.toString();
    }

    public static String[] getPerguntasFilial(String filial, Statement st) {
        String[] camposPergunta = new String[]{};
        try {
            String xmlPerguntas;
            StringBuilder buf = new StringBuilder("select fil_perguntas from filiais_postocoleta ");
            buf.append(" where fil_codigo = ").append(filial);
            ResultSet rs = st.executeQuery(buf.toString());
            String string = xmlPerguntas = rs.next() ? rs.getString("fil_perguntas") : "";
            if (!Funcoes.textoVazio(xmlPerguntas)) {
                camposPergunta = RelatorioRequisicoes.getCamposResultado(xmlPerguntas);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi possivel interpretar as perguntas da filial", ex.getStackTrace());
        }
        return camposPergunta;
    }

    private static String[] getCamposResultado(String xmlPerguntas) {
        if (xmlPerguntas == null) {
            return new String[0];
        }
        ArrayList<String> tmp = new ArrayList<String>();
        Pagina p = new Pagina();
        String exame = StringUtil.getValor(xmlPerguntas, PARAMETRO_EXAME);
        p.setMargensFromXML(exame);
        p.setTipoConfiguracao(0);
        p.setAtributos(StringUtil.getValor(exame, "pagina"), StringUtil.getValor(exame, "versao"));
        List<Componente> comps = p.getComponentes();
        for (Componente c : comps) {
            if (!(c instanceof Componente)) continue;
            tmp.add(c.getNome());
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    private static String[] getListaCamposUtilizados() {
        ArrayList<String> listaCamposUtilizados = new ArrayList<String>();
        for (String it : camposUtilizados.keySet()) {
            listaCamposUtilizados.add(it);
        }
        listaCamposUtilizados.removeIf(l -> l.equalsIgnoreCase("mediatempototalcoletaateimpressaoexamerequisicao"));
        listaCamposUtilizados.removeIf(l -> l.equalsIgnoreCase("mediatempototalcoletaateconferenciaexamerequisicao"));
        listaCamposUtilizados.add("mediatempototalcoletaateimpressaoexamerequisicao");
        listaCamposUtilizados.add("mediatempototalcoletaateconferenciaexamerequisicao");
        return (String[])listaCamposUtilizados.stream().toArray(String[]::new);
    }

    public static String getCampoImpressoPor(int campoDataImpresso) {
        if (campoDataImpresso >= 0) {
            return dataImpresso[campoDataImpresso];
        }
        return dataImpresso[0];
    }

    static {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"guiaExameRequisicao", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "dataRecebeuGuiaRequisicao", "dataGuiaConferidaRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "validadeCarteiraRequisicao", "validadeGuiaRepasseRequisicao", "validadeCarteiraRepasseRequisicao", "dataRecebeuGuiaRepasseRequisicao", "situacaoExameRequisicao", "entregueParaExameRequisicao", "dataAssinaturaExameRequisicao", "dataDigitacaoExameRequisicao", "dataColetaExameRequisicao", "dataEntregueExameRequisicao", "dataImpressaoExameRequisicao", "dataFaturaExameRequisicao", "valorTotalExameRequisicao", "prontuarioRequisicao", "valorFaturarExameRequisicao", "complementoDestinoRequisicao", "descricaoMotivoRecoleta", "motivoRecoletaExameRequisicao", "justificativaMotivoRecoleta", "codigoMotivoRecoleta", "dataRecoletaExameRequisicao", "codigoUsuarioRecoleta", "nomeUsuarioRecoleta", "dataRepeticaoExameRequisicao", "codigoUsuarioRepeticao", "nomeUsuarioRepeticao", "valorExameExameRequisicao", "valorCHExameExameRequisicao", "materialExternoExameRequisicao", "valorCHExameTabelaPreco", "percentualCBHPMExameTabelaPreco", "porteCBHPMExameTabelaPreco", "codigoAMBExameTabelaPreco", "dataEntregaExameRequisicao", "interfaceadoExameRequisicao", "loteReagenteExameRequisicao", "tipoUltimoPagamentoRequisicao", "observacaoPrazoCarenciaExameRequisicao", "quantidadeReagenteExameRequisicao", "valorCHExameRequisicao", "valorMaterialExameRequisicao", "valorPagoBalcaoExameRequisicao", "dataImpressaoMapaExameRequisicao", "codigoAutorizacaoExameRequisicao", "dataInsercaoExameRequisicao", "observacaoExameRequisicao", "dataCortesiaExameRequisicao", "serialReagenteExameRequisicao", "autorizarExameRequisicao", "tempoJejumExameRequisicao", "descricaoMaterialInformadoExameRequisicao", "urgenteExameRequisicao", "dataEtiquetaTriagemExameRequisicao", "naoFaturarExameRequisicao", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigosMultiGuias", "codigoPaciente", "dataTriagemExameRequisicao", "dataEtqColetaExameRequisicao", "tempoDiureseExameRequisicao", "dataLoteExternoExameRequisicao", "dataMaterialSetorExameRequisicao", "dataExcluidoExameRequisicao", "dataGuiaExameRequisicao", "validadeGuiaExameRequisicao", "dataFaturaRepasseExameRequisicao", "nomePaciente", "nomeSocialPaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairrodestino", "descricaoBairrodestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoSetor", "descricaoSetor", "responsavelSetor", "siglaSetor", "corSetor", "codigoUsuarioSetor", "nomeUsuarioSetor", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "percentualAcrescimoConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoPrioridade", "descricaoPrioridade", "codigoTabela", "descricaoTabela", "valorCHTabela", "moedaTabela", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoUsuarioAssina", "nomeUsuarioAssina", "codigoUsuarioDigitador", "nomeUsuarioDigitador", "codigoUsuarioMaterial", "nomeUsuarioMaterial", "codigoUsuarioFatura", "nomeUsuarioFatura", "codigoUsuarioEntrega", "nomeUsuarioEntrega", "codigoUsuarioImpressao", "nomeUsuarioImpressao", "codigoUsuarioExame", "nomeUsuarioExame", "codigoUsuarioMapa", "nomeUsuarioMapa", "codigoUsuarioCortesia", "nomeUsuarioCortesia", "codigoExame", "descricaoExame", "sexoExame", "horaEntradaExame", "horaSaidaExame", "textoFiltroExame", "proibidoExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "padraoExame", "ordemExame", "paginaExame", "codigoCBHPMExame", "codigoAMBExame", "solicitarJejumExame", "solicitarTempoDiureseExame", "solicitarMedicamentoExame", "marcarExternoExame", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "codigoPrazoEntrega", "descricaoPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "rotinaPrazoEntrega", "codigoMetodologia", "descricaoMetodologia", "solicitarDUMExame", "codigoEstacao", "descricaoEstacao", "medicamentosRequisicao", "avisarPacienteExameRequisicao", "valorCHExameExameRequisicaoOriginal", "valorCHExameRequisicaoOriginal", "codigoFilialCodigoRequisicao", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoMedico", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroMedico", "tipoLogradouroCobrancaConvenio", "cartaoSUSRequisicao", "cartaoSUSPaciente", "usuariosColetasAnterioresExame", "periodoGestacionalRequisicao", "requisicaoInterfaceamento", "mediaTempoTotalColetaAteImpressaoExameRequisicao", "detalhamentoTaxasRequisicao", "codigoSituacao", "descricaoSituacao", "comissaoMedicoConvenio", "perguntasRequisicao", "passaportePaciente", PARAMETRO_RESULTADO_CRITICO, "generoPaciente", "procedenciaRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "localColetaProdutoRequisicao", "nomeResponsavelRequisicao_", "cargoResponsavelRequisicao_", "foneResponsavelRequisicao_", "emailResponsavelRequisicao_", "nomeResponsavelRequisicao", "cargoResponsavelRequisicao", "foneResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "fornecedorProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "motivoExclusao", "codigoOrcamento", "dataHoraOrcamento", "observacaoOrcamento", "validadeOrcamento", "solicitanteOrcamento", "contatoOrcamento", "foneOrcamento", "emailOrcamento", "fonecontatoOrcamento", "proprietarioOrcamento", "codigoUsuarioOrcamento", "nomeUsuarioOrcamento", "tempoTotalAteColetaExame", "tempoTotalAteDigitacaoExame", "tempoTotalAteConferenciaExame", "tempoTotalAteImpressaoExame", "tempoTotalAteEntregaExame", "tempoTotalColetaAteDigitacaoExame", "tempoTotalColetaAteConferenciaExame", "tempoTotalColetaAteImpressaoExame", "tempoTotalColetaAteEntregaExame", "tempoTotalColetaAteDigitacaoExameMinutos", "tempoTotalColetaAteConferenciaExameMinutos", "somaTempoTotalAteColetaExame", "somaTempoTotalAteDigitacaoExame", "somaTempoTotalAteConferenciaExame", "somaTempoTotalAteImpressaoExame", "somaTempoTotalAteEntregaExame", "somaTempoTotalColetaAteDigitacaoExame", "somaTempoTotalColetaAteConferenciaExame", "somaTempoTotalColetaAteImpressaoExame", "somaTempoTotalColetaAteEntregaExame", "mediaTempoTotalAteColetaExame", "mediaTempoTotalAteDigitacaoExame", "mediaTempoTotalAteConferenciaExame", "mediaTempoTotalAteImpressaoExame", "mediaTempoTotalAteEntregaExame", "mediaTempoTotalColetaAteDigitacaoExame", "mediaTempoTotalColetaAteConferenciaExame", "mediaTempoTotalColetaAteImpressaoExame", "mediaTempoTotalColetaAteEntregaExame", "totalTaxaRequisicao", "codigoUnidadeSaude", "descricaoUnidadeSaude", "quantidadeTotalRequisicao", "quantidadeTotalExame", "valorCustoSimplesExame", "codigoUsuarioAColetar", "nomeUsuarioAColetar", "codigoUsuarioExclusao", "nomeUsuarioExclusao", "codigoUsuarioTransporte", "nomeUsuarioTransporte", "valorCustoSimplesExameAtual"});
        camposAuditoriaProducao = new String[]{"tempoTotalAteDigitacaoExameMinutos", "tempoTotalAteColetaExameMinutos", "tempoTotalAteConferenciaExameMinutos", "tempoTotalAteImpressaoExameMinutos", "tempoTotalAteEntregaExameMinutos", "tempoTotalColetaAteImpressaoExameMinutos", "tempoTotalColetaAteEntregaExameMinutos", "somaTempoTotalAteColetaExameMinutos", "somaTempoTotalAteDigitacaoExameMinutos", "somaTempoTotalAteConferenciaExameMinutos", "somaTempoTotalAteImpressaoExameMinutos", "somaTempoTotalAteEntregaExameMinutos", "somaTempoTotalColetaAteDigitacaoExameMinutos", "somaTempoTotalColetaAteConferenciaExameMinutos", "somaTempoTotalColetaAteImpressaoExameMinutos", "somaTempoTotalColetaAteEntregaExameMinutos", "mediaTempoTotalAteColetaExameMinutos", "mediaTempoTotalAteDigitacaoExameMinutos", "mediaTempoTotalAteConferenciaExameMinutos", "mediaTempoTotalAteImpressaoExameMinutos", "mediaTempoTotalAteEntregaExameMinutos", "mediaTempoTotalColetaAteDigitacaoExameMinutos", "mediaTempoTotalColetaAteConferenciaExameMinutos", "mediaTempoTotalColetaAteImpressaoExameMinutos", "mediaTempoTotalColetaAteEntregaExameMinutos", "dataChegadaPaciente", "dataChamadaPaciente", "horaChegadaPaciente", "horaChamadaPaciente", "tempoTotalAteChamadaGuiche", "tempoTotalAteChamadaGuicheMinutos", "tempoTotalAteGravacaoRequisicao", "tempoTotalAteGravacaoRequisicaoMinutos", "tempoTotalChegadaAteColetaExame", "tempoTotalChegadaAteColetaExameMinutos", "tempoTotalChegadaAteDigitacaoExame", "tempoTotalChegadaAteDigitacaoExameMinutos", "tempoTotalChegadaAteConferenciaExame", "tempoTotalChegadaAteConferenciaExameMinutos", "tempoTotalChegadaAteEntregaExame", "tempoTotalChegadaAteEntregaExameMinutos", "tempoTotalChegadaAteImpressaoExame", "tempoTotalChegadaAteImpressaoExameMinutos", "somaTempoTotalAteChamadaGuiche", "somaTempoTotalAteChamadaGuicheMinutos", "somaTempoTotalAteGravacaoRequisicao", "somaTempoTotalAteGravacaoRequisicaoMinutos", "somaTempoTotalChegadaAteColetaExame", "somaTempoTotalChegadaAteColetaExameMinutos", "somaTempoTotalChegadaAteDigitacaoExame", "somaTempoTotalChegadaAteDigitacaoExameMinutos", "somaTempoTotalChegadaAteConferenciaExame", "somaTempoTotalChegadaAteConferenciaExameMinutos", "somaTempoTotalChegadaAteEntregaExame", "somaTempoTotalChegadaAteEntregaExameMinutos", "somaTempoTotalChegadaAteImpressaoExame", "somaTempoTotalChegadaAteImpressaoExameMinutos", "mediaTempoTotalAteChamadaGuiche", "mediaTempoTotalAteChamadaGuicheMinutos", "mediaTempoTotalAteGravacaoRequisicao", "mediaTempoTotalAteGravacaoRequisicaoMinutos", "mediaTempoTotalChegadaAteColetaExame", "mediaTempoTotalChegadaAteColetaExameMinutos", "mediaTempoTotalChegadaAteDigitacaoExame", "mediaTempoTotalChegadaAteDigitacaoExameMinutos", "mediaTempoTotalChegadaAteConferenciaExame", "mediaTempoTotalChegadaAteConferenciaExameMinutos", "mediaTempoTotalChegadaAteEntregaExame", "mediaTempoTotalChegadaAteEntregaExameMinutos", "mediaTempoTotalChegadaAteImpressaoExame", "mediaTempoTotalChegadaAteImpressaoExameMinutos", "mediaTempoTotalColetaAteConferenciaExameRequisicao"};
        camposImpressao = new String[]{"qtdePaginasImpressasRequisicao"};
    }
}

