/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRequisicaoMultiguia
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "codigoColeta", "codigoDestino", "codigoConvenio", "codigoPaciente", "dataRequisicao", "crmMedico", "dataFatura", "totalPago", "valorDesconto", "valorTotalTaxa", "nomePaciente", "nomeSocialPaciente", "razaoConvenio", "descricaoDestino", "descricaoColeta", "examesRequisicaoPrincipal", "codigoMultiguia", "quantidadeMultiguia", "nomeSocialPaciente", "generoPaciente"});

    public RelatorioRequisicaoMultiguia() {
        this.setName("RelatorioRequisicaoMultiguia");
        this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es multiguias", "Relat\u00f3rio de quantidade de multiguias por requisi\u00e7\u00e3o", "relatorios/rel_requisicao_multiguia.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.setModuloConfigurar(RelatorioRequisicaoMultiguia.getModuloConfigurar());
        this.setModuloAcesso(RelatorioRequisicaoMultiguia.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement statement;
        block13: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            statement = Conexao.getStatement();
            ModeloGridTable modeloImpressao = new ModeloGridTable(this.campos);
            if (Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                Funcoes.mensagem(this, "Informe a data inicial.", 2);
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
                this.requisitaFocoComponente(FILTRO_DATA_INICIAL);
                return;
            }
            if (Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
                Funcoes.mensagem(this, "Informe a data final.", 2);
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
                this.requisitaFocoComponente(FILTRO_DATA_FINAL);
                return;
            }
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" select a.req_codigo as codigoRequisicao \t\t\t ");
                sql.append(" \t\t\t, col.col_codigo as codigoColeta           ");
                sql.append(" \t\t\t, des.des_codigo as codigoDestino          ");
                sql.append(" \t\t\t, con.con_codigo as codigoConvenio         ");
                sql.append(" \t\t\t, pac.pac_codigo as codigoPaciente         ");
                sql.append(" \t\t\t, pac.pac_nomesocial as nomeSocialPaciente ");
                sql.append(" \t\t\t, a.req_data as dataRequisicao           ");
                sql.append(" \t\t\t, a.med_crm as crmMedico                 ");
                sql.append(" \t\t\t, a.req_dtfatura as dataFatura           ");
                sql.append(" \t\t\t, a.req_totpago as totalPago             ");
                sql.append(" \t\t\t, a.req_desconto as valorDesconto        ");
                sql.append(" \t\t\t, a.req_totaltaxa as valorTotalTaxa      ");
                sql.append(" \t\t\t, pac.pac_nome as nomePaciente             ");
                sql.append(" \t\t\t, pac.pac_nomesocial as nomeSocialPaciente ");
                sql.append(" \t\t\t, con.con_razao as razaoConvenio           ");
                sql.append(" \t\t\t, des.des_descricao as descricaoDestino    ");
                sql.append(" \t\t\t, col.col_descricao descricaoColeta        ");
                sql.append(" \t\t\t, array_to_string(array_agg(distinct(exr.exa_codigo)), ',') as examesRequisicaoPrincipal            ");
                sql.append(" \t\t\t, array_to_string(array_agg(distinct(reqreq.req_kodigo)), ', ') as codigoMultiguia                  ");
                sql.append("\t\t  , count(distinct(reqreq.req_kodigo)) as quantidadeMultiguia ");
                sql.append("      , idg.ige_descricao as generoPaciente ");
                sql.append(", ").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                sql.append(" from requisicao a                                                                                           ");
                sql.append("      inner join requisicaorequisicao reqreq  on reqreq.fil_codigo = a.fil_codigo and a.req_codigo = reqreq.req_codigo ");
                sql.append("      inner join requisicao req2 on req2.fil_codigo = reqreq.fil_codigo and req2.req_codigo = reqreq.req_kodigo ");
                sql.append("      inner join examerequisicao exr on a.fil_codigo = exr.fil_codigo and exr.req_codigo = a.req_codigo    ");
                sql.append(" \t\t\tinner join paciente pac on exr.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo           ");
                sql.append(" \t\t\tinner join convenios con on pac.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo          ");
                sql.append(" \t\t\tinner join destino des on con.fil_codigo = des.fil_codigo and a.des_codigo = des.des_codigo            ");
                sql.append(" \t\t\tinner join coletas col on des.fil_codigo = col.fil_codigo and a.col_codigo = col.col_codigo            ");
                sql.append("\t\t\tinner join identidadegenero idg on coalesce(pac.pac_genero, 0) = idg.ige_codigo ");
                sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                String filiais = this.getSelecionadosFiltroValores(FILTRO_FILIAL, 0, false, false);
                if (filiais == null) {
                    filiais = Variaveis.filialPadrao;
                }
                sql.append(" where a.fil_codigo in ( ").append(filiais).append(" ) ");
                sql.append(" \t and a.req_data between '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                sql.append("'  and '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' ");
                sql.append("   and (a.req_excluida is false or (a.req_excluida and a.req_origemagendamento))  ");
                sql.append("   and req2.req_excluida is false ");
                this.getSelecionadosFiltroValoresConcat(FILTRO_COLETA, 0, sql, "and col.col_codigo in", false, true);
                this.getSelecionadosFiltroValoresConcat(FILTRO_DESTINO, 0, sql, "and des.des_codigo in", false, true);
                this.getSelecionadosFiltroValoresConcat(FILTRO_CONVENIO, 0, sql, "and con.con_codigo in", false, false);
                sql.append(" group by a.req_codigo   ");
                sql.append(" \t, col.col_codigo       ");
                sql.append(" \t, des.des_codigo       ");
                sql.append(" \t, con.con_codigo       ");
                sql.append(" \t, pac.pac_codigo       ");
                sql.append(" \t, a.req_data           ");
                sql.append(" \t, a.med_crm            ");
                sql.append(" \t, a.req_dtfatura       ");
                sql.append(" \t, a.req_totpago        ");
                sql.append(" \t, a.req_desconto       ");
                sql.append(" \t, a.req_totaltaxa      ");
                sql.append(" \t, a.fil_codigo         ");
                sql.append(" \t, pac.pac_nome         ");
                sql.append(" \t, pac.pac_nomesocial   ");
                sql.append(" \t, con.con_razao        ");
                sql.append(" \t, des.des_descricao    ");
                sql.append(" \t, col.col_descricao    ");
                sql.append("  , pac.pac_nomesocial    ");
                sql.append("  , idg.ige_descricao    ");
                sql.append(", ").append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
                sql.append(" order by a.fil_codigo, a.req_codigo  ");
                ResultSet rsDados = Conexao.executeQuery(statement, sql.toString());
                if (rsDados.next()) {
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[i] = rsDados.getObject(this.campos[i]);
                        }
                        modeloImpressao.addLine(o);
                    } while (rsDados.next());
                }
                if (modeloImpressao.getRowCount() > 0) {
                    StringBuilder sqlRel = new StringBuilder();
                    sqlRel.append("select rel_xml from relatoriosistema where rel_codigo = ").append(this.getModuloAcesso());
                    ResultSet rsLayout = Conexao.executeQuery(statement, sqlRel.toString());
                    if (rsLayout.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_COLETA, this.getSelecionadosFiltroValores(FILTRO_COLETA, 0, false, false));
                        var.put(FILTRO_CONVENIO, this.getSelecionadosFiltroValores(FILTRO_CONVENIO, 0, false, false));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DESTINO, this.getSelecionadosFiltroValores(FILTRO_DESTINO, 0, false, false));
                        var.put(FILTRO_FILIAL, filiais);
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioRequisicaoMultiguia.this.panelCentro.removeAll();
                                RelatorioRequisicaoMultiguia.this.panelCentro.repaint();
                                RelatorioRequisicaoMultiguia.this.habilitaBotaoImprimir(true);
                            }
                        });
                        gerador.executar(rsLayout.getString("rel_xml"), (TableModel)modeloImpressao, var);
                        this.panelCentro.revalidate();
                    } else {
                        Funcoes.mensagem(this.getTopLevelAncestor(), "Relat\u00f3rio n\u00e3o possui layout.", 2);
                        this.setCursor(Cursor.getDefaultCursor());
                        this.habilitaBotaoImprimir(true);
                    }
                    break block13;
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio", e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(statement);
                    this.setCursor(Cursor.getDefaultCursor());
                    this.habilitaBotaoImprimir(true);
                    throw throwable;
                }
                Conexao.fecharStatement(statement);
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
            }
        }
        Conexao.fecharStatement(statement);
        this.setCursor(Cursor.getDefaultCursor());
        this.habilitaBotaoImprimir(true);
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0823700100");
    }

    public static long getModuloConfigurar() {
        return Long.valueOf("0823700101");
    }
}

