/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioRealizados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String codigoAMB = "C\u00f3digo AMB";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_DESMEMBRAR_MATERIAL = "filtroDesmembrarMaterial";
    private final String FILTRO_TIPO_DATA = "filtroTipoData";
    private final String FILTRO_MOSTRAR_AMB = "filtroCodigoAMB";
    private final String FILTRO_INTERFACE = "filtroInterface";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_LAB_APOIO = "filtroLabApoio";
    public static final int TIPO_REALIZADOS_GERAL = 1;
    public static final int TIPO_REALIZADOS_COM_SETOR = 2;
    public static final int TIPO_REALIZADOS_COM_CONVENIO = 3;
    public static final int TIPO_REALIZADOS_COM_MEDICO = 7;
    public static final int TIPO_REALIZADOS_POR_INTERFACE = 9;
    public static final int TIPO_SOLICITADOS_GERAL = 4;
    public static final int TIPO_SOLICITADOS_COM_SETOR = 5;
    public static final int TIPO_SOLICITADOS_COM_CONVENIO = 6;
    public static final int TIPO_SOLICITADOS_COM_MEDICO = 8;
    private int tipoRelatorio = 1;
    public static final int TIPO_NAO_DETALHAR = 0;
    public static final int TIPO_DETALHAR = 1;
    private int acessoDesmembrar = 0;
    protected static String[] campos;

    public RelatorioRealizados(int tipoRelatorio, int acessoDesmembrar) {
        this.setName("RelatorioRealizados");
        this.tipoRelatorio = tipoRelatorio;
        this.acessoDesmembrar = acessoDesmembrar;
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "valorExame", "valorTotalExame", "valorMaterial", "quantidadeExames", "valorCHOriginal", "valorCH", "codigoMaterial", "descricaoMaterial", "descricaoAbreviadaMaterial", "codigoGrupo", "descricaoGrupo", "valorLiquidoTotalExame", "valorCustoSimplesExameAgrupado", "valorCustoSimplesExame", "valorCustoSimplesExameAgrupadoAtual", "valorCustoSimplesExameAtual"});
        if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de exames realizados", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo", "relatorios/rel_ger_rec_exames_realizados.jpg");
        } else if (this.tipoRelatorio == 3) {
            this.montaBarraDescricao("Relat\u00f3rio de exames realizados por conv\u00eanio", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo por conv\u00eanio", "relatorios/rel_ger_rec_exames_realizados_convenio.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio"});
        } else if (this.tipoRelatorio == 2) {
            this.montaBarraDescricao("Relat\u00f3rio de exames realizados por setor", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo por setor", "relatorios/rel_ger_rec_exames_realizados_setor.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoSetor", "descricaoSetor"});
        } else if (this.tipoRelatorio == 4) {
            this.montaBarraDescricao("Relat\u00f3rio de exames solicitados", "Listagem das requisi\u00e7\u00f5es solicitadas no per\u00edodo", "relatorios/rel_gerencia_exames_solicitados.jpg");
        } else if (this.tipoRelatorio == 6) {
            this.montaBarraDescricao("Relat\u00f3rio de exames solicitados por conv\u00eanio", "Listagem das requisi\u00e7\u00f5es solicitadas no per\u00edodo por conv\u00eanio", "relatorios/rel_gerencia_exames_solicitados_convenio.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio"});
        } else if (this.tipoRelatorio == 5) {
            this.montaBarraDescricao("Relat\u00f3rio de exames solicitados por setor", "Listagem das requisi\u00e7\u00f5es solicitadas no per\u00edodo por setor", "relatorios/rel_gerencia_exames_solicitados_setor.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoSetor", "descricaoSetor"});
        } else if (this.tipoRelatorio == 8) {
            this.montaBarraDescricao("Relat\u00f3rio de exames solicitados por m\u00e9dico", "Listagem das requisi\u00e7\u00f5es solicitadas no per\u00edodo por m\u00e9dico", "relatorios/rel_gerencia_exames_solicitados_medico.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "codigoAuxMed"});
        } else if (this.tipoRelatorio == 7) {
            this.montaBarraDescricao("Relat\u00f3rio de exames realizados por m\u00e9dico", "Listagem das requisi\u00e7\u00f5es realizadas no per\u00edodo por m\u00e9dico", "relatorios/rel_ger_rec_exames_realizados_medico.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "codigoAuxMed"});
        } else if (this.tipoRelatorio == 9) {
            this.montaBarraDescricao("Relat\u00f3rio de exames realizados por interface", "Listagem dos exames realizadas no per\u00edodo por interface", "relatorios/rel_ger_rec_exames_realizados_interface.jpg");
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoInterface", "descricaoInterface"});
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        if (tipoRelatorio == 9) {
            this.adicionaItemFiltro("filtroInterface", "Interface", "interface", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"int_codigo", "int_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroLabApoio", "Lab. Apoio", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        JComboBox comboOrdem = this.adicionaRetornaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        if (this.acessoDesmembrar == 1) {
            this.adicionaFiltroCheck("filtroDesmembrarMaterial", "Desmembrar por Material", false);
        }
        if (this.tipoRelatorio == 3 || this.tipoRelatorio == 7 || this.tipoRelatorio == 2 || this.tipoRelatorio == 1 && this.tipoRelatorio != 9) {
            this.adicionaRetornaFiltroCheck("filtroTipoData", "Filtrar por data de resultado", false);
        }
        JCheckBox checkDesmembrar = null;
        AbstractButton checkMostrarDesmembrados = null;
        if (Acesso.getAcesso(RelatorioRealizados.getModuloAcesso(this.tipoRelatorio, 1))) {
            checkDesmembrar = this.adicionaRetornaFiltroCheck("filtroDesmembrarMaterial", "Desmembrar por Material", false);
        }
        if (this.tipoRelatorio == 1 || this.tipoRelatorio == 4 || tipoRelatorio == 9 || this.tipoRelatorio == 3 || this.tipoRelatorio == 6) {
            comboOrdem.insertItemAt("C\u00f3digo AMB", comboOrdem.getItemCount());
            this.adicionaFiltroCheck("filtroCodigoAMB", "Mostrar c\u00f3digo AMB", false);
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoAMB"});
            String textoCheck = tipoRelatorio == 9 ? "Somente desmembrados" : "Mostrar material";
            checkMostrarDesmembrados = this.adicionaRetornaFiltroCheck("filtroDesmembrarMaterial", textoCheck, false);
        }
        if (checkMostrarDesmembrados != null) {
            checkMostrarDesmembrados.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        RelatorioRealizados.this.setModuloConfigurar(RelatorioRealizados.this.getModuloConfigurar(RelatorioRealizados.this.getTipoRelatorio(), 1));
                        RelatorioRealizados.this.setModuloAcesso(RelatorioRealizados.getModuloAcesso(RelatorioRealizados.this.getTipoRelatorio(), 1));
                    } else {
                        RelatorioRealizados.this.setModuloConfigurar(RelatorioRealizados.this.getModuloConfigurar(RelatorioRealizados.this.getTipoRelatorio(), 0));
                        RelatorioRealizados.this.setModuloAcesso(RelatorioRealizados.getModuloAcesso(RelatorioRealizados.this.getTipoRelatorio(), 0));
                    }
                }
            });
        }
        if (checkDesmembrar != null) {
            checkDesmembrar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        RelatorioRealizados.this.setModuloConfigurar(RelatorioRealizados.this.getModuloConfigurar(RelatorioRealizados.this.getTipoRelatorio(), 1));
                        RelatorioRealizados.this.setModuloAcesso(RelatorioRealizados.getModuloAcesso(RelatorioRealizados.this.getTipoRelatorio(), 1));
                    } else {
                        RelatorioRealizados.this.setModuloConfigurar(RelatorioRealizados.this.getModuloConfigurar(RelatorioRealizados.this.getTipoRelatorio(), 0));
                        RelatorioRealizados.this.setModuloAcesso(RelatorioRealizados.getModuloAcesso(RelatorioRealizados.this.getTipoRelatorio(), 0));
                    }
                }
            });
        }
        this.setModuloConfigurar(this.getModuloConfigurar(this.tipoRelatorio, 0));
        this.setModuloAcesso(RelatorioRealizados.getModuloAcesso(this.tipoRelatorio, 0));
        this.setCamposConfigurador(campos);
    }

    private HashMap<String, String> getCamposSelect() {
        LinkedHashMap<String, String> mapaTodosCampos = new LinkedHashMap<String, String>();
        if (this.tipoRelatorio == 1 || this.tipoRelatorio == 4) {
            if (this.getFiltroCheck("filtroDesmembrarMaterial")) {
                mapaTodosCampos.put("quantidadeExames", "count(a.exa_codigo||h.mco_codigo)");
            } else {
                mapaTodosCampos.put("quantidadeExames", "count(a.exa_codigo)");
            }
        } else if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
            mapaTodosCampos.put("quantidadeExames", "count(intexr.exa_kodigo || intexr.mco_codigo)");
        } else if (this.getFiltroCheck("filtroDesmembrarMaterial")) {
            mapaTodosCampos.put("quantidadeExames", "count(a.exa_codigo||h.mco_codigo)");
        } else {
            mapaTodosCampos.put("quantidadeExames", "count(a.exa_codigo)");
        }
        if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
            mapaTodosCampos.put("valorExame", "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, intexr.exa_kodigo, intexr.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
            mapaTodosCampos.put("valorTotalExame", "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, intexr.exa_kodigo, intexr.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
            mapaTodosCampos.put("valorLiquidoTotalExame", "sum(round(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, intexr.exa_kodigo, intexr.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo) * ((100 - b.req_desconto)/100), " + ParametrosGerais.getCasasPrecoExame() + "))");
            mapaTodosCampos.put("valorCHOriginal", "sum(a.exr_vlrchexame)");
            mapaTodosCampos.put("valorCH", "sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, intexr.exa_kodigo, intexr.mco_codigo))");
            mapaTodosCampos.put("valorMaterial", "sum(a.exr_vlrmaterial)");
            mapaTodosCampos.put("valorCustoSimplesExameAgrupado", "sum(COALESCE(a.exr_custosimples, 0.0))");
        } else {
            mapaTodosCampos.put("valorExame", "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
            mapaTodosCampos.put("valorTotalExame", "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
            mapaTodosCampos.put("valorLiquidoTotalExame", "sum(round(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo) * ((100 - (b.req_desconto - b.req_acrescimo))/100), " + ParametrosGerais.getCasasPrecoExame() + "))");
            mapaTodosCampos.put("valorCHOriginal", "sum(a.exr_vlrchexame)");
            mapaTodosCampos.put("valorCH", "sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo))");
            mapaTodosCampos.put("valorMaterial", "sum(a.exr_vlrmaterial)");
            mapaTodosCampos.put("valorCustoSimplesExameAgrupado", "sum(COALESCE(a.exr_custosimples, 0.0))");
        }
        if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
            mapaTodosCampos.put("codigoExame", "intexr.exa_kodigo");
            mapaTodosCampos.put("descricaoExame", "(select distinct(exa_descricao) from exames where exa_codigo = intexr.exa_kodigo limit 1)");
        } else {
            mapaTodosCampos.put("codigoExame", "a.exa_codigo");
            mapaTodosCampos.put("descricaoExame", "c.exa_descricao");
        }
        mapaTodosCampos.put("descricaoExameAscii", "UPPER(TO_ASCII(c.exa_descricao))");
        if (this.getFiltroCheck("filtroDesmembrarMaterial")) {
            mapaTodosCampos.put("codigoMaterial", "h.mco_codigo");
            mapaTodosCampos.put("descricaoMaterial", "h.mco_descricao");
            mapaTodosCampos.put("descricaoAbreviadaMaterial", "h.mco_abreviatura");
            if (this.tipoRelatorio != 9) {
                mapaTodosCampos.put("codigoGrupo", "i.grp_codigo");
                mapaTodosCampos.put("descricaoGrupo", "i.grp_descricao");
            }
        }
        if (this.getFiltroCheck("filtroCodigoAMB")) {
            if (ParametrosGerais.getPrecoMetodologia()) {
                mapaTodosCampos.put("codigoAMB", "COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), dtp.dtp_codamb)");
            } else {
                mapaTodosCampos.put("codigoAMB", "dtp.dtp_codamb");
            }
        }
        if (this.tipoRelatorio == 3 || this.tipoRelatorio == 6) {
            mapaTodosCampos.put("fantasiaConvenio", "d.con_fantasia");
            mapaTodosCampos.put("codigoConvenio", "d.con_codigo");
            mapaTodosCampos.put("razaoSocialConvenio", "d.con_razao");
        } else if (this.tipoRelatorio == 2 || this.tipoRelatorio == 5) {
            mapaTodosCampos.put("codigoSetor", "e.set_codigo");
            mapaTodosCampos.put("descricaoSetor", "f.set_descricao");
        } else if (this.tipoRelatorio == 7 || this.tipoRelatorio == 8) {
            mapaTodosCampos.put("conselhoMedico", "b.med_conselho");
            mapaTodosCampos.put("crmMedico", "b.med_crm");
            mapaTodosCampos.put("ufMedico", "b.med_uf");
            mapaTodosCampos.put("nomeMedico", "med.med_nome");
            mapaTodosCampos.put("nomeMedicoAscii", "UPPER(TO_ASCII(med.med_nome))");
            mapaTodosCampos.put("codigoAuxMed", "b.med_conselho||b.med_crm||b.med_uf");
        } else if (this.tipoRelatorio == 9) {
            mapaTodosCampos.put("codigoInterface", "coalesce(it.int_codigo,0)");
            mapaTodosCampos.put("descricaoInterface", "it.int_descricao");
        }
        if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
            mapaTodosCampos.putAll(Constantes.MAPA_SELECT_FILIAL);
        }
        mapaTodosCampos.put("valorCustoSimplesExame", "avg(COALESCE(a.exr_custosimples,0.0))");
        mapaTodosCampos.put("valorCustoSimplesExameAgrupadoAtual", "SUM(COALESCE(emc.emc_custosimples,0.0))");
        mapaTodosCampos.put("valorCustoSimplesExameAtual", "avg(COALESCE(emc.emc_custosimples,0.0))");
        return mapaTodosCampos;
    }

    private String getLayoutRelatorio(Statement st) {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            if (this.tipoRelatorio != 9) {
                buf.append(RelatorioRealizados.getModuloAcesso(this.tipoRelatorio, this.getFiltroCheck("filtroDesmembrarMaterial") ? 1 : 0));
            } else {
                buf.append(RelatorioRealizados.getModuloAcesso(this.tipoRelatorio, 0));
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("rel_xml");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o layout do relat\u00f3rio.\n" + e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    public void imprimirPressionado() {
        HashMap<String, String> mapaTodosCampos = this.getCamposSelect();
        HashMap<String, String> mapaCamposObrigatorios = this.getCamposObrigatorios();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && !Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "Informe ao menos a data inicial.", 2);
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getFiltroCombo("ordemRelatorio").equals("C\u00f3digo AMB") && !this.getFiltroCheck("filtroCodigoAMB")) {
            Funcoes.mensagem(this, "O filtro \"Mostrar c\u00f3digo AMB\" deve ser selecionado.", 2);
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            return;
        }
        try {
            String[] labexterno;
            String[] interfaces;
            int i;
            String[] materiais;
            String[] exames;
            String[] coletas;
            String[] estacoes;
            String[] setor;
            StringBuilder buf = new StringBuilder();
            String layoutRelatorio = this.getLayoutRelatorio(st);
            String[] grupos = this.getSelecionadosFiltro("filtroGrupo", 0);
            if (Funcoes.textoVazio(layoutRelatorio)) {
                this.habilitaBotaoImprimir(true);
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            HashMap<String, String> camposUtilizados = Relatorio.getCamposBancoLayout(layoutRelatorio, mapaTodosCampos, mapaCamposObrigatorios);
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1]) && !camposUtilizados.containsKey("descricaoExameAscii".toLowerCase())) {
                camposUtilizados.put("descricaoExameAscii".toLowerCase(), "UPPER(TO_ASCII(c.exa_descricao))");
            }
            buf.append("select ");
            if (!this.getFiltroCheck("filtroDesmembrarMaterial")) {
                buf.append(" distinct ");
            }
            if (grupos == null && camposUtilizados != null && camposUtilizados.containsKey("codigogrupo")) {
                camposUtilizados.remove("codigogrupo");
            }
            buf.append(Relatorio.getFieldsSelect(camposUtilizados));
            buf.append(" from examerequisicao a ");
            buf.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append(" left join examematcoleta  emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
            buf.append(" left join destino des on b.fil_codigo = des.fil_codigo and b.des_codigo = des.des_codigo ");
            buf.append(" left join loteexternoexamerequisicao lote on a.fil_codigo = lote.fil_codigo and a.req_codigo = lote.req_codigo and a.exa_codigo = lote.exa_codigo and lote.ler_datahoraestorno is null");
            if (this.tipoRelatorio == 9) {
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" join interfaceexamerequisicaodesm intexr on a.fil_codigo = intexr.fil_codigo ");
                    buf.append("  and a.req_codigo = intexr.req_codigo ");
                    buf.append("  and a.exa_codigo = intexr.exa_codigo ");
                    buf.append("  and a.mco_codigo = intexr.mco_codigo ");
                    buf.append("  and intexr.erd_situacao = ").append(8);
                    buf.append(" left join interface it on a.fil_codigo = it.fil_codigo and it.int_codigo = intexr.int_codigo ");
                } else {
                    buf.append(" join interfaceexamerequisicao intexr on a.fil_codigo = intexr.fil_codigo and intexr.req_codigo = b.req_codigo and a.exa_codigo = intexr.exa_codigo and a.mco_codigo = intexr.mco_codigo and intexr.ier_situacao = ").append(8);
                    buf.append(" join interface it on a.fil_codigo = it.fil_codigo and it.int_codigo = intexr.int_codigo ");
                }
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and intexr.exa_kodigo = c.exa_codigo");
                } else {
                    buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and intexr.exa_codigo = c.exa_codigo");
                }
                buf.append(" left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true");
                } else {
                    buf.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true and e.exa_codigo = c.exa_codigo ");
                }
                buf.append(" left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
                buf.append(" left join medico med on b.fil_codigo =  med.fil_codigo and b.med_conselho = med.med_conselho and b.med_crm = med.med_crm and b.med_uf = med.med_uf ");
                if (this.tipoRelatorio == 9) {
                    if (!this.getFiltroCheck("filtroDesmembrarMaterial")) {
                        buf.append(" left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
                    }
                } else {
                    buf.append(" left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
                }
                if (this.getFiltroCheck("filtroDesmembrarMaterial") && this.tipoRelatorio == 9) {
                    buf.append(" left join materialcoleta h on a.fil_codigo = h.fil_codigo and  intexr.mco_codigo = h.mco_codigo ");
                } else {
                    buf.append(" left join materialcoleta h on a.fil_codigo = h.fil_codigo and  a.mco_codigo = h.mco_codigo ");
                }
                if (this.tipoRelatorio == 9) {
                    if (!this.getFiltroCheck("filtroDesmembrarMaterial")) {
                        buf.append(" left join grupo i on a.fil_codigo = i.fil_codigo and g.grp_codigo = i.grp_codigo ");
                    }
                } else {
                    buf.append(" left join grupo i on a.fil_codigo = i.fil_codigo and g.grp_codigo = i.grp_codigo ");
                }
            } else {
                buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
                buf.append(" left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
                buf.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
                buf.append(" left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
                buf.append(" left join medico med on b.fil_codigo =  med.fil_codigo and b.med_conselho = med.med_conselho and b.med_crm = med.med_crm and b.med_uf = med.med_uf ");
                if (grupos != null) {
                    buf.append(" left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
                    buf.append(" left join grupo i on a.fil_codigo = i.fil_codigo and g.grp_codigo = i.grp_codigo ");
                }
                buf.append(" left join materialcoleta h on a.fil_codigo = h.fil_codigo and  a.mco_codigo = h.mco_codigo ");
            }
            if (this.getFiltroCheck("filtroCodigoAMB")) {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" left join detalhetabelaprecometodologia dtm on a.fil_codigo = dtm.fil_codigo and d.tpe_codigo = dtm.tpe_codigo and c.exa_codigo = dtm.exa_codigo and h.mco_codigo = dtm.mco_codigo and a.met_codigo = dtm.met_codigo ");
                }
                buf.append(" left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and d.tpe_codigo = dtp.tpe_codigo and c.exa_codigo = dtp.exa_codigo and h.mco_codigo = dtp.mco_codigo ");
            }
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i2 = 0; i2 < filiais.length; ++i2) {
                bufWhere.append(StringUtil.textoDBEscape(filiais[i2]));
                if (i2 >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i3 = 0; i3 < convenio.length; ++i3) {
                    bufWhere.append(convenio[i3]);
                    if (i3 >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i4 = 0; i4 < setor.length; ++i4) {
                    bufWhere.append("'");
                    bufWhere.append(setor[i4]);
                    bufWhere.append("'");
                    if (i4 >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((estacoes = this.getSelecionadosFiltro("filtroEstacao", 0)) != null) {
                bufWhere.append(" and b.est_codigo in (");
                for (int i5 = 0; i5 < estacoes.length; ++i5) {
                    bufWhere.append(estacoes[i5]);
                    if (i5 >= estacoes.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i6 = 0; i6 < coletas.length; ++i6) {
                    bufWhere.append(StringUtil.textoDBEscape(coletas[i6]));
                    if (i6 >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                int i7;
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    bufWhere.append(" and intexr.exa_kodigo in (");
                    for (i7 = 0; i7 < exames.length; ++i7) {
                        bufWhere.append("'");
                        bufWhere.append(exames[i7]);
                        bufWhere.append("'");
                        if (i7 >= exames.length - 1) continue;
                        bufWhere.append(", ");
                    }
                    bufWhere.append(")");
                } else {
                    bufWhere.append(" and a.exa_codigo in (");
                    for (i7 = 0; i7 < exames.length; ++i7) {
                        bufWhere.append("'");
                        bufWhere.append(exames[i7]);
                        bufWhere.append("'");
                        if (i7 >= exames.length - 1) continue;
                        bufWhere.append(", ");
                    }
                    bufWhere.append(")");
                }
            }
            if ((materiais = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
                if (this.getFiltroCheck("filtroDesmembrarMaterial") && this.tipoRelatorio == 9) {
                    bufWhere.append(" and intexr.mco_codigo in (");
                    for (i = 0; i < materiais.length; ++i) {
                        bufWhere.append(materiais[i]);
                        if (i >= materiais.length - 1) continue;
                        bufWhere.append(", ");
                    }
                    bufWhere.append(")");
                } else {
                    bufWhere.append(" and a.mco_codigo in (");
                    for (i = 0; i < materiais.length; ++i) {
                        bufWhere.append(materiais[i]);
                        if (i >= materiais.length - 1) continue;
                        bufWhere.append(", ");
                    }
                    bufWhere.append(")");
                }
            }
            if (!(this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial") || grupos == null)) {
                bufWhere.append(" and g.grp_codigo in (");
                for (i = 0; i < grupos.length; ++i) {
                    bufWhere.append(StringUtil.textoDBEscape(grupos[i]));
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((interfaces = this.getSelecionadosFiltro("filtroInterface", 0)) != null) {
                bufWhere.append(" and it.int_codigo in (");
                for (int i8 = 0; i8 < interfaces.length; ++i8) {
                    bufWhere.append("'");
                    bufWhere.append(interfaces[i8]);
                    bufWhere.append("'");
                    if (i8 >= interfaces.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((labexterno = this.getSelecionadosFiltro("filtroLabApoio", 0)) != null) {
                bufWhere.append(" and lote.lae_codigo in (");
                for (int i9 = 0; i9 < labexterno.length; ++i9) {
                    bufWhere.append("'");
                    bufWhere.append(labexterno[i9]);
                    bufWhere.append("'");
                    if (i9 >= labexterno.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
                bufWhere.append(" and lote.ler_datahoraestorno is null");
            }
            this.getSelecionadosFiltroValoresConcat("filtroDestino", 0, bufWhere, " and des.des_codigo in ", false, true);
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                bufWhere.append(" and (");
                for (int i10 = 0; i10 < crm.length; ++i10) {
                    bufWhere.append("(b.med_conselho = '");
                    bufWhere.append(conselho[i10]);
                    bufWhere.append("' and b.med_crm = '");
                    bufWhere.append(crm[i10]);
                    bufWhere.append("' and b.med_uf = '");
                    bufWhere.append(uf[i10]);
                    bufWhere.append("')");
                    if (i10 >= crm.length - 1) continue;
                    bufWhere.append(" or ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and ").append(this.getCampoData()).append(" >= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and ").append(this.getCampoData()).append(" <= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3 || this.tipoRelatorio == 2 || this.tipoRelatorio == 7) {
                bufWhere.append(" and a.exr_situacao not in ('");
                bufWhere.append("T");
                bufWhere.append("', '");
                bufWhere.append("A");
                bufWhere.append("', '");
                bufWhere.append("F");
                bufWhere.append("', '").append("R");
                bufWhere.append("', '', ' ') and a.exr_situacao is not null ");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                buf.append("and a.fil_codigo > 0");
                buf.append(" group by intexr.exa_kodigo, c.exa_descricao ,intexr.exa_kodigo ");
            } else {
                buf.append(" group by a.exa_codigo, c.exa_descricao ");
                if (grupos != null) {
                    buf.append(", i.grp_codigo");
                }
            }
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(" ,filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append(" filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_cnes, ");
                buf.append(" filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append(" cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append(" bairrofilial.bai_descricao ");
            }
            if (this.tipoRelatorio == 3 || this.tipoRelatorio == 6) {
                buf.append(" ,d.con_fantasia, d.con_codigo, d.con_razao ");
            } else if (this.tipoRelatorio == 2 || this.tipoRelatorio == 5) {
                buf.append(" ,e.set_codigo, f.set_descricao ");
            } else if (this.tipoRelatorio == 7 || this.tipoRelatorio == 8) {
                buf.append(" ,b.med_conselho, b.med_crm, b.med_uf, med.med_nome ");
            } else if (this.tipoRelatorio == 9) {
                buf.append(" ,it.int_codigo, it.int_descricao ");
            }
            if (this.tipoRelatorio == 9) {
                if (!this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" ,h.mco_codigo, h.mco_descricao, h.mco_abreviatura, i.grp_codigo, i.grp_descricao ");
                } else {
                    buf.append(" ,h.mco_codigo, h.mco_descricao, h.mco_abreviatura");
                }
            } else {
                if (this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" ,h.mco_codigo, h.mco_descricao, h.mco_abreviatura ");
                }
                if (grupos != null) {
                    buf.append(", i.grp_codigo, i.grp_descricao ");
                }
            }
            if (this.getFiltroCheck("filtroCodigoAMB")) {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" ,COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), dtp.dtp_codamb) ");
                } else {
                    buf.append(" ,dtp.dtp_codamb ");
                }
            }
            buf.append(" order by ");
            if (this.tipoRelatorio == 3 || this.tipoRelatorio == 6) {
                buf.append("d.con_codigo, ");
            } else if (this.tipoRelatorio == 7 || this.tipoRelatorio == 8) {
                buf.append("UPPER(TO_ASCII(med.med_nome)), b.med_conselho, b.med_crm, b.med_uf, ");
            } else if (this.tipoRelatorio == 2 || this.tipoRelatorio == 5) {
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append("f.set_descricao, e.set_codigo, ");
                } else {
                    buf.append("e.set_codigo, ");
                }
            }
            if (this.tipoRelatorio != 9) {
                if (this.getFiltroCombo("ordemRelatorio").equals("C\u00f3digo AMB") && Relatorio.getFieldsSelect(camposUtilizados).toUpperCase().contains("CODIGOAMB")) {
                    buf.append("dtp.dtp_codamb");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append("UPPER(TO_ASCII(c.exa_descricao))");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append("quantidadeExames");
                } else {
                    buf.append("a.exa_codigo ");
                }
            }
            if (this.getFiltroCheck("filtroDesmembrarMaterial")) {
                if (this.tipoRelatorio != 9) {
                    buf.append(",");
                }
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" codigoInterface, descricaoInterface ");
                } else {
                    buf.append(" h.mco_codigo ,h.mco_descricao, h.mco_abreviatura");
                    if (grupos != null) {
                        buf.append(", i.grp_codigo, i.grp_descricao  ");
                    }
                }
            }
            if (this.tipoRelatorio == 9) {
                if (this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(", ");
                }
                if (!this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append(" codigoInterface, descricaoInterface,");
                }
                if (this.getFiltroCombo("ordemRelatorio").equals("C\u00f3digo AMB") && Relatorio.getFieldsSelect(camposUtilizados).toUpperCase().contains("CODIGOAMB")) {
                    buf.append("dtp.dtp_codamb");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append("UPPER(TO_ASCII(c.exa_descricao))");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append("quantidadeExames");
                } else if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    buf.append("intexr.exa_kodigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append("UPPER(TO_ASCII(c.exa_descricao))");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append("quantidadeExames");
                } else {
                    buf.append("a.exa_codigo ");
                }
            }
            String[] listaCamposUtilizados = new String[camposUtilizados.size()];
            Iterator<String> it = camposUtilizados.keySet().iterator();
            int i11 = 0;
            while (it.hasNext()) {
                listaCamposUtilizados[i11] = it.next().toString();
                ++i11;
            }
            ModeloGridTable modelo = new ModeloGridTable(listaCamposUtilizados);
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                int i12;
                Object[] o;
                ResultSet rsExamesPais;
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial") && (rsExamesPais = Conexao.executeQuery(Conexao.getStatement(), this.getSqlExamePai(buf.toString()))).next()) {
                    do {
                        o = new Object[listaCamposUtilizados.length];
                        for (i12 = 0; i12 < listaCamposUtilizados.length; ++i12) {
                            if (RelatorioUtil.possuiColuna(rsExamesPais, listaCamposUtilizados[i12]) <= 0) continue;
                            o[i12] = rsExamesPais.getObject(listaCamposUtilizados[i12]);
                        }
                        modelo.addLine(o);
                    } while (rsExamesPais.next());
                }
                HashMap<String, Double> totalizador = this.getTotalizador(st, bufWhere.toString());
                do {
                    o = new Object[listaCamposUtilizados.length];
                    for (i12 = 0; i12 < listaCamposUtilizados.length; ++i12) {
                        if (RelatorioUtil.possuiColuna(rs, listaCamposUtilizados[i12]) <= 0) continue;
                        o[i12] = rs.getObject(listaCamposUtilizados[i12]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (this.tipoRelatorio == 9 && this.getFiltroCheck("filtroDesmembrarMaterial")) {
                    modelo.ordenarColunaAvancado(modelo.findColumn("codigoInterface"), modelo.findColumn("codigoExame"), 1, false);
                }
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                if (!Funcoes.textoVazio(layoutRelatorio)) {
                    int i13;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioRealizados.this.panelCentro.removeAll();
                            RelatorioRealizados.this.panelCentro.repaint();
                            RelatorioRealizados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroDesmembrarMaterial", this.getFiltroCheck("filtroDesmembrarMaterial"));
                    var.put("filtroInterface", this.getSelecionadosFiltro("filtroInterface", 0));
                    if (this.getFiltroCheck("filtroCodigoAMB")) {
                        var.put("filtroCodigoAMB", this.getFiltroCheck("filtroCodigoAMB"));
                    }
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i13 = 0; i13 < filiais.length; ++i13) {
                            buf.append(filiais[i13]);
                            if (i13 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i13 = 0; i13 < convenio.length; ++i13) {
                            buf.append(convenio[i13]);
                            if (i13 >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (estacoes != null) {
                        for (i13 = 0; i13 < estacoes.length; ++i13) {
                            buf.append(estacoes[i13]);
                            if (i13 >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (i13 = 0; i13 < crm.length; ++i13) {
                            buf.append(conselho[i13]).append(": ");
                            buf.append(crm[i13]);
                            buf.append("(");
                            buf.append(uf[i13]);
                            buf.append(")");
                            if (i13 >= crm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i13 = 0; i13 < coletas.length; ++i13) {
                            buf.append(coletas[i13]);
                            if (i13 >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (exames != null) {
                        for (i13 = 0; i13 < exames.length; ++i13) {
                            buf.append(exames[i13]);
                            if (i13 >= exames.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i13 = 0; i13 < setor.length; ++i13) {
                            buf.append(setor[i13]);
                            if (i13 >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (materiais != null) {
                        for (i13 = 0; i13 < materiais.length; ++i13) {
                            buf.append(materiais[i13]);
                            if (i13 >= materiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMaterial", buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (i13 = 0; i13 < grupos.length; ++i13) {
                            buf.append(StringUtil.textoDBEscape(grupos[i13]));
                            if (i13 >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroGrupo", buf.toString());
                    buf.delete(0, buf.length());
                    if (labexterno != null) {
                        for (i13 = 0; i13 < labexterno.length; ++i13) {
                            buf.append(labexterno[i13]);
                            if (i13 >= labexterno.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroLabApoio", buf.toString());
                    var.put("filtroDestino", this.getSelecionadosFiltroValores("filtroDestino", 0, false, false));
                    gerador.executar(layoutRelatorio, (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private HashMap<String, Double> getTotalizador(Statement st, String sql) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct b.req_codigo, b.req_vlrdesconto as vlrDesconto, b.req_vlracrescimo as vlrAcrescimo, ");
        buf.append(" sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo)) as vlrTotalExame");
        buf.append(" ,sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo)) as vlrTotal");
        buf.append(" from examerequisicao a ");
        buf.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on a.fil_codigo = lote.fil_codigo and a.req_codigo = lote.req_codigo and a.exa_codigo = lote.exa_codigo ");
        buf.append(" left join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
        buf.append(" left join destino des on b.fil_codigo = des.fil_codigo and b.des_codigo = des.des_codigo ");
        buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append(" left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
        buf.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
        buf.append(" left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
        buf.append(" left join medico med on b.fil_codigo =  med.fil_codigo and b.med_conselho = med.med_conselho and b.med_crm = med.med_crm and b.med_uf = med.med_uf ");
        buf.append(" left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append(" left join materialcoleta h on a.fil_codigo = h.fil_codigo and  a.mco_codigo = h.mco_codigo ");
        buf.append(" left join grupo i on a.fil_codigo = i.fil_codigo and g.grp_codigo = i.grp_codigo ");
        buf.append(" left join interface it on a.fil_codigo = it.fil_codigo");
        buf.append(" join interfaceexamerequisicaodesm intexr on a.fil_codigo = intexr.fil_codigo and intexr.req_codigo = a.req_codigo and a.exa_codigo = intexr.exa_codigo and a.mco_codigo = intexr.mco_codigo");
        buf.append(sql);
        buf.append("group by b.req_codigo, b.req_vlrdesconto, b.req_vlracrescimo ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        HashMap<String, Double> total = new HashMap<String, Double>();
        Double valorDesconto = 0.0;
        Double valorAcrescimo = 0.0;
        Double reqTotal = 0.0;
        Double reqTotalExame = 0.0;
        while (rs.next()) {
            valorDesconto = valorDesconto + rs.getDouble("vlrDesconto");
            valorAcrescimo = valorAcrescimo + rs.getDouble("vlrAcrescimo");
            reqTotal = reqTotal + rs.getDouble("vlrTotal");
            reqTotalExame = reqTotalExame + rs.getDouble("vlrTotalExame");
        }
        total.put("valorDesconto", valorDesconto);
        total.put("valorAcrescimo", valorAcrescimo);
        total.put("valorTotal", reqTotal);
        total.put("valorTotalExame", reqTotalExame);
        return total;
    }

    private HashMap<String, String> getCamposObrigatorios() {
        HashMap<String, String> camposObrigatorios = new HashMap<String, String>();
        if (this.tipoRelatorio == 7 || this.tipoRelatorio == 8) {
            camposObrigatorios.put("conselhoMedico", "b.med_conselho");
            camposObrigatorios.put("crmMedico", "b.med_crm");
            camposObrigatorios.put("ufMedico", "b.med_uf");
            camposObrigatorios.put("nomeMedico", "med.med_nome");
            camposObrigatorios.put("nomeMedicoAscii", "UPPER(TO_ASCII(med.med_nome))");
        }
        camposObrigatorios.put("valorTotalExame", "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, intexr.exa_kodigo, intexr.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
        camposObrigatorios.put("valorExame", "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, intexr.exa_kodigo, intexr.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
        if (!camposObrigatorios.isEmpty()) {
            return camposObrigatorios;
        }
        return null;
    }

    private String getSqlExamePai(String string) {
        String retorno = string;
        retorno = retorno.replaceAll("and a.fil_codigo > 0", "and b.req_codigo not in(select req_codigo from interfaceexamerequisicaodesm where a.exa_codigo = exa_codigo)");
        return retorno;
    }

    private int quantidadeRequisicoes(Statement st, String exame, String where) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(distinct a.req_codigo) as quantidadeRequisicoes ");
        buf.append("from examerequisicao a ");
        buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
        buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
        buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
        buf.append("left join medico med on b.fil_codigo =  med.fil_codigo and b.med_conselho = med.med_conselho and b.med_crm = med.med_crm and b.med_uf = med.med_uf ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(where);
        buf.append(" and a.exa_codigo = '").append(exame).append("'");
        buf.append(" and b.req_excluida = false and a.exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }

    public static long getModuloAcesso(int tipoRelatorio, int acessoDesmembrar) {
        if (acessoDesmembrar == 0) {
            if (tipoRelatorio == 2) {
                return Long.parseLong("0880100200");
            }
            if (tipoRelatorio == 3) {
                return Long.parseLong("0880100300");
            }
            if (tipoRelatorio == 7) {
                return Long.parseLong("0880101200");
            }
            if (tipoRelatorio == 1) {
                return Long.parseLong("0880100100");
            }
            if (tipoRelatorio == 9) {
                return Long.parseLong("0880102100");
            }
            if (tipoRelatorio == 5) {
                return Long.parseLong("0880100500");
            }
            if (tipoRelatorio == 6) {
                return Long.parseLong("0880100600");
            }
            if (tipoRelatorio == 8) {
                return Long.parseLong("0880101300");
            }
            return Long.parseLong("0880100400");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0880100202");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0880100302");
        }
        if (tipoRelatorio == 7) {
            return Long.parseLong("0880101202");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0880100102");
        }
        if (tipoRelatorio == 9) {
            return Long.parseLong("0880102102");
        }
        if (tipoRelatorio == 5) {
            return Long.parseLong("0880100502");
        }
        if (tipoRelatorio == 6) {
            return Long.parseLong("0880100602");
        }
        if (tipoRelatorio == 8) {
            return Long.parseLong("0880101302");
        }
        return Long.parseLong("0880100402");
    }

    private long getModuloConfigurar(int tipoRelatorio, int acessoDesmembrar) {
        if (acessoDesmembrar == 0) {
            if (tipoRelatorio == 2) {
                return Long.parseLong("0880100201");
            }
            if (tipoRelatorio == 3) {
                return Long.parseLong("0880100301");
            }
            if (tipoRelatorio == 7) {
                return Long.parseLong("0880101201");
            }
            if (tipoRelatorio == 1) {
                return Long.parseLong("0880100101");
            }
            if (tipoRelatorio == 5) {
                return Long.parseLong("0880100501");
            }
            if (tipoRelatorio == 9) {
                return Long.parseLong("0880102101");
            }
            if (tipoRelatorio == 6) {
                return Long.parseLong("0880100601");
            }
            if (tipoRelatorio == 8) {
                return Long.parseLong("0880101301");
            }
            return Long.parseLong("0880100401");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0880100202");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0880100302");
        }
        if (tipoRelatorio == 7) {
            return Long.parseLong("0880101202");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0880100102");
        }
        if (tipoRelatorio == 9) {
            return Long.parseLong("0880102102");
        }
        if (tipoRelatorio == 5) {
            return Long.parseLong("0880100502");
        }
        if (tipoRelatorio == 6) {
            return Long.parseLong("0880100602");
        }
        if (tipoRelatorio == 8) {
            return Long.parseLong("0880101302");
        }
        return Long.parseLong("0880100402");
    }

    private String getCampoData() {
        if (this.getFiltroCheck("filtroTipoData") || this.tipoRelatorio == 9) {
            return "cast(a.exr_datadigita as date)";
        }
        return "b.req_data";
    }

    private int getTipoRelatorio() {
        return this.tipoRelatorio;
    }
}

