/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPacientesContatos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static int TIPO_CADASTRO = 1;
    private int tipoRelatorio = TIPO_CADASTRO;
    private final String[] estados = ArraysUtil.concatenar(new String[]{"Todos"}, ConstantesGerais.ESTADOS);
    private final String[] ordem = new String[]{"C\u00f3digo", "Nome", "Cidade", "Estado", "Cidade/UF", "CPF", "CNPJ"};
    private final String[] proibido = new String[]{"Todas", "Liberadas", "Proibidas"};
    private final String[] fumanteDiabetico = new String[]{"Sim", "N\u00e3o", "N\u00e3o informado", "Todos"};
    private final long ACESSO_CONFIGURAR_CADASTRO = Long.parseLong("0824000101");
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_BAIRRO = "filtroBairro";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA_INICIAL = "filtroDataCadastroInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataCadastroFinal";
    private final String FILTRO_DIA_NASCIMENTO = "filtroDiaNascimento";
    private final String FILTRO_MES_NASCIMENTO = "filtroMesNascimento";
    private final String FILTRO_ANO_NASCIMENTO = "filtroAnoNascimento";
    private final String FILTRO_DDD = "filtroDDD";
    private final String FILTRO_MALADIRETA = "filtroMala";
    private final String FILTRO_PROIBIDO = "filtroProibido";
    private final String FILTRO_VIP = "filtroVIP";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_INTERVALO_ANIVERSARIO = "filtroAniversario";
    private final String FILTRO_DIA_NASCIMENTO2 = "filtroDiaNascimento2";
    private final String FILTRO_MES_NASCIMENTO2 = "filtroMesNascimento2";
    private final String FILTRO_EMAIL = "filtroEmail";
    private final String FILTRO_FUMANTE = "filtroFumante";
    private final String FILTRO_DIABETICO = "filtroDiabetico";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorRhPaciente", "fatorDuPaciente", "corPaciente", "observacaoPaciente", "dadoClinicoPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anoMesIdadePaciente", "idadePaciente", "foneContatoPaciente", "idadePaciente", "maePaciente", "paiPaciente", "malaDiretaPaciente", "senhaWebPaciente", "codigoCidade", "descricaoCidade", "estadoCidade", "codigoBairro", "descricaoBairro", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "percentualAcrescimoConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoMedico", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroMedico", "generoPaciente", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroCobranca", "descricaoBairroCobranca", "codigoCidadeCobranca", "descricaoCidadeCobranca", "razaoSocialEmpresa", "cnpjEmpresa", "ieEmpresa", "proprietarioAnimal", "sifEmpresa", "enderecoCobranca", "complementoCobranca", "cepCobranca", "foneCobranca", "responsavelCobranca", "codigoEspecieAnimal", "descricaoEspecieAnimal", "codigoRacaAnimal", "descricaoRacaAnimal", "pelagemAnimal", "codigoContato", "fantasiaContato", "razaoSocialContato", "responsavelContato", "cargoContato", "emailContato", "foneContato", "celularContato", "enderecoContato", "tipoContato", "complementoContato", "bairroContato", "nomeCidadeContato", "cepContato", "cnpjContato", "ieContato", "descricaoBairroContato", "UFCidadeContato"});

    public RelatorioPacientesContatos() {
        this.setName("RelatorioPacientesContatos");
        this.tipoRelatorio = TIPO_CADASTRO;
        String[] meses = ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.MESES_ANO);
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
            this.montaBarraDescricao("Relat\u00f3rio de contatos por pacientes", "Listagem dos contatos informados nos pacientes cadastrados", "relatorios/rel_contato_paciente.jpg");
        } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.montaBarraDescricao("Relat\u00f3rio de contatos por empresas", "Listagem dos contatos informados nas empresas cadastradas", "relatorios/rel_contato_empresa.jpg");
        } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.montaBarraDescricao("Relat\u00f3rio de contatos por animais", "Listagem dos contatos informados nos animais cadastrados", "relatorios/rel_contato_animal.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroBairro", "Bairro", "bairro", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Empresa", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
            this.adicionaFiltroCombo("filtroFumante", "Fumante: ", this.fumanteDiabetico, 3);
            this.adicionaFiltroCombo("filtroDiabetico", "Diab\u00e9tico: ", this.fumanteDiabetico, 3);
        }
        this.adicionaFiltroData("filtroDataCadastroInicial", "Dt.Cad. Inicial:");
        this.adicionaFiltroData("filtroDataCadastroFinal", "Dt.Cad. Final:");
        this.adicionaFiltroTexto("filtroDDD", "DDD inicial:", 12);
        this.adicionaFiltroCombo("filtroEstado", "Estado:", this.estados, 0);
        if (this.tipoRelatorio == TIPO_CADASTRO && Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.adicionaFiltroCombo("filtroProibido", "Situa\u00e7\u00e3o:", this.proibido, 0);
        }
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroVIP", Variaveis.tipoFilialPadrao.equals("A") ? "Empresa VIP" : "Paciente VIP", false);
        this.adicionaFiltroCheck("filtroEmail", Variaveis.tipoFilialPadrao.equals("A") ? "Empresa com e-mail" : "Paciente com e-mail", false);
        this.setModuloConfigurar(RelatorioPacientesContatos.getModuloConfigurar());
        this.setModuloAcesso(RelatorioPacientesContatos.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        boolean intervalo = this.getFiltroCheck("filtroAniversario");
        if (!(Funcoes.textoVazio(this.getFiltroNumero("filtroDiaNascimento")) || Funcoes.isNumeric(this.getFiltroNumero("filtroDiaNascimento")) && Integer.parseInt(this.getFiltroNumero("filtroDiaNascimento")) <= 31)) {
            Funcoes.mensagem(this, "Dia inv\u00e1lido", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!Funcoes.textoVazio(this.getFiltroNumero("filtroAnoNascimento")) && !Funcoes.isNumeric(this.getFiltroNumero("filtroAnoNascimento"))) {
            Funcoes.mensagem(this, "Ano inv\u00e1lido", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.tipoRelatorio == TIPO_CADASTRO) {
            if (!Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroInicial")) && !Funcoes.verificaData(this.getFiltroData("filtroDataCadastroInicial"))) {
                Funcoes.mensagem(this, "Data de cadastro inicial inv\u00e1lida", 1);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroFinal")) && !Funcoes.verificaData(this.getFiltroData("filtroDataCadastroFinal"))) {
                Funcoes.mensagem(this, "Data de cadastro final inv\u00e1lida", 1);
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] bairro;
            String[] cidade;
            StringBuilder buf = new StringBuilder("select a.pac_codigo as codigoPaciente, ");
            buf.append("a.pac_nome as nomePaciente, ");
            buf.append("a.pac_nomesocial as nomeSocialPaciente, ");
            buf.append("a.pac_sexo as sexoPaciente, ");
            buf.append("a.pac_datanasc as dataNascimentoPaciente, ");
            buf.append("a.pac_vip as vipPaciente, ");
            buf.append("a.pac_grpsangue as grupoSanguineoPaciente, ");
            buf.append("a.pac_fatorrh as fatorRhPaciente, ");
            buf.append("a.pac_fatordu as fatorDuPaciente, ");
            buf.append("a.pac_cor as corPaciente, ");
            buf.append("a.pac_observ as observacaoPaciente, ");
            buf.append("a.pac_dadoclinico as dadoClinicoPaciente, ");
            buf.append("a.pac_peso as pesoPaciente, ");
            buf.append("a.pac_altura as alturaPaciente, ");
            buf.append("a.pac_matricconv as matriculaConvenioPaciente, ");
            buf.append("a.pac_titularconv as titularConvenioPaciente, ");
            buf.append("a.pac_profissao as profissaoPaciente, ");
            buf.append("a.pac_fumante as fumantePaciente, ");
            buf.append("a.pac_diabetico as diabeticoPaciente, ");
            buf.append("a.pac_rg as rgPaciente, ");
            buf.append("a.pac_cpf as cpfPaciente, ");
            buf.append("a.pac_estcivil as estadoCivilPaciente, ");
            buf.append("a.pac_numfilho as numeroFilhosPaciente, ");
            buf.append("a.pac_datahora as dataHoraPaciente, ");
            buf.append("a.pac_dum as dumPaciente, ");
            buf.append("a.pac_fax as faxPaciente, ");
            buf.append("a.pac_celular as celularPaciente, ");
            buf.append("a.pac_fonecomercial as foneComercialPaciente, ");
            buf.append("a.pac_fone as fonePaciente, ");
            buf.append("a.pac_cep as cepPaciente, ");
            buf.append("a.pac_complemento as complementoPaciente, ");
            buf.append("a.pac_endereco as enderecoPaciente, ");
            buf.append("a.pac_numeroendereco as numeroEnderecoPaciente, ");
            buf.append("a.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
            buf.append("a.pac_email as emailPaciente, ");
            buf.append("a.pac_anomes as anoMesIdadePaciente, ");
            buf.append("a.pac_idade as idadePaciente, ");
            buf.append("a.pac_fonecontato as foneContatoPaciente, ");
            buf.append("a.pac_idade as idadePaciente, ");
            buf.append("a.pac_mae as maePaciente, ");
            buf.append("a.pac_pai as paiPaciente, ");
            buf.append("a.pac_maladireta as malaDiretaPaciente, ");
            buf.append("a.pac_senhaweb as senhaWebPaciente, ");
            buf.append("b.cid_codigo as codigoCidade, ");
            buf.append("b.cid_nome as descricaoCidade, ");
            buf.append("b.cid_uf as estadoCidade, ");
            buf.append("c.bai_codigo as codigoBairro, ");
            buf.append("c.bai_descricao as descricaoBairro, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_cnpjcpf as cnpjConvenio, ");
            buf.append("d.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("d.con_fatfmaterial as faturarFaltaMaterialConvenio, ");
            buf.append("d.con_descexame as habilitarDescontoConvenio, ");
            buf.append("d.con_multa as multaConvenio, ");
            buf.append("d.con_mora as moraConvenio, ");
            buf.append("d.con_fatfiliais as faturarFiliaisConvenio, ");
            buf.append("d.con_nr1via as quantidade1ViaConvenio, ");
            buf.append("d.con_nrexames as numeroExamesConvenio, ");
            buf.append("d.con_viasfatura as viasFaturaConvenio, ");
            buf.append("d.con_impbloqueto as imprimirBloquetoConvenio, ");
            buf.append("d.con_nr2via as quantidade2ViaConvenio, ");
            buf.append("d.con_tpcalcfatu as tipoCalculoFaturaConvenio, ");
            buf.append("d.con_percpgto as percentualBalcaoConvenio, ");
            buf.append("d.con_cobrexame as cobrarExameBalcaoConvenio,");
            buf.append("d.con_inscrest as inscricaoEstadualConvenio, ");
            buf.append("d.con_titdep as titularDependenteConvenio,");
            buf.append("d.con_maskcart as mascaraCarteiraConvenio, ");
            buf.append("d.con_contato as contatoConvenio, ");
            buf.append("d.con_informarmat as obrigaMatriculaConvenio, ");
            buf.append("d.con_cep as cepConvenio, ");
            buf.append("d.con_complemento as complementoConvenio, ");
            buf.append("d.con_endereco as enderecoConvenio, ");
            buf.append("d.con_numeroendereco as numeroEnderecoConvenio, ");
            buf.append("d.con_tipologradouroendereco as tipoLogradouroConvenio, ");
            buf.append("d.con_cepcobranca as cepCobrancaConvenio, ");
            buf.append("d.con_complcobranca as complementoCobrancaConvenio, ");
            buf.append("d.con_endcobranca as enderecoCobrancaConvenio, ");
            buf.append("d.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
            buf.append("d.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("d.con_fax as faxConvenio, ");
            buf.append("d.con_fone as foneConvenio, ");
            buf.append("d.con_valorfilme as valorFilmeConvenio, ");
            buf.append("d.con_valorch as valorCHConvenio, ");
            buf.append("d.con_site as siteConvenio, ");
            buf.append("d.con_email2 as email2Convenio, ");
            buf.append("d.con_email1 as email1Convenio, ");
            buf.append("d.con_tpcalcch as tipoCalculoCHConvenio, ");
            buf.append("d.con_inscmunic as inscricaoMunicipalConvenio, ");
            buf.append("d.con_bonus as percentualBonusConvenio, ");
            buf.append("d.con_acrescimo as percentualAcrescimoConvenio, ");
            buf.append("d.con_senhaweb as senhaWebConvenio, ");
            buf.append("d.con_proibidoweb as proibidoWebConvenio, ");
            buf.append("d.con_validadeguia as obrigaValidadeGuiaConvenio, ");
            buf.append("d.con_codigoguia as obrigaGuiaConvenio, ");
            buf.append("d.con_diasvalidade as diasValidadeGuia, ");
            buf.append("d.con_ordemfatura as ordemFaturaConvenio, ");
            buf.append("d.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("e.med_conselho as conselhoMedico, ");
            buf.append("e.med_crm as crmMedico, ");
            buf.append("e.cid_codigo as codigoCidadeMedico, ");
            buf.append("e.med_uf as ufMedico, ");
            buf.append("e.med_nome as nomeMedico, ");
            buf.append("e.med_abrev as abreviaturaMedico, ");
            buf.append("e.med_tipo as tipoMedico, ");
            buf.append("e.med_comissao as comissaoMedico, ");
            buf.append("e.med_cep as cepMedico, ");
            buf.append("e.med_complemento as complementoMedico, ");
            buf.append("e.med_endereco as enderecoMedico, ");
            buf.append("e.med_numeroendereco as numeroEnderecoMedico, ");
            buf.append("e.med_tipologradouroendereco as tipoLogradouroMedico, ");
            buf.append("e.med_celular as celularMedico, ");
            buf.append("e.med_fax as faxMedico, ");
            buf.append("e.med_fone as foneMedico, ");
            buf.append("e.bai_codigo as codigoBairroMedico, ");
            buf.append("e.med_email as emailMedico, ");
            buf.append("e.med_site as siteMedico, ");
            buf.append("e.med_senhaweb as senhaWebMedico, ");
            buf.append("f.cid_nome as descricaoCidadeMedico, ");
            buf.append("f.cid_uf as estadoCidadeMedico, ");
            buf.append("g.bai_descricao as descricaoBairroMedico, ");
            buf.append("a.cid_codigocobranca as codigoCidadeCobranca, ");
            buf.append("h.cid_nome as descricaoCidadeCobranca, ");
            buf.append("a.bai_codigocobranca as codigoBairroCobranca, ");
            buf.append("i.bai_descricao as descricaoBairroCobranca, ");
            buf.append("a.pac_razaosocial as razaoSocialEmpresa, ");
            buf.append("a.pac_cnpj as cnpjEmpresa, ");
            buf.append("a.pac_ie as ieEmpresa, ");
            buf.append("a.pac_proprietario as proprietarioAnimal, ");
            buf.append("a.pac_sif as sifEmpresa, ");
            buf.append("a.pac_enderecocobranca as enderecoCobranca, ");
            buf.append("a.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
            buf.append("a.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
            buf.append("a.pac_complementocobranca as complementoCobranca, ");
            buf.append("a.pac_cepcobranca as cepCobranca, ");
            buf.append("a.pac_fonecobranca as foneCobranca, ");
            buf.append("a.pac_responsavelcobranca as responsavelCobranca, ");
            buf.append("a.epc_codigo as codigoEspecieAnimal, ");
            buf.append("j.epc_descricao as descricaoEspecieAnimal, ");
            buf.append("a.rac_codigo as codigoRacaAnimal, ");
            buf.append("k.rac_descricao as descricaoRacaAnimal, ");
            buf.append("a.pac_pelagem as pelagemAnimal, ");
            buf.append("idg.ige_descricao as generoPaciente, ");
            buf.append("0 as codigoContato, '' as fantasiaContato, '' as razaoSocialContato, ");
            buf.append("false as responsavelContato, '' as cargoContato, '' as emailContato, '' as foneContato, '' as celularContato, ");
            buf.append("'' as enderecoContato, '' as tipoContato, '' as complementoContato, '' as bairroContato, '' as nomeCidadeContato,  ");
            buf.append("'' as cepContato, '' as cnpjContato, '' as ieContato, '' as descricaoBairroContato, '' as UFCidadeContato, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from paciente a ");
            buf.append("left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo ");
            buf.append("left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            buf.append("left join medico e on a .fil_codigo = e.fil_codigo and a.med_conselho = e.med_conselho and a.med_crm = e.med_crm and a.med_uf = e.med_uf ");
            buf.append("left join cidades f on a.fil_codigo = f.fil_codigo and e.cid_codigo = f.cid_codigo ");
            buf.append("left join bairro g on a.fil_codigo = g.fil_codigo and e.bai_codigo = g.bai_codigo ");
            buf.append("left join cidades h on a.fil_codigo = h.fil_codigo and a.cid_codigocobranca = h.cid_codigo ");
            buf.append("left join bairro i on a.fil_codigo = c.fil_codigo and a.bai_codigocobranca = i.bai_codigo ");
            buf.append("left join especie j on a.fil_codigo = j.fil_codigo and a.epc_codigo = j.epc_codigo ");
            buf.append("left join raca k on a.fil_codigo = k.fil_codigo and a.rac_codigo = k.rac_codigo ");
            buf.append("left join identidadegenero idg on coalesce(a.pac_genero, 0) = idg.ige_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] paciente = null;
            paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0);
            if (paciente != null) {
                buf.append(" and a.pac_codigo in (");
                for (int i = 0; i < paciente.length; ++i) {
                    buf.append(paciente[i]);
                    if (i >= paciente.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((cidade = this.getSelecionadosFiltro("filtroCidade", 0)) != null) {
                buf.append(" and a.cid_codigo in (");
                for (int i = 0; i < cidade.length; ++i) {
                    buf.append(cidade[i]);
                    if (i >= cidade.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((bairro = this.getSelecionadosFiltro("filtroBairro", 0)) != null) {
                buf.append(" and a.bai_codigo in ('");
                for (int i = 0; i < bairro.length; ++i) {
                    buf.append(bairro[i]);
                    if (i >= bairro.length - 1) continue;
                    buf.append("', '");
                }
                buf.append("') ");
            }
            String[] convenio = null;
            if (this.tipoRelatorio == TIPO_CADASTRO) {
                convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
                if (convenio != null) {
                    buf.append(" and a.con_codigo in (");
                    for (int i = 0; i < convenio.length; ++i) {
                        buf.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                    int indice = this.getFiltroComboIndice("filtroDiabetico");
                    if (indice < 3) {
                        buf.append(" and a.pac_diabetico = '").append(indice == 0 ? "S" : (indice == 1 ? "N" : "I")).append("' ");
                    }
                    if ((indice = this.getFiltroComboIndice("filtroFumante")) < 3) {
                        buf.append(" and a.pac_fumante = '").append(indice == 0 ? "S" : (indice == 1 ? "N" : "I")).append("' ");
                    }
                }
            }
            if (!Funcoes.textoVazio(this.getFiltroTexto("filtroDDD"))) {
                buf.append(" and a.pac_fone ilike '");
                buf.append(this.getFiltroTexto("filtroDDD"));
                buf.append("%'");
            }
            if (!this.getFiltroCombo("filtroEstado").equals(this.estados[0])) {
                buf.append(" and b.cid_uf = '");
                buf.append(this.getFiltroCombo("filtroEstado"));
                buf.append("'");
            }
            if (this.getFiltroCheck("filtroVIP")) {
                buf.append(" and a.pac_vip = true ");
            }
            if (this.getFiltroCheck("filtroEmail")) {
                buf.append(" and (a.pac_email is not null and trim(a.pac_email) <> '') ");
            }
            if (this.tipoRelatorio == TIPO_CADASTRO) {
                if (!Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroInicial")) && Funcoes.verificaData(this.getFiltroData("filtroDataCadastroInicial"))) {
                    buf.append(" and cast(a.pac_datahora as date) >= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataCadastroInicial"))).append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroFinal")) && Funcoes.verificaData(this.getFiltroData("filtroDataCadastroFinal"))) {
                    buf.append(" and cast(a.pac_datahora as date) <= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataCadastroFinal"))).append("'");
                }
            }
            if (this.tipoRelatorio == TIPO_CADASTRO && Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                int pos = this.getFiltroComboIndice("filtroProibido");
                if (pos == 1) {
                    buf.append(" and NOT COALESCE(pac_proibido, false) ");
                } else if (pos == 2) {
                    buf.append(" and COALESCE(pac_proibido, false) ");
                }
            }
            buf.append(" order by a.fil_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals("Nome")) {
                buf.append("upper(a.pac_nome)");
            } else if (this.getFiltroCombo("ordemRelatorio").equals("Cidade")) {
                buf.append("upper(b.cid_nome)");
            } else if (this.getFiltroCombo("ordemRelatorio").equals("Cidade/UF")) {
                buf.append("upper(b.cid_nome), b.cid_uf");
            } else if (this.getFiltroCombo("ordemRelatorio").equals("Estado")) {
                buf.append("upper(b.cid_uf)");
            } else if (this.getFiltroCombo("ordemRelatorio").equals("CPF")) {
                buf.append("upper(a.pac_cpf)");
            } else if (this.getFiltroCombo("ordemRelatorio").equals("CNPJ")) {
                buf.append("upper(a.pac_cnpj)");
            } else {
                buf.append("a.pac_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroMedico") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : (campos[i].equals("anoMesIdadePaciente") ? Tipos.tipoIdade(rs.getString(campos[i])) : (campos[i].equals("anoMesIdadePaciente") ? Tipos.tipoSexo(rs.getString(campos[i])) : (campos[i].equals("corPaciente") ? Tipos.tipoCor(rs.getString(campos[i])) : (campos[i].equals("estadoCivilPaciente") ? Tipos.tipoEstadoCivil(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("fumantePaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente")) : (campos[i].equalsIgnoreCase("diabeticoPaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente")) : rs.getObject(campos[i])))))));
                    }
                    Registro[] contatos = this.getContatos(st2, rs.getString("codigoFilial"), rs.getString("codigoPaciente"));
                    if (contatos != null && contatos.length > 0) {
                        for (Registro reg : contatos) {
                            Object[] copia = (Object[])o.clone();
                            for (int col = 0; col < reg.getQtdeColunas(); ++col) {
                                String coluna = reg.getNomeColuna(col);
                                int pos = ArraysUtil.indice(campos, coluna, true);
                                if (pos <= -1) continue;
                                copia[pos] = reg.getValor(coluna);
                            }
                            modelo.addLine(copia);
                        }
                    } else {
                        modelo.addLine(o);
                    }
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioPacientesContatos.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioPacientesContatos.this.panelCentro.removeAll();
                            RelatorioPacientesContatos.this.panelCentro.repaint();
                            RelatorioPacientesContatos.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroEstado", this.getFiltroCombo("filtroEstado"));
                    var.put("filtroDDD", this.getFiltroTexto("filtroDDD"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (cidade != null) {
                        for (int i = 0; i < cidade.length; ++i) {
                            buf.append(cidade[i]);
                            if (i >= cidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (paciente != null) {
                        for (int i = 0; i < paciente.length; ++i) {
                            buf.append(paciente[i]);
                            if (i >= paciente.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroPaciente", buf.toString());
                    buf.delete(0, buf.length());
                    if (bairro != null) {
                        for (int i = 0; i < bairro.length; ++i) {
                            buf.append(bairro[i]);
                            if (i >= bairro.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroBairro", buf.toString());
                    if (this.tipoRelatorio == TIPO_CADASTRO) {
                        if (!Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroInicial")) && Funcoes.verificaData(this.getFiltroData("filtroDataCadastroInicial"))) {
                            var.put("filtroDataCadastroInicial", this.getFiltroData("filtroDataCadastroInicial"));
                        }
                        if (!Funcoes.textoVazio(this.getFiltroData("filtroDataCadastroFinal")) && Funcoes.verificaData(this.getFiltroData("filtroDataCadastroFinal"))) {
                            var.put("filtroDataCadastroFinal", this.getFiltroData("filtroDataCadastroFinal"));
                        }
                        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                            var.put("filtroProibido", this.proibido[this.getFiltroComboIndice("filtroProibido")]);
                        }
                        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                            var.put("filtroFumante", this.getFiltroCombo("filtroFumante"));
                            var.put("filtroDiabetico", this.getFiltroCombo("filtroDiabetico"));
                        }
                    }
                    var.put("filtroVIP", this.getFiltroCheck("filtroVIP") ? "Sim" : "N\u00e3o");
                    var.put("filtroEmail", this.getFiltroCheck("filtroEmail") ? "Sim" : "N\u00e3o");
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Registro[] getContatos(Statement st, String filial, String paciente) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select pco_codigo as codigoContato, pco_nome as fantasiaContato, '' as razaoSocialContato, ");
        buf.append("\t\t   pco_responsavel as responsavelContato, pco_cargo as cargoContato, pco_email as emailContato, pco_fone as foneContato, pco_celular as celularContato, ");
        buf.append("       '' as enderecoContato, '' as tipoContato, '' as complementoContato, '' as bairroContato, '' as nomeCidadeContato,  '' as cepContato, '' as cnpjContato, '' as ieContato, ");
        buf.append("       '' as descricaoBairroContato, '' as UFCidadeContato ");
        buf.append("from pacientescontatos ");
        buf.append("where pacientescontatos.fil_codigo = ").append(filial).append(" and pacientescontatos.pac_codigo = ").append(paciente);
        buf.append(" union (");
        buf.append("select entidade.ent_codigo, entidade.ent_fantasia, entidade.ent_razaosocial, ");
        buf.append("       pacienteentidade.pen_responsavel, '', entidade.ent_email, entidade.ent_fone, entidade.ent_celular, entidade.ent_endereco, ");
        buf.append("       pacienteentidade.pen_tipo, entidade.ent_complemento, bairro.bai_descricao, cidades.cid_nome, entidade.ent_cep, entidade.ent_cpfcnpj, ");
        buf.append("       entidade.ent_rgie, bairro.bai_descricao, cidades.cid_uf ");
        buf.append("from entidade ");
        buf.append("join pacienteentidade on entidade.fil_codigo = pacienteentidade.fil_codigo and entidade.ent_codigo = pacienteentidade.ent_codigo ");
        buf.append("left join bairro on entidade.fil_codigo = bairro.fil_codigo and entidade.bai_codigo = bairro.bai_codigo ");
        buf.append("left join cidades on entidade.fil_codigo = cidades.fil_codigo and entidade.cid_codigo = cidades.cid_codigo ");
        buf.append("where pacienteentidade.fil_codigo = ").append(filial).append(" and pacienteentidade.pac_codigo = ").append(paciente).append(") order by 4");
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<Registro> registros = new ArrayList<Registro>();
        while (rs.next()) {
            Registro r = new Registro(rs);
            registros.add(r);
        }
        if (registros.size() > 0) {
            return registros.toArray(new Registro[registros.size()]);
        }
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0824000100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0824000101");
    }
}

