/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.relatorio.Gerador;
import jalis.service.relatorio.recepcao.RelatorioPacientesAtendidosService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioPacientesAtendidos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_EMPRESA = "filtroEmpresa";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_IDADE_INICIAL = "filtroIdadeInicial";
    private final String FILTRO_IDADE_FINAL = "filtroIdadeFinal";
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_SEXO = "filtroSexo";
    private final String FILTRO_FUMANTE = "filtroFumante";
    private final String FILTRO_DIABETICO = "filtroDiabetico";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_COM_EMAIL = "filtroComEmail";
    private final String FILTRO_VIP = "filtroVIP";
    private final String FILTRO_IDADE_ATUAL = "filtroIdadeAtual";
    private final String FILTRO_SITUACAO_EXAMES = "filtroSituacaoExames";
    private static final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P"), Tipos.tipoSituacaoExame("N")};
    private RelatorioPacientesAtendidosService service = new RelatorioPacientesAtendidosService();

    public RelatorioPacientesAtendidos() {
        RelatorioPacientesAtendidos relatorioPacientesAtendidos = this;
        RelatorioPacientesAtendidos relatorioPacientesAtendidos2 = this;
        this.montaBarraDescricao(relatorioPacientesAtendidos.service.getTitulo(), this.service.getDescricao(), relatorioPacientesAtendidos2.service.getImagem());
        this.adicionaRelatorioListener(this);
        this.setModuloConfigurar(RelatorioPacientesAtendidos.getModuloConfigurar());
        this.setModuloAcesso(RelatorioPacientesAtendidos.getModuloAcesso());
        RelatorioPacientesAtendidos relatorioPacientesAtendidos3 = this;
        this.setCamposConfigurador(relatorioPacientesAtendidos3.service.getCampos());
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEmpresa", "Empresa", "entidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio ", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_razao"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame ", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{30, 70, 30, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data Final:");
        this.adicionaFiltroIdade("filtroIdadeInicial", "Idade Inicial:", 0);
        this.adicionaFiltroIdade("filtroIdadeFinal", "Idade Final:", 0);
        this.adicionaFiltroCombo("filtroEstado", "Estado:", this.service.getEstados(), 0);
        this.adicionaFiltroCombo("filtroSexo", "Sexo:", this.service.getSexo(), 0);
        this.adicionaFiltroCombo("filtroFumante", "Fumante: ", this.service.getFumante(), 0);
        this.adicionaFiltroCombo("filtroDiabetico", "Diab\u00e9tico:", this.service.getDiabetico(), 0);
        this.adicionaFiltroCombo("filtroSituacaoExames", "Sit. do Exame:", situacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.service.getOrdem(), 0);
        this.adicionaFiltroCheck("filtroComEmail", "Paciente com e-mail", false);
        this.adicionaFiltroCheck("filtroVIP", "Paciente VIP", false);
        this.adicionaFiltroCheck("filtroIdadeAtual", "Idade atual do paciente", false);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0826000100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0826000101");
    }

    private boolean validaCampos() {
        if (this.getFiltroData("filtroDataInicial").isEmpty() || this.getFiltroData("filtroDataFinal").isEmpty()) {
            Funcoes.mensagem(this, "Os campos \"Data Inicial\" e \"Data Final\" devem ser informados!", 2);
            return false;
        }
        return true;
    }

    private Map<String, Object> montaDadosCabecalho() {
        int i;
        HashMap<String, Object> varFiltro = new HashMap<String, Object>();
        StringBuilder buf = new StringBuilder();
        if (this.service.getFiltroFilial() != null) {
            for (i = 0; i < this.service.getFiltroFilial().length; ++i) {
                buf.append(this.service.getFiltroFilial()[i]);
                if (i >= this.service.getFiltroFilial().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroFilial", buf.toString());
        } else {
            varFiltro.put("filtroFilial", Variaveis.filialPadrao);
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroCidade() != null) {
            for (i = 0; i < this.service.getFiltroCidade().length; ++i) {
                buf.append(this.service.getFiltroCidade()[i]);
                if (i >= this.service.getFiltroCidade().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroCidade", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroEmpresa() != null) {
            for (i = 0; i < this.service.getFiltroEmpresa().length; ++i) {
                buf.append(this.service.getFiltroEmpresa()[i]);
                if (i >= this.service.getFiltroEmpresa().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroEmpresa", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroConvenio() != null) {
            for (i = 0; i < this.service.getFiltroConvenio().length; ++i) {
                buf.append(this.service.getFiltroConvenio()[i]);
                if (i >= this.service.getFiltroConvenio().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroConvenio", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroExame() != null) {
            for (i = 0; i < this.service.getFiltroExame().length; ++i) {
                buf.append(this.service.getFiltroExame()[i]);
                if (i >= this.service.getFiltroExame().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroExame", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroDestino() != null) {
            for (i = 0; i < this.service.getFiltroDestino().length; ++i) {
                buf.append(this.service.getFiltroDestino()[i]);
                if (i >= this.service.getFiltroDestino().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroDestino", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroMedico() != null) {
            for (i = 0; i < this.service.getFiltroMedico().length; ++i) {
                buf.append(((Object[])this.service.getFiltroMedico()[i])[3]);
                if (i >= this.service.getFiltroMedico().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroMedico", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroColeta() != null) {
            for (i = 0; i < this.service.getFiltroColeta().length; ++i) {
                buf.append(this.service.getFiltroColeta()[i]);
                if (i >= this.service.getFiltroColeta().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroColeta", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroPaciente() != null) {
            for (i = 0; i < this.service.getFiltroPaciente().length; ++i) {
                buf.append(((Object[])this.service.getFiltroPaciente()[i])[1]);
                if (i >= this.service.getFiltroPaciente().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroPaciente", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroSetor() != null) {
            for (i = 0; i < this.service.getFiltroSetor().length; ++i) {
                buf.append(this.service.getFiltroSetor()[i]);
                if (i >= this.service.getFiltroSetor().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroSetor", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroSituacaoExame() != null) {
            buf.append(this.service.getFiltroSituacaoExame());
            varFiltro.put("filtroSituacaoExames", buf.toString());
        }
        if (this.service.getFiltroDataInicial() != null) {
            varFiltro.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
        }
        if (this.service.getFiltroDataFinal() != null) {
            varFiltro.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
        }
        if (this.service.getFiltroIdadeInicial() != null) {
            varFiltro.put("filtroIdadeInicial", this.getFiltroIdade("filtroIdadeInicial").getIdade());
        }
        if (this.service.getFiltroIdadeFinal() != null) {
            varFiltro.put("filtroIdadeFinal", this.getFiltroIdade("filtroIdadeFinal").getIdade());
        }
        if (this.service.getFiltroEstado() != null) {
            varFiltro.put("filtroEstado", this.getFiltroCombo("filtroEstado"));
        }
        if (this.service.getFiltroSexo() != null) {
            varFiltro.put("filtroSexo", this.getFiltroCombo("filtroSexo"));
        }
        if (this.service.getFiltroFumante() != null) {
            varFiltro.put("filtroFumante", this.getFiltroCombo("filtroFumante"));
        }
        if (this.service.getFiltroDiabetico() != null) {
            varFiltro.put("filtroDiabetico", this.getFiltroCombo("filtroDiabetico"));
        }
        return varFiltro;
    }

    @Override
    public void imprimirPressionado() {
        block8: {
            if (this.validaCampos()) {
                RelatorioPacientesAtendidos relatorioPacientesAtendidos = this;
                ModeloGridTable modelo = new ModeloGridTable(relatorioPacientesAtendidos.service.getCampos());
                this.service.setFiltroFilial(this.getSelecionadosFiltro("filtroFilial", 0));
                this.service.setFiltroCidade(this.getSelecionadosFiltro("filtroCidade", 0));
                this.service.setFiltroEmpresa(this.getSelecionadosFiltro("filtroEmpresa", 0));
                this.service.setFiltroConvenio(this.getSelecionadosFiltro("filtroConvenio", 0));
                this.service.setFiltroExame(this.getSelecionadosFiltro("filtroExame", 0));
                this.service.setFiltroDestino(this.getSelecionadosFiltro("filtroDestino", 0));
                this.service.setFiltroMedico(this.getSelecionadosFiltroAvancado("filtroMedico"));
                this.service.setFiltroColeta(this.getSelecionadosFiltro("filtroColeta", 0));
                this.service.setFiltroPaciente(this.getSelecionadosFiltroAvancado("filtroPaciente"));
                this.service.setFiltroSetor(this.getSelecionadosFiltro("filtroSetor", 0));
                this.service.setFiltroDataInicial(this.getFiltroData("filtroDataInicial"));
                this.service.setFiltroDataFinal(this.getFiltroData("filtroDataFinal"));
                this.service.setFiltroIdadeInicial(this.getFiltroIdade("filtroIdadeInicial"));
                this.service.setFiltroIdadeFinal(this.getFiltroIdade("filtroIdadeFinal"));
                this.service.setFiltroEstado(this.getFiltroCombo("filtroEstado").toString());
                this.service.setFiltroSexo(this.getFiltroCombo("filtroSexo").toString());
                this.service.setFiltroFumante(this.getFiltroCombo("filtroFumante").toString());
                this.service.setFiltroDiabetico(this.getFiltroCombo("filtroDiabetico").toString());
                this.service.setOrdemRelatorio(this.getFiltroCombo("ordemRelatorio").toString());
                this.service.setFiltroComEmail(this.getFiltroCheck("filtroComEmail"));
                this.service.setFiltroVIP(this.getFiltroCheck("filtroVIP"));
                this.service.setFiltroIdadeAtual(this.getFiltroCheck("filtroIdadeAtual"));
                this.service.setFiltroSituacaoExame(this.getFiltroCombo("filtroSituacaoExames").toString());
                try {
                    List<Object> listaDados = this.service.geraRelatorio();
                    if (!listaDados.isEmpty()) {
                        Iterator<Object> it = listaDados.iterator();
                        while (it.hasNext()) {
                            modelo.addLine((Object[])it.next());
                        }
                        if (!Funcoes.textoVazio(this.service.getModeloRelatorio())) {
                            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                            gerador.setPai(this.panelCentro);
                            gerador.setPreVisualizar(true);
                            gerador.setZoomPreVisualizar(0.5f);
                            gerador.setAcaoFechar(new Runnable(){

                                @Override
                                public void run() {
                                    RelatorioPacientesAtendidos.this.panelCentro.removeAll();
                                    RelatorioPacientesAtendidos.this.panelCentro.repaint();
                                    RelatorioPacientesAtendidos.this.habilitaBotaoImprimir(true);
                                }
                            });
                            Map<String, Object> varFiltro = this.montaDadosCabecalho();
                            gerador.executar(this.service.getModeloRelatorio(), (TableModel)modelo, varFiltro);
                            this.panelCentro.revalidate();
                        } else {
                            this.habilitaBotaoImprimir(true);
                        }
                        break block8;
                    }
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do relat\u00f3rio." + e.getMessage(), e.getStackTrace());
                }
            } else {
                this.habilitaBotaoImprimir(true);
            }
        }
    }
}

