/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.table.TableModel;

public class RelatorioOrcamento
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static HashMap<String, String> MAPA_TODOS_CAMPOS_DISPONIVEIS = new HashMap();
    private static String LIGACOES = "";
    private final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", Variaveis.tipoFilialPadrao.equals("A") ? "Cliente" : "Paciente"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final String FILTRO_USUARIO = "filtroUsuario";
    protected static String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "codigoConvenioRequisicao", "razaoSocialConvenioRequisicao", "fantasiaConvenioRequisicao", "codigosExamesRequisicao", "codigosConveniosOrcamento", "fantasiasConveniosOrcamento", "codigoOrcamento", "dataHoraOrcamento", "observacaoOrcamento", "percentualDescontoOrcamento", "valorDescontoOrcamento", "validadeOrcamento", "solicitanteOrcamento", "contatoOrcamento", "emailOrcamento", "proprietarioOrcamento", "percentualAcrescimoOrcamento", "valorAcrescimoOrcamento", "dataAprovadoOrcamento", "aprovadoPorOrcamento", "foneOrcamento", "foneContatoOrcamento", "codigoUsuarioOrcamento", "nomeUsuarioOrcamento", "nomePacienteOrcamento", "codigoPacienteOrcamento", "codigoUsuarioAprovadoOrcamento", "nomeUsuarioAprovadoOrcamento", "totalTaxasOrcamento", "descricoesTaxasOrcamento"});
    public static final String JOIN_FILIAL = "left join filiais_postocoleta filial on orc.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ";

    public RelatorioOrcamento() {
        this.setName("RelatorioOrcamento");
        this.montaBarraDescricao("Relat\u00f3rio de or\u00e7amentos", "Listagem dos or\u00e7amentos solicitados no per\u00edodo", "relatorios/rel_orcamento_solicitado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("filtroOrdem", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioOrcamento.getModuloConfigurar());
        this.setModuloAcesso(RelatorioOrcamento.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        String layout = null;
        try {
            layout = this.getLayoutRelatorio();
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar layout", e1.getStackTrace());
            return;
        }
        if (Funcoes.textoVazio(layout)) {
            Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
            return;
        }
        try {
            String[] usuario;
            this.setCursor(Cursor.getPredefinedCursor(3));
            Statement st = Conexao.getStatement();
            Statement stTemp = Conexao.getStatement();
            HashMap<String, String> camposUtilizados = new HashMap<String, String>();
            camposUtilizados.put("codigoRequisicao", "a.req_codigo");
            camposUtilizados.put("dataRequisicao", "a.req_data");
            camposUtilizados.put("codigoPaciente", "paciente.pac_codigo");
            camposUtilizados.put("nomePaciente", "paciente.pac_nome");
            camposUtilizados.put("nomeSocialPaciente", "pacienteorcamento.pac_nomesocial");
            camposUtilizados.put("codigoConvenioRequisicao", "conreq.con_codigo");
            camposUtilizados.put("razaoSocialConvenioRequisicao", "conreq.con_razao");
            camposUtilizados.put("fantasiaConvenioRequisicao", "conreq.con_fantasia");
            camposUtilizados.put("codigosConveniosOrcamento", "array_agg(orccon.con_codigo)");
            camposUtilizados.put("fantasiasConveniosOrcamento", "array_agg(convenioorcamento.con_fantasia)");
            camposUtilizados.putAll(Constantes.MAPA_SELECT_FILIAL);
            camposUtilizados.put("codigoOrcamento", "orc.orc_codigo");
            camposUtilizados.put("dataHoraOrcamento", "orc.orc_datahora");
            camposUtilizados.put("observacaoOrcamento", "orc.orc_observacao");
            camposUtilizados.put("percentualDescontoOrcamento", "orc.orc_percentualdesconto");
            camposUtilizados.put("valorDescontoOrcamento", "orc.orc_valordesconto");
            camposUtilizados.put("validadeOrcamento", "orc.orc_validade");
            camposUtilizados.put("solicitanteOrcamento", "orc.orc_solicitante");
            camposUtilizados.put("contatoOrcamento", "orc.orc_contato");
            camposUtilizados.put("emailOrcamento", "orc.orc_email");
            camposUtilizados.put("proprietarioOrcamento", "orc.orc_proprietario");
            camposUtilizados.put("percentualAcrescimoOrcamento", "orc.orc_percentualacrescimo");
            camposUtilizados.put("valorAcrescimoOrcamento", "orc.orc_valoracrescimo");
            camposUtilizados.put("dataAprovadoOrcamento", "orc.orc_dataaprovado");
            camposUtilizados.put("aprovadoPorOrcamento", "orc.orc_aprovadopor");
            camposUtilizados.put("foneOrcamento", "orc.orc_fone");
            camposUtilizados.put("foneContatoOrcamento", "orc.orc_fonecontato");
            camposUtilizados.put("codigoUsuarioOrcamento", "orc.usr_codigo");
            camposUtilizados.put("nomeUsuarioOrcamento", "usrorcamento.usr_nome");
            camposUtilizados.put("nomePacienteOrcamento", "pacienteorcamento.pac_nome");
            camposUtilizados.put("codigoPacienteOrcamento", "orc.pac_codigo");
            camposUtilizados.put("codigoUsuarioAprovadoOrcamento", "orc.usr_codaprovado");
            camposUtilizados.put("nomeUsuarioAprovadoOrcamento", "usraprovado.usr_nome");
            camposUtilizados.put("codigosExamesRequisicao", "''");
            camposUtilizados.put("totalTaxasOrcamento", "''");
            camposUtilizados.put("descricoesTaxasOrcamento", "''");
            MAPA_TODOS_CAMPOS_DISPONIVEIS = camposUtilizados;
            StringBuilder sqlLigacao = new StringBuilder();
            sqlLigacao.append(" from orcamento orc ");
            sqlLigacao.append(" left join paciente on orc.fil_codigo = paciente.fil_codigo and orc.pac_codigo = paciente.pac_codigo ");
            sqlLigacao.append(" left join convenios convenio on paciente.fil_codigo = convenio.fil_codigo and paciente.con_codigo = convenio.con_codigo ");
            sqlLigacao.append(" left join usuario usrorcamento on orc.usr_codigo = usrorcamento.usr_codigo ");
            sqlLigacao.append(" left join usuario usraprovado on orc.usr_codaprovado = usraprovado.usr_codigo ");
            sqlLigacao.append(" left join paciente pacienteorcamento on orc.fil_codigo = pacienteorcamento.fil_codigo and orc.pac_codigo = pacienteorcamento.pac_codigo ");
            sqlLigacao.append(" left join orcamentoconvenio orccon on orc.fil_codigo = orccon.fil_codigo and orc.orc_codigo = orccon.orc_codigo ");
            sqlLigacao.append(" left join convenios convenioorcamento on orccon.fil_codigo = convenioorcamento.fil_codigo and orccon.con_codigo = convenioorcamento.con_codigo ");
            sqlLigacao.append(JOIN_FILIAL);
            sqlLigacao.append(" left join requisicao a on a.fil_codigo = orc.fil_codigo and a.orc_codigo = orc.orc_codigo ");
            sqlLigacao.append(" left join convenios conreq on a.fil_codigo = conreq.fil_codigo and a.con_codigo = conreq.con_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            sqlLigacao.append("where orc.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                sqlLigacao.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(") ");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                sqlLigacao.append("  and cast(orc.orc_datahora as date) >= '");
                sqlLigacao.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                sqlLigacao.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                sqlLigacao.append("  and cast(orc.orc_datahora as date) <= '");
                sqlLigacao.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                sqlLigacao.append("'");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                sqlLigacao.append(" and orc.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    sqlLigacao.append("'");
                    sqlLigacao.append(usuario[i]);
                    sqlLigacao.append("'");
                    if (i >= usuario.length - 1) continue;
                    sqlLigacao.append(", ");
                }
                sqlLigacao.append(")");
            }
            HashMap<String, String> camposObrigatorios = new HashMap<String, String>();
            camposObrigatorios.put("codigoFilial", "filial.fil_codigo");
            camposObrigatorios.put("codigoRequisicao", "a.req_codigo");
            camposObrigatorios.put("codigoConvenio", "convenio.con_codigo");
            camposObrigatorios.put("codigoOrcamento", "orc.orc_codigo");
            camposObrigatorios.put("dataHoraOrcamento", "orc.orc_datahora");
            camposObrigatorios.put("nomePacienteOrcamento", "pacienteorcamento.pac_nome");
            camposUtilizados = Relatorio.getCamposBancoLayout(layout, MAPA_TODOS_CAMPOS_DISPONIVEIS, camposObrigatorios);
            sqlLigacao.append(" group by ").append(RelatorioOrcamento.getFieldsGroupBy(camposUtilizados));
            sqlLigacao.append(" order by ");
            String ord = this.getFiltroCombo("filtroOrdem").toString();
            if (ord.equals(this.ordem[0])) {
                sqlLigacao.append(" orc.orc_codigo ");
            } else if (ord.equals(this.ordem[1])) {
                sqlLigacao.append(" orc.orc_datahora ");
            } else {
                sqlLigacao.append(" pacienteorcamento.pac_nome ");
            }
            LIGACOES = sqlLigacao.toString();
            StringBuilder sqlFinal = new StringBuilder();
            sqlFinal.append(" select ");
            sqlFinal.append(Relatorio.getFieldsSelect(camposUtilizados));
            sqlFinal.append(LIGACOES);
            ResultSet rs = Conexao.executeQuery(st, sqlFinal.toString());
            if (rs.next()) {
                String[] listaCamposUtilizados = new String[camposUtilizados.size()];
                Iterator<String> it = camposUtilizados.keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    listaCamposUtilizados[i] = it.next().toString();
                    ++i;
                }
                ModeloGridTable modelo = new ModeloGridTable(listaCamposUtilizados);
                do {
                    Object[] o = new Object[listaCamposUtilizados.length];
                    for (int i2 = 0; i2 < listaCamposUtilizados.length; ++i2) {
                        Object respostasRequisicao = null;
                        if (listaCamposUtilizados[i2].equalsIgnoreCase("fantasiasConveniosOrcamento")) {
                            o[i2] = this.colunaExiste(rs, listaCamposUtilizados[i2]) ? rs.getObject(listaCamposUtilizados[i2]).toString().replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "") : null;
                            continue;
                        }
                        if (listaCamposUtilizados[i2].equalsIgnoreCase("codigosConveniosOrcamento")) {
                            o[i2] = this.colunaExiste(rs, listaCamposUtilizados[i2]) ? rs.getObject(listaCamposUtilizados[i2]).toString().replaceAll("\\{", "").replaceAll("\\}", "") : null;
                            continue;
                        }
                        if (listaCamposUtilizados[i2].equalsIgnoreCase("codigosExamesRequisicao")) {
                            o[i2] = BDUtil.getCodigoExames(rs.getString("codigofilial"), rs.getString("codigoRequisicao"), stTemp);
                            continue;
                        }
                        if (listaCamposUtilizados[i2].equalsIgnoreCase("totalTaxasOrcamento")) {
                            BigDecimal x = this.getTotalTaxas(rs.getString("codigofilial"), rs.getString("codigoOrcamento"), stTemp);
                            o[i2] = x;
                            continue;
                        }
                        o[i2] = listaCamposUtilizados[i2].equalsIgnoreCase("descricoesTaxasOrcamento") ? this.getDescricoesTaxas(rs.getString("codigofilial"), rs.getString("codigoOrcamento"), stTemp) : (this.colunaExiste(rs, listaCamposUtilizados[i2]) ? rs.getObject(listaCamposUtilizados[i2]) : null);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (!Funcoes.textoVazio(layout)) {
                    int i3;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioOrcamento.this.panelCentro.removeAll();
                            RelatorioOrcamento.this.panelCentro.repaint();
                            RelatorioOrcamento.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    StringBuilder buf = new StringBuilder();
                    for (i3 = 0; i3 < filiais.length; ++i3) {
                        buf.append(filiais[i3]);
                        if (i3 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.setLength(0);
                    if (usuario != null) {
                        for (i3 = 0; i3 < usuario.length; ++i3) {
                            buf.append(usuario[i3]);
                            if (i3 >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroUsuario", buf.toString());
                    gerador.executar(layout, (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                } else if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private BigDecimal getTotalTaxas(String filial, String orcamento, Statement st) throws SQLException {
        BigDecimal retorno = new BigDecimal("0");
        StringBuilder buf = new StringBuilder("select sum(ota_valor * coalesce(ota_quantidade, 1)) from orcamentotaxa ");
        buf.append("where fil_codigo = ").append(filial);
        buf.append("  and orc_codigo = ").append(orcamento);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = rs.getBigDecimal(1);
        }
        rs.close();
        return retorno;
    }

    private String getDescricoesTaxas(String filial, String orcamento, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder("select b.tax_descricao from orcamentotaxa a ");
        buf.append("left join taxa b on a.fil_codigo = b.fil_codigo and a.tax_codigo = b.tax_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append("  and a.orc_codigo = ").append(orcamento);
        buf.append(" order by 1 ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        buf.setLength(0);
        while (rs.next()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(rs.getString(1));
        }
        rs.close();
        return buf.toString();
    }

    private String getLayoutRelatorio() throws SQLException {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(RelatorioOrcamento.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            layout = rs.getString("rel_xml");
        }
        return layout;
    }

    private boolean colunaExiste(ResultSet rs, String campo) {
        try {
            return rs.findColumn(campo) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0823900100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0823900101");
    }

    public static String getFieldsGroupBy(HashMap<String, String> campos) {
        if (campos == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean isPrimeiroItem = true;
        for (String campo : campos.keySet()) {
            if (Funcoes.textoVazio(campos.get(campo)) || campos.get(campo).indexOf("''") > -1 || campos.get(campo).toLowerCase().indexOf("array_agg") > -1) continue;
            if (!isPrimeiroItem) {
                buf.append(", ");
            } else {
                isPrimeiroItem = false;
            }
            buf.append(campos.get(campo));
        }
        return buf.toString();
    }
}

