/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class RelatorioLancamentosPorRequisicao
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Nome Paciente", "Conv\u00eanio", "M\u00e9dico", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Esta\u00e7\u00e3o + Usu\u00e1rio"};
    private static final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P")};
    private static final String[] filtrarPorData = new String[]{"Dt. lan\u00e7amento", "Dt. requisi\u00e7\u00e3o"};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_ESTACAO = "filtroEstacao";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_CONTA_CORRENTE = "filtroContaCorrente";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_SITUACAO_CADASTRO = "filtroSituacaoRequisicao";
    private static final String FILTRO_FILTRAR_POR_DATA = "filtrarPorData";
    private static final String FILTRO_OCULTAR_CANCELADOS = "filtroOcultarCancelados";
    private static final String FILTRO_QUEBRA_POR_REQUISICAO = "filtroQuebraPorRequisicao";
    private static int CAMPO_FILTRO_DATA = 0;
    public static final int DATA_LANCAMENTO = 0;
    public static final int DATA_REQUISICAO = 1;
    private static final long ACESSO_FILTRARESTACAO = Long.parseLong("0821100102");
    private static final long ACESSO_FILTRARCOLETA = Long.parseLong("0821100103");
    private static final long ACESSO_FILTRARDESTINO = Long.parseLong("0821100104");
    private static final long ACESSO_FILTRARUSUARIO = Long.parseLong("0821100105");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "prontuarioRequisicao", "complementoDestinoRequisicao", "tipoUltimoPagamentoRequisicao", "quartoRequisicao", "leitoRequisicao", "codigoPaciente", "totalPaciente", "nomePaciente", "nomeSocialPaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairrodestino", "descricaoBairrodestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "percentualAcrescimoConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoEstacao", "descricaoEstacao", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoMedico", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroMedico", "generoPaciente", "codigoLanctoCaixa", "tipoLanctoCaixa", "dataHoraLanctoCaixa", "valorLanctoCaixa", "bancoLanctoCaixa", "agenciaLanctoCaixa", "documentoLanctoCaixa", "obsLanctoCaixa", "tipoDocumentoLanctoCaixa", "tipoPagamentoLanctoCaixa", "numeroChequeLanctoCaixa", "validadeCartaoLanctoCaixa", "numeroCartaoLanctoCaixa", "cartaoCreditoLanctoCaixa", "contaLanctoCaixa", "conciliacaoLanctoCaixa", "vencimentoLanctoCaixa", "competenciaLanctoCaixa", "dataCanceladoLanctoCaixa", "descricaoCanceladoLanctoCaixa", "valorTotalLanctoCaixa", "situacaoLanctoCaixa", "codigoUsuarioLanctoCaixa", "tipoJuroLanctoCaixa", "tipoOrigemLanctoCaixa", "descricaoHistoricoLanctoCaixa", "sacadoLanctoCaixa", "nomeUsuarioCancelouLcx", "nomeUsuarioLancouLcx", "descricaoMotivoCancelamento", "descricaoHistoricoPadrao", "DescricaoContaCorrente", "titularContaCorrente", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "motivoExclusao", "totalTaxaRequisicao"});

    public RelatorioLancamentosPorRequisicao() {
        this.setName("RelatorioLancamentosPorRequisicao");
        this.montaBarraDescricao("Relat\u00f3rio de lan\u00e7amentos por requisi\u00e7\u00e3o", "Listagem dos lan\u00e7amentos de caixa por requisi\u00e7\u00e3o", "relatorios/rel_lancamento_requisicao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (Acesso.getAcesso(ACESSO_FILTRARESTACAO)) {
            this.adicionaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARUSUARIO)) {
            this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARDESTINO)) {
            this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        if (Acesso.getAcesso(ACESSO_FILTRARCOLETA)) {
            this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro(FILTRO_SITUACAO_CADASTRO, "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Empresa", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        }
        this.adicionaItemFiltro(FILTRO_CONTA_CORRENTE, "Conta Corrente", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "cco_titular"}, new String[]{"C\u00f3digo", "Conta", "Titular"}, new int[]{70, 0, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCombo(FILTRO_FILTRAR_POR_DATA, "Filtra por:", filtrarPorData, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.adicionaFiltroCheck(FILTRO_OCULTAR_CANCELADOS, "Ocultar cancelados", false);
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_QUEBRA_POR_REQUISICAO, "Quebra por requisi\u00e7\u00e3o", false);
        this.setModuloConfigurar(RelatorioLancamentosPorRequisicao.getModuloConfigurar());
        this.setModuloAcesso(RelatorioLancamentosPorRequisicao.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            String[] estacao = this.getSelecionadosFiltro(FILTRO_ESTACAO, 0);
            String[] usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
            String[] destino = this.getSelecionadosFiltro(FILTRO_DESTINO, 0);
            String[] coleta = this.getSelecionadosFiltro(FILTRO_COLETA, 0);
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            String[] conselho = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0);
            String[] crm = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1);
            String[] uf = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2);
            String[] situacao = this.getSelecionadosFiltro(FILTRO_SITUACAO_CADASTRO, 0);
            String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
            String horaInicial = this.getFiltroHora(FILTRO_HORA_INICIAL);
            String horaFinal = this.getFiltroHora(FILTRO_HORA_FINAL);
            boolean intervaloHora = this.getFiltroCheck(FILTRO_INTERVALO_HORA);
            boolean filtrarCancelados = this.getFiltroCheck(FILTRO_OCULTAR_CANCELADOS);
            boolean quebraPorRequisicao = this.getFiltroCheck(FILTRO_QUEBRA_POR_REQUISICAO);
            String[] paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0);
            String[] contaCorrente = this.getSelecionadosFiltro(FILTRO_CONTA_CORRENTE, 0);
            this.getFiltroComboIndice(FILTRO_FILTRAR_POR_DATA);
            if (intervaloHora && (Funcoes.textoVazio(dataInicial) || Funcoes.textoVazio(horaInicial) || Funcoes.textoVazio(dataFinal) || Funcoes.textoVazio(horaFinal))) {
                Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos!", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String sql = RelatorioLancamentosPorRequisicao.getSelect(filiais, "", RelatorioLancamentosPorRequisicao.getCampoFiltroData(this.getFiltroComboIndice(FILTRO_FILTRAR_POR_DATA)), estacao, usuario, destino, coleta, null, convenio, conselho, crm, uf, situacao, paciente, contaCorrente, dataInicial, dataFinal, horaInicial, horaFinal, this.getFiltroCombo(FILTRO_ORDEM).toString(), filtrarCancelados, intervaloHora, quebraPorRequisicao);
            this.imprimirRelatorio(this, this.panelCentro, sql, filiais, estacao, usuario, destino, coleta, null, convenio, conselho, crm, uf, situacao, paciente, contaCorrente, dataInicial, dataFinal, horaInicial, horaFinal, this.getFiltroCombo(FILTRO_ORDEM).toString(), filtrarCancelados, quebraPorRequisicao, new Runnable(){

                @Override
                public void run() {
                    RelatorioLancamentosPorRequisicao.this.panelCentro.removeAll();
                    RelatorioLancamentosPorRequisicao.this.panelCentro.repaint();
                    RelatorioLancamentosPorRequisicao.this.habilitaBotaoImprimir(true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    RelatorioLancamentosPorRequisicao.this.habilitaBotaoImprimir(true);
                }
            });
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void imprimirRelatorio(Component pai, JPanel panel, String sql, String[] filiais, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] cids, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] situacao, String[] pacientes, String[] contaCorrente, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String ordemSelecionada, boolean filtrarCancelados, boolean quebraPorRequisicao, Runnable acaoFechar, Runnable acaoFimRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            ModeloGridTable modelo = new ModeloGridTable(campos);
            Integer paciente = 0;
            BigDecimal totalPaciente = new BigDecimal(0);
            do {
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    if (RelatorioUtil.possuiColuna(rs, campos[i]) < 0) continue;
                    if (campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                        o[i] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoMedico")) {
                        o[i] = Tipos.tipoMedico(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("anomesIdadeRequisicao") || campos[i].equals("anomesIdadePaciente")) {
                        o[i] = Tipos.tipoIdade(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("sexoPaciente") || campos[i].equals("sexoExame")) {
                        o[i] = Tipos.tipoSexo(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("corPaciente")) {
                        o[i] = Tipos.tipoCor(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("fumantePaciente")) {
                        o[i] = Tipos.tipoFumanteDiabetico(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("diabeticoPaciente")) {
                        o[i] = Tipos.tipoFumanteDiabetico(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("estadoCivilPaciente")) {
                        o[i] = Tipos.tipoEstadoCivil(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoPagamentoConvenio")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoCalculoFaturaConvenio")) {
                        o[i] = Tipos.tipoCalculoFatura(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("titularDependenteConvenio")) {
                        o[i] = Tipos.tipoTitularDependente(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoCalculoCHConvenio")) {
                        o[i] = Tipos.tipoCalculoCH(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoUltimoPagamentoRequisicao")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoPagamentoLanctoCaixa")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("situacaoLanctoCaixa")) {
                        o[i] = Tipos.tipoSituacaoLancamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoLanctoCaixa")) {
                        o[i] = Tipos.tipoLancamentoCaixa(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoDocumentoLanctoCaixa")) {
                        o[i] = Tipos.tipoDocumento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoOrigemLanctoCaixa")) {
                        o[i] = Tipos.tipoOrigemLancamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("codigoPaciente")) {
                        o[i] = rs.getObject(campos[i]);
                        paciente = rs.getInt(campos[i]);
                        continue;
                    }
                    if (campos[i].equals("totalPaciente") && quebraPorRequisicao) {
                        totalPaciente = paciente.intValue() != rs.getInt("codigoPaciente") ? new BigDecimal(rs.getDouble("totalRequisicao")).setScale(2, RoundingMode.HALF_UP) : totalPaciente.add(rs.getBigDecimal("totalRequisicao")).setScale(2, RoundingMode.HALF_UP);
                        o[i] = totalPaciente;
                        continue;
                    }
                    o[i] = rs.getObject(campos[i]);
                }
                modelo.addLine(o);
            } while (rs.next());
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioLancamentosPorRequisicao.getModuloAcesso());
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i;
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(panel);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                if (acaoFechar != null) {
                    gerador.setAcaoFechar(acaoFechar);
                }
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put(FILTRO_ORDEM, ordemSelecionada);
                var.put(FILTRO_FILTRAR_POR_DATA, this.getFiltroCombo(FILTRO_FILTRAR_POR_DATA).toString());
                var.put(FILTRO_OCULTAR_CANCELADOS, filtrarCancelados);
                var.put(FILTRO_DATA_INICIAL, dataInicial);
                var.put(FILTRO_DATA_FINAL, dataFinal);
                var.put(FILTRO_HORA_INICIAL, horaInicial);
                var.put(FILTRO_HORA_FINAL, horaFinal);
                var.put(FILTRO_QUEBRA_POR_REQUISICAO, quebraPorRequisicao);
                buf.delete(0, buf.length());
                if (estacoes != null) {
                    for (i = 0; i < estacoes.length; ++i) {
                        buf.append(estacoes[i]);
                        if (i >= estacoes.length - 1) continue;
                        buf.append(", ");
                    }
                } else if (!Acesso.getAcesso(ACESSO_FILTRARESTACAO)) {
                    buf.append(Variaveis.codigoEstacao);
                }
                var.put(FILTRO_ESTACAO, buf.toString());
                buf.delete(0, buf.length());
                if (usuarios != null) {
                    for (i = 0; i < usuarios.length; ++i) {
                        buf.append(usuarios[i]);
                        if (i >= usuarios.length - 1) continue;
                        buf.append(", ");
                    }
                } else if (!Acesso.getAcesso(ACESSO_FILTRARUSUARIO)) {
                    buf.append(Variaveis.login);
                }
                var.put(FILTRO_USUARIO, buf.toString());
                buf.delete(0, buf.length());
                if (destinos != null) {
                    for (i = 0; i < destinos.length; ++i) {
                        buf.append(destinos[i]);
                        if (i >= destinos.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_DESTINO, buf.toString());
                buf.delete(0, buf.length());
                if (coletas != null) {
                    for (i = 0; i < coletas.length; ++i) {
                        buf.append(coletas[i]);
                        if (i >= coletas.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_COLETA, buf.toString());
                buf.delete(0, buf.length());
                if (convenios != null) {
                    for (i = 0; i < convenios.length; ++i) {
                        buf.append(convenios[i]);
                        if (i >= convenios.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_CONVENIO, buf.toString());
                buf.delete(0, buf.length());
                if (pacientes != null) {
                    for (i = 0; i < pacientes.length; ++i) {
                        buf.append(pacientes[i]);
                        if (i >= pacientes.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_PACIENTE, buf.toString());
                buf.delete(0, buf.length());
                if (contaCorrente != null) {
                    for (i = 0; i < contaCorrente.length; ++i) {
                        buf.append(contaCorrente[i]);
                        if (i >= contaCorrente.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_CONTA_CORRENTE, buf.toString());
                buf.delete(0, buf.length());
                if (medicosCrm != null && medicosUF != null) {
                    for (i = 0; i < medicosCrm.length; ++i) {
                        buf.append(medicosConselho[i]).append(": ");
                        buf.append(medicosCrm[i]);
                        buf.append("(");
                        buf.append(medicosUF[i]);
                        buf.append(")");
                        if (i >= medicosCrm.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_MEDICO, buf.toString());
                buf.delete(0, buf.length());
                if (situacao != null) {
                    for (i = 0; i < situacao.length; ++i) {
                        buf.append(situacao[i]);
                        if (i >= situacao.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_SITUACAO_CADASTRO, buf.toString());
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                panel.revalidate();
            }
        } else {
            Funcoes.mensagem(pai, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            if (acaoFimRelatorio != null) {
                acaoFimRelatorio.run();
            }
        }
        Conexao.fecharStatement(st, st2);
    }

    private static String getSelect(String[] filiais, String whereAdicional, String filtrarPorData, String[] estacoes, String[] usuarios, String[] destinos, String[] coletas, String[] cids, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] situacoes, String[] pacientes, String[] contaCorrente, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String ordemSelecionada, boolean filtrarCancelados, Boolean intervaloHora, boolean quebraPorRequisicao) {
        String quebrarRequisicao;
        int i;
        StringBuilder buf = new StringBuilder("select ");
        buf.append("a.req_codigo as codigoRequisicao, ");
        buf.append("a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, ");
        buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao,  a.req_totaltaxa as totalTaxaRequisicao, ");
        buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, ");
        buf.append("a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
        buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao,  ");
        buf.append("a.req_titular as titularRequisicao, a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao,  ");
        buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
        buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
        buf.append("a.req_telacoleta as coletadoRequisicao, a.req_datarequisicao as dataAberturaRequisicao, ");
        buf.append("a.req_neonato as neonatoRequisicao, a.req_validadeguia as validadeGuiaRequisicao,  ");
        buf.append("a.req_guia as guiaRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        buf.append("a.req_complementodestino as complementoDestinoRequisicao, a.req_motivoExclusao as motivoExclusao,");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, ");
        buf.append("lcx.lcx_codigo as codigoLanctoCaixa, ");
        buf.append("lcx.lcx_tipo as tipoLanctoCaixa, ");
        buf.append("lcx.lcx_datahora as DataHoraLanctoCaixa, ");
        buf.append("(case when lcx.lcx_tipo = 'C' then lcx.lcx_valor else lcx.lcx_valor*-1 end) as valorLanctoCaixa, ");
        buf.append("lcx.lcx_banco as bancoLanctoCaixa, ");
        buf.append("lcx.lcx_agencia as agenciaLanctoCaixa, ");
        buf.append("lcx.lcx_documento as documentoLanctoCaixa, ");
        buf.append("lcx.lcx_obs as obsLanctoCaixa, ");
        buf.append("lcx.lcx_tipodocumento as tipoDocumentoLanctoCaixa, ");
        buf.append("lcx.lcx_tipopagamento as tipoPagamentoLanctoCaixa, ");
        buf.append("lcx.lcx_nrcheque as numeroChequeLanctoCaixa, ");
        buf.append("lcx.lcx_validadecartao as validadeCartaoLanctoCaixa, ");
        buf.append("lcx.lcx_nrcartao as numeroCartaoLanctoCaixa, ");
        buf.append("lcx.lcx_cartaocredito as cartaoCreditoLanctoCaixa, ");
        buf.append("lcx.lcx_conta as contaLanctoCaixa, ");
        buf.append("lcx.lcx_conciliacao as conciliacaoLanctoCaixa, ");
        buf.append("lcx.lcx_vencimento as vencimentoLanctoCaixa, ");
        buf.append("lcx.lcx_competencia as competenciaLanctoCaixa, ");
        buf.append("lcx.lcx_datacancelado as dataCanceladoLanctoCaixa, ");
        buf.append("lcx.lcx_descricaocancelado as descricaoCanceladoLanctoCaixa, ");
        buf.append("lcx.lcx_valortotal as valorTotalLanctoCaixa, ");
        buf.append("lcx.lcx_situacao as situacaoLanctoCaixa, ");
        buf.append("lcx.lcx_tipojuro as tipoJuroLanctoCaixa, ");
        buf.append("lcx.lcx_tipoorigem as tipoOrigemLanctoCaixa, ");
        buf.append("lcx.lcx_descricaohistorico as descricaoHistoricoLanctoCaixa, ");
        buf.append("lcx.lcx_sacado as sacadoLanctoCaixa, ");
        buf.append("lcx.est_codigo as codigoEstacaoLanctoCaixa, ");
        buf.append("lcx.mov_codigo as codigoMotivoCancelamentoLanctoCaixa, ");
        buf.append("lcx.hpa_codigo as historicoPadraoLanctoCaixa, ");
        buf.append("lcx.usr_codigo as codigoUsuarioLanctoCaixa, ");
        buf.append("lcx.cco_reduzido as codigoContaLanctoCaixa, ");
        buf.append("usrcanlcx.usr_nome as nomeUsuarioCancelouLcx, ");
        buf.append("usrlanct.usr_nome as nomeUsuarioLancouLcx, ");
        buf.append("mov.mov_descricao as descricaoMotivoCancelamento, ");
        buf.append("hpa.hpa_descricao as descricaoHistoricoPadrao, ");
        buf.append("cco.cco_conta as DescricaoContaCorrente, ");
        buf.append("cco.cco_titular as titularContaCorrente, ");
        buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, ");
        buf.append("paciente.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("paciente.pac_vip as vipPaciente, paciente.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append("paciente.pac_fatorrh as fatorrhPaciente, paciente.pac_fatordu as fatorduPaciente, ");
        buf.append("paciente.pac_cor as corPaciente, paciente.pac_observ as observacaoPaciente, ");
        buf.append("paciente.pac_dadoclinico as dadosClinicosPaciente, paciente.pac_peso as pesoPaciente, ");
        buf.append("paciente.pac_altura as alturaPaciente, paciente.pac_matricconv as matriculaConvenioPaciente, ");
        buf.append("paciente.pac_titularconv as titularConvenioPaciente, paciente.pac_profissao as profissaoPaciente, ");
        buf.append("paciente.pac_fumante as fumantePaciente, paciente.pac_diabetico as diabeticoPaciente, ");
        buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
        buf.append("paciente.pac_estcivil as estadoCivilPaciente, paciente.pac_numfilho as numeroFilhosPaciente, ");
        buf.append("paciente.pac_datahora as dataHoraCadastroPaciente, paciente.pac_dum as dumPaciente, ");
        buf.append("paciente.pac_fax as faxPaciente, paciente.pac_celular as celularPaciente, ");
        buf.append("paciente.pac_fonecomercial as foneComercialPaciente, paciente.pac_fone as fonePaciente, ");
        buf.append("paciente.pac_cep as cepPaciente, paciente.pac_complemento as complementoPaciente, ");
        buf.append("paciente.pac_endereco as enderecoPaciente, paciente.pac_numeroendereco as numeroEnderecoPaciente, paciente.pac_email as emailPaciente, ");
        buf.append("paciente.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
        buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
        buf.append("paciente.pac_fonecontato as foneContatoPaciente, paciente.pac_nomecontato as contatoPaciente, ");
        buf.append("paciente.pac_mae as maePaciente, paciente.pac_pai as paiPaciente, ");
        buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
        buf.append("cidpaciente.cid_uf as estadoCidadePaciente, 0 as totalPaciente, ");
        buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
        buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
        buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
        buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino,  ");
        buf.append("destino.des_impressora as impressoraDestino, destino.des_naoimprimir as naoImprimirDestino,  ");
        buf.append("destino.des_cep as cepDestino, destino.des_complemento as complementoDestino, ");
        buf.append("destino.des_endereco as enderecoDestino, destino.des_fone as foneDestino, ");
        buf.append("destino.des_enviarweb as enviarWebDestino,  ");
        buf.append("ciddestino.cid_codigo as codigoCidadeDestino, ciddestino.cid_nome as descricaoCidadeDestino, ");
        buf.append("ciddestino.cid_uf as estadoCidadeDestino, ");
        buf.append("baidestino.bai_codigo as codigoBairroDestino, baidestino.bai_descricao as descricaoBairroDestino, ");
        buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
        buf.append("coleta.col_cep as cepColeta, coleta.col_complemento as complementoColeta, ");
        buf.append("coleta.col_endereco as enderecoColeta, coleta.col_fone as foneColeta, ");
        buf.append("cidcoleta.cid_codigo as codigoCidadeColeta, cidcoleta.cid_nome as descricaoCidadeColeta, ");
        buf.append("cidcoleta.cid_uf as estadoCidadeColeta, ");
        buf.append("baicoleta.bai_codigo as codigoBairroColeta, baicoleta.bai_descricao as descricaoBairroColeta, ");
        buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
        buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
        buf.append("convenio.con_tppgto as tipoPagamentoConvenio, ");
        buf.append("convenio.con_fatfmaterial as faturarFaltaMaterialConvenio, convenio.con_descexame as habilitarDescontoConvenio,  ");
        buf.append("convenio.con_multa as multaConvenio, ");
        buf.append("convenio.con_mora as moraConvenio, convenio.con_fatfiliais as faturarFiliaisConvenio, ");
        buf.append("convenio.con_nr1via as quantidade1ViaConvenio, convenio.con_nrexames as numeroExamesConvenio,  ");
        buf.append("convenio.con_viasfatura as viasFaturaConvenio, convenio.con_impbloqueto as imprimirBloquetoConvenio,  ");
        buf.append("convenio.con_nr2via as quantidade2ViaConvenio, convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio,  ");
        buf.append("coalesce(convenio.con_percpgto, 0) as percentualBalcaoConvenio, convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
        buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, convenio.con_titdep as titularDependenteConvenio, ");
        buf.append("convenio.con_maskcart as mascaraCarteiraConvenio, convenio.con_contato as contatoConvenio, ");
        buf.append("convenio.con_informarmat as obrigaMatriculaConvenio, convenio.con_cep as cepConvenio,  ");
        buf.append("convenio.con_complemento as complementoConvenio, convenio.con_endereco as enderecoConvenio,  ");
        buf.append("convenio.con_numeroendereco as numeroEnderecoConvenio, convenio.con_tipologradouroendereco as tipoLogradouroConvenio, ");
        buf.append("convenio.con_cepcobranca as cepCobrancaConvenio, convenio.con_complcobranca as complementoCobrancaConvenio,  ");
        buf.append("convenio.con_endcobranca as enderecoCobrancaConvenio, convenio.con_fax as faxConvenio, ");
        buf.append("convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, convenio.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
        buf.append("convenio.con_fone as foneConvenio, convenio.con_valorfilme as valorFilmeConvenio,  ");
        buf.append("convenio.con_valorch as valorCHConvenio, convenio.con_site as siteConvenio, ");
        buf.append("convenio.con_email2 as email2Convenio, convenio.con_email1 as email1Convenio,  ");
        buf.append("convenio.con_tpcalcch as tipoCalculoCHConvenio, convenio.con_inscmunic as inscricaoMunicipalConvenio,  ");
        buf.append("convenio.con_bonus as percentualBonusConvenio, convenio.con_senhaweb as senhaWebConvenio,  ");
        buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
        buf.append("convenio.con_proibidoweb as proibidoWebConvenio, convenio.con_validadeguia as obrigaValidadeGuiaConvenio,  ");
        buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, convenio.con_diasvalidade as diasValidadeGuia,  ");
        buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
        buf.append("cidconvenio.cid_codigo as codigoCidadeConvenio, cidconvenio.cid_nome as descricaoCidadeConvenio,  ");
        buf.append("cidconvenio.cid_uf as estadoCidadeConvenio, ");
        buf.append("baiconvenio.bai_codigo as codigoBairroConvenio, baiconvenio.bai_descricao as descricaoBairroConvenio, ");
        buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
        buf.append("medico.med_abrev as abreviaturaMedico, ");
        buf.append("medico.med_tipo as tipoMedico,  ");
        buf.append("medico.med_comissao as comissaoMedico, medico.med_cep as cepMedico, medico.med_complemento as complementoMedico,  ");
        buf.append("medico.med_endereco as enderecoMedico, medico.med_celular as celularMedico, medico.med_fax as faxMedico,  ");
        buf.append("medico.med_numeroendereco as numeroEnderecoMedico, medico.med_tipologradouroendereco as tipoLogradouroMedico, ");
        buf.append("medico.med_fone as foneMedico, medico.med_email as emailMedico, medico.med_site as siteMedico, medico.med_senhaweb as senhaWebMedico, ");
        buf.append("cidmedico.cid_codigo as codigoCidadeMedico, cidmedico.cid_nome as descricaoCidadeMedico, cidmedico.cid_uf as estadoCidadeMedico,  ");
        buf.append("baimedico.bai_codigo as codigoBairroMedico, baimedico.bai_descricao as descricaoBairroMedico, ");
        buf.append("a.est_codigo as codigoEstacao, estacoes.est_descricao as descricaoEstacao, ");
        buf.append("a.req_prontuario as prontuarioRequisicao, ");
        buf.append("sit.sit_codigo as codigoSituacao, ");
        buf.append("sit.sit_descricao as descricaoSituacao, ");
        buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        buf.append("ent.ent_email as emailResponsavelRequisicao, ");
        buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
        buf.append("ent.ent_razaosocial as razaoSocialResponsavelRequisicao, ");
        buf.append("ent.ent_endereco as enderecoResponsavelRequisicao, ");
        buf.append("ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao, ");
        buf.append("ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao, ");
        buf.append("ent.ent_complemento as complementoResponsavelRequisicao, ");
        buf.append("ent.ent_cep as cepResponsavelRequisicao, ");
        buf.append("ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao, ");
        buf.append("cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao, ");
        buf.append("cidentidade.cid_uf as estadoCidadeResponsavelRequisicao, ");
        buf.append("baientidade.bai_descricao as descricaoBairroResponsavelRequisicao, ");
        buf.append("paciente.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        buf.append("paciente.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        buf.append("paciente.pac_razaosocial as razaoSocialPaciente, ");
        buf.append("paciente.pac_cnpj as cnpjPaciente, ");
        buf.append("paciente.pac_ie as inscricaoEstadualPaciente, ");
        buf.append("paciente.pac_proprietario as proprietarioPaciente, ");
        buf.append("paciente.pac_sif as sifPaciente, ");
        buf.append("paciente.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        buf.append("paciente.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        buf.append("paciente.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
        buf.append("paciente.pac_complementocobranca as complementoCobrancaPaciente, ");
        buf.append("paciente.pac_cepcobranca as cepCobrancaPaciente, ");
        buf.append("paciente.pac_fonecobranca as foneCobrancaPaciente, ");
        buf.append("paciente.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        buf.append("idg.ige_descricao as generoPaciente, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("from requisicao a ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append("join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
        buf.append("left join situacao sit on a.fil_codigo = sit.fil_codigo and a.sit_codigo = sit.sit_codigo ");
        buf.append("join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
        buf.append("left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
        buf.append("left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
        buf.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
        buf.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
        buf.append("left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
        buf.append("left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
        buf.append("left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
        buf.append("left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
        buf.append("left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
        buf.append("left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo  and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("left join cidades cidcobranca on paciente.fil_codigo = cidcobranca.fil_codigo and paciente.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on paciente.fil_codigo = baicobranca.fil_codigo and paciente.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        buf.append("left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        buf.append("left join requisicaolanctocaixa rlc on a.fil_codigo = rlc.fil_codigo  and  a.req_codigo  = rlc.req_codigo ");
        buf.append("left join lanctocaixa lcx on rlc.fil_codigo = lcx.fil_codigo  and  rlc.lcx_codigo = lcx.lcx_codigo ");
        buf.append("left join usuario usrcanlcx on lcx.fil_codigo = usrcanlcx.fil_codigo and lcx.usr_codcancelado = usrcanlcx.usr_codigo ");
        buf.append("left join usuario usrlanct on lcx.fil_codigo = usrlanct.fil_codigo  and lcx.usr_codigo = usrlanct.usr_codigo ");
        buf.append("left join motivoscancelamentos mov on lcx.fil_codigo = mov.fil_codigo and lcx.mov_codigo = mov.mov_codigo ");
        buf.append("left join historicopadrao hpa on lcx.fil_codigo = hpa.fil_codigo and lcx.hpa_codigo = hpa.hpa_codigo ");
        buf.append("left join contacorrente cco on lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido ");
        buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append("where a.fil_codigo in (");
        for (i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        if (!Funcoes.textoVazio(whereAdicional)) {
            buf.append(" and ").append(whereAdicional);
        }
        if (estacoes != null) {
            buf.append(" and a.est_codigo in (");
            for (i = 0; i < estacoes.length; ++i) {
                buf.append(estacoes[i]);
                if (i >= estacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        } else if (!Acesso.getAcesso(ACESSO_FILTRARESTACAO)) {
            buf.append(" and lcx.est_codigo = ");
            buf.append(Variaveis.codigoEstacao);
        }
        if (usuarios != null) {
            buf.append(" and lcx.usr_codigo in (");
            for (i = 0; i < usuarios.length; ++i) {
                buf.append("'");
                buf.append(usuarios[i]);
                buf.append("'");
                if (i >= usuarios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        } else if (!Acesso.getAcesso(ACESSO_FILTRARUSUARIO)) {
            buf.append(" and lcx.usr_codigo= '");
            buf.append(Variaveis.login);
            buf.append("'");
        }
        if (destinos != null) {
            buf.append(" and a.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (coletas != null) {
            buf.append(" and a.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (convenios != null) {
            buf.append(" and a.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (situacoes != null && situacoes.length > 0) {
            buf.append(" and a.sit_codigo in (");
            for (i = 0; i < situacoes.length; ++i) {
                buf.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (pacientes != null) {
            buf.append(" and a.pac_codigo in (");
            for (i = 0; i < pacientes.length; ++i) {
                buf.append(pacientes[i]);
                if (i >= pacientes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (contaCorrente != null) {
            buf.append(" and lcx.cco_reduzido in (");
            for (i = 0; i < contaCorrente.length; ++i) {
                buf.append(contaCorrente[i]);
                if (i >= contaCorrente.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (medicosCrm != null && medicosUF != null && medicosCrm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (i = 0; i < medicosCrm.length; ++i) {
                buf.append("(a.med_conselho = '");
                buf.append(medicosConselho[i]);
                buf.append("' and a.med_crm = '");
                buf.append(medicosCrm[i]);
                buf.append("' and a.med_uf = '");
                buf.append(medicosUF[i]);
                buf.append("')");
                if (i >= medicosCrm.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(")");
        }
        if (!intervaloHora.booleanValue()) {
            if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                buf.append(" and ").append(filtrarPorData).append(" >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                buf.append("'");
            }
            if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                buf.append(" and ").append(filtrarPorData).append(" <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                buf.append("'");
            }
            if (horaInicial != null && Funcoes.verificaHora(horaInicial)) {
                buf.append(" and ").append(RelatorioLancamentosPorRequisicao.getCampoFiltroHora(CAMPO_FILTRO_DATA)).append(" >= '");
                buf.append(horaInicial);
                buf.append("'");
            }
            if (horaFinal != null && Funcoes.verificaHora(horaFinal)) {
                buf.append(" and ").append(RelatorioLancamentosPorRequisicao.getCampoFiltroHora(CAMPO_FILTRO_DATA)).append(" <= '");
                buf.append(horaFinal);
                buf.append("'");
            }
        } else {
            buf.append(" and ((").append(filtrarPorData).append(" + ");
            buf.append(RelatorioLancamentosPorRequisicao.getCampoFiltroHora(CAMPO_FILTRO_DATA)).append(") >= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ");
            buf.append(horaInicial);
            buf.append("') and ((");
            buf.append(filtrarPorData).append(" + ");
            buf.append(RelatorioLancamentosPorRequisicao.getCampoFiltroHora(CAMPO_FILTRO_DATA)).append(") <= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ");
            buf.append(horaFinal);
            buf.append("')");
        }
        buf.append(" and a.req_excluida = false and lcx.lcx_codigo is not null ");
        if (filtrarCancelados) {
            buf.append(" and not (lcx.lcx_situacao = '").append("C").append("' or ");
            buf.append("(lcx.lcx_situacao = '").append("O").append("' and ");
            buf.append("lcx.lcx_tipoorigem = '").append("V").append("')) ");
        }
        buf.append(" order by ");
        if (ordemSelecionada != null && ordemSelecionada.equals(ordem[2])) {
            buf.append(" paciente.pac_nome, a.req_codigo, lcx.lcx_codigo ");
        }
        String string = quebrarRequisicao = quebraPorRequisicao ? " a.req_codigo, " : "";
        if (ordemSelecionada == null || ordemSelecionada.equals(ordem[0])) {
            buf.append("a.req_codigo, lcx.lcx_codigo ");
        } else if (ordemSelecionada.equals(ordem[1])) {
            buf.append(quebrarRequisicao).append(filtrarPorData);
        } else if (ordemSelecionada.equals(ordem[3])) {
            buf.append(quebrarRequisicao).append(" upper(convenio.con_fantasia) ,lcx.lcx_codigo ");
        } else if (ordemSelecionada.equals(ordem[4])) {
            buf.append(quebrarRequisicao).append(" upper(medico.med_nome) ,lcx.lcx_codigo");
        } else if (ordemSelecionada.equals(ordem[5])) {
            buf.append(quebrarRequisicao).append(" a.est_codigo , lcx.lcx_codigo");
        } else if (ordemSelecionada.equals(ordem[6])) {
            buf.append(quebrarRequisicao).append(" a.usr_codigo ,lcx.lcx_codigo");
        } else if (ordemSelecionada.equals(ordem[7])) {
            buf.append(quebrarRequisicao).append(" a.est_codigo, a.usr_codigo ,lcx.lcx_codigo");
        }
        return buf.toString();
    }

    private static String getCampoFiltroData(int tipoFiltroData) {
        String retorno;
        switch (tipoFiltroData) {
            case 0: {
                retorno = "cast( lcx.lcx_datahora as date)";
                break;
            }
            default: {
                retorno = "a.req_data";
            }
        }
        return retorno;
    }

    private static String getCampoFiltroHora(int campoDataFiltro) {
        String retorno;
        switch (campoDataFiltro) {
            case 0: {
                retorno = "cast( lcx.lcx_datahora as time)";
                break;
            }
            default: {
                retorno = "a.req_hora";
            }
        }
        return retorno;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0822600200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0822600201");
    }
}

