/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioExamesAgendados
extends FrmRelPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_SALA = "filtroSala";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_DATA_HORA_AGENDA = "filtroDataHoraAgenda";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    public static final int TIPO_AGENDAMENTO = 1;
    public static final int TIPO_AGENDAMENTO_COLETA = 2;
    private final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoSalaAtendimento", "descricaoSalaAtendimento", "codigoExame", "descricaoExame", "codigoMaterial", "abreviaturaMaterial", "descricaoMaterial", "qtdeExame", "dataAgenda", "valorTotalExameRequisicao"});

    public RelatorioExamesAgendados() {
        this.setName("RelatorioExamesAgendados");
        this.montaBarraDescricao("Relat\u00f3rio de exames agendados", "Listagem dos exames agendados", "relatorios/rel_agendamento_exame.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSala", "Sala", "salaatendimento", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sal_codigo", "sal_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.setModuloConfigurar(RelatorioExamesAgendados.getModuloConfigurar());
        this.setModuloAcesso(RelatorioExamesAgendados.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0823500300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0823500301");
    }

    @Override
    public void imprimirPressionado() {
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "A data inicial deve ser preenchida.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] exame;
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            StringBuilder buf = new StringBuilder(" SELECT ");
            buf.append(" sal.sal_codigo      \t\t\t\t\t\t\t\tAS codigoSalaAtendimento ");
            buf.append(",sal.sal_descricao   \t\t\t\t\t\t\t\tAS descricaoSalaAtendimento ");
            buf.append(",exa.exa_codigo      \t\t\t\t\t\t\t\tAS codigoExame ");
            buf.append(",exa.exa_descricao   \t\t\t\t\t\t\t\tAS descricaoExame ");
            buf.append(",mco.mco_codigo      \t\t\t\t\t\t\t  AS codigoMaterial ");
            buf.append(",mco.mco_abreviatura \t\t\t\t\t\t\t\tAS abreviaturaMaterial ");
            buf.append(",mco.mco_descricao   \t\t\t\t\t\t\t\tAS descricaoMaterial ");
            buf.append(",cast(a.agd_datahoraagenda as date) AS dataAgenda ");
            buf.append(", SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, true, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append("))");
            buf.append(" as valorTotalExameRequisicao ");
            buf.append(",count(1)            \t\t\t\t\t\t\t\tAS qtdeExame, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("FROM agendamento a ");
            buf.append("JOIN salaatendimento sal ON a.fil_codigo = sal.fil_codigo AND sal.sal_codigo = a.sal_codigo ");
            buf.append("JOIN requisicao req ON a.fil_codigo = req.fil_codigo AND a.req_codigo = req.req_codigo ");
            buf.append("LEFT JOIN examerequisicao exr ON a.fil_codigo = exr.fil_codigo AND req.req_codigo = exr.req_codigo ");
            buf.append("LEFT JOIN convenios con ON a.fil_codigo = con.fil_codigo AND req.con_codigo = con.con_codigo ");
            buf.append("LEFT JOIN materialcoleta mco ON a.fil_codigo = mco.fil_codigo AND exr.mco_codigo = mco.mco_codigo ");
            buf.append("LEFT JOIN exames exa ON a.fil_codigo = exa.fil_codigo AND exr.exa_codigo = exa.exa_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] sala = this.getSelecionadosFiltro("filtroSala", 0);
            if (sala != null) {
                buf.append(" AND sal.sal_codigo in (");
                for (int i = 0; i < sala.length; ++i) {
                    buf.append(sala[i]);
                    if (i >= sala.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((exame = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" AND exa.exa_codigo in (");
                for (int i = 0; i < exame.length; ++i) {
                    buf.append("'");
                    buf.append(exame[i]);
                    buf.append("'");
                    if (i >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" AND cast(a.agd_datahoraagenda as date) >= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" AND cast(a.agd_datahoraagenda as date) <= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal"))).append("'");
            }
            buf.append(" AND a.agd_situacao <> '").append("C").append("' ");
            buf.append(" AND not exr.exr_excluido ");
            buf.append("GROUP BY  sal.sal_codigo ");
            buf.append("         ,sal.sal_descricao ");
            buf.append("   \t\t\t ,exa.exa_codigo ");
            buf.append("         ,exa.exa_descricao ");
            buf.append("         ,mco.mco_codigo ");
            buf.append("         ,mco.mco_abreviatura");
            buf.append("         ,mco.mco_descricao ");
            buf.append("         ,cast(a.agd_datahoraagenda as date), ");
            buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
            buf.append("ORDER BY sal.sal_codigo, ");
            buf.append("         cast(a.agd_datahoraagenda as date), ");
            buf.append("         exa.exa_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equalsIgnoreCase("valorTotalExameRequisicao")) {
                            BigDecimal valor = new BigDecimal(0);
                            o[i] = valor.add(rs.getBigDecimal(this.campos[i]) == null ? BigDecimal.ZERO : rs.getBigDecimal(this.campos[i])).setScale(2, RoundingMode.HALF_UP);
                            continue;
                        }
                        o[i] = this.colunaExiste(rs, this.campos[i]) ? rs.getObject(this.campos[i]) : null;
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesAgendados.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesAgendados.this.panelCentro.removeAll();
                            RelatorioExamesAgendados.this.panelCentro.repaint();
                            RelatorioExamesAgendados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (sala != null) {
                        for (int i = 0; i < sala.length; ++i) {
                            buf.append(sala[i]);
                            if (i >= sala.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSala", buf.toString());
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        for (int i = 0; i < exame.length; ++i) {
                            buf.append(exame[i]);
                            if (i >= exame.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExame", buf.toString());
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean colunaExiste(ResultSet rs, String campo) {
        try {
            return rs.findColumn(campo) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

