/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAgendamento
extends FrmRelPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_BAIRRO = "filtroBairro";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_SALA = "filtroSala";
    private final String FILTRO_DATA_HORA_AGENDA = "filtroDataHoraAgenda";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    public static final int TIPO_AGENDAMENTO = 1;
    public static final int TIPO_AGENDAMENTO_COLETA = 2;
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoAgendamento("A"), Tipos.tipoSituacaoAgendamento("C"), Tipos.tipoSituacaoAgendamento("T"), Tipos.tipoSituacaoAgendamento("F"), Tipos.tipoSituacaoAgendamento("R")};
    private final String[] ordem = new String[]{"Requisi\u00e7\u00e3o", "Paciente", "Conv\u00eanio", "M\u00e9dico", "Data/Hora"};
    private final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"numeroEnderecoConvenio", "numeroEnderecoMedico", "tipoLogradouroCobrancaPaciente", "tipoLogradouroMedico", "tipoLogradouroConvenio", "tipoLogradouroPaciente", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "sexoPaciente", "dataNascimentoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorRhPaciente", "fatorDuPaciente", "corPaciente", "observacaoPaciente", "dadoClinicoPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "emailPaciente", "anoMesIdadePaciente", "idadePaciente", "foneContatoPaciente", "idadePaciente", "maePaciente", "paiPaciente", "malaDiretaPaciente", "senhaWebPaciente", "codigoCidade", "descricaoCidade", "estadoCidade", "codigoBairro", "descricaoBairro", "pontoReferenciaPaciente", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "percentualAcrescimoConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "razaoSocialEmpresa", "cnpjEmpresa", "ieEmpresa", "proprietarioAnimal", "sifEmpresa", "enderecoCobrancaPaciente", "complementoCobranca", "cepCobranca", "foneCobranca", "responsavelCobranca", "codigoEspecieAnimal", "descricaoEspecieAnimal", "codigoRacaAnimal", "descricaoRacaAnimal", "pelagemAnimal", "codigoAgendamentoFilial", "codigoAgendamento", "dataHoraAgendamento", "dataHoraCadastroAgendamento", "usuarioCancelamentoAgendamento", "situacaoAgendamento", "codigoSalaAtendimento", "dataHoraCancelamentoAgendamento", "observacaoAgendamento", "codigoRequisicaoAgendamento", "dataAgendamento", "horaAgendamento", "descricaoSalaAtendimento", "codigoMaterial", "abreviaturaMaterial", "descricaoMaterial", "codigoExame", "descricaoExame", "valorTotalExameRequisicao", "generoPaciente"});
    private int tipoRelatorio = 1;

    public RelatorioAgendamento(int tipoRelatorio) {
        this.setName("RelatorioAgendamento");
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de agendamento", "Listagem dos agendamentos", "relatorios/rel_agendamento.jpg");
        } else if (this.tipoRelatorio == 2) {
            this.montaBarraDescricao("Relat\u00f3rio de agendamento em coleta", "Listagem dos agendamentos em coleta", "relatorios/rel_agendamento_coleta.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Cons.", "C\u00f3digo", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroBairro", "Bairro", "bairro", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSala", "Sala", "salaatendimento", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sal_codigo", "sal_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data Final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora Inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora Final:");
        if (tipoRelatorio == 1) {
            this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0);
        }
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de Hora", false);
        this.setModuloConfigurar(RelatorioAgendamento.getModuloConfigurar(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioAgendamento.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        boolean intervaloHora = this.getFiltroCheck("filtroIntervaloHora");
        if (intervaloHora && (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial")) || Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) || Funcoes.textoVazio(this.getFiltroData("filtroHoraInicial")) || Funcoes.textoVazio(this.getFiltroData("filtroHoraFinal")))) {
            Funcoes.mensagem(this, "Os filtros de DATAS/HORAS devem ser preenchido.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] bairro;
            String[] cidade;
            String[] convenio;
            String[] paciente;
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("SELECT a.fil_codigo AS codigoAgendamentoFilial, ");
            buf.append("a.agd_codigo               AS codigoAgendamento, ");
            buf.append("a.agd_datahoraagenda AS dataHoraAgendamento, ");
            buf.append("date_trunc('day', a.agd_datahoraagenda) AS dataAgendamento, ");
            buf.append("cast(extract(hour from a.agd_datahoraagenda) || ':' || extract(minute from a.agd_datahoraagenda) as time) AS horaAgendamento, ");
            buf.append("a.agd_datahora             AS dataHoraCadastroAgendamento, ");
            buf.append("a.usr_codigo               AS usuarioAgendamento, ");
            buf.append("a.usr_codcancelamento      AS usuarioCancelamentoAgendamento, ");
            buf.append("a.agd_situacao             AS situacaoAgendamento, ");
            buf.append("a.sal_codigo               AS codigoSalaAtendimento, ");
            buf.append("a.agd_datahoracancelamento AS dataHoraCancelamentoAgendamento, ");
            buf.append("a.agd_observacao           AS observacaoAgendamento, ");
            buf.append("a.req_codigo               AS codigoRequisicaoAgendamento, ");
            buf.append("sal.sal_descricao          AS descricaoSalaAtendimento, ");
            buf.append("exa.exa_codigo    AS codigoExame, ");
            buf.append("exa.exa_descricao AS descricaoExame, ");
            buf.append("calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, true, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(")");
            buf.append(" as valorTotalExameRequisicao, ");
            buf.append("mco.mco_codigo      AS codigoMaterial, ");
            buf.append("mco.mco_abreviatura AS abreviaturaMaterial, ");
            buf.append("mco.mco_descricao   AS descricaoMaterial, ");
            buf.append("pac.pac_codigo        AS codigoPaciente, ");
            buf.append("pac.pac_nome          AS nomePaciente, ");
            buf.append("pac.pac_nomesocial    AS nomeSocialPaciente, ");
            buf.append("pac.pac_sexo          AS sexoPaciente, ");
            buf.append("pac.pac_datanasc      AS dataNascimentoPaciente, ");
            buf.append("pac.pac_vip           AS vipPaciente, ");
            buf.append("pac.pac_grpsangue     AS grupoSanguineoPaciente, ");
            buf.append("pac.pac_fatorrh       AS fatorRhPaciente, ");
            buf.append("pac.pac_fatordu       AS fatorDuPaciente, ");
            buf.append("pac.pac_cor           AS corPaciente, ");
            buf.append("pac.pac_observ        AS observacaoPaciente, ");
            buf.append("pac.pac_dadoclinico   AS dadoClinicoPaciente, ");
            buf.append("pac.pac_peso          AS pesoPaciente, ");
            buf.append("pac.pac_altura        AS alturaPaciente, ");
            buf.append("pac.pac_matricconv    AS matriculaConvenioPaciente, ");
            buf.append("pac.pac_titularconv   AS titularConvenioPaciente, ");
            buf.append("pac.pac_profissao     AS profissaoPaciente, ");
            buf.append("pac.pac_fumante       AS fumantePaciente, ");
            buf.append("pac.pac_diabetico     AS diabeticoPaciente, ");
            buf.append("pac.pac_rg            AS rgPaciente, ");
            buf.append("pac.pac_cpf           AS cpfPaciente, ");
            buf.append("pac.pac_estcivil      AS estadoCivilPaciente, ");
            buf.append("pac.pac_numfilho      AS numeroFilhosPaciente, ");
            buf.append("pac.pac_datahora      AS dataHoraPaciente, ");
            buf.append("pac.pac_dum           AS dumPaciente, ");
            buf.append("pac.pac_fax           AS faxPaciente, ");
            buf.append("pac.pac_celular       AS celularPaciente, ");
            buf.append("pac.pac_fonecomercial AS foneComercialPaciente, ");
            buf.append("pac.pac_fone          AS fonePaciente, ");
            buf.append("pac.pac_cep           AS cepPaciente, ");
            buf.append("pac.pac_complemento   AS complementoPaciente, ");
            buf.append("pac.pac_endereco      AS enderecoPaciente, ");
            buf.append("pac.pac_tipologradouroendereco AS tipoLogradouroPaciente, ");
            buf.append("pac.pac_numeroendereco AS numeroEnderecoPaciente, ");
            buf.append("pac.pac_pontoreferencia AS pontoReferenciaPaciente, ");
            buf.append("pac.pac_email         AS emailPaciente, ");
            buf.append("pac.pac_anomes        AS anoMesIdadePaciente, ");
            buf.append("pac.pac_idade         AS idadePaciente, ");
            buf.append("pac.pac_fonecontato   AS foneContatoPaciente, ");
            buf.append("pac.pac_idade         AS idadePaciente, ");
            buf.append("pac.pac_mae           AS maePaciente, ");
            buf.append("pac.pac_pai           AS paiPaciente, ");
            buf.append("pac.pac_maladireta    AS malaDiretaPaciente, ");
            buf.append("pac.pac_senhaweb      AS senhaWebPaciente, ");
            buf.append("pac.cid_codigocobranca      AS codigoCidadeCobranca, ");
            buf.append("pac.bai_codigocobranca      AS codigoBairroCobranca, ");
            buf.append("pac.pac_razaosocial         AS razaoSocialEmpresa, ");
            buf.append("pac.pac_cnpj                AS cnpjEmpresa, ");
            buf.append("pac.pac_ie                  AS ieEmpresa, ");
            buf.append("pac.pac_proprietario        AS proprietarioAnimal, ");
            buf.append("pac.pac_sif                 AS sifEmpresa, ");
            buf.append("pac.pac_tipologradouroendcobranca  AS tipoLogradouroCobrancaPaciente, ");
            buf.append("pac.pac_enderecocobranca    AS enderecoCobrancaPaciente, ");
            buf.append("pac.pac_numeroenderecocobranca AS numeroEnderecoCobrancaPaciente, ");
            buf.append("pac.pac_complementocobranca AS complementoCobranca, ");
            buf.append("pac.pac_cepcobranca         AS cepCobranca, ");
            buf.append("pac.pac_fonecobranca        AS foneCobranca, ");
            buf.append("pac.pac_responsavelcobranca AS responsavelCobranca, ");
            buf.append("pac.epc_codigo    AS codigoEspecieAnimal, ");
            buf.append("esp.epc_descricao AS descricaoEspecieAnimal, ");
            buf.append("pac.rac_codigo    AS codigoRacaAnimal, ");
            buf.append("rac.rac_descricao AS descricaoRacaAnimal, ");
            buf.append("pac.pac_pelagem   AS pelagemAnimal, ");
            buf.append("con.con_codigo        AS codigoConvenio, ");
            buf.append("con.con_razao         AS razaoSocialConvenio, ");
            buf.append("con.con_fantasia      AS fantasiaConvenio, ");
            buf.append("con.con_cnpjcpf       AS cnpjConvenio, ");
            buf.append("con.con_tppgto        AS tipoPagamentoConvenio, ");
            buf.append("con.con_fatfmaterial  AS faturarFaltaMaterialConvenio, ");
            buf.append("con.con_descexame     AS habilitarDescontoConvenio, ");
            buf.append("con.con_multa         AS multaConvenio, ");
            buf.append("con.con_mora          AS moraConvenio, ");
            buf.append("con.con_fatfiliais    AS faturarFiliaisConvenio, ");
            buf.append("con.con_nr1via        AS quantidade1ViaConvenio, ");
            buf.append("con.con_nrexames      AS numeroExamesConvenio, ");
            buf.append("con.con_viasfatura    AS viasFaturaConvenio, ");
            buf.append("con.con_impbloqueto   AS imprimirBloquetoConvenio, ");
            buf.append("con.con_nr2via        AS quantidade2ViaConvenio, ");
            buf.append("con.con_tpcalcfatu    AS tipoCalculoFaturaConvenio, ");
            buf.append("con.con_percpgto      AS percentualBalcaoConvenio, ");
            buf.append("con.con_cobrexame     AS cobrarExameBalcaoConvenio, ");
            buf.append("con.con_inscrest      AS inscricaoEstadualConvenio, ");
            buf.append("con.con_titdep        AS titularDependenteConvenio, ");
            buf.append("con.con_maskcart      AS mascaraCarteiraConvenio, ");
            buf.append("con.con_contato       AS contatoConvenio, ");
            buf.append("con.con_informarmat   AS obrigaMatriculaConvenio, ");
            buf.append("con.con_cep           AS cepConvenio, ");
            buf.append("con.con_complemento   AS complementoConvenio, ");
            buf.append("con.con_endereco      AS enderecoConvenio, ");
            buf.append("con.con_numeroendereco  AS numeroEnderecoConvenio, ");
            buf.append("con.con_tipologradouroendereco AS tipoLogradouroConvenio, ");
            buf.append("con.con_cepcobranca   AS cepCobrancaConvenio, ");
            buf.append("con.con_complcobranca AS complementoCobrancaConvenio, ");
            buf.append("con.con_endcobranca   AS enderecoCobrancaConvenio, ");
            buf.append("con.con_fax           AS faxConvenio, ");
            buf.append("con.con_fone          AS foneConvenio, ");
            buf.append("con.con_valorfilme    AS valorFilmeConvenio, ");
            buf.append("con.con_valorch       AS valorChConvenio, ");
            buf.append("con.con_site          AS siteConvenio, ");
            buf.append("con.con_email2        AS email2Convenio, ");
            buf.append("con.con_email1        AS email1Convenio, ");
            buf.append("con.con_tpcalcch      AS tipoCalculoChConvenio, ");
            buf.append("con.con_inscmunic     AS inscricaoMunicipalConvenio, ");
            buf.append("con.con_bonus         AS percentualBonusConvenio, ");
            buf.append("con.con_acrescimo     AS percentualAcrescimoConvenio, ");
            buf.append("con.con_senhaweb      AS senhaWebConvenio, ");
            buf.append("con.con_proibidoweb   AS proibidoWebConvenio, ");
            buf.append("con.con_validadeguia  AS obrigaValidadeGuiaConvenio, ");
            buf.append("con.con_codigoguia    AS obrigaGuiaConvenio, ");
            buf.append("con.con_diasvalidade  AS diasValidadeGuia, ");
            buf.append("con.con_ordemfatura   AS ordemFaturaConvenio, ");
            buf.append("con.con_cobrmaterial  AS cobrarMateriaisConvenio, ");
            buf.append("med.med_conselho    AS conselhoMedico, ");
            buf.append("med.med_crm         AS crmMedico, ");
            buf.append("med.cid_codigo      AS codigoCidadeMedico, ");
            buf.append("med.med_uf          AS ufMedico, ");
            buf.append("med.med_nome        AS nomeMedico, ");
            buf.append("med.med_abrev       AS abreviaturaMedico, ");
            buf.append("med.med_tipo        AS tipoMedico, ");
            buf.append("med.med_comissao    AS comissaoMedico, ");
            buf.append("med.med_cep         AS cepMedico, ");
            buf.append("med.med_complemento AS complementoMedico, ");
            buf.append("med.med_endereco    AS enderecoMedico, ");
            buf.append("med.med_numeroendereco AS numeroEnderecoMedico, ");
            buf.append("med.med_tipologradouroendereco AS tipoLogradouroMedico, ");
            buf.append("med.med_celular     AS celularMedico, ");
            buf.append("med.med_fax         AS faxMedico, ");
            buf.append("med.med_fone        AS foneMedico, ");
            buf.append("med.bai_codigo      AS codigoBairroMedico, ");
            buf.append("med.med_email       AS emailMedico, ");
            buf.append("med.med_site        AS siteMedico, ");
            buf.append("med.med_senhaweb    AS senhaWebMedico, ");
            buf.append("cid.cid_codigo AS codigoCidade, ");
            buf.append("cid.cid_nome   AS descricaoCidade, ");
            buf.append("cid.cid_uf     AS estadoCidade, ");
            buf.append("bai.bai_codigo    AS codigoBairro, ");
            buf.append("bai.bai_descricao AS descricaoBairro, ");
            buf.append("idg.ige_descricao as generoPaciente, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("FROM agendamento a ");
            buf.append("JOIN salaatendimento sal ON a.fil_codigo = sal.fil_codigo AND sal.sal_codigo = a.sal_codigo ");
            buf.append("JOIN requisicao req ON a.fil_codigo = req.fil_codigo AND a.req_codigo = req.req_codigo ");
            buf.append("LEFT JOIN orcamento orc ON a.fil_codigo = orc.fil_codigo AND req.orc_codigo = orc.orc_codigo ");
            buf.append("LEFT JOIN medico med ON req.fil_codigo = med.fil_codigo AND req.med_crm = med.med_crm AND req.med_uf = med.med_uf AND req.med_conselho = med.med_conselho ");
            buf.append("LEFT JOIN convenios con ON a.fil_codigo = con.fil_codigo AND req.con_codigo = con.con_codigo ");
            buf.append("LEFT JOIN paciente pac ON req.fil_codigo = pac.fil_codigo AND req.pac_codigo = pac.pac_codigo ");
            buf.append("LEFT JOIN especie esp ON a.fil_codigo = esp.fil_codigo AND pac.epc_codigo = esp.epc_codigo ");
            buf.append("LEFT JOIN raca rac ON a.fil_codigo = rac.fil_codigo AND pac.rac_codigo = rac.rac_codigo ");
            buf.append("LEFT JOIN cidades cid ON a.fil_codigo = cid.fil_codigo AND pac.cid_codigo = cid.cid_codigo ");
            buf.append("LEFT JOIN bairro bai ON a.fil_codigo = bai.fil_codigo AND pac.bai_codigo = bai.bai_codigo ");
            buf.append("LEFT JOIN examerequisicao exr ON a.fil_codigo = exr.fil_codigo AND req.req_codigo = exr.req_codigo ");
            buf.append("LEFT JOIN materialcoleta mco ON a.fil_codigo = mco.fil_codigo AND exr.mco_codigo = mco.mco_codigo ");
            buf.append("LEFT JOIN exames exa ON a.fil_codigo = exa.fil_codigo AND exr.exa_codigo = exa.exa_codigo ");
            buf.append("LEFT JOIN identidadegenero idg on coalesce(pac.pac_genero, 0) = idg.ige_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] sala = this.getSelecionadosFiltro("filtroSala", 0);
            if (sala != null) {
                buf.append(" AND sal.sal_codigo in (");
                for (int i = 0; i < sala.length; ++i) {
                    buf.append(sala[i]);
                    if (i >= sala.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                buf.append(" AND pac.pac_codigo in (");
                for (int i = 0; i < paciente.length; ++i) {
                    buf.append(paciente[i]);
                    if (i >= paciente.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" AND con.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] medico = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] medicoUf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (medico != null && medico.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < medico.length; ++i) {
                    buf.append("(med.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and med.med_crm = '");
                    buf.append(medico[i]);
                    buf.append("' and med.med_uf = '");
                    buf.append(medicoUf[i]);
                    buf.append("') ");
                    if (i >= medico.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(") ");
            }
            if ((cidade = this.getSelecionadosFiltro("filtroCidade", 0)) != null) {
                buf.append(" AND pac.cid_codigo in (");
                for (int i = 0; i < cidade.length; ++i) {
                    buf.append(cidade[i]);
                    if (i >= cidade.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((bairro = this.getSelecionadosFiltro("filtroBairro", 0)) != null) {
                buf.append(" AND pac.bai_codigo in ('");
                for (int i = 0; i < bairro.length; ++i) {
                    buf.append(bairro[i]);
                    if (i >= bairro.length - 1) continue;
                    buf.append("', '");
                }
                buf.append("') ");
            }
            String s = this.getFiltroCombo("filtroSituacao").toString();
            if (this.tipoRelatorio == 1) {
                if (s.equals(this.situacao[0])) {
                    buf.append(" AND a.agd_situacao <> '").append("R").append("' ");
                } else if (s.equals(this.situacao[1])) {
                    buf.append(" AND a.agd_situacao = '").append("A").append("' ");
                } else if (s.equals(this.situacao[2])) {
                    buf.append(" AND a.agd_situacao = '").append("C").append("' ");
                } else if (s.equals(this.situacao[3])) {
                    buf.append(" AND a.agd_situacao = '").append("T").append("' ");
                } else if (s.equals(this.situacao[4])) {
                    buf.append(" AND a.agd_situacao = '").append("F").append("' ");
                } else if (s.equals(this.situacao[5])) {
                    buf.append(" AND a.agd_situacao = '").append("R").append("' ");
                }
            } else if (this.tipoRelatorio == 2) {
                buf.append(" AND a.agd_situacao = '").append("T").append("' ");
            }
            if (intervaloHora) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute', a.agd_datahoraagenda) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append(" ").append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute', a.agd_datahoraagenda) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append(" ").append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" AND cast(a.agd_datahoraagenda as date) >= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" AND cast(a.agd_datahoraagenda as date) <= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal"))).append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" AND cast(a.agd_datahoraagenda as time) >= '").append(this.getFiltroHora("filtroHoraInicial")).append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" AND cast(a.agd_datahoraagenda as time) <= '").append(this.getFiltroHora("filtroHoraFinal")).append("'");
                }
            }
            buf.append(" ORDER BY sal.sal_descricao, dataHoraAgendamento, nomePaciente, exr.exa_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equals("anoMesIdadePaciente")) {
                            o[i] = Tipos.tipoIdade(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || this.campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroMedico") || this.campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("anoMesIdadePaciente")) {
                            o[i] = Tipos.tipoSexo(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("corPaciente")) {
                            o[i] = Tipos.tipoCor(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("estadoCivilPaciente")) {
                            o[i] = Tipos.tipoEstadoCivil(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("fumantePaciente")) {
                            o[i] = Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente"));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("diabeticoPaciente")) {
                            o[i] = Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente"));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("situacaoAgendamento")) {
                            o[i] = Tipos.tipoSituacaoAgendamento(rs.getString("situacaoAgendamento"));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("valorTotalExameRequisicao")) {
                            BigDecimal valor = new BigDecimal(0);
                            o[i] = valor.add(rs.getBigDecimal(this.campos[i]) == null ? BigDecimal.ZERO : rs.getBigDecimal(this.campos[i])).setScale(2, RoundingMode.HALF_UP);
                            continue;
                        }
                        o[i] = this.colunaExiste(rs, this.campos[i]) ? rs.getObject(this.campos[i]) : null;
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAgendamento.getModuloAcesso(this.tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAgendamento.this.panelCentro.removeAll();
                            RelatorioAgendamento.this.panelCentro.repaint();
                            RelatorioAgendamento.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (paciente != null) {
                        for (int i = 0; i < paciente.length; ++i) {
                            buf.append(paciente[i]);
                            if (i >= paciente.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroPaciente", buf.toString());
                    buf.delete(0, buf.length());
                    if (sala != null) {
                        for (int i = 0; i < sala.length; ++i) {
                            buf.append(sala[i]);
                            if (i >= sala.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSala", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (int i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (medico != null) {
                        for (int i = 0; i < medico.length; ++i) {
                            buf.append(medico[i]);
                            if (i >= medico.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (cidade != null) {
                        for (int i = 0; i < cidade.length; ++i) {
                            buf.append(cidade[i]);
                            if (i >= cidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (bairro != null) {
                        for (int i = 0; i < bairro.length; ++i) {
                            buf.append(bairro[i]);
                            if (i >= bairro.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroBairro", buf.toString());
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    if (this.tipoRelatorio == 1) {
                        var.put("filtroSituacao", s);
                    }
                    var.put("filtroIntervaloHora", this.getFiltroCheck("filtroIntervaloHora") ? "Sim" : "N\u00e3o");
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean colunaExiste(ResultSet rs, String campo) {
        try {
            return rs.findColumn(campo) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 2) {
            return Long.parseLong("0823500200");
        }
        return Long.parseLong("0823500100");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 2) {
            return Long.parseLong("0823500201");
        }
        return Long.parseLong("0823500101");
    }
}

